/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.function.Function;

final class FieldWriterBigDecimalFunc<T>
extends FieldWriterImpl<T> {
    final Method method;
    final Function<T, BigDecimal> function;

    protected FieldWriterBigDecimalFunc(String fieldName, int ordinal, long features, Method method, Function<T, BigDecimal> function) {
        super(fieldName, ordinal, features, null, (Type)((Object)BigDecimal.class), BigDecimal.class);
        this.method = method;
        this.function = function;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.function.apply(object);
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        BigDecimal value = this.function.apply(object);
        jsonWriter.writeDecimal(value);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        BigDecimal value;
        try {
            value = this.function.apply(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.WriteNulls.mask) == 0L) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        jsonWriter.writeDecimal(value);
        return true;
    }
}

