/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import com.alibaba.fastjson2.writer.ObjectWriterImplListEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplListStr;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.List;

abstract class FieldWriterList<T>
extends FieldWriterImpl<T> {
    final Type itemType;
    final Class itemClass;
    ObjectWriter listWriter;
    ObjectWriter itemObjectWriter;

    FieldWriterList(String name, Type itemType, int ordinal, long features, String format, Type fieldType, Class fieldClass) {
        super(name, ordinal, features, format, fieldType, fieldClass);
        Object object = this.itemType = itemType == null ? Object.class : itemType;
        if (this.itemType instanceof Class) {
            this.itemClass = (Class)itemType;
            if (this.itemClass != null) {
                this.listWriter = Enum.class.isAssignableFrom(this.itemClass) ? new ObjectWriterImplListEnum(fieldClass, this.itemClass, features) : (this.itemClass == String.class ? ObjectWriterImplListStr.INSTANCE : new ObjectWriterImplList(fieldClass, fieldType, this.itemClass, itemType, features));
            }
        } else {
            this.itemClass = TypeUtils.getMapping(itemType);
        }
        if (format != null && this.itemClass == Date.class) {
            switch (format) {
                case "unixtime": {
                    this.itemObjectWriter = ObjectWriterImplDate.INSTANCE_UNIXTIME;
                }
            }
            this.itemObjectWriter = new ObjectWriterImplDate(format);
        }
    }

    @Override
    public Type getItemType() {
        return this.itemType;
    }

    @Override
    public Class getItemClass() {
        return this.itemClass;
    }

    @Override
    public ObjectWriter getItemWriter(JSONWriter jsonWriter, Type itemType) {
        if (itemType == null || itemType == this.itemType) {
            if (this.itemObjectWriter != null) {
                return this.itemObjectWriter;
            }
            this.itemObjectWriter = jsonWriter.getObjectWriter(this.itemType, this.itemClass);
            return this.itemObjectWriter;
        }
        return jsonWriter.getObjectWriter(itemType, null);
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (this.listWriter != null) {
            return this.listWriter;
        }
        if (this.listWriter == null && valueClass == this.fieldClass) {
            this.listWriter = jsonWriter.getObjectWriter(valueClass);
            return this.listWriter;
        }
        return jsonWriter.getObjectWriter(valueClass);
    }

    @Override
    public void writeList(JSONWriter jsonWriter, boolean writeFieldName, List list) {
        Class<?> previousClass = null;
        ObjectWriter previousObjectWriter = null;
        if (writeFieldName) {
            this.writeFieldName(jsonWriter);
        }
        boolean refDetect = jsonWriter.isRefDetect();
        boolean beanToArray = jsonWriter.isBeanToArray(this.features);
        if (jsonWriter.isJSONB()) {
            int size = list.size();
            if (jsonWriter.isWriteTypeInfo((Object)list, this.fieldClass)) {
                jsonWriter.writeTypeName(TypeUtils.getTypeName(list.getClass()));
            }
            jsonWriter.startArray(size);
            for (int i = 0; i < size; ++i) {
                String refPath;
                Object item = list.get(i);
                if (item == null) {
                    jsonWriter.writeNull();
                    continue;
                }
                Class<?> itemClass = item.getClass();
                if (itemClass != previousClass) {
                    refDetect = jsonWriter.isRefDetect();
                    previousObjectWriter = this.getItemWriter(jsonWriter, itemClass);
                    previousClass = itemClass;
                    if (refDetect) {
                        refDetect = !ObjectWriterProvider.isNotReferenceDetect(itemClass);
                    }
                }
                ObjectWriter itemObjectWriter = previousObjectWriter;
                if (refDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                    jsonWriter.writeReference(refPath);
                    jsonWriter.popPath(item);
                    continue;
                }
                if (beanToArray) {
                    itemObjectWriter.writeArrayMappingJSONB(jsonWriter, item, i, this.itemType, this.features);
                } else {
                    itemObjectWriter.writeJSONB(jsonWriter, item, i, this.itemType, this.features);
                }
                if (!refDetect) continue;
                jsonWriter.popPath(item);
            }
            return;
        }
        jsonWriter.startArray();
        for (int i = 0; i < list.size(); ++i) {
            String refPath;
            ObjectWriter itemObjectWriter;
            Object item;
            if (i != 0) {
                jsonWriter.writeComma();
            }
            if ((item = list.get(i)) == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> itemClass = item.getClass();
            if (itemClass == previousClass) {
                itemObjectWriter = previousObjectWriter;
            } else {
                itemObjectWriter = this.getItemWriter(jsonWriter, itemClass);
                previousClass = itemClass;
                previousObjectWriter = itemObjectWriter;
            }
            if (refDetect && (refPath = jsonWriter.setPath(i, item)) != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(item);
                continue;
            }
            itemObjectWriter.write(jsonWriter, item, null, this.itemType, this.features);
            if (!refDetect) continue;
            jsonWriter.popPath(item);
        }
        jsonWriter.endArray();
    }

    @Override
    public void writeListStr(JSONWriter jsonWriter, boolean writeFieldName, List<String> list) {
        if (writeFieldName) {
            this.writeFieldName(jsonWriter);
        }
        if (jsonWriter.isJSONB()) {
            int listSize = list.size();
            jsonWriter.startArray(listSize);
            int size = listSize;
            for (int i = 0; i < size; ++i) {
                String str = list.get(i);
                jsonWriter.writeString(str);
            }
            return;
        }
        jsonWriter.startArray();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                jsonWriter.writeComma();
            }
            String str = list.get(i);
            jsonWriter.writeString(str);
        }
        jsonWriter.endArray();
    }
}

