/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.modules.ObjectWriterModule;
import com.alibaba.fastjson2.util.GuavaSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterCreatorLambda;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Currency;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ObjectWriterProvider {
    final ConcurrentMap<Type, ObjectWriter> cache = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Type, ObjectWriter> cacheFieldBased = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final ObjectWriterCreator creator;
    final List<ObjectWriterModule> modules = new ArrayList<ObjectWriterModule>();
    static final int ENUM = 16384;
    static final int[] PRIMITIVE_HASH_CODES;
    static final int[] NOT_REFERENCES_TYPE_HASH_CODES;

    public ObjectWriterProvider() {
        this.init();
        switch (JSONFactory.CREATOR) {
            case "reflect": {
                this.creator = ObjectWriterCreator.INSTANCE;
                break;
            }
            default: {
                this.creator = ObjectWriterCreatorLambda.INSTANCE;
            }
        }
    }

    public ObjectWriterProvider(ObjectWriterCreator creator) {
        this.init();
        this.creator = creator;
    }

    public void mixIn(Class target, Class mixinSource) {
        this.mixInCache.put(target, mixinSource);
        this.cache.remove(target);
    }

    public ObjectWriterCreator getCreator() {
        ObjectWriterCreator contextCreator = JSONFactory.getContextWriterCreator();
        if (contextCreator != null) {
            return contextCreator;
        }
        return this.creator;
    }

    public boolean register(Type type, ObjectWriter objectWriter) {
        return this.cache.put(type, objectWriter) == null;
    }

    public boolean register(ObjectWriterModule module) {
        for (int i = this.modules.size() - 1; i >= 0; --i) {
            if (this.modules.get(i) != module) continue;
            return false;
        }
        module.init(this);
        this.modules.add(0, module);
        return true;
    }

    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void init() {
        this.modules.add(new ObjectWriterBaseModule(this));
    }

    public List<ObjectWriterModule> getModules() {
        return this.modules;
    }

    public ObjectWriter getObjectWriter(Class objectClass) {
        return this.getObjectWriter(objectClass, objectClass, false);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        return this.getObjectWriter(objectType, objectClass, false);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass, boolean fieldBased) {
        ObjectWriter objectWriter;
        ObjectWriter objectWriter2 = objectWriter = fieldBased ? (ObjectWriter)this.cacheFieldBased.get(objectType) : (ObjectWriter)this.cache.get(objectType);
        if (objectWriter != null) {
            return objectWriter;
        }
        boolean useModules = true;
        if (fieldBased && objectClass != null && Iterable.class.isAssignableFrom(objectClass) && !Collection.class.isAssignableFrom(objectClass)) {
            useModules = false;
        }
        if (useModules) {
            for (int i = 0; i < this.modules.size(); ++i) {
                ObjectWriter previous;
                Object module = this.modules.get(i);
                objectWriter = module.getObjectWriter(objectType, objectClass);
                if (objectWriter == null) continue;
                ObjectWriter objectWriter3 = previous = fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, objectWriter) : this.cache.putIfAbsent(objectType, objectWriter);
                if (previous != null) {
                    objectWriter = previous;
                }
                return objectWriter;
            }
        }
        if (objectWriter == null && objectClass != null && !fieldBased) {
            String className = objectClass.getName();
            switch (className) {
                case "com.google.common.collect.HashMultimap": 
                case "com.google.common.collect.LinkedListMultimap": 
                case "com.google.common.collect.LinkedHashMultimap": 
                case "com.google.common.collect.ArrayListMultimap": 
                case "com.google.common.collect.TreeMultimap": {
                    objectWriter = GuavaSupport.createAsMapWriter(objectClass);
                    break;
                }
                case "com.alibaba.fastjson.JSONObject": {
                    objectWriter = ObjectWriterImplMap.of(objectClass);
                    break;
                }
            }
        }
        if (objectWriter == null) {
            ObjectWriter previous;
            ObjectWriterCreator creator = this.getCreator();
            if (objectClass == null) {
                objectClass = TypeUtils.getMapping(objectType);
            }
            objectWriter = creator.createObjectWriter(objectClass, fieldBased ? JSONWriter.Feature.FieldBased.mask : 0L, this.modules);
            ObjectWriter objectWriter4 = previous = fieldBased ? this.cacheFieldBased.putIfAbsent(objectType, objectWriter) : this.cache.putIfAbsent(objectType, objectWriter);
            if (previous != null) {
                objectWriter = previous;
            }
        }
        return objectWriter;
    }

    public static boolean isPrimitiveOrEnum(Class<?> clazz) {
        return Arrays.binarySearch(PRIMITIVE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    public static boolean isNotReferenceDetect(Class<?> clazz) {
        return Arrays.binarySearch(NOT_REFERENCES_TYPE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    static {
        Class[] classes = new Class[]{Boolean.TYPE, Boolean.class, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigInteger.class, BigDecimal.class, String.class, Currency.class, Date.class, UUID.class, Locale.class, LocalTime.class, LocalDate.class, LocalDateTime.class, Instant.class, ZoneId.class, ZonedDateTime.class, OffsetDateTime.class, OffsetTime.class, String.class};
        int[] codes = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            codes[i] = System.identityHashCode(classes[i]);
        }
        Arrays.sort(codes);
        PRIMITIVE_HASH_CODES = codes;
        int[] codes2 = Arrays.copyOf(codes, codes.length + 3);
        codes2[codes2.length - 1] = System.identityHashCode(Class.class);
        codes2[codes2.length - 2] = System.identityHashCode(int[].class);
        codes2[codes2.length - 3] = System.identityHashCode(long[].class);
        Arrays.sort(codes2);
        NOT_REFERENCES_TYPE_HASH_CODES = codes2;
    }
}

