/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.util.IOUtils;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;

final class JSONPathSegmentIndex
extends JSONPathSegment {
    static final JSONPathSegmentIndex ZERO = new JSONPathSegmentIndex(0);
    static final JSONPathSegmentIndex ONE = new JSONPathSegmentIndex(1);
    static final JSONPathSegmentIndex TWO = new JSONPathSegmentIndex(2);
    final int index;

    public JSONPathSegmentIndex(int index) {
        if (index < 0) {
            throw new JSONException("not support negative index");
        }
        this.index = index;
    }

    static JSONPathSegmentIndex of(int index) {
        if (index == 0) {
            return ZERO;
        }
        if (index == 1) {
            return ONE;
        }
        if (index == 2) {
            return TWO;
        }
        return new JSONPathSegmentIndex(index);
    }

    @Override
    public void eval(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object == null) {
            context.eval = true;
            return;
        }
        if (object instanceof List) {
            List list = (List)object;
            if (this.index < list.size()) {
                context.value = list.get(this.index);
            }
            context.eval = true;
            return;
        }
        if (object instanceof SortedSet || object instanceof LinkedHashSet || this.index == 0 && object instanceof Collection && ((Collection)object).size() == 1) {
            Collection collection = (Collection)object;
            int i = 0;
            for (Object item : collection) {
                if (i == this.index) {
                    context.value = item;
                    break;
                }
                ++i;
            }
            context.eval = true;
            return;
        }
        if (object instanceof Object[]) {
            Object[] array = (Object[])object;
            if (this.index < array.length) {
                context.value = array[this.index];
            }
            context.eval = true;
            return;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass.isArray()) {
            int length = Array.getLength(object);
            if (this.index < length) {
                context.value = Array.get(object, this.index);
            }
            context.eval = true;
            return;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            context.value = this.eval((Map)object);
            context.eval = true;
            return;
        }
        if (this.index == 0) {
            context.value = object;
            context.eval = true;
            return;
        }
        throw new JSONException("jsonpath not support operate : " + context.path + ", objectClass" + objectClass.getName());
    }

    private Object eval(Map object) {
        Object value;
        block6: {
            value = object.get(this.index);
            if (value == null) {
                value = object.get(Integer.toString(this.index));
            }
            if (value != null) break block6;
            int size = object.size();
            Iterator it = object.entrySet().iterator();
            if (size == 1 || object instanceof LinkedHashMap || object instanceof SortedMap) {
                for (int i = 0; i <= this.index && i < size && it.hasNext(); ++i) {
                    Map.Entry entry = it.next();
                    Object entryKey = entry.getKey();
                    Object entryValue = entry.getValue();
                    if (entryKey instanceof Long) {
                        if (!entryKey.equals(this.index)) continue;
                        value = entryValue;
                        break;
                    }
                    if (i != this.index) continue;
                    value = entryValue;
                }
            } else {
                for (int i = 0; i <= this.index && i < object.size() && it.hasNext(); ++i) {
                    Map.Entry entry = it.next();
                    Object entryKey = entry.getKey();
                    Object entryValue = entry.getValue();
                    if (!(entryKey instanceof Long) || !entryKey.equals(this.index)) continue;
                    value = entryValue;
                    break;
                }
            }
        }
        return value;
    }

    public String toString() {
        int size = IOUtils.stringSize(this.index);
        byte[] bytes = new byte[size + 2];
        bytes[0] = 91;
        IOUtils.writeInt32(bytes, 1, this.index);
        bytes[bytes.length - 1] = 93;
        return new String(bytes, IOUtils.ISO_8859_1);
    }
}

