/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReaderASCII;
import com.alibaba.fastjson2.JSONReaderJSONB;
import com.alibaba.fastjson2.JSONReaderUTF16;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.ContextAutoTypeBeforeHandler;
import com.alibaba.fastjson2.filter.ExtraProcessor;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.function.BiFunction;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.function.Supplier;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.time.DateTimeException;
import com.alibaba.fastjson2.time.DateTimeFormatter;
import com.alibaba.fastjson2.time.Instant;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.ReferenceKey;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONReader
implements Closeable {
    static final int MAX_EXP = 1023;
    static final byte JSON_TYPE_INT = 1;
    static final byte JSON_TYPE_DEC = 2;
    static final byte JSON_TYPE_STRING = 3;
    static final byte JSON_TYPE_BOOL = 4;
    static final byte JSON_TYPE_NULL = 5;
    static final byte JSON_TYPE_OBJECT = 6;
    static final byte JSON_TYPE_ARRAY = 7;
    static final byte JSON_TYPE_BIG_DEC = 8;
    static final byte JSON_TYPE_INT8 = 9;
    static final byte JSON_TYPE_INT16 = 10;
    static final byte JSON_TYPE_INT64 = 11;
    static final byte JSON_TYPE_FLOAT = 12;
    static final byte JSON_TYPE_DOUBLE = 13;
    static final char EOI = '\u001a';
    static final long SPACE = 4294981376L;
    public final Context context;
    List<ResolveTask> resolveTasks;
    protected int offset;
    protected char ch;
    protected boolean comma;
    protected boolean nameEscape;
    protected boolean valueEscape;
    protected boolean wasNull;
    protected boolean boolValue;
    protected boolean negative;
    protected byte valueType;
    protected short exponent;
    protected byte scale;
    protected int mag0;
    protected int mag1;
    protected int mag2;
    protected int mag3;
    protected int level;
    protected String stringValue;
    protected Object complex;
    protected boolean typeRedirect;
    protected char[] doubleChars;
    public final boolean jsonb;

    public final char current() {
        return this.ch;
    }

    public boolean isEnd() {
        return this.ch == '\u001a';
    }

    public byte getType() {
        return -128;
    }

    public boolean isInt() {
        return this.ch == '-' || this.ch == '+' || this.ch >= '0' && this.ch <= '9';
    }

    public abstract boolean isNull();

    public final boolean hasComma() {
        return this.comma;
    }

    public abstract Date readNullOrNewDate();

    public abstract boolean nextIfNull();

    public JSONReader(Context context, boolean jsonb) {
        this.context = context;
        this.jsonb = jsonb;
    }

    public final Context getContext() {
        return this.context;
    }

    public final void errorOnNoneSerializable(Class objectClass) {
        if ((this.context.features & Feature.ErrorOnNoneSerializable.mask) != 0L && !Serializable.class.isAssignableFrom(objectClass)) {
            throw new JSONException("not support none-Serializable, class " + objectClass.getName());
        }
    }

    public final boolean isEnabled(Feature feature) {
        return (this.context.features & feature.mask) != 0L;
    }

    public final Locale getLocale() {
        return this.context.getLocale();
    }

    public final ZoneId getZoneId() {
        return this.context.getZoneId();
    }

    public final long features(long features) {
        return this.context.features | features;
    }

    public final void handleResolveTasks(Object root) {
        if (this.resolveTasks == null) {
            return;
        }
        Object previous = null;
        for (int i = 0; i < this.resolveTasks.size(); ++i) {
            Object fieldValue;
            ResolveTask resolveTask = this.resolveTasks.get(i);
            JSONPath path = resolveTask.reference;
            FieldReader fieldReader = resolveTask.fieldReader;
            if (path.isPrevious()) {
                fieldValue = previous;
            } else {
                if (!path.isRef()) {
                    throw new JSONException("reference path invalid : " + path);
                }
                path.readerContext = this.context;
                if ((this.context.features & Feature.FieldBased.mask) != 0L) {
                    JSONWriter.Context writeContext = JSONFactory.createWriteContext();
                    writeContext.features |= JSONWriter.Feature.FieldBased.mask;
                    path.writerContext = writeContext;
                }
                previous = fieldValue = path.eval(root);
            }
            Object resolvedName = resolveTask.name;
            Object resolvedObject = resolveTask.object;
            if (resolvedName != null) {
                if (resolvedObject instanceof Map) {
                    Map map = (Map)resolvedObject;
                    if (resolvedName instanceof ReferenceKey) {
                        if (map instanceof LinkedHashMap) {
                            int size = map.size();
                            if (size == 0) continue;
                            Object[] keys = new Object[size];
                            Object[] values = new Object[size];
                            int index = 0;
                            for (Map.Entry o : map.entrySet()) {
                                Map.Entry entry = o;
                                Object entryKey = entry.getKey();
                                keys[index] = resolvedName == entryKey ? fieldValue : entryKey;
                                values[index++] = entry.getValue();
                            }
                            map.clear();
                            for (int j = 0; j < keys.length; ++j) {
                                map.put(keys[j], values[j]);
                            }
                            continue;
                        }
                        map.put(fieldValue, map.remove(resolvedName));
                        continue;
                    }
                    map.put(resolvedName, fieldValue);
                    continue;
                }
                if (resolvedName instanceof Integer) {
                    if (resolvedObject instanceof List) {
                        List list;
                        int index = (Integer)resolvedName;
                        if (index == (list = (List)resolvedObject).size()) {
                            list.add(fieldValue);
                            continue;
                        }
                        list.set(index, fieldValue);
                        continue;
                    }
                    if (resolvedObject instanceof Object[]) {
                        int index = (Integer)resolvedName;
                        Object[] array = (Object[])resolvedObject;
                        array[index] = fieldValue;
                        continue;
                    }
                    if (resolvedObject instanceof Collection) {
                        Collection collection = (Collection)resolvedObject;
                        collection.add(fieldValue);
                        continue;
                    }
                }
            }
            fieldReader.accept(resolvedObject, fieldValue);
        }
    }

    public final ObjectReader getObjectReader(Type type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectReader(type, fieldBased);
    }

    public final boolean isSupportSmartMatch() {
        return (this.context.features & Feature.SupportSmartMatch.mask) != 0L;
    }

    public final boolean isInitStringFieldAsEmpty() {
        return (this.context.features & Feature.InitStringFieldAsEmpty.mask) != 0L;
    }

    public final boolean isSupportSmartMatch(long features) {
        return ((this.context.features | features) & Feature.SupportSmartMatch.mask) != 0L;
    }

    public final boolean isSupportBeanArray() {
        return (this.context.features & Feature.SupportArrayToBean.mask) != 0L;
    }

    public final boolean isSupportBeanArray(long features) {
        return ((this.context.features | features) & Feature.SupportArrayToBean.mask) != 0L;
    }

    public final boolean isSupportAutoType(long features) {
        return ((this.context.features | features) & Feature.SupportAutoType.mask) != 0L;
    }

    public final boolean isSupportAutoTypeOrHandler(long features) {
        return ((this.context.features | features) & Feature.SupportAutoType.mask) != 0L || this.context.autoTypeBeforeHandler != null;
    }

    public final boolean isJSONB() {
        return this.jsonb;
    }

    public ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        return null;
    }

    final char char1(int c) {
        switch (c) {
            case 48: {
                return '\u0000';
            }
            case 49: {
                return '\u0001';
            }
            case 50: {
                return '\u0002';
            }
            case 51: {
                return '\u0003';
            }
            case 52: {
                return '\u0004';
            }
            case 53: {
                return '\u0005';
            }
            case 54: {
                return '\u0006';
            }
            case 55: {
                return '\u0007';
            }
            case 98: {
                return '\b';
            }
            case 116: {
                return '\t';
            }
            case 110: {
                return '\n';
            }
            case 118: {
                return '\u000b';
            }
            case 70: 
            case 102: {
                return '\f';
            }
            case 114: {
                return '\r';
            }
            case 34: 
            case 35: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 46: 
            case 47: 
            case 64: 
            case 91: 
            case 92: 
            case 93: 
            case 95: {
                return (char)c;
            }
        }
        throw new JSONException(this.info("unclosed.str '\\" + (char)c));
    }

    static char char2(int c1, int c2) {
        return (char)(JSONFactory.DIGITS2[c1] * 16 + JSONFactory.DIGITS2[c2]);
    }

    static char char4(int c1, int c2, int c3, int c4) {
        return (char)(JSONFactory.DIGITS2[c1] * 4096 + JSONFactory.DIGITS2[c2] * 256 + JSONFactory.DIGITS2[c3] * 16 + JSONFactory.DIGITS2[c4]);
    }

    public abstract boolean nextIfObjectStart();

    public abstract boolean nextIfNullOrEmptyString();

    public abstract boolean nextIfObjectEnd();

    public abstract boolean nextIfArrayStart();

    public abstract boolean nextIfArrayEnd();

    public abstract boolean nextIfComma();

    public int startArray() {
        if (!this.nextIfArrayStart()) {
            throw new JSONException(this.info("illegal input, expect '[', but " + this.ch));
        }
        return Integer.MAX_VALUE;
    }

    public abstract boolean isReference();

    public abstract String readReference();

    public final void addResolveTask(FieldReader fieldReader, Object object, JSONPath path) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(fieldReader, object, fieldReader.fieldName, path));
    }

    public final void addResolveTask(Map object, Object key, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        if (object instanceof LinkedHashMap) {
            object.put(key, null);
        }
        this.resolveTasks.add(new ResolveTask(null, object, key, reference));
    }

    public final void addResolveTask(Collection object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public final void addResolveTask(Object[] object, int i, JSONPath reference) {
        if (this.resolveTasks == null) {
            this.resolveTasks = new ArrayList<ResolveTask>();
        }
        this.resolveTasks.add(new ResolveTask(null, object, i, reference));
    }

    public abstract boolean isArray();

    public boolean isObject() {
        return this.ch == '{';
    }

    public boolean isNumber() {
        switch (this.ch) {
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                return true;
            }
        }
        return false;
    }

    public boolean isString() {
        return this.ch == '\"' || this.ch == '\'';
    }

    public void endArray() {
        this.next();
    }

    public abstract boolean nextIfMatch(char var1);

    public abstract boolean nextIfSet();

    public abstract boolean nextIfInfinity();

    public abstract String readPattern();

    public final int getOffset() {
        return this.offset;
    }

    public abstract void next();

    public abstract long readValueHashCode();

    public long readTypeHashCode() {
        return this.readValueHashCode();
    }

    public abstract long readFieldNameHashCode();

    public abstract long getNameHashCodeLCase();

    public abstract String readFieldName();

    public abstract String getFieldName();

    public final void setTypeRedirect(boolean typeRedirect) {
        this.typeRedirect = typeRedirect;
    }

    public final boolean isTypeRedirect() {
        return this.typeRedirect;
    }

    public abstract long readFieldNameHashCodeUnquote();

    public final String readFieldNameUnquote() {
        this.readFieldNameHashCodeUnquote();
        return this.getFieldName();
    }

    public abstract boolean skipName();

    public abstract void skipValue();

    public boolean isBinary() {
        return false;
    }

    public abstract byte[] readHex();

    public byte[] readBinary() {
        if (this.ch == 'x') {
            return this.readHex();
        }
        if (this.isString()) {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            if ((this.context.features & Feature.Base64StringAsByteArray.mask) != 0L) {
                return IOUtils.decodeBase64(str);
            }
            throw new JSONException(this.info("not support input " + str));
        }
        if (this.nextIfArrayStart()) {
            int index = 0;
            byte[] bytes = new byte[64];
            while (true) {
                if (this.ch == ']') break;
                if (index == bytes.length) {
                    int oldCapacity = bytes.length;
                    int newCapacity = oldCapacity + (oldCapacity >> 1);
                    bytes = Arrays.copyOf(bytes, newCapacity);
                }
                bytes[index++] = (byte)this.readInt32Value();
            }
            this.next();
            this.nextIfComma();
            return Arrays.copyOf(bytes, index);
        }
        throw new JSONException(this.info("not support read binary"));
    }

    public abstract int readInt32Value();

    public boolean nextIfMatch(byte type) {
        throw new JSONException("UnsupportedOperation");
    }

    public boolean nextIfMatchTypedAny() {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4, char var5);

    public abstract boolean nextIfMatchIdent(char var1, char var2, char var3, char var4, char var5, char var6);

    public abstract Integer readInt32();

    public final int getInt32Value() {
        switch (this.valueType) {
            case 1: {
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? -this.mag3 : this.mag3;
                }
                Number number = this.getNumber();
                if (number instanceof Long) {
                    long longValue = number.longValue();
                    if (longValue < Integer.MIN_VALUE || longValue > Integer.MAX_VALUE) {
                        throw new JSONException(this.info("integer overflow " + longValue));
                    }
                    return (int)longValue;
                }
                return number.intValue();
            }
            case 2: {
                return this.getNumber().intValue();
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                if ((this.context.features & Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("int value not support input null"));
                }
                return 0;
            }
            case 3: {
                return this.toInt32(this.stringValue);
            }
            case 6: {
                Number num = this.toNumber((Map)this.complex);
                if (num != null) {
                    return num.intValue();
                }
                return 0;
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public final long getInt64Value() {
        switch (this.valueType) {
            case 1: {
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? (long)(-this.mag3) : (long)this.mag3;
                }
                return this.getNumber().longValue();
            }
            case 2: {
                return this.getNumber().longValue();
            }
            case 4: {
                return this.boolValue ? 1L : 0L;
            }
            case 5: {
                if ((this.context.features & Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                return 0L;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toLong((Map)this.complex);
            }
            case 7: {
                return this.toInt((List)this.complex);
            }
        }
        throw new JSONException("TODO");
    }

    protected final Long getInt64() {
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    return this.negative ? (long)(-this.mag3) : (long)this.mag3;
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == Integer.MIN_VALUE && this.mag3 == 0 && !this.negative) {
                            return Long.MIN_VALUE;
                        }
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return this.negative ? -v23 : v23;
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                int signum = this.negative ? -1 : 1;
                BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                return bigInt.longValue();
            }
            case 2: {
                return this.getNumber().longValue();
            }
            case 4: {
                return this.boolValue ? 1L : 0L;
            }
            case 5: {
                return null;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                Number num = this.toNumber((Map)this.complex);
                if (num != null) {
                    return num.longValue();
                }
                return null;
            }
        }
        throw new JSONException("TODO");
    }

    public long[] readInt64ValueArray() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.nextIfArrayStart()) {
            long[] values = new long[8];
            int size = 0;
            while (!this.nextIfArrayEnd()) {
                if (this.isEnd()) {
                    throw new JSONException(this.info("input end"));
                }
                if (size == values.length) {
                    values = Arrays.copyOf(values, values.length << 1);
                }
                values[size++] = this.readInt64Value();
            }
            this.nextIfComma();
            long[] array = size == values.length ? values : Arrays.copyOf(values, size);
            return array;
        }
        if (this.isString()) {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw new JSONException(this.info("not support input " + str));
        }
        throw new JSONException(this.info("TODO"));
    }

    public abstract long readInt64Value();

    public abstract Long readInt64();

    public abstract float readFloatValue();

    public final Float readFloat() {
        if (this.nextIfNull()) {
            return null;
        }
        this.wasNull = false;
        float value = this.readFloatValue();
        if (this.wasNull) {
            return null;
        }
        return Float.valueOf(value);
    }

    public abstract double readDoubleValue();

    public final Double readDouble() {
        if (this.nextIfNull()) {
            return null;
        }
        this.wasNull = false;
        double value = this.readDoubleValue();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    public Number readNumber() {
        this.readNumber0();
        return this.getNumber();
    }

    public BigInteger readBigInteger() {
        this.readNumber0();
        return this.getBigInteger();
    }

    public abstract BigDecimal readBigDecimal();

    public abstract UUID readUUID();

    public final boolean isLocalDate() {
        LocalDate localDate;
        if (!this.isString()) {
            return false;
        }
        int len = this.getStringLength();
        switch (len) {
            case 8: {
                localDate = this.readLocalDate8();
                break;
            }
            case 9: {
                localDate = this.readLocalDate9();
                break;
            }
            case 10: {
                localDate = this.readLocalDate10();
                break;
            }
            case 11: {
                localDate = this.readLocalDate11();
                break;
            }
            default: {
                return false;
            }
        }
        return localDate != null;
    }

    public LocalDate readLocalDate() {
        String str;
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.context.getZoneId());
            return zdt.dateTime.date;
        }
        if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            LocalDateTime ldt = null;
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 19: {
                    ldt = this.readLocalDateTime19();
                    break;
                }
                case 20: {
                    ldt = this.readLocalDateTime20();
                    break;
                }
                default: {
                    if (len <= 20) break;
                    ldt = this.readLocalDateTimeX(len);
                }
            }
            if (ldt != null) {
                return ldt.date;
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            return null;
        }
        DateTimeFormatter formatter = this.context.getDateFormatter();
        if (formatter != null) {
            if (this.context.formatHasHour) {
                return formatter.parseLocalDateTime((String)str).date;
            }
            return formatter.parseLocalDate(str);
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.context.getZoneId());
            return zdt.dateTime.date;
        }
        throw new JSONException("not support input : " + str);
    }

    public final boolean isLocalDateTime() {
        if (!this.isString()) {
            return false;
        }
        int len = this.getStringLength();
        switch (len) {
            case 16: {
                return this.readLocalDateTime16() != null;
            }
            case 17: {
                return this.readLocalDateTime17() != null;
            }
            case 18: {
                return this.readLocalDateTime18() != null;
            }
            case 19: {
                return this.readLocalDateTime19() != null;
            }
            case 20: {
                return this.readLocalDateTime20() != null;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                return this.readLocalDateTimeX(len) != null;
            }
        }
        return false;
    }

    public LocalDateTime readLocalDateTime() {
        String str;
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.context.getZoneId());
            return zdt.dateTime;
        }
        if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 16: {
                    return this.readLocalDateTime16();
                }
                case 17: {
                    LocalDateTime ldt = this.readLocalDateTime17();
                    if (ldt == null) break;
                    return ldt;
                }
                case 18: {
                    LocalDateTime ldt = this.readLocalDateTime18();
                    if (ldt == null) break;
                    return ldt;
                }
                case 19: {
                    LocalDateTime ldt = this.readLocalDateTime19();
                    if (ldt == null) break;
                    return ldt;
                }
                case 20: {
                    LocalDateTime ldt = this.readLocalDateTime20();
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.dateTime;
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    LocalDateTime ldt = this.readLocalDateTimeX(len);
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    ZoneId contextZoneId = this.context.getZoneId();
                    ldt = !zdt.zone.equals(contextZoneId) ? ZonedDateTime.ofInstant((Instant)zdt.toInstant(), (ZoneId)contextZoneId).dateTime : zdt.dateTime;
                    return ldt;
                }
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            this.wasNull = true;
            return null;
        }
        DateTimeFormatter formatter = this.context.getDateFormatter();
        if (formatter != null) {
            if (!this.context.formatHasHour) {
                return LocalDateTime.of(formatter.parseLocalDate(str), LocalTime.MIN);
            }
            return formatter.parseLocalDateTime(str);
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, this.context.getZoneId());
        }
        if (str.startsWith("/Date(", 0) && str.endsWith(")/")) {
            String dotnetDateStr = str.substring(6, str.length() - 2);
            int i = dotnetDateStr.indexOf(43);
            if (i == -1) {
                i = dotnetDateStr.indexOf(45);
            }
            if (i != -1) {
                dotnetDateStr = dotnetDateStr.substring(0, i);
            }
            long millis = Long.parseLong(dotnetDateStr);
            Instant instant = Instant.ofEpochMilli(millis);
            return LocalDateTime.ofInstant(instant, this.context.getZoneId());
        }
        if (str.equals("0000-00-00 00:00:00")) {
            this.wasNull = true;
            return null;
        }
        throw new JSONException(this.info("read LocalDateTime error " + str));
    }

    public ZonedDateTime readZonedDateTime() {
        if (this.isInt()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            Instant instant = Instant.ofEpochMilli(millis);
            return ZonedDateTime.ofInstant(instant, this.context.getZoneId());
        }
        if (this.isString()) {
            String str;
            LocalDate localDate;
            if (this.context.dateFormat == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
                int len = this.getStringLength();
                LocalDateTime ldt = null;
                switch (len) {
                    case 8: {
                        localDate = this.readLocalDate8();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 9: {
                        localDate = this.readLocalDate9();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 10: {
                        localDate = this.readLocalDate10();
                        ldt = localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 11: {
                        localDate = this.readLocalDate11();
                        ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                        break;
                    }
                    case 16: {
                        ldt = this.readLocalDateTime16();
                        break;
                    }
                    case 17: {
                        ldt = this.readLocalDateTime17();
                        break;
                    }
                    case 18: {
                        ldt = this.readLocalDateTime18();
                        break;
                    }
                    case 19: {
                        ldt = this.readLocalDateTime19();
                        break;
                    }
                    case 20: {
                        ldt = this.readLocalDateTime20();
                        break;
                    }
                    default: {
                        ZonedDateTime zdt = this.readZonedDateTimeX(len);
                        if (zdt == null) break;
                        return zdt;
                    }
                }
                if (ldt != null) {
                    return ZonedDateTime.ofLocal(ldt, this.context.getZoneId());
                }
            }
            if ((str = this.readString()).isEmpty() || "null".equals(str)) {
                return null;
            }
            DateTimeFormatter formatter = this.context.getDateFormatter();
            if (formatter != null) {
                if (!this.context.formatHasHour) {
                    localDate = formatter.parseLocalDate(str);
                    return ZonedDateTime.of(localDate, LocalTime.MIN, this.context.getZoneId());
                }
                LocalDateTime localDateTime = formatter.parseLocalDateTime(str);
                return ZonedDateTime.of(localDateTime, this.context.getZoneId());
            }
            if (IOUtils.isNumber(str)) {
                long millis = Long.parseLong(str);
                if (this.context.formatUnixTime) {
                    millis *= 1000L;
                }
                Instant instant = Instant.ofEpochMilli(millis);
                return ZonedDateTime.ofInstant(instant, this.context.getZoneId());
            }
            return DateUtils.parseZonedDateTime(str);
        }
        throw new JSONException("TODO : " + this.ch);
    }

    public LocalTime readLocalTime() {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.isInt()) {
            long millis = this.readInt64Value();
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.context.getZoneId());
            return zdt.dateTime.time;
        }
        int len = this.getStringLength();
        switch (len) {
            case 5: {
                return this.readLocalTime5();
            }
            case 8: {
                return this.readLocalTime8();
            }
            case 10: {
                return this.readLocalTime10();
            }
            case 11: {
                return this.readLocalTime11();
            }
            case 12: {
                return this.readLocalTime12();
            }
            case 18: {
                return this.readLocalTime18();
            }
            case 19: {
                return this.readLocalDateTime19().time;
            }
            case 20: {
                return this.readLocalDateTime20().time;
            }
        }
        String str = this.readString();
        if (str.isEmpty() || "null".equals(str)) {
            return null;
        }
        if (IOUtils.isNumber(str)) {
            long millis = Long.parseLong(str);
            Instant instant = Instant.ofEpochMilli(millis);
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, this.context.getZoneId());
            return zdt.dateTime.time;
        }
        throw new JSONException("not support len : " + len);
    }

    protected abstract int getStringLength();

    public Instant readInstant() {
        if (this.nextIfNullOrEmptyString()) {
            this.wasNull = true;
            return null;
        }
        if (this.isNumber()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            return Instant.ofEpochMilli(millis);
        }
        if (this.isObject()) {
            return (Instant)this.getObjectReader((Type)((Object)Instant.class)).createInstance(this.readObject(), 0L);
        }
        ZonedDateTime zdt = this.readZonedDateTime();
        if (zdt == null) {
            return null;
        }
        return Instant.ofEpochSecond(zdt.toEpochSecond(), zdt.dateTime.time.nano);
    }

    public final long readMillisFromString() {
        String str;
        this.wasNull = false;
        String format = this.context.dateFormat;
        if (format == null || this.context.formatyyyyMMddhhmmss19 || this.context.formatyyyyMMddhhmmssT19 || this.context.formatyyyyMMdd8 || this.context.formatISO8601) {
            int len = this.getStringLength();
            LocalDateTime ldt = null;
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    if (localDate == null) {
                        throw new JSONException("TODO : " + this.readString());
                    }
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    if (localDate == null) break;
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    if (localDate == null) {
                        String str2 = this.readString();
                        if ("0000-00-00".equals(str2)) {
                            this.wasNull = true;
                            return 0L;
                        }
                        if (IOUtils.isNumber(str2)) {
                            return Long.parseLong(str2);
                        }
                        throw new JSONException("TODO : " + str2);
                    }
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    if (localDate == null) break;
                    ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                    break;
                }
                case 12: {
                    ldt = this.readLocalDateTime12();
                    break;
                }
                case 14: {
                    ldt = this.readLocalDateTime14();
                    break;
                }
                case 16: {
                    ldt = this.readLocalDateTime16();
                    break;
                }
                case 17: {
                    ldt = this.readLocalDateTime17();
                    break;
                }
                case 18: {
                    ldt = this.readLocalDateTime18();
                    break;
                }
                case 19: {
                    long millis = this.readMillis19();
                    if (millis != 0L || !this.wasNull) {
                        return millis;
                    }
                    ldt = this.readLocalDateTime19();
                    break;
                }
                case 20: {
                    ldt = this.readLocalDateTime20();
                    break;
                }
            }
            ZonedDateTime zdt = null;
            if (ldt != null) {
                zdt = ZonedDateTime.ofLocal(ldt, this.context.getZoneId());
            } else if (len >= 20 && (zdt = this.readZonedDateTimeX(len)) == null && len >= 32 && len <= 35) {
                String str3 = this.readString();
                zdt = DateUtils.parseZonedDateTime(str3, null);
            }
            if (zdt != null) {
                long seconds = zdt.toEpochSecond();
                int nanos = zdt.dateTime.time.nano;
                if (seconds < 0L && nanos > 0) {
                    long millis = (seconds + 1L) * 1000L;
                    long adjustment = nanos / 1000000 - 1000;
                    return millis + adjustment;
                }
                long millis = seconds * 1000L;
                return millis + (long)(nanos / 1000000);
            }
        }
        if ((str = this.readString()).isEmpty() || "null".equals(str)) {
            this.wasNull = true;
            return 0L;
        }
        if (this.context.formatMillis || this.context.formatUnixTime) {
            long millis = Long.parseLong(str);
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            return millis;
        }
        if (format != null && !format.isEmpty()) {
            if ("yyyy-MM-dd HH:mm:ss".equals(format)) {
                if ((str.length() < 4 || str.charAt(4) != '-') && IOUtils.isNumber(str)) {
                    return Long.parseLong(str);
                }
                return DateUtils.parseMillis19(str, null);
            }
            SimpleDateFormat utilFormat = new SimpleDateFormat(format);
            try {
                return utilFormat.parse(str).getTime();
            }
            catch (ParseException e) {
                throw new JSONException("parse date error, " + str + ", expect format " + utilFormat.toPattern());
            }
        }
        if ("0000-00-00T00:00:00".equals(str) || "0001-01-01T00:00:00+08:00".equals(str)) {
            return 0L;
        }
        if (str.startsWith("/Date(", 0) && str.endsWith(")/")) {
            String dotnetDateStr = str.substring(6, str.length() - 2);
            int i = dotnetDateStr.indexOf(43);
            if (i == -1) {
                i = dotnetDateStr.indexOf(45);
            }
            if (i != -1) {
                dotnetDateStr = dotnetDateStr.substring(0, i);
            }
            return Long.parseLong(dotnetDateStr);
        }
        if (IOUtils.isNumber(str)) {
            return Long.parseLong(str);
        }
        throw new JSONException(this.info("format " + format + " not support, input " + str));
    }

    protected abstract LocalDateTime readLocalDateTime12();

    protected abstract LocalDateTime readLocalDateTime14();

    protected abstract LocalDateTime readLocalDateTime16();

    protected abstract LocalDateTime readLocalDateTime17();

    protected abstract LocalDateTime readLocalDateTime18();

    protected abstract LocalDateTime readLocalDateTime19();

    protected abstract LocalDateTime readLocalDateTime20();

    public abstract long readMillis19();

    protected abstract LocalDateTime readLocalDateTimeX(int var1);

    protected abstract LocalTime readLocalTime5();

    protected abstract LocalTime readLocalTime8();

    protected abstract LocalTime readLocalTime10();

    protected abstract LocalTime readLocalTime11();

    protected abstract LocalTime readLocalTime12();

    protected abstract LocalTime readLocalTime18();

    protected abstract LocalDate readLocalDate8();

    protected abstract LocalDate readLocalDate9();

    protected abstract LocalDate readLocalDate10();

    protected abstract LocalDate readLocalDate11();

    protected abstract ZonedDateTime readZonedDateTimeX(int var1);

    public void readNumber(ValueConsumer consumer, boolean quoted) {
        this.readNumber0();
        Number number = this.getNumber();
        consumer.accept(number);
    }

    public void readString(ValueConsumer consumer, boolean quoted) {
        String str = this.readString();
        if (quoted) {
            consumer.accept(JSON.toJSONString(str));
        } else {
            consumer.accept(str);
        }
    }

    protected abstract void readNumber0();

    public abstract String readString();

    public Date readDate() {
        if ((this.context.formatMillis || this.context.formatUnixTime || this.context.dateFormat == null) && this.isInt()) {
            long millis = this.readInt64Value();
            if (this.context.formatUnixTime) {
                millis *= 1000L;
            }
            return new Date(millis);
        }
        String str = this.readString();
        return DateUtils.parseDate(str, this.context.dateFormat, this.context.getZoneId());
    }

    public Calendar readCalendar() {
        Date date = this.readDate();
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance(this.context.getTimeZone());
        calendar.setTime(date);
        return calendar;
    }

    public String[] readStringArray() {
        if (this.ch == 'n' && this.nextIfNull()) {
            return null;
        }
        if (this.nextIfArrayStart()) {
            String[] values = null;
            int size = 0;
            while (true) {
                if (this.nextIfArrayEnd()) {
                    if (values != null) break;
                    values = new String[]{};
                    break;
                }
                if (this.isEnd()) {
                    throw new JSONException(this.info("input end"));
                }
                if (values == null) {
                    values = new String[16];
                } else if (size == values.length) {
                    values = Arrays.copyOf(values, values.length << 1);
                }
                values[size++] = this.readString();
            }
            this.nextIfComma();
            if (values.length == size) {
                return values;
            }
            return Arrays.copyOf(values, size);
        }
        if (this.ch == '\"' || this.ch == '\'') {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            throw new JSONException(this.info("not support input " + str));
        }
        throw new JSONException(this.info("not support input"));
    }

    public char readCharValue() {
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            this.wasNull = true;
            return '\u0000';
        }
        return str.charAt(0);
    }

    public abstract void readNull();

    public abstract boolean readIfNull();

    public abstract String getString();

    public boolean wasNull() {
        return this.wasNull;
    }

    public <T> T read(Type type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, null, null, 0L);
    }

    public final void read(List list) {
        if (!this.nextIfArrayStart()) {
            throw new JSONException("illegal input, offset " + this.offset + ", char " + this.ch);
        }
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        while (true) {
            if (this.nextIfArrayEnd()) {
                --this.level;
                break;
            }
            Object item = ObjectReaderImplObject.INSTANCE.readObject(this, null, null, 0L);
            list.add(item);
            this.nextIfComma();
        }
        this.nextIfComma();
    }

    public final void read(Collection list) {
        if (!this.nextIfArrayStart()) {
            throw new JSONException("illegal input, offset " + this.offset + ", char " + this.ch);
        }
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        while (true) {
            if (this.nextIfArrayEnd()) {
                --this.level;
                break;
            }
            Object item = this.readAny();
            list.add(item);
            if (!this.nextIfComma()) continue;
        }
        this.nextIfComma();
    }

    public final void readObject(Object object, Feature ... features) {
        long featuresLong = 0L;
        for (int i = 0; i < features.length; ++i) {
            featuresLong |= features[i].mask;
        }
        this.readObject(object, featuresLong);
    }

    public final void readObject(Object object, long features) {
        boolean fieldBased;
        if (object == null) {
            throw new JSONException("object is null");
        }
        Class<?> objectClass = object.getClass();
        ObjectReader objectReader = this.context.provider.getObjectReader(objectClass, fieldBased = ((this.context.features | features) & Feature.FieldBased.mask) != 0L);
        if (objectReader instanceof ObjectReaderBean) {
            ObjectReaderBean objectReaderBean = (ObjectReaderBean)objectReader;
            objectReaderBean.readObject(this, object, features);
        } else if (object instanceof Map) {
            this.read((Map)object, features);
        } else {
            throw new JSONException("read object not support");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void read(Map object, long features) {
        boolean match = this.nextIfObjectStart();
        boolean typeRedirect = false;
        if (!match) {
            typeRedirect = this.isTypeRedirect();
            if (typeRedirect) {
                this.setTypeRedirect(false);
            } else {
                String str;
                if (!this.isString() || !(str = this.readString()).isEmpty()) throw new JSONException("illegal input\uff0c offset " + this.offset + ", char " + this.ch);
                return;
            }
        }
        long contextFeatures = features | this.context.features;
        int i = 0;
        while (true) {
            block29: {
                Object origin;
                Object value;
                Object name;
                if (this.ch == '/') {
                    this.skipLineComment();
                }
                if (this.nextIfObjectEnd()) break;
                if (i != 0 && !this.comma) {
                    throw new JSONException(this.info());
                }
                if (match || typeRedirect) {
                    name = this.ch >= '1' && this.ch <= '9' ? null : this.readFieldName();
                } else {
                    name = this.getFieldName();
                    match = true;
                }
                if (name == null) {
                    if (this.isNumber()) {
                        name = this.readNumber();
                        if ((contextFeatures & Feature.NonStringKeyAsString.mask) != 0L) {
                            name = name.toString();
                        }
                    } else {
                        if ((contextFeatures & Feature.AllowUnQuotedFieldNames.mask) == 0L) throw new JSONException(this.info("not allow unquoted fieldName"));
                        name = this.readFieldNameUnquote();
                    }
                    if (this.ch == ':') {
                        this.next();
                    }
                }
                this.comma = false;
                switch (this.ch) {
                    case '+': 
                    case '-': 
                    case '.': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        value = this.readNumber();
                        break;
                    }
                    case '[': {
                        value = this.readArray();
                        break;
                    }
                    case '{': {
                        if (typeRedirect) {
                            value = ObjectReaderImplObject.INSTANCE.readObject(this, null, name, features);
                            break;
                        }
                        value = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        value = this.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        value = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        value = this.readNullOrNewDate();
                        break;
                    }
                    case '/': {
                        this.next();
                        if (this.ch != '/') throw new JSONException("FASTJSON2.0.40input not support " + this.ch + ", offset " + this.offset);
                        this.skipLineComment();
                        break block29;
                    }
                    case 'S': {
                        if (!this.nextIfSet()) throw new JSONException("FASTJSON2.0.40error, offset " + this.offset + ", char " + this.ch);
                        value = this.read(HashSet.class);
                        break;
                    }
                    case 'I': {
                        if (!this.nextIfInfinity()) throw new JSONException("FASTJSON2.0.40error, offset " + this.offset + ", char " + this.ch);
                        value = Double.POSITIVE_INFINITY;
                        break;
                    }
                    case 'x': {
                        value = this.readBinary();
                        break;
                    }
                    default: {
                        throw new JSONException("FASTJSON2.0.40error, offset " + this.offset + ", char " + this.ch);
                    }
                }
                if ((value != null || (contextFeatures & Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = object.put(name, value)) != null && (contextFeatures & Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                    if (origin instanceof Collection) {
                        ((Collection)origin).add(value);
                        object.put(name, origin);
                    } else {
                        JSONArray array = JSONArray.of(origin, value);
                        object.put(name, array);
                    }
                }
            }
            ++i;
        }
        this.nextIfComma();
    }

    public final void read(Map object, Type keyType, Type valueType, long features) {
        boolean match = this.nextIfObjectStart();
        if (!match) {
            throw new JSONException("illegal input\uff0c offset " + this.offset + ", char " + this.ch);
        }
        ObjectReader keyReader = this.context.getObjectReader(keyType);
        ObjectReader valueReader = this.context.getObjectReader(valueType);
        long contextFeatures = features | this.context.getFeatures();
        int i = 0;
        while (true) {
            Object origin;
            String name;
            if (this.ch == '/') {
                this.skipLineComment();
            }
            if (this.nextIfMatch('}')) break;
            if (i != 0 && !this.comma) {
                throw new JSONException(this.info());
            }
            if (keyType == String.class) {
                name = this.readFieldName();
            } else {
                name = keyReader.readObject(this, null, null, 0L);
                this.nextIfMatch(':');
            }
            Object value = valueReader.readObject(this, null, null, 0L);
            if ((value != null || (contextFeatures & Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = object.put(name, value)) != null && (contextFeatures & Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                if (origin instanceof Collection) {
                    ((Collection)origin).add(value);
                    object.put(name, origin);
                } else {
                    JSONArray array = JSONArray.of(origin, value);
                    object.put(name, array);
                }
            }
            ++i;
        }
        this.nextIfComma();
    }

    public <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readObject(this, null, null, 0L);
    }

    public Map<String, Object> readObject() {
        this.nextIfObjectStart();
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        JSONObject object = this.context.objectSupplier == null ? ((this.context.features & Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject()) : this.context.objectSupplier.get();
        int i = 0;
        while (true) {
            block23: {
                Object val;
                if (this.ch == '}') break;
                Object name = this.readFieldName();
                if (name == null) {
                    if (this.ch == '\u001a') {
                        throw new JSONException("input end");
                    }
                    if (this.ch == '-' || this.ch >= '0' && this.ch <= '9') {
                        this.readNumber0();
                        name = this.getNumber();
                    } else {
                        name = this.readFieldNameUnquote();
                    }
                    this.nextIfMatch(':');
                }
                if (i == 0 && (this.context.features & Feature.ErrorOnNotSupportAutoType.mask) != 0L && "@type".equals(name)) {
                    String typeName = this.readString();
                    throw new JSONException("autoType not support : " + typeName);
                }
                switch (this.ch) {
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.readNumber0();
                        val = this.getNumber();
                        break;
                    }
                    case '[': {
                        val = this.readArray();
                        break;
                    }
                    case '{': {
                        val = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = this.readString();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        this.readNull();
                        val = null;
                        break;
                    }
                    case '/': {
                        this.next();
                        if (this.ch == '/') {
                            this.skipLineComment();
                        }
                        break block23;
                    }
                    case 'I': {
                        if (this.nextIfInfinity()) {
                            val = Double.POSITIVE_INFINITY;
                            break;
                        }
                        throw new JSONException(this.info("illegal input " + this.ch));
                    }
                    case 'S': {
                        if (this.nextIfSet()) {
                            val = this.read(Set.class);
                            break;
                        }
                        throw new JSONException(this.info("illegal input " + this.ch));
                    }
                    default: {
                        throw new JSONException(this.info("illegal input " + this.ch));
                    }
                }
                if (val != null || (this.context.features & Feature.IgnoreNullPropertyValue.mask) == 0L) {
                    object.put(name, val);
                }
            }
            ++i;
        }
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        --this.level;
        return object;
    }

    public abstract void skipLineComment();

    public final Boolean readBool() {
        if (this.isNull()) {
            this.readNull();
            return null;
        }
        boolean boolValue = this.readBoolValue();
        if (!boolValue && this.wasNull) {
            return null;
        }
        return boolValue;
    }

    public abstract boolean readBoolValue();

    public Object readAny() {
        return this.read(Object.class);
    }

    public List readArray(Type itemType) {
        if (this.nextIfNull()) {
            return null;
        }
        if (!this.nextIfArrayStart()) {
            throw new JSONException(this.info("syntax error : " + this.ch));
        }
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(itemType, fieldBased);
        ArrayList list = new ArrayList();
        while (!this.nextIfArrayEnd()) {
            int mark = this.offset;
            Object item = objectReader.readObject(this, null, null, 0L);
            if (mark == this.offset || this.ch == '}' || this.ch == '\u001a') {
                throw new JSONException("illegal input : " + this.ch + ", offset " + this.getOffset());
            }
            list.add(item);
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return list;
    }

    public List readList(Type[] types) {
        if (this.nextIfNull()) {
            return null;
        }
        if (!this.nextIfArrayStart()) {
            throw new JSONException("syntax error : " + this.ch);
        }
        int i = 0;
        int max = types.length;
        ArrayList list = new ArrayList(max);
        while (!this.nextIfArrayEnd() && i < max) {
            int mark = this.offset;
            Object item = this.read(types[i++]);
            if (mark == this.offset || this.ch == '}' || this.ch == '\u001a') {
                throw new JSONException("illegal input : " + this.ch + ", offset " + this.getOffset());
            }
            list.add(item);
        }
        if (i != max) {
            throw new JSONException(this.info("element length mismatch"));
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return list;
    }

    public final Object[] readArray(Type[] types) {
        if (this.nextIfNull()) {
            return null;
        }
        if (!this.nextIfArrayStart()) {
            throw new JSONException(this.info("syntax error"));
        }
        boolean arrayEnd = false;
        Object[] list = new Object[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (i != 0) {
                if (this.nextIfArrayEnd()) {
                    arrayEnd = true;
                    break;
                }
                if (this.isEnd()) break;
            }
            Type itemType = types[i];
            Object item = this.read(itemType);
            list[i] = item;
            if (i != types.length - 1) continue;
            arrayEnd = true;
        }
        if (!arrayEnd) {
            throw new JSONException(this.info("syntax error"));
        }
        return list;
    }

    public final void readArray(List list, Type itemType) {
        this.readArray((Collection)list, itemType);
    }

    public final void readArray(Collection list, Type itemType) {
        if (this.nextIfArrayStart()) {
            while (!this.nextIfArrayEnd()) {
                Object item = this.read(itemType);
                list.add(item);
                if (this.ch != '}' && this.ch != '\u001a') continue;
                throw new JSONException(this.info());
            }
            this.comma = this.ch == ',';
            if (this.comma) {
                this.next();
            }
            return;
        }
        if (this.isString()) {
            String str = this.readString();
            if (itemType == String.class) {
                list.add(str);
            } else {
                Function typeConvert = this.context.provider.getTypeConvert((Type)((Object)String.class), itemType);
                if (typeConvert == null) {
                    throw new JSONException(this.info("not support input " + str));
                }
                if (str.indexOf(44) != -1) {
                    String[] items;
                    for (String strItem : items = str.split(",")) {
                        Object item = typeConvert.apply(strItem);
                        list.add(item);
                    }
                } else {
                    Object item = typeConvert.apply(str);
                    list.add(item);
                }
            }
        } else {
            Object item = this.read(itemType);
            list.add(item);
        }
        if (this.comma = this.ch == ',') {
            this.next();
        }
    }

    public List readArray() {
        this.next();
        ++this.level;
        if (this.level >= this.context.maxLevel) {
            throw new JSONException("level too large : " + this.level);
        }
        int i = 0;
        List<Object> list = null;
        Map<String, Object> first = null;
        Map<String, Object> second = null;
        block10: while (true) {
            block28: {
                Map<String, Object> val;
                switch (this.ch) {
                    case ']': {
                        this.next();
                        break block10;
                    }
                    case '[': {
                        val = this.readArray();
                        break;
                    }
                    case '{': {
                        if (this.context.autoTypeBeforeHandler != null || (this.context.features & Feature.SupportAutoType.mask) != 0L) {
                            val = ObjectReaderImplObject.INSTANCE.readObject(this, null, null, 0L);
                            break;
                        }
                        val = this.readObject();
                        break;
                    }
                    case '\"': 
                    case '\'': {
                        val = this.readString();
                        break;
                    }
                    case '+': 
                    case '-': 
                    case '0': 
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': 
                    case '8': 
                    case '9': {
                        this.readNumber0();
                        val = this.getNumber();
                        break;
                    }
                    case 'f': 
                    case 't': {
                        val = this.readBoolValue();
                        break;
                    }
                    case 'n': {
                        this.readNull();
                        val = null;
                        break;
                    }
                    case '/': {
                        this.skipLineComment();
                        break block28;
                    }
                    default: {
                        throw new JSONException("TODO : " + this.ch);
                    }
                }
                if (i == 0) {
                    first = val;
                } else if (i == 1) {
                    second = val;
                } else if (i == 2) {
                    list = this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray();
                    list.add(first);
                    list.add(second);
                    list.add(val);
                } else {
                    list.add(val);
                }
            }
            ++i;
        }
        if (list == null) {
            if (this.context.arraySupplier != null) {
                list = this.context.arraySupplier.get();
            } else if (this.context.isEnabled(Feature.UseNativeObject)) {
                list = i == 2 ? new ArrayList(2) : new ArrayList(1);
            } else {
                JSONArray jSONArray = list = i == 2 ? new JSONArray(2) : new JSONArray(1);
            }
            if (i == 1) {
                list.add(first);
            } else if (i == 2) {
                list.add(first);
                list.add(second);
            }
        }
        if (this.comma = this.ch == ',') {
            this.next();
        }
        --this.level;
        return list;
    }

    public final BigInteger getBigInteger() {
        Number number = this.getNumber();
        if (number == null) {
            return null;
        }
        if (number instanceof BigInteger) {
            return (BigInteger)number;
        }
        return BigInteger.valueOf(number.longValue());
    }

    public final BigDecimal getBigDecimal() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: {
                int[] mag;
                if (this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    return BigDecimal.valueOf(this.negative ? (long)(-this.mag3) : (long)this.mag3);
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return BigDecimal.valueOf(this.negative ? -v23 : v23);
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                int signum = this.negative ? -1 : 1;
                BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                return new BigDecimal(bigInt);
            }
            case 2: {
                BigDecimal decimal = null;
                if (this.exponent == 0 && this.mag0 == 0 && this.mag1 == 0) {
                    if (this.mag2 == 0 && this.mag3 >= 0) {
                        int unscaledVal = this.negative ? -this.mag3 : this.mag3;
                        decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                    } else {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            long unscaledVal = this.negative ? -v23 : v23;
                            decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                        }
                    }
                }
                if (decimal == null) {
                    int[] nArray;
                    if (this.mag0 == 0) {
                        if (this.mag1 == 0) {
                            if (this.mag2 == 0) {
                                int[] nArray2 = new int[1];
                                nArray = nArray2;
                                nArray2[0] = this.mag3;
                            } else {
                                int[] nArray3 = new int[2];
                                nArray3[0] = this.mag2;
                                nArray = nArray3;
                                nArray3[1] = this.mag3;
                            }
                        } else {
                            int[] nArray4 = new int[3];
                            nArray4[0] = this.mag1;
                            nArray4[1] = this.mag2;
                            nArray = nArray4;
                            nArray4[2] = this.mag3;
                        }
                    } else {
                        int[] nArray5 = new int[4];
                        nArray5[0] = this.mag0;
                        nArray5[1] = this.mag1;
                        nArray5[2] = this.mag2;
                        nArray = nArray5;
                        nArray5[3] = this.mag3;
                    }
                    int[] mag = nArray;
                    int signum = this.negative ? -1 : 1;
                    BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                    decimal = new BigDecimal(bigInt, this.scale);
                }
                if (this.exponent != 0) {
                    String doubleStr = decimal.toPlainString() + "E" + this.exponent;
                    double doubleValue = Double.parseDouble(doubleStr);
                    return TypeUtils.toBigDecimal(doubleValue);
                }
                return decimal;
            }
            case 8: {
                return TypeUtils.toBigDecimal(this.stringValue);
            }
            case 4: {
                return this.boolValue ? BigDecimal.ONE : BigDecimal.ZERO;
            }
            case 3: {
                try {
                    return TypeUtils.toBigDecimal(this.stringValue);
                }
                catch (NumberFormatException ex) {
                    throw new JSONException(this.info("read decimal error, value " + this.stringValue), ex);
                }
            }
            case 6: {
                JSONObject object = (JSONObject)this.complex;
                BigDecimal decimal = object.getBigDecimal("value");
                if (decimal == null) {
                    decimal = object.getBigDecimal("$numberDecimal");
                }
                if (decimal != null) {
                    return decimal;
                }
                throw new JSONException("TODO : " + this.valueType);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    public final Number getNumber() {
        if (this.wasNull) {
            return null;
        }
        switch (this.valueType) {
            case 1: 
            case 11: {
                int[] mag;
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                    int intVlaue;
                    if (this.negative) {
                        if (this.mag3 < 0) {
                            return -((long)this.mag3 & 0xFFFFFFFFL);
                        }
                        intVlaue = -this.mag3;
                    } else {
                        if (this.mag3 < 0) {
                            return (long)this.mag3 & 0xFFFFFFFFL;
                        }
                        intVlaue = this.mag3;
                    }
                    if (this.valueType == 11) {
                        return (long)intVlaue;
                    }
                    return intVlaue;
                }
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long v23 = (v2 << 32) + v3;
                            return this.negative ? -v23 : v23;
                        }
                        mag = new int[]{this.mag2, this.mag3};
                    } else {
                        mag = new int[]{this.mag1, this.mag2, this.mag3};
                    }
                } else {
                    mag = new int[]{this.mag0, this.mag1, this.mag2, this.mag3};
                }
                int signum = this.negative ? -1 : 1;
                return BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
            }
            case 10: {
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    int intValue = this.negative ? -this.mag3 : this.mag3;
                    return (short)intValue;
                }
                throw new JSONException(this.info("shortValue overflow"));
            }
            case 9: {
                if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 >= 0) {
                    int intValue = this.negative ? -this.mag3 : this.mag3;
                    return (byte)intValue;
                }
                throw new JSONException(this.info("shortValue overflow"));
            }
            case 2: {
                BigDecimal decimal = null;
                if (this.mag0 == 0 && this.mag1 == 0) {
                    if (this.mag2 == 0 && this.mag3 >= 0) {
                        int unscaledVal;
                        int n = unscaledVal = this.negative ? -this.mag3 : this.mag3;
                        if (this.exponent == 0) {
                            if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                                switch (this.scale) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: {
                                        return Float.valueOf((float)((double)unscaledVal / JSONFactory.DOUBLE_10_POW[this.scale]));
                                    }
                                }
                            } else if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                                if (unscaledVal == 0) {
                                    return JSONFactory.DOUBLE_ZERO;
                                }
                                switch (this.scale) {
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: 
                                    case 5: 
                                    case 6: 
                                    case 7: 
                                    case 8: 
                                    case 9: 
                                    case 10: 
                                    case 11: 
                                    case 12: 
                                    case 13: 
                                    case 14: 
                                    case 15: {
                                        return (double)unscaledVal / JSONFactory.DOUBLE_10_POW[this.scale];
                                    }
                                }
                            }
                        }
                        decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                    } else {
                        long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                        long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                        if (v2 <= Integer.MAX_VALUE) {
                            long unscaledVal;
                            long v23 = (v2 << 32) + v3;
                            long l = unscaledVal = this.negative ? -v23 : v23;
                            if (this.exponent == 0) {
                                if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                                    long unsignedUnscaledVal;
                                    boolean isNegative;
                                    if (unscaledVal < 0L) {
                                        isNegative = true;
                                        unsignedUnscaledVal = -unscaledVal;
                                    } else {
                                        isNegative = false;
                                        unsignedUnscaledVal = unscaledVal;
                                    }
                                    if (this.doubleChars == null) {
                                        this.doubleChars = new char[20];
                                    }
                                    int len = IOUtils.writeInt64(this.doubleChars, 0, unsignedUnscaledVal);
                                    return Float.valueOf(TypeUtils.floatValue(isNegative, len - this.scale, this.doubleChars, len));
                                }
                                if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                                    long unsignedUnscaledVal;
                                    boolean isNegative;
                                    if (unscaledVal < 0L) {
                                        isNegative = true;
                                        unsignedUnscaledVal = -unscaledVal;
                                    } else {
                                        isNegative = false;
                                        unsignedUnscaledVal = unscaledVal;
                                    }
                                    if (unsignedUnscaledVal < 0x10000000000000L) {
                                        if (this.scale > 0 && this.scale < JSONFactory.DOUBLE_10_POW.length) {
                                            return (double)unscaledVal / JSONFactory.DOUBLE_10_POW[this.scale];
                                        }
                                        if (this.scale < 0 && this.scale > -JSONFactory.DOUBLE_10_POW.length) {
                                            return (double)unscaledVal * JSONFactory.DOUBLE_10_POW[-this.scale];
                                        }
                                    }
                                    if (this.doubleChars == null) {
                                        this.doubleChars = new char[20];
                                    }
                                    int len = IOUtils.writeInt64(this.doubleChars, 0, unsignedUnscaledVal);
                                    return TypeUtils.doubleValue(isNegative, len - this.scale, this.doubleChars, len);
                                }
                            }
                            decimal = BigDecimal.valueOf(unscaledVal, this.scale);
                        }
                    }
                }
                if (decimal == null) {
                    int[] nArray;
                    if (this.mag0 == 0) {
                        if (this.mag1 == 0) {
                            int[] nArray2 = new int[2];
                            nArray2[0] = this.mag2;
                            nArray = nArray2;
                            nArray2[1] = this.mag3;
                        } else {
                            int[] nArray3 = new int[3];
                            nArray3[0] = this.mag1;
                            nArray3[1] = this.mag2;
                            nArray = nArray3;
                            nArray3[2] = this.mag3;
                        }
                    } else {
                        int[] nArray4 = new int[4];
                        nArray4[0] = this.mag0;
                        nArray4[1] = this.mag1;
                        nArray4[2] = this.mag2;
                        nArray = nArray4;
                        nArray4[3] = this.mag3;
                    }
                    int[] mag = nArray;
                    int signum = this.negative ? -1 : 1;
                    BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                    int adjustedScale = this.scale - this.exponent;
                    decimal = new BigDecimal(bigInt, adjustedScale);
                    if (this.exponent != 0) {
                        return decimal.doubleValue();
                    }
                }
                if (this.exponent != 0) {
                    String decimalStr = decimal.toPlainString();
                    double doubleValue = Double.parseDouble(decimalStr + "E" + this.exponent);
                    return doubleValue;
                }
                if ((this.context.features & Feature.UseBigDecimalForFloats.mask) != 0L) {
                    return Float.valueOf(decimal.floatValue());
                }
                if ((this.context.features & Feature.UseBigDecimalForDoubles.mask) != 0L) {
                    return decimal.doubleValue();
                }
                return decimal;
            }
            case 8: {
                if (this.scale > 0) {
                    return TypeUtils.toBigDecimal(this.stringValue);
                }
                return new BigInteger(this.stringValue);
            }
            case 12: 
            case 13: {
                int[] nArray;
                if (this.mag0 == 0) {
                    if (this.mag1 == 0) {
                        if (this.mag2 == 0) {
                            int[] nArray5 = new int[1];
                            nArray = nArray5;
                            nArray5[0] = this.mag3;
                        } else {
                            int[] nArray6 = new int[2];
                            nArray6[0] = this.mag2;
                            nArray = nArray6;
                            nArray6[1] = this.mag3;
                        }
                    } else {
                        int[] nArray7 = new int[3];
                        nArray7[0] = this.mag1;
                        nArray7[1] = this.mag2;
                        nArray = nArray7;
                        nArray7[2] = this.mag3;
                    }
                } else {
                    int[] nArray8 = new int[4];
                    nArray8[0] = this.mag0;
                    nArray8[1] = this.mag1;
                    nArray8[2] = this.mag2;
                    nArray = nArray8;
                    nArray8[3] = this.mag3;
                }
                int[] mag = nArray;
                int signum = this.negative ? -1 : 1;
                BigInteger bigInt = BigIntegerCreator.BIG_INTEGER_CREATOR.apply(signum, mag);
                BigDecimal decimal = new BigDecimal(bigInt, this.scale);
                if (this.valueType == 12) {
                    if (this.exponent != 0) {
                        float floatValueValue = Float.parseFloat(decimal + "E" + this.exponent);
                        return Float.valueOf(floatValueValue);
                    }
                    return Float.valueOf(decimal.floatValue());
                }
                if (this.exponent != 0) {
                    double doubleValue = Double.parseDouble(decimal + "E" + this.exponent);
                    return doubleValue;
                }
                return decimal.doubleValue();
            }
            case 4: {
                return this.boolValue ? 1 : 0;
            }
            case 5: {
                return null;
            }
            case 3: {
                return this.toInt64(this.stringValue);
            }
            case 6: {
                return this.toNumber((Map)this.complex);
            }
            case 7: {
                return this.toNumber((List)this.complex);
            }
        }
        throw new JSONException("TODO : " + this.valueType);
    }

    @Override
    public abstract void close();

    protected final int toInt32(String val) {
        if (IOUtils.isNumber(val)) {
            return Integer.parseInt(val);
        }
        throw new JSONException("parseInt error, value : " + val);
    }

    protected final long toInt64(String val) {
        if (IOUtils.isNumber(val)) {
            return Long.parseLong(val);
        }
        if (val.length() > 10 && val.length() < 40) {
            try {
                return DateUtils.parseMillis(val, this.context.zoneId);
            }
            catch (JSONException | DateTimeException runtimeException) {
                // empty catch block
            }
        }
        throw new JSONException("parseLong error, value : " + val);
    }

    protected final long toLong(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return ((Number)val).intValue();
        }
        throw new JSONException("parseLong error, value : " + map);
    }

    protected final int toInt(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return ((Number)val).intValue();
            }
            if (val instanceof String) {
                return Integer.parseInt((String)val);
            }
        }
        throw new JSONException("parseLong error, field : value " + list);
    }

    protected final Number toNumber(Map map) {
        Object val = map.get("val");
        if (val instanceof Number) {
            return (Number)val;
        }
        return null;
    }

    protected final BigDecimal decimal(JSONObject object) {
        BigDecimal decimal = object.getBigDecimal("value");
        if (decimal == null) {
            decimal = object.getBigDecimal("$numberDecimal");
        }
        if (decimal != null) {
            return decimal;
        }
        throw new JSONException("can not cast to decimal " + object);
    }

    protected final Number toNumber(List list) {
        if (list.size() == 1) {
            Object val = list.get(0);
            if (val instanceof Number) {
                return (Number)val;
            }
            if (val instanceof String) {
                return TypeUtils.toBigDecimal((String)val);
            }
        }
        return null;
    }

    protected final String toString(List array) {
        JSONWriter writer = JSONWriter.of();
        writer.setRootObject(array);
        writer.write(array);
        return writer.toString();
    }

    protected final String toString(Map object) {
        JSONWriter writer = JSONWriter.of();
        writer.setRootObject(object);
        writer.write(object);
        return writer.toString();
    }

    public static JSONReader of(byte[] utf8Bytes) {
        return new JSONReaderUTF8(JSONFactory.createReadContext(), null, utf8Bytes, 0, utf8Bytes.length);
    }

    @Deprecated
    public static JSONReader of(Context context, byte[] utf8Bytes) {
        return new JSONReaderUTF8(context, null, utf8Bytes, 0, utf8Bytes.length);
    }

    public static JSONReader of(byte[] utf8Bytes, Context context) {
        return new JSONReaderUTF8(context, null, utf8Bytes, 0, utf8Bytes.length);
    }

    public static JSONReader of(char[] chars) {
        Context context = JSONFactory.createReadContext();
        return new JSONReaderUTF16(context, null, chars, 0, chars.length);
    }

    @Deprecated
    public static JSONReader of(Context context, char[] chars) {
        return new JSONReaderUTF16(context, null, chars, 0, chars.length);
    }

    public static JSONReader of(char[] chars, Context context) {
        return new JSONReaderUTF16(context, null, chars, 0, chars.length);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), jsonbBytes, 0, jsonbBytes.length);
    }

    @Deprecated
    public static JSONReader ofJSONB(Context context, byte[] jsonbBytes) {
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes, Context context) {
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(byte[] jsonbBytes, Feature ... features) {
        Context context = JSONFactory.createReadContext();
        context.config(features);
        return new JSONReaderJSONB(context, jsonbBytes, 0, jsonbBytes.length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(), bytes, offset, length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length, Context context) {
        return new JSONReaderJSONB(context, bytes, offset, length);
    }

    public static JSONReader ofJSONB(byte[] bytes, int offset, int length, SymbolTable symbolTable) {
        return new JSONReaderJSONB(JSONFactory.createReadContext(symbolTable), bytes, offset, length);
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Charset charset) {
        Context context = JSONFactory.createReadContext();
        if (charset == IOUtils.UTF_8) {
            return new JSONReaderUTF8(context, null, bytes, offset, length);
        }
        if (charset == IOUtils.UTF_16) {
            return new JSONReaderUTF16(context, bytes, offset, length);
        }
        if (charset == IOUtils.US_ASCII || charset == IOUtils.ISO_8859_1) {
            return new JSONReaderASCII(context, null, bytes, offset, length);
        }
        throw new JSONException("not support charset " + charset);
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Charset charset, Context context) {
        if (charset == IOUtils.UTF_8) {
            if (offset == 0 && bytes.length == length) {
                return JSONReader.of(bytes, context);
            }
            return new JSONReaderUTF8(context, null, bytes, offset, length);
        }
        if (charset == IOUtils.UTF_16) {
            return new JSONReaderUTF16(context, bytes, offset, length);
        }
        if (charset == IOUtils.US_ASCII || charset == IOUtils.ISO_8859_1) {
            return new JSONReaderASCII(context, null, bytes, offset, length);
        }
        throw new JSONException("not support charset " + charset);
    }

    public static JSONReader of(byte[] bytes, int offset, int length) {
        return new JSONReaderUTF8(JSONFactory.createReadContext(), null, bytes, offset, length);
    }

    public static JSONReader of(byte[] bytes, int offset, int length, Context context) {
        return new JSONReaderUTF8(context, null, bytes, offset, length);
    }

    public static JSONReader of(char[] chars, int offset, int length) {
        Context context = JSONFactory.createReadContext();
        return new JSONReaderUTF16(context, null, chars, offset, length);
    }

    public static JSONReader of(char[] chars, int offset, int length, Context context) {
        return new JSONReaderUTF16(context, null, chars, offset, length);
    }

    public static JSONReader of(URL url, Context context) throws IOException {
        try (InputStream is = url.openStream();){
            JSONReader jSONReader = JSONReader.of(is, IOUtils.UTF_8, context);
            return jSONReader;
        }
    }

    public static JSONReader of(InputStream is, Charset charset) {
        return JSONReader.of(is, charset, new Context(JSONFactory.defaultObjectReaderProvider));
    }

    public static JSONReader of(InputStream is, Charset charset, Context context) {
        if (charset == IOUtils.UTF_8 || charset == null) {
            return new JSONReaderUTF8(context, is);
        }
        if (charset == IOUtils.UTF_16) {
            return new JSONReaderUTF16(context, is);
        }
        throw new JSONException("not support charset " + charset);
    }

    public static JSONReader of(Reader is) {
        return new JSONReaderUTF16(JSONFactory.createReadContext(), is);
    }

    public static JSONReader of(Reader is, Context context) {
        return new JSONReaderUTF16(context, is);
    }

    public static JSONReader of(ByteBuffer buffer, Charset charset) {
        return JSONReader.of(buffer, JSONFactory.createReadContext(), charset);
    }

    public static JSONReader of(ByteBuffer buffer, Context context, Charset charset) {
        if (charset == IOUtils.UTF_8 || charset == null) {
            return new JSONReaderUTF8(context, buffer);
        }
        throw new JSONException("not support charset " + charset);
    }

    @Deprecated
    public static JSONReader of(Context context, String str) {
        return JSONReader.of(str, context);
    }

    public static JSONReader of(String str) {
        if (str == null) {
            throw new NullPointerException();
        }
        return new JSONReaderUTF16(new Context(JSONFactory.defaultObjectReaderProvider), str, 0, str.length());
    }

    public static JSONReader of(String str, Context context) {
        if (str == null || context == null) {
            throw new NullPointerException();
        }
        return new JSONReaderUTF16(context, str, 0, str.length());
    }

    public static JSONReader of(String str, int offset, int length) {
        if (str == null) {
            throw new NullPointerException();
        }
        Context context = JSONFactory.createReadContext();
        char[] chars = str.toCharArray();
        return new JSONReaderUTF16(context, str, chars, offset, length);
    }

    public static JSONReader of(String str, int offset, int length, Context context) {
        if (str == null || context == null) {
            throw new NullPointerException();
        }
        char[] chars = str.toCharArray();
        return new JSONReaderUTF16(context, str, chars, offset, length);
    }

    final void bigInt(char[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = chars[start++]) == '.') {
            c = chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = chars[index];
            if (c == '.') {
                c = chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = chars[start2++]) == '.') {
                c2 = chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = chars[index];
                if (c2 == '.') {
                    c2 = chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                long product;
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    final void bigInt(byte[] chars, int off, int len) {
        char c;
        int cursor = off;
        int numDigits = len - cursor;
        if (this.scale > 0) {
            --numDigits;
        }
        if (numDigits > 38) {
            throw new JSONException("number too large : " + new String(chars, off, numDigits));
        }
        int firstGroupLen = numDigits % 9;
        if (firstGroupLen == 0) {
            firstGroupLen = 9;
        }
        int start = cursor;
        cursor += firstGroupLen;
        int end = cursor++;
        if ((c = (char)chars[start++]) == '.') {
            c = (char)chars[start++];
        }
        int result = c - 48;
        for (int index = start; index < end; ++index) {
            c = (char)chars[index];
            if (c == '.') {
                c = (char)chars[++index];
                ++cursor;
                if (end < len) {
                    ++end;
                }
            }
            int nextVal = c - 48;
            result = 10 * result + nextVal;
        }
        this.mag3 = result;
        while (cursor < len) {
            char c2;
            int start2 = cursor;
            cursor += 9;
            int end2 = cursor++;
            if ((c2 = (char)chars[start2++]) == '.') {
                c2 = (char)chars[start2++];
                ++end2;
            }
            int result2 = c2 - 48;
            for (int index = start2; index < end2; ++index) {
                c2 = (char)chars[index];
                if (c2 == '.') {
                    c2 = (char)chars[++index];
                    ++cursor;
                    ++end2;
                }
                int nextVal = c2 - 48;
                result2 = 10 * result2 + nextVal;
            }
            int groupVal = result2;
            long ylong = 1000000000L;
            long zlong = (long)groupVal & 0xFFFFFFFFL;
            long carry = 0L;
            for (int i = 3; i >= 0; --i) {
                long product;
                switch (i) {
                    case 0: {
                        product = ylong * ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)product;
                        break;
                    }
                    case 1: {
                        product = ylong * ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)product;
                        break;
                    }
                    case 2: {
                        product = ylong * ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)product;
                        break;
                    }
                    case 3: {
                        product = ylong * ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)product;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = product >>> 32;
            }
            long sum = ((long)this.mag3 & 0xFFFFFFFFL) + zlong;
            this.mag3 = (int)sum;
            carry = sum >>> 32;
            for (int i = 2; i >= 0; --i) {
                switch (i) {
                    case 0: {
                        sum = ((long)this.mag0 & 0xFFFFFFFFL) + carry;
                        this.mag0 = (int)sum;
                        break;
                    }
                    case 1: {
                        sum = ((long)this.mag1 & 0xFFFFFFFFL) + carry;
                        this.mag1 = (int)sum;
                        break;
                    }
                    case 2: {
                        sum = ((long)this.mag2 & 0xFFFFFFFFL) + carry;
                        this.mag2 = (int)sum;
                        break;
                    }
                    case 3: {
                        sum = ((long)this.mag3 & 0xFFFFFFFFL) + carry;
                        this.mag3 = (int)sum;
                        break;
                    }
                    default: {
                        throw new ArithmeticException("BigInteger would overflow supported range");
                    }
                }
                carry = sum >>> 32;
            }
        }
    }

    public static AutoTypeBeforeHandler autoTypeFilter(String ... names) {
        return new ContextAutoTypeBeforeHandler(names);
    }

    public static AutoTypeBeforeHandler autoTypeFilter(boolean includeBasic, String ... names) {
        return new ContextAutoTypeBeforeHandler(includeBasic, names);
    }

    public static AutoTypeBeforeHandler autoTypeFilter(Class ... types) {
        return new ContextAutoTypeBeforeHandler(types);
    }

    public static AutoTypeBeforeHandler autoTypeFilter(boolean includeBasic, Class ... types) {
        return new ContextAutoTypeBeforeHandler(includeBasic, types);
    }

    public SavePoint mark() {
        return new SavePoint(this.offset, this.ch);
    }

    public void reset(SavePoint savePoint) {
        this.offset = savePoint.offset;
        this.ch = (char)savePoint.current;
    }

    public final String info() {
        return this.info(null);
    }

    public String info(String message) {
        if (message == null || message.isEmpty()) {
            return "offset " + this.offset;
        }
        return message + ", offset " + this.offset;
    }

    static boolean isFirstIdentifier(char ch) {
        return ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z' || ch == '_' || ch == '$' || ch >= '0' && ch <= '9' || ch > '\u007f';
    }

    public ObjectReader getObjectReaderAutoType(long typeHash, Class expectClass, long features) {
        Class<?> autoTypeClass;
        ObjectReader autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
        if (autoTypeObjectReader != null) {
            return autoTypeObjectReader;
        }
        String typeName = this.getString();
        if (this.context.autoTypeBeforeHandler != null && (autoTypeClass = this.context.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            boolean fieldBased = (features & Feature.FieldBased.mask) != 0L;
            return this.context.provider.getObjectReader(autoTypeClass, fieldBased);
        }
        return this.context.provider.getObjectReader(typeName, expectClass, this.context.features | features);
    }

    public Byte readInt8() {
        Integer i = this.readInt32();
        if (i == null) {
            return null;
        }
        return i.byteValue();
    }

    public byte readInt8Value() {
        int i = this.readInt32Value();
        return (byte)i;
    }

    public Short readInt16() {
        Integer i = this.readInt32();
        if (i == null) {
            return null;
        }
        return i.shortValue();
    }

    public short readInt16Value() {
        int i = this.readInt32Value();
        return (short)i;
    }

    public Character readCharacter() {
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            this.wasNull = true;
            return Character.valueOf('\u0000');
        }
        return Character.valueOf(str.charAt(0));
    }

    public final JSONArray readJSONArray() {
        JSONArray array = new JSONArray();
        this.read(array);
        return array;
    }

    public final JSONObject readJSONObject() {
        JSONObject object = new JSONObject();
        this.read(object, 0L);
        return object;
    }

    public void read(Map map, ObjectReader itemReader, long features) {
        this.nextIfObjectStart();
        long contextFeatures = features | this.context.getFeatures();
        int i = 0;
        while (true) {
            Object origin;
            if (this.ch == '/') {
                this.skipLineComment();
            }
            if (this.nextIfObjectEnd()) break;
            if (i != 0 && !this.comma) {
                throw new JSONException(this.info());
            }
            String name = this.readFieldName();
            Object value = itemReader.readObject(this, itemReader.getObjectClass(), name, features);
            if ((value != null || (contextFeatures & Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = map.put(name, value)) != null && (contextFeatures & Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                if (origin instanceof Collection) {
                    ((Collection)origin).add(value);
                    map.put(name, origin);
                } else {
                    JSONArray array = JSONArray.of(origin, value);
                    map.put(name, array);
                }
            }
            ++i;
        }
        this.nextIfComma();
    }

    public static final class Context {
        String dateFormat;
        boolean formatyyyyMMddhhmmss19;
        boolean formatyyyyMMddhhmmssT19;
        boolean yyyyMMddhhmm16;
        boolean formatyyyyMMdd8;
        boolean formatMillis;
        boolean formatUnixTime;
        boolean formatISO8601;
        boolean formatHasDay;
        boolean formatHasHour;
        boolean useSimpleFormatter;
        int maxLevel = 2048;
        int bufferSize = 524288;
        DateTimeFormatter dateFormatter;
        ZoneId zoneId;
        long features;
        Locale locale;
        TimeZone timeZone;
        Supplier<Map> objectSupplier;
        Supplier<List> arraySupplier;
        AutoTypeBeforeHandler autoTypeBeforeHandler;
        public ExtraProcessor extraProcessor;
        public final ObjectReaderProvider provider;
        protected final SymbolTable symbolTable;

        public Context(ObjectReaderProvider provider) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(ObjectReaderProvider provider, long features) {
            this.features = features;
            this.provider = provider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = JSONFactory.defaultObjectReaderProvider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public Context(String dateFormat, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = JSONFactory.defaultObjectReaderProvider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
            this.setDateFormat(dateFormat);
        }

        public Context(ObjectReaderProvider provider, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.objectSupplier = JSONFactory.defaultObjectSupplier;
            this.arraySupplier = JSONFactory.defaultArraySupplier;
            this.symbolTable = null;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.symbolTable = symbolTable;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.symbolTable = symbolTable;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable, Filter filter, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.symbolTable = symbolTable;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            this.config(filter);
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public Context(ObjectReaderProvider provider, SymbolTable symbolTable, Filter[] filters, Feature ... features) {
            this.features = JSONFactory.defaultReaderFeatures;
            this.provider = provider;
            this.symbolTable = symbolTable;
            this.zoneId = JSONFactory.defaultReaderZoneId;
            String format = JSONFactory.defaultReaderFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            this.config(filters, new Feature[0]);
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public int getBufferSize() {
            return this.bufferSize;
        }

        public void setBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
        }

        public boolean isFormatUnixTime() {
            return this.formatUnixTime;
        }

        public boolean isFormatyyyyMMddhhmmss19() {
            return this.formatyyyyMMddhhmmss19;
        }

        public boolean isFormatyyyyMMddhhmmssT19() {
            return this.formatyyyyMMddhhmmssT19;
        }

        public boolean isFormatyyyyMMdd8() {
            return this.formatyyyyMMdd8;
        }

        public boolean isFormatMillis() {
            return this.formatMillis;
        }

        public boolean isFormatISO8601() {
            return this.formatISO8601;
        }

        public boolean isFormatHasHour() {
            return this.formatHasHour;
        }

        public ObjectReader getObjectReader(Type type) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectReader(type, fieldBased);
        }

        public ObjectReaderProvider getProvider() {
            return this.provider;
        }

        public ObjectReader getObjectReaderAutoType(long hashCode) {
            return this.provider.getObjectReader(hashCode);
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass) {
            Class<?> autoTypeClass;
            if (this.autoTypeBeforeHandler != null && (autoTypeClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, this.features)) != null) {
                boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
                return this.provider.getObjectReader(autoTypeClass, fieldBased);
            }
            return this.provider.getObjectReader(typeName, expectClass, this.features);
        }

        public AutoTypeBeforeHandler getContextAutoTypeBeforeHandler() {
            return this.autoTypeBeforeHandler;
        }

        public ObjectReader getObjectReaderAutoType(String typeName, Class expectClass, long features) {
            Class<?> autoTypeClass;
            if (this.autoTypeBeforeHandler != null && (autoTypeClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
                boolean fieldBased = (features & Feature.FieldBased.mask) != 0L;
                return this.provider.getObjectReader(autoTypeClass, fieldBased);
            }
            return this.provider.getObjectReader(typeName, expectClass, this.features | features);
        }

        public ExtraProcessor getExtraProcessor() {
            return this.extraProcessor;
        }

        public void setExtraProcessor(ExtraProcessor extraProcessor) {
            this.extraProcessor = extraProcessor;
        }

        public Supplier<Map> getObjectSupplier() {
            return this.objectSupplier;
        }

        public void setObjectSupplier(Supplier<Map> objectSupplier) {
            this.objectSupplier = objectSupplier;
        }

        public Supplier<List> getArraySupplier() {
            return this.arraySupplier;
        }

        public void setArraySupplier(Supplier<List> arraySupplier) {
            this.arraySupplier = arraySupplier;
        }

        public DateTimeFormatter getDateFormatter() {
            if (!(this.dateFormatter != null || this.dateFormat == null || this.formatMillis || this.formatISO8601 || this.formatUnixTime)) {
                this.dateFormatter = this.locale == null ? DateTimeFormatter.ofPattern(this.dateFormat) : DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
            }
            return this.dateFormatter;
        }

        public void setDateFormatter(DateTimeFormatter dateFormatter) {
            this.dateFormatter = dateFormatter;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public void setDateFormat(String format) {
            if (format != null && format.isEmpty()) {
                format = null;
            }
            boolean formatUnixTime = false;
            boolean formatISO8601 = false;
            boolean formatMillis = false;
            boolean hasDay = false;
            boolean hasHour = false;
            boolean useSimpleFormatter = false;
            if (format != null) {
                switch (format) {
                    case "unixtime": {
                        formatUnixTime = true;
                        break;
                    }
                    case "iso8601": {
                        formatISO8601 = true;
                        break;
                    }
                    case "millis": {
                        formatMillis = true;
                        break;
                    }
                    case "yyyyMMddHHmmssSSSZ": {
                        useSimpleFormatter = true;
                    }
                    case "yyyy-MM-dd HH:mm:ss": 
                    case "yyyy-MM-ddTHH:mm:ss": {
                        this.formatyyyyMMddhhmmss19 = true;
                        hasDay = true;
                        hasHour = true;
                        break;
                    }
                    case "yyyy-MM-dd'T'HH:mm:ss": {
                        this.formatyyyyMMddhhmmssT19 = true;
                        hasDay = true;
                        hasHour = true;
                        break;
                    }
                    case "yyyy-MM-dd": {
                        this.formatyyyyMMdd8 = true;
                        hasDay = true;
                        hasHour = false;
                        break;
                    }
                    case "yyyy-MM-dd HH:mm": {
                        this.yyyyMMddhhmm16 = true;
                        break;
                    }
                    default: {
                        hasDay = format.indexOf(100) != -1;
                        boolean bl = hasHour = format.indexOf(72) != -1 || format.indexOf(104) != -1 || format.indexOf(75) != -1 || format.indexOf(107) != -1;
                    }
                }
            }
            if (this.dateFormat != null && !this.dateFormat.equals(format)) {
                this.dateFormatter = null;
            }
            this.dateFormat = format;
            this.formatUnixTime = formatUnixTime;
            this.formatMillis = formatMillis;
            this.formatISO8601 = formatISO8601;
            this.formatHasDay = hasDay;
            this.formatHasHour = hasHour;
            this.useSimpleFormatter = useSimpleFormatter;
        }

        public ZoneId getZoneId() {
            if (this.zoneId == null) {
                this.zoneId = ZoneId.DEFAULT_ZONE_ID;
            }
            return this.zoneId;
        }

        public long getFeatures() {
            return this.features;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public int getMaxLevel() {
            return this.maxLevel;
        }

        public void setMaxLevel(int maxLevel) {
            this.maxLevel = maxLevel;
        }

        public Locale getLocale() {
            return this.locale;
        }

        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public TimeZone getTimeZone() {
            if (this.timeZone == null) {
                this.timeZone = ZoneId.DEFAULT_TIME_ZONE;
            }
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public void config(Feature ... features) {
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public void config(Filter filter, Feature ... features) {
            if (filter instanceof AutoTypeBeforeHandler) {
                this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
            }
            if (filter instanceof ExtraProcessor) {
                this.extraProcessor = (ExtraProcessor)filter;
            }
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public void config(Filter filter) {
            if (filter instanceof AutoTypeBeforeHandler) {
                this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
            }
            if (filter instanceof ExtraProcessor) {
                this.extraProcessor = (ExtraProcessor)filter;
            }
        }

        public void config(Filter[] filters, Feature ... features) {
            int i;
            for (i = 0; i < filters.length; ++i) {
                Filter filter = filters[i];
                if (filter instanceof AutoTypeBeforeHandler) {
                    this.autoTypeBeforeHandler = (AutoTypeBeforeHandler)filter;
                }
                if (!(filter instanceof ExtraProcessor)) continue;
                this.extraProcessor = (ExtraProcessor)filter;
            }
            for (i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public boolean isEnabled(Feature feature) {
            return (this.features & feature.mask) != 0L;
        }

        public void config(Feature feature, boolean state) {
            this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }
    }

    public static enum Feature {
        FieldBased(1L),
        IgnoreNoneSerializable(2L),
        ErrorOnNoneSerializable(4L),
        SupportArrayToBean(8L),
        InitStringFieldAsEmpty(16L),
        SupportAutoType(32L),
        SupportSmartMatch(64L),
        UseNativeObject(128L),
        SupportClassForName(256L),
        IgnoreSetNullValue(512L),
        UseDefaultConstructorAsPossible(1024L),
        UseBigDecimalForFloats(2048L),
        UseBigDecimalForDoubles(4096L),
        ErrorOnEnumNotMatch(8192L),
        TrimString(16384L),
        ErrorOnNotSupportAutoType(32768L),
        DuplicateKeyValueAsArray(65536L),
        AllowUnQuotedFieldNames(131072L),
        NonStringKeyAsString(262144L),
        Base64StringAsByteArray(524288L),
        IgnoreCheckClose(0x100000L),
        ErrorOnNullForPrimitives(0x200000L),
        NullOnError(0x400000L),
        IgnoreAutoTypeNotMatch(0x800000L),
        NonZeroNumberCastToBooleanAsTrue(0x1000000L),
        IgnoreNullPropertyValue(0x2000000L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }

        public static long of(Feature[] features) {
            if (features == null) {
                return 0L;
            }
            long value = 0L;
            for (int i = 0; i < features.length; ++i) {
                value |= features[i].mask;
            }
            return value;
        }
    }

    static class ResolveTask {
        final FieldReader fieldReader;
        final Object object;
        final Object name;
        final JSONPath reference;

        ResolveTask(FieldReader fieldReader, Object object, Object name, JSONPath reference) {
            this.fieldReader = fieldReader;
            this.object = object;
            this.name = name;
            this.reference = reference;
        }

        public String toString() {
            return this.reference.toString();
        }
    }

    public static interface AutoTypeBeforeHandler
    extends Filter {
        default public Class<?> apply(long typeNameHash, Class<?> expectClass, long features) {
            return null;
        }

        public Class<?> apply(String var1, Class<?> var2, long var3);
    }

    static final class BigIntegerCreator
    implements BiFunction<Integer, int[], BigInteger> {
        static final BiFunction<Integer, int[], BigInteger> BIG_INTEGER_CREATOR = new BigIntegerCreator();

        BigIntegerCreator() {
        }

        @Override
        public BigInteger apply(Integer integer, int[] mag) {
            int bitLength;
            int signum = integer;
            if (mag.length == 0) {
                bitLength = 0;
            } else {
                int bitLengthForInt = 32 - Integer.numberOfLeadingZeros(mag[0]);
                int magBitLength = (mag.length - 1 << 5) + bitLengthForInt;
                if (signum < 0) {
                    boolean pow2 = Integer.bitCount(mag[0]) == 1;
                    for (int i = 1; i < mag.length && pow2; ++i) {
                        pow2 = mag[i] == 0;
                    }
                    bitLength = pow2 ? magBitLength - 1 : magBitLength;
                } else {
                    bitLength = magBitLength;
                }
            }
            int byteLen = bitLength / 8 + 1;
            byte[] bytes = new byte[byteLen];
            int bytesCopied = 4;
            int nextInt = 0;
            int intIndex = 0;
            for (int i = byteLen - 1; i >= 0; --i) {
                if (bytesCopied == 4) {
                    int n;
                    if ((n = intIndex++) < 0) {
                        nextInt = 0;
                    } else if (n >= mag.length) {
                        nextInt = signum < 0 ? -1 : 0;
                    } else {
                        int magInt = mag[mag.length - n - 1];
                        if (signum >= 0) {
                            nextInt = magInt;
                        } else {
                            int j;
                            int mlen = mag.length;
                            for (j = mlen - 1; j >= 0 && mag[j] == 0; --j) {
                            }
                            int firstNonzeroIntNum = mlen - j - 1;
                            nextInt = n <= firstNonzeroIntNum ? -magInt : ~magInt;
                        }
                    }
                    bytesCopied = 1;
                } else {
                    nextInt >>>= 8;
                    ++bytesCopied;
                }
                bytes[i] = (byte)nextInt;
            }
            return new BigInteger(bytes);
        }
    }

    public static class SavePoint {
        protected final int offset;
        protected final int current;

        protected SavePoint(int offset, int current) {
            this.offset = offset;
            this.current = current;
        }
    }
}

