/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.reader.ObjectReader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

public class ObjectReaderImplValue<I, T>
implements ObjectReader<T> {
    final Type valueType;
    final Class<I> valueClass;
    final long features;
    final Constructor<T> constructor;
    final Method factoryMethod;
    final Function<I, T> function;
    final Object emptyVariantArgs;
    ObjectReader valueReader;

    public ObjectReaderImplValue(Class<T> objectClass, Type valueType, Class<I> valueClass, long features, String format, Object defaultValue, Constructor<T> constructor, Method factoryMethod, Function<I, T> function) {
        Class<?>[] parameterTypes;
        this.valueType = valueType;
        this.valueClass = valueClass;
        this.features = features;
        this.constructor = constructor;
        this.factoryMethod = factoryMethod;
        this.function = function;
        if (factoryMethod != null && (parameterTypes = factoryMethod.getParameterTypes()).length == 2) {
            Class<?> varArgType = parameterTypes[1].getComponentType();
            this.emptyVariantArgs = Array.newInstance(varArgType, 0);
        } else {
            this.emptyVariantArgs = null;
        }
    }

    @Override
    public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return this.readObject(jsonReader, fieldType, fieldName, features);
    }

    @Override
    public T readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Object object;
        Object value;
        if (this.valueReader == null) {
            this.valueReader = jsonReader.getObjectReader(this.valueType);
        }
        if ((value = this.valueReader.readObject(jsonReader, fieldType, fieldName, features | this.features)) == null) {
            return null;
        }
        if (this.function != null) {
            try {
                object = this.function.apply(value);
            }
            catch (Exception ex) {
                throw new JSONException(jsonReader.info("create object error"), ex);
            }
        } else if (this.constructor != null) {
            try {
                object = this.constructor.newInstance(value);
            }
            catch (Exception ex) {
                throw new JSONException(jsonReader.info("create object error"), ex);
            }
        } else if (this.factoryMethod != null) {
            try {
                if (this.emptyVariantArgs != null) {
                    object = this.factoryMethod.invoke(null, value, this.emptyVariantArgs);
                }
                object = this.factoryMethod.invoke(null, value);
            }
            catch (Exception ex) {
                throw new JSONException(jsonReader.info("create object error"), ex);
            }
        } else {
            throw new JSONException(jsonReader.info("create object error"));
        }
        return object;
    }

    public static <I, T> ObjectReaderImplValue<I, T> of(Class<T> objectClass, Class<I> valueClass, Method method) {
        return new ObjectReaderImplValue<I, T>(objectClass, valueClass, valueClass, 0L, null, null, null, method, null);
    }

    public static <I, T> ObjectReaderImplValue<I, T> of(Class<T> objectClass, Class<I> valueClass, Function<I, T> function) {
        return new ObjectReaderImplValue<I, T>(objectClass, valueClass, valueClass, 0L, null, null, null, null, function);
    }
}

