/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONValidException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.DateTimeException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONReaderUTF8
extends JSONReader {
    protected final byte[] bytes;
    protected final int length;
    protected final int start;
    protected final int end;
    protected int nameBegin;
    protected int nameEnd;
    protected int nameLength;
    protected boolean nameAscii;
    protected int referenceBegin;
    protected final InputStream in;
    protected final JSONFactory.CacheItem cacheItem;

    JSONReaderUTF8(JSONReader.Context ctx, InputStream is) {
        super(ctx, false, true);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        int bufferSize = ctx.bufferSize;
        if (bytes == null) {
            bytes = new byte[bufferSize];
        }
        int off = 0;
        try {
            int n;
            while ((n = is.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + bufferSize);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.bytes = bytes;
        this.offset = 0;
        this.length = off;
        this.in = is;
        this.start = 0;
        this.end = this.length;
        this.next();
        while (this.ch == '/' && this.offset < this.bytes.length && this.bytes[this.offset] == 47) {
            this.skipLineComment();
        }
    }

    JSONReaderUTF8(JSONReader.Context ctx, ByteBuffer buffer) {
        super(ctx, false, true);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        int remaining = buffer.remaining();
        if (bytes == null || bytes.length < remaining) {
            bytes = new byte[remaining];
        }
        buffer.get(bytes, 0, remaining);
        this.bytes = bytes;
        this.offset = 0;
        this.length = remaining;
        this.in = null;
        this.start = 0;
        this.end = this.length;
        this.next();
        while (this.ch == '/' && this.offset < this.bytes.length && this.bytes[this.offset] == 47) {
            this.skipLineComment();
        }
    }

    JSONReaderUTF8(JSONReader.Context ctx, String str, byte[] bytes, int offset, int length) {
        super(ctx, false, true);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.in = null;
        this.start = offset;
        this.end = offset + length;
        this.cacheItem = null;
        this.next();
    }

    @Override
    public boolean nextIfMatch(char e) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char ch = this.ch;
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = '\u001a';
                continue;
            }
            ch = bytes[offset++];
        }
        if (ch != e) {
            return false;
        }
        boolean bl = this.comma = ch == ',';
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = bytes[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = bytes[offset];
        }
        if (ch >= '\u0000') {
            ++offset;
        } else {
            switch ((ch &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    byte char2 = bytes[(offset += 2) - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new JSONException("malformed input around byte " + offset);
                    }
                    ch = (ch & 0x1F) << 6 | char2 & 0x3F;
                    break;
                }
                case 14: {
                    byte char2 = bytes[(offset += 3) - 2];
                    byte char3 = bytes[offset - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new JSONException("malformed input around byte " + (offset - 1));
                    }
                    ch = (ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
                    break;
                }
                default: {
                    throw new JSONException("malformed input around byte " + offset);
                }
            }
        }
        this.offset = offset;
        this.ch = ch;
        while (this.ch == '/' && offset < bytes.length && bytes[offset] == 47) {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public boolean nextIfComma() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch != 44) {
            this.offset = offset;
            this.ch = (char)ch;
            return false;
        }
        this.comma = true;
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = bytes[offset];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = bytes[offset];
        }
        if (ch >= 0) {
            ++offset;
        } else {
            switch ((ch &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    byte char2 = bytes[(offset += 2) - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new JSONException("malformed input around byte " + offset);
                    }
                    ch = (ch & 0x1F) << 6 | char2 & 0x3F;
                    break;
                }
                case 14: {
                    byte char2 = bytes[(offset += 3) - 2];
                    byte char3 = bytes[offset - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new JSONException("malformed input around byte " + (offset - 1));
                    }
                    ch = (ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
                    break;
                }
                default: {
                    throw new JSONException("malformed input around byte " + offset);
                }
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        while (this.ch == '/' && offset < bytes.length && bytes[offset] == 47) {
            this.skipLineComment();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean nextIfArrayStart() {
        byte[] bytes;
        int offset;
        int ch;
        block10: {
            ch = this.ch;
            if (ch != 91) {
                return false;
            }
            offset = this.offset;
            if (offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            bytes = this.bytes;
            ch = bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    this.ch = (char)26;
                    this.offset = offset;
                    return true;
                }
                ch = bytes[offset++];
            }
            if (ch < 0) {
                switch ((ch &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        byte c2 = bytes[offset];
                        if ((c2 & 0xC0) != 128) break;
                        ch = (ch & 0x1F) << 6 | c2 & 0x3F;
                        ++offset;
                        break block10;
                    }
                    case 14: {
                        byte c2 = bytes[offset];
                        byte c3 = bytes[offset + 1];
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) break;
                        ch = (ch & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                        offset += 2;
                        break block10;
                    }
                }
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        while (this.ch == '/' && this.offset < bytes.length && bytes[this.offset] == 47) {
            this.skipLineComment();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean nextIfArrayEnd() {
        byte[] bytes;
        int offset;
        int ch;
        block14: {
            ch = this.ch;
            if (ch == 125 || ch == 26) {
                throw new JSONException(this.info("Illegal syntax: `" + (char)ch + '`'));
            }
            if (ch != 93) {
                return false;
            }
            offset = this.offset;
            if (offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            bytes = this.bytes;
            ch = bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    this.ch = (char)26;
                    this.offset = offset;
                    return true;
                }
                ch = bytes[offset++];
            }
            if (ch == 44) {
                this.comma = true;
                ch = bytes[offset++];
                while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (offset >= this.end) {
                        this.ch = (char)26;
                        this.offset = offset;
                        return true;
                    }
                    ch = bytes[offset++];
                }
            }
            if (ch < 0) {
                switch ((ch &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        byte c2 = bytes[offset];
                        if ((c2 & 0xC0) != 128) break;
                        ch = (ch & 0x1F) << 6 | c2 & 0x3F;
                        ++offset;
                        break block14;
                    }
                    case 14: {
                        byte c2 = bytes[offset];
                        byte c3 = bytes[offset + 1];
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) break;
                        ch = (ch & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                        offset += 2;
                        break block14;
                    }
                }
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        while (this.ch == '/' && this.offset < bytes.length && bytes[this.offset] == 47) {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfSet() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 83 && offset + 1 < this.end && bytes[offset] == 101 && bytes[offset + 1] == 116) {
            if ((offset += 2) >= this.end) {
                ch = 26;
            } else {
                ch = bytes[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (offset == this.end) {
                        ch = 26;
                        break;
                    }
                    ch = bytes[offset++];
                }
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextIfInfinity() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 73 && offset + 6 < this.end && bytes[offset] == 110 && bytes[offset + 1] == 102 && bytes[offset + 2] == 105 && bytes[offset + 3] == 110 && bytes[offset + 4] == 105 && bytes[offset + 5] == 116 && bytes[offset + 6] == 121) {
            if ((offset += 7) >= this.end) {
                ch = 26;
            } else {
                ch = bytes[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (offset == this.end) {
                        ch = 26;
                        break;
                    }
                    ch = bytes[offset++];
                }
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean nextIfObjectStart() {
        byte[] bytes;
        int offset;
        int ch;
        block10: {
            ch = this.ch;
            if (ch != 123) {
                return false;
            }
            offset = this.offset;
            if (offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            bytes = this.bytes;
            ch = bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    this.ch = (char)26;
                    this.offset = offset;
                    return true;
                }
                ch = bytes[offset++];
            }
            if (ch < 0) {
                switch ((ch &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        byte c2 = bytes[offset];
                        if ((c2 & 0xC0) != 128) break;
                        ch = (ch & 0x1F) << 6 | c2 & 0x3F;
                        ++offset;
                        break block10;
                    }
                    case 14: {
                        byte c2 = bytes[offset];
                        byte c3 = bytes[offset + 1];
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) break;
                        ch = (ch & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                        offset += 2;
                        break block10;
                    }
                }
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        while (this.ch == '/' && this.offset < bytes.length && bytes[this.offset] == 47) {
            this.skipLineComment();
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean nextIfObjectEnd() {
        byte[] bytes;
        int offset;
        int ch;
        block14: {
            ch = this.ch;
            if (ch == 93 || ch == 26) {
                throw new JSONException(this.info("Illegal syntax: `" + (char)ch + '`'));
            }
            if (ch != 125) {
                return false;
            }
            offset = this.offset;
            if (offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            bytes = this.bytes;
            ch = bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    this.ch = (char)26;
                    this.offset = offset;
                    return true;
                }
                ch = bytes[offset++];
            }
            if (ch == 44) {
                this.comma = true;
                ch = bytes[offset++];
                while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (offset >= this.end) {
                        this.ch = (char)26;
                        this.offset = offset;
                        return true;
                    }
                    ch = bytes[offset++];
                }
            }
            if (ch < 0) {
                switch ((ch &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        byte c2 = bytes[offset];
                        if ((c2 & 0xC0) != 128) break;
                        ch = (ch & 0x1F) << 6 | c2 & 0x3F;
                        ++offset;
                        break block14;
                    }
                    case 14: {
                        byte c2 = bytes[offset];
                        byte c3 = bytes[offset + 1];
                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) break;
                        ch = (ch & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                        offset += 2;
                        break block14;
                    }
                }
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        while (this.ch == '/' && this.offset < bytes.length && bytes[this.offset] == 47) {
            this.skipLineComment();
        }
        return true;
    }

    @Override
    public void next() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        int ch = bytes[offset];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            ch = bytes[offset];
        }
        if (ch >= 0) {
            this.offset = offset + 1;
            this.ch = (char)ch;
            while (this.ch == '/' && this.offset < bytes.length && bytes[this.offset] == 47) {
                this.skipLineComment();
            }
            return;
        }
        switch ((ch &= 0xFF) >> 4) {
            case 12: 
            case 13: {
                byte char2 = bytes[(offset += 2) - 1];
                if ((char2 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + offset);
                }
                ch = (ch & 0x1F) << 6 | char2 & 0x3F;
                break;
            }
            case 14: {
                byte char2 = bytes[(offset += 3) - 2];
                byte char3 = bytes[offset - 1];
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + (offset - 1));
                }
                ch = (ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
                break;
            }
            default: {
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        while (this.ch == '/' && this.offset < bytes.length && bytes[this.offset] == 47) {
            this.skipLineComment();
        }
    }

    @Override
    public final long readFieldNameHashCodeUnquote() {
        long hashCode;
        this.nameEscape = false;
        this.nameBegin = this.offset - 1;
        char first = this.ch;
        long nameValue = 0L;
        int i = 0;
        block26: while (this.offset <= this.end) {
            switch (this.ch) {
                case '\b': 
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case '\u001a': 
                case ' ': 
                case '!': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case '<': 
                case '=': 
                case '>': 
                case '[': 
                case ']': 
                case '{': 
                case '}': {
                    this.nameLength = i;
                    this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        this.next();
                    }
                    break block26;
                }
                default: {
                    if (this.ch == '\\') {
                        this.nameEscape = true;
                        this.ch = (char)this.bytes[this.offset++];
                        switch (this.ch) {
                            case 'u': {
                                byte c1 = this.bytes[this.offset++];
                                byte c2 = this.bytes[this.offset++];
                                byte c3 = this.bytes[this.offset++];
                                byte c4 = this.bytes[this.offset++];
                                this.ch = JSONReaderUTF8.char4(c1, c2, c3, c4);
                                break;
                            }
                            case 'x': {
                                byte c1 = this.bytes[this.offset++];
                                byte c2 = this.bytes[this.offset++];
                                this.ch = JSONReaderUTF8.char2(c1, c2);
                                break;
                            }
                            case '\"': 
                            case '*': 
                            case '+': 
                            case '-': 
                            case '.': 
                            case '/': 
                            case ':': 
                            case '<': 
                            case '=': 
                            case '>': 
                            case '@': 
                            case '\\': {
                                break;
                            }
                            default: {
                                this.ch = this.char1(this.ch);
                            }
                        }
                    }
                    if (this.ch > '\u007f' || i >= 8 || i == 0 && this.ch == '\u0000') {
                        nameValue = 0L;
                        this.ch = first;
                        this.offset = this.nameBegin + 1;
                        break block26;
                    }
                    byte c = (byte)this.ch;
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    this.ch = (char)(this.offset >= this.end ? 26 : (char)this.bytes[this.offset++]);
                    ++i;
                    continue block26;
                }
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            block28: while (true) {
                if (this.ch == '\\') {
                    this.nameEscape = true;
                    this.ch = (char)this.bytes[this.offset++];
                    switch (this.ch) {
                        case 'u': {
                            char c1 = (char)this.bytes[this.offset++];
                            char c2 = (char)this.bytes[this.offset++];
                            char c3 = (char)this.bytes[this.offset++];
                            char c4 = (char)this.bytes[this.offset++];
                            this.ch = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            char c1 = (char)this.bytes[this.offset++];
                            char c2 = (char)this.bytes[this.offset++];
                            this.ch = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '@': 
                        case '\\': {
                            break;
                        }
                        default: {
                            this.ch = this.char1(this.ch);
                        }
                    }
                    hashCode ^= (long)this.ch;
                    hashCode *= 1099511628211L;
                    this.next();
                } else {
                    switch (this.ch) {
                        case '\b': 
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case '\u001a': 
                        case ' ': 
                        case '!': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case ',': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '[': 
                        case ']': 
                        case '{': 
                        case '}': {
                            this.nameLength = i2;
                            this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                                this.next();
                            }
                            break block28;
                        }
                        default: {
                            hashCode ^= (long)this.ch;
                            hashCode *= 1099511628211L;
                            this.ch = (char)(this.offset >= this.end ? 26 : (char)this.bytes[this.offset++]);
                        }
                    }
                }
                ++i2;
            }
        }
        if (this.ch == ':') {
            this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        return hashCode;
    }

    @Override
    public final int getRawInt() {
        if (this.offset + 3 < this.bytes.length) {
            return JDKUtils.UNSAFE.getInt(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset - 1L);
        }
        return 0;
    }

    @Override
    public final long getRawLong() {
        if (this.offset + 8 < this.bytes.length) {
            return JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset - 1L);
        }
        return 0L;
    }

    @Override
    public final boolean nextIfName8Match2() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 9) >= this.end) {
            return false;
        }
        if (bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName8Match1() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 8) >= this.end) {
            return false;
        }
        if (bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName8Match0() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 7) == this.end) {
            this.ch = (char)26;
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match2() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 4) >= this.end) {
            return false;
        }
        if (bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match3() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 5) >= this.end) {
            return false;
        }
        if (bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match4(byte c4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 6) >= this.end) {
            return false;
        }
        if (bytes[offset - 3] != c4 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match5(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 7) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name1) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match6(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 8) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name1 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match7(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 9) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name1 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match8(int name1, byte c8) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 10) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name1 || bytes[offset - 3] != c8 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match9(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 11) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name1) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match10(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 12) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name1 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match11(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 13) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name1 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match12(long name1, byte c12) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 14) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name1 || bytes[offset - 3] != c12 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match13(long name1, int name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 15) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name2) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match14(long name1, int name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 16) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name2 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match15(long name1, int name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 17) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name2 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match16(long name1, int name2, byte c16) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 18) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name1 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name2 || bytes[offset - 3] != c16 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match17(long name1, long name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 19) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name2) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match18(long name1, long name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 20) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name2 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match19(long name1, long name2) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 21) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name2 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match20(long name1, long name2, byte c20) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 22) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 19L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name2 || bytes[offset - 3] != c20 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match21(long name1, long name2, int name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 23) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 20L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name3) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match22(long name1, long name2, int name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 24) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 21L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name3 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match23(long name1, long name2, int name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 25) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 22L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name3 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match24(long name1, long name2, int name3, byte c24) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 26) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 23L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name2 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name3 || bytes[offset - 3] != c24 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match25(long name1, long name2, long name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 27) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 24L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name3) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match26(long name1, long name2, long name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 28) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 25L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name3 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match27(long name1, long name2, long name3) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 29) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 26L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name3 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match28(long name1, long name2, long name3, byte c29) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 30) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 27L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 19L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name3 || bytes[offset - 3] != c29 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match29(long name1, long name2, long name3, int name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 31) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 28L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 20L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name4) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match30(long name1, long name2, long name3, int name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 32) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 29L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 21L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name4 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match31(long name1, long name2, long name3, int name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 33) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 30L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 22L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name4 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match32(long name1, long name2, long name3, int name4, byte c32) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 34) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 31L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 23L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name3 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name4 || bytes[offset - 3] != c32 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match33(long name1, long name2, long name3, long name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 35) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 32L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 24L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name4) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match34(long name1, long name2, long name3, long name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 36) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 33L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 25L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name4 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match35(long name1, long name2, long name3, long name4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 37) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 34L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 26L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name4 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match36(long name1, long name2, long name3, long name4, byte c36) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 38) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 35L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 27L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 19L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 11L) != name4 || bytes[offset - 3] != c36 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match37(long name1, long name2, long name3, long name4, int name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 39) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 36L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 28L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 20L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 12L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name5) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match38(long name1, long name2, long name3, long name4, int name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 40) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 37L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 29L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 21L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 13L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name5 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match39(long name1, long name2, long name3, long name4, int name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 41) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 38L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 30L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 22L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 14L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name5 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match40(long name1, long name2, long name3, long name4, int name5, byte c40) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 42) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 39L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 31L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 23L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 15L) != name4 || JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name5 || bytes[offset - 3] != c40 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match41(long name1, long name2, long name3, long name4, long name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 43) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 40L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 32L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 24L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 16L) != name4 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name5) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match42(long name1, long name2, long name3, long name4, long name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 44) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 41L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 33L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 25L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 17L) != name4 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name5 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfName4Match43(long name1, long name2, long name3, long name4, long name5) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 45) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 42L) != name1 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 34L) != name2 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 26L) != name3 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 18L) != name4 || JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 10L) != name5 || bytes[offset - 2] != 34 || bytes[offset - 1] != 58) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match2() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 3) >= this.end) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match3() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 4) >= this.end) {
            return false;
        }
        if (bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match4(byte c4) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 5) >= this.end) {
            return false;
        }
        if (bytes[offset - 2] != c4 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match5(byte c4, byte c5) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 6) >= this.end) {
            return false;
        }
        if (bytes[offset - 3] != c4 || bytes[offset - 2] != c5 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match6(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 7) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 4L) != name1) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match7(int name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 8) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 5L) != name1 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match8(int name1, byte c8) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 9) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 6L) != name1 || bytes[offset - 2] != c8 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match9(int name1, byte c8, byte c9) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 10) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 7L) != name1 || bytes[offset - 3] != c8 || bytes[offset - 2] != c9 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match10(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 11) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 8L) != name1) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final boolean nextIfValue4Match11(long name1) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((offset += 12) >= this.end) {
            return false;
        }
        if (JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset - 9L) != name1 || bytes[offset - 1] != 34) {
            return false;
        }
        int c = bytes[offset] & 0xFF;
        if (c != 44 && c != 125 && c != 93) {
            return false;
        }
        if (c == 44) {
            this.comma = true;
            int n = c = ++offset == this.end ? 26 : bytes[offset] & 0xFF;
        }
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset] & 0xFF;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public long readFieldNameHashCode() {
        long hashCode;
        byte[] bytes = this.bytes;
        if (this.ch != '\"' && this.ch != '\'') {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF8.isFirstIdentifier(this.ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            String errorMsg = this.ch == '[' && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + this.ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + this.ch;
            throw new JSONException(this.info(errorMsg));
        }
        char quote = this.ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (offset + 9 < this.end) {
            byte c0 = bytes[offset];
            if (c0 == quote) {
                nameValue = 0L;
            } else {
                byte c1 = bytes[offset + 1];
                if (c1 == quote && c0 != 92 && c0 > 0) {
                    nameValue = c0;
                    this.nameLength = 1;
                    this.nameEnd = offset + 1;
                    offset += 2;
                } else {
                    byte c2 = bytes[offset + 2];
                    if (c2 == quote && c0 != 92 && c1 != 92 && c0 >= 0 && c1 > 0) {
                        nameValue = (c1 << 8) + c0;
                        this.nameLength = 2;
                        this.nameEnd = offset + 2;
                        offset += 3;
                    } else {
                        byte c3 = bytes[offset + 3];
                        if (c3 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c0 >= 0 && c1 >= 0 && c2 > 0) {
                            nameValue = (c2 << 16) + (c1 << 8) + c0;
                            this.nameLength = 3;
                            this.nameEnd = offset + 3;
                            offset += 4;
                        } else {
                            byte c4 = bytes[offset + 4];
                            if (c4 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 > 0) {
                                nameValue = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                                this.nameLength = 4;
                                this.nameEnd = offset + 4;
                                offset += 5;
                            } else {
                                byte c5 = bytes[offset + 5];
                                if (c5 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 > 0) {
                                    nameValue = ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                    this.nameLength = 5;
                                    this.nameEnd = offset + 5;
                                    offset += 6;
                                } else {
                                    byte c6 = bytes[offset + 6];
                                    if (c6 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 > 0) {
                                        nameValue = ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                        this.nameLength = 6;
                                        this.nameEnd = offset + 6;
                                        offset += 7;
                                    } else {
                                        byte c7 = bytes[offset + 7];
                                        if (c7 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 > 0) {
                                            nameValue = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 7;
                                            this.nameEnd = offset + 7;
                                            offset += 8;
                                        } else if (bytes[offset + 8] == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c7 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 >= 0 && c7 > 0) {
                                            nameValue = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 8;
                                            this.nameEnd = offset + 8;
                                            offset += 9;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (nameValue == 0L) {
            int i = 0;
            while (offset < this.end) {
                byte c1;
                char c = bytes[offset];
                if (c == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c == '\\') {
                    this.nameEscape = true;
                    c = bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c1 = bytes[++offset];
                            byte c2 = bytes[++offset];
                            byte c3 = bytes[++offset];
                            byte c4 = bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            c1 = bytes[++offset];
                            byte c2 = bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    if (c > '\u00ff') {
                        this.nameAscii = false;
                    }
                } else if (c == '\uffffffc3' || c == '\uffffffc2') {
                    c1 = bytes[++offset];
                    c = (char)((c & 0x1F) << 6 | c1 & 0x3F);
                    this.nameAscii = false;
                }
                if (c > '\u00ff' || c < '\u0000' || i >= 8 || i == 0 && c == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                int c;
                if ((c = bytes[offset]) == 92) {
                    this.nameEscape = true;
                    c = bytes[++offset];
                    switch (c) {
                        case 117: {
                            byte c1 = bytes[++offset];
                            byte c2 = bytes[++offset];
                            byte c3 = bytes[++offset];
                            byte c4 = bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 120: {
                            byte c1 = bytes[++offset];
                            byte c2 = bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                } else {
                    if (c == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    if (c >= 0) {
                        ++offset;
                    } else {
                        switch ((c &= 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                byte c2 = bytes[offset + 1];
                                if ((c2 & 0xC0) != 128) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                offset += 2;
                                this.nameAscii = false;
                                break;
                            }
                            case 14: {
                                byte c2 = bytes[offset + 1];
                                byte c3 = bytes[offset + 2];
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                offset += 3;
                                this.nameAscii = false;
                                break;
                            }
                            default: {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int c = bytes[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset];
        }
        if (c != 58) {
            throw new JSONException(this.info("expect ':', but " + c));
        }
        c = ++offset == this.end ? 26 : bytes[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long readValueHashCode() {
        long hashCode;
        int offset;
        block39: {
            block38: {
                if (this.ch != '\"' && this.ch != '\'') {
                    throw new JSONException(this.info("illegal character " + this.ch));
                }
                char quote = this.ch;
                this.nameAscii = true;
                this.nameEscape = false;
                offset = this.nameBegin = this.offset;
                long nameValue = 0L;
                int i = 0;
                while (offset < this.end) {
                    byte c1;
                    char c = this.bytes[offset];
                    if (c == quote) {
                        if (i == 0) {
                            nameValue = 0L;
                            offset = this.nameBegin;
                            break;
                        }
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    if (c == '\\') {
                        this.nameEscape = true;
                        c = this.bytes[++offset];
                        switch (c) {
                            case 'u': {
                                c1 = this.bytes[++offset];
                                byte c2 = this.bytes[++offset];
                                byte c3 = this.bytes[++offset];
                                byte c4 = this.bytes[++offset];
                                c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                                break;
                            }
                            case 'x': {
                                c1 = this.bytes[++offset];
                                byte c2 = this.bytes[++offset];
                                c = JSONReaderUTF8.char2(c1, c2);
                                break;
                            }
                            default: {
                                c = this.char1(c);
                                break;
                            }
                        }
                    } else if (c == '\uffffffc3' || c == '\uffffffc2') {
                        c1 = this.bytes[++offset];
                        c = (char)((c & 0x1F) << 6 | c1 & 0x3F);
                    }
                    if (c > '\u00ff' || c < '\u0000' || i >= 8 || i == 0 && c == '\u0000') {
                        nameValue = 0L;
                        offset = this.nameBegin;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = (byte)c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++offset;
                    ++i;
                }
                if (nameValue == 0L) break block38;
                hashCode = nameValue;
                break block39;
            }
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                block41: {
                    char c;
                    block43: {
                        block42: {
                            block40: {
                                if ((c = this.bytes[offset]) != '\\') break block40;
                                this.nameEscape = true;
                                c = this.bytes[++offset];
                                switch (c) {
                                    case 'u': {
                                        byte c1 = this.bytes[++offset];
                                        byte c2 = this.bytes[++offset];
                                        byte c3 = this.bytes[++offset];
                                        byte c4 = this.bytes[++offset];
                                        c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                                        break;
                                    }
                                    case 'x': {
                                        byte c1 = this.bytes[++offset];
                                        byte c2 = this.bytes[++offset];
                                        c = JSONReaderUTF8.char2(c1, c2);
                                        break;
                                    }
                                    default: {
                                        c = this.char1(c);
                                    }
                                }
                                ++offset;
                                hashCode ^= (long)c;
                                hashCode *= 1099511628211L;
                                break block41;
                            }
                            if (c == '\"') {
                                this.nameLength = i;
                                this.nameEnd = offset++;
                                break;
                            }
                            if (c < '\u0000') break block42;
                            ++offset;
                            break block43;
                        }
                        switch ((c & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                byte c2 = this.bytes[offset + 1];
                                if ((c2 & 0xC0) != 128) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                offset += 2;
                                this.nameAscii = false;
                                break;
                            }
                            case 14: {
                                byte c2 = this.bytes[offset + 1];
                                byte c3 = this.bytes[offset + 2];
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                offset += 3;
                                this.nameAscii = false;
                                break;
                            }
                            default: {
                                if (c >> 3 != -2) throw new JSONException("malformed input around byte " + offset);
                                int n = ++offset;
                                byte c2 = this.bytes[n];
                                int n2 = ++offset;
                                byte c3 = this.bytes[n2];
                                int n3 = ++offset;
                                ++offset;
                                byte c4 = this.bytes[n3];
                                int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                char x1 = (char)((uc >>> 10) + 55232);
                                char x2 = (char)((uc & 0x3FF) + 56320);
                                hashCode ^= (long)x1;
                                hashCode *= 1099511628211L;
                                hashCode ^= (long)x2;
                                hashCode *= 1099511628211L;
                                ++i;
                                break block41;
                            }
                        }
                    }
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int c = offset == this.end ? 26 : this.bytes[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = this.bytes[++offset];
        }
        this.comma = c == 44;
        if (this.comma) {
            c = ++offset == this.end ? 26 : this.bytes[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = this.bytes[++offset];
            }
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        byte c1;
        char c;
        int offset;
        long hashCode = -3750763034362895579L;
        long nameValue = 0L;
        int i = 0;
        for (offset = this.nameBegin; offset < this.end; ++offset) {
            c = this.bytes[offset];
            if (c == '\\') {
                c = this.bytes[++offset];
                switch (c) {
                    case 'u': {
                        c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderUTF8.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\uffffffc3' || c == '\uffffffc2') {
                c1 = this.bytes[++offset];
                c = (char)((c & 0x1F) << 6 | c1 & 0x3F);
            } else if (c == '\"') break;
            if (i >= 8 || c > '\u00ff' || c < '\u0000' || i == 0 && c == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            if ((c == '_' || c == '-' || c == ' ') && (c1 = this.bytes[offset + 1]) != 34 && c1 != 39 && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)c;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        if (this.nameAscii && !this.nameEscape) {
            for (i = this.nameBegin; i < this.nameEnd; ++i) {
                c = (char)this.bytes[i];
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if ((c == '_' || c == '-' || c == ' ') && (c1 = this.bytes[i + 1]) != 34 && c1 != 39 && c1 != c) continue;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            return hashCode;
        }
        while (true) {
            char c2;
            if ((c2 = this.bytes[offset]) == '\\') {
                c2 = (char)this.bytes[++offset];
                switch (c2) {
                    case 'u': {
                        byte c12 = this.bytes[++offset];
                        byte c22 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c2 = JSONReaderUTF8.char4(c12, c22, c3, c4);
                        break;
                    }
                    case 'x': {
                        byte c12 = this.bytes[++offset];
                        byte c22 = this.bytes[++offset];
                        c2 = JSONReaderUTF8.char2(c12, c22);
                        break;
                    }
                    default: {
                        c2 = this.char1(c2);
                    }
                }
                ++offset;
            } else {
                if (c2 == '\"') break;
                if (c2 >= '\u0000') {
                    if (c2 >= 'A' && c2 <= 'Z') {
                        c2 = (char)(c2 + 32);
                    }
                    ++offset;
                } else {
                    c2 = (char)(c2 & 0xFF);
                    switch (c2 >> 4) {
                        case 12: 
                        case 13: {
                            byte c23 = this.bytes[offset + 1];
                            c2 = (char)((c2 & 0x1F) << 6 | c23 & 0x3F);
                            offset += 2;
                            break;
                        }
                        case 14: {
                            byte c23 = this.bytes[offset + 1];
                            byte c3 = this.bytes[offset + 2];
                            c2 = (char)((c2 & 0xF) << 12 | (c23 & 0x3F) << 6 | c3 & 0x3F);
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
            }
            if (c2 == '_' || c2 == '-' || c2 == ' ') continue;
            hashCode ^= (long)c2;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            if (this.nameAscii) {
                if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                    char[] chars = new char[length];
                    for (int i = 0; i < length; ++i) {
                        chars[i] = (char)this.bytes[this.nameBegin + i];
                    }
                    return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                }
                if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                    byte[] bytes = Arrays.copyOfRange(this.bytes, this.nameBegin, this.nameEnd);
                    return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
                }
            }
            return new String(this.bytes, this.nameBegin, length, this.nameAscii ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            int c = this.bytes[offset];
            if (c < 0) {
                switch ((c &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        byte char2 = this.bytes[offset + 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                        c = (c & 0x1F) << 6 | char2 & 0x3F;
                        offset += 2;
                        break;
                    }
                    case 14: {
                        byte char2 = this.bytes[offset + 1];
                        byte char3 = this.bytes[offset + 2];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new JSONException("malformed input around byte " + (offset + 2));
                        }
                        c = (c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
                        offset += 3;
                        break;
                    }
                    default: {
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
                chars[i] = (char)c;
            } else {
                if (c == 92) {
                    c = (char)this.bytes[++offset];
                    switch (c) {
                        case 117: {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 120: {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == 34) break;
                chars[i] = (char)c;
                ++offset;
            }
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        if (this.ch != '\"' && this.ch != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF8.isFirstIdentifier(this.ch)) {
                return this.readFieldNameUnquote();
            }
            return null;
        }
        char quote = this.ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (offset < this.end) {
            int c = this.bytes[offset];
            if (c == 92) {
                this.nameEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = this.bytes[offset] & 0xFF;
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset] & 0xFF;
                    }
                    if (c != 58) {
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = ++offset == this.end ? 26 : this.bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    this.offset = offset + 1;
                    this.ch = (char)c;
                    break;
                }
                if (c >= 0) {
                    ++offset;
                } else {
                    if (this.nameAscii) {
                        this.nameAscii = false;
                    }
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            offset += 2;
                            break;
                        }
                        case 14: {
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.nameEnd < this.nameBegin) {
            throw new JSONException("syntax error : " + offset);
        }
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            if (this.nameAscii) {
                long nameValue0 = -1L;
                long nameValue1 = -1L;
                switch (length) {
                    case 1: {
                        return TypeUtils.toString((char)(this.bytes[this.nameBegin] & 0xFF));
                    }
                    case 2: {
                        return TypeUtils.toString((char)(this.bytes[this.nameBegin] & 0xFF), (char)(this.bytes[this.nameBegin + 1] & 0xFF));
                    }
                    case 3: {
                        nameValue0 = (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                        break;
                    }
                    case 4: {
                        nameValue0 = (this.bytes[this.nameBegin + 3] << 24) + (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                        break;
                    }
                    case 5: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        break;
                    }
                    case 6: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 5] << 40) + ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        break;
                    }
                    case 7: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 6] << 48) + ((long)this.bytes[this.nameBegin + 5] << 40) + ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        break;
                    }
                    case 8: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 7] << 56) + ((long)this.bytes[this.nameBegin + 6] << 48) + ((long)this.bytes[this.nameBegin + 5] << 40) + ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        break;
                    }
                    case 9: {
                        nameValue0 = this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 8] << 56) + ((long)this.bytes[this.nameBegin + 7] << 48) + ((long)this.bytes[this.nameBegin + 6] << 40) + ((long)this.bytes[this.nameBegin + 5] << 32) + ((long)this.bytes[this.nameBegin + 4] << 24) + ((long)this.bytes[this.nameBegin + 3] << 16) + ((long)this.bytes[this.nameBegin + 2] << 8) + (long)this.bytes[this.nameBegin + 1];
                        break;
                    }
                    case 10: {
                        nameValue0 = (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 9] << 56) + ((long)this.bytes[this.nameBegin + 8] << 48) + ((long)this.bytes[this.nameBegin + 7] << 40) + ((long)this.bytes[this.nameBegin + 6] << 32) + ((long)this.bytes[this.nameBegin + 5] << 24) + ((long)this.bytes[this.nameBegin + 4] << 16) + ((long)this.bytes[this.nameBegin + 3] << 8) + (long)this.bytes[this.nameBegin + 2];
                        break;
                    }
                    case 11: {
                        nameValue0 = (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 10] << 56) + ((long)this.bytes[this.nameBegin + 9] << 48) + ((long)this.bytes[this.nameBegin + 8] << 40) + ((long)this.bytes[this.nameBegin + 7] << 32) + ((long)this.bytes[this.nameBegin + 6] << 24) + ((long)this.bytes[this.nameBegin + 5] << 16) + ((long)this.bytes[this.nameBegin + 4] << 8) + (long)this.bytes[this.nameBegin + 3];
                        break;
                    }
                    case 12: {
                        nameValue0 = (this.bytes[this.nameBegin + 3] << 24) + (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 11] << 56) + ((long)this.bytes[this.nameBegin + 10] << 48) + ((long)this.bytes[this.nameBegin + 9] << 40) + ((long)this.bytes[this.nameBegin + 8] << 32) + ((long)this.bytes[this.nameBegin + 7] << 24) + ((long)this.bytes[this.nameBegin + 6] << 16) + ((long)this.bytes[this.nameBegin + 5] << 8) + (long)this.bytes[this.nameBegin + 4];
                        break;
                    }
                    case 13: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 12] << 56) + ((long)this.bytes[this.nameBegin + 11] << 48) + ((long)this.bytes[this.nameBegin + 10] << 40) + ((long)this.bytes[this.nameBegin + 9] << 32) + ((long)this.bytes[this.nameBegin + 8] << 24) + ((long)this.bytes[this.nameBegin + 7] << 16) + ((long)this.bytes[this.nameBegin + 6] << 8) + (long)this.bytes[this.nameBegin + 5];
                        break;
                    }
                    case 14: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 5] << 40) + ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 13] << 56) + ((long)this.bytes[this.nameBegin + 12] << 48) + ((long)this.bytes[this.nameBegin + 11] << 40) + ((long)this.bytes[this.nameBegin + 10] << 32) + ((long)this.bytes[this.nameBegin + 9] << 24) + ((long)this.bytes[this.nameBegin + 8] << 16) + ((long)this.bytes[this.nameBegin + 8] << 8) + (long)this.bytes[this.nameBegin + 6];
                        break;
                    }
                    case 15: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 6] << 48) + ((long)this.bytes[this.nameBegin + 5] << 40) + ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 14] << 56) + ((long)this.bytes[this.nameBegin + 13] << 48) + ((long)this.bytes[this.nameBegin + 12] << 40) + ((long)this.bytes[this.nameBegin + 11] << 32) + ((long)this.bytes[this.nameBegin + 10] << 24) + ((long)this.bytes[this.nameBegin + 9] << 16) + ((long)this.bytes[this.nameBegin + 8] << 8) + (long)this.bytes[this.nameBegin + 7];
                        break;
                    }
                    case 16: {
                        nameValue0 = ((long)this.bytes[this.nameBegin + 7] << 56) + ((long)this.bytes[this.nameBegin + 6] << 48) + ((long)this.bytes[this.nameBegin + 5] << 40) + ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                        nameValue1 = ((long)this.bytes[this.nameBegin + 15] << 56) + ((long)this.bytes[this.nameBegin + 14] << 48) + ((long)this.bytes[this.nameBegin + 13] << 40) + ((long)this.bytes[this.nameBegin + 12] << 32) + ((long)this.bytes[this.nameBegin + 11] << 24) + ((long)this.bytes[this.nameBegin + 10] << 16) + ((long)this.bytes[this.nameBegin + 9] << 8) + (long)this.bytes[this.nameBegin + 8];
                        break;
                    }
                }
                if (nameValue0 != -1L) {
                    if (nameValue1 != -1L) {
                        long nameValue01 = nameValue0 ^ nameValue1;
                        int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                        JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                        if (entry == null) {
                            String name;
                            if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                                char[] chars = new char[length];
                                for (int i2 = 0; i2 < length; ++i2) {
                                    chars[i2] = (char)this.bytes[this.nameBegin + i2];
                                }
                                name = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                            } else {
                                name = new String(this.bytes, this.nameBegin, length, StandardCharsets.ISO_8859_1);
                            }
                            JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                            return name;
                        }
                        if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                            return entry.name;
                        }
                    } else {
                        int indexMask = (int)(nameValue0 ^ nameValue0 >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                        JSONFactory.NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                        if (entry == null) {
                            String name;
                            if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                                char[] chars = new char[length];
                                for (int i3 = 0; i3 < length; ++i3) {
                                    chars[i3] = (char)this.bytes[this.nameBegin + i3];
                                }
                                name = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                            } else {
                                name = new String(this.bytes, this.nameBegin, length, StandardCharsets.ISO_8859_1);
                            }
                            JSONFactory.NAME_CACHE[indexMask] = new JSONFactory.NameCacheEntry(name, nameValue0);
                            return name;
                        }
                        if (entry.value == nameValue0) {
                            return entry.name;
                        }
                    }
                }
                if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                    char[] chars = new char[length];
                    for (int i4 = 0; i4 < length; ++i4) {
                        chars[i4] = (char)this.bytes[this.nameBegin + i4];
                    }
                    return JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                }
                if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                    byte[] bytes = Arrays.copyOfRange(this.bytes, this.nameBegin, this.nameEnd);
                    return JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
                }
            }
            return new String(this.bytes, this.nameBegin, length, this.nameAscii ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
        }
        return this.getFieldName();
    }

    @Override
    public final int readInt32Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        byte[] bytes = this.bytes;
        int intValue = 0;
        char quote = '\u0000';
        if (firstChar == '\"' || firstChar == '\'') {
            quote = this.ch;
            this.ch = (char)bytes[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)bytes[this.offset++];
        } else if (this.ch == '+') {
            this.ch = (char)bytes[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = (char)bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.intValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("int overflow, value " + bigInteger);
                }
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : (char)bytes[this.offset++]);
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : (char)bytes[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)bytes[this.offset++];
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public final Integer readInt32() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                if (this.offset == this.end) {
                    this.ch = (char)26;
                } else {
                    this.ch = (char)this.bytes[this.offset++];
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            continue;
                        }
                        this.ch = (char)this.bytes[this.offset++];
                    }
                    this.nextIfComma();
                }
                return null;
            }
        } else if (this.ch == ',' || this.ch == '\r' || this.ch == '\n') {
            return null;
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)this.bytes[this.offset++];
        } else if (this.ch == '+') {
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            int intValue10 = intValue * 10 + (this.ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = (char)this.bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public final long readInt64Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        byte[] bytes = this.bytes;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)bytes[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)bytes[this.offset++];
        } else if (this.ch == '+') {
            this.ch = (char)bytes[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = (char)bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.longValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("long overflow, value " + bigInteger);
                }
            }
            return this.getInt64Value();
        }
        if (quote != '\u0000') {
            this.wasNull = firstOffset + 1 == this.offset;
            this.ch = (char)(this.offset == this.end ? 26 : (char)bytes[this.offset++]);
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : (char)bytes[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)bytes[this.offset++];
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public final Long readInt64() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
                this.nextIfComma();
                return null;
            }
        } else if (this.ch == ',' || this.ch == '\r' || this.ch == '\n') {
            return null;
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
                this.nextIfComma();
                return null;
            }
        } else if (this.ch == '+') {
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            long intValue10 = longValue * 10L + (long)(this.ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            return this.getInt64();
        }
        if (quote != '\u0000') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = (char)this.bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public final double readDoubleValue() {
        long intValue10;
        this.wasNull = false;
        boolean value = false;
        double doubleValue = 0.0;
        byte[] bytes = this.bytes;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)bytes[this.offset++];
                this.nextIfComma();
                this.wasNull = true;
                return 0.0;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = (char)bytes[this.offset++];
        } else {
            this.negative = false;
            if (this.ch == '+') {
                this.ch = (char)bytes[this.offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.scale = 0;
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(this.ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)bytes[this.offset++];
            }
        }
        int expValue = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            this.ch = (char)bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (bytes[this.offset++] == 117 && bytes[this.offset++] == 108 && bytes[this.offset++] == 108) {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (bytes[this.offset++] == 114 && bytes[this.offset++] == 117 && bytes[this.offset++] == 101) {
                    value = true;
                    doubleValue = 1.0;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.offset + 4 <= this.end && JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) == IOUtils.ALSE) {
                    this.offset += 4;
                    doubleValue = 0.0;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        String str = null;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                str = this.readString();
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
        }
        if (!value) {
            if (!overflow) {
                if (longValue == 0L) {
                    if (this.scale == 1) {
                        doubleValue = 0.0;
                        value = true;
                    }
                } else {
                    int scale = this.scale - expValue;
                    if (scale == 0) {
                        doubleValue = longValue;
                        if (this.negative) {
                            doubleValue = -doubleValue;
                        }
                        value = true;
                    } else if ((long)((double)longValue) == longValue) {
                        if (0 < scale && scale < JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = (double)longValue / JSONFactory.DOUBLE_10_POW[scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        } else if (0 > scale && scale > -JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = (double)longValue * JSONFactory.DOUBLE_10_POW[-scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        }
                    }
                    if (!value && scale > -128 && scale < 128) {
                        doubleValue = TypeUtils.doubleValue(this.negative ? -1 : 1, longValue, scale);
                        value = true;
                    }
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        doubleValue = Double.parseDouble(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    doubleValue = TypeUtils.parseDouble(bytes, start - 1, len);
                }
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
            }
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = (char)bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)bytes[this.offset++];
                }
            }
        }
        return doubleValue;
    }

    @Override
    public final float readFloatValue() {
        long intValue10;
        this.wasNull = false;
        boolean value = false;
        float floatValue = 0.0f;
        byte[] bytes = this.bytes;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)bytes[this.offset++];
                this.nextIfComma();
                this.wasNull = true;
                return 0.0f;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = (char)bytes[this.offset++];
        } else {
            this.negative = false;
            if (this.ch == '+') {
                this.ch = (char)bytes[this.offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.scale = 0;
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(this.ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)bytes[this.offset++];
            }
        }
        int expValue = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            this.ch = (char)bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (bytes[this.offset++] == 117 && bytes[this.offset++] == 108 && bytes[this.offset++] == 108) {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (bytes[this.offset++] == 114 && bytes[this.offset++] == 117 && bytes[this.offset++] == 101) {
                    value = true;
                    floatValue = 1.0f;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.offset + 4 <= this.end && JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) == IOUtils.ALSE) {
                    this.offset += 4;
                    floatValue = 0.0f;
                    value = true;
                    this.ch = this.offset == this.end ? (char)26 : (char)bytes[this.offset++];
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        String str = null;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                overflow = true;
                --this.offset;
                this.ch = quote;
                str = this.readString();
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
        }
        if (!value) {
            if (!overflow) {
                int scale = this.scale - expValue;
                if (scale == 0) {
                    floatValue = longValue;
                    if (this.negative) {
                        floatValue = -floatValue;
                    }
                    value = true;
                } else if ((long)((float)longValue) == longValue) {
                    if (0 < scale && scale < JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)longValue / JSONFactory.FLOAT_10_POW[scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    } else if (0 > scale && scale > -JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)longValue * JSONFactory.FLOAT_10_POW[-scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    }
                }
                if (!value && scale > -128 && scale < 128) {
                    floatValue = TypeUtils.floatValue(this.negative ? -1 : 1, longValue, scale);
                    value = true;
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        floatValue = Float.parseFloat(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    floatValue = TypeUtils.parseFloat(bytes, start - 1, len);
                }
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
            }
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = (char)bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)bytes[this.offset++];
                }
            }
        }
        return floatValue;
    }

    @Override
    public final void readString(ValueConsumer consumer, boolean quoted) {
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            byte c;
            if ((c = this.bytes[offset]) == 92) {
                this.valueEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else if (c >= 0) {
                if (c == quote) break;
                ++offset;
            } else {
                switch ((c & 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        offset += 2;
                        break;
                    }
                    case 14: {
                        offset += 3;
                        break;
                    }
                    default: {
                        if (c >> 3 == -2) {
                            offset += 4;
                            ++i;
                            break;
                        }
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            int bytesMaxiumLength = offset - this.offset;
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.bytes[offset]) == '\\') {
                    c = this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                if (c >= '\u0000') {
                    chars[i2] = c;
                    ++offset;
                } else {
                    switch ((c & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            int n = ++offset;
                            ++offset;
                            byte c2 = this.bytes[n];
                            chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            break;
                        }
                        case 14: {
                            int n = ++offset;
                            byte c2 = this.bytes[n];
                            int n2 = ++offset;
                            ++offset;
                            byte c3 = this.bytes[n2];
                            chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                            break;
                        }
                        default: {
                            byte c3;
                            byte c2;
                            if (c >> 3 == -2) {
                                int n = ++offset;
                                c2 = this.bytes[n];
                                int n3 = ++offset;
                                c3 = this.bytes[n3];
                                int n4 = ++offset;
                                ++offset;
                                byte c4 = this.bytes[n4];
                                int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                chars[i2++] = (char)((uc >>> 10) + 55232);
                                chars[i2] = (char)((uc & 0x3FF) + 56320);
                                break;
                            }
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
                ++i2;
            }
            if (quoted) {
                JSONWriter jsonWriter = JSONWriterUTF8.of();
                jsonWriter.writeString(chars, 0, chars.length);
                byte[] bytes = jsonWriter.getBytes();
                consumer.accept(bytes, 0, bytes.length);
            } else {
                byte[] bytes = new byte[bytesMaxiumLength];
                int bytesLength = IOUtils.encodeUTF8(chars, 0, chars.length, bytes, 0);
                consumer.accept(bytes, 0, bytesLength);
            }
        } else {
            int consumLen;
            int consumStart = quoted ? this.offset - 1 : this.offset;
            int n = consumLen = quoted ? offset - this.offset + 2 : offset - this.offset;
            if (quoted && quote == '\'') {
                byte[] quotedBytes = new byte[consumLen];
                System.arraycopy(this.bytes, this.offset - 1, quotedBytes, 0, consumLen);
                quotedBytes[0] = 34;
                quotedBytes[quotedBytes.length - 1] = 34;
                consumer.accept(quotedBytes, 0, quotedBytes.length);
            } else {
                consumer.accept(this.bytes, consumStart, consumLen);
            }
        }
        byte b = this.bytes[++offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.bytes[++offset];
        }
        this.comma = b == 44;
        if (this.comma) {
            this.offset = offset + 1;
            this.next();
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
    }

    protected void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        boolean ascii = true;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            byte c;
            if ((c = this.bytes[offset]) == 92) {
                this.valueEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else if (c >= 0) {
                if (c == quote) break;
                ++offset;
            } else {
                switch ((c & 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        offset += 2;
                        ascii = false;
                        break;
                    }
                    case 14: {
                        offset += 3;
                        ascii = false;
                        break;
                    }
                    default: {
                        if (c >> 3 == -2) {
                            offset += 4;
                            ++i;
                            ascii = false;
                            break;
                        }
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.bytes[offset]) == '\\') {
                    c = this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    chars[i2] = c;
                    ++offset;
                } else {
                    if (c == '\"') break;
                    if (c >= '\u0000') {
                        chars[i2] = c;
                        ++offset;
                    } else {
                        switch ((c & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                int n = ++offset;
                                ++offset;
                                byte c2 = this.bytes[n];
                                chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                int n = ++offset;
                                byte c2 = this.bytes[n];
                                int n2 = ++offset;
                                ++offset;
                                byte c3 = this.bytes[n2];
                                chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                byte c3;
                                byte c2;
                                if (c >> 3 == -2) {
                                    int n = ++offset;
                                    c2 = this.bytes[n];
                                    int n3 = ++offset;
                                    c3 = this.bytes[n3];
                                    int n4 = ++offset;
                                    ++offset;
                                    byte c4 = this.bytes[n4];
                                    int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                        throw new JSONException("malformed input around byte " + offset);
                                    }
                                    chars[i2++] = (char)((uc >>> 10) + 55232);
                                    chars[i2] = (char)((uc & 0x3FF) + 56320);
                                    break;
                                }
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                }
                ++i2;
            }
            str = new String(chars);
        } else {
            str = ascii ? new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.ISO_8859_1) : new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
        }
        byte b = this.bytes[++offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.bytes[++offset];
        }
        boolean bl = this.comma = b == 44;
        if (b == 44) {
            this.offset = offset + 1;
            this.next();
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public final boolean skipName() {
        byte c;
        if (this.ch != '\"') {
            throw new JSONException("not support unquoted name");
        }
        int offset = this.offset;
        while (true) {
            if ((c = this.bytes[offset]) == 92) {
                offset += 2;
                continue;
            }
            if (c == 34) {
                c = this.bytes[++offset];
                while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                    c = this.bytes[++offset];
                }
                if (c != 58) {
                    throw new JSONException("syntax error, expect ',', but '" + c + "'");
                }
                c = this.bytes[++offset];
                while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                    c = this.bytes[++offset];
                }
                break;
            }
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public final void skipValue() {
        this.comma = false;
        block0 : switch (this.ch) {
            case '[': {
                this.next();
                int i = 0;
                while (true) {
                    if (this.ch == ']') {
                        this.next();
                        break block0;
                    }
                    if (i != 0 && !this.comma) {
                        throw new JSONValidException("offset " + this.offset);
                    }
                    this.comma = false;
                    this.skipValue();
                    ++i;
                }
            }
            case '{': {
                this.next();
                while (true) {
                    if (this.ch == '}') {
                        this.next();
                        break block0;
                    }
                    this.skipName();
                    this.skipValue();
                }
            }
            case '\"': {
                this.skipString();
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                boolean sign;
                boolean bl = sign = this.ch == '-' || this.ch == '+';
                if (sign) {
                    if (this.offset < this.end) {
                        this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                    } else {
                        throw new JSONException("illegal number, offset " + this.offset);
                    }
                }
                boolean dot = this.ch == '.';
                boolean num = false;
                if (!dot && this.ch >= '0' && this.ch <= '9') {
                    num = true;
                    do {
                        if (this.offset >= this.end) {
                            this.ch = (char)26;
                            return;
                        }
                        this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                    } while (this.ch >= '0' && this.ch <= '9');
                }
                if (num && (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S')) {
                    this.next();
                }
                boolean small = false;
                if (this.ch == '.') {
                    small = true;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                    if (this.ch >= '0' && this.ch <= '9') {
                        do {
                            if (this.offset >= this.end) {
                                this.ch = (char)26;
                                return;
                            }
                            this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                        } while (this.ch >= '0' && this.ch <= '9');
                    }
                }
                if (!num && !small) {
                    throw new JSONException("illegal number, offset " + this.offset + ", char " + this.ch);
                }
                if (this.ch == 'e' || this.ch == 'E') {
                    this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                    boolean eSign = false;
                    if (this.ch == '+' || this.ch == '-') {
                        eSign = true;
                        if (this.offset < this.end) {
                            this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                        } else {
                            throw new JSONException("illegal number, offset " + this.offset);
                        }
                    }
                    if (this.ch >= '0' && this.ch <= '9') {
                        do {
                            if (this.offset >= this.end) {
                                this.ch = (char)26;
                                return;
                            }
                            this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                        } while (this.ch >= '0' && this.ch <= '9');
                    } else if (eSign) {
                        throw new JSONException("illegal number, offset " + this.offset + ", char " + this.ch);
                    }
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch == '}' || this.ch == ']') {
                    return;
                }
                if (this.ch == ',') {
                    this.comma = true;
                    if (this.offset >= this.end) {
                        throw new JSONException("illegal number, offset " + this.offset);
                    }
                    this.ch = (char)(this.bytes[this.offset] & 0xFF);
                    while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                        ++this.offset;
                        if (this.offset >= this.end) {
                            throw new JSONException("illegal number, offset " + this.offset);
                        }
                        this.ch = (char)(this.bytes[this.offset] & 0xFF);
                    }
                    this.comma = true;
                    ++this.offset;
                    return;
                }
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
            case 't': {
                if (this.offset + 3 > this.end) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                if (this.bytes[this.offset] != 114 || this.bytes[this.offset + 1] != 117 || this.bytes[this.offset + 2] != 101) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.offset += 3;
                if (this.offset < this.end) {
                    this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                } else {
                    this.ch = (char)26;
                    return;
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch != '}' && this.ch != ']') break;
                return;
            }
            case 'f': {
                if (this.offset + 4 >= this.end && JDKUtils.UNSAFE.getInt(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) != IOUtils.ALSE) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.offset += 4;
                if (this.offset < this.end) {
                    this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                } else {
                    this.ch = (char)26;
                    return;
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch != '}' && this.ch != ']') break;
                return;
            }
            case 'n': {
                if (this.offset + 3 > this.end) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                if (this.bytes[this.offset] != 117 || this.bytes[this.offset + 1] != 108 || this.bytes[this.offset + 2] != 108) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.offset += 3;
                if (this.offset < this.end) {
                    this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                } else {
                    this.ch = (char)26;
                    return;
                }
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset < this.end) {
                        this.ch = (char)(this.bytes[this.offset++] & 0xFF);
                        continue;
                    }
                    this.ch = (char)26;
                    return;
                }
                if (this.ch != '}' && this.ch != ']') break;
                return;
            }
            case 'S': {
                if (this.nextIfSet()) {
                    this.skipValue();
                    break;
                }
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
            default: {
                throw new JSONException("TODO : " + this.ch);
            }
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.end) {
                throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
            }
            this.ch = (char)this.bytes[this.offset];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.end) {
                    throw new JSONException("error, offset " + this.offset + ", char " + this.ch);
                }
                this.ch = (char)this.bytes[this.offset];
            }
            ++this.offset;
        } else if (!this.comma && this.ch != '}' && this.ch != ']' && this.ch != '\u001a') {
            throw new JSONValidException("offset " + this.offset);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.bytes, this.nameBegin, length, this.nameAscii != false ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
        }
        chars = new char[this.nameLength];
        offset = this.nameBegin;
        i = 0;
        while (true) {
            block18: {
                block17: {
                    if ((c = this.bytes[offset]) >= '\u0000') break block17;
                    switch ((c & 255) >> 4) {
                        case 12: 
                        case 13: {
                            char2 = this.bytes[offset + 1];
                            if ((char2 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 31) << 6 | char2 & 63);
                            offset += 2;
                            break;
                        }
                        case 14: {
                            char2 = this.bytes[offset + 1];
                            char3 = this.bytes[offset + 2];
                            if ((char2 & 192) != 128 || (char3 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + (offset + 2));
                            }
                            c = (char)((c & 15) << 12 | (char2 & 63) << 6 | char3 & 63);
                            offset += 3;
                            break;
                        }
                        default: {
                            if (c >> 3 != -2) ** GOTO lbl42
                            v0 = ++offset;
                            c2 = this.bytes[v0];
                            v1 = ++offset;
                            c3 = this.bytes[v1];
                            v2 = ++offset;
                            ++offset;
                            c4 = this.bytes[v2];
                            uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 3678080);
                            if ((c2 & 192) != 128 || (c3 & 192) != 128 || (c4 & 192) != 128 || uc < 65536 || uc >= 0x110000) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            chars[i++] = (char)((uc >>> 10) + 55232);
                            chars[i] = (char)((uc & 1023) + 56320);
                            break block18;
lbl42:
                            // 1 sources

                            c = (char)(c & 255);
                            ++offset;
                        }
                    }
                    chars[i] = c;
                    break block18;
                }
                if (c == '\\') {
                    c = (char)this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            c3 = this.bytes[++offset];
                            c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i] = c;
                ++offset;
            }
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    protected final void skipString() {
        int offset;
        byte[] bytes;
        int ch;
        block10: {
            int quote = ch = (int)this.ch;
            bytes = this.bytes;
            offset = this.offset;
            ch = bytes[offset++];
            while (true) {
                if (ch == 92) {
                    if ((ch = bytes[offset++]) == 92 || ch == 34) {
                        ch = bytes[offset++];
                        continue;
                    }
                    if (ch == 117) {
                        offset += 4;
                        ch = bytes[offset++];
                        continue;
                    }
                    this.char1(ch);
                    continue;
                }
                if (ch == quote) {
                    ch = offset < this.end ? bytes[offset++] : 26;
                    break block10;
                }
                if (offset >= this.end) break;
                ch = bytes[offset++];
            }
            ch = 26;
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            if (offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return;
            }
            ch = bytes[offset];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (++offset >= this.end) {
                    this.ch = (char)26;
                    this.offset = offset;
                    return;
                }
                ch = bytes[offset];
            }
            ++offset;
        }
        this.offset = offset;
        this.ch = (char)ch;
    }

    @Override
    public final void skipLineComment() {
        while (true) {
            if (this.ch == '\n') {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = (char)this.bytes[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = (char)this.bytes[this.offset];
                }
                ++this.offset;
                break;
            }
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = (char)this.bytes[this.offset];
        }
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int offset;
            block66: {
                char quote = this.ch;
                int start = offset = this.offset;
                boolean ascii = true;
                this.valueEscape = false;
                int i = 0;
                while (true) {
                    if (offset >= this.end) {
                        throw new JSONException("invalid escape character EOI");
                    }
                    byte c = this.bytes[offset];
                    if (c == 92) {
                        this.valueEscape = true;
                        c = this.bytes[++offset];
                        switch (c) {
                            case 117: {
                                offset += 4;
                                break;
                            }
                            case 120: {
                                offset += 2;
                                break;
                            }
                        }
                        ++offset;
                    } else if (c >= 0) {
                        if (c == quote) break;
                        ++offset;
                    } else {
                        switch ((c & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                offset += 2;
                                ascii = false;
                                break;
                            }
                            case 14: {
                                offset += 3;
                                ascii = false;
                                break;
                            }
                            default: {
                                if (c >> 3 == -2) {
                                    offset += 4;
                                    ++i;
                                    ascii = false;
                                    break;
                                }
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                    ++i;
                }
                int valueLength = i;
                if (this.valueEscape) {
                    char[] chars = new char[valueLength];
                    offset = start;
                    int i2 = 0;
                    while (true) {
                        int c;
                        if ((c = this.bytes[offset]) == 92) {
                            c = this.bytes[++offset];
                            switch (c) {
                                case 117: {
                                    byte c1 = this.bytes[++offset];
                                    byte c2 = this.bytes[++offset];
                                    byte c3 = this.bytes[++offset];
                                    byte c4 = this.bytes[++offset];
                                    c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                                    break;
                                }
                                case 120: {
                                    byte c1 = this.bytes[++offset];
                                    byte c2 = this.bytes[++offset];
                                    c = JSONReaderUTF8.char2(c1, c2);
                                    break;
                                }
                                case 34: 
                                case 92: {
                                    break;
                                }
                                case 98: {
                                    c = 8;
                                    break;
                                }
                                case 116: {
                                    c = 9;
                                    break;
                                }
                                case 110: {
                                    c = 10;
                                    break;
                                }
                                case 102: {
                                    c = 12;
                                    break;
                                }
                                case 114: {
                                    c = 13;
                                    break;
                                }
                                default: {
                                    c = this.char1(c);
                                }
                            }
                            chars[i2] = (char)c;
                            ++offset;
                        } else {
                            if (c == 34) break;
                            if (c >= 0) {
                                chars[i2] = (char)c;
                                ++offset;
                            } else {
                                switch ((c & 0xFF) >> 4) {
                                    case 12: 
                                    case 13: {
                                        int n = ++offset;
                                        ++offset;
                                        byte c2 = this.bytes[n];
                                        chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                        break;
                                    }
                                    case 14: {
                                        int n = ++offset;
                                        byte c2 = this.bytes[n];
                                        int n2 = ++offset;
                                        ++offset;
                                        byte c3 = this.bytes[n2];
                                        chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                        break;
                                    }
                                    default: {
                                        byte c3;
                                        byte c2;
                                        if (c >> 3 == -2) {
                                            int n = ++offset;
                                            c2 = this.bytes[n];
                                            int n3 = ++offset;
                                            c3 = this.bytes[n3];
                                            int n4 = ++offset;
                                            ++offset;
                                            byte c4 = this.bytes[n4];
                                            int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                                throw new JSONException("malformed input around byte " + offset);
                                            }
                                            chars[i2++] = (char)((uc >>> 10) + 55232);
                                            chars[i2] = (char)((uc & 0x3FF) + 56320);
                                            break;
                                        }
                                        throw new JSONException("malformed input around byte " + offset);
                                    }
                                }
                            }
                        }
                        ++i2;
                    }
                    str = new String(chars);
                } else if (ascii) {
                    int strlen = offset - this.offset;
                    if (strlen == 1) {
                        str = TypeUtils.toString((char)(this.bytes[this.offset] & 0xFF));
                    } else if (strlen == 2) {
                        str = TypeUtils.toString((char)(this.bytes[this.offset] & 0xFF), (char)(this.bytes[this.offset + 1] & 0xFF));
                    } else if (JDKUtils.STRING_CREATOR_JDK8 != null) {
                        char[] chars = new char[strlen];
                        for (int i3 = 0; i3 < strlen; ++i3) {
                            chars[i3] = (char)this.bytes[this.offset + i3];
                        }
                        str = JDKUtils.STRING_CREATOR_JDK8.apply(chars, Boolean.TRUE);
                    } else if (JDKUtils.STRING_CREATOR_JDK11 != null) {
                        byte[] bytes = Arrays.copyOfRange(this.bytes, this.offset, offset);
                        str = JDKUtils.STRING_CREATOR_JDK11.apply(bytes, JDKUtils.LATIN1);
                    } else {
                        str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.ISO_8859_1);
                    }
                } else {
                    str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
                }
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str = str.trim();
                }
                if (++offset != this.end) {
                    int e = this.bytes[offset++];
                    while (e <= 32 && (1L << e & 0x100003700L) != 0L) {
                        if (offset != this.end) {
                            e = this.bytes[offset++];
                            continue;
                        }
                        break block66;
                    }
                    this.comma = e == 44;
                    if (this.comma) {
                        if (offset == this.end) {
                            e = 26;
                        } else {
                            e = this.bytes[offset++];
                            while (e <= 32 && (1L << e & 0x100003700L) != 0L) {
                                if (offset == this.end) {
                                    e = 26;
                                    break;
                                }
                                e = this.bytes[offset++];
                            }
                        }
                    }
                    this.ch = (char)e;
                    this.offset = offset;
                    return str;
                }
            }
            this.ch = (char)26;
            this.comma = false;
            this.offset = offset;
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException(this.info("illegal input : " + this.ch));
    }

    @Override
    public final void readNumber0() {
        int digit;
        int multmin;
        int limit;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        int firstOffset = this.offset;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
                this.nextIfComma();
                this.wasNull = true;
                return;
            }
        } else if (this.ch == ',' || this.ch == '\r' || this.ch == '\n') {
            this.wasNull = true;
            this.valueType = (byte)5;
            return;
        }
        int start = this.offset;
        if (this.ch == '-') {
            limit = Integer.MIN_VALUE;
            multmin = -214748364;
            this.negative = true;
            this.ch = (char)this.bytes[this.offset++];
        } else {
            if (this.ch == '+') {
                this.ch = (char)this.bytes[this.offset++];
            }
            limit = -2147483647;
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                digit = this.ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    digit = this.ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? this.offset - 2 - numStart : this.offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                this.stringValue = new String(this.bytes, numStart, this.offset - 1 - numStart);
            } else {
                this.bigInt(this.bytes, numStart, this.offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)this.bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)this.bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 108 && this.bytes[this.offset++] == 108) {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)this.bytes[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.bytes[this.offset++] == 114 && this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 101) {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)this.bytes[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.offset + 4 <= this.end && JDKUtils.UNSAFE.getInt(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) == IOUtils.ALSE) {
                    this.offset += 4;
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)this.bytes[this.offset++];
                    }
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                this.offset = firstOffset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
            switch (this.ch) {
                case 'B': {
                    this.valueType = (byte)9;
                    break;
                }
                case 'S': {
                    this.valueType = (byte)10;
                    break;
                }
                case 'L': {
                    this.valueType = (byte)11;
                    break;
                }
                case 'F': {
                    this.valueType = (byte)12;
                    break;
                }
                case 'D': {
                    this.valueType = (byte)13;
                    break;
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = (char)this.bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
    }

    @Override
    public final void readNumber(ValueConsumer consumer, boolean quoted) {
        int mag3_10;
        this.wasNull = false;
        this.boolValue = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                mag3_10 = this.mag3 * 10 + (this.ch - 48);
                if (mag3_10 < this.mag3) {
                    intOverflow = true;
                } else {
                    this.mag3 = mag3_10;
                }
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    mag3_10 = this.mag3 * 10 + (this.ch - 48);
                    if (mag3_10 < this.mag3) {
                        intOverflow = true;
                    } else {
                        this.mag3 = mag3_10;
                    }
                }
                this.scale = (byte)(this.scale + 1);
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        if (intOverflow) {
            int numStart = this.negative ? start : start - 1;
            this.bigInt(this.bytes, numStart, this.offset - 1);
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)this.bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)this.bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                this.ch = (char)this.bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        int len = this.offset - start;
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 108 && this.bytes[this.offset++] == 108) {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    this.ch = (char)this.bytes[this.offset++];
                }
            } else if (this.ch == 't') {
                if (this.bytes[this.offset++] == 114 && this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 101) {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    this.ch = (char)this.bytes[this.offset++];
                }
            } else if (this.ch == 'f') {
                if (this.offset + 4 <= this.end && JDKUtils.UNSAFE.getInt(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) == IOUtils.ALSE) {
                    this.offset += 4;
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    this.ch = (char)this.bytes[this.offset++];
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        if (!(quoted || this.valueType != 1 && this.valueType != 2)) {
            consumer.accept(this.bytes, start - 1, len);
            return;
        }
        if (this.valueType == 1) {
            if (this.mag0 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                int intValue = this.negative ? -this.mag3 : this.mag3;
                consumer.accept(intValue);
                return;
            }
            if (this.mag0 == 0 && this.mag1 == 0) {
                long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                if (v2 <= Integer.MAX_VALUE) {
                    long v23 = (v2 << 32) + v3;
                    long longValue = this.negative ? -v23 : v23;
                    consumer.accept(longValue);
                    return;
                }
            }
        }
        Number number = this.getNumber();
        consumer.accept(number);
    }

    @Override
    public final boolean readIfNull() {
        if (this.ch == 'n' && this.bytes[this.offset] == 117 && this.bytes[this.offset + 1] == 108 && this.bytes[this.offset + 2] == 108) {
            this.ch = this.offset + 3 == this.end ? (char)26 : (char)this.bytes[this.offset + 3];
            this.offset += 4;
        } else {
            return false;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : (char)this.bytes[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        return true;
    }

    @Override
    public final boolean isNull() {
        return this.ch == 'n' && this.offset < this.end && this.bytes[this.offset] == 117;
    }

    @Override
    public final Date readNullOrNewDate() {
        Date date = null;
        if (this.offset + 2 < this.end && this.bytes[this.offset] == 117 && this.bytes[this.offset + 1] == 108 && this.bytes[this.offset + 2] == 108) {
            this.ch = this.offset + 3 == this.end ? (char)26 : (char)this.bytes[this.offset + 3];
            this.offset += 4;
        } else if (this.offset + 1 < this.end && this.bytes[this.offset] == 101 && this.bytes[this.offset + 1] == 119) {
            this.ch = this.offset + 3 == this.end ? (char)26 : (char)this.bytes[this.offset + 2];
            this.offset += 3;
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
            if (this.offset + 4 < this.end && this.ch == 'D' && this.bytes[this.offset] == 97 && this.bytes[this.offset + 1] == 116 && this.bytes[this.offset + 2] == 101) {
                this.ch = this.offset + 3 == this.end ? (char)26 : (char)this.bytes[this.offset + 3];
                this.offset += 4;
            } else {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
            if (this.ch != '(' || this.offset >= this.end) {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
            long millis = this.readInt64Value();
            if (this.ch != ')') {
                throw new JSONException("json syntax error, not match new Date" + this.offset);
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
            date = new Date(millis);
        } else {
            throw new JSONException("json syntax error, not match null or new Date" + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)(this.offset == this.end ? 26 : (char)this.bytes[this.offset++]);
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        return date;
    }

    @Override
    public final boolean nextIfNull() {
        int offset = this.offset;
        byte[] bytes = this.bytes;
        if (this.ch == 'n' && offset + 2 < this.end && bytes[offset] == 117) {
            this.readNull();
            return true;
        }
        return false;
    }

    @Override
    public final void readNull() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            ch = offset + 3 == this.end ? 26 : (int)((char)bytes[offset + 3]);
            offset += 4;
        } else {
            throw new JSONException("json syntax error, not match null" + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = 26;
                continue;
            }
            ch = (char)bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = offset >= this.end ? 26 : (int)((char)bytes[offset++]);
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    ch = 26;
                    continue;
                }
                ch = (char)bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    @Override
    public final int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("string length only support string input");
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        byte[] bytes = this.bytes;
        int i8 = i + 8;
        if (i8 < this.end && i8 < bytes.length && bytes[i] != quote && bytes[i + 1] != quote && bytes[i + 2] != quote && bytes[i + 3] != quote && bytes[i + 4] != quote && bytes[i + 5] != quote && bytes[i + 6] != quote && bytes[i + 7] != quote) {
            i += 8;
            len += 8;
        }
        while (i < this.end && bytes[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    public final LocalDate readLocalDate() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (this.ch == '\"' || this.ch == '\'') {
            JSONReader.Context context = this.context;
            if (context.dateFormat == null || context.formatyyyyMMddhhmmss19 || context.formatyyyyMMddhhmmssT19 || context.formatyyyyMMdd8 || context.formatISO8601) {
                char quote = this.ch;
                int c10 = offset + 10;
                if (c10 < bytes.length && c10 < this.end && bytes[offset + 4] == 45 && bytes[offset + 7] == 45 && bytes[offset + 10] == quote) {
                    byte y0 = bytes[offset];
                    byte y1 = bytes[offset + 1];
                    byte y2 = bytes[offset + 2];
                    byte y3 = bytes[offset + 3];
                    byte m0 = bytes[offset + 5];
                    byte m1 = bytes[offset + 6];
                    byte d0 = bytes[offset + 8];
                    byte d1 = bytes[offset + 9];
                    if (y0 >= 48 && y0 <= 57 && y1 >= 48 && y1 <= 57 && y2 >= 48 && y2 <= 57 && y3 >= 48 && y3 <= 57) {
                        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
                        if (m0 >= 48 && m0 <= 57 && m1 >= 48 && m1 <= 57) {
                            int month = (m0 - 48) * 10 + (m1 - 48);
                            if (d0 >= 48 && d0 <= 57 && d1 >= 48 && d1 <= 57) {
                                LocalDate ldt;
                                int dom = (d0 - 48) * 10 + (d1 - 48);
                                try {
                                    ldt = year == 0 && month == 0 && dom == 0 ? null : LocalDate.of(year, month, dom);
                                }
                                catch (DateTimeException ex) {
                                    throw new JSONException(this.info("read date error"), ex);
                                }
                                this.offset = offset + 11;
                                this.next();
                                this.comma = this.ch == ',';
                                if (this.comma) {
                                    this.next();
                                }
                                return ldt;
                            }
                        }
                    }
                }
            }
        }
        return super.readLocalDate();
    }

    @Override
    public final OffsetDateTime readOffsetDateTime() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        JSONReader.Context context = this.context;
        if ((this.ch == '\"' || this.ch == '\'') && (context.dateFormat == null || context.formatyyyyMMddhhmmss19 || context.formatyyyyMMddhhmmssT19 || context.formatyyyyMMdd8 || context.formatISO8601)) {
            byte c10;
            char quote = this.ch;
            int off21 = offset + 19;
            if (off21 < bytes.length && off21 < this.end && bytes[offset + 4] == 45 && bytes[offset + 7] == 45 && ((c10 = bytes[offset + 10]) == 32 || c10 == 84) && bytes[offset + 13] == 58 && bytes[offset + 16] == 58) {
                int start;
                LocalDate localDate;
                byte y0 = bytes[offset];
                byte y1 = bytes[offset + 1];
                byte y2 = bytes[offset + 2];
                byte y3 = bytes[offset + 3];
                byte m0 = bytes[offset + 5];
                byte m1 = bytes[offset + 6];
                byte d0 = bytes[offset + 8];
                byte d1 = bytes[offset + 9];
                byte h0 = bytes[offset + 11];
                byte h1 = bytes[offset + 12];
                byte i0 = bytes[offset + 14];
                byte i1 = bytes[offset + 15];
                byte s0 = bytes[offset + 17];
                byte s1 = bytes[offset + 18];
                if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
                    return this.readZonedDateTime().toOffsetDateTime();
                }
                int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
                if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
                    return this.readZonedDateTime().toOffsetDateTime();
                }
                int month = (m0 - 48) * 10 + (m1 - 48);
                if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
                    return this.readZonedDateTime().toOffsetDateTime();
                }
                int dom = (d0 - 48) * 10 + (d1 - 48);
                if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
                    return this.readZonedDateTime().toOffsetDateTime();
                }
                int hour = (h0 - 48) * 10 + (h1 - 48);
                if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
                    return this.readZonedDateTime().toOffsetDateTime();
                }
                int minute = (i0 - 48) * 10 + (i1 - 48);
                if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
                    return this.readZonedDateTime().toOffsetDateTime();
                }
                int second = (s0 - 48) * 10 + (s1 - 48);
                try {
                    localDate = year == 0 && month == 0 && dom == 0 ? null : LocalDate.of(year, month, dom);
                }
                catch (DateTimeException ex) {
                    throw new JSONException(this.info("read date error"), ex);
                }
                int nanoSize = -1;
                int len = 0;
                int end = offset + 31;
                for (int i = start = offset + 19; i < end && i < this.end && i < bytes.length; ++i) {
                    if (bytes[i] != quote || bytes[i - 1] != 90) continue;
                    nanoSize = i - start - 2;
                    len = i - offset + 1;
                    break;
                }
                if (nanoSize != -1 || len == 21) {
                    int nano = nanoSize <= 0 ? 0 : DateUtils.readNanos(bytes, nanoSize, offset + 20);
                    LocalTime localTime = LocalTime.of(hour, minute, second, nano);
                    LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
                    OffsetDateTime oft = OffsetDateTime.of(ldt, ZoneOffset.UTC);
                    this.offset += len;
                    this.next();
                    this.comma = this.ch == ',';
                    if (this.comma) {
                        this.next();
                    }
                    return oft;
                }
            }
        }
        return this.readZonedDateTime().toOffsetDateTime();
    }

    @Override
    public final OffsetTime readOffsetTime() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        JSONReader.Context context = this.context;
        if ((this.ch == '\"' || this.ch == '\'') && context.dateFormat == null) {
            char quote = this.ch;
            int off10 = offset + 8;
            if (off10 < bytes.length && off10 < this.end && bytes[offset + 2] == 58 && bytes[offset + 5] == 58) {
                ZoneOffset zoneOffset;
                int start;
                byte h0 = bytes[offset];
                byte h1 = bytes[offset + 1];
                byte i0 = bytes[offset + 3];
                byte i1 = bytes[offset + 4];
                byte s0 = bytes[offset + 6];
                byte s1 = bytes[offset + 7];
                if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int hour = (h0 - 48) * 10 + (h1 - 48);
                if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int minute = (i0 - 48) * 10 + (i1 - 48);
                if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
                    throw new JSONException(this.info("illegal offsetTime"));
                }
                int second = (s0 - 48) * 10 + (s1 - 48);
                int nanoSize = -1;
                int len = 0;
                int end = offset + 25;
                for (int i = start = offset + 8; i < end && i < this.end && i < bytes.length; ++i) {
                    byte b = bytes[i];
                    if (nanoSize == -1 && (b == 90 || b == 43 || b == 45)) {
                        nanoSize = i - start - 1;
                    }
                    if (b != quote) continue;
                    len = i - offset;
                    break;
                }
                int nano = nanoSize <= 0 ? 0 : DateUtils.readNanos(bytes, nanoSize, offset + 9);
                int zoneOffsetSize = len - 9 - nanoSize;
                if (zoneOffsetSize <= 1) {
                    zoneOffset = ZoneOffset.UTC;
                } else {
                    String zonedId = new String(bytes, offset + 9 + nanoSize, zoneOffsetSize);
                    zoneOffset = ZoneOffset.of(zonedId);
                }
                LocalTime localTime = LocalTime.of(hour, minute, second, nano);
                OffsetTime oft = OffsetTime.of(localTime, zoneOffset);
                this.offset += len + 2;
                this.next();
                this.comma = this.ch == ',';
                if (this.comma) {
                    this.next();
                }
                return oft;
            }
        }
        throw new JSONException(this.info("illegal offsetTime"));
    }

    @Override
    protected final ZonedDateTime readZonedDateTimeX(int len) {
        ZonedDateTime zdt;
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        if (len == 30 && this.bytes[this.offset + 29] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime29(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 29 && this.bytes[this.offset + 28] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime28(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 28 && this.bytes[this.offset + 27] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime27(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else if (len == 27 && this.bytes[this.offset + 26] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime26(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneOffset.UTC);
        } else {
            zdt = DateUtils.parseZonedDateTime(this.bytes, this.offset, len, this.context.zoneId);
        }
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return zdt;
    }

    @Override
    public final LocalDate readLocalDate8() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate8(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate9() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate9(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate10() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate10(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDate readLocalDate11() {
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        LocalDate ldt = DateUtils.parseLocalDate11(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime17() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime17(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 18;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime5() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime5(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 6;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime8() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime9() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime10() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime10(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime11() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime11(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime12() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime12(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime18() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime18(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalDateTime readLocalDateTime12() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime12(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime14() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime14(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 15;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime16() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime16(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 17;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime18() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime18(this.bytes, this.offset);
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime19() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime19(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime20() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime20(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 21;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final long readMillis19() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            throw new JSONException("date only support string input");
        }
        if (this.offset + 18 >= this.end) {
            this.wasNull = true;
            return 0L;
        }
        long millis = DateUtils.parseMillis19(this.bytes, this.offset, this.context.zoneId);
        if (this.bytes[this.offset + 19] != quote) {
            throw new JSONException(this.info("illegal date input"));
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return millis;
    }

    @Override
    protected final LocalDateTime readLocalDateTimeX(int len) {
        LocalDateTime ldt;
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        if (this.bytes[this.offset + len - 1] == 90) {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(this.bytes, this.offset, len);
            ldt = zdt.toLocalDateTime();
        } else {
            ldt = DateUtils.parseLocalDateTimeX(this.bytes, this.offset, len);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final BigDecimal readBigDecimal() {
        long r;
        byte[] bytes = this.bytes;
        boolean value = false;
        BigDecimal decimal = null;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)bytes[this.offset++];
                this.nextIfComma();
                return null;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = (char)bytes[this.offset++];
        } else {
            this.negative = false;
            if (this.ch == '+') {
                this.ch = (char)bytes[this.offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                r = longValue * 10L;
                if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                    longValue = r + (long)(this.ch - 48);
                } else {
                    overflow = true;
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.scale = 0;
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                this.scale = (byte)(this.scale + 1);
                if (!overflow) {
                    r = longValue * 10L;
                    if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                        longValue = r + (long)(this.ch - 48);
                    } else {
                        overflow = true;
                    }
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)bytes[this.offset++];
            }
        }
        int expValue = 0;
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            this.ch = (char)bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (bytes[this.offset++] == 117 && bytes[this.offset++] == 108 && bytes[this.offset++] == 108) {
                    if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                        throw new JSONException(this.info("long value not support input null"));
                    }
                    this.wasNull = true;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (bytes[this.offset++] == 114 && bytes[this.offset++] == 117 && bytes[this.offset++] == 101) {
                    value = true;
                    decimal = BigDecimal.ONE;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.offset + 4 <= this.end && JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset) == IOUtils.ALSE) {
                    this.offset += 4;
                    decimal = BigDecimal.ZERO;
                    value = true;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)bytes[this.offset++];
                    }
                }
            } else if (this.ch == '{' && quote == '\u0000') {
                JSONObject jsonObject = new JSONObject();
                this.readObject((Object)jsonObject, 0L);
                decimal = this.decimal(jsonObject);
                value = true;
                this.wasNull = true;
            } else if (this.ch == '[' && quote == '\u0000') {
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                value = true;
                this.wasNull = true;
            }
        }
        int len = this.offset - start;
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                String str = this.readString();
                try {
                    return TypeUtils.toBigDecimal(str);
                }
                catch (NumberFormatException e) {
                    throw new JSONException(this.info(e.getMessage()), e);
                }
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
        }
        if (!value) {
            if (expValue == 0 && !overflow && longValue != 0L) {
                decimal = BigDecimal.valueOf(this.negative ? -longValue : longValue, this.scale);
                value = true;
            }
            if (!value) {
                decimal = TypeUtils.parseBigDecimal(bytes, start - 1, len);
            }
            if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D' || this.ch == 'B' || this.ch == 'S') {
                switch (this.ch) {
                    case 'B': {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 'S': {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 'L': {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 'F': {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 'D': {
                        this.valueType = (byte)13;
                        break;
                    }
                }
                this.ch = this.offset >= this.end ? (char)26 : (char)bytes[this.offset++];
            }
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                this.ch = (char)bytes[this.offset++];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)bytes[this.offset++];
                }
            }
        }
        return decimal;
    }

    @Override
    public final UUID readUUID() {
        String str;
        byte ch = this.ch;
        if (ch == 110) {
            this.readNull();
            return null;
        }
        if (ch != 34 && ch != 39) {
            throw new JSONException(this.info("syntax error, can not read uuid"));
        }
        byte quote = ch;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        if (offset + 36 < bytes.length && bytes[offset + 36] == quote) {
            char ch1 = (char)bytes[offset + 8];
            char ch2 = (char)bytes[offset + 13];
            char ch3 = (char)bytes[offset + 18];
            char ch4 = (char)bytes[offset + 23];
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-') {
                int i;
                int i2;
                long hi = 0L;
                for (i2 = 0; i2 < 8; ++i2) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i2] - 48];
                }
                for (i2 = 9; i2 < 13; ++i2) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i2] - 48];
                }
                for (i2 = 14; i2 < 18; ++i2) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i2] - 48];
                }
                long lo = 0L;
                for (i = 19; i < 23; ++i) {
                    lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
                }
                for (i = 24; i < 36; ++i) {
                    lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
                }
                UUID uuid = new UUID(hi, lo);
                ch = (offset += 37) == this.end ? (byte)26 : (byte)bytes[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (offset >= this.end) {
                        ch = 26;
                        continue;
                    }
                    ch = bytes[offset++];
                }
                this.offset = offset;
                this.comma = ch == 44;
                if (this.comma) {
                    this.next();
                } else {
                    this.ch = (char)ch;
                }
                return uuid;
            }
        } else if (offset + 32 < bytes.length && bytes[offset + 32] == quote) {
            long hi = 0L;
            for (int i = 0; i < 16; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            long lo = 0L;
            for (int i = 16; i < 32; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            UUID uuid = new UUID(hi, lo);
            ch = (offset += 33) == this.end ? (byte)26 : (byte)bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    ch = 26;
                    continue;
                }
                ch = bytes[offset++];
            }
            this.offset = offset;
            this.comma = ch == 44;
            if (this.comma) {
                this.next();
            } else {
                this.ch = (char)ch;
            }
            return uuid;
        }
        if ((str = this.readString()).isEmpty()) {
            return null;
        }
        return UUID.fromString(str);
    }

    @Override
    public final String readPattern() {
        char c;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        int offset = this.offset;
        int i = 0;
        while ((c = (char)this.bytes[offset]) != '/' && ++offset < this.end) {
            ++i;
        }
        String str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
        if (offset + 1 == this.end) {
            this.offset = this.end;
            this.ch = (char)26;
            return str;
        }
        char b = (char)this.bytes[++offset];
        while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
            b = (char)this.bytes[++offset];
        }
        this.comma = b == ',';
        if (this.comma) {
            this.offset = offset + 1;
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = b;
        }
        return str;
    }

    @Override
    public boolean nextIfNullOrEmptyString() {
        int ch;
        char first = this.ch;
        int end = this.end;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        if (first == 'n' && offset + 2 < end && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            offset += 3;
        } else if ((first == '\"' || first == '\'') && offset < end && bytes[offset] == first) {
            ++offset;
        } else {
            return false;
        }
        char c = (char)(ch = (char)(offset == end ? 26 : (char)bytes[offset]));
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                this.ch = (char)26;
                this.offset = offset;
                return true;
            }
            ch = bytes[offset];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = ++offset >= end ? 26 : bytes[offset];
        }
        if (offset >= end) {
            this.ch = (char)26;
            this.offset = offset;
            return true;
        }
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                this.ch = (char)26;
                return true;
            }
            ch = bytes[offset];
        }
        if (ch >= 0) {
            this.offset = offset + 1;
            this.ch = (char)ch;
            return true;
        }
        switch ((ch &= 0xFF) >> 4) {
            case 12: 
            case 13: {
                byte char2 = bytes[(offset += 2) - 1];
                if ((char2 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + offset);
                }
                ch = (char)((ch & 0x1F) << 6 | char2 & 0x3F);
                break;
            }
            case 14: {
                byte char2 = bytes[(offset += 3) - 2];
                byte char3 = bytes[offset - 1];
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + (offset - 1));
                }
                ch = (char)((ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F);
                break;
            }
            default: {
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2) {
        if (this.ch != c0) {
            return false;
        }
        int offset2 = this.offset + 2;
        if (offset2 > this.end || this.bytes[this.offset] != c1 || this.bytes[this.offset + 1] != c2) {
            return false;
        }
        if (offset2 == this.end) {
            this.offset = offset2;
            this.ch = (char)26;
            return true;
        }
        int offset = offset2;
        int ch = this.bytes[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = (char)this.bytes[offset];
        }
        if (offset == offset2) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        if (this.ch != c0) {
            return false;
        }
        int offset3 = this.offset + 3;
        if (offset3 > this.end || this.bytes[this.offset] != c1 || this.bytes[this.offset + 1] != c2 || this.bytes[this.offset + 2] != c3) {
            return false;
        }
        if (offset3 == this.end) {
            this.offset = offset3;
            this.ch = (char)26;
            return true;
        }
        int offset = offset3;
        int ch = this.bytes[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = (char)this.bytes[offset];
        }
        if (offset == offset3 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        if (this.ch != c0) {
            return false;
        }
        int offset4 = this.offset + 4;
        if (offset4 > this.end || this.bytes[this.offset] != c1 || this.bytes[this.offset + 1] != c2 || this.bytes[this.offset + 2] != c3 || this.bytes[this.offset + 3] != c4) {
            return false;
        }
        if (offset4 == this.end) {
            this.offset = offset4;
            this.ch = (char)26;
            return true;
        }
        int offset = offset4;
        int ch = this.bytes[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = (char)this.bytes[offset];
        }
        if (offset == offset4 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        if (this.ch != c0) {
            return false;
        }
        int offset5 = this.offset + 5;
        if (offset5 > this.end || this.bytes[this.offset] != c1 || this.bytes[this.offset + 1] != c2 || this.bytes[this.offset + 2] != c3 || this.bytes[this.offset + 3] != c4 || this.bytes[this.offset + 4] != c5) {
            return false;
        }
        if (offset5 == this.end) {
            this.offset = offset5;
            this.ch = (char)26;
            return true;
        }
        int offset = offset5;
        int ch = this.bytes[offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset == this.end) {
                ch = 26;
                break;
            }
            ch = (char)this.bytes[offset];
        }
        if (offset == offset5 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset + 1;
        this.ch = ch;
        return true;
    }

    @Override
    public final byte[] readHex() {
        if (this.ch == 'x') {
            this.next();
        }
        int ch = this.ch;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        int quote = ch;
        if (quote != 39 && quote != 34) {
            throw new JSONException("illegal state. " + ch);
        }
        int start = offset++;
        while ((ch = (char)bytes[offset++]) >= 48 && ch <= 57 || ch >= 65 && ch <= 70) {
        }
        if (ch != quote) {
            throw new JSONException("illegal state. " + ch);
        }
        ch = bytes[offset++];
        int len = offset - start - 2;
        if (len == 0) {
            return new byte[0];
        }
        if (len % 2 != 0) {
            throw new JSONException("illegal state. " + len);
        }
        byte[] hex = new byte[len / 2];
        for (int i = 0; i < hex.length; ++i) {
            byte c0 = this.bytes[start + i * 2];
            byte c1 = this.bytes[start + i * 2 + 1];
            int b0 = c0 - (c0 <= 57 ? 48 : 55);
            int b1 = c1 - (c1 <= 57 ? 48 : 55);
            hex[i] = (byte)(b0 << 4 | b1);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = 26;
                continue;
            }
            ch = (char)(bytes[offset++] & 0xFF);
        }
        if (ch != 44 || offset >= this.end) {
            this.offset = offset;
            this.ch = (char)ch;
            return hex;
        }
        this.comma = true;
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return hex;
            }
            ch = bytes[offset];
        }
        if (ch >= 0) {
            ++offset;
        } else {
            switch ((ch &= 0xFF) >> 4) {
                case 12: 
                case 13: {
                    byte char2 = bytes[(offset += 2) - 1];
                    if ((char2 & 0xC0) != 128) {
                        throw new JSONException("malformed input around byte " + offset);
                    }
                    ch = (ch & 0x1F) << 6 | char2 & 0x3F;
                    break;
                }
                case 14: {
                    byte char2 = bytes[(offset += 3) - 2];
                    byte char3 = bytes[offset - 1];
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new JSONException("malformed input around byte " + (offset - 1));
                    }
                    ch = (ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
                    break;
                }
                default: {
                    throw new JSONException("malformed input around byte " + offset);
                }
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        while (this.ch == '/' && offset < bytes.length && bytes[offset] == 47) {
            this.skipLineComment();
        }
        return hex;
    }

    @Override
    public boolean isReference() {
        byte[] bytes = this.bytes;
        char ch = this.ch;
        int offset = this.offset;
        if (ch != '{') {
            return false;
        }
        if (offset == this.end) {
            return false;
        }
        ch = bytes[offset];
        while (ch >= '\u0000' && ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                return false;
            }
            ch = bytes[offset];
        }
        char quote = ch;
        if (quote != '\"' && quote != '\'' || offset + 6 >= this.end || bytes[offset + 1] != 36 || bytes[offset + 2] != 114 || bytes[offset + 3] != 101 || bytes[offset + 4] != 102 || bytes[offset + 5] != quote) {
            return false;
        }
        ch = bytes[offset += 6];
        while (ch >= '\u0000' && ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                return false;
            }
            ch = bytes[offset];
        }
        if (ch != ':' || offset + 1 >= this.end) {
            return false;
        }
        ch = bytes[++offset];
        while (ch >= '\u0000' && ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                return false;
            }
            ch = bytes[offset];
        }
        if (ch != quote) {
            return false;
        }
        this.referenceBegin = offset;
        return true;
    }

    @Override
    public final String readReference() {
        if (this.referenceBegin == this.end) {
            return null;
        }
        this.offset = this.referenceBegin;
        this.ch = (char)this.bytes[this.offset++];
        String reference = this.readString();
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return reference;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        if (this.ch != '}') {
            throw new JSONException("illegal reference : " + reference);
        }
        this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        this.comma = this.ch == ',';
        if (this.comma) {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        return reference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean readBoolValue() {
        boolean val;
        this.wasNull = false;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 116 && offset + 2 < bytes.length && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
            offset += 3;
            val = true;
        } else if (ch == 102 && offset + 4 <= bytes.length && JDKUtils.UNSAFE.getInt(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset) == IOUtils.ALSE) {
            offset += 4;
            val = false;
        } else {
            if (ch == 45 || ch >= 48 && ch <= 57) {
                this.readNumber();
                if (this.valueType != 1) return false;
                if ((this.context.features & JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue.mask) != 0L) {
                    if (this.mag0 != 0) return true;
                    if (this.mag1 != 0) return true;
                    if (this.mag2 != 0) return true;
                    if (this.mag3 == 0) return false;
                    return true;
                }
                if (this.mag0 != 0) return false;
                if (this.mag1 != 0) return false;
                if (this.mag2 != 0) return false;
                if (this.mag3 != 1) return false;
                return true;
            }
            if (ch == 110 && offset + 2 < bytes.length && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("boolean value not support input null"));
                }
                this.wasNull = true;
                offset += 3;
                val = false;
            } else {
                if (ch != 34) throw new JSONException("syntax error : " + (char)ch);
                if (offset + 1 < bytes.length && bytes[offset + 1] == 34) {
                    byte c0 = bytes[offset];
                    offset += 2;
                    if (c0 == 48 || c0 == 78) {
                        val = false;
                    } else {
                        if (c0 != 49) {
                            if (c0 != 89) throw new JSONException("can not convert to boolean : " + c0);
                        }
                        val = true;
                    }
                } else {
                    String str = this.readString();
                    if ("true".equalsIgnoreCase(str)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(str)) {
                        return false;
                    }
                    if (!str.isEmpty()) {
                        if (!"null".equalsIgnoreCase(str)) throw new JSONException("can not convert to boolean : " + str);
                    }
                    this.wasNull = true;
                    return false;
                }
            }
        }
        char c = (char)(ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]));
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = 26;
                continue;
            }
            ch = (char)bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]);
            char c2 = (char)ch;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    ch = 26;
                    continue;
                }
                ch = (char)bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return val;
    }

    @Override
    public final String info(String message) {
        int line = 1;
        int column = 1;
        int i = 0;
        while (i < this.offset && i < this.end) {
            if (this.bytes[i] == 10) {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        StringBuilder buf = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            buf.append(message).append(", ");
        }
        buf.append("offset ").append(this.offset).append(", character ").append(this.ch).append(", line ").append(line).append(", column ").append(column).append(", fastjson-version ").append("2.0.40").append(line > 1 ? (char)'\n' : ' ');
        String str = new String(this.bytes, this.start, Math.min(this.length, 65535));
        buf.append(str);
        return buf.toString();
    }

    @Override
    public final void close() {
        if (this.cacheItem != null && this.bytes.length < 0x100000) {
            JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, this.bytes);
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

