/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplStringArray;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.time.Instant;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NameCacheEntry;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

final class JSONReaderJSONB
extends JSONReader {
    static final long BASE = JDKUtils.UNSAFE.arrayBaseOffset(byte[].class);
    static final byte[] SHANGHAI_ZONE_ID_NAME_BYTES = JSONB.toBytes("Asia/Shanghai");
    static Charset GB18030;
    protected final byte[] bytes;
    protected final int length;
    protected final int end;
    protected byte type;
    protected int strlen;
    protected byte strtype;
    protected int strBegin;
    protected byte[] valueBytes;
    protected final JSONFactory.CacheItem cacheItem;
    protected final SymbolTable symbolTable;
    protected long symbol0Hash;
    protected int symbol0Begin;
    protected int symbol0Length;
    protected byte symbol0StrType;
    protected long[] symbols;

    JSONReaderJSONB(JSONReader.Context ctx, InputStream is) {
        super(ctx, true);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (bytes == null) {
            bytes = new byte[ctx.bufferSize];
        }
        int off = 0;
        try {
            int n;
            while ((n = is.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + ctx.bufferSize);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.bytes = bytes;
        this.offset = 0;
        this.end = this.length = off;
        this.symbolTable = ctx.symbolTable;
    }

    JSONReaderJSONB(JSONReader.Context ctx, byte[] bytes, int off, int length) {
        super(ctx, true);
        this.bytes = bytes;
        this.offset = off;
        this.length = length;
        this.end = off + length;
        this.symbolTable = ctx.symbolTable;
        this.cacheItem = JSONFactory.CACHE_ITEMS[System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1];
    }

    @Override
    public final String getString() {
        Charset charset;
        if (this.strtype == -81) {
            return null;
        }
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        if (this.strtype == 121) {
            charset = IOUtils.ISO_8859_1;
        } else if (this.strtype >= 73 && this.strtype <= 120) {
            charset = IOUtils.ISO_8859_1;
        } else if (this.strtype == 122) {
            charset = IOUtils.UTF_8;
        } else if (this.strtype == 123) {
            charset = IOUtils.UTF_16;
        } else if (this.strtype == 124) {
            charset = IOUtils.UTF_16LE;
        } else if (this.strtype == 125) {
            charset = IOUtils.UTF_16BE;
        } else {
            throw new JSONException("TODO : " + JSONB.typeName(this.strtype));
        }
        return new String(this.bytes, this.strBegin, this.strlen, charset);
    }

    public int readLength() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int len = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return len;
        }
        if (type == 72) {
            int len = IOUtils.getInt(this.bytes, this.offset);
            this.offset += 4;
            if (len > 0x10000000) {
                throw new JSONException("input length overflow");
            }
            return len;
        }
        throw new JSONException("not support length type : " + JSONB.typeName(type));
    }

    static int getInt3(byte[] bytes, int offset, int type) {
        return (type - 68 << 16) + ((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF);
    }

    @Override
    public final boolean isArray() {
        if (this.offset >= this.bytes.length) {
            return false;
        }
        byte type = this.bytes[this.offset];
        return type >= -108 && type <= -92;
    }

    @Override
    public final boolean isObject() {
        return this.offset < this.end && this.bytes[this.offset] == -90;
    }

    @Override
    public final boolean isNumber() {
        byte type = this.bytes[this.offset];
        return type >= -78 && type <= 72;
    }

    @Override
    public final boolean isString() {
        return this.offset < this.bytes.length && (this.type = this.bytes[this.offset]) >= 73;
    }

    @Override
    public final boolean nextIfMatch(char ch) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfArrayStart() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfArrayEnd() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfComma() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfObjectStart() {
        if (this.bytes[this.offset] != -90) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public final boolean nextIfObjectEnd() {
        if (this.bytes[this.offset] != -91) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public final boolean nextIfNullOrEmptyString() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        if (this.bytes[this.offset] != 73) {
            return false;
        }
        ++this.offset;
        return true;
    }

    @Override
    public final <T> T read(Type type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public final <T> T read(Class<T> type) {
        boolean fieldBased = (this.context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.context.provider.getObjectReader(type, fieldBased);
        return objectReader.readJSONBObject(this, null, null, 0L);
    }

    @Override
    public final Map<String, Object> readObject() {
        this.type = this.bytes[this.offset++];
        if (this.type == -81) {
            return null;
        }
        if (this.type >= -90) {
            JSONObject map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
            int i = 0;
            while (true) {
                this.type = this.bytes[this.offset];
                if (this.type == -91) {
                    ++this.offset;
                    break;
                }
                Object name = this.isString() ? this.readFieldName() : this.readAny();
                if (this.offset < this.bytes.length && this.bytes[this.offset] == -109) {
                    String reference = this.readReference();
                    if ("..".equals(reference)) {
                        map.put(name, map);
                    } else {
                        this.addResolveTask(map, name, JSONPath.of(reference));
                    }
                } else {
                    List<Object> value;
                    byte valueType = this.bytes[this.offset];
                    if (valueType >= 73 && valueType <= 126) {
                        value = this.readString();
                    } else if (valueType >= -16 && valueType <= 47) {
                        ++this.offset;
                        value = Integer.valueOf(valueType);
                    } else if (valueType == -79) {
                        ++this.offset;
                        value = Boolean.TRUE;
                    } else if (valueType == -80) {
                        ++this.offset;
                        value = Boolean.FALSE;
                    } else if (valueType == -90) {
                        value = this.readObject();
                    } else if (valueType == -66) {
                        ++this.offset;
                        long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                        this.offset += 8;
                        value = JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
                    } else if (valueType >= -108 && valueType <= -92) {
                        int len;
                        ++this.offset;
                        if (valueType == -92) {
                            int itemType = this.bytes[this.offset];
                            if (itemType >= -16 && itemType <= 47) {
                                ++this.offset;
                                len = itemType;
                            } else {
                                len = this.readLength();
                            }
                        } else {
                            len = valueType - -108;
                        }
                        if (len == 0) {
                            value = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList() : (this.context.arraySupplier != null ? this.context.arraySupplier.get() : new JSONArray());
                        } else {
                            JSONArray list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
                            for (int j = 0; j < len; ++j) {
                                if (this.isReference()) {
                                    String reference = this.readReference();
                                    if ("..".equals(reference)) {
                                        list.add(list);
                                        continue;
                                    }
                                    list.add(null);
                                    this.addResolveTask(list, j, JSONPath.of(reference));
                                    continue;
                                }
                                byte itemType = this.bytes[this.offset];
                                Object item = itemType >= 73 && itemType <= 126 ? this.readString() : (itemType == -90 ? this.readObject() : this.readAny());
                                list.add(item);
                            }
                            value = list;
                        }
                    } else if (valueType >= 48 && valueType <= 63) {
                        value = (valueType - 56 << 8) + (this.bytes[this.offset + 1] & 0xFF);
                        this.offset += 2;
                    } else if (valueType >= 64 && valueType <= 71) {
                        int int32Value = JSONReaderJSONB.getInt3(this.bytes, this.offset + 1, valueType);
                        this.offset += 3;
                        value = new Integer(int32Value);
                    } else if (valueType == 72) {
                        int int32Value = IOUtils.getInt(this.bytes, this.offset + 1);
                        this.offset += 5;
                        value = new Integer(int32Value);
                    } else {
                        value = this.readAny();
                    }
                    if (value != null || (this.context.features & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) {
                        map.put(name, value);
                    }
                }
                ++i;
            }
            return map;
        }
        if (this.type == -110) {
            ObjectReader objectReader = this.checkAutoType(Map.class, 0L, 0L);
            return (Map)objectReader.readObject(this, null, null, 0L);
        }
        throw new JSONException("object not support input " + this.error(this.type));
    }

    @Override
    public final void read(Map map, long features) {
        if (this.bytes[this.offset] != -90) {
            throw new JSONException("object not support input " + this.error(this.type));
        }
        ++this.offset;
        int i = 0;
        while (true) {
            byte type;
            if ((type = this.bytes[this.offset]) == -91) {
                ++this.offset;
                break;
            }
            Object name = type >= 73 ? this.readFieldName() : this.readAny();
            if (this.isReference()) {
                String reference = this.readReference();
                if ("..".equals(reference)) {
                    map.put(name, map);
                } else {
                    this.addResolveTask(map, name, JSONPath.of(reference));
                    map.put(name, null);
                }
            } else {
                Object value;
                byte valueType = this.bytes[this.offset];
                if (valueType >= 73 && valueType <= 126) {
                    value = this.readString();
                } else if (valueType >= -16 && valueType <= 47) {
                    ++this.offset;
                    value = (int)valueType;
                } else if (valueType == -79) {
                    ++this.offset;
                    value = Boolean.TRUE;
                } else if (valueType == -80) {
                    ++this.offset;
                    value = Boolean.FALSE;
                } else {
                    value = valueType == -90 ? this.readObject() : this.readAny();
                }
                if (value != null || (this.context.features & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) {
                    map.put(name, value);
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final Object readAny() {
        if (this.offset >= this.bytes.length) {
            throw new JSONException("readAny overflow : " + this.offset + "/" + this.bytes.length);
        }
        this.type = this.bytes[this.offset++];
        switch (this.type) {
            case -81: {
                return null;
            }
            case -79: {
                return true;
            }
            case -80: {
                return false;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                return (short)((this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 255));
            }
            case 72: {
                int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Integer(int32Value);
            }
            case -65: {
                int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Long(int32Value);
            }
            case -66: {
                int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN != false ? int64Value : Long.reverseBytes(int64Value);
            }
            case -69: {
                len = this.readInt32Value();
                bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -73: {
                int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return Double.longBitsToDouble(JDKUtils.BIG_ENDIAN != false ? int64Value : Long.reverseBytes(int64Value));
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case 122: {
                strlen = this.readLength();
                str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                return str;
            }
            case 123: {
                strlen = this.readLength();
                str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_16);
                this.offset += strlen;
                return str;
            }
            case 124: {
                strlen = this.readLength();
                str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_16LE);
                this.offset += strlen;
                return str;
            }
            case 125: {
                strlen = this.readLength();
                str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_16BE);
                this.offset += strlen;
                return str;
            }
            case 126: {
                if (JSONReaderJSONB.GB18030 == null) {
                    JSONReaderJSONB.GB18030 = Charset.forName("GB18030");
                }
                strlen = this.readLength();
                str = new String(this.bytes, this.offset, strlen, JSONReaderJSONB.GB18030);
                this.offset += strlen;
                return str;
            }
            case -71: {
                scale = this.readInt32Value();
                unscaledValue = this.readBigInteger();
                decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal;
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case -111: {
                len = this.readLength();
                binary = Arrays.copyOfRange(this.bytes, this.offset, this.offset + len);
                this.offset += len;
                return binary;
            }
            case -83: {
                minutes = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Date(minutes * 60L * 1000L);
            }
            case -84: {
                seconds = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return new Date(seconds * 1000L);
            }
            case -87: {
                year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 255);
                month = this.bytes[this.offset++];
                dayOfMonth = this.bytes[this.offset++];
                return LocalDate.of(year, month, dayOfMonth);
            }
            case -89: {
                hour = this.bytes[this.offset++];
                minute = this.bytes[this.offset++];
                second = this.bytes[this.offset++];
                nano = this.readInt32Value();
                return LocalTime.of(hour, minute, second, nano);
            }
            case -88: {
                year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 255);
                month = this.bytes[this.offset++];
                dayOfMonth = this.bytes[this.offset++];
                hour = this.bytes[this.offset++];
                minute = this.bytes[this.offset++];
                second = this.bytes[this.offset++];
                nano = this.readInt32Value();
                return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nano);
            }
            case -86: {
                year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 255);
                month = this.bytes[this.offset++];
                dayOfMonth = this.bytes[this.offset++];
                hour = this.bytes[this.offset++];
                minute = this.bytes[this.offset++];
                second = this.bytes[this.offset++];
                nano = this.readInt32Value();
                shanghaiZoneIdNameBytes = JSONReaderJSONB.SHANGHAI_ZONE_ID_NAME_BYTES;
                if (this.offset + shanghaiZoneIdNameBytes.length >= this.bytes.length) ** GOTO lbl128
                shanghai = true;
                for (i = 0; i < shanghaiZoneIdNameBytes.length; ++i) {
                    if (this.bytes[this.offset + i] == shanghaiZoneIdNameBytes[i]) continue;
                    shanghai = false;
                    ** GOTO lbl129
                }
                ** GOTO lbl129
lbl128:
                // 1 sources

                shanghai = false;
lbl129:
                // 3 sources

                if (shanghai) {
                    this.offset += shanghaiZoneIdNameBytes.length;
                    zoneId = ZoneId.SHANGHAI_ZONE_ID;
                } else {
                    zoneIdStr = this.readString();
                    zoneId = DateUtils.getZoneId(zoneIdStr, ZoneId.SHANGHAI_ZONE_ID);
                }
                ldt = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nano);
                return ZonedDateTime.of(ldt, zoneId);
            }
            case -82: {
                epochSeconds = this.readInt64Value();
                nano = this.readInt32Value();
                return Instant.ofEpochSecond(epochSeconds, nano);
            }
            case -85: {
                millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return new Date(JDKUtils.BIG_ENDIAN != false ? millis : Long.reverseBytes(millis));
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -110: {
                typeHash = this.readTypeHashCode();
                if (this.context.autoTypeBeforeHandler != null) {
                    filterClass = this.context.autoTypeBeforeHandler.apply(typeHash, null, this.context.features);
                    if (filterClass == null) {
                        typeName = this.getString();
                        filterClass = this.context.autoTypeBeforeHandler.apply(typeName, null, this.context.features);
                    }
                    if (filterClass != null) {
                        autoTypeObjectReader = this.context.getObjectReader(filterClass);
                        return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
                    }
                }
                v0 = supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                if (!supportAutoType) {
                    if (this.isObject()) {
                        return this.readObject();
                    }
                    if (this.isArray()) {
                        return this.readArray();
                    }
                    throw new JSONException("auoType not support , offset " + this.offset + "/" + this.bytes.length);
                }
                autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                    throw new JSONException("auoType not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                }
                return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
            }
            case -78: {
                return 0.0;
            }
            case -77: {
                return 1.0;
            }
            case -112: {
                intValue = this.readInt32Value();
                return Character.valueOf((char)intValue);
            }
            case -90: {
                map = null;
                supportAutoType = (this.context.features & JSONReader.Feature.SupportAutoType.mask) != 0L;
                i = 0;
                while (true) {
                    if ((type = this.bytes[this.offset]) == -91) {
                        ++this.offset;
                        break;
                    }
                    if (supportAutoType && i == 0 && type >= 73) {
                        hash = this.readFieldNameHashCode();
                        if (hash == ObjectReader.HASH_TYPE) {
                            typeHash = this.readValueHashCode();
                            autoTypeObjectReader = this.context.getObjectReaderAutoType(typeHash);
                            if (autoTypeObjectReader == null && (autoTypeObjectReader = this.context.getObjectReaderAutoType(typeName = this.getString(), null)) == null) {
                                throw new JSONException("auotype not support : " + typeName + ", offset " + this.offset + "/" + this.bytes.length);
                            }
                            this.typeRedirect = true;
                            return autoTypeObjectReader.readJSONBObject(this, null, null, 0L);
                        }
                        name = this.getFieldName();
                    } else {
                        name = type >= 73 ? this.readFieldName() : this.readAny();
                    }
                    if (map == null) {
                        map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap<K, V>() : new JSONObject();
                    }
                    if (this.isReference()) {
                        reference = this.readReference();
                        if ("..".equals(reference)) {
                            map.put(name, map);
                        } else {
                            this.addResolveTask(map, name, JSONPath.of(reference));
                            map.put(name, null);
                        }
                    } else {
                        valueType = this.bytes[this.offset];
                        if (valueType >= 73 && valueType <= 126) {
                            value = this.readString();
                        } else if (valueType >= -16 && valueType <= 47) {
                            ++this.offset;
                            value = (int)valueType;
                        } else if (valueType == -79) {
                            ++this.offset;
                            value = Boolean.TRUE;
                        } else if (valueType == -80) {
                            ++this.offset;
                            value = Boolean.FALSE;
                        } else {
                            value = valueType == -90 ? this.readObject() : this.readAny();
                        }
                        if (value != null || (this.context.features & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) {
                            map.put(name, value);
                        }
                    }
                    ++i;
                }
                if (map == null) {
                    map = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new HashMap() : new JSONObject();
                }
                return map;
            }
        }
        if (this.type >= -16 && this.type <= 47) {
            return (int)this.type;
        }
        if (this.type >= 48 && this.type <= 63) {
            return (this.type - 56 << 8) + (this.bytes[this.offset++] & 255);
        }
        if (this.type >= 64 && this.type <= 71) {
            int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, this.type);
            this.offset += 2;
            return int3;
        }
        if (this.type >= -40 && this.type <= -17) {
            return -8L + (long)(this.type - -40);
        }
        if (this.type >= -56 && this.type <= -41) {
            return (long)(this.type - -48 << 8) + (long)(this.bytes[this.offset++] & 255);
        }
        if (this.type >= -64 && this.type <= -57) {
            return (long)((this.type - -60 << 16) + ((this.bytes[this.offset++] & 255) << 8) + (this.bytes[this.offset++] & 255));
        }
        if (this.type >= -108 && this.type <= -92) {
            v1 = len = this.type == -92 ? this.readLength() : this.type - -108;
            if (len == 0) {
                if ((this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L) {
                    return new ArrayList<E>();
                }
                if (this.context.arraySupplier != null) {
                    return this.context.arraySupplier.get();
                }
                return new JSONArray();
            }
            list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
            for (i = 0; i < len; ++i) {
                if (this.isReference()) {
                    reference = this.readReference();
                    if ("..".equals(reference)) {
                        list.add(list);
                        continue;
                    }
                    list.add(null);
                    this.addResolveTask(list, i, JSONPath.of(reference));
                    continue;
                }
                item = this.readAny();
                list.add(item);
            }
            return list;
        }
        if (this.type >= 73 && this.type <= 121) {
            v2 = this.strlen = this.type == 121 ? this.readLength() : this.type - 73;
            if (this.strlen < 0) {
                return this.symbolTable.getName(-this.strlen);
            }
            str = new String(this.bytes, this.offset, this.strlen, IOUtils.ISO_8859_1);
            this.offset += this.strlen;
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            return str;
        }
        if (this.type == 127) {
            this.strlen = this.readLength();
            if (this.strlen >= 0) {
                throw new JSONException("not support symbol : " + this.strlen);
            }
            return this.symbolTable.getName(-this.strlen);
        }
        throw new JSONException("not support type : " + this.error(this.type));
    }

    @Override
    public final byte getType() {
        return this.bytes[this.offset];
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public final List readArray() {
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        int i = 0;
        while (true) {
            block24: {
                void var5_5;
                block9: {
                    JSONArray list;
                    int len;
                    block18: {
                        block22: {
                            String reference;
                            block23: {
                                byte valueType;
                                block21: {
                                    block20: {
                                        block19: {
                                            block16: {
                                                block17: {
                                                    block15: {
                                                        block14: {
                                                            block13: {
                                                                block12: {
                                                                    block11: {
                                                                        block10: {
                                                                            if (i >= entryCnt) {
                                                                                return array;
                                                                            }
                                                                            valueType = this.bytes[this.offset];
                                                                            if (valueType < 73 || valueType > 126) break block10;
                                                                            String string = this.readString();
                                                                            break block9;
                                                                        }
                                                                        if (valueType < -16 || valueType > 47) break block11;
                                                                        ++this.offset;
                                                                        Integer n = valueType;
                                                                        break block9;
                                                                    }
                                                                    if (valueType != -79) break block12;
                                                                    ++this.offset;
                                                                    Boolean bl = Boolean.TRUE;
                                                                    break block9;
                                                                }
                                                                if (valueType != -80) break block13;
                                                                ++this.offset;
                                                                Boolean bl = Boolean.FALSE;
                                                                break block9;
                                                            }
                                                            if (valueType != -90) break block14;
                                                            Map<String, Object> map = this.readObject();
                                                            break block9;
                                                        }
                                                        if (valueType != -66) break block15;
                                                        ++this.offset;
                                                        long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                                                        this.offset += 8;
                                                        Long l = JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
                                                        break block9;
                                                    }
                                                    if (valueType < -108 || valueType > -92) break block16;
                                                    ++this.offset;
                                                    int n = len = valueType == -92 ? this.readLength() : valueType - -108;
                                                    if (len != 0) break block17;
                                                    if ((this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L) {
                                                        ArrayList arrayList = new ArrayList();
                                                        break block9;
                                                    } else if (this.context.arraySupplier != null) {
                                                        List list2 = this.context.arraySupplier.get();
                                                        break block9;
                                                    } else {
                                                        JSONArray jSONArray = new JSONArray();
                                                    }
                                                    break block9;
                                                }
                                                list = (this.context.features & JSONReader.Feature.UseNativeObject.mask) != 0L ? new ArrayList(len) : new JSONArray(len);
                                                break block18;
                                            }
                                            if (valueType < 48 || valueType > 63) break block19;
                                            Integer n = (valueType - 56 << 8) + (this.bytes[this.offset + 1] & 0xFF);
                                            this.offset += 2;
                                            break block9;
                                        }
                                        if (valueType < 64 || valueType > 71) break block20;
                                        int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset + 1, valueType);
                                        this.offset += 3;
                                        Integer n = new Integer(int3);
                                        break block9;
                                    }
                                    if (valueType != 72) break block21;
                                    int int32Value = IOUtils.getInt(this.bytes, this.offset + 1);
                                    this.offset += 5;
                                    Integer n = new Integer(int32Value);
                                    break block9;
                                }
                                if (valueType != -109) break block22;
                                reference = this.readReference();
                                if (!"..".equals(reference)) break block23;
                                JSONArray jSONArray = array;
                                break block9;
                            }
                            this.addResolveTask(array, i, JSONPath.of(reference));
                            break block24;
                        }
                        Object object = this.readAny();
                        break block9;
                    }
                    for (int j = 0; j < len; ++j) {
                        if (this.isReference()) {
                            String reference = this.readReference();
                            if ("..".equals(reference)) {
                                list.add(list);
                                continue;
                            }
                            list.add(null);
                            this.addResolveTask(list, j, JSONPath.of(reference));
                            continue;
                        }
                        byte itemType = this.bytes[this.offset];
                        Object item = itemType >= 73 && itemType <= 126 ? this.readString() : (itemType == -90 ? this.readObject() : this.readAny());
                        list.add(item);
                    }
                    JSONArray jSONArray = list;
                }
                array.add(var5_5);
            }
            ++i;
        }
    }

    @Override
    public final List readArray(Type itemType) {
        if (this.nextIfNull()) {
            return null;
        }
        if (this.bytes[this.offset] == -110) {
            Object obj = this.readAny();
            if (obj instanceof List) {
                return (List)obj;
            }
            if (obj instanceof Collection) {
                return new JSONArray((Collection<?>)((Collection)obj));
            }
            throw new JSONException("not support class " + obj.getClass());
        }
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            array.add(this.read(itemType));
        }
        return array;
    }

    @Override
    public final List readList(Type[] types) {
        if (this.nextIfNull()) {
            return null;
        }
        int entryCnt = this.startArray();
        JSONArray array = new JSONArray(entryCnt);
        for (int i = 0; i < entryCnt; ++i) {
            Type itemType = types[i];
            array.add(this.read(itemType));
        }
        return array;
    }

    @Override
    public final byte[] readHex() {
        String str = this.readString();
        byte[] bytes = new byte[str.length() / 2];
        for (int i = 0; i < bytes.length; ++i) {
            char c0 = str.charAt(i * 2);
            char c1 = str.charAt(i * 2 + 1);
            int b0 = c0 - (c0 <= '9' ? 48 : 55);
            int b1 = c1 - (c1 <= '9' ? 48 : 55);
            bytes[i] = (byte)(b0 << 4 | b1);
        }
        return bytes;
    }

    @Override
    public final boolean isReference() {
        return this.offset < this.bytes.length && this.bytes[this.offset] == -109;
    }

    @Override
    public final String readReference() {
        if (this.bytes[this.offset] != -109) {
            return null;
        }
        ++this.offset;
        if (this.isString()) {
            return this.readString();
        }
        throw new JSONException("reference not support input " + this.error(this.type));
    }

    @Override
    public final ObjectReader checkAutoType(Class expectClass, long expectClassHash, long features) {
        ObjectReader autoTypeObjectReader = null;
        byte type = this.bytes[this.offset];
        if (type == -110) {
            ClassLoader tcl;
            ClassLoader classLoader;
            Class objectClass;
            long features2;
            boolean isSupportAutoType;
            ObjectReader objectReader;
            Class<Object> objectClass2;
            ++this.offset;
            long typeHash = this.readTypeHashCode();
            ObjectReaderProvider provider = this.context.provider;
            if (expectClassHash == typeHash && (objectClass2 = (objectReader = this.context.getObjectReader(expectClass)).getObjectClass()) != null && objectClass2 == expectClass) {
                provider.registerIfAbsent(typeHash, objectReader);
                return objectReader;
            }
            JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler = this.context.autoTypeBeforeHandler;
            if (autoTypeBeforeHandler != null) {
                ObjectReader objectReader2;
                objectClass2 = autoTypeBeforeHandler.apply(typeHash, expectClass, features);
                if (objectClass2 == null) {
                    objectClass2 = autoTypeBeforeHandler.apply(this.getString(), expectClass, features);
                }
                if (objectClass2 != null && (objectReader2 = this.context.getObjectReader(objectClass2)) != null) {
                    return objectReader2;
                }
            }
            boolean bl = isSupportAutoType = ((features2 = this.context.features | features) & JSONReader.Feature.SupportAutoType.mask) != 0L;
            if (!isSupportAutoType) {
                if ((features2 & JSONReader.Feature.ErrorOnNotSupportAutoType.mask) == 0L) {
                    return null;
                }
                this.autoTypeError();
            }
            if ((autoTypeObjectReader = provider.getObjectReader(typeHash)) != null && (objectClass = autoTypeObjectReader.getObjectClass()) != null && (classLoader = objectClass.getClassLoader()) != null && classLoader != (tcl = Thread.currentThread().getContextClassLoader())) {
                autoTypeObjectReader = this.getObjectReaderContext(autoTypeObjectReader, objectClass, tcl);
            }
            if (autoTypeObjectReader == null && (autoTypeObjectReader = provider.getObjectReader(this.getString(), expectClass, features2)) == null) {
                this.autoTypeError();
            }
            this.type = this.bytes[this.offset];
        }
        return autoTypeObjectReader;
    }

    final void autoTypeError() {
        throw new JSONException("auotype not support : " + this.getString());
    }

    private ObjectReader getObjectReaderContext(ObjectReader autoTypeObjectReader, Class objectClass, ClassLoader contextClassLoader) {
        String typeName = this.getString();
        Class<?> contextClass = TypeUtils.getMapping(typeName);
        if (contextClass == null) {
            try {
                if (contextClassLoader == null) {
                    contextClassLoader = JSON.class.getClassLoader();
                }
                contextClass = contextClassLoader.loadClass(typeName);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        if (contextClass != null && !objectClass.equals(contextClass)) {
            autoTypeObjectReader = this.getObjectReader(contextClass);
        }
        return autoTypeObjectReader;
    }

    @Override
    public final int startArray() {
        byte type;
        if ((type = (this.type = this.bytes[this.offset++])) == -81) {
            return -1;
        }
        if (type >= -108 && type <= -93) {
            this.ch = (char)(-type);
            return type - -108;
        }
        if (type == -111) {
            return this.readInt32Value();
        }
        if (type != -92) {
            throw new JSONException("array not support input " + this.error(type));
        }
        return this.readInt32Value();
    }

    public final String error(byte type) {
        StringBuilder buf = new StringBuilder();
        buf.append(JSONB.typeName(type));
        if (this.isString()) {
            int mark = this.offset--;
            String str = null;
            try {
                str = this.readString();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (str != null) {
                buf.append(' ');
                buf.append(str);
            }
            this.offset = mark;
        }
        buf.append(", offset ");
        buf.append(this.offset);
        buf.append('/');
        buf.append(this.bytes.length);
        return buf.toString();
    }

    @Override
    public final void next() {
        ++this.offset;
    }

    @Override
    public long readFieldNameHashCode() {
        long hashCode;
        boolean typeSymbol;
        this.strtype = this.bytes[this.offset++];
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            this.strtype = this.bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol;
                if (this.strtype <= 47) {
                    ++this.offset;
                    symbol = this.strtype;
                } else {
                    symbol = this.readInt32Value();
                }
                if (symbol < 0) {
                    return this.symbolTable.getHashCode(-symbol);
                }
                if (symbol == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    if (this.symbol0Hash == 0L) {
                        this.symbol0Hash = this.getNameHashCode();
                    }
                    return this.symbol0Hash;
                }
                int index = symbol * 2;
                long strInfo = this.symbols[index + 1];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                long nameHashCode = this.symbols[index];
                if (nameHashCode == 0L) {
                    this.symbols[index] = nameHashCode = this.getNameHashCode();
                }
                return nameHashCode;
            }
            ++this.offset;
        }
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            StringBuffer message = new StringBuffer().append("fieldName not support input type ").append(JSONB.typeName(this.strtype));
            if (this.strtype == -109) {
                message.append(" ").append(this.readString());
            }
            message.append(", offset ").append(this.offset);
            throw new JSONException(message.toString());
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else {
            long nameValue = 0L;
            if (this.strlen <= 8) {
                if (JDKUtils.BIG_ENDIAN) {
                    switch (this.strlen) {
                        case 1: {
                            nameValue = this.bytes[this.offset];
                            break;
                        }
                        case 2: {
                            nameValue = (long)JDKUtils.UNSAFE.getShort(this.bytes, BASE + (long)this.offset) & 0xFFFFL;
                            break;
                        }
                        case 3: {
                            nameValue = (long)(this.bytes[this.offset + 2] << 16) + ((long)JDKUtils.UNSAFE.getShort(this.bytes, BASE + (long)this.offset) & 0xFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)this.bytes[this.offset + 4] << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)JDKUtils.UNSAFE.getShort(this.bytes, BASE + (long)this.offset + 4L) << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 8: {
                            nameValue = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset);
                            break;
                        }
                    }
                } else {
                    switch (this.strlen) {
                        case 1: {
                            nameValue = this.bytes[this.offset];
                            break;
                        }
                        case 2: {
                            nameValue = (this.bytes[this.offset + 1] << 8) + (this.bytes[this.offset] & 0xFF);
                            break;
                        }
                        case 3: {
                            nameValue = (this.bytes[this.offset + 2] << 16) + ((this.bytes[this.offset + 1] & 0xFF) << 8) + (this.bytes[this.offset] & 0xFF);
                            break;
                        }
                        case 4: {
                            nameValue = (this.bytes[this.offset + 3] << 24) + ((this.bytes[this.offset + 2] & 0xFF) << 16) + ((this.bytes[this.offset + 1] & 0xFF) << 8) + (this.bytes[this.offset] & 0xFF);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)this.bytes[this.offset + 4] << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 8: {
                            nameValue = ((long)this.bytes[this.offset + 7] << 56) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                    }
                }
            }
            if (nameValue != 0L) {
                this.offset += this.strlen;
                hashCode = nameValue;
            } else {
                hashCode = -3750763034362895579L;
                for (int i = 0; i < this.strlen; ++i) {
                    byte c = this.bytes[this.offset++];
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
            }
        }
        if (typeSymbol) {
            int symbol;
            this.type = this.bytes[this.offset];
            if (this.type >= -16 && this.type <= 47) {
                symbol = this.type;
                ++this.offset;
            } else {
                symbol = this.readInt32Value();
            }
            if (symbol == 0) {
                this.symbol0Begin = this.strBegin;
                this.symbol0Length = this.strlen;
                this.symbol0StrType = this.strtype;
                this.symbol0Hash = hashCode;
                return hashCode;
            }
            long strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
            int minCapacity = symbol * 2 + 2;
            if (this.symbols == null) {
                this.symbols = new long[minCapacity < 32 ? 32 : minCapacity];
            } else if (this.symbols.length < minCapacity) {
                this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
            }
            this.symbols[symbol * 2] = hashCode;
            this.symbols[symbol * 2 + 1] = strInfo;
        }
        return hashCode;
    }

    @Override
    public final boolean isInt() {
        byte type = this.bytes[this.offset];
        return type >= -70 && type <= 72 || type == -84 || type == -83 || type == -85;
    }

    @Override
    public final boolean isNull() {
        return this.bytes[this.offset] == -81;
    }

    @Override
    public final Date readNullOrNewDate() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public final void readNull() {
        this.type = this.bytes[this.offset++];
        if (this.type != -81) {
            throw new JSONException("null not match, " + this.type);
        }
    }

    @Override
    public final boolean readIfNull() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public final long readTypeHashCode() {
        int symbol;
        byte c1;
        byte c0;
        long hashCode;
        boolean typeSymbol;
        this.strtype = this.bytes[this.offset];
        byte[] bytes = this.bytes;
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            ++this.offset;
            this.strtype = bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol2;
                if (this.strtype <= 47) {
                    ++this.offset;
                    symbol2 = this.strtype;
                } else {
                    symbol2 = this.readInt32Value();
                }
                if (symbol2 < 0) {
                    return this.symbolTable.getHashCode(-symbol2);
                }
                if (symbol2 == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    if (this.symbol0Hash == 0L) {
                        this.symbol0Hash = this.getNameHashCode();
                    }
                    return this.symbol0Hash;
                }
                int index = symbol2 * 2;
                long strInfo = this.symbols[index + 1];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                long nameHashCode = this.symbols[index];
                if (nameHashCode == 0L) {
                    this.symbols[index] = nameHashCode = this.getNameHashCode();
                }
                return nameHashCode;
            }
        }
        if (this.strtype >= -16 && this.strtype <= 72) {
            long refTypeHash;
            int typeIndex;
            if (this.strtype <= 47) {
                ++this.offset;
                typeIndex = this.strtype;
            } else if (this.strtype <= 63) {
                ++this.offset;
                typeIndex = (this.strtype - 56 << 8) + (bytes[this.offset++] & 0xFF);
            } else {
                typeIndex = this.readInt32Value();
            }
            if (typeIndex == 0) {
                this.strtype = this.symbol0StrType;
                this.strlen = this.symbol0Length;
                this.strBegin = this.symbol0Begin;
                if (this.symbol0Hash == 0L) {
                    this.symbol0Hash = Fnv.hashCode64(this.getString());
                }
                refTypeHash = this.symbol0Hash;
            } else if (typeIndex < 0) {
                this.strlen = this.strtype;
                refTypeHash = this.symbolTable.getHashCode(-typeIndex);
            } else {
                refTypeHash = this.symbols[typeIndex * 2];
                if (refTypeHash == 0L) {
                    long strInfo = this.symbols[typeIndex * 2 + 1];
                    this.strtype = (byte)strInfo;
                    this.strlen = (int)strInfo >> 8;
                    this.strBegin = (int)(strInfo >> 32);
                    refTypeHash = Fnv.hashCode64(this.getString());
                }
            }
            if (refTypeHash == -1L) {
                throw new JSONException("type ref not found : " + typeIndex);
            }
            return refTypeHash;
        }
        ++this.offset;
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            int strType = bytes[this.offset];
            if (strType >= -16 && strType <= 47) {
                ++this.offset;
                this.strlen = strType;
            } else if (strType >= 48 && strType <= 63) {
                ++this.offset;
                this.strlen = (strType - 56 << 8) + (bytes[this.offset++] & 0xFF);
            } else {
                this.strlen = this.readLength();
            }
            this.strBegin = this.offset;
        } else {
            throw new JSONException("string value not support input " + JSONB.typeName(this.type) + " offset " + this.offset + "/" + bytes.length);
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (this.strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                int c = bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = bytes[this.offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = bytes[this.offset + 1];
                            byte c3 = bytes[this.offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 123 || this.strtype == 125) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                c0 = bytes[this.offset + i];
                c1 = bytes[this.offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 124) {
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                c0 = bytes[this.offset + i];
                c1 = bytes[this.offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            int i;
            long nameValue = 0L;
            if (this.strlen <= 8) {
                int start = this.offset;
                for (i = 0; i < this.strlen; ++i) {
                    byte c = bytes[this.offset];
                    if (c < 0 || c == 0 && bytes[start] == 0) {
                        nameValue = 0L;
                        this.offset = start;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++this.offset;
                }
            }
            if (nameValue != 0L) {
                hashCode = nameValue;
            } else {
                hashCode = -3750763034362895579L;
                for (i = 0; i < this.strlen; ++i) {
                    byte c = bytes[this.offset++];
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                }
            }
        }
        this.type = bytes[this.offset];
        if (this.type >= -16 && this.type <= 47) {
            symbol = this.type;
            ++this.offset;
        } else {
            symbol = this.readInt32Value();
        }
        if (symbol == 0) {
            this.symbol0Begin = this.strBegin;
            this.symbol0Length = this.strlen;
            this.symbol0StrType = this.strtype;
            this.symbol0Hash = hashCode;
        } else {
            long strInfo;
            int minCapacity = symbol * 2 + 2;
            if (this.symbols == null) {
                this.symbols = new long[minCapacity < 32 ? 32 : minCapacity];
            } else if (this.symbols.length < minCapacity) {
                this.symbols = Arrays.copyOf(this.symbols, minCapacity + 16);
            }
            this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
        }
        return hashCode;
    }

    @Override
    public final long readValueHashCode() {
        long hashCode;
        this.strtype = this.bytes[this.offset];
        ++this.offset;
        this.strBegin = this.offset;
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.strlen = this.strtype - 73;
        } else if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else if (this.strtype == 127) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
        } else {
            throw new JSONException("string value not support input " + JSONB.typeName(this.type) + " offset " + this.offset + "/" + this.bytes.length);
        }
        if (this.strlen < 0) {
            hashCode = this.symbolTable.getHashCode(-this.strlen);
        } else if (this.strtype == 122) {
            hashCode = -3750763034362895579L;
            int end = this.offset + this.strlen;
            while (this.offset < end) {
                int c = this.bytes[this.offset];
                if (c >= 0) {
                    ++this.offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[this.offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            this.offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[this.offset + 1];
                            byte c3 = this.bytes[this.offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + this.offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                            this.offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + this.offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 123) {
            hashCode = -3750763034362895579L;
            if (this.bytes[this.offset] == -2 && this.bytes[this.offset + 1] == -1) {
                if (this.strlen <= 16) {
                    long nameValue = 0L;
                    block44: for (int i = 2; i < this.strlen; i += 2) {
                        byte c1 = this.bytes[this.offset + i + 1];
                        byte c0 = this.bytes[this.offset + i];
                        char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                        if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                            nameValue = 0L;
                            break;
                        }
                        byte c = (byte)ch;
                        switch (i - 2 >> 1) {
                            case 0: {
                                nameValue = c;
                                continue block44;
                            }
                            case 1: {
                                nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                                continue block44;
                            }
                            case 2: {
                                nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                                continue block44;
                            }
                            case 3: {
                                nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                                continue block44;
                            }
                            case 4: {
                                nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                                continue block44;
                            }
                            case 5: {
                                nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                                continue block44;
                            }
                            case 6: {
                                nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                                continue block44;
                            }
                        }
                    }
                    if (nameValue != 0L) {
                        return nameValue;
                    }
                }
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else if (this.bytes[this.offset] == -1 && this.bytes[this.offset + 1] == -2) {
                for (int i = 2; i < this.strlen; i += 2) {
                    byte c1 = this.bytes[this.offset + i];
                    byte c0 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            } else {
                for (int i = 0; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
            }
        } else if (this.strtype == 125) {
            if (this.strlen <= 16) {
                long nameValue = 0L;
                block48: for (int i = 0; i < this.strlen; i += 2) {
                    byte c1 = this.bytes[this.offset + i + 1];
                    byte c0 = this.bytes[this.offset + i];
                    char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                    if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                        nameValue = 0L;
                        break;
                    }
                    byte c = (byte)ch;
                    switch (i >> 1) {
                        case 0: {
                            nameValue = c;
                            continue block48;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            continue block48;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            continue block48;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            continue block48;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            continue block48;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            continue block48;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            continue block48;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            continue block48;
                        }
                    }
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = this.bytes[this.offset + i];
                byte c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c1 & 0xFF | (c0 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else if (this.strtype == 124) {
            if (this.strlen <= 16) {
                long nameValue = 0L;
                block50: for (int i = 0; i < this.strlen; i += 2) {
                    byte c0 = this.bytes[this.offset + i];
                    byte c1 = this.bytes[this.offset + i + 1];
                    char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                    if (ch > '\u007f' || i == 0 && ch == '\u0000') {
                        nameValue = 0L;
                        break;
                    }
                    byte c = (byte)ch;
                    switch (i >> 1) {
                        case 0: {
                            nameValue = c;
                            continue block50;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            continue block50;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            continue block50;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            continue block50;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            continue block50;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            continue block50;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            continue block50;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            continue block50;
                        }
                    }
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; i += 2) {
                byte c0 = this.bytes[this.offset + i];
                byte c1 = this.bytes[this.offset + i + 1];
                char ch = (char)(c0 & 0xFF | (c1 & 0xFF) << 8);
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
        } else {
            if (this.strlen <= 8) {
                long nameValue = 0L;
                int start = this.offset;
                for (int i = 0; i < this.strlen; ++i) {
                    byte c = this.bytes[this.offset];
                    if (c < 0 || c == 0 && this.bytes[start] == 0) {
                        nameValue = 0L;
                        this.offset = start;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++this.offset;
                }
                if (nameValue != 0L) {
                    return nameValue;
                }
            }
            hashCode = -3750763034362895579L;
            for (int i = 0; i < this.strlen; ++i) {
                byte c = this.bytes[this.offset++];
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
        }
        return hashCode;
    }

    protected final long getNameHashCode() {
        byte c;
        int offset = this.strBegin;
        long nameValue = 0L;
        int i = 0;
        while (i < this.strlen) {
            c = this.bytes[offset];
            if (c < 0 || i >= 8 || i == 0 && this.bytes[this.strBegin] == 0) {
                offset = this.strBegin;
                nameValue = 0L;
                break;
            }
            switch (i) {
                case 0: {
                    nameValue = c;
                    break;
                }
                case 1: {
                    nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
            ++offset;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        for (i = 0; i < this.strlen; ++i) {
            c = this.bytes[offset++];
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public final long getNameHashCodeLCase() {
        byte c;
        int offset = this.strBegin;
        long nameValue = 0L;
        int i = 0;
        while (i < this.strlen) {
            byte c1;
            c = this.bytes[offset];
            if (c < 0 || i >= 8 || i == 0 && this.bytes[this.strBegin] == 0) {
                offset = this.strBegin;
                nameValue = 0L;
                break;
            }
            if (c != 95 && c != 45 && c != 32 || (c1 = this.bytes[offset + 1]) == c) {
                if (c >= 65 && c <= 90) {
                    c = (byte)(c + 32);
                }
                switch (i) {
                    case 0: {
                        nameValue = c;
                        break;
                    }
                    case 1: {
                        nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++i;
            }
            ++offset;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        for (i = 0; i < this.strlen; ++i) {
            if ((c = this.bytes[offset++]) >= 65 && c <= 90) {
                c = (byte)(c + 32);
            }
            if (c == 95 || c == 45 || c == 32) continue;
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public void skipValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -108: 
            case -81: 
            case -80: 
            case -79: 
            case 73: {
                return;
            }
            case -67: {
                ++this.offset;
                return;
            }
            case -68: {
                this.offset += 2;
                return;
            }
            case -84: 
            case -83: 
            case -73: 
            case 72: {
                this.offset += 4;
                return;
            }
            case -74: {
                this.readInt32Value();
                return;
            }
            case -85: 
            case -75: 
            case -66: {
                this.offset += 8;
                return;
            }
            case -76: {
                this.readInt64Value();
                return;
            }
            case -71: {
                this.readInt32Value();
                this.readBigInteger();
                return;
            }
            case -72: {
                this.readInt64Value();
                return;
            }
            case -89: {
                this.offset += 3;
                this.readInt32Value();
                return;
            }
            case -88: {
                this.offset += 7;
                this.readInt32Value();
                return;
            }
            case -86: {
                this.offset += 7;
                this.readInt32Value();
                this.readString();
                return;
            }
            case -111: {
                int byteslen = this.readInt32Value();
                this.offset += byteslen;
                return;
            }
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: {
                int strlen = this.readInt32Value();
                this.offset += strlen;
                return;
            }
            case -110: {
                this.readTypeHashCode();
                this.skipValue();
                return;
            }
            case -90: {
                int i = 0;
                while (true) {
                    if (this.bytes[this.offset] == -91) {
                        ++this.offset;
                        break;
                    }
                    this.skipName();
                    this.skipValue();
                    ++i;
                }
                return;
            }
            case -109: {
                if (this.isString()) {
                    this.skipName();
                    return;
                }
                throw new JSONException("skip not support type " + JSONB.typeName(type));
            }
        }
        if (type >= -16 && type <= 47) {
            return;
        }
        if (type >= -40 && type <= -17) {
            return;
        }
        if (type >= 48 && type <= 63) {
            ++this.offset;
            return;
        }
        if (type >= 73 && type <= 120) {
            this.offset += type - 73;
            return;
        }
        if (type >= -56 && type <= -41) {
            ++this.offset;
            return;
        }
        if (type >= -108 && type <= -92) {
            int itemCnt = type == -92 ? this.readInt32Value() : type - -108;
            for (int i = 0; i < itemCnt; ++i) {
                this.skipValue();
            }
            return;
        }
        throw new JSONException("skip not support type " + JSONB.typeName(type));
    }

    @Override
    public final boolean skipName() {
        this.strtype = this.bytes[this.offset++];
        if (this.strtype >= 73 && this.strtype <= 120) {
            this.offset += this.strtype - 73;
            return true;
        }
        if (this.strtype == 121 || this.strtype == 122 || this.strtype == 123 || this.strtype == 124 || this.strtype == 125) {
            this.strlen = this.readLength();
            this.offset += this.strlen;
            return true;
        }
        if (this.strtype == 127) {
            byte type = this.bytes[this.offset];
            if (type >= -16 && type <= 72) {
                this.readInt32Value();
                return true;
            }
            String str = this.readString();
            this.readInt32Value();
            return true;
        }
        throw new JSONException("name not support input : " + JSONB.typeName(this.strtype));
    }

    @Override
    public String readFieldName() {
        Charset charset;
        boolean typeSymbol;
        this.strtype = this.bytes[this.offset];
        if (this.strtype == -81) {
            ++this.offset;
            return null;
        }
        ++this.offset;
        boolean bl = typeSymbol = this.strtype == 127;
        if (typeSymbol) {
            this.strtype = this.bytes[this.offset];
            if (this.strtype >= -16 && this.strtype <= 72) {
                int symbol = this.readInt32Value();
                if (symbol < 0) {
                    return this.symbolTable.getName(-symbol);
                }
                if (symbol == 0) {
                    this.strtype = this.symbol0StrType;
                    this.strlen = this.symbol0Length;
                    this.strBegin = this.symbol0Begin;
                    return this.getString();
                }
                int index = symbol * 2 + 1;
                long strInfo = this.symbols[index];
                this.strtype = (byte)strInfo;
                this.strlen = (int)strInfo >> 8;
                this.strBegin = (int)(strInfo >> 32);
                return this.getString();
            }
            ++this.offset;
        }
        this.strBegin = this.offset;
        String str = null;
        if (this.strtype == 74) {
            str = TypeUtils.toString((char)(this.bytes[this.offset] & 0xFF));
            this.strlen = 1;
            ++this.offset;
            charset = IOUtils.ISO_8859_1;
        } else if (this.strtype == 75) {
            str = TypeUtils.toString((char)(this.bytes[this.offset] & 0xFF), (char)(this.bytes[this.offset + 1] & 0xFF));
            this.strlen = 2;
            this.offset += 2;
            charset = IOUtils.ISO_8859_1;
        } else if (this.strtype >= 73 && this.strtype <= 121) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            if (this.strtype == 121) {
                this.strlen = this.readLength();
                this.strBegin = this.offset;
            } else {
                this.strlen = this.strtype - 73;
                if (JDKUtils.BIG_ENDIAN) {
                    switch (this.strlen) {
                        case 3: {
                            nameValue0 = (long)(this.bytes[this.offset + 2] << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 4: {
                            nameValue0 = JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset);
                            break;
                        }
                        case 5: {
                            nameValue0 = ((long)this.bytes[this.offset + 4] << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue0 = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue0 = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            break;
                        }
                        case 8: {
                            nameValue0 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset);
                            break;
                        }
                        case 9: {
                            nameValue0 = this.bytes[this.offset];
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 1L);
                            break;
                        }
                        case 10: {
                            nameValue0 = JDKUtils.UNSAFE.getShort(this.bytes, BASE + (long)this.offset);
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 2L);
                            break;
                        }
                        case 11: {
                            nameValue0 = (long)(this.bytes[this.offset] << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 2] & 0xFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 3L);
                            break;
                        }
                        case 12: {
                            nameValue0 = JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset);
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 4L);
                            break;
                        }
                        case 13: {
                            nameValue0 = ((long)this.bytes[this.offset + 4] << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 5L);
                            break;
                        }
                        case 14: {
                            nameValue0 = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 6L);
                            break;
                        }
                        case 15: {
                            nameValue0 = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + ((long)JDKUtils.UNSAFE.getInt(this.bytes, BASE + (long)this.offset) & 0xFFFFFFFFL);
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 7L);
                            break;
                        }
                        case 16: {
                            nameValue0 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset);
                            nameValue1 = JDKUtils.UNSAFE.getLong(this.bytes, BASE + (long)this.offset + 8L);
                            break;
                        }
                    }
                } else {
                    switch (this.strlen) {
                        case 3: {
                            nameValue0 = (long)(this.bytes[this.offset + 2] << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 4: {
                            nameValue0 = (long)(this.bytes[this.offset + 3] << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 5: {
                            nameValue0 = ((long)this.bytes[this.offset + 4] << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 6: {
                            nameValue0 = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 0] & 0xFFL);
                            break;
                        }
                        case 7: {
                            nameValue0 = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 8: {
                            nameValue0 = ((long)this.bytes[this.offset + 7] << 56) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            break;
                        }
                        case 9: {
                            nameValue0 = this.bytes[this.offset + 0];
                            nameValue1 = ((long)this.bytes[this.offset + 8] << 56) + (long)(this.bytes[this.offset + 7] << 48) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 1] & 0xFFL);
                            break;
                        }
                        case 10: {
                            nameValue0 = (long)(this.bytes[this.offset + 1] << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)this.bytes[this.offset + 9] << 56) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 2] & 0xFFL);
                            break;
                        }
                        case 11: {
                            nameValue0 = (long)(this.bytes[this.offset + 2] << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)this.bytes[this.offset + 10] << 56) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 3] & 0xFFL);
                            break;
                        }
                        case 12: {
                            nameValue0 = (long)(this.bytes[this.offset + 3] << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)this.bytes[this.offset + 11] << 56) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 4] & 0xFFL);
                            break;
                        }
                        case 13: {
                            nameValue0 = ((long)this.bytes[this.offset + 4] << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)this.bytes[this.offset + 12] << 56) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 6] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 5] & 0xFFL);
                            break;
                        }
                        case 14: {
                            nameValue0 = ((long)this.bytes[this.offset + 5] << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)this.bytes[this.offset + 13] << 56) + (((long)this.bytes[this.offset + 12] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 7] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 6] & 0xFFL);
                            break;
                        }
                        case 15: {
                            nameValue0 = ((long)this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)this.bytes[this.offset + 14] << 56) + (((long)this.bytes[this.offset + 13] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 12] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 8] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 7] & 0xFFL);
                            break;
                        }
                        case 16: {
                            nameValue0 = ((long)this.bytes[this.offset + 7] << 56) + (long)(this.bytes[this.offset + 6] << 48) + (((long)this.bytes[this.offset + 5] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 4] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 3] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 2] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 1] & 0xFFL) << 8) + ((long)this.bytes[this.offset] & 0xFFL);
                            nameValue1 = ((long)this.bytes[this.offset + 15] << 56) + (((long)this.bytes[this.offset + 14] & 0xFFL) << 48) + (((long)this.bytes[this.offset + 13] & 0xFFL) << 40) + (((long)this.bytes[this.offset + 12] & 0xFFL) << 32) + (((long)this.bytes[this.offset + 11] & 0xFFL) << 24) + (((long)this.bytes[this.offset + 10] & 0xFFL) << 16) + (((long)this.bytes[this.offset + 9] & 0xFFL) << 8) + ((long)this.bytes[this.offset + 8] & 0xFFL);
                            break;
                        }
                    }
                }
            }
            if (this.bytes[this.offset + this.strlen - 1] > 0 && nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    long nameValue01 = nameValue0 ^ nameValue1;
                    int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        str = new String(this.bytes, this.offset, this.strlen, IOUtils.ISO_8859_1);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(str, nameValue0, nameValue1);
                        this.offset += this.strlen;
                    } else if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        this.offset += this.strlen;
                        str = entry.name;
                    }
                } else {
                    int indexMask = (int)(nameValue0 ^ nameValue0 >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                    NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        str = new String(this.bytes, this.offset, this.strlen, IOUtils.ISO_8859_1);
                        JSONFactory.NAME_CACHE[indexMask] = new NameCacheEntry(str, nameValue0);
                        this.offset += this.strlen;
                    } else if (entry.value == nameValue0) {
                        this.offset += this.strlen;
                        str = entry.name;
                    }
                }
            }
            charset = IOUtils.ISO_8859_1;
        } else if (this.strtype == 122) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = IOUtils.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = IOUtils.UTF_16;
        } else if (this.strtype == 124) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = IOUtils.UTF_16LE;
        } else if (this.strtype == 125) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = IOUtils.UTF_16BE;
        } else if (this.strtype == 126) {
            this.strlen = this.readLength();
            if (GB18030 == null) {
                GB18030 = Charset.forName("GB18030");
            }
            charset = GB18030;
        } else {
            charset = IOUtils.UTF_8;
        }
        if (this.strlen < 0) {
            str = this.symbolTable.getName(-this.strlen);
        }
        if (str == null) {
            str = new String(this.bytes, this.offset, this.strlen, charset);
            this.offset += this.strlen;
        }
        if (typeSymbol) {
            int symbol = this.readInt32Value();
            if (symbol == 0) {
                this.symbol0Begin = this.strBegin;
                this.symbol0Length = this.strlen;
                this.symbol0StrType = this.strtype;
            } else {
                long strInfo;
                if (this.symbols == null) {
                    this.symbols = new long[symbol * 2 + 2 < 32 ? 32 : symbol * 2 + 2];
                } else if (this.symbols.length < symbol * 2 + 2) {
                    this.symbols = Arrays.copyOf(this.symbols, this.symbols.length + 16);
                }
                this.symbols[symbol * 2 + 1] = strInfo = ((long)this.strBegin << 32) + ((long)this.strlen << 8) + (long)this.strtype;
            }
        }
        return str;
    }

    @Override
    public final String getFieldName() {
        return this.getString();
    }

    @Override
    public final String readString() {
        byte strtype;
        this.strtype = strtype = this.bytes[this.offset++];
        if (strtype == -81) {
            return null;
        }
        this.strBegin = this.offset;
        boolean ascii = false;
        if (strtype >= 73 && strtype <= 121) {
            int strlen;
            ascii = true;
            if (strtype == 121) {
                int strType = this.bytes[this.offset];
                if (strType >= -16 && strType <= 47) {
                    ++this.offset;
                    strlen = strType;
                } else {
                    strlen = this.readLength();
                }
                this.strBegin = this.offset;
            } else {
                strlen = strtype - 73;
            }
            this.strlen = strlen;
        }
        return this.readStringNonAscii(null, ascii);
    }

    @Override
    public Date readDate() {
        byte month;
        int year;
        byte type = this.bytes[this.offset];
        LocalDateTime ldt = null;
        if (type == -87) {
            ++this.offset;
            year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            LocalDate localDate = LocalDate.of(year, month, dayOfMonth);
            ldt = localDate.atStartOfDay();
        } else if (type == -88) {
            ++this.offset;
            year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            ldt = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nano);
        }
        if (ldt != null) {
            Instant instant = ldt.toInstant(this.context.getZoneId());
            return instant.toDate();
        }
        String str = this.readString();
        long millis = DateUtils.parseMillis(str, ZoneId.DEFAULT_ZONE_ID);
        if (millis == 0L) {
            return null;
        }
        return new Date(millis);
    }

    private String readStringNonAscii(String str, boolean ascii) {
        Charset charset;
        if (ascii) {
            charset = IOUtils.ISO_8859_1;
        } else if (this.strtype == 122) {
            str = this.readStringUTF8();
            charset = IOUtils.UTF_8;
        } else if (this.strtype == 123) {
            this.strlen = this.readLength();
            this.strBegin = this.offset;
            charset = IOUtils.UTF_16;
        } else if (this.strtype == 124) {
            str = this.readUTF16LE();
            charset = IOUtils.UTF_16LE;
        } else if (this.strtype == 125) {
            str = this.readUTF16BE();
            if (str != null) {
                return str;
            }
            charset = IOUtils.UTF_16BE;
        } else if (this.strtype == 126) {
            this.readGB18030();
            charset = GB18030;
        } else {
            return this.readStringTypeNotMatch();
        }
        if (str != null) {
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            return str;
        }
        return this.readString(charset);
    }

    private String readString(Charset charset) {
        if (this.strlen < 0) {
            return this.symbolTable.getName(-this.strlen);
        }
        String str = new String(this.bytes, this.offset, this.strlen, charset);
        this.offset += this.strlen;
        if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
            str = str.trim();
        }
        return str;
    }

    private String readGB18030() {
        this.strlen = this.readLength();
        this.strBegin = this.offset;
        if (GB18030 == null) {
            GB18030 = Charset.forName("GB18030");
        }
        return null;
    }

    private String readUTF16BE() {
        this.strlen = this.readLength();
        this.strBegin = this.offset;
        return null;
    }

    private String readUTF16LE() {
        int strType = this.bytes[this.offset];
        if (strType >= -16 && strType <= 47) {
            ++this.offset;
            this.strlen = strType;
        } else if (strType >= 48 && strType <= 63) {
            ++this.offset;
            this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        } else {
            this.strlen = this.readLength();
        }
        this.strBegin = this.offset;
        if (this.strlen == 0) {
            return "";
        }
        return null;
    }

    private String readStringUTF8() {
        int strType = this.bytes[this.offset];
        if (strType >= -16 && strType <= 47) {
            ++this.offset;
            this.strlen = strType;
        } else if (strType >= 48 && strType <= 63) {
            ++this.offset;
            this.strlen = (strType - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        } else {
            this.strlen = this.readLength();
        }
        this.strBegin = this.offset;
        return null;
    }

    private String readStringTypeNotMatch() {
        if (this.strtype >= -16 && this.strtype <= 47) {
            return Byte.toString(this.strtype);
        }
        if (this.strtype >= 48 && this.strtype <= 63) {
            int intValue = (this.strtype - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return Integer.toString(intValue);
        }
        if (this.strtype >= 64 && this.strtype <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, this.strtype);
            this.offset += 2;
            return Integer.toString(int3);
        }
        if (this.strtype >= -40 && this.strtype <= -17) {
            int intValue = -8 + (this.strtype - -40);
            return Integer.toString(intValue);
        }
        if (this.strtype >= -56 && this.strtype <= -41) {
            int intValue = (this.strtype - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return Integer.toString(intValue);
        }
        if (this.strtype >= -64 && this.strtype <= -57) {
            int intValue = (this.strtype - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return Integer.toString(intValue);
        }
        switch (this.strtype) {
            case -81: {
                return null;
            }
            case -78: {
                return "0.0";
            }
            case -77: {
                return "1.0";
            }
            case -65: 
            case 72: {
                long int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Long.toString(int32Value);
            }
            case -74: {
                return Float.toString(this.readInt32Value());
            }
            case -73: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return Float.toString(floatValue);
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
                return Double.toString(doubleValue);
            }
            case -84: {
                long seconds = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                long millis = seconds * 1000L;
                return DateUtils.toString(millis, false, ZoneId.DEFAULT_ZONE_ID);
            }
            case -83: {
                long minutes = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                long millis = minutes * 60L * 1000L;
                return DateUtils.toString(millis, false, ZoneId.DEFAULT_ZONE_ID);
            }
            case -85: {
                long millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return DateUtils.toString(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis), false, ZoneId.DEFAULT_ZONE_ID);
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                if (!JDKUtils.BIG_ENDIAN) {
                    int64Value = Long.reverseBytes(int64Value);
                }
                this.offset += 8;
                return Long.toString(int64Value);
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes).toString();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.toString();
            }
            case -110: {
                --this.offset;
                Object typedAny = this.readAny();
                return typedAny == null ? null : JSON.toJSONString(typedAny, JSONWriter.Feature.WriteThrowableClassName);
            }
            case -72: 
            case -70: {
                return Long.toString(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return Double.toString(doubleValue);
            }
        }
        throw new JSONException("readString not support type " + JSONB.typeName(this.strtype) + ", offset " + this.offset + "/" + this.bytes.length);
    }

    @Override
    public final String[] readStringArray() {
        long typeHash;
        if (this.nextIfMatch((byte)-110) && (typeHash = this.readTypeHashCode()) != ObjectReaderImplStringArray.HASH_TYPE) {
            throw new JSONException(this.info("not support type " + this.getString()));
        }
        int entryCnt = this.startArray();
        if (entryCnt == -1) {
            return null;
        }
        String[] array = new String[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            array[i] = this.readString();
        }
        return array;
    }

    @Override
    public final char readCharValue() {
        byte type = this.bytes[this.offset];
        if (type == -112) {
            ++this.offset;
            return (char)this.readInt32Value();
        }
        if (type == 73) {
            ++this.offset;
            return '\u0000';
        }
        if (type > 73 && type < 120) {
            ++this.offset;
            return (char)(this.bytes[this.offset++] & 0xFF);
        }
        String str = this.readString();
        if (str == null || str.isEmpty()) {
            return '\u0000';
        }
        return str.charAt(0);
    }

    @Override
    public long[] readInt64ValueArray() {
        long typeHash;
        if (this.nextIfMatch((byte)-110) && (typeHash = this.readTypeHashCode()) != ObjectReaderImplInt64ValueArray.HASH_TYPE && typeHash != ObjectReaderImplInt64Array.HASH_TYPE && typeHash != ObjectReaderImplInt32Array.HASH_TYPE && typeHash != ObjectReaderImplInt32ValueArray.HASH_TYPE) {
            throw new JSONException(this.info("not support " + this.getString()));
        }
        int entryCnt = this.startArray();
        if (entryCnt == -1) {
            return null;
        }
        long[] array = new long[entryCnt];
        for (int i = 0; i < entryCnt; ++i) {
            array[i] = this.readInt64Value();
        }
        return array;
    }

    @Override
    public final long readInt64Value() {
        long int64Value;
        byte type;
        this.wasNull = false;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((type = bytes[offset++]) >= -40 && type <= -17) {
            int64Value = -8 + (type - -40);
        } else if (type >= -56 && type <= -41) {
            int64Value = (type - -48 << 8) + (bytes[offset] & 0xFF);
            ++offset;
        } else if (type >= -64 && type <= -57) {
            int64Value = (type - -60 << 16) + ((bytes[offset] & 0xFF) << 8) + (bytes[offset + 1] & 0xFF);
            offset += 2;
        } else if (type == -65) {
            int64Value = IOUtils.getInt(bytes, offset);
            offset += 4;
        } else if (type == -66) {
            int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)offset);
            if (!JDKUtils.BIG_ENDIAN) {
                int64Value = Long.reverseBytes(int64Value);
            }
            offset += 8;
        } else {
            this.offset = offset;
            return this.readInt64ValueTypeNotMatch(bytes, type);
        }
        this.offset = offset;
        return int64Value;
    }

    private long readInt64ValueTypeNotMatch(byte[] bytes, byte type) {
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0L;
            }
            case -80: 
            case -78: {
                return 0L;
            }
            case -79: 
            case -77: {
                return 1L;
            }
            case -67: {
                return bytes[this.offset++];
            }
            case -68: {
                int int16Value = (bytes[this.offset + 1] & 0xFF) + (bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case 72: {
                int int32Value = IOUtils.getInt(bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = IOUtils.getInt(bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (long)floatValue;
            }
            case -75: {
                --this.offset;
                return (long)this.readDoubleValue();
            }
            case -74: {
                return (long)((float)this.readInt32Value());
            }
            case -76: {
                return (long)((double)this.readInt64Value());
            }
            case -83: {
                long minutes = IOUtils.getInt(bytes, this.offset);
                this.offset += 4;
                return minutes * 60L * 1000L;
            }
            case -84: {
                long seconds = IOUtils.getInt(bytes, this.offset);
                this.offset += 4;
                return seconds * 1000L;
            }
            case -85: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.longValue();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, IOUtils.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, IOUtils.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).longValue();
            }
            return TypeUtils.toBigDecimal(str).longValue();
        }
        throw new JSONException("readInt64Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + bytes.length);
    }

    @Override
    public final int readInt32Value() {
        int int32Value;
        int type;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if ((type = bytes[offset++]) >= -16 && type <= 47) {
            int32Value = type;
        } else if (type >= 48 && type <= 63) {
            int32Value = (type - 56 << 8) + (bytes[offset] & 0xFF);
            ++offset;
        } else if (type >= 64 && type <= 71) {
            int32Value = JSONReaderJSONB.getInt3(bytes, offset, type);
            offset += 2;
        } else if (type == 72) {
            int32Value = IOUtils.getInt(bytes, offset);
            offset += 4;
        } else {
            this.offset = offset;
            return this.readInt32ValueNotMatchType(bytes, (byte)type);
        }
        this.offset = offset;
        return int32Value;
    }

    private int readInt32ValueNotMatchType(byte[] bytes, byte type) {
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((bytes[this.offset++] & 0xFF) << 8) + (bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("int value not support input null"));
                }
                this.wasNull = true;
                return 0;
            }
            case -80: 
            case -78: {
                return 0;
            }
            case -79: 
            case -77: {
                return 1;
            }
            case -67: {
                return bytes[this.offset++];
            }
            case -68: {
                int int16Value = (bytes[this.offset + 1] & 0xFF) + (bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -76: {
                return (int)this.readInt64Value();
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return (int)(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -74: {
                return (int)((float)this.readInt32Value());
            }
            case -73: {
                int int32Value = IOUtils.getInt(bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return (int)floatValue;
            }
            case -75: {
                --this.offset;
                return (int)this.readDoubleValue();
            }
            case -84: 
            case -83: 
            case -65: {
                int int32Value = IOUtils.getInt(bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, IOUtils.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, IOUtils.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return TypeUtils.toBigDecimal(str).intValue();
        }
        throw new JSONException("readInt32Value not support " + JSONB.typeName(type) + ", offset " + this.offset + "/" + bytes.length);
    }

    @Override
    public final boolean isBinary() {
        return this.bytes[this.offset] == -111;
    }

    @Override
    public final byte[] readBinary() {
        byte type;
        if ((type = this.bytes[this.offset++]) != -111) {
            throw new JSONException("not support input : " + JSONB.typeName(type));
        }
        int len = this.readLength();
        byte[] bytes = new byte[len];
        System.arraycopy(this.bytes, this.offset, bytes, 0, len);
        this.offset += len;
        return bytes;
    }

    @Override
    public final Integer readInt32() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            this.wasNull = true;
            return null;
        }
        this.wasNull = false;
        int value = this.readInt32Value();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    @Override
    public final Long readInt64() {
        if (this.bytes[this.offset] == -81) {
            ++this.offset;
            this.wasNull = true;
            return null;
        }
        long value = this.readInt64Value();
        if (this.wasNull) {
            return null;
        }
        return value;
    }

    protected final String readFixedAsciiString(int strlen) {
        String str = strlen == 1 ? TypeUtils.toString((char)(this.bytes[this.offset] & 0xFF)) : (strlen == 2 ? TypeUtils.toString((char)(this.bytes[this.offset] & 0xFF), (char)(this.bytes[this.offset + 1] & 0xFF)) : new String(this.bytes, this.offset, strlen, IOUtils.ISO_8859_1));
        return str;
    }

    @Override
    public final float readFloatValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0.0f;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -65: 
            case 72: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Float.intBitsToFloat(int32Value);
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return (float)Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -74: {
                return this.readInt32Value();
            }
            case -76: {
                return (float)((double)this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0f;
            }
            case -79: 
            case -77: {
                return 1.0f;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        if (type >= -40 && type <= -17) {
            return -8 + (type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return TypeUtils.toBigDecimal(str).intValue();
        }
        throw new JSONException("TODO : " + JSONB.typeName(type));
    }

    @Override
    public final double readDoubleValue() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return 0.0;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return int16Value;
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -65: 
            case 72: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case -73: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Float.intBitsToFloat(int32Value);
            }
            case -74: {
                return this.readInt32Value();
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -76: {
                return this.readInt64Value();
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str).intValue();
                }
                return TypeUtils.toBigDecimal(str).intValue();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.intValue();
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
        }
        if (type >= -16 && type <= 47) {
            return type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            if (str.indexOf(46) == -1) {
                return new BigInteger(str).intValue();
            }
            return TypeUtils.toBigDecimal(str).intValue();
        }
        throw new JSONException("TODO : " + JSONB.typeName(type));
    }

    @Override
    protected final void readNumber0() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final Number readNumber() {
        byte type;
        if ((type = this.bytes[this.offset++]) >= -16 && type <= 47) {
            return (int)type;
        }
        if (type >= 48 && type <= 63) {
            return (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return int3;
        }
        if (type >= -40 && type <= -17) {
            return -8L + (long)(type - -40);
        }
        if (type >= -56 && type <= -41) {
            return (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        if (type >= -64 && type <= -57) {
            return (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
        }
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return 0.0;
            }
            case -79: 
            case -77: {
                return 1.0;
            }
            case -67: {
                return this.bytes[this.offset++];
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return (short)int16Value;
            }
            case 72: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return int32Value;
            }
            case -65: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return (long)int32Value;
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value);
            }
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -73: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Float.valueOf(Float.intBitsToFloat(int32Value));
            }
            case -74: {
                return Float.valueOf(this.readInt32Value());
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -76: {
                return (double)this.readInt64Value();
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                if (scale == 0) {
                    return new BigDecimal(unscaledValue);
                }
                return new BigDecimal(unscaledValue, scale);
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.ISO_8859_1);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case -110: {
                String typeName = this.readString();
                throw new JSONException("not support input type : " + typeName);
            }
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            return TypeUtils.toBigDecimal(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public final BigDecimal readBigDecimal() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigDecimal.ZERO;
            }
            case -79: 
            case -77: {
                return BigDecimal.ONE;
            }
            case -67: {
                return BigDecimal.valueOf(this.bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return BigDecimal.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return BigDecimal.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigDecimal.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigDecimal.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
                return BigDecimal.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return BigDecimal.valueOf(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -69: {
                return new BigDecimal(this.readBigInteger());
            }
            case -71: {
                int scale = this.readInt32Value();
                if (this.bytes[this.offset] == -70) {
                    ++this.offset;
                    long unscaledLongValue = this.readInt64Value();
                    return BigDecimal.valueOf(unscaledLongValue, scale);
                }
                if (this.bytes[this.offset] == 72) {
                    ++this.offset;
                    int unscaledValue = IOUtils.getInt(this.bytes, this.offset);
                    this.offset += 4;
                    return BigDecimal.valueOf(unscaledValue, scale);
                }
                if (this.bytes[this.offset] == -66) {
                    long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset + 1L);
                    this.offset += 9;
                    return BigDecimal.valueOf(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value), scale);
                }
                BigInteger unscaledValue = this.readBigInteger();
                if (scale == 0) {
                    return new BigDecimal(unscaledValue);
                }
                return new BigDecimal(unscaledValue, scale);
            }
            case -72: {
                return BigDecimal.valueOf(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigDecimal.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.ISO_8859_1);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_16LE);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                return TypeUtils.toBigDecimal(str);
            }
        }
        if (type >= -16 && type <= 47) {
            return BigDecimal.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return BigDecimal.valueOf(int3);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigDecimal.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            return TypeUtils.toBigDecimal(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public final BigInteger readBigInteger() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -80: 
            case -78: {
                return BigInteger.ZERO;
            }
            case -79: 
            case -77: {
                return BigInteger.ONE;
            }
            case -67: {
                return BigInteger.valueOf(this.bytes[this.offset++]);
            }
            case -68: {
                int int16Value = (this.bytes[this.offset + 1] & 0xFF) + (this.bytes[this.offset] << 8);
                this.offset += 2;
                return BigInteger.valueOf(int16Value);
            }
            case -65: 
            case 72: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return BigInteger.valueOf(int32Value);
            }
            case -74: {
                float floatValue = this.readInt32Value();
                return BigInteger.valueOf((long)floatValue);
            }
            case -73: {
                int int32Value = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                float floatValue = Float.intBitsToFloat(int32Value);
                return BigInteger.valueOf((long)floatValue);
            }
            case -75: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                double doubleValue = Double.longBitsToDouble(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
                return BigInteger.valueOf((long)doubleValue);
            }
            case -66: {
                long int64Value = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return BigInteger.valueOf(JDKUtils.BIG_ENDIAN ? int64Value : Long.reverseBytes(int64Value));
            }
            case -111: 
            case -69: {
                int len = this.readInt32Value();
                byte[] bytes = new byte[len];
                System.arraycopy(this.bytes, this.offset, bytes, 0, len);
                this.offset += len;
                return new BigInteger(bytes);
            }
            case -71: {
                int scale = this.readInt32Value();
                BigInteger unscaledValue = this.readBigInteger();
                BigDecimal decimal = scale == 0 ? new BigDecimal(unscaledValue) : new BigDecimal(unscaledValue, scale);
                return decimal.toBigInteger();
            }
            case -70: {
                return BigInteger.valueOf(this.readInt64Value());
            }
            case -76: {
                double doubleValue = this.readInt64Value();
                return BigInteger.valueOf((long)doubleValue);
            }
            case 121: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.ISO_8859_1);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return TypeUtils.toBigDecimal(str).toBigInteger();
            }
            case 122: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return TypeUtils.toBigDecimal(str).toBigInteger();
            }
            case 124: {
                int strlen = this.readInt32Value();
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_16LE);
                this.offset += strlen;
                if (str.indexOf(46) == -1) {
                    return new BigInteger(str);
                }
                return TypeUtils.toBigDecimal(str).toBigInteger();
            }
        }
        if (type >= -16 && type <= 47) {
            return BigInteger.valueOf(type);
        }
        if (type >= 48 && type <= 63) {
            int intValue = (type - 56 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 64 && type <= 71) {
            int int3 = JSONReaderJSONB.getInt3(this.bytes, this.offset, type);
            this.offset += 2;
            return BigInteger.valueOf(int3);
        }
        if (type >= -40 && type <= -17) {
            int intValue = -8 + (type - -40);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -56 && type <= -41) {
            int intValue = (type - -48 << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= -64 && type <= -57) {
            int intValue = (type - -60 << 16) + ((this.bytes[this.offset++] & 0xFF) << 8) + (this.bytes[this.offset++] & 0xFF);
            return BigInteger.valueOf(intValue);
        }
        if (type >= 73 && type <= 120) {
            int strlen = type - 73;
            String str = this.readFixedAsciiString(strlen);
            this.offset += strlen;
            return new BigInteger(str);
        }
        throw new JSONException("not support type :" + JSONB.typeName(type));
    }

    @Override
    public final LocalDate readLocalDate() {
        byte type = this.bytes[this.offset];
        if (type == -87) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            return LocalDate.of(year, month, dayOfMonth);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        if (type == 122 || type == 121) {
            this.strtype = type;
            ++this.offset;
            this.strlen = this.readLength();
            switch (this.strlen) {
                case 8: {
                    return this.readLocalDate8();
                }
                case 9: {
                    return this.readLocalDate9();
                }
                case 10: {
                    return this.readLocalDate10();
                }
                case 11: {
                    return this.readLocalDate11();
                }
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final LocalDateTime readLocalDateTime() {
        byte type = this.bytes[this.offset];
        if (type == -88) {
            ++this.offset;
            int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
            byte month = this.bytes[this.offset++];
            byte dayOfMonth = this.bytes[this.offset++];
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nano);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 8: {
                    LocalDate localDate = this.readLocalDate8();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 9: {
                    LocalDate localDate = this.readLocalDate9();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 10: {
                    LocalDate localDate = this.readLocalDate10();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 11: {
                    LocalDate localDate = this.readLocalDate11();
                    return localDate == null ? null : LocalDateTime.of(localDate, LocalTime.MIN);
                }
                case 16: {
                    return this.readLocalDateTime16();
                }
                case 17: {
                    return this.readLocalDateTime17();
                }
                case 18: {
                    return this.readLocalDateTime18();
                }
                case 19: {
                    return this.readLocalDateTime19();
                }
                case 20: {
                    return this.readLocalDateTime20();
                }
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 27: 
                case 28: 
                case 29: {
                    LocalDateTime ldt = this.readLocalDateTimeX(len);
                    if (ldt != null) {
                        return ldt;
                    }
                    ZonedDateTime zdt = this.readZonedDateTimeX(len);
                    if (zdt == null) break;
                    return zdt.dateTime;
                }
            }
            throw new JSONException("TODO : " + len + ", " + this.readString());
        }
        throw new UnsupportedOperationException();
    }

    @Override
    protected final LocalDateTime readLocalDateTime12() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 85 || (ldt = DateUtils.parseLocalDateTime12(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 13;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime14() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 87 || (ldt = DateUtils.parseLocalDateTime14(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 15;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime16() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 89 || (ldt = DateUtils.parseLocalDateTime16(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 17;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime17() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 90 || (ldt = DateUtils.parseLocalDateTime17(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 18;
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime10() {
        LocalTime time;
        if (this.bytes[this.offset] != 83 || (time = DateUtils.parseLocalTime10(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 11;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime11() {
        LocalTime time;
        if (this.bytes[this.offset] != 84 || (time = DateUtils.parseLocalTime11(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 12;
        return time;
    }

    @Override
    protected final ZonedDateTime readZonedDateTimeX(int len) {
        ZonedDateTime ldt;
        this.type = this.bytes[this.offset];
        if (this.type < 73 || this.type > 120) {
            throw new JSONException("date only support string input");
        }
        if (len < 19 || (ldt = DateUtils.parseZonedDateTime(this.bytes, this.offset + 1, len, this.context.zoneId)) == null) {
            throw new JSONException("illegal LocalDateTime string : " + this.readString());
        }
        this.offset += len + 1;
        return ldt;
    }

    @Override
    public final void skipLineComment() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final LocalTime readLocalTime() {
        byte type = this.bytes[this.offset];
        if (type == -89) {
            ++this.offset;
            byte hour = this.bytes[this.offset++];
            byte minute = this.bytes[this.offset++];
            byte second = this.bytes[this.offset++];
            int nano = this.readInt32Value();
            return LocalTime.of(hour, minute, second, nano);
        }
        if (type >= 73 && type <= 120) {
            int len = this.getStringLength();
            switch (len) {
                case 5: {
                    return this.readLocalTime5();
                }
                case 8: {
                    return this.readLocalTime8();
                }
                case 10: {
                    return this.readLocalTime10();
                }
                case 11: {
                    return this.readLocalTime11();
                }
                case 12: {
                    return this.readLocalTime12();
                }
                case 18: {
                    return this.readLocalTime18();
                }
            }
            throw new JSONException("not support len : " + len);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public final Instant readInstant() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                return Instant.ofEpochSecond(second, nano);
            }
            case -83: {
                long minutes = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Instant.ofEpochSecond(minutes * 60L, 0L);
            }
            case -84: {
                long seconds = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                return Instant.ofEpochSecond(seconds, 0L);
            }
            case -85: 
            case -66: {
                long millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                return Instant.ofEpochMilli(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis));
            }
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public ZonedDateTime readZonedDateTime() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -82: {
                long second = this.readInt64Value();
                int nano = this.readInt32Value();
                Instant instant = Instant.ofEpochSecond(second, nano);
                return ZonedDateTime.ofInstant(instant, ZoneId.DEFAULT_ZONE_ID);
            }
            case -83: {
                long minutes = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                Instant instant = Instant.ofEpochSecond(minutes * 60L, 0L);
                return ZonedDateTime.ofInstant(instant, ZoneId.DEFAULT_ZONE_ID);
            }
            case -84: {
                long seconds = IOUtils.getInt(this.bytes, this.offset);
                this.offset += 4;
                Instant instant = Instant.ofEpochSecond(seconds, 0L);
                return ZonedDateTime.ofInstant(instant, ZoneId.DEFAULT_ZONE_ID);
            }
            case -85: 
            case -66: {
                long millis = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                this.offset += 8;
                Instant instant = Instant.ofEpochMilli(JDKUtils.BIG_ENDIAN ? millis : Long.reverseBytes(millis));
                return ZonedDateTime.ofInstant(instant, ZoneId.DEFAULT_ZONE_ID);
            }
            case -86: {
                ZoneId zoneId;
                int year = (this.bytes[this.offset++] << 8) + (this.bytes[this.offset++] & 0xFF);
                byte month = this.bytes[this.offset++];
                byte dayOfMonth = this.bytes[this.offset++];
                byte hour = this.bytes[this.offset++];
                byte minute = this.bytes[this.offset++];
                byte second = this.bytes[this.offset++];
                int nano = this.readInt32Value();
                LocalDateTime ldt = LocalDateTime.of(year, month, dayOfMonth, hour, minute, second, nano);
                long zoneIdHash = this.readValueHashCode();
                long SHANGHAI_ZONE_ID_HASH = -4800907791268808639L;
                if (zoneIdHash == -4800907791268808639L) {
                    zoneId = ZoneId.SHANGHAI_ZONE_ID;
                } else {
                    String zoneIdStr = this.getString();
                    ZoneId contextZoneId = this.context.getZoneId();
                    zoneId = contextZoneId.id.equals(zoneIdStr) ? contextZoneId : DateUtils.getZoneId(zoneIdStr, ZoneId.SHANGHAI_ZONE_ID);
                }
                return ZonedDateTime.ofLocal(ldt, zoneId);
            }
        }
        if (type >= 73 && type <= 120) {
            --this.offset;
            return this.readZonedDateTimeX(type - 73);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public UUID readUUID() {
        byte type = this.bytes[this.offset++];
        switch (type) {
            case -81: {
                return null;
            }
            case -111: {
                int len = this.readLength();
                if (len != 16) {
                    throw new JSONException("uuid not support " + len);
                }
                long msb = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset);
                long lsb = JDKUtils.UNSAFE.getLong(this.bytes, JDKUtils.ARRAY_BYTE_BASE_OFFSET + (long)this.offset + 8L);
                this.offset += 16;
                return new UUID(JDKUtils.BIG_ENDIAN ? msb : Long.reverseBytes(msb), JDKUtils.BIG_ENDIAN ? lsb : Long.reverseBytes(lsb));
            }
            case 105: {
                long hi = 0L;
                for (int i = 0; i < 16; ++i) {
                    hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                }
                long lo = 0L;
                for (int i = 16; i < 32; ++i) {
                    lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                }
                this.offset += 32;
                return new UUID(hi, lo);
            }
            case 109: {
                byte ch1 = this.bytes[this.offset + 8];
                byte ch2 = this.bytes[this.offset + 13];
                byte ch3 = this.bytes[this.offset + 18];
                byte ch4 = this.bytes[this.offset + 23];
                if (ch1 == 45 && ch2 == 45 && ch3 == 45 && ch4 == 45) {
                    int i;
                    int i2;
                    long hi = 0L;
                    for (i2 = 0; i2 < 8; ++i2) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i2] - 48];
                    }
                    for (i2 = 9; i2 < 13; ++i2) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i2] - 48];
                    }
                    for (i2 = 14; i2 < 18; ++i2) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i2] - 48];
                    }
                    long lo = 0L;
                    for (i = 19; i < 23; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                    }
                    for (i = 24; i < 36; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                    }
                    this.offset += 36;
                    return new UUID(hi, lo);
                }
                throw new JSONException("Invalid UUID string:  " + new String(this.bytes, this.offset, 36, IOUtils.ISO_8859_1));
            }
            case 121: 
            case 122: {
                int strlen = this.readLength();
                if (strlen == 32) {
                    long hi = 0L;
                    for (int i = 0; i < 16; ++i) {
                        hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                    }
                    long lo = 0L;
                    for (int i = 16; i < 32; ++i) {
                        lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                    }
                    this.offset += 32;
                    return new UUID(hi, lo);
                }
                if (strlen == 36) {
                    byte ch1 = this.bytes[this.offset + 8];
                    byte ch2 = this.bytes[this.offset + 13];
                    byte ch3 = this.bytes[this.offset + 18];
                    byte ch4 = this.bytes[this.offset + 23];
                    if (ch1 == 45 && ch2 == 45 && ch3 == 45 && ch4 == 45) {
                        int i;
                        int i3;
                        long hi = 0L;
                        for (i3 = 0; i3 < 8; ++i3) {
                            hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i3] - 48];
                        }
                        for (i3 = 9; i3 < 13; ++i3) {
                            hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i3] - 48];
                        }
                        for (i3 = 14; i3 < 18; ++i3) {
                            hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i3] - 48];
                        }
                        long lo = 0L;
                        for (i = 19; i < 23; ++i) {
                            lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                        }
                        for (i = 24; i < 36; ++i) {
                            lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[this.bytes[this.offset + i] - 48];
                        }
                        this.offset += 36;
                        return new UUID(hi, lo);
                    }
                }
                String str = new String(this.bytes, this.offset, strlen, IOUtils.UTF_8);
                this.offset += strlen;
                throw new JSONException("Invalid UUID string:  " + str);
            }
        }
        throw new JSONException("type not support : " + JSONB.typeName(type));
    }

    @Override
    public final boolean readBoolValue() {
        this.wasNull = false;
        byte[] bytes = this.bytes;
        byte type = bytes[this.offset++];
        switch (type) {
            case -79: 
            case 1: {
                return true;
            }
            case -80: 
            case 0: {
                return false;
            }
            case -81: {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                return false;
            }
            case 74: {
                if (bytes[this.offset] == 49 || bytes[this.offset] == 89) {
                    ++this.offset;
                    return true;
                }
                if (bytes[this.offset] == 48 || bytes[this.offset] == 78) {
                    ++this.offset;
                    return false;
                }
            }
            case 77: {
                if (bytes[this.offset] == 116 && bytes[this.offset + 1] == 114 && bytes[this.offset + 2] == 117 && bytes[this.offset + 3] == 101) {
                    this.offset += 4;
                    return true;
                }
                if (bytes[this.offset] == 84 && bytes[this.offset + 1] == 82 && bytes[this.offset + 2] == 85 && bytes[this.offset + 3] == 69) {
                    this.offset += 4;
                    return true;
                }
            }
            case 78: {
                if (bytes[this.offset] == 102 && bytes[this.offset + 1] == 97 && bytes[this.offset + 2] == 108 && bytes[this.offset + 3] == 115 && bytes[this.offset + 4] == 101) {
                    this.offset += 5;
                    return false;
                }
                if (bytes[this.offset] == 70 && bytes[this.offset + 1] == 65 && bytes[this.offset + 2] == 76 && bytes[this.offset + 3] == 83 && bytes[this.offset + 4] == 69) {
                    this.offset += 5;
                    return false;
                }
            }
            case 121: 
            case 122: {
                this.strlen = this.readLength();
                if (this.strlen == 1) {
                    if (bytes[this.offset] == 89) {
                        ++this.offset;
                        return true;
                    }
                    if (bytes[this.offset] == 78) {
                        ++this.offset;
                        return true;
                    }
                } else {
                    if (this.strlen == 4 && bytes[this.offset] == 116 && bytes[this.offset + 1] == 114 && bytes[this.offset + 2] == 117 && bytes[this.offset + 3] == 101) {
                        this.offset += 4;
                        return true;
                    }
                    if (this.strlen == 5) {
                        if (bytes[this.offset] == 102 && bytes[this.offset + 1] == 97 && bytes[this.offset + 2] == 108 && bytes[this.offset + 3] == 115 && bytes[this.offset + 4] == 101) {
                            this.offset += 5;
                            return false;
                        }
                        if (bytes[this.offset] == 70 && bytes[this.offset + 1] == 65 && bytes[this.offset + 2] == 76 && bytes[this.offset + 3] == 83 && bytes[this.offset + 4] == 69) {
                            this.offset += 5;
                            return false;
                        }
                    }
                }
                String str = new String(bytes, this.offset, this.strlen, IOUtils.ISO_8859_1);
                this.offset += this.strlen;
                throw new JSONException("not support input " + str);
            }
            case 123: 
            case 124: 
            case 125: {
                this.strlen = this.readLength();
                byte[] chars = new byte[this.strlen];
                System.arraycopy(bytes, this.offset, chars, 0, this.strlen);
                Charset charset = type == 125 ? IOUtils.UTF_16BE : (type == 124 ? IOUtils.UTF_16LE : IOUtils.UTF_16);
                String str = new String(chars, charset);
                this.offset += this.strlen;
                switch (str) {
                    case "0": 
                    case "N": 
                    case "false": 
                    case "FALSE": {
                        return false;
                    }
                    case "1": 
                    case "Y": 
                    case "true": 
                    case "TRUE": {
                        return true;
                    }
                }
                throw new JSONException("not support input " + str);
            }
        }
        throw new JSONException("not support type : " + JSONB.typeName(type));
    }

    @Override
    public final boolean nextIfMatch(byte type) {
        if (this.bytes[this.offset] == type) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextIfMatchTypedAny() {
        if (this.bytes[this.offset] == -110) {
            ++this.offset;
            return true;
        }
        return false;
    }

    @Override
    protected final int getStringLength() {
        this.type = this.bytes[this.offset];
        if (this.type >= 73 && this.type < 120) {
            return this.type - 73;
        }
        throw new UnsupportedOperationException(JSONB.typeName(this.type));
    }

    @Override
    public final LocalDate readLocalDate8() {
        LocalDate ldt;
        if (this.bytes[this.offset] != 81 || (ldt = DateUtils.parseLocalDate8(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 9;
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate9() {
        LocalDate ldt;
        if (this.bytes[this.offset] != 82 || (ldt = DateUtils.parseLocalDate9(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 10;
        return ldt;
    }

    @Override
    protected final LocalDate readLocalDate10() {
        LocalDate ldt;
        if ((this.strtype == 121 || this.strtype == 122) && this.strlen == 10) {
            ldt = DateUtils.parseLocalDate10(this.bytes, this.offset);
        } else if (this.bytes[this.offset] != 83 || (ldt = DateUtils.parseLocalDate10(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 11;
        return ldt;
    }

    @Override
    protected final LocalDate readLocalDate11() {
        LocalDate ldt;
        if ((this.strtype == 121 || this.strtype == 122) && this.strlen == 11) {
            ldt = DateUtils.parseLocalDate11(this.bytes, this.offset);
        } else if (this.bytes[this.offset] != 84 || (ldt = DateUtils.parseLocalDate11(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 12;
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime5() {
        LocalTime time;
        if (this.bytes[this.offset] != 78 || (time = DateUtils.parseLocalTime5(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 6;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime8() {
        LocalTime time;
        if (this.bytes[this.offset] != 81 || (time = DateUtils.parseLocalTime8(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 9;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime12() {
        LocalTime time;
        if (this.bytes[this.offset] != 85 || (time = DateUtils.parseLocalTime12(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 13;
        return time;
    }

    @Override
    protected final LocalTime readLocalTime18() {
        LocalTime time;
        if (this.bytes[this.offset] != 91 || (time = DateUtils.parseLocalTime18(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 19;
        return time;
    }

    @Override
    protected final LocalDateTime readLocalDateTime18() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 91 || (ldt = DateUtils.parseLocalDateTime18(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 19;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime20() {
        LocalDateTime ldt;
        if (this.bytes[this.offset] != 93 || (ldt = DateUtils.parseLocalDateTime20(this.bytes, this.offset + 1)) == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 21;
        return ldt;
    }

    @Override
    public final long readMillis19() {
        if (this.bytes[this.offset] != 92) {
            throw new JSONException("date only support string input");
        }
        long millis = DateUtils.parseMillis19(this.bytes, this.offset + 1, this.context.zoneId);
        this.offset += 20;
        return millis;
    }

    @Override
    protected final LocalDateTime readLocalDateTime19() {
        this.type = this.bytes[this.offset];
        if (this.type != 92) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime19(this.bytes, this.offset + 1);
        if (ldt == null) {
            throw new JSONException("date only support string input");
        }
        this.offset += 20;
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTimeX(int len) {
        LocalDateTime ldt;
        this.type = this.bytes[this.offset];
        if (this.type < 73 || this.type > 120) {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29 || (ldt = DateUtils.parseLocalDateTimeX(this.bytes, this.offset + 1, len)) == null) {
            throw new JSONException("illegal LocalDateTime string : " + this.readString());
        }
        this.offset += len + 1;
        return ldt;
    }

    @Override
    public final String readPattern() {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final long readFieldNameHashCodeUnquote() {
        return this.readFieldNameHashCode();
    }

    @Override
    public final boolean nextIfSet() {
        return false;
    }

    @Override
    public final boolean nextIfInfinity() {
        return false;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        throw new JSONException("UnsupportedOperation");
    }

    @Override
    public final JSONReader.SavePoint mark() {
        return new JSONReader.SavePoint(this.offset, this.type);
    }

    @Override
    public final void reset(JSONReader.SavePoint savePoint) {
        this.offset = savePoint.offset;
        this.type = (byte)savePoint.current;
    }

    @Override
    public final void close() {
        byte[] valueBytes = this.valueBytes;
        if (valueBytes != null && valueBytes.length < 0x100000) {
            JSONFactory.BYTES_UPDATER.lazySet(this.cacheItem, valueBytes);
        }
    }

    @Override
    public final boolean isEnd() {
        return this.offset >= this.end;
    }
}

