/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.time.DateTimeException;
import com.alibaba.fastjson2.time.DateTimeFormatter;
import com.alibaba.fastjson2.time.Instant;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;

public class DateUtils {
    static DateTimeFormatter DATE_TIME_FORMATTER_34;
    static DateTimeFormatter DATE_TIME_FORMATTER_COOKIE;
    static DateTimeFormatter DATE_TIME_FORMATTER_COOKIE_LOCAL;
    static DateTimeFormatter DATE_TIME_FORMATTER_RFC_2822;
    static final int LOCAL_EPOCH_DAY;
    public static final int MIN_VALUE = -999999999;
    public static final int MAX_VALUE = 999999999;

    public static Date parseDate(String str, String format, ZoneId zoneId) {
        if (str == null || str.isEmpty() || "null".equals(str)) {
            return null;
        }
        if (format == null || format.isEmpty()) {
            long millis = DateUtils.parseMillis(str, zoneId);
            if (millis == 0L) {
                return null;
            }
            return new Date(millis);
        }
        switch (format) {
            case "yyyy-MM-dd'T'HH:mm:ss": {
                long millis = DateUtils.parseMillis19(str, zoneId, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
                return new Date(millis);
            }
            case "yyyy-MM-dd HH:mm:ss": {
                long millis = DateUtils.parseMillisYMDHMS19(str, zoneId);
                return new Date(millis);
            }
            case "yyyy/MM/dd HH:mm:ss": {
                long millis = DateUtils.parseMillis19(str, zoneId, DateTimeFormatPattern.DATE_TIME_FORMAT_19_SLASH);
                return new Date(millis);
            }
            case "dd.MM.yyyy HH:mm:ss": {
                long millis = DateUtils.parseMillis19(str, zoneId, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DOT);
                return new Date(millis);
            }
            case "yyyy-MM-dd": {
                long millis = DateUtils.parseMillis10(str, zoneId, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
                return new Date(millis);
            }
            case "yyyy/MM/dd": {
                long millis = DateUtils.parseMillis10(str, zoneId, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
                return new Date(millis);
            }
            case "yyyyMMdd": {
                long millis = DateUtils.parseMillis8(str, zoneId);
                return new Date(millis);
            }
            case "yyyyMMddHHmmssSSSZ": 
            case "iso8601": {
                long millis = DateUtils.parseMillis(str, ZoneId.DEFAULT_ZONE_ID);
                if (millis == 0L) {
                    return null;
                }
                return new Date(millis);
            }
            case "millis": {
                long millis = Long.parseLong(str);
                return new Date(millis);
            }
            case "unixtime": {
                long seconds = Long.parseLong(str);
                return new Date(seconds * 1000L);
            }
        }
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        LocalDateTime ldt = formatter.parseLocalDateTime(str);
        long millis = DateUtils.millis(ldt, zoneId);
        return new Date(millis);
    }

    public static Date parseDate(String str, ZoneId zoneId) {
        long millis = DateUtils.parseMillis(str, zoneId);
        if (millis == 0L) {
            return null;
        }
        return new Date(millis);
    }

    public static long parseMillis(String str, ZoneId zoneId) {
        if (str == null) {
            return 0L;
        }
        char[] chars = JDKUtils.getCharArray(str);
        return DateUtils.parseMillis(chars, 0, chars.length, zoneId);
    }

    public static LocalDateTime parseLocalDateTime(String str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        char[] chars = new char[len];
        str.getChars(off, off + len, chars, 0);
        LocalDateTime ldt = DateUtils.parseLocalDateTime(chars, off, len);
        if (ldt == null) {
            switch (str) {
                case "": 
                case "null": 
                case "00000000": 
                case "000000000000": 
                case "0000\u5e7400\u670800\u65e5": 
                case "0000-0-00": 
                case "0000-00-0": 
                case "0000-00-00": {
                    return null;
                }
            }
            throw new DateTimeException(str, str, off);
        }
        return ldt;
    }

    public static LocalDateTime parseLocalDateTime(char[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        switch (len) {
            case 4: {
                if (str[off] == 'n' && str[off + 1] == 'u' && str[off + 2] == 'l' && str[off + 3] == 'l') {
                    return null;
                }
                String input = new String(str, off, len);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            case 8: {
                LocalDate localDate = DateUtils.parseLocalDate8(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 9: {
                LocalDate localDate = DateUtils.parseLocalDate9(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 10: {
                LocalDate localDate = DateUtils.parseLocalDate10(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 11: {
                LocalDate localDate = DateUtils.parseLocalDate11(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 12: {
                return DateUtils.parseLocalDateTime12(str, off);
            }
            case 14: {
                return DateUtils.parseLocalDateTime14(str, off);
            }
            case 16: {
                return DateUtils.parseLocalDateTime16(str, off);
            }
            case 17: {
                return DateUtils.parseLocalDateTime17(str, off);
            }
            case 18: {
                return DateUtils.parseLocalDateTime18(str, off);
            }
            case 19: {
                return DateUtils.parseLocalDateTime19(str, off);
            }
            case 20: {
                return DateUtils.parseLocalDateTime20(str, off);
            }
        }
        return DateUtils.parseLocalDateTimeX(str, off, len);
    }

    public static LocalTime parseLocalTime5(byte[] bytes, int off) {
        if (off + 5 > bytes.length) {
            return null;
        }
        byte c0 = bytes[off];
        byte c1 = bytes[off + 1];
        byte c2 = bytes[off + 2];
        byte c3 = bytes[off + 3];
        byte c4 = bytes[off + 4];
        if (c2 != 58) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        return LocalTime.of(hour, minute, 0);
    }

    public static LocalTime parseLocalTime5(char[] chars, int off) {
        if (off + 5 > chars.length) {
            return null;
        }
        char c0 = chars[off];
        char c1 = chars[off + 1];
        char c2 = chars[off + 2];
        char c3 = chars[off + 3];
        char c4 = chars[off + 4];
        if (c2 != ':') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        return LocalTime.of(hour, minute, 0);
    }

    public static LocalTime parseLocalTime6(String bytes, int off) {
        if (off + 6 > bytes.length()) {
            return null;
        }
        char c0 = bytes.charAt(off);
        char c1 = bytes.charAt(off + 1);
        char c2 = bytes.charAt(off + 2);
        char c3 = bytes.charAt(off + 3);
        char c4 = bytes.charAt(off + 4);
        char c5 = bytes.charAt(off + 5);
        if (c0 < '0' || c0 > '9' || c1 < '0' || c1 > '9') {
            return null;
        }
        int hour = (c0 - 48) * 10 + (c1 - 48);
        if (c2 < '0' || c2 > '9' || c3 < '0' || c3 > '9') {
            return null;
        }
        int minute = (c2 - 48) * 10 + (c3 - 48);
        if (c4 < '0' || c4 > '9' || c5 < '0' || c5 > '9') {
            return null;
        }
        int seccond = (c4 - 48) * 10 + (c5 - 48);
        return LocalTime.of(hour, minute, seccond);
    }

    public static LocalTime parseLocalTime8(byte[] bytes, int off) {
        if (off + 8 > bytes.length) {
            return null;
        }
        byte c0 = bytes[off];
        byte c1 = bytes[off + 1];
        byte c2 = bytes[off + 2];
        byte c3 = bytes[off + 3];
        byte c4 = bytes[off + 4];
        byte c5 = bytes[off + 5];
        byte c6 = bytes[off + 6];
        byte c7 = bytes[off + 7];
        if (c2 != 58 || c5 != 58) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        return LocalTime.of(hour, minute, seccond);
    }

    public static LocalTime parseLocalTime8(char[] bytes, int off) {
        if (off + 8 > bytes.length) {
            return null;
        }
        char c0 = bytes[off];
        char c1 = bytes[off + 1];
        char c2 = bytes[off + 2];
        char c3 = bytes[off + 3];
        char c4 = bytes[off + 4];
        char c5 = bytes[off + 5];
        char c6 = bytes[off + 6];
        char c7 = bytes[off + 7];
        if (c2 != ':' || c5 != ':') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        return LocalTime.of(hour, minute, seccond);
    }

    public static LocalTime parseLocalTime10(byte[] bytes, int off) {
        if (off + 10 > bytes.length) {
            return null;
        }
        byte c0 = bytes[off];
        byte c1 = bytes[off + 1];
        byte c2 = bytes[off + 2];
        byte c3 = bytes[off + 3];
        byte c4 = bytes[off + 4];
        byte c5 = bytes[off + 5];
        byte c6 = bytes[off + 6];
        byte c7 = bytes[off + 7];
        byte c8 = bytes[off + 8];
        byte c9 = bytes[off + 9];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100;
        return LocalTime.of(hour, minute, seccond, millis *= 1000000);
    }

    public static LocalTime parseLocalTime10(char[] bytes, int off) {
        if (off + 10 > bytes.length) {
            return null;
        }
        char c0 = bytes[off];
        char c1 = bytes[off + 1];
        char c2 = bytes[off + 2];
        char c3 = bytes[off + 3];
        char c4 = bytes[off + 4];
        char c5 = bytes[off + 5];
        char c6 = bytes[off + 6];
        char c7 = bytes[off + 7];
        char c8 = bytes[off + 8];
        char c9 = bytes[off + 9];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < '0' || m0 > '9') {
            return null;
        }
        int millis = (m0 - 48) * 100;
        return LocalTime.of(hour, minute, seccond, millis *= 1000000);
    }

    public static LocalTime parseLocalTime11(byte[] bytes, int off) {
        if (off + 11 > bytes.length) {
            return null;
        }
        byte c0 = bytes[off];
        byte c1 = bytes[off + 1];
        byte c2 = bytes[off + 2];
        byte c3 = bytes[off + 3];
        byte c4 = bytes[off + 4];
        byte c5 = bytes[off + 5];
        byte c6 = bytes[off + 6];
        byte c7 = bytes[off + 7];
        byte c8 = bytes[off + 8];
        byte c9 = bytes[off + 9];
        byte c10 = bytes[off + 10];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100 + (m1 - 48) * 10;
        return LocalTime.of(hour, minute, second, millis *= 1000000);
    }

    public static LocalTime parseLocalTime11(char[] bytes, int off) {
        if (off + 11 > bytes.length) {
            return null;
        }
        char c0 = bytes[off];
        char c1 = bytes[off + 1];
        char c2 = bytes[off + 2];
        char c3 = bytes[off + 3];
        char c4 = bytes[off + 4];
        char c5 = bytes[off + 5];
        char c6 = bytes[off + 6];
        char c7 = bytes[off + 7];
        char c8 = bytes[off + 8];
        char c9 = bytes[off + 9];
        char c10 = bytes[off + 10];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int millis = (m0 - 48) * 100 + (m1 - 48) * 10;
        return LocalTime.of(hour, minute, seccond, millis *= 1000000);
    }

    public static LocalTime parseLocalTime12(byte[] bytes, int off) {
        if (off + 12 > bytes.length) {
            return null;
        }
        byte c0 = bytes[off];
        byte c1 = bytes[off + 1];
        byte c2 = bytes[off + 2];
        byte c3 = bytes[off + 3];
        byte c4 = bytes[off + 4];
        byte c5 = bytes[off + 5];
        byte c6 = bytes[off + 6];
        byte c7 = bytes[off + 7];
        byte c8 = bytes[off + 8];
        byte c9 = bytes[off + 9];
        byte c10 = bytes[off + 10];
        byte c11 = bytes[off + 11];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57 || m2 < 48 || m2 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
        return LocalTime.of(hour, minute, seccond, millis *= 1000000);
    }

    public static LocalTime parseLocalTime12(char[] bytes, int off) {
        if (off + 12 > bytes.length) {
            return null;
        }
        char c0 = bytes[off];
        char c1 = bytes[off + 1];
        char c2 = bytes[off + 2];
        char c3 = bytes[off + 3];
        char c4 = bytes[off + 4];
        char c5 = bytes[off + 5];
        char c6 = bytes[off + 6];
        char c7 = bytes[off + 7];
        char c8 = bytes[off + 8];
        char c9 = bytes[off + 9];
        char c10 = bytes[off + 10];
        char c11 = bytes[off + 11];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9' || m2 < '0' || m2 > '9') {
            return null;
        }
        int millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
        return LocalTime.of(hour, minute, seccond, millis *= 1000000);
    }

    public static LocalTime parseLocalTime18(byte[] bytes, int off) {
        if (off + 18 > bytes.length) {
            return null;
        }
        byte c0 = bytes[off];
        byte c1 = bytes[off + 1];
        byte c2 = bytes[off + 2];
        byte c3 = bytes[off + 3];
        byte c4 = bytes[off + 4];
        byte c5 = bytes[off + 5];
        byte c6 = bytes[off + 6];
        byte c7 = bytes[off + 7];
        byte c8 = bytes[off + 8];
        byte c9 = bytes[off + 9];
        byte c10 = bytes[off + 10];
        byte c11 = bytes[off + 11];
        byte c12 = bytes[off + 12];
        byte c13 = bytes[off + 13];
        byte c14 = bytes[off + 14];
        byte c15 = bytes[off + 15];
        byte c16 = bytes[off + 16];
        byte c17 = bytes[off + 17];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        byte m3 = c12;
        byte m4 = c13;
        byte m5 = c14;
        byte m6 = c15;
        byte m7 = c16;
        byte m8 = c17;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57 || m2 < 48 || m2 > 57 || m3 < 48 || m3 > 57 || m4 < 48 || m4 > 57 || m5 < 48 || m5 > 57 || m6 < 48 || m6 > 57 || m7 < 48 || m7 > 57 || m8 < 48 || m8 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        return LocalTime.of(hour, minute, seccond, millis);
    }

    public static LocalTime parseLocalTime18(char[] bytes, int off) {
        if (off + 18 > bytes.length) {
            return null;
        }
        char c0 = bytes[off];
        char c1 = bytes[off + 1];
        char c2 = bytes[off + 2];
        char c3 = bytes[off + 3];
        char c4 = bytes[off + 4];
        char c5 = bytes[off + 5];
        char c6 = bytes[off + 6];
        char c7 = bytes[off + 7];
        char c8 = bytes[off + 8];
        char c9 = bytes[off + 9];
        char c10 = bytes[off + 10];
        char c11 = bytes[off + 11];
        char c12 = bytes[off + 12];
        char c13 = bytes[off + 13];
        char c14 = bytes[off + 14];
        char c15 = bytes[off + 15];
        char c16 = bytes[off + 16];
        char c17 = bytes[off + 17];
        if (c2 != ':' || c5 != ':' || c8 != '.') {
            return null;
        }
        char h0 = c0;
        char h1 = c1;
        char i0 = c3;
        char i1 = c4;
        char s0 = c6;
        char s1 = c7;
        char m0 = c9;
        char m1 = c10;
        char m2 = c11;
        char m3 = c12;
        char m4 = c13;
        char m5 = c14;
        char m6 = c15;
        char m7 = c16;
        char m8 = c17;
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9' || m2 < '0' || m2 > '9' || m3 < '0' || m3 > '9' || m4 < '0' || m4 > '9' || m5 < '0' || m5 > '9' || m6 < '0' || m6 > '9' || m7 < '0' || m7 > '9' || m8 < '0' || m8 > '9') {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        return LocalTime.of(hour, minute, seccond, millis);
    }

    public static LocalDateTime parseLocalDateTime(byte[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        switch (len) {
            case 4: {
                if (str[off] == 110 && str[off + 1] == 117 && str[off + 2] == 108 && str[off + 3] == 108) {
                    return null;
                }
                String input = new String(str, off, len);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            case 8: {
                LocalDate localDate = DateUtils.parseLocalDate8(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 9: {
                LocalDate localDate = DateUtils.parseLocalDate9(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 10: {
                LocalDate localDate = DateUtils.parseLocalDate10(str, off);
                if (localDate == null) {
                    return null;
                }
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 11: {
                LocalDate localDate = DateUtils.parseLocalDate11(str, off);
                return LocalDateTime.of(localDate, LocalTime.MIN);
            }
            case 12: {
                return DateUtils.parseLocalDateTime12(str, off);
            }
            case 14: {
                return DateUtils.parseLocalDateTime14(str, off);
            }
            case 16: {
                return DateUtils.parseLocalDateTime16(str, off);
            }
            case 17: {
                return DateUtils.parseLocalDateTime17(str, off);
            }
            case 18: {
                return DateUtils.parseLocalDateTime18(str, off);
            }
            case 19: {
                return DateUtils.parseLocalDateTime19(str, off);
            }
            case 20: {
                return DateUtils.parseLocalDateTime20(str, off);
            }
        }
        return DateUtils.parseLocalDateTimeX(str, off, len);
    }

    public static LocalDate parseLocalDate(String str) {
        if (str == null) {
            return null;
        }
        char[] chars = JDKUtils.getCharArray(str);
        LocalDate localDate = DateUtils.parseLocalDate(chars, 0, chars.length);
        if (localDate == null) {
            switch (str) {
                case "": 
                case "null": 
                case "00000000": 
                case "0000\u5e7400\u670800\u65e5": 
                case "0000-0-00": 
                case "0000-00-00": {
                    return null;
                }
            }
            throw new DateTimeException(str, str, 0);
        }
        return localDate;
    }

    public static LocalDate parseLocalDate(byte[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        if (off + len > str.length) {
            String input = new String(str, off, len);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        switch (len) {
            case 8: {
                return DateUtils.parseLocalDate8(str, off);
            }
            case 9: {
                return DateUtils.parseLocalDate9(str, off);
            }
            case 10: {
                return DateUtils.parseLocalDate10(str, off);
            }
            case 11: {
                return DateUtils.parseLocalDate11(str, off);
            }
        }
        if (len == 4 && str[off] == 110 && str[off + 1] == 117 && str[off + 2] == 108 && str[off + 3] == 108) {
            return null;
        }
        String input = new String(str, off, len);
        throw new DateTimeException("illegal input " + input, input, 0);
    }

    public static LocalDate parseLocalDate(char[] str, int off, int len) {
        if (str == null || len == 0) {
            return null;
        }
        if (off + len > str.length) {
            String input = new String(str, off, len);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        switch (len) {
            case 8: {
                return DateUtils.parseLocalDate8(str, off);
            }
            case 9: {
                return DateUtils.parseLocalDate9(str, off);
            }
            case 10: {
                return DateUtils.parseLocalDate10(str, off);
            }
            case 11: {
                return DateUtils.parseLocalDate11(str, off);
            }
        }
        if (len == 4 && str[off] == 'n' && str[off + 1] == 'u' && str[off + 2] == 'l' && str[off + 3] == 'l') {
            return null;
        }
        String input = new String(str, off, len);
        throw new DateTimeException("illegal input " + input, input, 0);
    }

    public static long parseMillis(byte[] bytes, int off, int len) {
        return DateUtils.parseMillis(bytes, off, len, IOUtils.UTF_8, ZoneId.DEFAULT_ZONE_ID);
    }

    public static long parseMillis(byte[] chars, int off, int len, Charset charset, ZoneId zoneId) {
        char c10;
        long millis;
        if (chars == null || len == 0) {
            return 0L;
        }
        if (len == 4 && chars[off] == 110 && chars[off + 1] == 117 && chars[off + 2] == 108 && chars[off + 3] == 108) {
            return 0L;
        }
        char c0 = (char)chars[off];
        if (c0 == '\"' && chars[len - 1] == 34) {
            try (JSONReader jsonReader = JSONReader.of(chars, off, len, charset);){
                Date date = (Date)ObjectReaderImplDate.INSTANCE.readObject(jsonReader, null, null, 0L);
                millis = date.getTime();
            }
        } else if (len == 19) {
            millis = DateUtils.parseMillis19(chars, off, zoneId);
        } else if (len > 19 || len == 16 && ((c10 = (char)chars[off + 10]) == '+' || c10 == '-')) {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(chars, off, len, zoneId);
            if (zdt == null) {
                String input = new String(chars, off, len - off);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            millis = zdt.toInstant().toEpochMilli();
        } else if ((c0 == '-' || c0 >= '0' && c0 <= '9') && IOUtils.isNumber(chars, off, len)) {
            millis = TypeUtils.parseLong(chars, off, len);
            if (len == 8 && millis >= 19700101L && millis <= 21000101L) {
                LocalDate localDate = DateUtils.parseLocalDate8(chars, 0);
                LocalDateTime ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
                millis = zdt.toEpochMilli();
            } else if (len == 12 && millis >= 197001010000L && millis <= 210001010000L) {
                LocalDateTime ldt = DateUtils.parseLocalDateTime12(chars, 0);
                ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
                millis = zdt.toEpochMilli();
            } else if (len == 14 && millis >= 19700101000000L && millis <= 21000101000000L) {
                LocalDateTime ldt = DateUtils.parseLocalDateTime14(chars, 0);
                ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
                millis = zdt.toEpochMilli();
            }
        } else {
            LocalDateTime ldt;
            char last = (char)chars[len - 1];
            if (last == 'Z') {
                zoneId = ZoneId.UTC;
            }
            if ((ldt = DateUtils.parseLocalDateTime(chars, off, len)) == null && chars[off] == 48 && chars[off + 1] == 48 && chars[off + 2] == 48 && chars[off + 3] == 48 && chars[off + 4] == 45 && chars[off + 5] == 48 && chars[off + 6] == 48 && chars[off + 7] == 45 && chars[off + 8] == 48 && chars[off + 9] == 48) {
                ldt = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
            }
            ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
            long seconds = zdt.toEpochSecond();
            int nanos = ldt.time.nano;
            millis = seconds < 0L && nanos > 0 ? (seconds + 1L) * 1000L + (long)(nanos / 1000000) - 1000L : seconds * 1000L + (long)(nanos / 1000000);
        }
        return millis;
    }

    public static long parseMillis(char[] bytes, int off, int len) {
        return DateUtils.parseMillis(bytes, off, len, ZoneId.DEFAULT_ZONE_ID);
    }

    public static long parseMillis(char[] chars, int off, int len, ZoneId zoneId) {
        char c10;
        long millis;
        if (chars == null || len == 0) {
            return 0L;
        }
        if (len == 4 && chars[off] == 'n' && chars[off + 1] == 'u' && chars[off + 2] == 'l' && chars[off + 3] == 'l') {
            return 0L;
        }
        char c0 = chars[off];
        if (c0 == '\"' && chars[len - 1] == '\"') {
            try (JSONReader jsonReader = JSONReader.of(chars, off, len);){
                Date date = (Date)ObjectReaderImplDate.INSTANCE.readObject(jsonReader, null, null, 0L);
                millis = date.getTime();
            }
        } else if (len == 19) {
            millis = DateUtils.parseMillis19(chars, off, zoneId);
        } else if (len > 19 || len == 16 && ((c10 = chars[off + 10]) == '+' || c10 == '-')) {
            ZonedDateTime zdt = DateUtils.parseZonedDateTime(chars, off, len, zoneId);
            if (zdt == null) {
                String input = new String(chars, off, len - off);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            millis = zdt.toEpochMilli();
        } else if ((c0 == '-' || c0 >= '0' && c0 <= '9') && IOUtils.isNumber(chars, off, len)) {
            millis = TypeUtils.parseLong(chars, off, len);
            if (len == 8 && millis >= 19700101L && millis <= 21000101L) {
                LocalDate localDate = DateUtils.parseLocalDate8(chars, 0);
                LocalDateTime ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
                millis = zdt.toEpochMilli();
            } else if (len == 12 && millis >= 197001010000L && millis <= 210001010000L) {
                LocalDateTime ldt = DateUtils.parseLocalDateTime12(chars, 0);
                ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
                millis = zdt.toEpochMilli();
            } else if (len == 14 && millis >= 19700101000000L && millis <= 21000101000000L) {
                LocalDateTime ldt = DateUtils.parseLocalDateTime14(chars, 0);
                ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
                millis = zdt.toEpochMilli();
            }
        } else {
            LocalDateTime ldt;
            char last = chars[len - 1];
            if (last == 'Z') {
                zoneId = ZoneId.UTC;
            }
            if ((ldt = DateUtils.parseLocalDateTime(chars, off, len)) == null && chars[off] == '0' && chars[off + 1] == '0' && chars[off + 2] == '0' && chars[off + 3] == '0' && chars[off + 4] == '-' && chars[off + 5] == '0' && chars[off + 6] == '0' && chars[off + 7] == '-' && chars[off + 8] == '0' && chars[off + 9] == '0') {
                ldt = LocalDateTime.of(1970, 1, 1, 0, 0, 0);
            }
            if (ldt == null) {
                String input = new String(chars, off, len - off);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            ZonedDateTime zdt = ZonedDateTime.ofLocal(ldt, zoneId);
            long seconds = zdt.toEpochSecond();
            int nanos = ldt.time.nano;
            millis = seconds < 0L && nanos > 0 ? (seconds + 1L) * 1000L + (long)(nanos / 1000000) - 1000L : seconds * 1000L + (long)(nanos / 1000000);
        }
        return millis;
    }

    public static LocalDate parseLocalDate8(byte[] str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 8 > str.length) {
            return null;
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        if (c4 == 45 && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c1 == 47 && c3 == 47) {
            m0 = 48;
            m1 = c0;
            d0 = 48;
            d1 = c2;
            y0 = c4;
            y1 = c5;
            y2 = c6;
            y3 = c7;
        } else if (c1 == 45 && c5 == 45) {
            d0 = 48;
            d1 = c0;
            int month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = 50;
            y1 = 48;
            y2 = c6;
            y3 = c7;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate8(char[] str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 8 > str.length) {
            return null;
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        if (c4 == 45 && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c1 == 47 && c3 == 47) {
            m0 = 48;
            m1 = c0;
            d0 = 48;
            d1 = c2;
            y0 = c4;
            y1 = c5;
            y2 = c6;
            y3 = c7;
        } else if (c1 == 45 && c5 == 45) {
            d0 = 48;
            d1 = c0;
            int month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = 50;
            y1 = 48;
            y2 = c6;
            y3 = c7;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate9(byte[] str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        char y2;
        int y1;
        int y0;
        if (off + 9 > str.length) {
            return null;
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        char c2 = (char)str[off + 2];
        int c3 = str[off + 3];
        char c4 = (char)str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        char c7 = (char)str[off + 7];
        int c8 = str[off + 8];
        if (c4 == '-' && c7 == '-') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == '-' && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == '/' && c7 == '/') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == '/' && c6 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c1 == 46 && c4 == '.') {
            d0 = 48;
            d1 = c0;
            m0 = c2;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == '.' && c4 == '.') {
            d0 = c0;
            d1 = c1;
            m0 = 48;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c1 == 45 && c4 == '-') {
            d0 = 48;
            d1 = c0;
            m0 = c2;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == '-' && c4 == '-') {
            d0 = c0;
            d1 = c1;
            m0 = 48;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == '-' && c6 == 45) {
            d0 = c0;
            d1 = c1;
            int month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = 50;
            y1 = 48;
            y2 = c7;
            y3 = c8;
        } else if (c1 == 47 && c4 == '/') {
            m0 = 48;
            m1 = c0;
            d0 = c2;
            d1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == '/' && c4 == '/') {
            m0 = c0;
            m1 = c1;
            d0 = 48;
            d1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < '0' || y2 > '9' || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate9(char[] str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 9 > str.length) {
            return null;
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        char c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        if (c4 == '-' && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == '-' && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == '/' && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == '/' && c6 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c1 == 46 && c4 == '.') {
            d0 = 48;
            d1 = c0;
            m0 = c2;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == 46 && c4 == '.') {
            d0 = c0;
            d1 = c1;
            m0 = 48;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c1 == 45 && c4 == '-') {
            d0 = 48;
            d1 = c0;
            m0 = c2;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == 45 && c4 == '-') {
            d0 = c0;
            d1 = c1;
            m0 = 48;
            m1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c4 == '\u5e74' && c6 == 26376 && c8 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c4 == '\ub144' && c6 == 50900 && c8 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else if (c2 == 45 && c6 == 45) {
            d0 = c0;
            d1 = c1;
            int month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = 50;
            y1 = 48;
            y2 = c7;
            y3 = c8;
        } else if (c1 == 47 && c4 == '/') {
            m0 = 48;
            m1 = c0;
            d0 = c2;
            d1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else if (c2 == 47 && c4 == '/') {
            m0 = c0;
            m1 = c1;
            d0 = 48;
            d1 = c3;
            y0 = c5;
            y1 = c6;
            y2 = c7;
            y3 = c8;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate10(byte[] str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 10 > str.length) {
            return null;
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 47 && c5 == 47) {
            m0 = c0;
            m1 = c1;
            d0 = c3;
            d1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c1 == 32 && c5 == 32) {
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            int month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = 48;
            d1 = c0;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate10(char[] str, int off) {
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 10 > str.length) {
            return null;
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 47 && c5 == 47) {
            m0 = c0;
            m1 = c1;
            d0 = c3;
            d1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c4 == 24180 && c6 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 45380 && c6 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
        } else if (c4 == 24180 && c7 == 26376 && c9 == 26085) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c4 == 45380 && c7 == 50900 && c9 == 51068) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
        } else if (c1 == 32 && c5 == 32) {
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            int month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = 48;
            d1 = c0;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate11(char[] str, int off) {
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 11 > str.length) {
            return null;
        }
        char c0 = str[off + 0];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        if (c4 == '\u5e74' && c7 == '\u6708' && c10 == '\u65e5') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == '-' && c7 == '-' && c10 == 'Z') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == '\ub144' && c7 == '\uc6d4' && c10 == '\uc77c') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == ' ' && c6 == ' ') {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            int month = DateUtils.month(c3, c4, c5);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = c0;
            d1 = c1;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDate parseLocalDate11(byte[] str, int off) {
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 11 > str.length) {
            return null;
        }
        char c0 = (char)str[off + 0];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        if (c4 == '-' && c7 == '-' && c10 == 'Z') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == ' ' && c6 == ' ') {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            int month = DateUtils.month(c3, c4, c5);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = c0;
            d1 = c1;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        return LocalDate.of(year, month, dom);
    }

    public static LocalDateTime parseLocalDateTime12(char[] str, int off) {
        if (off + 12 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        char y0 = str[off + 0];
        char y1 = str[off + 1];
        char y2 = str[off + 2];
        char y3 = str[off + 3];
        char m0 = str[off + 4];
        char m1 = str[off + 5];
        char d0 = str[off + 6];
        char d1 = str[off + 7];
        char h0 = str[off + 8];
        char h1 = str[off + 9];
        char i0 = str[off + 10];
        char i1 = str[off + 11];
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (year == 0 && month == 0 && dom == 0 && hour == 0 && minute == 0) {
            return null;
        }
        return LocalDateTime.of(year, month, dom, hour, minute, 0);
    }

    public static LocalDateTime parseLocalDateTime12(byte[] str, int off) {
        if (off + 12 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        char y0 = (char)str[off + 0];
        char y1 = (char)str[off + 1];
        char y2 = (char)str[off + 2];
        char y3 = (char)str[off + 3];
        char m0 = (char)str[off + 4];
        char m1 = (char)str[off + 5];
        char d0 = (char)str[off + 6];
        char d1 = (char)str[off + 7];
        char h0 = (char)str[off + 8];
        char h1 = (char)str[off + 9];
        char i0 = (char)str[off + 10];
        char i1 = (char)str[off + 11];
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            String input = new String(str, off, off + 12);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (year == 0 && month == 0 && dom == 0 && hour == 0 && minute == 0) {
            return null;
        }
        return LocalDateTime.of(year, month, dom, hour, minute, 0);
    }

    public static LocalDateTime parseLocalDateTime14(char[] str, int off) {
        if (off + 14 > str.length) {
            return null;
        }
        char y0 = str[off + 0];
        char y1 = str[off + 1];
        char y2 = str[off + 2];
        char y3 = str[off + 3];
        char m0 = str[off + 4];
        char m1 = str[off + 5];
        char d0 = str[off + 6];
        char d1 = str[off + 7];
        char h0 = str[off + 8];
        char h1 = str[off + 9];
        char i0 = str[off + 10];
        char i1 = str[off + 11];
        char s0 = str[off + 12];
        char s1 = str[off + 13];
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime14(byte[] str, int off) {
        if (off + 14 > str.length) {
            return null;
        }
        char y0 = (char)str[off + 0];
        char y1 = (char)str[off + 1];
        char y2 = (char)str[off + 2];
        char y3 = (char)str[off + 3];
        char m0 = (char)str[off + 4];
        char m1 = (char)str[off + 5];
        char d0 = (char)str[off + 6];
        char d1 = (char)str[off + 7];
        char h0 = (char)str[off + 8];
        char h1 = (char)str[off + 9];
        char i0 = (char)str[off + 10];
        char i1 = (char)str[off + 11];
        char s0 = (char)str[off + 12];
        char s1 = (char)str[off + 13];
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime16(char[] str, int off) {
        int month;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 16 > str.length) {
            return null;
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        int c14 = str[off + 14];
        int c15 = str[off + 15];
        int s0 = 48;
        int s1 = 48;
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
        } else if (c8 == 84 && c15 == 90) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c11;
            i1 = c12;
            s0 = c13;
            s1 = c14;
        } else if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c12 == 58 && c14 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = 48;
            h1 = c11;
            i0 = 48;
            i1 = c13;
            s1 = c15;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58) {
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = 48;
            d1 = c0;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c14 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = 48;
            h1 = c11;
            i0 = 48;
            i1 = c13;
            s1 = c15;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month2 = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month2, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime16(byte[] str, int off) {
        int month;
        int i1;
        int i0;
        int h1;
        int h0;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 16 > str.length) {
            return null;
        }
        byte c0 = str[off + 0];
        byte c1 = str[off + 1];
        byte c2 = str[off + 2];
        byte c3 = str[off + 3];
        byte c4 = str[off + 4];
        byte c5 = str[off + 5];
        byte c6 = str[off + 6];
        byte c7 = str[off + 7];
        byte c8 = str[off + 8];
        byte c9 = str[off + 9];
        byte c10 = str[off + 10];
        byte c11 = str[off + 11];
        byte c12 = str[off + 12];
        byte c13 = str[off + 13];
        byte c14 = str[off + 14];
        byte c15 = str[off + 15];
        int s0 = 48;
        int s1 = 48;
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c5;
            m1 = (char)c6;
            d0 = (char)c8;
            d1 = (char)c9;
            h0 = (char)c11;
            h1 = (char)c12;
            i0 = (char)c14;
            i1 = (char)c15;
        } else if (c8 == 84 && c15 == 90) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = c4;
            m1 = (char)c5;
            d0 = c6;
            d1 = (char)c7;
            h0 = c9;
            h1 = c10;
            i0 = c11;
            i1 = c12;
            s0 = (char)c13;
            s1 = (char)c14;
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c8 == -26 && c9 == -100 && c10 == -120 && c13 == -26 && c14 == -105 && c15 == -91) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c7;
            d0 = (char)c11;
            d1 = (char)c12;
            h0 = 48;
            h1 = 48;
            i0 = 48;
            i1 = 48;
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c9 == -26 && c10 == -100 && c11 == -120 && c13 == -26 && c14 == -105 && c15 == -91) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c7;
            m1 = (char)c8;
            d0 = 48;
            d1 = (char)c12;
            h0 = 48;
            h1 = 48;
            i0 = 48;
            i1 = 48;
        } else if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c12 == 58 && c14 == 58) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c5;
            m1 = (char)c6;
            d0 = (char)c8;
            d1 = (char)c9;
            h0 = 48;
            h1 = (char)c11;
            i0 = 48;
            i1 = (char)c13;
            s1 = (char)c15;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58) {
            y0 = (char)c6;
            y1 = (char)c7;
            y2 = (char)c8;
            y3 = (char)c9;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = 48;
            d1 = (char)c0;
            h0 = (char)c11;
            h1 = (char)c12;
            i0 = (char)c14;
            i1 = (char)c15;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c14 == 58) {
            d0 = 48;
            d1 = (char)c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = (char)c6;
            y1 = (char)c7;
            y2 = (char)c8;
            y3 = (char)c9;
            h0 = 48;
            h1 = (char)c11;
            i0 = 48;
            i1 = (char)c13;
            s1 = (char)c15;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month2 = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month2, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime17(char[] str, int off) {
        int month;
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 17 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        int c14 = str[off + 14];
        int c15 = str[off + 15];
        int c16 = str[off + 16];
        int nanoOfSecond = 0;
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58 && c16 == 90) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else if (c4 == 45 && c6 == 45 && (c8 == 32 || c8 == 84) && c11 == 58 && c14 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
            h0 = c9;
            h1 = c10;
            i0 = c12;
            i1 = c13;
            s0 = c15;
            s1 = c16;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = c0;
            d1 = c1;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = 48;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c14 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = 48;
            h1 = c11;
            i0 = 48;
            i1 = c13;
            s0 = c15;
            s1 = c16;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c15 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = 48;
            s1 = c16;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c15 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = 48;
            s1 = c16;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c15 == 58) {
            d0 = c0;
            d1 = c1;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month <= 0) {
                return null;
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = 48;
            s1 = c16;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c8;
            h1 = c9;
            i0 = c10;
            i1 = c11;
            s0 = c12;
            s1 = c13;
            if (c14 >= 48 && c14 <= 57 && c15 >= 48 && c15 <= 57 && c16 >= 48 && c16 <= 57) {
                nanoOfSecond = ((c14 - 48) * 100 + (c15 - 48) * 10 + (c16 - 48)) * 1000000;
            } else {
                return null;
            }
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month2 = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month2, dom, hour, minute, second, nanoOfSecond);
    }

    public static LocalDateTime parseLocalDateTime17(byte[] str, int off) {
        int month;
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 17 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        byte c0 = str[off + 0];
        byte c1 = str[off + 1];
        byte c2 = str[off + 2];
        byte c3 = str[off + 3];
        byte c4 = str[off + 4];
        byte c5 = str[off + 5];
        byte c6 = str[off + 6];
        byte c7 = str[off + 7];
        byte c8 = str[off + 8];
        byte c9 = str[off + 9];
        byte c10 = str[off + 10];
        byte c11 = str[off + 11];
        byte c12 = str[off + 12];
        byte c13 = str[off + 13];
        byte c14 = str[off + 14];
        byte c15 = str[off + 15];
        byte c16 = str[off + 16];
        int nanoOfSecond = 0;
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58 && c16 == 90) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = c5;
            m1 = (char)c6;
            d0 = (char)c8;
            d1 = (char)c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else if (c4 == 45 && c6 == 45 && (c8 == 32 || c8 == 84) && c11 == 58 && c14 == 58) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c5;
            d0 = 48;
            d1 = (char)c7;
            h0 = (char)c9;
            h1 = (char)c10;
            i0 = (char)c12;
            i1 = (char)c13;
            s0 = (char)c15;
            s1 = (char)c16;
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c9 == -26 && c10 == -100 && c11 == -120 && c14 == -26 && c15 == -105 && c16 == -91) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c7;
            m1 = (char)c8;
            d0 = (char)c12;
            d1 = (char)c13;
            h0 = 48;
            h1 = 48;
            i0 = 48;
            i1 = 48;
            s0 = 48;
            s1 = 48;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58) {
            y0 = (char)c7;
            y1 = (char)c8;
            y2 = (char)c9;
            y3 = (char)c10;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 17);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            d0 = (char)c0;
            d1 = (char)c1;
            h0 = (char)c12;
            h1 = (char)c13;
            i0 = (char)c15;
            i1 = (char)c16;
            s0 = 48;
            s1 = 48;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c14 == 58) {
            d0 = 48;
            d1 = (char)c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                String input = new String(str, off, 17);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = (char)c6;
            y1 = (char)c7;
            y2 = (char)c8;
            y3 = (char)c9;
            h0 = 48;
            h1 = (char)c11;
            i0 = 48;
            i1 = (char)c13;
            s0 = (char)c15;
            s1 = (char)c16;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c15 == 58) {
            d0 = 48;
            d1 = (char)c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                String input = new String(str, off, 17);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = (char)c6;
            y1 = (char)c7;
            y2 = (char)c8;
            y3 = (char)c9;
            h0 = 48;
            h1 = (char)c11;
            i0 = (char)c13;
            i1 = (char)c14;
            s0 = 48;
            s1 = (char)c16;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c15 == 58) {
            d0 = 48;
            d1 = (char)c0;
            month = DateUtils.month((char)c2, (char)c3, (char)c4);
            if (month <= 0) {
                String input = new String(str, off, 17);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = (char)c6;
            y1 = (char)c7;
            y2 = (char)c8;
            y3 = (char)c9;
            h0 = (char)c11;
            h1 = (char)c12;
            i0 = 48;
            i1 = (char)c14;
            s0 = 48;
            s1 = (char)c16;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c15 == 58) {
            d0 = (char)c0;
            d1 = (char)c1;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 17);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = (char)c7;
            y1 = (char)c8;
            y2 = (char)c9;
            y3 = (char)c10;
            h0 = 48;
            h1 = (char)c12;
            i0 = 48;
            i1 = (char)c14;
            s0 = 48;
            s1 = (char)c16;
        } else {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c4;
            m1 = (char)c5;
            d0 = (char)c6;
            d1 = (char)c7;
            h0 = (char)c8;
            h1 = (char)c9;
            i0 = (char)c10;
            i1 = (char)c11;
            s0 = (char)c12;
            s1 = (char)c13;
            if (c14 >= 48 && c14 <= 57 && c15 >= 48 && c15 <= 57 && c16 >= 48 && c16 <= 57) {
                nanoOfSecond = ((c14 - 48) * 100 + (c15 - 48) * 10 + (c16 - 48)) * 1000000;
            } else {
                return null;
            }
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = new String(str, off, 17);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            String input = new String(str, off, 17);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int month2 = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            String input = new String(str, off, 17);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            String input = new String(str, off, 17);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            String input = new String(str, off, 17);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            String input = new String(str, off, 17);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month2, dom, hour, minute, second, nanoOfSecond);
    }

    public static LocalDateTime parseLocalDateTime18(char[] str, int off) {
        int month;
        char s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 18 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        char c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        int c14 = str[off + 14];
        int c15 = str[off + 15];
        int c16 = str[off + 16];
        char c17 = str[off + 17];
        if (c4 == '-' && c6 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c12 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c15 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c15 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, c4);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c15 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, c4);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c16 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, c4);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c15 == 58) {
            d0 = c0;
            d1 = c1;
            month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int month2 = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month2, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime18(byte[] str, int off) {
        int month;
        char s1;
        int s0;
        char i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (off + 18 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int c0 = str[off + 0];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        char c4 = (char)str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        char c14 = (char)str[off + 14];
        char c15 = (char)str[off + 15];
        int c16 = str[off + 16];
        char c17 = (char)str[off + 17];
        if (c4 == '-' && c6 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c9 == 32 || c9 == 84) && c12 == 58 && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c12 == 58 && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c12 == 58 && c15 == ':') {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, c4);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = 48;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c15 == ':') {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, c4);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c1 == 32 && c5 == 32 && c10 == 32 && c13 == 58 && c16 == 58) {
            d0 = 48;
            d1 = c0;
            month = DateUtils.month((char)c2, (char)c3, c4);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c14 == ':' && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = c17;
        } else if (c2 == 32 && c6 == 32 && c11 == 32 && c13 == 58 && c15 == ':') {
            d0 = c0;
            d1 = c1;
            month = DateUtils.month((char)c3, c4, (char)c5);
            if (month <= 0) {
                String input = new String(str, off, 18);
                throw new DateTimeException("illegal input " + input, input, 0);
            }
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = 48;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int month2 = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            String input = new String(str, off, 18);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        return LocalDateTime.of(year, month2, dom, hour, minute, second);
    }

    public static LocalDateTime parseLocalDateTime19(char[] str, int off) {
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 19 > str.length) {
            return null;
        }
        char c0 = str[off + 0];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        char c17 = str[off + 17];
        char c18 = str[off + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == '/' && c5 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            int month = DateUtils.month(c2, c3, c4);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = '0';
                m1 = '0';
            }
            d0 = '0';
            d1 = c0;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else {
            return null;
        }
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1);
    }

    public static LocalDateTime parseLocalDateTime19(byte[] str, int off) {
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (off + 19 > str.length) {
            return null;
        }
        char c0 = (char)str[off + 0];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c11 = (char)str[off + 11];
        char c12 = (char)str[off + 12];
        char c13 = (char)str[off + 13];
        char c14 = (char)str[off + 14];
        char c15 = (char)str[off + 15];
        char c16 = (char)str[off + 16];
        char c17 = (char)str[off + 17];
        char c18 = (char)str[off + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == '/' && c5 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            int month = DateUtils.month(c2, c3, c4);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = '0';
                m1 = '0';
            }
            d0 = '0';
            d1 = c0;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else {
            return null;
        }
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1);
    }

    public static LocalDateTime parseLocalDateTime20(char[] str, int off) {
        char m1;
        char m0;
        if (off + 19 > str.length) {
            return null;
        }
        char c0 = str[off + 0];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        char c17 = str[off + 17];
        char c18 = str[off + 18];
        char c19 = str[off + 19];
        if (c2 != ' ' || c6 != ' ' || c11 != ' ' || c14 != ':' || c17 != ':') {
            return null;
        }
        int month = DateUtils.month(c3, c4, c5);
        if (month > 0) {
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
        } else {
            m0 = '0';
            m1 = '0';
        }
        return DateUtils.localDateTime(c7, c8, c9, c10, m0, m1, c0, c1, c12, c13, c15, c16, c18, c19);
    }

    public static LocalDateTime parseLocalDateTime20(byte[] str, int off) {
        char m1;
        char m0;
        if (off + 19 > str.length) {
            return null;
        }
        char c0 = (char)str[off + 0];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c11 = (char)str[off + 11];
        char c12 = (char)str[off + 12];
        char c13 = (char)str[off + 13];
        char c14 = (char)str[off + 14];
        char c15 = (char)str[off + 15];
        char c16 = (char)str[off + 16];
        char c17 = (char)str[off + 17];
        char c18 = (char)str[off + 18];
        char c19 = (char)str[off + 19];
        if (c2 != ' ' || c6 != ' ' || c11 != ' ' || c14 != ':' || c17 != ':') {
            return null;
        }
        char y0 = c7;
        char y1 = c8;
        char y2 = c9;
        char y3 = c10;
        int month = DateUtils.month(c3, c4, c5);
        if (month > 0) {
            m0 = (char)(48 + month / 10);
            m1 = (char)(48 + month % 10);
        } else {
            m0 = '0';
            m1 = '0';
        }
        char d0 = c0;
        char d1 = c1;
        char h0 = c12;
        char h1 = c13;
        char i0 = c15;
        char i1 = c16;
        char s0 = c18;
        char s1 = c19;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1);
    }

    public static LocalDateTime parseLocalDateTime26(byte[] str, int off) {
        if (off + 26 > str.length) {
            return null;
        }
        char c0 = (char)str[off + 0];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c11 = (char)str[off + 11];
        char c12 = (char)str[off + 12];
        char c13 = (char)str[off + 13];
        char c14 = (char)str[off + 14];
        char c15 = (char)str[off + 15];
        char c16 = (char)str[off + 16];
        char c17 = (char)str[off + 17];
        char c18 = (char)str[off + 18];
        char c19 = (char)str[off + 19];
        char c20 = (char)str[off + 20];
        char c21 = (char)str[off + 21];
        char c22 = (char)str[off + 22];
        char c23 = (char)str[off + 23];
        char c24 = (char)str[off + 24];
        char c25 = (char)str[off + 25];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, '0', '0', '0');
    }

    public static LocalDateTime parseLocalDateTime26(char[] str, int off) {
        if (off + 26 > str.length) {
            return null;
        }
        char c0 = str[off + 0];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        char c17 = str[off + 17];
        char c18 = str[off + 18];
        char c19 = str[off + 19];
        char c20 = str[off + 20];
        char c21 = str[off + 21];
        char c22 = str[off + 22];
        char c23 = str[off + 23];
        char c24 = str[off + 24];
        char c25 = str[off + 25];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, '0', '0', '0');
    }

    public static LocalDateTime parseLocalDateTime27(byte[] str, int off) {
        if (off + 27 > str.length) {
            return null;
        }
        char c0 = (char)str[off + 0];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c11 = (char)str[off + 11];
        char c12 = (char)str[off + 12];
        char c13 = (char)str[off + 13];
        char c14 = (char)str[off + 14];
        char c15 = (char)str[off + 15];
        char c16 = (char)str[off + 16];
        char c17 = (char)str[off + 17];
        char c18 = (char)str[off + 18];
        char c19 = (char)str[off + 19];
        char c20 = (char)str[off + 20];
        char c21 = (char)str[off + 21];
        char c22 = (char)str[off + 22];
        char c23 = (char)str[off + 23];
        char c24 = (char)str[off + 24];
        char c25 = (char)str[off + 25];
        char c26 = (char)str[off + 26];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, '0', '0');
    }

    public static LocalDateTime parseLocalDateTime27(char[] str, int off) {
        if (off + 27 > str.length) {
            return null;
        }
        char c0 = str[off + 0];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        char c17 = str[off + 17];
        char c18 = str[off + 18];
        char c19 = str[off + 19];
        char c20 = str[off + 20];
        char c21 = str[off + 21];
        char c22 = str[off + 22];
        char c23 = str[off + 23];
        char c24 = str[off + 24];
        char c25 = str[off + 25];
        char c26 = str[off + 26];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, '0', '0');
    }

    public static LocalDateTime parseLocalDateTime28(char[] str, int off) {
        if (off + 28 > str.length) {
            return null;
        }
        char c0 = str[off + 0];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        char c17 = str[off + 17];
        char c18 = str[off + 18];
        char c19 = str[off + 19];
        char c20 = str[off + 20];
        char c21 = str[off + 21];
        char c22 = str[off + 22];
        char c23 = str[off + 23];
        char c24 = str[off + 24];
        char c25 = str[off + 25];
        char c26 = str[off + 26];
        char c27 = str[off + 27];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, '0');
    }

    public static LocalDateTime parseLocalDateTime28(byte[] str, int off) {
        if (off + 28 > str.length) {
            return null;
        }
        char c0 = (char)str[off + 0];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c11 = (char)str[off + 11];
        char c12 = (char)str[off + 12];
        char c13 = (char)str[off + 13];
        char c14 = (char)str[off + 14];
        char c15 = (char)str[off + 15];
        char c16 = (char)str[off + 16];
        char c17 = (char)str[off + 17];
        char c18 = (char)str[off + 18];
        char c19 = (char)str[off + 19];
        char c20 = (char)str[off + 20];
        char c21 = (char)str[off + 21];
        char c22 = (char)str[off + 22];
        char c23 = (char)str[off + 23];
        char c24 = (char)str[off + 24];
        char c25 = (char)str[off + 25];
        char c26 = (char)str[off + 26];
        char c27 = (char)str[off + 27];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, '0');
    }

    public static LocalDateTime parseLocalDateTime29(byte[] str, int off) {
        if (off + 29 > str.length) {
            return null;
        }
        char c0 = (char)str[off + 0];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c11 = (char)str[off + 11];
        char c12 = (char)str[off + 12];
        char c13 = (char)str[off + 13];
        char c14 = (char)str[off + 14];
        char c15 = (char)str[off + 15];
        char c16 = (char)str[off + 16];
        char c17 = (char)str[off + 17];
        char c18 = (char)str[off + 18];
        char c19 = (char)str[off + 19];
        char c20 = (char)str[off + 20];
        char c21 = (char)str[off + 21];
        char c22 = (char)str[off + 22];
        char c23 = (char)str[off + 23];
        char c24 = (char)str[off + 24];
        char c25 = (char)str[off + 25];
        char c26 = (char)str[off + 26];
        char c27 = (char)str[off + 27];
        char c28 = (char)str[off + 28];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
    }

    public static LocalDateTime parseLocalDateTime29(char[] str, int off) {
        if (off + 29 > str.length) {
            return null;
        }
        char c0 = str[off + 0];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c11 = str[off + 11];
        char c12 = str[off + 12];
        char c13 = str[off + 13];
        char c14 = str[off + 14];
        char c15 = str[off + 15];
        char c16 = str[off + 16];
        char c17 = str[off + 17];
        char c18 = str[off + 18];
        char c19 = str[off + 19];
        char c20 = str[off + 20];
        char c21 = str[off + 21];
        char c22 = str[off + 22];
        char c23 = str[off + 23];
        char c24 = str[off + 24];
        char c25 = str[off + 25];
        char c26 = str[off + 26];
        char c27 = str[off + 27];
        char c28 = str[off + 28];
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
    }

    public static LocalDateTime parseLocalDateTimeX(char[] str, int offset, int len) {
        char c20;
        if (str == null || len == 0) {
            return null;
        }
        if (len < 21 || len > 29) {
            return null;
        }
        char c0 = str[offset + 0];
        char c1 = str[offset + 1];
        char c2 = str[offset + 2];
        char c3 = str[offset + 3];
        char c4 = str[offset + 4];
        char c5 = str[offset + 5];
        char c6 = str[offset + 6];
        char c7 = str[offset + 7];
        char c8 = str[offset + 8];
        char c9 = str[offset + 9];
        char c10 = str[offset + 10];
        char c11 = str[offset + 11];
        char c12 = str[offset + 12];
        char c13 = str[offset + 13];
        char c14 = str[offset + 14];
        char c15 = str[offset + 15];
        char c16 = str[offset + 16];
        char c17 = str[offset + 17];
        char c18 = str[offset + 18];
        char c19 = str[offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = str[offset + 20];
                break;
            }
            case 22: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                break;
            }
            case 23: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                break;
            }
            case 24: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                break;
            }
            case 25: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                break;
            }
            case 26: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                break;
            }
            case 27: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                c26 = str[offset + 26];
                break;
            }
            case 28: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                c26 = str[offset + 26];
                c27 = str[offset + 27];
                break;
            }
            default: {
                c20 = str[offset + 20];
                c21 = str[offset + 21];
                c22 = str[offset + 22];
                c23 = str[offset + 23];
                c24 = str[offset + 24];
                c25 = str[offset + 25];
                c26 = str[offset + 26];
                c27 = str[offset + 27];
                c28 = str[offset + 28];
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
    }

    public static LocalDateTime parseLocalDateTimeX(byte[] str, int offset, int len) {
        char c20;
        if (str == null || len == 0) {
            return null;
        }
        if (len < 21 || len > 29) {
            return null;
        }
        char c0 = (char)str[offset + 0];
        char c1 = (char)str[offset + 1];
        char c2 = (char)str[offset + 2];
        char c3 = (char)str[offset + 3];
        char c4 = (char)str[offset + 4];
        char c5 = (char)str[offset + 5];
        char c6 = (char)str[offset + 6];
        char c7 = (char)str[offset + 7];
        char c8 = (char)str[offset + 8];
        char c9 = (char)str[offset + 9];
        char c10 = (char)str[offset + 10];
        char c11 = (char)str[offset + 11];
        char c12 = (char)str[offset + 12];
        char c13 = (char)str[offset + 13];
        char c14 = (char)str[offset + 14];
        char c15 = (char)str[offset + 15];
        char c16 = (char)str[offset + 16];
        char c17 = (char)str[offset + 17];
        char c18 = (char)str[offset + 18];
        char c19 = (char)str[offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = (char)str[offset + 20];
                break;
            }
            case 22: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                break;
            }
            case 23: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                break;
            }
            case 24: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                break;
            }
            case 25: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                break;
            }
            case 26: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                break;
            }
            case 27: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                c26 = (char)str[offset + 26];
                break;
            }
            case 28: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                c26 = (char)str[offset + 26];
                c27 = (char)str[offset + 27];
                break;
            }
            default: {
                c20 = (char)str[offset + 20];
                c21 = (char)str[offset + 21];
                c22 = (char)str[offset + 22];
                c23 = (char)str[offset + 23];
                c24 = (char)str[offset + 24];
                c25 = (char)str[offset + 25];
                c26 = (char)str[offset + 26];
                c27 = (char)str[offset + 27];
                c28 = (char)str[offset + 28];
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        return DateUtils.localDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
    }

    static ZonedDateTime parseZonedDateTime16(char[] str, int off, ZoneId defaultZonedId) {
        if (off + 16 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        char c0 = str[off];
        char c1 = str[off + 1];
        char c2 = str[off + 2];
        char c3 = str[off + 3];
        char c4 = str[off + 4];
        char c5 = str[off + 5];
        char c6 = str[off + 6];
        char c7 = str[off + 7];
        char c8 = str[off + 8];
        char c9 = str[off + 9];
        char c10 = str[off + 10];
        char c13 = str[off + 13];
        if (c4 != '-' || c7 != '-' || c10 != '+' && c10 != '-' || c13 != ':') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        String zoneIdStr = new String(str, off + 10, 6);
        ZoneId zoneId = DateUtils.getZoneId(zoneIdStr, defaultZonedId);
        LocalDateTime ldt = LocalDateTime.of(LocalDate.of(year, month, dom), LocalTime.MIN);
        return ZonedDateTime.of(ldt, zoneId);
    }

    static ZonedDateTime parseZonedDateTime16(byte[] str, int off, ZoneId defaultZonedId) {
        if (off + 16 > str.length) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        char c0 = (char)str[off];
        char c1 = (char)str[off + 1];
        char c2 = (char)str[off + 2];
        char c3 = (char)str[off + 3];
        char c4 = (char)str[off + 4];
        char c5 = (char)str[off + 5];
        char c6 = (char)str[off + 6];
        char c7 = (char)str[off + 7];
        char c8 = (char)str[off + 8];
        char c9 = (char)str[off + 9];
        char c10 = (char)str[off + 10];
        char c13 = (char)str[off + 13];
        if (c4 != '-' || c7 != '-' || c10 != '+' && c10 != '-' || c13 != ':') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            String input = new String(str, off, 16);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        String zoneIdStr = new String(str, off + 10, 6);
        ZoneId zoneId = DateUtils.getZoneId(zoneIdStr, defaultZonedId);
        LocalDateTime ldt = LocalDateTime.of(LocalDate.of(year, month, dom), LocalTime.MIN);
        return ZonedDateTime.of(ldt, zoneId);
    }

    public static ZonedDateTime parseZonedDateTime(String str) {
        return DateUtils.parseZonedDateTime(str, ZoneId.DEFAULT_ZONE_ID);
    }

    public static ZonedDateTime parseZonedDateTime(String str, ZoneId defaultZoneId) {
        if (str == null) {
            return null;
        }
        int len = str.length();
        if (len == 0) {
            return null;
        }
        char[] chars = JDKUtils.getCharArray(str);
        ZonedDateTime zdt = DateUtils.parseZonedDateTime(chars, 0, chars.length, defaultZoneId);
        if (zdt == null) {
            switch (str) {
                case "null": 
                case "0": 
                case "0000-00-00": {
                    return null;
                }
            }
            throw new DateTimeException(str, str, 0);
        }
        return zdt;
    }

    public static ZonedDateTime parseZonedDateTime(byte[] str, int off, int len, ZoneId defaultZoneId) {
        ZoneId zoneId;
        LocalDateTime ldt;
        int month;
        int zoneIdBegin;
        int S8;
        int S7;
        int S6;
        int S5;
        int S4;
        int S3;
        int S2;
        int S1;
        int S0;
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        int c20;
        if (str == null) {
            return null;
        }
        if (len == 0) {
            return null;
        }
        if (len == 16) {
            return DateUtils.parseZonedDateTime16(str, off, defaultZoneId);
        }
        if (len < 19) {
            return null;
        }
        String zoneIdStr = null;
        int c0 = str[off];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        int c14 = str[off + 14];
        int c15 = str[off + 15];
        int c16 = str[off + 16];
        int c17 = str[off + 17];
        int c18 = str[off + 18];
        int c19 = (char)(len == 19 ? 32 : (char)str[off + 19]);
        int c21 = 48;
        int c22 = 48;
        int c23 = 48;
        int c24 = 48;
        int c25 = 48;
        int c26 = 48;
        int c27 = 48;
        int c28 = 48;
        char c29 = '\u0000';
        switch (len) {
            case 19: 
            case 20: {
                c20 = 0;
                break;
            }
            case 21: {
                c20 = str[off + 20];
                break;
            }
            case 22: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                break;
            }
            case 23: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                break;
            }
            case 24: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                break;
            }
            case 25: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                break;
            }
            case 26: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                break;
            }
            case 27: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                break;
            }
            case 28: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                c27 = (char)str[off + 27];
                break;
            }
            case 29: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                c27 = (char)str[off + 27];
                c28 = (char)str[off + 28];
                break;
            }
            default: {
                c20 = (char)str[off + 20];
                c21 = (char)str[off + 21];
                c22 = (char)str[off + 22];
                c23 = (char)str[off + 23];
                c24 = (char)str[off + 24];
                c25 = (char)str[off + 25];
                c26 = (char)str[off + 26];
                c27 = (char)str[off + 27];
                c28 = (char)str[off + 28];
                c29 = (char)str[off + 29];
            }
        }
        boolean isTimeZone = false;
        boolean pm = false;
        if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
        } else if (c4 == 45 && c7 == 45 && c10 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && len == 20) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (len == 20 && c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c0;
            d1 = c1;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 21 && c21 != 91 && c21 != 43 && c21 != 45 && c21 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 22 && c22 != 91 && c22 != 43 && c22 != 45 && c22 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == 124;
        } else if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 90 && c17 == 91 && c21 == 93 && len == 22) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (len == 22 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = 48;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 22 && c2 == 47 && c5 == 47 && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            m0 = c0;
            m1 = c1;
            d0 = c3;
            d1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 23 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = c12;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 23 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = 48;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 24 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = c13;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 23 && c23 != 91 && c23 != 124 && c23 != 43 && c23 != 45 && c23 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 24 && c24 != 91 && c24 != 124 && c24 != 43 && c24 != 45 && c24 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 25 && c25 != 91 && c25 != 124 && c25 != 43 && c25 != 45 && c25 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 26 && c26 != 91 && c26 != 124 && c26 != 43 && c26 != 45 && c26 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 27 && c27 != 91 && c27 != 124 && c27 != 43 && c27 != 45 && c27 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            if (c23 == 32) {
                S3 = 48;
                S4 = 48;
                S5 = 48;
                S6 = 48;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 23;
            } else {
                S3 = c23;
                S4 = c24;
                S5 = c25;
                S6 = c26;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 27;
                isTimeZone = c27 == 124;
            }
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (len == 28 && c3 == 32 && c7 == 32 && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && c23 == 32) {
            month = DateUtils.month((char)c4, (char)c5, (char)c6);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            y0 = c24;
            y1 = c25;
            y2 = c26;
            y3 = c27;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
            zoneIdStr = new String(str, off + 20, 3);
        } else if (len == 28 && c3 == 44 && c4 == 32 && c6 == 32 && c10 == 32 && c15 == 32 && c18 == 58 && c21 == 58 && c24 == 32) {
            y0 = c11;
            y1 = c12;
            y2 = c13;
            y3 = c14;
            month = DateUtils.month((char)c7, (char)c8, (char)c9);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c5;
            h0 = c16;
            h1 = c17;
            i0 = c19;
            i1 = c20;
            s0 = c22;
            s1 = c23;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = true;
        } else if (len == 29 && c3 == 44 && c4 == 32 && c7 == 32 && c11 == 32 && c16 == 32 && c19 == 58 && c22 == 58 && c25 == 32) {
            y0 = c12;
            y1 = c13;
            y2 = c14;
            y3 = c15;
            month = DateUtils.month((char)c8, (char)c9, (char)c10);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c5;
            d1 = c6;
            h0 = c17;
            h1 = c18;
            i0 = c20;
            i1 = c21;
            s0 = c23;
            s1 = c24;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = true;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 29 && c29 != '[' && c29 != '|' && c29 != '+' && c29 != '-' && c29 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == '|';
        } else if (len == 22 && (c17 == 43 || c17 == 45)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c8;
            h1 = c9;
            i0 = c10;
            i1 = c11;
            s0 = c12;
            s1 = c13;
            S0 = c14;
            S1 = c15;
            S2 = c16;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 17;
        } else {
            if (len == 32 && c6 == 44 && c7 == 32 && c10 == 45 && c14 == 45 && c19 == 32 && c22 == 58 && c25 == 58 && str[off + 28] == 32 || len == 33 && c7 == 44 && c8 == 32 && c11 == 45 && c15 == 45 && c20 == 32 && c23 == 58 && c26 == 58 && str[off + 29] == 32 || len == 34 && c8 == 44 && c9 == 32 && c12 == 45 && c16 == 45 && c21 == 32 && c24 == 58 && c27 == 58 && str[off + 30] == 32 || len == 35 && c9 == 44 && c10 == 32 && c13 == 45 && c17 == 45 && c22 == 32 && c25 == 58 && c28 == 58 && str[off + 31] == 32) {
                return DateUtils.parseZonedDateTimeCookie(new String(str, off, len));
            }
            if (len == 34) {
                DateTimeFormatter formatter = DATE_TIME_FORMATTER_34;
                if (formatter == null) {
                    formatter = DATE_TIME_FORMATTER_34 = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss O yyyy");
                }
                return formatter.parseZonedDateTime(new String(str, off, len));
            }
            if (len == 31 && str[off + 3] == 44) {
                DateTimeFormatter formatter = DATE_TIME_FORMATTER_RFC_2822;
                if (formatter == null) {
                    formatter = DATE_TIME_FORMATTER_RFC_2822 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z");
                }
                return formatter.parseZonedDateTime(new String(str, off, len));
            }
            return null;
        }
        if (pm) {
            int hourValue = DateUtils.hourAfterNoon((char)h0, (char)h1);
            h0 = (char)(hourValue >> 16);
            h1 = (char)hourValue;
        }
        if ((ldt = DateUtils.localDateTime((char)y0, (char)y1, (char)y2, (char)y3, (char)m0, (char)m1, (char)d0, (char)d1, (char)h0, (char)h1, (char)i0, (char)i1, (char)s0, (char)s1, (char)S0, (char)S1, (char)S2, (char)S3, (char)S4, (char)S5, (char)S6, (char)S7, (char)S8)) == null) {
            return null;
        }
        if (isTimeZone) {
            String tzStr;
            switch (tzStr = new String(str, zoneIdBegin, len - zoneIdBegin)) {
                case "UTC": 
                case "[UTC]": {
                    zoneId = ZoneId.UTC;
                    break;
                }
                default: {
                    TimeZone timeZone = TimeZone.getTimeZone(tzStr);
                    zoneId = ZoneId.of(timeZone);
                    break;
                }
            }
        } else if (zoneIdBegin == len) {
            zoneId = defaultZoneId;
        } else {
            char first = (char)str[off + zoneIdBegin];
            if (first == 'Z') {
                zoneId = ZoneId.UTC;
            } else {
                if (zoneIdStr == null) {
                    if (first == '+' || first == '-') {
                        zoneIdStr = new String(str, off + zoneIdBegin, len - zoneIdBegin);
                    } else if (first == ' ') {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 1);
                    } else if (zoneIdBegin < len) {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 2);
                    }
                }
                zoneId = DateUtils.getZoneId(zoneIdStr, defaultZoneId);
            }
        }
        if (zoneId == null) {
            zoneId = defaultZoneId;
        }
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        return ZonedDateTime.ofLocal(ldt, zoneId);
    }

    public static ZonedDateTime parseZonedDateTime(char[] str, int off, int len, ZoneId defaultZoneId) {
        ZoneId zoneId;
        LocalDateTime ldt;
        int month;
        int zoneIdBegin;
        int S8;
        int S7;
        int S6;
        int S5;
        int S4;
        int S3;
        int S2;
        int S1;
        int S0;
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        int d1;
        int d0;
        int m1;
        int m0;
        int y3;
        int y2;
        int y1;
        int y0;
        int c20;
        if (str == null) {
            return null;
        }
        if (len == 0) {
            return null;
        }
        if (len == 16) {
            return DateUtils.parseZonedDateTime16(str, off, defaultZoneId);
        }
        if (len < 19) {
            String input = new String(str, off, str.length - off);
            throw new DateTimeException("illegal input " + input, input, 0);
        }
        String zoneIdStr = null;
        int c0 = str[off];
        int c1 = str[off + 1];
        int c2 = str[off + 2];
        int c3 = str[off + 3];
        int c4 = str[off + 4];
        int c5 = str[off + 5];
        int c6 = str[off + 6];
        int c7 = str[off + 7];
        int c8 = str[off + 8];
        int c9 = str[off + 9];
        int c10 = str[off + 10];
        int c11 = str[off + 11];
        int c12 = str[off + 12];
        int c13 = str[off + 13];
        int c14 = str[off + 14];
        int c15 = str[off + 15];
        int c16 = str[off + 16];
        int c17 = str[off + 17];
        int c18 = str[off + 18];
        int c19 = len == 19 ? 32 : str[off + 19];
        int c21 = 48;
        int c22 = 48;
        int c23 = 48;
        int c24 = 48;
        int c25 = 48;
        int c26 = 48;
        int c27 = 48;
        int c28 = 48;
        char c29 = '\u0000';
        switch (len) {
            case 19: 
            case 20: {
                c20 = 0;
                break;
            }
            case 21: {
                c20 = str[off + 20];
                break;
            }
            case 22: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                break;
            }
            case 23: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                break;
            }
            case 24: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                break;
            }
            case 25: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                break;
            }
            case 26: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                break;
            }
            case 27: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                break;
            }
            case 28: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                c27 = str[off + 27];
                break;
            }
            case 29: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                c27 = str[off + 27];
                c28 = str[off + 28];
                break;
            }
            default: {
                c20 = str[off + 20];
                c21 = str[off + 21];
                c22 = str[off + 22];
                c23 = str[off + 23];
                c24 = str[off + 24];
                c25 = str[off + 25];
                c26 = str[off + 26];
                c27 = str[off + 27];
                c28 = str[off + 28];
                c29 = str[off + 29];
            }
        }
        boolean isTimeZone = false;
        boolean pm = false;
        if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
        } else if (c4 == 45 && c7 == 45 && c10 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && len == 20) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (len == 20 && c2 == 32 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c3, (char)c4, (char)c5);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c0;
            d1 = c1;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 20;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 21 && c21 != 91 && c21 != 43 && c21 != 45 && c21 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 22 && c22 != 91 && c22 != 43 && c22 != 45 && c22 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == 124;
        } else if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 90 && c17 == 91 && c21 == 93 && len == 22) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (len == 22 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = 48;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 22 && c2 == 47 && c5 == 47 && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && (c20 == 65 || c20 == 80) && c21 == 77) {
            m0 = c0;
            m1 = c1;
            d0 = c3;
            d1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            pm = c20 == 80;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 22;
        } else if (len == 23 && c3 == 32 && c5 == 44 && c6 == 32 && c11 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c4;
            h0 = c12;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 23 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c14 == 58 && c17 == 58 && c20 == 32 && (c21 == 65 || c21 == 80) && c22 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = 48;
            h1 = c13;
            pm = c21 == 80;
            i0 = c15;
            i1 = c16;
            s0 = c18;
            s1 = c19;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
        } else if (len == 24 && c3 == 32 && c6 == 44 && c7 == 32 && c12 == 32 && c15 == 58 && c18 == 58 && c21 == 32 && (c22 == 65 || c22 == 80) && c23 == 77) {
            y0 = c8;
            y1 = c9;
            y2 = c10;
            y3 = c11;
            month = DateUtils.month((char)c0, (char)c1, (char)c2);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c4;
            d1 = c5;
            h0 = c13;
            h1 = c14;
            pm = c22 == 80;
            i0 = c16;
            i1 = c17;
            s0 = c19;
            s1 = c20;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 23 && c23 != 91 && c23 != 124 && c23 != 43 && c23 != 45 && c23 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 24 && c24 != 91 && c24 != 124 && c24 != 43 && c24 != 45 && c24 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 25 && c25 != 91 && c25 != 124 && c25 != 43 && c25 != 45 && c25 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 26 && c26 != 91 && c26 != 124 && c26 != 43 && c26 != 45 && c26 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == 124;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 27 && c27 != 91 && c27 != 124 && c27 != 43 && c27 != 45 && c27 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            if (c23 == 32) {
                S3 = 48;
                S4 = 48;
                S5 = 48;
                S6 = 48;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 23;
            } else {
                S3 = c23;
                S4 = c24;
                S5 = c25;
                S6 = c26;
                S7 = 48;
                S8 = 48;
                zoneIdBegin = 27;
                isTimeZone = c27 == 124;
            }
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (len == 28 && c3 == 32 && c7 == 32 && c10 == 32 && c13 == 58 && c16 == 58 && c19 == 32 && c23 == 32) {
            month = DateUtils.month((char)c4, (char)c5, (char)c6);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            y0 = c24;
            y1 = c25;
            y2 = c26;
            y3 = c27;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 19;
            zoneIdStr = new String(str, off + 20, 3);
        } else if (len == 28 && c3 == 44 && c4 == 32 && c6 == 32 && c10 == 32 && c15 == 32 && c18 == 58 && c21 == 58 && c24 == 32) {
            y0 = c11;
            y1 = c12;
            y2 = c13;
            y3 = c14;
            month = DateUtils.month((char)c7, (char)c8, (char)c9);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = 48;
            d1 = c5;
            h0 = c16;
            h1 = c17;
            i0 = c19;
            i1 = c20;
            s0 = c22;
            s1 = c23;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = true;
        } else if (len == 29 && c3 == 44 && c4 == 32 && c7 == 32 && c11 == 32 && c16 == 32 && c19 == 58 && c22 == 58 && c25 == 32) {
            y0 = c12;
            y1 = c13;
            y2 = c14;
            y3 = c15;
            month = DateUtils.month((char)c8, (char)c9, (char)c10);
            if (month > 0) {
                m0 = (char)(48 + month / 10);
                m1 = (char)(48 + month % 10);
            } else {
                m0 = 48;
                m1 = 48;
            }
            d0 = c5;
            d1 = c6;
            h0 = c17;
            h1 = c18;
            i0 = c20;
            i1 = c21;
            s0 = c23;
            s1 = c24;
            S0 = 48;
            S1 = 48;
            S2 = 48;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = true;
        } else if (!(c4 != 45 || c7 != 45 || c10 != 32 && c10 != 84 || c13 != 58 || c16 != 58 || c19 != 46 || len != 29 && c29 != '[' && c29 != '|' && c29 != '+' && c29 != '-' && c29 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == '|';
        } else if (len == 22 && (c17 == 43 || c17 == 45)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
            h0 = c8;
            h1 = c9;
            i0 = c10;
            i1 = c11;
            s0 = c12;
            s1 = c13;
            S0 = c14;
            S1 = c15;
            S2 = c16;
            S3 = 48;
            S4 = 48;
            S5 = 48;
            S6 = 48;
            S7 = 48;
            S8 = 48;
            zoneIdBegin = 17;
        } else {
            if (len == 32 && c6 == 44 && c7 == 32 && c10 == 45 && c14 == 45 && c19 == 32 && c22 == 58 && c25 == 58 && str[off + 28] == ' ' || len == 33 && c7 == 44 && c8 == 32 && c11 == 45 && c15 == 45 && c20 == 32 && c23 == 58 && c26 == 58 && str[off + 29] == ' ' || len == 34 && c8 == 44 && c9 == 32 && c12 == 45 && c16 == 45 && c21 == 32 && c24 == 58 && c27 == 58 && str[off + 30] == ' ' || len == 35 && c9 == 44 && c10 == 32 && c13 == 45 && c17 == 45 && c22 == 32 && c25 == 58 && c28 == 58 && str[off + 31] == ' ') {
                return DateUtils.parseZonedDateTimeCookie(new String(str, off, len));
            }
            if (len == 34) {
                Date date;
                String dateStr = new String(str, off, len);
                String pattern = "EEE MMM dd HH:mm:ss z yyyy";
                SimpleDateFormat fmt = new SimpleDateFormat(pattern);
                try {
                    date = fmt.parse(dateStr);
                }
                catch (ParseException e) {
                    throw new JSONException("parse error, format " + pattern + ", input " + dateStr);
                }
                return ZonedDateTime.ofInstant(Instant.of(date), ZoneId.DEFAULT_ZONE_ID);
            }
            if (len == 31 && str[off + 3] == ',') {
                DateTimeFormatter formatter = DATE_TIME_FORMATTER_RFC_2822;
                if (formatter == null) {
                    formatter = DATE_TIME_FORMATTER_RFC_2822 = DateTimeFormatter.ofPattern("EEE, dd MMM yyyy HH:mm:ss Z");
                }
                return formatter.parseZonedDateTime(new String(str, off, len));
            }
            return null;
        }
        if (pm) {
            int hourValue = DateUtils.hourAfterNoon((char)h0, (char)h1);
            h0 = (char)(hourValue >> 16);
            h1 = (char)hourValue;
        }
        if ((ldt = DateUtils.localDateTime((char)y0, (char)y1, (char)y2, (char)y3, (char)m0, (char)m1, (char)d0, (char)d1, (char)h0, (char)h1, (char)i0, (char)i1, (char)s0, (char)s1, (char)S0, (char)S1, (char)S2, (char)S3, (char)S4, (char)S5, (char)S6, (char)S7, (char)S8)) == null) {
            return null;
        }
        if (isTimeZone) {
            String tzStr;
            switch (tzStr = new String(str, zoneIdBegin, len - zoneIdBegin)) {
                case "UTC": 
                case "[UTC]": {
                    zoneId = ZoneId.UTC;
                    break;
                }
                default: {
                    TimeZone timeZone = TimeZone.getTimeZone(tzStr);
                    zoneId = ZoneId.of(timeZone);
                    break;
                }
            }
        } else if (zoneIdBegin == len) {
            zoneId = defaultZoneId;
        } else {
            char first = str[off + zoneIdBegin];
            if (first == 'Z') {
                zoneId = ZoneId.UTC;
            } else {
                if (zoneIdStr == null) {
                    if (first == '+' || first == '-') {
                        zoneIdStr = new String(str, off + zoneIdBegin, len - zoneIdBegin);
                    } else if (first == ' ') {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 1);
                    } else if (zoneIdBegin < len) {
                        zoneIdStr = new String(str, off + zoneIdBegin + 1, len - zoneIdBegin - 2);
                    }
                }
                zoneId = DateUtils.getZoneId(zoneIdStr, defaultZoneId);
            }
        }
        if (zoneId == null) {
            zoneId = defaultZoneId;
        }
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        return ZonedDateTime.ofLocal(ldt, zoneId);
    }

    static ZonedDateTime parseZonedDateTimeCookie(String str) {
        if (str.endsWith(" CST")) {
            DateTimeFormatter formatter = DATE_TIME_FORMATTER_COOKIE_LOCAL;
            if (formatter == null) {
                DATE_TIME_FORMATTER_COOKIE_LOCAL = formatter = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yyyy HH:mm:ss");
            }
            String strLocalDateTime = str.substring(0, str.length() - 4);
            LocalDateTime ldt = formatter.parseLocalDateTime(strLocalDateTime);
            return ZonedDateTime.of(ldt, ZoneId.SHANGHAI_ZONE_ID);
        }
        DateTimeFormatter formatter = DATE_TIME_FORMATTER_COOKIE;
        if (formatter == null) {
            DATE_TIME_FORMATTER_COOKIE = formatter = DateTimeFormatter.ofPattern("EEEE, dd-MMM-yyyy HH:mm:ss zzz");
        }
        return formatter.parseZonedDateTime(str);
    }

    public static ZoneId getZoneId(String zoneIdStr, ZoneId defaultZoneId) {
        ZoneId zoneId;
        if (zoneIdStr == null) {
            return defaultZoneId != null ? defaultZoneId : ZoneId.DEFAULT_ZONE_ID;
        }
        switch (zoneIdStr) {
            case "000": {
                zoneId = ZoneId.UTC;
                break;
            }
            case "+08:00": {
                zoneId = ZoneId.OFFSET_8_ZONE_ID;
                break;
            }
            case "CST": {
                zoneId = ZoneId.SHANGHAI_ZONE_ID;
                break;
            }
            default: {
                int p1;
                char c0;
                if (zoneIdStr.length() > 0 && ((c0 = zoneIdStr.charAt(0)) == '+' || c0 == '-') && zoneIdStr.charAt(zoneIdStr.length() - 1) != ']') {
                    zoneId = ZoneId.of(zoneIdStr);
                    break;
                }
                int p0 = zoneIdStr.indexOf(91);
                if (p0 > 0 && (p1 = zoneIdStr.indexOf(93, p0)) > 0) {
                    String str = zoneIdStr.substring(p0 + 1, p1);
                    zoneId = ZoneId.of(str);
                    break;
                }
                zoneId = ZoneId.of(zoneIdStr);
            }
        }
        return zoneId;
    }

    public static long parseMillisYMDHMS19(String str, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        if (str == null) {
            return 0L;
        }
        if (str.length() != 19) {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        char c2 = str.charAt(2);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c5 = str.charAt(5);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        char c8 = str.charAt(8);
        char c9 = str.charAt(9);
        char c10 = str.charAt(10);
        char c11 = str.charAt(11);
        char c12 = str.charAt(12);
        char c13 = str.charAt(13);
        char c14 = str.charAt(14);
        char c15 = str.charAt(15);
        char c16 = str.charAt(16);
        char c17 = str.charAt(17);
        char c18 = str.charAt(18);
        if (c4 != '-' || c7 != '-' || c10 != ' ' || c13 != ':' || c16 != ':') {
            throw new DateTimeException("illegal input", str, 0);
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        boolean shanghai = ZoneId.SHANGHAI_ZONE_ID.equals(zoneId);
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            int OFFSET_0800_TOTAL_SECONDS = 28800;
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneId.UTC || "UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            zoneOffsetTotalSeconds = zoneId.getOffsetTotalSeconds(ldt);
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    static long parseMillis19(String str, ZoneId zoneId, DateTimeFormatPattern pattern) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (str == null || "null".equals(str)) {
            return 0L;
        }
        if (pattern.length != 19) {
            throw new UnsupportedOperationException();
        }
        if (str.length() != 19) {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        char c2 = str.charAt(2);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c5 = str.charAt(5);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        char c8 = str.charAt(8);
        char c9 = str.charAt(9);
        char c10 = str.charAt(10);
        char c11 = str.charAt(11);
        char c12 = str.charAt(12);
        char c13 = str.charAt(13);
        char c14 = str.charAt(14);
        char c15 = str.charAt(15);
        char c16 = str.charAt(16);
        char c17 = str.charAt(17);
        char c18 = str.charAt(18);
        switch (pattern) {
            case DATE_TIME_FORMAT_19_DASH: {
                if (c4 != '-' || c7 != '-' || c10 != ' ' || c13 != ':' || c16 != ':') {
                    throw new DateTimeException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            case DATE_TIME_FORMAT_19_DASH_T: {
                if (c4 != '-' || c7 != '-' || c10 != 'T' || c13 != ':' || c16 != ':') {
                    throw new DateTimeException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            case DATE_TIME_FORMAT_19_SLASH: {
                if (c4 != '/' || c7 != '/' || c10 != ' ' || c13 != ':' || c16 != ':') {
                    throw new DateTimeException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            case DATE_TIME_FORMAT_19_DOT: {
                if (c2 != '.' || c5 != '.' || c10 != ' ' || c13 != ':' || c16 != ':') {
                    throw new DateTimeException("illegal input", str, 0);
                }
                d0 = c0;
                d1 = c1;
                m0 = c3;
                m1 = c4;
                y0 = c6;
                y1 = c7;
                y2 = c8;
                y3 = c9;
                h0 = c11;
                h1 = c12;
                i0 = c14;
                i1 = c15;
                s0 = c17;
                s1 = c18;
                break;
            }
            default: {
                throw new DateTimeException("illegal input", str, 0);
            }
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        boolean shanghai = ZoneId.SHANGHAI_ZONE_ID.equals(zoneId);
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            int OFFSET_0800_TOTAL_SECONDS = 28800;
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneId.UTC || "UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            zoneOffsetTotalSeconds = zoneId.getOffsetTotalSeconds(ldt);
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    static long parseMillis8(String str, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        if (str == null || "null".equals(str)) {
            return 0L;
        }
        if (str.length() != 8) {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        char c2 = str.charAt(2);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c5 = str.charAt(5);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c4;
        char m1 = c5;
        char d0 = c6;
        char d1 = c7;
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L;
        boolean shanghai = zoneId.equals(ZoneId.SHANGHAI_ZONE_ID);
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            int OFFSET_0800_TOTAL_SECONDS = 28800;
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneId.UTC || "UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalDateTime ldt = LocalDateTime.of(localDate, LocalTime.MIN);
            zoneOffsetTotalSeconds = zoneId.getOffsetTotalSeconds(ldt);
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    static long parseMillis10(String str, ZoneId zoneId, DateTimeFormatPattern pattern) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (str == null || "null".equals(str)) {
            return 0L;
        }
        if (pattern.length != 10) {
            throw new UnsupportedOperationException();
        }
        if (str.length() != 10) {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(1);
        char c2 = str.charAt(2);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c5 = str.charAt(5);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        char c8 = str.charAt(8);
        char c9 = str.charAt(9);
        switch (pattern) {
            case DATE_FORMAT_10_DASH: {
                if (c4 != '-' || c7 != '-') {
                    throw new DateTimeException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                break;
            }
            case DATE_FORMAT_10_SLASH: {
                if (c4 != '/' || c7 != '/') {
                    throw new DateTimeException("illegal input", str, 0);
                }
                y0 = c0;
                y1 = c1;
                y2 = c2;
                y3 = c3;
                m0 = c5;
                m1 = c6;
                d0 = c8;
                d1 = c9;
                break;
            }
            default: {
                throw new DateTimeException("illegal input", str, 0);
            }
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            throw new DateTimeException("illegal input", str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeException("illegal input", str, 0);
            }
        } else {
            throw new DateTimeException("illegal input", str, 0);
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L;
        boolean shanghai = zoneId.equals(ZoneId.SHANGHAI_ZONE_ID);
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            int OFFSET_0800_TOTAL_SECONDS = 28800;
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneId.UTC || "UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalDateTime ldt = LocalDateTime.of(localDate, LocalTime.MIN);
            zoneOffsetTotalSeconds = zoneId.getOffsetTotalSeconds(ldt);
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    public static long parseMillis19(String str, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        int month2;
        char s1;
        int s0;
        char i1;
        int i0;
        char h1;
        int h0;
        int d1;
        int d0;
        char m1;
        char m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (str == null) {
            throw new NullPointerException();
        }
        if (str.length() != 19) {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int c0 = str.charAt(0);
        int c1 = str.charAt(1);
        char c = str.charAt(2);
        char c3 = str.charAt(3);
        char c4 = str.charAt(4);
        char c2 = str.charAt(5);
        char c6 = str.charAt(6);
        char c7 = str.charAt(7);
        int c8 = str.charAt(8);
        int c9 = str.charAt(9);
        char c10 = str.charAt(10);
        int c11 = str.charAt(11);
        char c12 = str.charAt(12);
        char c13 = str.charAt(13);
        int c14 = str.charAt(14);
        char c15 = str.charAt(15);
        char c16 = str.charAt(16);
        int c17 = str.charAt(17);
        char c18 = str.charAt(18);
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c;
            y3 = c3;
            m0 = c2;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c;
            y3 = c3;
            m0 = c2;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == '/' && c2 == '/' && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == '.' && c2 == '.' && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == 32 && c2 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = 48;
            d1 = c0;
            int month22 = DateUtils.month(c, c3, c4);
            if (month22 <= 0) {
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month22 / 10);
            m1 = (char)(48 + month22 % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == ' ' && c11 == 32 && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c2);
            if (month2 <= 0) {
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c2);
            if (month2 <= 0) {
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c17 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c2);
            if (month2 <= 0) {
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = c18;
        } else {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                throw new DateTimeException("illegal input " + str, str, 0);
            }
        } else {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (d0 >= 48 && d0 <= 57 && d1 >= 48 && d1 <= 57) {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                throw new DateTimeException("illegal input " + str, str, 0);
            }
        } else {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (h0 < 48 || h0 > 57 || h1 < '0' || h1 > '9') {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        boolean shanghai = ZoneId.SHANGHAI_ZONE_ID.equals(zoneId);
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            int OFFSET_0800_TOTAL_SECONDS = 28800;
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneId.UTC || "UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            zoneOffsetTotalSeconds = zoneId.getOffsetTotalSeconds(ldt);
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    public static long parseMillis19(byte[] bytes, int off, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        int month2;
        char s1;
        int s0;
        char i1;
        int i0;
        char h1;
        int h0;
        int d1;
        int d0;
        char m1;
        char m0;
        int y3;
        int y2;
        int y1;
        int y0;
        if (bytes == null) {
            throw new NullPointerException();
        }
        int c0 = bytes[off + 0];
        int c1 = bytes[off + 1];
        char c = bytes[off + 2];
        char c3 = (char)bytes[off + 3];
        char c4 = (char)bytes[off + 4];
        char c2 = bytes[off + 5];
        char c6 = (char)bytes[off + 6];
        char c7 = (char)bytes[off + 7];
        int c8 = bytes[off + 8];
        int c9 = bytes[off + 9];
        char c10 = (char)bytes[off + 10];
        int c11 = bytes[off + 11];
        char c12 = (char)bytes[off + 12];
        char c13 = (char)bytes[off + 13];
        int c14 = bytes[off + 14];
        char c15 = (char)bytes[off + 15];
        char c16 = (char)bytes[off + 16];
        int c17 = bytes[off + 17];
        char c18 = (char)bytes[off + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c;
            y3 = c3;
            m0 = c2;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c;
            y3 = c3;
            m0 = c2;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == '/' && c2 == '/' && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == '.' && c2 == '.' && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == 32 && c2 == ' ' && c10 == ' ' && c13 == ':' && c16 == ':') {
            d0 = 48;
            d1 = c0;
            int month22 = DateUtils.month(c, c3, c4);
            if (month22 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month22 / 10);
            m1 = (char)(48 + month22 % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == ' ' && c11 == 32 && c13 == ':' && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c2);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c16 == ':') {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c2);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c17 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c2);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = c18;
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (d0 >= 48 && d0 <= 57 && d1 >= 48 && d1 <= 57) {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (h0 < 48 || h0 > 57 || h1 < '0' || h1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < '0' || i1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        boolean shanghai = ZoneId.SHANGHAI_ZONE_ID.equals(zoneId);
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai && utcSeconds >= SECONDS_1991_09_15_02) {
            int OFFSET_0800_TOTAL_SECONDS = 28800;
            zoneOffsetTotalSeconds = 28800;
        } else if (zoneId == ZoneId.UTC || "UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            LocalDate localDate = LocalDate.of(year, month, dom);
            LocalTime localTime = LocalTime.of(hour, minute, second, 0);
            LocalDateTime ldt = LocalDateTime.of(localDate, localTime);
            zoneOffsetTotalSeconds = zoneId.getOffsetTotalSeconds(ldt);
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    public static long parseMillis19(char[] bytes, int off, ZoneId zoneId) {
        int zoneOffsetTotalSeconds;
        int dom;
        int month;
        int month2;
        char s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (bytes == null) {
            throw new NullPointerException();
        }
        char c0 = bytes[off];
        char c1 = bytes[off + 1];
        char c2 = bytes[off + 2];
        char c3 = bytes[off + 3];
        char c4 = bytes[off + 4];
        char c5 = bytes[off + 5];
        char c6 = bytes[off + 6];
        char c7 = bytes[off + 7];
        char c8 = bytes[off + 8];
        char c9 = bytes[off + 9];
        char c10 = bytes[off + 10];
        int c11 = bytes[off + 11];
        int c12 = bytes[off + 12];
        int c13 = bytes[off + 13];
        int c14 = bytes[off + 14];
        int c15 = bytes[off + 15];
        int c16 = bytes[off + 16];
        int c17 = bytes[off + 17];
        char c18 = bytes[off + 18];
        if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c4 == '/' && c7 == '/' && (c10 == ' ' || c10 == 'T') && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == '/' && c5 == '/' && c10 == ' ' && c13 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == '.' && c5 == '.' && c10 == ' ' && c13 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c1 == ' ' && c5 == ' ' && c10 == ' ' && c13 == 58 && c16 == 58) {
            d0 = '0';
            d1 = c0;
            month2 = DateUtils.month(c2, c3, c4);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == ' ' && c6 == ' ' && c11 == 32 && c13 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c5);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = 48;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c16 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c5);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = 48;
            i1 = c15;
            s0 = c17;
            s1 = c18;
        } else if (c2 == ' ' && c6 == ' ' && c11 == 32 && c14 == 58 && c17 == 58) {
            d0 = c0;
            d1 = c1;
            month2 = DateUtils.month(c3, c4, c5);
            if (month2 <= 0) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
            m0 = (char)(48 + month2 / 10);
            m1 = (char)(48 + month2 % 10);
            y0 = c7;
            y1 = c8;
            y2 = c9;
            y3 = c10;
            h0 = c12;
            h1 = c13;
            i0 = c15;
            i1 = c16;
            s0 = 48;
            s1 = c18;
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 >= '0' && m0 <= '9' && m1 >= '0' && m1 <= '9') {
            month = (m0 - 48) * 10 + (m1 - 48);
            if (month == 0 && year != 0 || month > 12) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (d0 >= '0' && d0 <= '9' && d1 >= '0' && d1 <= '9') {
            dom = (d0 - 48) * 10 + (d1 - 48);
            int max = 31;
            switch (month) {
                case 2: {
                    boolean leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
                    max = leapYear ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    max = 30;
                }
            }
            if (dom == 0 && year != 0 || dom > max) {
                String str = new String(bytes, off, 19);
                throw new DateTimeException("illegal input " + str, str, 0);
            }
        } else {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < '0' || s1 > '9') {
            String str = new String(bytes, off, 19);
            throw new DateTimeException("illegal input " + str, str, 0);
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        boolean shanghai = ZoneId.SHANGHAI_ZONE_ID.equals(zoneId);
        long SECONDS_1991_09_15_02 = 684900000L;
        if (shanghai) {
            zoneOffsetTotalSeconds = utcSeconds >= SECONDS_1991_09_15_02 ? 28800 : DateUtils.getShanghaiZoneOffsetTotalSeconds(utcSeconds);
        } else if ("UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            Calendar calendar = Calendar.getInstance(zoneId.timeZone);
            calendar.set(year, month - 1, dom, hour, minute, second);
            calendar.set(14, 0);
            return calendar.getTimeInMillis();
        }
        return (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
    }

    public static LocalDateTime localDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (year == 0 && month == 0 && dom == 0 && hour == 0 && minute == 0 && second == 0) {
            return null;
        }
        if (hour > 24 || minute > 60 || second > 60) {
            return null;
        }
        return LocalDateTime.of(year, month, dom, hour, minute, second, 0);
    }

    public static LocalDateTime localDateTime(char y0, char y1, char y2, char y3, char m0, char m1, char d0, char d1, char h0, char h1, char i0, char i1, char s0, char s1, char S0, char S1, char S2, char S3, char S4, char S5, char S6, char S7, char S8) {
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < '0' || m0 > '9' || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < '0' || d0 > '9' || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 < '0' || S0 > '9' || S1 < '0' || S1 > '9' || S2 < '0' || S2 > '9' || S3 < '0' || S3 > '9' || S4 < '0' || S4 > '9' || S5 < '0' || S5 > '9' || S6 < '0' || S6 > '9' || S7 < '0' || S7 > '9' || S8 < '0' || S8 > '9') {
            return null;
        }
        int nanos = (S0 - 48) * 100000000 + (S1 - 48) * 10000000 + (S2 - 48) * 1000000 + (S3 - 48) * 100000 + (S4 - 48) * 10000 + (S5 - 48) * 1000 + (S6 - 48) * 100 + (S7 - 48) * 10 + (S8 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, nanos);
        return ldt;
    }

    public static long millis(LocalDateTime ldt) {
        return DateUtils.millis(null, ldt.date.year, ldt.date.monthValue, ldt.date.dayOfMonth, ldt.time.hour, ldt.time.minute, ldt.time.second, ldt.time.nano);
    }

    public static long millis(LocalDateTime ldt, ZoneId zoneId) {
        return DateUtils.millis(zoneId, ldt.date.year, ldt.date.monthValue, ldt.date.dayOfMonth, ldt.time.hour, ldt.time.minute, ldt.time.second, ldt.time.nano);
    }

    public static long millis(ZoneId zoneId, int year, int month, int dom, int hour, int minute, int second, int nanoOfSecond) {
        int zoneOffsetTotalSeconds;
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        long utcSeconds = epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
        boolean shanghai = ZoneId.SHANGHAI_ZONE_ID.equals(zoneId);
        if (shanghai) {
            long SECONDS_1991_09_15_02 = 684900000L;
            if (utcSeconds >= SECONDS_1991_09_15_02) {
                int OFFSET_0800_TOTAL_SECONDS = 28800;
                zoneOffsetTotalSeconds = 28800;
            } else {
                zoneOffsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(utcSeconds);
            }
        } else if (zoneId == ZoneId.UTC || "UTC".equals(zoneId.id)) {
            zoneOffsetTotalSeconds = 0;
        } else {
            Calendar calendar = Calendar.getInstance(zoneId.timeZone);
            calendar.set(year, month - 1, dom, hour, minute, second);
            calendar.set(14, nanoOfSecond / 1000000);
            return calendar.getTimeInMillis();
        }
        long millis = (utcSeconds - (long)zoneOffsetTotalSeconds) * 1000L;
        if (nanoOfSecond != 0) {
            millis += (long)(nanoOfSecond / 1000000);
        }
        return millis;
    }

    public static long utcSeconds(int year, int month, int dom, int hour, int minute, int second) {
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long total = 365 * year + ((year + 3) / 4 - (year + 99) / 100 + (year + 399) / 400) + (367 * month - 362) / 12 + (dom - 1);
        if (month > 2) {
            boolean leapYear;
            --total;
            boolean bl = leapYear = (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
            if (!leapYear) {
                --total;
            }
        }
        long epochDay = total - 719528L;
        return epochDay * 86400L + (long)(hour * 3600) + (long)(minute * 60) + (long)second;
    }

    public static String formatYMDHMS19(Date date, ZoneId zoneId) {
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        if (date == null) {
            return null;
        }
        long timeMillis = date.getTime();
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        int SECONDS_PER_DAY = 86400;
        long epochSecond = IOUtils.floorDiv(timeMillis, 1000L);
        long SECONDS_1991_09_15_02 = 684900000L;
        boolean shanghai = ZoneId.SHANGHAI_ZONE_ID.equals(zoneId);
        if (shanghai && epochSecond > 684900000L) {
            int OFFSET_0800_TOTAL_SECONDS = 28800;
            offsetTotalSeconds = 28800;
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getOffsetTotalSeconds(instant);
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = IOUtils.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)IOUtils.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new JSONException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new JSONException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        int h0 = hour / 10 + 48;
        int h1 = hour % 10 + 48;
        int i0 = minute / 10 + 48;
        int i1 = minute % 10 + 48;
        int s0 = second / 10 + 48;
        int s1 = second % 10 + 48;
        byte[] bytes = new byte[]{(byte)y0, (byte)y1, (byte)y2, (byte)y3, 45, (byte)m0, (byte)m1, 45, (byte)d0, (byte)d1, 32, (byte)h0, (byte)h1, 58, (byte)i0, (byte)i1, 58, (byte)s0, (byte)s1};
        return new String(bytes, 0, bytes.length, IOUtils.ISO_8859_1);
    }

    public static String formatHMS6(LocalTime time) {
        if (time == null) {
            return null;
        }
        byte[] bytes = new byte[6];
        int v = IOUtils.DIGITS_K[time.hour];
        bytes[0] = (byte)(v >> 8);
        bytes[1] = (byte)v;
        int v1 = IOUtils.DIGITS_K[time.minute];
        bytes[2] = (byte)(v1 >> 8);
        bytes[3] = (byte)v1;
        int v2 = IOUtils.DIGITS_K[time.second];
        bytes[4] = (byte)(v2 >> 8);
        bytes[5] = (byte)v2;
        return new String(bytes, IOUtils.ISO_8859_1);
    }

    public static String formatHMS8(LocalTime time) {
        if (time == null) {
            return null;
        }
        byte[] bytes = new byte[8];
        int v = IOUtils.DIGITS_K[time.hour];
        bytes[0] = (byte)(v >> 8);
        bytes[1] = (byte)v;
        bytes[2] = 58;
        int v1 = IOUtils.DIGITS_K[time.minute];
        bytes[3] = (byte)(v1 >> 8);
        bytes[4] = (byte)v1;
        bytes[5] = 58;
        int v2 = IOUtils.DIGITS_K[time.second];
        bytes[6] = (byte)(v2 >> 8);
        bytes[7] = (byte)v2;
        return new String(bytes, IOUtils.ISO_8859_1);
    }

    public static String formatYMD8(long timeMillis, ZoneId zoneId) {
        long yearEst;
        long doyEst;
        String str;
        int offsetTotalSeconds;
        int SECONDS_PER_DAY = 86400;
        long epochSecond = IOUtils.floorDiv(timeMillis, 1000L);
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        if (ZoneId.SHANGHAI_ZONE_ID.equals(zoneId)) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getOffsetTotalSeconds(instant);
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = IOUtils.floorDiv(localSecond, 86400L);
        int off = (int)(localEpochDay - (long)LOCAL_EPOCH_DAY + 128L);
        String[] cache = CacheDate8.CACHE;
        if (off >= 0 && off < cache.length && (str = cache[off]) != null) {
            return str;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        String str2 = DateUtils.formatYMD8(year, month, dayOfMonth);
        if (off >= 0 && off < cache.length) {
            cache[off] = str2;
        }
        return str2;
    }

    public static String formatYMD8(int year, int month, int dayOfMonth) {
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        byte[] bytes = new byte[]{(byte)y0, (byte)y1, (byte)y2, (byte)y3, (byte)m0, (byte)m1, (byte)d0, (byte)d1};
        return new String(bytes, 0, bytes.length, IOUtils.ISO_8859_1);
    }

    public static String formatYMD9(int year, int month, int dayOfMonth) {
        int off;
        byte[] bytes = new byte[10];
        int q = year / 1000;
        int v = IOUtils.DIGITS_K[year - q * 1000];
        bytes[0] = (byte)(q + 48);
        bytes[1] = (byte)(v >> 16);
        bytes[2] = (byte)(v >> 8);
        bytes[3] = (byte)v;
        bytes[4] = 45;
        if (month < 10) {
            bytes[5] = (byte)(month + 48);
            bytes[6] = 45;
            off = 7;
        } else {
            v = IOUtils.DIGITS_K[month];
            bytes[5] = (byte)(v >> 8);
            bytes[6] = (byte)v;
            bytes[7] = 45;
            off = 8;
        }
        v = IOUtils.DIGITS_K[dayOfMonth];
        bytes[off] = (byte)(v >> 8);
        bytes[off + 1] = (byte)v;
        return new String(bytes, 0, off + 2, IOUtils.ISO_8859_1);
    }

    public static String formatYMD10(LocalDate date) {
        if (date == null) {
            return null;
        }
        int year = date.year;
        short month = date.monthValue;
        short dayOfMonth = date.dayOfMonth;
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        int separator = 45;
        byte[] bytes = new byte[]{(byte)y0, (byte)y1, (byte)y2, (byte)y3, 45, (byte)m0, (byte)m1, 45, (byte)d0, (byte)d1};
        return new String(bytes, IOUtils.ISO_8859_1);
    }

    public static String formatYMD10(long timeMillis, ZoneId zoneId) {
        long yearEst;
        long doyEst;
        String str;
        int offsetTotalSeconds;
        if (zoneId == null) {
            zoneId = ZoneId.DEFAULT_ZONE_ID;
        }
        int SECONDS_PER_DAY = 86400;
        long epochSecond = IOUtils.floorDiv(timeMillis, 1000L);
        if (ZoneId.SHANGHAI_ZONE_ID.equals(zoneId)) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getOffsetTotalSeconds(instant);
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = IOUtils.floorDiv(localSecond, 86400L);
        int off = (int)(localEpochDay - (long)LOCAL_EPOCH_DAY + 128L);
        String[] cache = CacheDate10.CACHE;
        if (off >= 0 && off < cache.length && (str = cache[off]) != null) {
            return str;
        }
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        byte[] bytes = new byte[]{(byte)y0, (byte)y1, (byte)y2, (byte)y3, 45, (byte)m0, (byte)m1, 45, (byte)d0, (byte)d1};
        String str2 = new String(bytes, IOUtils.ISO_8859_1);
        if (off >= 0 && off < cache.length) {
            cache[off] = str2;
        }
        return str2;
    }

    public static String formatYMD11(int year, int month, int dayOfMonth) {
        int m2;
        int m1;
        int m0;
        byte[] bytes = new byte[11];
        int q = year / 1000;
        int v = IOUtils.DIGITS_K[year - q * 1000];
        bytes[0] = (byte)(q + 48);
        bytes[1] = (byte)(v >> 16);
        bytes[2] = (byte)(v >> 8);
        bytes[3] = (byte)v;
        bytes[4] = 45;
        switch (month) {
            case 1: {
                m0 = 74;
                m1 = 97;
                m2 = 110;
                break;
            }
            case 2: {
                m0 = 70;
                m1 = 101;
                m2 = 98;
                break;
            }
            case 3: {
                m0 = 77;
                m1 = 97;
                m2 = 114;
                break;
            }
            case 4: {
                m0 = 65;
                m1 = 112;
                m2 = 114;
                break;
            }
            case 5: {
                m0 = 77;
                m1 = 97;
                m2 = 121;
                break;
            }
            case 6: {
                m0 = 74;
                m1 = 117;
                m2 = 110;
                break;
            }
            case 7: {
                m0 = 74;
                m1 = 117;
                m2 = 108;
                break;
            }
            case 8: {
                m0 = 65;
                m1 = 117;
                m2 = 103;
                break;
            }
            case 9: {
                m0 = 83;
                m1 = 101;
                m2 = 112;
                break;
            }
            case 10: {
                m0 = 79;
                m1 = 99;
                m2 = 116;
                break;
            }
            case 11: {
                m0 = 78;
                m1 = 111;
                m2 = 118;
                break;
            }
            case 12: {
                m0 = 68;
                m1 = 101;
                m2 = 99;
                break;
            }
            default: {
                throw new JSONException("illegal month " + month);
            }
        }
        bytes[5] = m0;
        bytes[6] = m1;
        bytes[7] = m2;
        bytes[8] = 45;
        v = IOUtils.DIGITS_K[dayOfMonth];
        bytes[9] = (byte)(v >> 8);
        bytes[10] = (byte)v;
        return new String(bytes, IOUtils.ISO_8859_1);
    }

    public static String format(Date date, String format) {
        if (date == null) {
            return null;
        }
        if (format == null) {
            return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
        }
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "dd.MM.yyyy HH:mm:ss": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_TIME_FORMAT_19_DOT);
            }
            case "yyyyMMdd": {
                return DateUtils.formatYMD8(date.getTime(), ZoneId.DEFAULT_ZONE_ID);
            }
            case "yyyy-MM-dd": {
                return DateUtils.formatYMD10(date.getTime(), ZoneId.DEFAULT_ZONE_ID);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(date.getTime(), DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
        }
        long epochMilli = date.getTime();
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        return fmt.format(date);
    }

    public static String formatYMDHMS19(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        int year = zdt.dateTime.date.year;
        short month = zdt.dateTime.date.monthValue;
        short dayOfMonth = zdt.dateTime.date.dayOfMonth;
        byte hour = zdt.dateTime.time.hour;
        byte minute = zdt.dateTime.time.minute;
        byte second = zdt.dateTime.time.second;
        return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    public static String format(ZonedDateTime zdt, String format) {
        if (zdt == null) {
            return null;
        }
        int year = zdt.dateTime.date.year;
        short month = zdt.dateTime.date.monthValue;
        short dayOfMonth = zdt.dateTime.date.dayOfMonth;
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                byte hour = zdt.dateTime.time.hour;
                byte minute = zdt.dateTime.time.minute;
                byte second = zdt.dateTime.time.second;
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                byte hour = zdt.dateTime.time.hour;
                byte minute = zdt.dateTime.time.minute;
                byte second = zdt.dateTime.time.second;
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "yyyy-MM-dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
            case "yyyyMMdd": {
                return DateUtils.formatYMD8(year, month, dayOfMonth);
            }
            case "yyyy-MMM-dd": {
                return DateUtils.formatYMD11(year, month, dayOfMonth);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(zdt);
    }

    public static String formatYMDHMS19(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        int year = ldt.date.year;
        short month = ldt.date.monthValue;
        short dayOfMonth = ldt.date.dayOfMonth;
        byte hour = ldt.time.hour;
        byte minute = ldt.time.minute;
        byte second = ldt.time.second;
        return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    public static String formatYMDHMS29(LocalDateTime ldt) {
        if (ldt == null) {
            return null;
        }
        int year = ldt.date.year;
        short month = ldt.date.monthValue;
        short dayOfMonth = ldt.date.dayOfMonth;
        byte hour = ldt.time.hour;
        byte minute = ldt.time.minute;
        byte second = ldt.time.second;
        int nano = ldt.time.nano;
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        int h0 = hour / 10 + 48;
        int h1 = hour % 10 + 48;
        int i0 = minute / 10 + 48;
        int i1 = minute % 10 + 48;
        int s0 = second / 10 + 48;
        int s1 = second % 10 + 48;
        byte[] bytes = new byte[29];
        bytes[0] = (byte)y0;
        bytes[1] = (byte)y1;
        bytes[2] = (byte)y2;
        bytes[3] = (byte)y3;
        bytes[4] = 45;
        bytes[5] = (byte)m0;
        bytes[6] = (byte)m1;
        bytes[7] = 45;
        bytes[8] = (byte)d0;
        bytes[9] = (byte)d1;
        bytes[10] = 32;
        bytes[11] = (byte)h0;
        bytes[12] = (byte)h1;
        bytes[13] = 58;
        bytes[14] = (byte)i0;
        bytes[15] = (byte)i1;
        bytes[16] = 58;
        bytes[17] = (byte)s0;
        bytes[18] = (byte)s1;
        int div = nano / 1000;
        int div2 = div / 1000;
        int rem1 = nano - div * 1000;
        bytes[19] = 46;
        int v = IOUtils.DIGITS_K[div2];
        bytes[20] = (byte)(v >> 16);
        bytes[21] = (byte)(v >> 8);
        bytes[22] = (byte)v;
        int v1 = IOUtils.DIGITS_K[div - div2 * 1000];
        bytes[23] = (byte)(v1 >> 16);
        bytes[24] = (byte)(v1 >> 8);
        bytes[25] = (byte)v1;
        int v2 = IOUtils.DIGITS_K[rem1];
        bytes[26] = (byte)(v2 >> 16);
        bytes[27] = (byte)(v2 >> 8);
        bytes[28] = (byte)v2;
        return new String(bytes, 0, bytes.length, IOUtils.ISO_8859_1);
    }

    public static String format(LocalDateTime ldt, String format) {
        if (ldt == null) {
            return null;
        }
        int year = ldt.date.year;
        short month = ldt.date.monthValue;
        short dayOfMonth = ldt.date.dayOfMonth;
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                byte hour = ldt.time.hour;
                byte minute = ldt.time.minute;
                byte second = ldt.time.second;
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                byte hour = ldt.time.hour;
                byte minute = ldt.time.minute;
                byte second = ldt.time.second;
                return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "yyyy-MM-dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
            case "yyyy-M-dd": {
                return DateUtils.formatYMD9(year, month, dayOfMonth);
            }
            case "yyyy-MMM-dd": {
                return DateUtils.formatYMD11(year, month, dayOfMonth);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(ldt);
    }

    public static String formatYMDHMS19(LocalDate localDate) {
        if (localDate == null) {
            return null;
        }
        int year = localDate.year;
        short month = localDate.monthValue;
        short dayOfMonth = localDate.dayOfMonth;
        return DateUtils.format(year, month, dayOfMonth, 0, 0, 0, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    public static String format(LocalDate localDate, String format) {
        if (localDate == null) {
            return null;
        }
        int year = localDate.year;
        short month = localDate.monthValue;
        short dayOfMonth = localDate.dayOfMonth;
        switch (format) {
            case "yyyy-MM-dd HH:mm:ss": {
                return DateUtils.format(year, month, dayOfMonth, 0, 0, 0, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
            }
            case "yyyy-MM-ddTHH:mm:ss": 
            case "yyyy-MM-dd'T'HH:mm:ss": {
                return DateUtils.format(year, month, dayOfMonth, 0, 0, 0, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH_T);
            }
            case "yyyy-MM-dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
            }
            case "yyyy/MM/dd": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_SLASH);
            }
            case "dd.MM.yyyy": {
                return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DOT);
            }
            case "yyyyMMdd": {
                return DateUtils.formatYMD8(year, month, dayOfMonth);
            }
            case "yyyy-MMM-dd": {
                return DateUtils.formatYMD11(year, month, dayOfMonth);
            }
        }
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
        return formatter.format(localDate);
    }

    public static String format(int year, int month, int dayOfMonth) {
        return DateUtils.format(year, month, dayOfMonth, DateTimeFormatPattern.DATE_FORMAT_10_DASH);
    }

    public static String format(int year, int month, int dayOfMonth, DateTimeFormatPattern pattern) {
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        byte[] bytes = new byte[10];
        if (pattern == DateTimeFormatPattern.DATE_FORMAT_10_DOT) {
            bytes[0] = (byte)d0;
            bytes[1] = (byte)d1;
            bytes[2] = 46;
            bytes[3] = (byte)m0;
            bytes[4] = (byte)m1;
            bytes[5] = 46;
            bytes[6] = (byte)y0;
            bytes[7] = (byte)y1;
            bytes[8] = (byte)y2;
            bytes[9] = (byte)y3;
        } else {
            byte separator = (byte)(pattern == DateTimeFormatPattern.DATE_FORMAT_10_DASH ? 45 : 47);
            bytes[0] = (byte)y0;
            bytes[1] = (byte)y1;
            bytes[2] = (byte)y2;
            bytes[3] = (byte)y3;
            bytes[4] = separator;
            bytes[5] = (byte)m0;
            bytes[6] = (byte)m1;
            bytes[7] = separator;
            bytes[8] = (byte)d0;
            bytes[9] = (byte)d1;
        }
        return new String(bytes, IOUtils.ISO_8859_1);
    }

    public static String format(long timeMillis, DateTimeFormatPattern pattern) {
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        ZoneId zoneId = ZoneId.DEFAULT_ZONE_ID;
        int SECONDS_PER_DAY = 86400;
        long epochSecond = IOUtils.floorDiv(timeMillis, 1000L);
        if (ZoneId.SHANGHAI_ZONE_ID.equals(zoneId)) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getOffsetTotalSeconds(instant);
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = IOUtils.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)IOUtils.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        if (pattern == DateTimeFormatPattern.DATE_FORMAT_10_DASH || pattern == DateTimeFormatPattern.DATE_FORMAT_10_SLASH || pattern == DateTimeFormatPattern.DATE_FORMAT_10_DOT) {
            return DateUtils.format(year, month, dayOfMonth, pattern);
        }
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        return DateUtils.format(year, month, dayOfMonth, hour, minute, second, pattern);
    }

    public static String format(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        return DateUtils.format(year, month, dayOfMonth, hour, minute, second, DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH);
    }

    static String format(int year, int month, int dayOfMonth, int hour, int minute, int second, DateTimeFormatPattern pattern) {
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        int h0 = hour / 10 + 48;
        int h1 = hour % 10 + 48;
        int i0 = minute / 10 + 48;
        int i1 = minute % 10 + 48;
        int s0 = second / 10 + 48;
        int s1 = second % 10 + 48;
        byte[] bytes = new byte[19];
        if (pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_DOT) {
            bytes[0] = (byte)d0;
            bytes[1] = (byte)d1;
            bytes[2] = 46;
            bytes[3] = (byte)m0;
            bytes[4] = (byte)m1;
            bytes[5] = 46;
            bytes[6] = (byte)y0;
            bytes[7] = (byte)y1;
            bytes[8] = (byte)y2;
            bytes[9] = (byte)y3;
            bytes[10] = 32;
        } else {
            int separator = pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_DASH ? 32 : 84;
            int dateSeparator = pattern == DateTimeFormatPattern.DATE_TIME_FORMAT_19_SLASH ? 47 : 45;
            bytes[0] = (byte)y0;
            bytes[1] = (byte)y1;
            bytes[2] = (byte)y2;
            bytes[3] = (byte)y3;
            bytes[4] = (byte)dateSeparator;
            bytes[5] = (byte)m0;
            bytes[6] = (byte)m1;
            bytes[7] = (byte)dateSeparator;
            bytes[8] = (byte)d0;
            bytes[9] = (byte)d1;
            bytes[10] = (byte)separator;
        }
        bytes[11] = (byte)h0;
        bytes[12] = (byte)h1;
        bytes[13] = 58;
        bytes[14] = (byte)i0;
        bytes[15] = (byte)i1;
        bytes[16] = 58;
        bytes[17] = (byte)s0;
        bytes[18] = (byte)s1;
        return new String(bytes, IOUtils.ISO_8859_1);
    }

    public static String toString(long timeMillis, boolean timeZone, ZoneId zoneId) {
        long yearEst;
        long doyEst;
        int offsetTotalSeconds;
        int SECONDS_PER_DAY = 86400;
        long epochSecond = IOUtils.floorDiv(timeMillis, 1000L);
        if (ZoneId.SHANGHAI_ZONE_ID.equals(zoneId)) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getOffsetTotalSeconds(instant);
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = IOUtils.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)IOUtils.floorMod(localSecond, 86400L);
        int DAYS_PER_CYCLE = 146097;
        long DAYS_0000_TO_1970 = 719528L;
        long zeroDay = localEpochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dayOfMonth = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        if ((yearEst += (long)(marchMonth0 / 10)) < -999999999L || yearEst > 999999999L) {
            throw new DateTimeException("Invalid year " + yearEst);
        }
        int year = (int)yearEst;
        int MINUTES_PER_HOUR = 60;
        int SECONDS_PER_MINUTE = 60;
        int SECONDS_PER_HOUR = 3600;
        long secondOfDay = secsOfDay;
        if (secondOfDay < 0L || secondOfDay > 86399L) {
            throw new DateTimeException("Invalid secondOfDay " + secondOfDay);
        }
        int hours = (int)(secondOfDay / 3600L);
        int minutes = (int)((secondOfDay -= (long)(hours * 3600)) / 60L);
        int hour = hours;
        int minute = minutes;
        int second = (int)(secondOfDay -= (long)(minutes * 60));
        int millis = (int)IOUtils.floorMod(timeMillis, 1000L);
        int millislen = millis == 0 ? 0 : (millis < 10 ? 4 : (millis % 100 == 0 ? 2 : (millis % 10 == 0 ? 3 : 4)));
        int zonelen = timeZone ? (offsetTotalSeconds == 0 ? 1 : 6) : 0;
        int len = 19 + millislen + zonelen;
        int y0 = year / 1000 + 48;
        int y1 = year / 100 % 10 + 48;
        int y2 = year / 10 % 10 + 48;
        int y3 = year % 10 + 48;
        int m0 = month / 10 + 48;
        int m1 = month % 10 + 48;
        int d0 = dayOfMonth / 10 + 48;
        int d1 = dayOfMonth % 10 + 48;
        int h0 = hour / 10 + 48;
        int h1 = hour % 10 + 48;
        int i0 = minute / 10 + 48;
        int i1 = minute % 10 + 48;
        int s0 = second / 10 + 48;
        int s1 = second % 10 + 48;
        byte[] bytes = new byte[len];
        bytes[0] = (byte)y0;
        bytes[1] = (byte)y1;
        bytes[2] = (byte)y2;
        bytes[3] = (byte)y3;
        bytes[4] = 45;
        bytes[5] = (byte)m0;
        bytes[6] = (byte)m1;
        bytes[7] = 45;
        bytes[8] = (byte)d0;
        bytes[9] = (byte)d1;
        bytes[10] = 32;
        bytes[11] = (byte)h0;
        bytes[12] = (byte)h1;
        bytes[13] = 58;
        bytes[14] = (byte)i0;
        bytes[15] = (byte)i1;
        bytes[16] = 58;
        bytes[17] = (byte)s0;
        bytes[18] = (byte)s1;
        if (millislen > 0) {
            bytes[19] = 46;
            for (int i = 20; i < len; ++i) {
                bytes[i] = 48;
            }
            if (millis < 10) {
                IOUtils.writeInt32(bytes, 22, millis);
            } else if (millis % 100 == 0) {
                IOUtils.writeInt32(bytes, 20, millis / 100);
            } else if (millis % 10 == 0) {
                IOUtils.writeInt32(bytes, 20, millis / 10);
            } else {
                IOUtils.writeInt32(bytes, 20, millis);
            }
        }
        if (timeZone) {
            int timeZoneOffset = offsetTotalSeconds / 3600;
            if (offsetTotalSeconds == 0) {
                bytes[19 + millislen] = 90;
            } else {
                int offsetAbs = Math.abs(timeZoneOffset);
                bytes[19 + millislen] = timeZoneOffset >= 0 ? 43 : 45;
                if (offsetAbs < 10) {
                    bytes[20 + millislen] = 48;
                    bytes[21 + millislen] = (byte)(48 + offsetAbs);
                } else {
                    bytes[20 + millislen] = (byte)(48 + offsetAbs / 10);
                    bytes[21 + millislen] = (byte)(48 + offsetAbs % 10);
                }
                bytes[22 + millislen] = 58;
                int offsetMinutes = (offsetTotalSeconds - timeZoneOffset * 3600) / 60;
                if (offsetMinutes < 0) {
                    offsetMinutes = -offsetMinutes;
                }
                if (offsetMinutes < 10) {
                    bytes[23 + millislen] = 48;
                    bytes[24 + millislen] = (byte)(48 + offsetMinutes);
                } else {
                    bytes[23 + millislen] = (byte)(48 + offsetMinutes / 10);
                    bytes[24 + millislen] = (byte)(48 + offsetMinutes % 10);
                }
            }
        }
        return new String(bytes, 0, bytes.length, IOUtils.ISO_8859_1);
    }

    public static int month(char c0, char c1, char c2) {
        switch (c0) {
            case 'J': {
                if (c1 == 'a' && c2 == 'n') {
                    return 1;
                }
                if (c1 != 'u') break;
                if (c2 == 'n') {
                    return 6;
                }
                if (c2 != 'l') break;
                return 7;
            }
            case 'F': {
                if (c1 != 'e' || c2 != 'b') break;
                return 2;
            }
            case 'M': {
                if (c1 != 'a') break;
                if (c2 == 'r') {
                    return 3;
                }
                if (c2 != 'y') break;
                return 5;
            }
            case 'A': {
                if (c1 == 'p' && c2 == 'r') {
                    return 4;
                }
                if (c1 != 'u' || c2 != 'g') break;
                return 8;
            }
            case 'S': {
                if (c1 != 'e' || c2 != 'p') break;
                return 9;
            }
            case 'O': {
                if (c1 != 'c' || c2 != 't') break;
                return 10;
            }
            case 'N': {
                if (c1 != 'o' || c2 != 'v') break;
                return 11;
            }
            case 'D': {
                if (c1 != 'e' || c2 != 'c') break;
                return 12;
            }
        }
        return 0;
    }

    public static int hourAfterNoon(char h0, char h1) {
        if (h0 == '0') {
            switch (h1) {
                case '0': {
                    h0 = (char)49;
                    h1 = (char)50;
                    break;
                }
                case '1': {
                    h0 = (char)49;
                    h1 = (char)51;
                    break;
                }
                case '2': {
                    h0 = (char)49;
                    h1 = (char)52;
                    break;
                }
                case '3': {
                    h0 = (char)49;
                    h1 = (char)53;
                    break;
                }
                case '4': {
                    h0 = (char)49;
                    h1 = (char)54;
                    break;
                }
                case '5': {
                    h0 = (char)49;
                    h1 = (char)55;
                    break;
                }
                case '6': {
                    h0 = (char)49;
                    h1 = (char)56;
                    break;
                }
                case '7': {
                    h0 = (char)49;
                    h1 = (char)57;
                    break;
                }
                case '8': {
                    h0 = (char)50;
                    h1 = (char)48;
                    break;
                }
                case '9': {
                    h0 = (char)50;
                    h1 = (char)49;
                    break;
                }
            }
        } else if (h0 == '1') {
            switch (h1) {
                case '0': {
                    h0 = (char)50;
                    h1 = (char)50;
                    break;
                }
                case '1': {
                    h0 = (char)50;
                    h1 = (char)51;
                    break;
                }
                case '2': {
                    h0 = (char)50;
                    h1 = (char)52;
                    break;
                }
            }
        }
        return h0 << 16 | h1;
    }

    public static int getShanghaiZoneOffsetTotalSeconds(long seconds) {
        long SECONDS_1991_09_15_02 = 684900000L;
        long SECONDS_1991_04_14_03 = 671598000L;
        long SECONDS_1990_09_16_02 = 653450400L;
        long SECONDS_1990_04_15_03 = 640148400L;
        long SECONDS_1989_09_17_02 = 622000800L;
        long SECONDS_1989_04_16_03 = 608698800L;
        long SECONDS_1988_09_11_02 = 589946400L;
        long SECONDS_1988_04_17_03 = 577249200L;
        long SECONDS_1987_09_13_02 = 558496800L;
        long SECONDS_1987_04_12_03 = 545194800L;
        long SECONDS_1986_09_14_02 = 527047200L;
        long SECONDS_1986_05_04_03 = 515559600L;
        long SECONDS_1949_05_28_00 = -649987200L;
        long SECONDS_1949_05_01_01 = -652316400L;
        long SECONDS_1948_10_01_00 = -670636800L;
        long SECONDS_1948_05_01_01 = -683852400L;
        long SECONDS_1947_11_01_00 = -699580800L;
        long SECONDS_1947_04_15_01 = -716857200L;
        long SECONDS_1946_10_01_00 = -733795200L;
        long SECONDS_1946_05_15_01 = -745801200L;
        long SECONDS_1945_09_02_00 = -767836800L;
        long SECONDS_1942_01_31_01 = -881017200L;
        long SECONDS_1941_11_02_00 = -888796800L;
        long SECONDS_1941_03_15_01 = -908838000L;
        long SECONDS_1940_10_13_00 = -922060800L;
        long SECONDS_1940_06_01_01 = -933634800L;
        long SECONDS_1919_10_01_00 = -1585872000L;
        long SECONDS_1919_04_13_01 = -1600642800L;
        long SECONDS_1901_01_01_00 = -2177452800L;
        int OFFSET_0900_TOTAL_SECONDS = 32400;
        int OFFSET_0800_TOTAL_SECONDS = 28800;
        int OFFSET_0543_TOTAL_SECONDS = 29143;
        int zoneOffsetTotalSeconds = seconds >= SECONDS_1991_09_15_02 ? 28800 : (seconds >= SECONDS_1991_04_14_03 ? 32400 : (seconds >= SECONDS_1990_09_16_02 ? 28800 : (seconds >= SECONDS_1990_04_15_03 ? 32400 : (seconds >= SECONDS_1989_09_17_02 ? 28800 : (seconds >= SECONDS_1989_04_16_03 ? 32400 : (seconds >= SECONDS_1988_09_11_02 ? 28800 : (seconds >= SECONDS_1988_04_17_03 ? 32400 : (seconds >= SECONDS_1987_09_13_02 ? 28800 : (seconds >= SECONDS_1987_04_12_03 ? 32400 : (seconds >= SECONDS_1986_09_14_02 ? 28800 : (seconds >= SECONDS_1986_05_04_03 ? 32400 : (seconds >= SECONDS_1949_05_28_00 ? 28800 : (seconds >= SECONDS_1949_05_01_01 ? 32400 : (seconds >= SECONDS_1948_10_01_00 ? 28800 : (seconds >= SECONDS_1948_05_01_01 ? 32400 : (seconds >= SECONDS_1947_11_01_00 ? 28800 : (seconds >= SECONDS_1947_04_15_01 ? 32400 : (seconds >= SECONDS_1946_10_01_00 ? 28800 : (seconds >= SECONDS_1946_05_15_01 ? 32400 : (seconds >= SECONDS_1945_09_02_00 ? 28800 : (seconds >= SECONDS_1942_01_31_01 ? 32400 : (seconds >= SECONDS_1941_11_02_00 ? 28800 : (seconds >= SECONDS_1941_03_15_01 ? 32400 : (seconds >= SECONDS_1940_10_13_00 ? 28800 : (seconds >= SECONDS_1940_06_01_01 ? 32400 : (seconds >= SECONDS_1919_10_01_00 ? 28800 : (seconds >= SECONDS_1919_04_13_01 ? 32400 : (seconds >= SECONDS_1901_01_01_00 ? 28800 : 29143))))))))))))))))))))))))))));
        return zoneOffsetTotalSeconds;
    }

    static {
        int offsetTotalSeconds;
        long timeMillis = System.currentTimeMillis();
        ZoneId zoneId = ZoneId.DEFAULT_ZONE_ID;
        int SECONDS_PER_DAY = 86400;
        long epochSecond = IOUtils.floorDiv(timeMillis, 1000L);
        if (zoneId.equals(ZoneId.SHANGHAI_ZONE_ID)) {
            offsetTotalSeconds = DateUtils.getShanghaiZoneOffsetTotalSeconds(epochSecond);
        } else {
            Instant instant = Instant.ofEpochMilli(timeMillis);
            offsetTotalSeconds = zoneId.getOffsetTotalSeconds(instant);
        }
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        LOCAL_EPOCH_DAY = (int)IOUtils.floorDiv(localSecond, 86400L);
    }

    public static enum DateTimeFormatPattern {
        DATE_FORMAT_10_DASH("yyyy-MM-dd", 10),
        DATE_FORMAT_10_SLASH("yyyy/MM/dd", 10),
        DATE_FORMAT_10_DOT("dd.MM.yyyy", 10),
        DATE_TIME_FORMAT_19_DASH("yyyy-MM-dd HH:mm:ss", 19),
        DATE_TIME_FORMAT_19_DASH_T("yyyy-MM-dd'T'HH:mm:ss", 19),
        DATE_TIME_FORMAT_19_SLASH("yyyy/MM/dd HH:mm:ss", 19),
        DATE_TIME_FORMAT_19_DOT("dd.MM.yyyy HH:mm:ss", 19);

        public final String pattern;
        public final int length;

        private DateTimeFormatPattern(String pattern, int length) {
            this.pattern = pattern;
            this.length = length;
        }
    }

    static class CacheDate8 {
        static final String[] CACHE = new String[1024];

        CacheDate8() {
        }
    }

    static class CacheDate10 {
        static final String[] CACHE = new String[1024];

        CacheDate10() {
        }
    }
}

