/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterArrayFinal;
import com.alibaba.fastjson2.writer.ObjectWriterImplCurrency;
import com.alibaba.fastjson2.writer.ObjectWriterImplDoubleValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloatValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterModule;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

public class FieldWriterObject<T>
extends FieldWriter<T> {
    volatile Class initValueClass;
    final boolean unwrapped;
    final boolean array;
    final boolean number;
    static final AtomicReferenceFieldUpdater<FieldWriterObject, Class> initValueClassUpdater = AtomicReferenceFieldUpdater.newUpdater(FieldWriterObject.class, Class.class, "initValueClass");

    protected FieldWriterObject(String name, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass, Field field, Method method) {
        super(name, ordinal, features, format, label, fieldType, fieldClass, field, method);
        boolean bl = this.unwrapped = (features & 0x2000000000000L) != 0L;
        if (fieldClass == Currency.class) {
            this.initValueClass = fieldClass;
            this.initObjectWriter = ObjectWriterImplCurrency.INSTANCE_FOR_FIELD;
        }
        this.array = fieldClass.isArray() || Collection.class.isAssignableFrom(fieldClass) || fieldClass == AtomicLongArray.class || fieldClass == AtomicIntegerArray.class;
        this.number = Number.class.isAssignableFrom(fieldClass);
    }

    @Override
    public ObjectWriter getInitWriter() {
        return this.initObjectWriter;
    }

    @Override
    public boolean unwrapped() {
        return this.unwrapped;
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        boolean typeMatch;
        Class initValueClass = this.initValueClass;
        if (initValueClass == null || this.initObjectWriter == ObjectWriterModule.VoidObjectWriter.INSTANCE) {
            return this.getObjectWriterVoid(jsonWriter, valueClass);
        }
        boolean bl = typeMatch = initValueClass == valueClass || initValueClass == Map.class && initValueClass.isAssignableFrom(valueClass);
        if (!typeMatch && initValueClass.isPrimitive()) {
            typeMatch = FieldWriterObject.typeMatch(initValueClass, valueClass);
        }
        if (typeMatch) {
            ObjectWriter objectWriter = this.initObjectWriter == null ? this.getObjectWriterTypeMatch(jsonWriter, valueClass) : this.initObjectWriter;
            return objectWriter;
        }
        return this.getObjectWriterTypeNotMatch(jsonWriter, valueClass);
    }

    private ObjectWriter getObjectWriterVoid(JSONWriter jsonWriter, Class valueClass) {
        boolean success;
        ObjectWriter formattedWriter = null;
        if (this.format == null) {
            JSONWriter.Context context = jsonWriter.context;
            boolean fieldBased = ((this.features | context.getFeatures()) & JSONWriter.Feature.FieldBased.mask) != 0L;
            formattedWriter = context.provider.getObjectWriterFromCache(valueClass, valueClass, fieldBased);
        }
        DecimalFormat decimalFormat = this.decimalFormat;
        if (valueClass == Float[].class) {
            formattedWriter = decimalFormat != null ? new ObjectWriterArrayFinal(Float.class, decimalFormat) : ObjectWriterArrayFinal.FLOAT_ARRAY;
        } else if (valueClass == Double[].class) {
            formattedWriter = decimalFormat != null ? new ObjectWriterArrayFinal(Double.class, decimalFormat) : ObjectWriterArrayFinal.DOUBLE_ARRAY;
        } else if (valueClass == float[].class) {
            formattedWriter = decimalFormat != null ? new ObjectWriterImplFloatValueArray(decimalFormat) : ObjectWriterImplFloatValueArray.INSTANCE;
        } else if (valueClass == double[].class) {
            formattedWriter = decimalFormat != null ? new ObjectWriterImplDoubleValueArray(decimalFormat) : ObjectWriterImplDoubleValueArray.INSTANCE;
        }
        if (formattedWriter == null) {
            formattedWriter = FieldWriter.getObjectWriter(this.fieldType, this.fieldClass, this.format, null, valueClass);
        }
        if (formattedWriter == null) {
            success = initValueClassUpdater.compareAndSet(this, null, valueClass);
            formattedWriter = jsonWriter.getObjectWriter(valueClass);
            if (success) {
                initObjectWriterUpdater.compareAndSet(this, null, formattedWriter);
            }
        } else if (this.initObjectWriter == null && (success = initValueClassUpdater.compareAndSet(this, null, valueClass))) {
            initObjectWriterUpdater.compareAndSet(this, null, formattedWriter);
        }
        return formattedWriter;
    }

    static boolean typeMatch(Class initValueClass, Class valueClass) {
        return initValueClass == Integer.TYPE && valueClass == Integer.class || initValueClass == Long.TYPE && valueClass == Long.class || initValueClass == Boolean.TYPE && valueClass == Boolean.class || initValueClass == Short.TYPE && valueClass == Short.class || initValueClass == Byte.TYPE && valueClass == Byte.class || initValueClass == Float.TYPE && valueClass == Float.class || initValueClass == Double.TYPE && valueClass == Double.class || initValueClass == Character.TYPE && valueClass == Character.class;
    }

    private ObjectWriter getObjectWriterTypeNotMatch(JSONWriter jsonWriter, Class valueClass) {
        if (Map.class.isAssignableFrom(valueClass)) {
            if (this.fieldClass.isAssignableFrom(valueClass)) {
                return ObjectWriterImplMap.of(this.fieldType, valueClass);
            }
            return ObjectWriterImplMap.of(valueClass);
        }
        ObjectWriter objectWriter = null;
        if (this.format != null) {
            objectWriter = FieldWriter.getObjectWriter(this.fieldType, this.fieldClass, this.format, null, valueClass);
        }
        if (objectWriter == null) {
            objectWriter = jsonWriter.getObjectWriter(valueClass);
        }
        return objectWriter;
    }

    private ObjectWriter getObjectWriterTypeMatch(JSONWriter jsonWriter, Class valueClass) {
        ObjectWriter objectWriter = Map.class.isAssignableFrom(valueClass) ? (this.fieldClass.isAssignableFrom(valueClass) ? ObjectWriterImplMap.of(this.fieldType, valueClass) : ObjectWriterImplMap.of(valueClass)) : jsonWriter.getObjectWriter(valueClass);
        initObjectWriterUpdater.compareAndSet(this, null, objectWriter);
        return objectWriter;
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Class<?> valueClass;
        Object value;
        long features = this.features | jsonWriter.getFeatures();
        if (!this.fieldClassSerializable && (features & JSONWriter.Feature.IgnoreNoneSerializable.mask) != 0L) {
            return false;
        }
        try {
            value = this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            if ((features & JSONWriter.Feature.WriteNulls.mask) != 0L && (features & JSONWriter.Feature.NotWriteDefaultValue.mask) == 0L) {
                this.writeFieldName(jsonWriter);
                if (this.array) {
                    jsonWriter.writeArrayNull();
                } else if (this.number) {
                    jsonWriter.writeNumberNull();
                } else if (this.fieldClass == Appendable.class || this.fieldClass == StringBuffer.class || this.fieldClass == StringBuilder.class) {
                    jsonWriter.writeStringNull();
                } else {
                    jsonWriter.writeNull();
                }
                return true;
            }
            if ((features & (JSONWriter.Feature.WriteNullNumberAsZero.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L && this.number) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeInt32(0);
                return true;
            }
            if ((features & (JSONWriter.Feature.WriteNullBooleanAsFalse.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L && (this.fieldClass == Boolean.class || this.fieldClass == AtomicBoolean.class)) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeBool(false);
                return true;
            }
            return false;
        }
        if (value == object && this.fieldClass == Throwable.class && this.field != null && this.field.getDeclaringClass() == Throwable.class) {
            return false;
        }
        if ((features & JSONWriter.Feature.IgnoreNoneSerializable.mask) != 0L && !(value instanceof Serializable)) {
            return false;
        }
        boolean refDetect = jsonWriter.isRefDetect(value);
        if (refDetect) {
            if (value == object) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeReference("..");
                return true;
            }
            String refPath = jsonWriter.setPath(this, value);
            if (refPath != null) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(value);
                return true;
            }
        }
        if ((valueClass = value.getClass()) == byte[].class) {
            this.writeBinary(jsonWriter, (byte[])value);
            return true;
        }
        ObjectWriter valueWriter = this.getObjectWriter(jsonWriter, valueClass);
        if (valueWriter == null) {
            throw new JSONException("get objectWriter error : " + valueClass);
        }
        if (this.unwrapped) {
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    String entryKey = entry.getKey().toString();
                    Object entryValue = entry.getValue();
                    if (entryValue == null && (features & JSONWriter.Feature.WriteNulls.mask) == 0L) continue;
                    jsonWriter.writeName(entryKey);
                    jsonWriter.writeColon();
                    if (entryValue == null) {
                        jsonWriter.writeNull();
                        continue;
                    }
                    Class<?> entryValueClass = entryValue.getClass();
                    ObjectWriter entryValueWriter = jsonWriter.getObjectWriter(entryValueClass);
                    entryValueWriter.write(jsonWriter, entryValue);
                }
                if (refDetect) {
                    jsonWriter.popPath(value);
                }
                return true;
            }
            if (valueWriter instanceof ObjectWriterAdapter) {
                ObjectWriterAdapter writerAdapter = (ObjectWriterAdapter)valueWriter;
                List<FieldWriter> fieldWriters = writerAdapter.fieldWriters;
                for (FieldWriter fieldWriter : fieldWriters) {
                    fieldWriter.write(jsonWriter, value);
                }
                return true;
            }
        }
        this.writeFieldName(jsonWriter);
        boolean jsonb = jsonWriter.jsonb;
        if ((this.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
            if (jsonb) {
                valueWriter.writeArrayMappingJSONB(jsonWriter, value, this.fieldName, this.fieldType, this.features);
            } else {
                valueWriter.writeArrayMapping(jsonWriter, value, this.fieldName, this.fieldType, this.features);
            }
        } else if (jsonb) {
            valueWriter.writeJSONB(jsonWriter, value, this.fieldName, this.fieldType, this.features);
        } else {
            valueWriter.write(jsonWriter, value, this.fieldName, this.fieldType, this.features);
        }
        if (refDetect) {
            jsonWriter.popPath(value);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        boolean refDetect;
        ObjectWriter valueWriter;
        Object value = this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        Class<?> valueClass = value.getClass();
        if (this.initValueClass == null) {
            this.initValueClass = valueClass;
            valueWriter = this.getObjectWriter(jsonWriter, valueClass);
            initObjectWriterUpdater.compareAndSet(this, null, valueWriter);
        } else {
            valueWriter = this.initValueClass == valueClass ? this.initObjectWriter : jsonWriter.getObjectWriter(valueClass);
        }
        if (valueWriter == null) {
            throw new JSONException("get value writer error, valueType : " + valueClass);
        }
        boolean bl = refDetect = jsonWriter.isRefDetect() && !ObjectWriterProvider.isNotReferenceDetect(valueClass);
        if (refDetect) {
            if (value == object) {
                jsonWriter.writeReference("..");
                return;
            }
            String refPath = jsonWriter.setPath(this.fieldName, value);
            if (refPath != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(value);
                return;
            }
        }
        if (jsonWriter.jsonb) {
            if (jsonWriter.isBeanToArray()) {
                valueWriter.writeArrayMappingJSONB(jsonWriter, value, this.fieldName, this.fieldClass, this.features);
            } else {
                valueWriter.writeJSONB(jsonWriter, value, this.fieldName, this.fieldClass, this.features);
            }
        } else {
            valueWriter.write(jsonWriter, value, this.fieldName, this.fieldClass, this.features);
        }
        if (refDetect) {
            jsonWriter.popPath(value);
        }
    }
}

