/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Type;

final class FieldWriterStringFunc<T>
extends FieldWriter<T> {
    final Function<T, String> function;
    final boolean symbol;
    final boolean trim;
    final boolean raw;

    protected FieldWriterStringFunc(String fieldName, int ordinal, long features, String format, String label, Method method, Function<T, String> function) {
        super(fieldName, ordinal, features, format, label, (Type)((Object)String.class), String.class, null, method);
        this.function = function;
        this.symbol = "symbol".equals(format);
        this.trim = "trim".equals(format);
        this.raw = (features & 0x4000000000000L) != 0L;
    }

    @Override
    public Object getFieldValue(T object) {
        return this.function.apply(object);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        long features;
        String value;
        try {
            value = this.function.apply(object);
        }
        catch (RuntimeException error) {
            if ((jsonWriter.getFeatures(this.features) | JSONWriter.Feature.IgnoreNonFieldGetter.mask) != 0L) {
                return false;
            }
            throw error;
        }
        if (value == null && ((features = this.features | jsonWriter.getFeatures()) & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) == 0L) {
            return false;
        }
        this.writeFieldName(jsonWriter);
        if (value == null && (this.features & (JSONWriter.Feature.NullAsDefaultValue.mask | JSONWriter.Feature.WriteNullStringAsEmpty.mask)) != 0L) {
            jsonWriter.writeString("");
            return true;
        }
        if (this.trim && value != null) {
            value = value.trim();
        }
        if (this.symbol && jsonWriter.jsonb) {
            jsonWriter.writeSymbol(value);
        } else if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        String value = this.function.apply(object);
        if (this.trim && value != null) {
            value = value.trim();
        }
        if (this.symbol && jsonWriter.jsonb) {
            jsonWriter.writeSymbol(value);
        } else if (this.raw) {
            jsonWriter.writeRaw(value);
        } else {
            jsonWriter.writeString(value);
        }
    }
}

