/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONPathSegmentIndex;
import com.alibaba.fastjson2.JSONPathSegmentName;
import java.util.List;

final class JSONPathMulti
extends JSONPath {
    final List<JSONPathSegment> segments;
    final boolean ref;
    final boolean extractSupport;

    JSONPathMulti(String path, List<JSONPathSegment> segments) {
        super(path);
        this.segments = segments;
        boolean extractSupport = true;
        boolean ref = true;
        int l = segments.size();
        for (int i = 0; i < l; ++i) {
            JSONPathSegment segment = segments.get(i);
            if (segment instanceof JSONPathSegmentIndex) {
                if (((JSONPathSegmentIndex)segment).index >= 0) continue;
                extractSupport = false;
                continue;
            }
            if (segment instanceof JSONPathSegmentName) continue;
            ref = false;
            break;
        }
        this.extractSupport = extractSupport;
        this.ref = ref;
    }

    @Override
    public boolean isRef() {
        return this.ref;
    }

    @Override
    public Object eval(Object root) {
        JSONPath.Context context = null;
        int size = this.segments.size();
        if (size == 0) {
            return root;
        }
        for (int i = 0; i < size; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new JSONPath.Context(this, context, segment, nextSegment, 0L);
            if (i == 0) {
                context.root = root;
            }
            segment.eval(context);
        }
        return context.value;
    }
}

