/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.annotation.JSONBuilder;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectArrayReaderMultiType;
import com.alibaba.fastjson2.reader.ObjectArrayTypedReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicReference;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigDecimal;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplBoolValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplBoolean;
import com.alibaba.fastjson2.reader.ObjectReaderImplByte;
import com.alibaba.fastjson2.reader.ObjectReaderImplCalendar;
import com.alibaba.fastjson2.reader.ObjectReaderImplCharValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplCharacter;
import com.alibaba.fastjson2.reader.ObjectReaderImplClass;
import com.alibaba.fastjson2.reader.ObjectReaderImplCurrency;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplDouble;
import com.alibaba.fastjson2.reader.ObjectReaderImplDoubleArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplDoubleValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplField;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloat;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloatArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloatValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromBoolean;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromInt;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromLong;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromString;
import com.alibaba.fastjson2.reader.ObjectReaderImplGenericArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt16Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt16ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplJSONP;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplListInt64;
import com.alibaba.fastjson2.reader.ObjectReaderImplListStr;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocale;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapEntry;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapMultiValueType;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapString;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplMethod;
import com.alibaba.fastjson2.reader.ObjectReaderImplNumber;
import com.alibaba.fastjson2.reader.ObjectReaderImplNumberArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderImplShort;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.reader.ObjectReaderImplStringArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplUUID;
import com.alibaba.fastjson2.reader.ObjectReaderImplValue;
import com.alibaba.fastjson2.reader.ObjectReaderMisc;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.MapMultiValueType;
import com.alibaba.fastjson2.util.MultiType;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;

public final class ObjectReaderModule {
    final ObjectReaderProvider provider;

    public ObjectReaderModule(ObjectReaderProvider provider) {
        this.provider = provider;
    }

    public void getBeanInfo(BeanInfo beanInfo, Class<?> objectClass) {
        Class mixInSource = (Class)this.provider.mixInCache.get(objectClass);
        if (mixInSource != null && mixInSource != objectClass) {
            beanInfo.mixIn = true;
            this.getBeanInfo(beanInfo, mixInSource.getDeclaredAnnotations());
            BeanUtils.staticMethod(mixInSource, method -> this.getCreator(beanInfo, objectClass, (Method)method));
            BeanUtils.constructor(mixInSource, constructor -> this.getCreator(beanInfo, objectClass, (Constructor)constructor));
        }
        Class<?> seeAlsoClass = null;
        for (Class<?> superClass = objectClass.getSuperclass(); superClass != null && superClass != Object.class && superClass != Enum.class; superClass = superClass.getSuperclass()) {
            BeanInfo superBeanInfo = new BeanInfo();
            this.getBeanInfo(superBeanInfo, superClass);
            if (superBeanInfo.seeAlso == null) continue;
            boolean inSeeAlso = false;
            for (Class seeAlsoItem : superBeanInfo.seeAlso) {
                if (seeAlsoItem != objectClass) continue;
                inSeeAlso = true;
                break;
            }
            if (inSeeAlso) continue;
            seeAlsoClass = superClass;
        }
        if (seeAlsoClass != null) {
            this.getBeanInfo(beanInfo, seeAlsoClass);
        }
        Annotation[] annotations = objectClass.getDeclaredAnnotations();
        this.getBeanInfo(beanInfo, annotations);
        block10: for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            switch (annotationTypeName = annotationType.getName()) {
                case "com.alibaba.fastjson.annotation.JSONType": {
                    this.getBeanInfo1x(beanInfo, annotation);
                    continue block10;
                }
                case "kotlin.Metadata": {
                    beanInfo.kotlin = true;
                    continue block10;
                }
            }
        }
        BeanUtils.staticMethod(objectClass, method -> this.getCreator(beanInfo, objectClass, (Method)method));
        BeanUtils.constructor(objectClass, constructor -> this.getCreator(beanInfo, objectClass, (Constructor)constructor));
        if (beanInfo.creatorConstructor == null && (beanInfo.readerFeatures & JSONReader.Feature.FieldBased.mask) == 0L && beanInfo.kotlin) {
            BeanUtils.getKotlinConstructor(objectClass, beanInfo);
            beanInfo.createParameterNames = BeanUtils.getKotlinConstructorParameters(objectClass);
        }
    }

    private void getBeanInfo(BeanInfo beanInfo, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONType jsonType = BeanUtils.findAnnotation(annotation, JSONType.class);
            if (jsonType == null) continue;
            this.getBeanInfo1x(beanInfo, annotation);
            if (jsonType != annotation) continue;
        }
    }

    void getBeanInfo1x(BeanInfo beanInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "seeAlso": {
                        Class[] classes = (Class[])result;
                        if (classes.length == 0) break;
                        beanInfo.seeAlso = classes;
                        beanInfo.seeAlsoNames = new String[classes.length];
                        for (int i = 0; i < classes.length; ++i) {
                            Class item = classes[i];
                            BeanInfo itemBeanInfo = new BeanInfo();
                            this.processSeeAlsoAnnotation(itemBeanInfo, item);
                            String typeName = itemBeanInfo.typeName;
                            if (typeName == null || typeName.isEmpty()) {
                                typeName = item.getSimpleName();
                            }
                            beanInfo.seeAlsoNames[i] = typeName;
                        }
                        beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                        break;
                    }
                    case "seeAlsoDefault": {
                        Class seeAlsoDefault = (Class)result;
                        if (seeAlsoDefault != Void.class) {
                            beanInfo.seeAlsoDefault = seeAlsoDefault;
                        }
                    }
                    case "typeKey": {
                        String jsonTypeKey = (String)result;
                        if (jsonTypeKey.isEmpty()) break;
                        beanInfo.typeKey = jsonTypeKey;
                        break;
                    }
                    case "typeName": {
                        String typeName = (String)result;
                        if (typeName.isEmpty()) break;
                        beanInfo.typeName = typeName;
                        break;
                    }
                    case "naming": {
                        Enum naming = (Enum)result;
                        beanInfo.namingStrategy = naming.name();
                        break;
                    }
                    case "ignores": {
                        String[] ignores = (String[])result;
                        if (ignores.length <= 0) break;
                        beanInfo.ignores = ignores;
                        break;
                    }
                    case "orders": {
                        String[] fields = (String[])result;
                        if (fields.length == 0) break;
                        beanInfo.orders = fields;
                        break;
                    }
                    case "deserializer": {
                        Class deserializer = (Class)result;
                        if (!ObjectReader.class.isAssignableFrom(deserializer)) break;
                        beanInfo.deserializer = deserializer;
                        break;
                    }
                    case "parseFeatures": {
                        Enum[] features = (Enum[])result;
                        block46: for (int i = 0; i < features.length; ++i) {
                            Enum feature = features[i];
                            switch (feature.name()) {
                                case "SupportAutoType": {
                                    beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                                    continue block46;
                                }
                                case "SupportArrayToBean": {
                                    beanInfo.readerFeatures |= JSONReader.Feature.SupportArrayToBean.mask;
                                    continue block46;
                                }
                                case "InitStringFieldAsEmpty": {
                                    beanInfo.readerFeatures |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                                    continue block46;
                                }
                                case "TrimStringFieldValue": {
                                    continue block46;
                                }
                            }
                        }
                        break;
                    }
                    case "deserializeFeatures": {
                        JSONReader.Feature[] features = (JSONReader.Feature[])result;
                        for (int i = 0; i < features.length; ++i) {
                            beanInfo.readerFeatures |= features[i].mask;
                        }
                        break;
                    }
                    case "builder": {
                        Class builderClass = (Class)result;
                        if (builderClass == Void.TYPE || builderClass == Void.class) break;
                        beanInfo.builder = builderClass;
                        for (Annotation builderAnnotation : builderClass.getDeclaredAnnotations()) {
                            Class<? extends Annotation> builderAnnotationClass = builderAnnotation.annotationType();
                            String builderAnnotationName = builderAnnotationClass.getName();
                            if (builderAnnotationName.equals("com.alibaba.fastjson.annotation.JSONPOJOBuilder")) {
                                this.getBeanInfo1xJSONPOJOBuilder(beanInfo, builderClass, builderAnnotation, builderAnnotationClass);
                                continue;
                            }
                            JSONBuilder jsonBuilder = BeanUtils.findAnnotation(builderClass, JSONBuilder.class);
                            if (jsonBuilder == null) continue;
                            String buildMethodName = jsonBuilder.buildMethod();
                            beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, buildMethodName);
                            String withPrefix = jsonBuilder.withPrefix();
                            if (withPrefix.isEmpty()) continue;
                            beanInfo.builderWithPrefix = withPrefix;
                        }
                        if (beanInfo.buildMethod == null) {
                            beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, "build");
                        }
                        if (beanInfo.buildMethod != null) break;
                        beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, "create");
                        break;
                    }
                    case "deserializeUsing": {
                        Class deserializeUsing = (Class)result;
                        if (!ObjectReader.class.isAssignableFrom(deserializeUsing)) break;
                        beanInfo.deserializer = deserializeUsing;
                        break;
                    }
                    case "autoTypeBeforeHandler": 
                    case "autoTypeCheckHandler": {
                        Class autoTypeCheckHandler = (Class)result;
                        if (!JSONReader.AutoTypeBeforeHandler.class.isAssignableFrom(autoTypeCheckHandler)) break;
                        beanInfo.autoTypeBeforeHandler = autoTypeCheckHandler;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void processSeeAlsoAnnotation(BeanInfo beanInfo, Class<?> objectClass) {
        Class mixInSource = (Class)this.provider.mixInCache.get(objectClass);
        if (mixInSource != null && mixInSource != objectClass) {
            beanInfo.mixIn = true;
            this.processSeeAlsoAnnotation(beanInfo, mixInSource.getDeclaredAnnotations());
        }
        this.processSeeAlsoAnnotation(beanInfo, objectClass.getDeclaredAnnotations());
    }

    private void processSeeAlsoAnnotation(BeanInfo beanInfo, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> itemAnnotationType = annotation.annotationType();
            BeanUtils.annotationMethods(itemAnnotationType, m -> {
                String name = m.getName();
                try {
                    String typeName;
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    if (name.equals("typeName") && !(typeName = (String)result).isEmpty()) {
                        beanInfo.typeName = typeName;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Annotation[][] parameterAnnotations) {
        int paIndex;
        Class mixInSource;
        if (objectClass != null && (mixInSource = (Class)this.provider.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
            Constructor mixInConstructor = null;
            try {
                mixInConstructor = mixInSource.getDeclaredConstructor(constructor.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (mixInConstructor != null) {
                Annotation[] mixInParamAnnotations = mixInConstructor.getParameterAnnotations()[paramIndex];
                this.processAnnotation(fieldInfo, mixInParamAnnotations);
            }
        }
        Annotation[] annotations = null;
        if (parameterAnnotations == null) {
            parameterAnnotations = constructor.getParameterAnnotations();
        }
        if ((paIndex = parameterAnnotations.length == constructor.getParameterTypes().length ? paramIndex : paramIndex - 1) >= 0 && paIndex < parameterAnnotations.length) {
            annotations = parameterAnnotations[paIndex];
        }
        if (annotations != null && annotations.length > 0) {
            this.processAnnotation(fieldInfo, annotations);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex) {
        Class mixInSource;
        if (objectClass != null && (mixInSource = (Class)this.provider.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
            Method mixInMethod = null;
            try {
                mixInMethod = mixInSource.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (mixInMethod != null) {
                Annotation[] mixInParamAnnotations = mixInMethod.getParameterAnnotations()[paramIndex];
                this.processAnnotation(fieldInfo, mixInParamAnnotations);
            }
        }
        Annotation[] parameterAnnotations = method.getParameterAnnotations()[paramIndex];
        this.processAnnotation(fieldInfo, parameterAnnotations);
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
        Annotation[] annotations;
        Class mixInSource;
        if (objectClass != null && (mixInSource = (Class)this.provider.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
            Field mixInField = null;
            try {
                mixInField = mixInSource.getDeclaredField(field.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mixInField != null) {
                this.getFieldInfo(fieldInfo, mixInSource, mixInField);
            }
        }
        if ((annotations = field.getDeclaredAnnotations()).length > 0) {
            this.processAnnotation(fieldInfo, annotations);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
        String fieldName2;
        String fieldName1;
        char c1;
        char c0;
        String methodName = method.getName();
        if (objectClass != null) {
            Method supperMethod;
            Class superclass = objectClass.getSuperclass();
            if (superclass != Object.class && superclass != null && (supperMethod = BeanUtils.getMethod(superclass, method)) != null) {
                this.getFieldInfo(fieldInfo, superclass, supperMethod);
            }
            Class<?>[] interfaces = objectClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method interfaceMethod;
                Class<?> item = interfaces[i];
                if (item == Serializable.class || (interfaceMethod = BeanUtils.getMethod(item, method)) == null || superclass == null) continue;
                this.getFieldInfo(fieldInfo, superclass, interfaceMethod);
            }
            Class mixInSource = (Class)this.provider.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(methodName, method.getParameterTypes());
                }
                catch (Exception interfaceMethod) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInMethod);
                }
            }
        }
        String jsonFieldName = null;
        Annotation[] annotations = method.getDeclaredAnnotations();
        for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONField jsonField = BeanUtils.findAnnotation(annotation, JSONField.class);
            if (jsonField != null) {
                this.getFieldInfo(fieldInfo, jsonField);
                jsonFieldName = jsonField.name();
                if (jsonField == annotation) continue;
            }
            if (!(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONField")) continue;
            this.processJSONField1x(fieldInfo, annotation);
        }
        String fieldName = methodName.startsWith("set", 0) ? BeanUtils.setterName(methodName, null) : BeanUtils.getterName(methodName, null);
        if (fieldName.length() > 1 && (c0 = fieldName.charAt(0)) >= 'A' && c0 <= 'Z' && (c1 = fieldName.charAt(1)) >= 'A' && c1 <= 'Z' && (jsonFieldName == null || jsonFieldName.isEmpty())) {
            char[] chars = fieldName.toCharArray();
            chars[0] = (char)(chars[0] + 32);
            fieldName1 = new String(chars);
            chars[1] = (char)(chars[1] + 32);
            fieldName2 = new String(chars);
        } else {
            fieldName1 = null;
            fieldName2 = null;
        }
        BeanUtils.getFieldInfo(objectClass, fieldInfo, this, fieldName, fieldName1, fieldName2);
        if (fieldName1 != null && fieldInfo.fieldName == null && fieldInfo.alternateNames == null) {
            fieldInfo.alternateNames = new String[]{fieldName1, fieldName2};
        }
    }

    private void processAnnotation(FieldInfo fieldInfo, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONField jsonField = BeanUtils.findAnnotation(annotation, JSONField.class);
            if (jsonField != null) {
                this.getFieldInfo(fieldInfo, jsonField);
                if (jsonField == annotation) continue;
            }
            if (!(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONField")) continue;
            this.processJSONField1x(fieldInfo, annotation);
        }
    }

    private void processJSONField1x(FieldInfo fieldInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "name": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        fieldInfo.fieldName = value;
                        break;
                    }
                    case "format": {
                        String format = (String)result;
                        if (format.isEmpty()) break;
                        if ((format = format.trim()).indexOf(84) != -1 && !format.contains("'T'")) {
                            format = format.replaceAll("T", "'T'");
                        }
                        fieldInfo.format = format;
                        break;
                    }
                    case "label": {
                        String label = (String)result;
                        if (label.isEmpty()) break;
                        fieldInfo.label = label;
                        break;
                    }
                    case "defaultValue": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        fieldInfo.defaultValue = value;
                        break;
                    }
                    case "alternateNames": {
                        String[] alternateNames = (String[])result;
                        if (alternateNames.length == 0) break;
                        if (fieldInfo.alternateNames == null) {
                            fieldInfo.alternateNames = alternateNames;
                            break;
                        }
                        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
                        nameSet.addAll(Arrays.asList(alternateNames));
                        nameSet.addAll(Arrays.asList(fieldInfo.alternateNames));
                        fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
                        break;
                    }
                    case "ordinal": {
                        Integer ordinal = (Integer)result;
                        if (ordinal == 0) break;
                        fieldInfo.ordinal = ordinal;
                        break;
                    }
                    case "deserialize": {
                        Boolean serialize = (Boolean)result;
                        if (serialize.booleanValue()) break;
                        fieldInfo.ignore = true;
                        break;
                    }
                    case "parseFeatures": {
                        Enum[] features;
                        block34: for (Enum feature : features = (Enum[])result) {
                            switch (feature.name()) {
                                case "SupportAutoType": {
                                    fieldInfo.features |= JSONReader.Feature.SupportAutoType.mask;
                                    continue block34;
                                }
                                case "SupportArrayToBean": {
                                    fieldInfo.features |= JSONReader.Feature.SupportArrayToBean.mask;
                                    continue block34;
                                }
                                case "InitStringFieldAsEmpty": {
                                    fieldInfo.features |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                                    continue block34;
                                }
                            }
                        }
                        break;
                    }
                    case "deserializeUsing": {
                        Class deserializeUsing = (Class)result;
                        if (!ObjectReader.class.isAssignableFrom(deserializeUsing)) break;
                        fieldInfo.readUsing = deserializeUsing;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void getFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
        Class deserializeUsing;
        boolean value;
        String[] alternateNames;
        String[] parts;
        String locale;
        String defaultValue;
        String label;
        String jsonFieldFormat;
        if (jsonField == null) {
            return;
        }
        String jsonFieldName = jsonField.name();
        if (!jsonFieldName.isEmpty()) {
            fieldInfo.fieldName = jsonFieldName;
        }
        if (!(jsonFieldFormat = jsonField.format()).isEmpty()) {
            if ((jsonFieldFormat = jsonFieldFormat.trim()).indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
            }
            fieldInfo.format = jsonFieldFormat;
        }
        if (!(label = jsonField.label()).isEmpty()) {
            fieldInfo.label = label = label.trim();
        }
        if (!(defaultValue = jsonField.defaultValue()).isEmpty()) {
            fieldInfo.defaultValue = defaultValue;
        }
        if (!(locale = jsonField.locale()).isEmpty() && (parts = locale.split("_")).length == 2) {
            fieldInfo.locale = new Locale(parts[0], parts[1]);
        }
        if ((alternateNames = jsonField.alternateNames()).length != 0) {
            if (fieldInfo.alternateNames == null) {
                fieldInfo.alternateNames = alternateNames;
            } else {
                LinkedHashSet nameSet = new LinkedHashSet();
                Collections.addAll(nameSet, alternateNames);
                nameSet.addAll(Arrays.asList(fieldInfo.alternateNames));
                fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
            }
        }
        if (!fieldInfo.ignore) {
            fieldInfo.ignore = !jsonField.deserialize();
        }
        for (JSONReader.Feature feature : jsonField.deserializeFeatures()) {
            fieldInfo.features |= feature.mask;
        }
        int ordinal = jsonField.ordinal();
        if (ordinal != 0) {
            fieldInfo.ordinal = ordinal;
        }
        if (value = jsonField.value()) {
            fieldInfo.features |= 0x1000000000000L;
        }
        if (jsonField.unwrapped()) {
            fieldInfo.features |= 0x2000000000000L;
        }
        if (jsonField.required()) {
            fieldInfo.required = true;
        }
        if (ObjectReader.class.isAssignableFrom(deserializeUsing = jsonField.deserializeUsing())) {
            fieldInfo.readUsing = deserializeUsing;
        }
    }

    private void getBeanInfo1xJSONPOJOBuilder(BeanInfo beanInfo, Class<?> builderClass, Annotation builderAnnatation, Class<? extends Annotation> builderAnnatationClass) {
        BeanUtils.annotationMethods(builderAnnatationClass, method -> {
            try {
                String methodName;
                switch (methodName = method.getName()) {
                    case "buildMethod": {
                        String buildMethodName = (String)method.invoke((Object)builderAnnatation, new Object[0]);
                        beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, buildMethodName);
                        break;
                    }
                    case "withPrefix": {
                        String withPrefix = (String)method.invoke((Object)builderAnnatation, new Object[0]);
                        if (withPrefix.isEmpty()) break;
                        beanInfo.builderWithPrefix = withPrefix;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void getCreator(BeanInfo beanInfo, Class<?> objectClass, Constructor constructor) {
        if (objectClass.isEnum()) {
            return;
        }
        Annotation[] annotations = constructor.getDeclaredAnnotations();
        boolean creatorMethod = false;
        for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONCreator jsonCreator = BeanUtils.findAnnotation(annotation, JSONCreator.class);
            if (jsonCreator != null) {
                String[] createParameterNames = jsonCreator.parameterNames();
                if (createParameterNames.length != 0) {
                    beanInfo.createParameterNames = createParameterNames;
                }
                creatorMethod = true;
                if (jsonCreator == annotation) continue;
            }
            if (!(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONCreator") && !annotationTypeName.equals("com.alibaba.fastjson2.annotation.JSONCreator")) continue;
            creatorMethod = true;
            BeanUtils.annotationMethods(annotationType, m1 -> {
                try {
                    switch (m1.getName()) {
                        case "parameterNames": {
                            String[] createParameterNames = (String[])m1.invoke((Object)annotation, new Object[0]);
                            if (createParameterNames.length == 0) break;
                            beanInfo.createParameterNames = createParameterNames;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        if (!creatorMethod) {
            return;
        }
        Constructor<?> targetConstructor = null;
        try {
            targetConstructor = objectClass.getDeclaredConstructor(constructor.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (targetConstructor != null) {
            beanInfo.creatorConstructor = targetConstructor;
        }
    }

    private void getCreator(BeanInfo beanInfo, Class<?> objectClass, Method method) {
        if (method.getDeclaringClass() == Enum.class) {
            return;
        }
        String methodName = method.getName();
        if (objectClass.isEnum() && methodName.equals("values")) {
            return;
        }
        Annotation[] annotations = method.getDeclaredAnnotations();
        boolean creatorMethod = false;
        JSONCreator jsonCreator = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            jsonCreator = BeanUtils.findAnnotation(annotation, JSONCreator.class);
            if (jsonCreator == annotation || !annotationType.getName().equals("com.alibaba.fastjson.annotation.JSONCreator")) continue;
            creatorMethod = true;
            BeanUtils.annotationMethods(annotationType, m1 -> {
                try {
                    switch (m1.getName()) {
                        case "parameterNames": {
                            String[] createParameterNames = (String[])m1.invoke((Object)annotation, new Object[0]);
                            if (createParameterNames.length == 0) break;
                            beanInfo.createParameterNames = createParameterNames;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        if (jsonCreator != null) {
            String[] createParameterNames = jsonCreator.parameterNames();
            if (createParameterNames.length != 0) {
                beanInfo.createParameterNames = createParameterNames;
            }
            creatorMethod = true;
        }
        if (!creatorMethod) {
            return;
        }
        Method targetMethod = null;
        try {
            targetMethod = objectClass.getDeclaredMethod(methodName, method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (targetMethod != null) {
            beanInfo.createMethod = targetMethod;
        }
    }

    public ObjectReader getObjectReader(ObjectReaderProvider provider, Type type) {
        Type[] upperBounds;
        if (type == String.class || type == CharSequence.class) {
            return ObjectReaderImplString.INSTANCE;
        }
        if (type == Character.TYPE || type == Character.class) {
            return ObjectReaderImplCharacter.INSTANCE;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ObjectReaderImplBoolean.INSTANCE;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return ObjectReaderImplByte.INSTANCE;
        }
        if (type == Short.TYPE || type == Short.class) {
            return ObjectReaderImplShort.INSTANCE;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return ObjectReaderImplInteger.INSTANCE;
        }
        if (type == Long.TYPE || type == Long.class) {
            return ObjectReaderImplInt64.INSTANCE;
        }
        if (type == Float.TYPE || type == Float.class) {
            return ObjectReaderImplFloat.INSTANCE;
        }
        if (type == Double.TYPE || type == Double.class) {
            return ObjectReaderImplDouble.INSTANCE;
        }
        if (type == BigInteger.class) {
            return ObjectReaderImplBigInteger.INSTANCE;
        }
        if (type == BigDecimal.class) {
            return ObjectReaderImplBigDecimal.INSTANCE;
        }
        if (type == Number.class) {
            return ObjectReaderImplNumber.INSTANCE;
        }
        if (type == UUID.class) {
            return ObjectReaderImplUUID.INSTANCE;
        }
        if (type == AtomicBoolean.class) {
            return new ObjectReaderImplFromBoolean<AtomicBoolean>(AtomicBoolean.class, AtomicBoolean::new);
        }
        if (type == URI.class) {
            return new ObjectReaderImplFromString<URI>(URI.class, URI::create);
        }
        if (type == Charset.class) {
            return new ObjectReaderImplFromString<Charset>(Charset.class, e -> Charset.forName(e));
        }
        if (type == File.class) {
            return new ObjectReaderImplFromString<File>(File.class, e -> new File((String)e));
        }
        if (type == URL.class) {
            return new ObjectReaderImplFromString<URL>(URL.class, e -> {
                try {
                    return new URL((String)e);
                }
                catch (MalformedURLException ex) {
                    throw new JSONException("read URL error", ex);
                }
            });
        }
        if (type == Pattern.class) {
            return new ObjectReaderImplFromString<Pattern>(Pattern.class, Pattern::compile);
        }
        if (type == SimpleDateFormat.class) {
            return new ObjectReaderImplFromString<SimpleDateFormat>(SimpleDateFormat.class, SimpleDateFormat::new);
        }
        if (type == Class.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        if (type == Method.class) {
            return new ObjectReaderImplMethod();
        }
        if (type == Field.class) {
            return new ObjectReaderImplField();
        }
        if (type == Type.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        String typeName = type instanceof Class ? ((Class)type).getName() : "";
        if (type == Map.class || type == AbstractMap.class) {
            return ObjectReaderImplMap.of(null, (Class)type, 0L);
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return ObjectReaderModule.typedMap((Class)type, ConcurrentHashMap.class, null, Object.class);
        }
        if (type == ConcurrentNavigableMap.class || type == ConcurrentSkipListMap.class) {
            return ObjectReaderModule.typedMap((Class)type, ConcurrentSkipListMap.class, null, Object.class);
        }
        if (type == SortedMap.class || type == NavigableMap.class || type == TreeMap.class) {
            return ObjectReaderModule.typedMap((Class)type, TreeMap.class, null, Object.class);
        }
        if (type == Calendar.class) {
            return ObjectReaderImplCalendar.INSTANCE;
        }
        if (type == Date.class) {
            return ObjectReaderImplDate.INSTANCE;
        }
        if (type == Locale.class) {
            return ObjectReaderImplLocale.INSTANCE;
        }
        if (type == Currency.class) {
            return ObjectReaderImplCurrency.INSTANCE;
        }
        if (type == ZoneId.class) {
            return new ObjectReaderImplFromString<ZoneId>(ZoneId.class, e -> ZoneId.of(e));
        }
        if (type == TimeZone.class) {
            return new ObjectReaderImplFromString<TimeZone>(TimeZone.class, e -> TimeZone.getTimeZone(e));
        }
        if (type == char[].class) {
            return ObjectReaderImplCharValueArray.INSTANCE;
        }
        if (type == float[].class) {
            return ObjectReaderImplFloatValueArray.INSTANCE;
        }
        if (type == double[].class) {
            return ObjectReaderImplDoubleValueArray.INSTANCE;
        }
        if (type == boolean[].class) {
            return ObjectReaderImplBoolValueArray.INSTANCE;
        }
        if (type == byte[].class) {
            return ObjectReaderImplInt8ValueArray.INSTANCE;
        }
        if (type == short[].class) {
            return ObjectReaderImplInt16ValueArray.INSTANCE;
        }
        if (type == int[].class) {
            return ObjectReaderImplInt32ValueArray.INSTANCE;
        }
        if (type == long[].class) {
            return ObjectReaderImplInt64ValueArray.INSTANCE;
        }
        if (type == Byte[].class) {
            return ObjectReaderImplInt8Array.INSTANCE;
        }
        if (type == Short[].class) {
            return ObjectReaderImplInt16Array.INSTANCE;
        }
        if (type == Integer[].class) {
            return ObjectReaderImplInt32Array.INSTANCE;
        }
        if (type == Long[].class) {
            return ObjectReaderImplInt64Array.INSTANCE;
        }
        if (type == Float[].class) {
            return ObjectReaderImplFloatArray.INSTANCE;
        }
        if (type == Double[].class) {
            return ObjectReaderImplDoubleArray.INSTANCE;
        }
        if (type == Number[].class) {
            return ObjectReaderImplNumberArray.INSTANCE;
        }
        if (type == String[].class) {
            return ObjectReaderImplStringArray.INSTANCE;
        }
        if (type == AtomicInteger.class) {
            return new ObjectReaderImplFromInt<AtomicInteger>(AtomicInteger.class, AtomicInteger::new);
        }
        if (type == AtomicLong.class) {
            return new ObjectReaderImplFromLong<AtomicLong>(AtomicLong.class, AtomicLong::new);
        }
        if (type == AtomicIntegerArray.class) {
            return new ObjectReaderImplInt32ValueArray(AtomicIntegerArray.class, AtomicIntegerArray::new);
        }
        if (type == AtomicLongArray.class) {
            return new ObjectReaderImplInt64ValueArray(AtomicLongArray.class, AtomicLongArray::new);
        }
        if (type == AtomicReference.class) {
            return ObjectReaderImplAtomicReference.INSTANCE;
        }
        if (type instanceof MultiType) {
            return new ObjectArrayReaderMultiType((MultiType)type);
        }
        if (type instanceof MapMultiValueType) {
            return new ObjectReaderImplMapMultiValueType((MapMultiValueType)type);
        }
        if (type == StringBuffer.class || type == StringBuilder.class) {
            try {
                Class objectClass = (Class)type;
                return new ObjectReaderImplValue(objectClass, (Type)((Object)String.class), String.class, 0L, null, null, objectClass.getConstructor(String.class), null, null);
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException(e2);
            }
        }
        if (type == Iterable.class || type == Collection.class || type == List.class || type == AbstractCollection.class || type == AbstractList.class || type == ArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Queue.class || type == Deque.class || type == AbstractSequentialList.class || type == LinkedList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Set.class || type == AbstractSet.class || type == EnumSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == NavigableSet.class || type == SortedSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ConcurrentLinkedQueue.class || type == ConcurrentSkipListSet.class || type == LinkedHashSet.class || type == HashSet.class || type == TreeSet.class || type == CopyOnWriteArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ObjectReaderImplList.CLASS_EMPTY_SET || type == ObjectReaderImplList.CLASS_EMPTY_LIST || type == ObjectReaderImplList.CLASS_SINGLETON || type == ObjectReaderImplList.CLASS_SINGLETON_LIST || type == ObjectReaderImplList.CLASS_ARRAYS_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_COLLECTION || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_SET) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == TypeUtils.CLASS_SINGLE_SET) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Object.class || type == Cloneable.class || type == Closeable.class || type == Serializable.class || type == Comparable.class) {
            return ObjectReaderImplObject.INSTANCE;
        }
        if (type == Map.Entry.class) {
            return new ObjectReaderImplMapEntry(null, null);
        }
        if (type instanceof Class) {
            Class objectClass = (Class)type;
            if (Map.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplMap.of(null, objectClass, 0L);
            }
            if (Collection.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplList.of(objectClass, objectClass, 0L);
            }
            if (objectClass.isArray()) {
                Class<?> componentType = objectClass.getComponentType();
                if (componentType == Object.class) {
                    return ObjectArrayReader.INSTANCE;
                }
                return new ObjectArrayTypedReader(objectClass);
            }
            if (JSONPObject.class.isAssignableFrom(objectClass)) {
                return new ObjectReaderImplJSONP(objectClass);
            }
            ObjectReaderCreator creator = JSONFactory.defaultObjectReaderProvider.creator;
            if (objectClass == StackTraceElement.class) {
                try {
                    Constructor constructor = objectClass.getConstructor(String.class, String.class, String.class, Integer.TYPE);
                    return creator.createObjectReaderNoneDefaultConstructor(constructor, "className", "methodName", "fileName", "lineNumber");
                }
                catch (Throwable constructor) {
                    // empty catch block
                }
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 2) {
                Type actualTypeParam0 = actualTypeArguments[0];
                Type actualTypeParam1 = actualTypeArguments[1];
                if (rawType == Map.class || rawType == AbstractMap.class || rawType == HashMap.class) {
                    return ObjectReaderModule.typedMap((Class)rawType, HashMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == ConcurrentMap.class || rawType == ConcurrentHashMap.class) {
                    return ObjectReaderModule.typedMap((Class)rawType, ConcurrentHashMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == ConcurrentNavigableMap.class || rawType == ConcurrentSkipListMap.class) {
                    return ObjectReaderModule.typedMap((Class)rawType, ConcurrentSkipListMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == LinkedHashMap.class || rawType == TreeMap.class) {
                    return ObjectReaderModule.typedMap((Class)rawType, (Class)rawType, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == Map.Entry.class) {
                    return new ObjectReaderImplMapEntry(actualTypeArguments[0], actualTypeArguments[1]);
                }
            }
            if (actualTypeArguments.length == 1) {
                Type itemType = actualTypeArguments[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (rawType == Iterable.class || rawType == Collection.class || rawType == List.class || rawType == AbstractCollection.class || rawType == AbstractList.class || rawType == ArrayList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, ArrayList.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, ArrayList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Queue.class || rawType == Deque.class || rawType == AbstractSequentialList.class || rawType == LinkedList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, LinkedList.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, LinkedList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Set.class || rawType == AbstractSet.class || rawType == EnumSet.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, HashSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, HashSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == NavigableSet.class || rawType == SortedSet.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, TreeSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, TreeSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == ConcurrentLinkedQueue.class || rawType == ConcurrentSkipListSet.class || rawType == LinkedHashSet.class || rawType == HashSet.class || rawType == TreeSet.class || rawType == CopyOnWriteArrayList.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, (Class)rawType);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, (Class)rawType);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == AtomicReference.class) {
                    return new ObjectReaderImplAtomicReference(itemType);
                }
                if (itemType instanceof WildcardType) {
                    return this.getObjectReader(provider, rawType);
                }
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return new ObjectReaderImplGenericArray((GenericArrayType)type);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return this.getObjectReader(provider, upperBounds[0]);
        }
        if (type == ParameterizedType.class) {
            return ObjectReaders.ofReflect(ParameterizedTypeImpl.class);
        }
        switch (typeName) {
            case "java.sql.Time": {
                return new JdbcSupport.TimeReader(null, null);
            }
            case "java.sql.Timestamp": {
                return new JdbcSupport.TimestampReader(null, null);
            }
            case "java.sql.Date": {
                return new JdbcSupport.DateReader(null, null);
            }
            case "java.util.RegularEnumSet": 
            case "java.util.JumboEnumSet": {
                return ObjectReaderImplList.of(type, TypeUtils.getClass(type), 0L);
            }
            case "java.net.InetSocketAddress": {
                return new ObjectReaderMisc((Class)type);
            }
            case "java.net.InetAddress": {
                return ObjectReaderImplValue.of((Class)type, String.class, address -> {
                    try {
                        return InetAddress.getByName(address);
                    }
                    catch (UnknownHostException e) {
                        throw new JSONException("create address error", e);
                    }
                });
            }
            case "java.text.SimpleDateFormat": {
                return ObjectReaderImplValue.of((Class)type, String.class, SimpleDateFormat::new);
            }
        }
        return null;
    }

    public static ObjectReader typedMap(Class mapType, Class instanceType, Type keyType, Type valueType) {
        if ((keyType == null || keyType == String.class) && valueType == String.class) {
            return new ObjectReaderImplMapString(mapType, instanceType, 0L);
        }
        return new ObjectReaderImplMapTyped(mapType, instanceType, keyType, valueType, 0L, null);
    }
}

