/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.time;

import com.alibaba.fastjson2.time.DateTimeException;
import com.alibaba.fastjson2.time.Instant;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.IOUtils;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;

public final class LocalDateTime {
    public final LocalDate date;
    public final LocalTime time;

    private LocalDateTime(LocalDate date, LocalTime time) {
        this.date = date;
        this.time = time;
    }

    public static LocalDateTime ofEpochSecond(long epochSecond, int nanoOfSecond, int offsetTotalSeconds) {
        LocalDateTime.checkNanoOfSecond(nanoOfSecond);
        int SECONDS_PER_DAY = 86400;
        long localSecond = epochSecond + (long)offsetTotalSeconds;
        long localEpochDay = IOUtils.floorDiv(localSecond, 86400L);
        int secsOfDay = (int)IOUtils.floorMod(localSecond, 86400L);
        LocalDate date = LocalDate.ofEpochDay(localEpochDay);
        LocalTime time = LocalTime.ofNanoOfDay((long)secsOfDay * 1000000000L + (long)nanoOfSecond);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(LocalDate date, LocalTime time) {
        if (date == null) {
            throw new NullPointerException("date");
        }
        if (time == null) {
            throw new NullPointerException("time");
        }
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        LocalDate date = LocalDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second);
        return new LocalDateTime(date, time);
    }

    public static LocalDateTime of(int year, int month, int dayOfMonth, int hour, int minute, int second, int nano) {
        LocalDate date = LocalDate.of(year, month, dayOfMonth);
        LocalTime time = LocalTime.of(hour, minute, second, nano);
        return new LocalDateTime(date, time);
    }

    public Date toDate() {
        return this.toInstant(ZoneId.DEFAULT_ZONE_ID).toDate();
    }

    public Date toDate(ZoneId zoneId) {
        return this.toInstant(zoneId).toDate();
    }

    public Timestamp toTimestamp() {
        return new Timestamp(this.date.year - 1900, this.date.monthValue - 1, this.date.dayOfMonth, this.time.hour, this.time.minute, this.time.second, this.time.nano);
    }

    public Instant toInstant(ZoneId zone) {
        Calendar calendar = Calendar.getInstance(zone.timeZone);
        calendar.set(this.date.year, this.date.monthValue - 1, this.date.dayOfMonth, this.time.hour, this.time.minute, this.time.second);
        long seconds = calendar.getTime().getTime() / 1000L;
        return Instant.ofEpochSecond(seconds, this.time.nano);
    }

    public static LocalDateTime ofInstant(Instant instant, ZoneId zone) {
        if (instant == null) {
            throw new NullPointerException("instant");
        }
        if (zone == null) {
            throw new NullPointerException("zone");
        }
        int offset = zone.getOffsetTotalSeconds(instant);
        return LocalDateTime.ofEpochSecond(instant.epochSecond, instant.nanos, offset);
    }

    public static int checkYear(long value) {
        if (value < -999999999L || value > 999999999L) {
            throw new DateTimeException("Invalid value for year (valid values [-999_999_999, 999_999_999]): " + value);
        }
        return (int)value;
    }

    public static void checkSecondOfDay(long value) {
        if (value < 0L || value > 86399999999999L) {
            throw new DateTimeException("Invalid value for year (valid values [0, 86399999999999]): " + value);
        }
    }

    public static void checkNanoOfSecond(long value) {
        if (value < 0L || value > 999999999L) {
            throw new DateTimeException("Invalid value for year (valid values [0, 999_999_999]): " + value);
        }
    }

    public static LocalDateTime now() {
        return ZonedDateTime.now((ZoneId)ZoneId.DEFAULT_ZONE_ID).dateTime;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDateTime that = (LocalDateTime)o;
        return this.date == that.date || this.date != null && this.date.equals(that.date) && this.time == that.time || this.time != null && this.time.equals(that.time);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.date, this.time});
    }

    public String toString() {
        return DateUtils.format(this, "yyyy-MM-dd HH:mm:ss");
    }
}

