/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF16;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.BeforeFilter;
import com.alibaba.fastjson2.filter.ContextNameFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.function.Consumer;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderNoneDefaultConstructor;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.MapMultiValueType;
import com.alibaba.fastjson2.util.MultiType;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public interface JSON {
    public static final String VERSION = "2.0.46";

    public static Object parse(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object;
            char ch = reader.current();
            if (context.objectSupplier == null && (context.features & JSONReader.Feature.UseNativeObject.mask) == 0L && (ch == '{' || ch == '[')) {
                if (ch == '{') {
                    JSONObject jsonObject = new JSONObject();
                    reader.read(jsonObject, 0L);
                    object = jsonObject;
                } else {
                    JSONArray array = new JSONArray();
                    reader.read(array);
                    object = array;
                }
                if (reader.resolveTasks != null) {
                    reader.handleResolveTasks(object);
                }
            } else {
                ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
                object = objectReader.readObject(reader, null, null, 0L);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, int offset, int length, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReader reader = JSONReader.of(text, offset, length, context);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(String text, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReader objectReader = context.getObjectReader((Type)((Object)Object.class));
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(byte[] utf8, JSONReader.Context context) {
        if (utf8 == null || utf8.length == 0) {
            return null;
        }
        ObjectReader objectReader = context.getObjectReader((Type)((Object)Object.class));
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, utf8, 0, utf8.length);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(byte[] bytes, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static Object parse(char[] chars, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
        JSONReader.Context context = new JSONReader.Context(provider, features);
        ObjectReader objectReader = provider.getObjectReader((Type)((Object)Object.class), false);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, 0, chars.length);){
            Object object = objectReader.readObject(reader, null, null, 0L);
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static JSONObject parseObject(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = new JSONReader.Context(JSONFactory.defaultObjectReaderProvider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, int offset, int length, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(text, offset, length, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, int offset, int length, JSONReader.Context context) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, offset, length, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(String text, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        try (JSONReader reader = JSONReader.of(text, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(Reader input, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(input, context);){
            if (reader.isEnd()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream input, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8, context);){
            if (reader.isEnd()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, 0, chars.length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(InputStream in, Charset charset) {
        if (in == null) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(in, charset, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(URL url) {
        JSONObject jSONObject;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONObject = JSON.parseObject(is, StandardCharsets.UTF_8);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("JSON#parseObject cannot parse '" + url + "'", e);
                }
            }
            is.close();
        }
        return jSONObject;
    }

    public static JSONObject parseObject(byte[] bytes, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, offset, length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(char[] chars, int offset, int length, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(features);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, offset, length);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static JSONObject parseObject(byte[] bytes, int offset, int length, Charset charset, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            if (reader.nextIfNull()) {
                JSONObject jSONObject = null;
                return jSONObject;
            }
            context.config(features);
            JSONObject object = new JSONObject();
            reader.read(object, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONObject jSONObject = object;
            return jSONObject;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        ObjectReader objectReader = provider.getObjectReader(clazz, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(filter, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            if (reader.nextIfNull()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, String format, Filter[] filters, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext(filters, features);
        context.setDateFormat(format);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            if (reader.nextIfNull()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            ObjectReader objectReader = provider.getObjectReader(type, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T extends Map<String, Object>> T parseObject(String text, MapMultiValueType<T> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            ObjectReader objectReader = provider.getObjectReader(type, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
            Map object = (Map)objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Map map = object;
            return (T)map;
        }
    }

    public static <T> T parseObject(String text, Type ... types) {
        return JSON.parseObject(text, (Type)new MultiType(types));
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        Type type = typeReference.getType();
        ObjectReader objectReader = provider.getObjectReader(type, (JSONFactory.defaultReaderFeatures & JSONReader.Feature.FieldBased.mask) != 0L);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, TypeReference<T> typeReference, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, null, filter, features);
        Type type = typeReference.getType();
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(clazz, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, int offset, int length, Class<T> clazz, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty() || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(clazz, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, offset, length);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, JSONReader.Context context) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Class<T> clazz, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(clazz, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, Filter filter, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, null, filter, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(String text, Type type, String format, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, int offset, int length, Type type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0 || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, offset, length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, Class<T> clazz) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(clazz, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, 0, chars.length);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(((JSONReader)reader).info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, offset, length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            ObjectReader objectReader = context.getObjectReader(clazz);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz, Filter filter, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        JSONReader.Context context = JSONFactory.createReadContext();
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            context.config(filter, features);
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz, JSONReader.Context context) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
            ObjectReader objectReader = context.provider.getObjectReader(clazz, fieldBased);
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, String format, Filter[] filters, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, null, filters, features);
        context.setDateFormat(format);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Class<T> clazz, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(clazz, fieldBased);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            Object object = objectReader.readObject(reader, clazz, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, Class<T> objectClass, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, 0, chars.length);){
            Object object = objectReader.readObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(char[] chars, Type type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, 0, chars.length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, Filter filter, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, null, filter, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, Type type, String format, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(ByteBuffer buffer, Class<T> objectClass) {
        if (buffer == null) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(objectClass, fieldBased);
        try (JSONReader reader = JSONReader.of(buffer, context, null);){
            Object object = objectReader.readObject(reader, objectClass, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(Reader input, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, input);){
            if (reader.isEnd()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8, context);){
            if (reader.isEnd()) {
                T t = null;
                return t;
            }
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Type type, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            T t = JSON.parseObject(is, type, features);
            return t;
        }
        catch (IOException e) {
            throw new JSONException("parseObject error", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Class<T> objectClass, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            T t = JSON.parseObject(is, objectClass, features);
            return t;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse '" + url + "' to '" + objectClass + "'", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T parseObject(URL url, Function<JSONObject, T> function, JSONReader.Feature ... features) {
        if (url == null) {
            return null;
        }
        try (InputStream is = url.openStream();){
            JSONObject object = JSON.parseObject(is, features);
            if (object == null) {
                T t = null;
                return t;
            }
            JSONObject jSONObject = function.apply(object);
            return (T)jSONObject;
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse '" + url + "'", e);
        }
    }

    public static <T> T parseObject(InputStream input, Type type, String format, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(input, StandardCharsets.UTF_8, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(InputStream input, Charset charset, Type type, JSONReader.Feature ... features) {
        if (input == null) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(input, charset, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Type type) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> T parseObject(byte[] bytes, int offset, int length, Charset charset, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = provider.getObjectReader(type, fieldBased);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            Object object = objectReader.readObject(reader, type, null, 0L);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(object);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            Object t = object;
            return t;
        }
    }

    public static <T> void parseObject(InputStream input, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        JSON.parseObject(input, StandardCharsets.UTF_8, '\n', type, consumer, features);
    }

    public static <T> void parseObject(InputStream input, Charset charset, char delimiter, Type type, Consumer<T> consumer, JSONReader.Feature ... features) {
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(cacheItem, null);
        int bufferSize = 524288;
        if (bytes == null) {
            bytes = new byte[bufferSize];
        }
        int offset = 0;
        int start = 0;
        ObjectReader objectReader = null;
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        try {
            int n;
            while ((n = input.read(bytes, offset, bytes.length - offset)) != -1) {
                int k = offset;
                offset += n;
                boolean dispose = false;
                while (k < offset) {
                    if (bytes[k] == delimiter) {
                        int end = k;
                        JSONReader jsonReader = JSONReader.of(bytes, start, end - start, charset, context);
                        if (objectReader == null) {
                            objectReader = provider.getObjectReader(type, fieldBased);
                        }
                        Object object = objectReader.readObject(jsonReader, type, null, 0L);
                        if (jsonReader.resolveTasks != null) {
                            jsonReader.handleResolveTasks(object);
                        }
                        if (jsonReader.ch != '\u001a' && (jsonReader.context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                            throw new JSONException(jsonReader.info("input not end"));
                        }
                        consumer.accept(object);
                        start = end + 1;
                        dispose = true;
                    }
                    ++k;
                }
                if (offset != bytes.length) continue;
                if (dispose) {
                    int len = bytes.length - start;
                    System.arraycopy(bytes, start, bytes, 0, len);
                    start = 0;
                    offset = len;
                    continue;
                }
                bytes = Arrays.copyOf(bytes, bytes.length + bufferSize);
            }
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse the 'InputStream' to '" + type + "'", e);
        }
        finally {
            JSONFactory.BYTES_UPDATER.lazySet(cacheItem, bytes);
        }
    }

    public static <T> void parseObject(Reader input, char delimiter, Type type, Consumer<T> consumer) {
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        JSONFactory.CacheItem cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        char[] chars = JSONFactory.CHARS_UPDATER.getAndSet(cacheItem, null);
        if (chars == null) {
            chars = new char[8192];
        }
        int offset = 0;
        int start = 0;
        ObjectReader objectReader = null;
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        boolean fieldBased = (context.features & JSONReader.Feature.FieldBased.mask) != 0L;
        try {
            int n;
            while ((n = input.read(chars, offset, chars.length - offset)) != -1) {
                int k = offset;
                offset += n;
                boolean dispose = false;
                while (k < offset) {
                    if (chars[k] == delimiter) {
                        int end = k;
                        JSONReader jsonReader = JSONReader.of(chars, start, end - start, context);
                        if (objectReader == null) {
                            objectReader = provider.getObjectReader(type, fieldBased);
                        }
                        consumer.accept(objectReader.readObject(jsonReader, type, null, 0L));
                        start = end + 1;
                        dispose = true;
                    }
                    ++k;
                }
                if (offset != chars.length) continue;
                if (dispose) {
                    int len = chars.length - start;
                    System.arraycopy(chars, start, chars, 0, len);
                    start = 0;
                    offset = len;
                    continue;
                }
                chars = Arrays.copyOf(chars, chars.length + 8192);
            }
        }
        catch (IOException e) {
            throw new JSONException("JSON#parseObject cannot parse the 'Reader' to '" + type + "'", e);
        }
        finally {
            JSONFactory.CHARS_UPDATER.lazySet(cacheItem, chars);
        }
    }

    public static JSONArray parseArray(String text) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(char[] chars) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, 0, chars.length);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(String text, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static JSONArray parseArray(URL url, JSONReader.Feature ... features) {
        JSONArray jSONArray;
        block9: {
            if (url == null) {
                return null;
            }
            InputStream is = url.openStream();
            try {
                jSONArray = JSON.parseArray(is, features);
                if (is == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new JSONException("JSON#parseArray cannot parse '" + url + "' to '" + JSONArray.class + "'", e);
                }
            }
            is.close();
        }
        return jSONArray;
    }

    public static JSONArray parseArray(InputStream in, JSONReader.Feature ... features) {
        if (in == null) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReader reader = JSONReader.of(in, StandardCharsets.UTF_8, context);){
            if (reader.nextIfNull()) {
                JSONArray jSONArray = null;
                return jSONArray;
            }
            JSONArray array = new JSONArray();
            reader.read(array);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            JSONArray jSONArray = array;
            return jSONArray;
        }
    }

    public static <T> List<T> parseArray(String text, Type type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type ... types) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            List list = reader.readList(types);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Class<T> type, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(char[] chars, Class<T> type, JSONReader.Feature ... features) {
        if (chars == null || chars.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, null, chars, 0, chars.length);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(String text, Type[] types, JSONReader.Feature ... features) {
        if (text == null || text.isEmpty()) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderUTF16 reader = new JSONReaderUTF16(context, text, 0, text.length());){
            if (reader.nextIfNull()) {
                List<T> list = null;
                return list;
            }
            reader.startArray();
            ArrayList array = new ArrayList(types.length);
            for (int i = 0; i < types.length; ++i) {
                array.add(reader.read(types[i]));
            }
            reader.endArray();
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(array);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            ArrayList arrayList = array;
            return arrayList;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Type type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReaderUTF8 reader = new JSONReaderUTF8(context, null, bytes, 0, bytes.length);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static <T> List<T> parseArray(byte[] bytes, int offset, int length, Charset charset, Class<T> type, JSONReader.Feature ... features) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return null;
        }
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        JSONReader.Context context = new JSONReader.Context(provider, features);
        try (JSONReader reader = JSONReader.of(bytes, offset, length, charset, context);){
            List list = reader.readArray(type);
            if (reader.resolveTasks != null) {
                reader.handleResolveTasks(list);
            }
            if (reader.ch != '\u001a' && (context.features & JSONReader.Feature.IgnoreCheckClose.mask) == 0L) {
                throw new JSONException(reader.info("input not end"));
            }
            List list2 = list;
            return list2;
        }
    }

    public static String toJSONString(Object object) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider);
        boolean optimizedForAscii = (JSONFactory.defaultWriterFeatures & JSONWriter.Feature.OptimizedForAscii.mask) != 0L;
        JSONWriter writer = optimizedForAscii ? new JSONWriterUTF8(context) : new JSONWriterUTF16(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                if (valueClass == JSONObject.class && context.features == 0L) {
                    writer.write((JSONObject)object);
                } else {
                    boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
                    ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                    objectWriter.write(writer, object, null, null, 0L);
                }
            }
            String string = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
            }
        }
    }

    public static String toJSONString(Object object, JSONWriter.Context context) {
        JSONWriter writer = JSONWriter.of(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = writer.getObjectWriter(valueClass, valueClass);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            if (writer != null) {
                writer.close();
            }
            return string;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (NullPointerException | NumberFormatException e) {
                throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
            }
        }
    }

    public static String toJSONString(Object object, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter filter, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, null, filter, features);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        context.configFilter(filters);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static String toJSONString(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        context.configFilter(filters);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriter writer = JSONWriter.of(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            String string = writer.toString();
            return string;
        }
    }

    public static byte[] toJSONBytes(Object object) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriterUTF8 writer = new JSONWriterUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                if (valueClass == JSONObject.class && writer.context.features == 0L) {
                    writer.write((JSONObject)object);
                } else {
                    ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                    objectWriter.write(writer, object, null, null, 0L);
                }
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, String format, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        if (format != null && !format.isEmpty()) {
            context.setDateFormat(format);
        }
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriterUTF8 writer = new JSONWriterUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter ... filters) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider);
        context.configFilter(filters);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriterUTF8 writer = new JSONWriterUTF8(context);){
            if (filters != null && filters.length != 0) {
                writer.context.configFilter(filters);
            }
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriterUTF8 writer = new JSONWriterUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, Filter[] filters, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        context.configFilter(filters);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriterUTF8 writer = new JSONWriterUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static byte[] toJSONBytes(Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        context.configFilter(filters);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        try (JSONWriterUTF8 writer = new JSONWriterUTF8(context);){
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            byte[] byArray = writer.getBytes();
            return byArray;
        }
    }

    public static int writeTo(OutputStream out, Object object) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException(e.getMessage(), e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, Filter[] filters, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        context.configFilter(filters);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException("JSON#writeTo cannot serialize '" + object + "' to 'OutputStream'", e);
            }
        }
    }

    public static int writeTo(OutputStream out, Object object, String format, Filter[] filters, JSONWriter.Feature ... features) {
        ObjectWriterProvider provider = JSONFactory.defaultObjectWriterProvider;
        JSONWriter.Context context = new JSONWriter.Context(provider, features);
        context.configFilter(filters);
        boolean fieldBased = (context.features & JSONWriter.Feature.FieldBased.mask) != 0L;
        JSONWriter writer = JSONWriter.ofUTF8(context);
        try {
            if (object == null) {
                writer.writeNull();
            } else {
                writer.rootObject = object;
                writer.path = JSONWriter.Path.ROOT;
                if (format != null && !format.isEmpty()) {
                    writer.context.setDateFormat(format);
                }
                if (filters != null && filters.length != 0) {
                    writer.context.configFilter(filters);
                }
                Class<?> valueClass = object.getClass();
                ObjectWriter objectWriter = provider.getObjectWriter(valueClass, valueClass, fieldBased);
                objectWriter.write(writer, object, null, null, 0L);
            }
            int n = writer.flushTo(out);
            if (writer != null) {
                writer.close();
            }
            return n;
        }
        catch (Throwable throwable) {
            try {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new JSONException("JSON#writeTo cannot serialize '" + object + "' to 'OutputStream'", e);
            }
        }
    }

    public static boolean isValid(String text) {
        if (text == null || text.isEmpty()) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(text);
        try {
            boolean bl;
            jsonReader.skipValue();
            boolean bl2 = bl = jsonReader.isEnd() && !jsonReader.comma;
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static boolean isValid(char[] chars) {
        if (chars == null || chars.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(chars);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidObject(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isObject()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(String text) {
        if (text == null) return false;
        if (text.isEmpty()) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(text);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static boolean isValid(byte[] bytes, Charset charset) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        return JSON.isValid(bytes, 0, bytes.length, charset);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isValidArray(byte[] bytes) {
        if (bytes == null) return false;
        if (bytes.length == 0) {
            return false;
        }
        try (JSONReader jsonReader = JSONReader.of(bytes);){
            if (!jsonReader.isArray()) {
                boolean bl = false;
                return bl;
            }
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            return bl;
        }
        catch (JSONException error) {
            return false;
        }
    }

    public static boolean isValid(byte[] bytes, int offset, int length, Charset charset) {
        if (bytes == null || bytes.length == 0 || length == 0) {
            return false;
        }
        JSONReader jsonReader = JSONReader.of(bytes, offset, length, charset);
        try {
            jsonReader.skipValue();
            boolean bl = jsonReader.isEnd();
            if (jsonReader != null) {
                jsonReader.close();
            }
            return bl;
        }
        catch (Throwable throwable) {
            try {
                if (jsonReader != null) {
                    try {
                        jsonReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (JSONException error) {
                return false;
            }
        }
    }

    public static Object toJSON(Object object) {
        return JSON.toJSON(object, null);
    }

    public static Object toJSON(Object object, JSONWriter.Feature ... features) {
        String str;
        Class<?> valueClass;
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject || object instanceof JSONArray) {
            return object;
        }
        JSONWriter.Context writeContext = features == null ? JSONFactory.createWriteContext() : JSONFactory.createWriteContext(features);
        ObjectWriter<?> objectWriter = writeContext.getObjectWriter(valueClass = object.getClass(), valueClass);
        if (objectWriter instanceof ObjectWriterAdapter && !writeContext.isEnabled(JSONWriter.Feature.ReferenceDetection)) {
            ObjectWriterAdapter objectWriterAdapter = (ObjectWriterAdapter)objectWriter;
            return objectWriterAdapter.toJSONObject(object, writeContext.features);
        }
        try (JSONWriter writer = JSONWriter.of(writeContext);){
            objectWriter.write(writer, object, null, null, writeContext.features);
            str = writer.toString();
        }
        catch (NullPointerException | NumberFormatException ex) {
            throw new JSONException("toJSONString error", ex);
        }
        return JSON.parse(str);
    }

    public static <T> T to(Class<T> clazz, Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof JSONObject) {
            return ((JSONObject)object).to(clazz, new JSONReader.Feature[0]);
        }
        return TypeUtils.cast(object, clazz, JSONFactory.defaultObjectReaderProvider);
    }

    public static <T> T toJavaObject(Object object, Class<T> clazz) {
        return JSON.to(clazz, object);
    }

    public static void mixIn(Class<?> target, Class<?> mixinSource) {
        JSONFactory.defaultObjectWriterProvider.mixIn(target, mixinSource);
        JSONFactory.defaultObjectReaderProvider.mixIn(target, mixinSource);
    }

    public static ObjectReader<?> register(Type type, ObjectReader<?> objectReader) {
        return JSONFactory.defaultObjectReaderProvider.register(type, objectReader);
    }

    public static ObjectReader<?> registerIfAbsent(Type type, ObjectReader<?> objectReader) {
        return JSONFactory.defaultObjectReaderProvider.registerIfAbsent(type, objectReader);
    }

    public static void registerSeeAlsoSubType(Class subTypeClass) {
        JSON.registerSeeAlsoSubType(subTypeClass, null);
    }

    public static void registerSeeAlsoSubType(Class subTypeClass, String subTypeClassName) {
        JSONFactory.defaultObjectReaderProvider.registerSeeAlsoSubType(subTypeClass, subTypeClassName);
    }

    public static ObjectWriter<?> register(Type type, ObjectWriter<?> objectWriter) {
        return JSONFactory.defaultObjectWriterProvider.register(type, objectWriter);
    }

    public static ObjectWriter<?> registerIfAbsent(Type type, ObjectWriter<?> objectWriter) {
        return JSONFactory.defaultObjectWriterProvider.registerIfAbsent(type, objectWriter);
    }

    public static void register(Class type, Filter filter) {
        boolean writerFilter;
        boolean bl = writerFilter = filter instanceof AfterFilter || filter instanceof BeforeFilter || filter instanceof ContextNameFilter || filter instanceof ContextValueFilter || filter instanceof LabelFilter || filter instanceof NameFilter || filter instanceof PropertyFilter || filter instanceof PropertyPreFilter || filter instanceof ValueFilter;
        if (writerFilter) {
            ObjectWriter objectWriter = JSONFactory.defaultObjectWriterProvider.getObjectWriter(type);
            objectWriter.setFilter(filter);
        }
    }

    public static void config(JSONReader.Feature ... features) {
        for (int i = 0; i < features.length; ++i) {
            JSONReader.Feature feature = features[i];
            if (feature == JSONReader.Feature.SupportAutoType) {
                throw new JSONException("not support config global autotype support");
            }
            JSONFactory.defaultReaderFeatures |= feature.mask;
        }
    }

    public static void config(JSONReader.Feature feature, boolean state) {
        if (feature == JSONReader.Feature.SupportAutoType && state) {
            throw new JSONException("not support config global autotype support");
        }
        JSONFactory.defaultReaderFeatures = state ? (JSONFactory.defaultReaderFeatures |= feature.mask) : (JSONFactory.defaultReaderFeatures &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isEnabled(JSONReader.Feature feature) {
        return (JSONFactory.defaultReaderFeatures & feature.mask) != 0L;
    }

    public static void configReaderDateFormat(String dateFormat) {
        JSONFactory.defaultReaderFormat = dateFormat;
    }

    public static void configWriterDateFormat(String dateFormat) {
        JSONFactory.defaultWriterFormat = dateFormat;
    }

    public static void configReaderZoneId(ZoneId zoneId) {
        JSONFactory.defaultReaderZoneId = zoneId;
    }

    public static void configWriterZoneId(ZoneId zoneId) {
        JSONFactory.defaultWriterZoneId = zoneId;
    }

    public static void config(JSONWriter.Feature ... features) {
        for (int i = 0; i < features.length; ++i) {
            JSONWriter.Feature feature = features[i];
            JSONFactory.defaultWriterFeatures |= feature.mask;
        }
    }

    public static void config(JSONWriter.Feature feature, boolean state) {
        JSONFactory.defaultWriterFeatures = state ? (JSONFactory.defaultWriterFeatures |= feature.mask) : (JSONFactory.defaultWriterFeatures &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static boolean isEnabled(JSONWriter.Feature feature) {
        return (JSONFactory.defaultWriterFeatures & feature.mask) != 0L;
    }

    public static <T> T copy(T object, JSONWriter.Feature ... features) {
        byte[] jsonbBytes;
        if (object == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        if (ObjectWriterProvider.isPrimitiveOrEnum(objectClass)) {
            return object;
        }
        boolean fieldBased = false;
        boolean beanToArray = false;
        long featuresValue = 0L;
        for (int i = 0; i < features.length; ++i) {
            JSONWriter.Feature feature = features[i];
            featuresValue |= feature.mask;
            if (feature == JSONWriter.Feature.FieldBased) {
                fieldBased = true;
                continue;
            }
            if (feature != JSONWriter.Feature.BeanToArray) continue;
            beanToArray = true;
        }
        ObjectWriter objectWriter = JSONFactory.defaultObjectWriterProvider.getObjectWriter(objectClass, objectClass, fieldBased);
        ObjectReader objectReader = JSONFactory.defaultObjectReaderProvider.getObjectReader(objectClass, fieldBased);
        if (objectWriter instanceof ObjectWriterAdapter && objectReader instanceof ObjectReaderBean) {
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            if (objectReader instanceof ObjectReaderNoneDefaultConstructor) {
                HashMap<String, Object> map = new HashMap<String, Object>(fieldWriters.size());
                for (int i = 0; i < fieldWriters.size(); ++i) {
                    FieldWriter fieldWriter = fieldWriters.get(i);
                    Object fieldValue = fieldWriter.getFieldValue(object);
                    map.put(fieldWriter.fieldName, fieldValue);
                }
                return objectReader.createInstance(map, featuresValue);
            }
            Object instance = objectReader.createInstance(featuresValue);
            for (int i = 0; i < fieldWriters.size(); ++i) {
                FieldWriter fieldWriter = fieldWriters.get(i);
                FieldReader fieldReader = objectReader.getFieldReader(fieldWriter.fieldName);
                if (fieldReader == null) continue;
                Object fieldValue = fieldWriter.getFieldValue(object);
                Object fieldValueCopied = JSON.copy(fieldValue, new JSONWriter.Feature[0]);
                fieldReader.accept(instance, fieldValueCopied);
            }
            return instance;
        }
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.config(JSONWriter.Feature.WriteClassName);
            objectWriter.writeJSONB(writer, object, null, null, 0L);
            jsonbBytes = writer.getBytes();
        }
        try (JSONReader jsonReader = JSONReader.ofJSONB(jsonbBytes, JSONReader.Feature.SupportAutoType, JSONReader.Feature.SupportClassForName);){
            if (beanToArray) {
                jsonReader.context.config(JSONReader.Feature.SupportArrayToBean);
            }
            Object t = objectReader.readJSONBObject(jsonReader, null, null, featuresValue);
            return t;
        }
    }

    public static <T> T copyTo(Object object, Class<T> targetClass, JSONWriter.Feature ... features) {
        byte[] jsonbBytes;
        if (object == null) {
            return null;
        }
        Class<?> objectClass = object.getClass();
        boolean fieldBased = false;
        boolean beanToArray = false;
        long featuresValue = 0L;
        for (int i = 0; i < features.length; ++i) {
            JSONWriter.Feature feature = features[i];
            featuresValue |= feature.mask;
            if (feature == JSONWriter.Feature.FieldBased) {
                fieldBased = true;
                continue;
            }
            if (feature != JSONWriter.Feature.BeanToArray) continue;
            beanToArray = true;
        }
        ObjectWriter objectWriter = JSONFactory.defaultObjectWriterProvider.getObjectWriter(objectClass, objectClass, fieldBased);
        ObjectReader objectReader = JSONFactory.defaultObjectReaderProvider.getObjectReader(targetClass, fieldBased);
        if (objectWriter instanceof ObjectWriterAdapter && objectReader instanceof ObjectReaderBean) {
            List<FieldWriter> fieldWriters = objectWriter.getFieldWriters();
            if (objectReader instanceof ObjectReaderNoneDefaultConstructor) {
                HashMap<String, Object> map = new HashMap<String, Object>(fieldWriters.size());
                for (int i = 0; i < fieldWriters.size(); ++i) {
                    FieldWriter fieldWriter = fieldWriters.get(i);
                    Object fieldValue = fieldWriter.getFieldValue(object);
                    map.put(fieldWriter.fieldName, fieldValue);
                }
                return objectReader.createInstance(map, featuresValue);
            }
            Object instance = objectReader.createInstance(featuresValue);
            for (int i = 0; i < fieldWriters.size(); ++i) {
                FieldWriter fieldWriter = fieldWriters.get(i);
                FieldReader fieldReader = objectReader.getFieldReader(fieldWriter.fieldName);
                if (fieldReader == null) continue;
                Object fieldValue = fieldWriter.getFieldValue(object);
                Object fieldValueCopied = fieldWriter.fieldClass == Date.class && fieldReader.fieldClass == String.class ? DateUtils.format((Date)fieldValue, fieldWriter.format) : (fieldWriter.fieldClass == LocalDate.class && fieldReader.fieldClass == String.class ? DateUtils.format((LocalDate)fieldValue, fieldWriter.format) : (fieldValue == null || fieldReader.supportAcceptType(fieldValue.getClass()) ? fieldValue : JSON.copy(fieldValue, new JSONWriter.Feature[0])));
                fieldReader.accept(instance, fieldValueCopied);
            }
            return instance;
        }
        try (JSONWriter writer = JSONWriter.ofJSONB(features);){
            writer.config(JSONWriter.Feature.WriteClassName);
            objectWriter.writeJSONB(writer, object, null, null, 0L);
            jsonbBytes = writer.getBytes();
        }
        try (JSONReader jsonReader = JSONReader.ofJSONB(jsonbBytes, JSONReader.Feature.SupportAutoType, JSONReader.Feature.SupportClassForName);){
            if (beanToArray) {
                jsonReader.context.config(JSONReader.Feature.SupportArrayToBean);
            }
            Object t = objectReader.readJSONBObject(jsonReader, null, null, 0L);
            return t;
        }
    }
}

