/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPathParser;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import java.util.ArrayList;
import java.util.List;

public class JSONPath {
    static final JSONPath ROOT = new JSONPath("$", new ArrayList<JSONPathSegment>(), true, false);
    static final JSONPath PREVIOUS = new JSONPath("#-1", new ArrayList<JSONPathSegment>(), false, true);
    static final JSONReader.Context PARSE_CONTEXT = JSONFactory.createReadContext();
    JSONReader.Context readerContext;
    JSONWriter.Context writerContext;
    final String path;
    final List<JSONPathSegment> segments;
    final boolean root;
    public final boolean previous;

    protected JSONPath(String path, List<JSONPathSegment> segments, boolean root, boolean previous) {
        this.path = path;
        this.segments = segments;
        this.root = root;
        this.previous = previous;
    }

    public final String toString() {
        return this.path;
    }

    public Object eval(Object root) {
        if (this.root) {
            return root;
        }
        Context context = null;
        int size = this.segments.size();
        if (size == 0) {
            return root;
        }
        for (int i = 0; i < size; ++i) {
            JSONPathSegment segment = this.segments.get(i);
            JSONPathSegment nextSegment = null;
            int nextIndex = i + 1;
            if (nextIndex < size) {
                nextSegment = this.segments.get(nextIndex);
            }
            context = new Context(this, context, segment, nextSegment, 0L);
            if (i == 0) {
                context.root = root;
            }
            segment.eval(context);
        }
        return context.value;
    }

    public static JSONPath of(String path) {
        if ("#-1".equals(path)) {
            return PREVIOUS;
        }
        return new JSONPathParser(path).parse();
    }

    static final class Context {
        final JSONPath path;
        final Context parent;
        final JSONPathSegment current;
        final JSONPathSegment next;
        final long readerFeatures;
        Object root;
        Object value;
        boolean eval;

        Context(JSONPath path, Context parent, JSONPathSegment current, JSONPathSegment next, long readerFeatures) {
            this.path = path;
            this.current = current;
            this.next = next;
            this.parent = parent;
            this.readerFeatures = readerFeatures;
        }
    }
}

