/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF8;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NameCacheEntry;
import com.alibaba.fastjson2.util.TypeUtils;
import java.nio.charset.StandardCharsets;
import sun.misc.Unsafe;

final class JSONReaderASCII
extends JSONReaderUTF8 {
    final String str;

    JSONReaderASCII(JSONReader.Context ctx, String str, byte[] bytes, int offset, int length) {
        super(ctx, str, bytes, offset, length);
        this.str = str;
        this.nameAscii = true;
    }

    @Override
    public void next() {
        int offset = this.offset;
        if (offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        byte[] bytes = this.bytes;
        byte ch = bytes[offset];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return;
            }
            ch = bytes[offset];
        }
        this.offset = offset + 1;
        this.ch = (char)(ch & 0xFF);
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    @Override
    public boolean nextIfObjectStart() {
        char ch = this.ch;
        if (ch != '{') {
            return false;
        }
        int offset = this.offset;
        if (offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        byte[] bytes = this.bytes;
        ch = bytes[offset++];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                this.ch = (char)26;
                this.offset = offset;
                return true;
            }
            ch = bytes[offset++];
        }
        this.ch = (char)(ch & 0xFF);
        this.offset = offset;
        if (this.ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfObjectEnd() {
        char ch = this.ch;
        if (ch == ']' || ch == '\u001a') {
            throw new JSONException(this.info("Illegal syntax: `" + (char)ch + '`'));
        }
        if (ch != '}') {
            return false;
        }
        int offset = this.offset;
        if (offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        byte[] bytes = this.bytes;
        ch = bytes[offset++];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                this.ch = (char)26;
                this.offset = offset;
                return true;
            }
            ch = bytes[offset++];
        }
        if (ch == ',') {
            this.comma = true;
            ch = bytes[offset++];
            while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                if (offset >= this.end) {
                    this.ch = (char)26;
                    this.offset = offset;
                    return true;
                }
                ch = bytes[offset++];
            }
        }
        this.ch = (char)(ch & 0xFF);
        this.offset = offset;
        if (this.ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfMatch(char m) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char ch = this.ch;
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (offset >= this.end) {
                ch = '\u001a';
                continue;
            }
            ch = bytes[offset++];
        }
        if (ch != m) {
            return false;
        }
        boolean bl = this.comma = m == ',';
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = bytes[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = bytes[offset];
        }
        this.offset = offset + 1;
        this.ch = (char)(ch & 0xFF);
        if (this.ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfComma() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char ch = this.ch;
        if (ch != ',') {
            return false;
        }
        this.comma = true;
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = bytes[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = bytes[offset];
        }
        this.offset = offset + 1;
        this.ch = (char)(ch & 0xFF);
        if (this.ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfArrayStart() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char ch = this.ch;
        if (ch != '[') {
            return false;
        }
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = bytes[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = bytes[offset];
        }
        this.offset = offset + 1;
        this.ch = (char)(ch & 0xFF);
        if (this.ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfArrayEnd() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char ch = this.ch;
        if (ch == '}' || ch == '\u001a') {
            throw new JSONException(this.info());
        }
        if (ch != ']') {
            return false;
        }
        if (offset >= this.end) {
            this.offset = offset;
            this.ch = (char)26;
            return true;
        }
        ch = bytes[offset];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= this.end) {
                this.offset = offset;
                this.ch = (char)26;
                return true;
            }
            ch = bytes[offset];
        }
        if (ch == ',') {
            this.comma = true;
            ch = bytes[++offset];
            while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                if (++offset >= this.end) {
                    this.offset = offset;
                    this.ch = (char)26;
                    return true;
                }
                ch = bytes[offset];
            }
        }
        this.offset = offset + 1;
        this.ch = (char)(ch & 0xFF);
        if (this.ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfNullOrEmptyString() {
        int ch;
        char first = this.ch;
        int end = this.end;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        if (first == 'n' && offset + 2 < end && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            offset += 3;
        } else if ((first == '\"' || first == '\'') && offset < end && bytes[offset] == first) {
            ++offset;
        } else {
            return false;
        }
        char c = (char)(ch = (char)(offset == end ? 26 : (char)bytes[offset]));
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                this.ch = (char)26;
                this.offset = offset;
                return true;
            }
            ch = (char)bytes[offset];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = ++offset >= end ? 26 : (int)((char)bytes[offset]);
        }
        if (offset >= end) {
            this.ch = (char)26;
            this.offset = offset;
            return true;
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                this.ch = (char)26;
                return true;
            }
            ch = (char)bytes[offset];
        }
        this.offset = offset + 1;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public long readFieldNameHashCode() {
        int c;
        long hashCode;
        byte c0;
        byte[] bytes = this.bytes;
        if (this.ch != '\"' && this.ch != '\'') {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderASCII.isFirstIdentifier(this.ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (this.ch == '}' || this.isNull()) {
                return -1L;
            }
            String errorMsg = this.ch == '[' && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + this.ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + this.ch;
            throw new JSONException(this.info(errorMsg));
        }
        char quote = this.ch;
        this.stringValue = null;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        if (offset + 9 < this.end && (c0 = bytes[offset]) != quote) {
            byte c1 = bytes[offset + 1];
            if (c1 == quote && c0 != 0 && c0 != 92) {
                nameValue = c0;
                this.nameLength = 1;
                this.nameEnd = offset + 1;
                offset += 2;
            } else {
                byte c2 = bytes[offset + 2];
                if (c2 == quote && c1 != 0 && c0 != 92 && c1 != 92) {
                    nameValue = (c1 << 8) + (c0 & 0xFF);
                    this.nameLength = 2;
                    this.nameEnd = offset + 2;
                    offset += 3;
                } else {
                    byte c3 = bytes[offset + 3];
                    if (c3 == quote && c2 != 0 && c0 != 92 && c1 != 92 && c2 != 92) {
                        nameValue = (c2 << 16) + ((c1 & 0xFF) << 8) + (c0 & 0xFF);
                        this.nameLength = 3;
                        this.nameEnd = offset + 3;
                        offset += 4;
                    } else {
                        byte c4 = bytes[offset + 4];
                        if (c4 == quote && c3 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92) {
                            nameValue = (c3 << 24) + ((c2 & 0xFF) << 16) + ((c1 & 0xFF) << 8) + (c0 & 0xFF);
                            this.nameLength = 4;
                            this.nameEnd = offset + 4;
                            offset += 5;
                        } else {
                            byte c5 = bytes[offset + 5];
                            if (c5 == quote && c4 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92) {
                                nameValue = ((long)c4 << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c0 & 0xFFL);
                                this.nameLength = 5;
                                this.nameEnd = offset + 5;
                                offset += 6;
                            } else {
                                byte c6 = bytes[offset + 6];
                                if (c6 == quote && c5 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92) {
                                    nameValue = ((long)c5 << 40) + (((long)c4 & 0xFFL) << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c0 & 0xFFL);
                                    this.nameLength = 6;
                                    this.nameEnd = offset + 6;
                                    offset += 7;
                                } else {
                                    byte c7 = bytes[offset + 7];
                                    if (c7 == quote && c6 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92) {
                                        nameValue = ((long)c6 << 48) + (((long)c5 & 0xFFL) << 40) + (((long)c4 & 0xFFL) << 32) + (((long)c3 & 0xFFL) << 24) + (((long)c2 & 0xFFL) << 16) + (((long)c1 & 0xFFL) << 8) + ((long)c0 & 0xFFL);
                                        this.nameLength = 7;
                                        this.nameEnd = offset + 7;
                                        offset += 8;
                                    } else if (bytes[offset + 8] == quote && c7 != 0 && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c7 != 92) {
                                        nameValue = JSONReaderASCII.getLong(bytes, offset);
                                        this.nameLength = 8;
                                        this.nameEnd = offset + 8;
                                        offset += 9;
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (nameValue == 0L) {
            int i = 0;
            while (offset < this.end) {
                char c2 = bytes[offset];
                if (c2 == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (c2 == '\\') {
                    this.nameEscape = true;
                    c2 = bytes[++offset];
                    switch (c2) {
                        case 'u': {
                            c2 = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c2 = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            c2 = this.char1(c2);
                        }
                    }
                }
                if (c2 > '\u00ff' || i >= 8 || i == 0 && c2 == '\u0000') {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)c2;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)c2 << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)c2 << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)c2 << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)c2) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)c2) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)c2) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)c2) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                char c3;
                if ((c3 = bytes[offset]) == '\\') {
                    this.nameEscape = true;
                    c3 = bytes[++offset];
                    switch (c3) {
                        case 'u': {
                            c3 = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c3 = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            c3 = this.char1(c3);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c3;
                    hashCode *= 1099511628211L;
                } else {
                    if (c3 == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    ++offset;
                    hashCode ^= (long)(c3 & 0xFF);
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        if (offset < this.end) {
            c = bytes[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = bytes[++offset];
            }
        } else {
            c = 26;
        }
        if (c != 58) {
            throw new JSONException(this.info("expect ':', but " + c));
        }
        c = ++offset == this.end ? 26 : bytes[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset];
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    public static int getInt(byte[] bytes, int off) {
        if (JDKUtils.BIG_ENDIAN) {
            return JDKUtils.UNSAFE.getInt(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)off);
        }
        return ((bytes[off + 3] & 0xFF) << 24) + ((bytes[off + 2] & 0xFF) << 16) + ((bytes[off + 1] & 0xFF) << 8) + (bytes[off] & 0xFF);
    }

    public static long getLong(byte[] bytes, int off) {
        if (JDKUtils.BIG_ENDIAN) {
            return JDKUtils.UNSAFE.getLong(bytes, (long)Unsafe.ARRAY_BYTE_BASE_OFFSET + (long)off);
        }
        return ((long)bytes[off + 7] << 56) + (((long)bytes[off + 6] & 0xFFL) << 48) + (((long)bytes[off + 5] & 0xFFL) << 40) + (((long)bytes[off + 4] & 0xFFL) << 32) + (((long)bytes[off + 3] & 0xFFL) << 24) + (((long)bytes[off + 2] & 0xFFL) << 16) + (((long)bytes[off + 1] & 0xFFL) << 8) + ((long)bytes[off] & 0xFFL);
    }

    @Override
    public long readValueHashCode() {
        long hashCode;
        if (this.ch != '\"' && this.ch != '\'') {
            return -1L;
        }
        byte[] bytes = this.bytes;
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long nameValue = 0L;
        int i = 0;
        while (offset < this.end) {
            char c = bytes[offset];
            if (c == quote) {
                if (i == 0) {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                this.nameLength = i;
                this.nameEnd = offset++;
                break;
            }
            if (c == '\\') {
                this.nameEscape = true;
                c = bytes[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        c = this.char1(c);
                    }
                }
            }
            if (c > '\u00ff' || i >= 8 || i == 0 && c == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)c;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++offset;
            ++i;
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = bytes[offset]) == '\\') {
                    this.nameEscape = true;
                    c = bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)c;
                    hashCode *= 1099511628211L;
                } else {
                    if (c == '\"') {
                        this.nameLength = i2;
                        this.nameEnd = offset++;
                        this.stringValue = null;
                        break;
                    }
                    ++offset;
                    hashCode ^= c < '\u0000' ? (long)(c & 0xFF) : (long)c;
                    hashCode *= 1099511628211L;
                }
                ++i2;
            }
        }
        int c = offset == this.end ? 26 : bytes[offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            c = bytes[++offset];
        }
        this.comma = c == 44;
        if (this.comma) {
            c = ++offset == this.end ? 26 : bytes[offset];
            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                c = bytes[++offset];
            }
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        int offset;
        byte[] bytes = this.bytes;
        long nameValue = 0L;
        int i = 0;
        for (offset = this.nameBegin; offset < this.end; ++offset) {
            byte c1;
            char c = bytes[offset];
            if (c == '\\') {
                c = bytes[++offset];
                switch (c) {
                    case 'u': {
                        c = JSONReaderASCII.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 'x': {
                        c = JSONReaderASCII.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if (c > '\u00ff' || c < '\u0000' || i >= 8 || i == 0 && c == '\u0000') {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            if ((c == '_' || c == '-' || c == ' ') && (c1 = bytes[offset + 1]) != 34 && c1 != 39 && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)c;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)c << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)c << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)c << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)c) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)c) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)c) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)c) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        long hashCode = -3750763034362895579L;
        while (offset < this.end) {
            byte c1;
            char c = bytes[offset];
            if (c == '\\') {
                c = bytes[++offset];
                switch (c) {
                    case 'u': {
                        c1 = bytes[++offset];
                        byte c2 = bytes[++offset];
                        byte c3 = bytes[++offset];
                        byte c4 = bytes[++offset];
                        c = JSONReaderASCII.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        c1 = bytes[++offset];
                        byte c2 = bytes[++offset];
                        c = JSONReaderASCII.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            if ((c == '_' || c == '-' || c == ' ') && (c1 = bytes[++offset]) != 34 && c1 != 39 && c1 != c) continue;
            if (c >= 'A' && c <= 'Z') {
                c = (char)(c + 32);
            }
            hashCode ^= c < '\u0000' ? (long)(c & 0xFF) : (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            if (this.str != null) {
                return this.str.substring(this.nameBegin, this.nameEnd);
            }
            return this.getLatin1String(this.nameBegin, length);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            char c = (char)(this.bytes[offset] & 0xFF);
            if (c == '\\') {
                c = (char)this.bytes[++offset];
                switch (c) {
                    case 'u': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderASCII.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderASCII.char2(c1, c2);
                        break;
                    }
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': {
                        break;
                    }
                    default: {
                        c = this.char1(c);
                        break;
                    }
                }
            } else if (c == '\"') break;
            chars[i] = c;
            ++offset;
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        if (this.ch != '\"' && this.ch != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderASCII.isFirstIdentifier(this.ch)) {
                return this.readFieldNameUnquote();
            }
            return null;
        }
        char quote = this.ch;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (offset < this.end) {
            byte c = this.bytes[offset];
            if (c == 92) {
                this.nameEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = this.bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    if (c != 58) {
                        throw new JSONException("syntax error : " + offset);
                    }
                    if (++offset >= this.end) {
                        this.ch = (char)26;
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = this.bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    this.offset = offset + 1;
                    this.ch = (char)c;
                    break;
                }
                ++offset;
            }
            ++i;
        }
        if (this.nameEnd < this.nameBegin) {
            throw new JSONException("syntax error : " + offset);
        }
        if (!this.nameEscape) {
            long nameValue0 = -1L;
            long nameValue1 = -1L;
            int length = this.nameEnd - this.nameBegin;
            switch (length) {
                case 1: {
                    return TypeUtils.toString(this.bytes[this.nameBegin]);
                }
                case 2: {
                    return TypeUtils.toString(this.bytes[this.nameBegin], this.bytes[this.nameBegin + 1]);
                }
                case 3: {
                    nameValue0 = (this.bytes[this.nameBegin + 2] << 16) + ((this.bytes[this.nameBegin + 1] & 0xFF) << 8) + (this.bytes[this.nameBegin] & 0xFF);
                    break;
                }
                case 4: {
                    nameValue0 = (this.bytes[this.nameBegin + 3] << 24) + ((this.bytes[this.nameBegin + 2] & 0xFF) << 16) + ((this.bytes[this.nameBegin + 1] & 0xFF) << 8) + (this.bytes[this.nameBegin] & 0xFF);
                    break;
                }
                case 5: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 4] << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 6: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 5] << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 7: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 6] << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 8: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 7] << 56) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    break;
                }
                case 9: {
                    nameValue0 = this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 8] << 56) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 1] & 0xFFL);
                    break;
                }
                case 10: {
                    nameValue0 = (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 9] << 56) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 2] & 0xFFL);
                    break;
                }
                case 11: {
                    nameValue0 = (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 10] << 56) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 3] & 0xFFL);
                    break;
                }
                case 12: {
                    nameValue0 = (this.bytes[this.nameBegin + 3] << 24) + (this.bytes[this.nameBegin + 2] << 16) + (this.bytes[this.nameBegin + 1] << 8) + this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 11] << 56) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 4] & 0xFFL);
                    break;
                }
                case 13: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 4] << 32) + ((long)this.bytes[this.nameBegin + 3] << 24) + ((long)this.bytes[this.nameBegin + 2] << 16) + ((long)this.bytes[this.nameBegin + 1] << 8) + (long)this.bytes[this.nameBegin];
                    nameValue1 = ((long)this.bytes[this.nameBegin + 12] << 56) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 5] & 0xFFL);
                    break;
                }
                case 14: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 5] << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    nameValue1 = ((long)this.bytes[this.nameBegin + 13] << 56) + (((long)this.bytes[this.nameBegin + 12] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 7] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 6] & 0xFFL);
                    break;
                }
                case 15: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 6] << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    nameValue1 = ((long)this.bytes[this.nameBegin + 14] << 56) + (((long)this.bytes[this.nameBegin + 13] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 12] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 8] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 7] & 0xFFL);
                    break;
                }
                case 16: {
                    nameValue0 = ((long)this.bytes[this.nameBegin + 7] << 56) + (((long)this.bytes[this.nameBegin + 6] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 5] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 4] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 3] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 2] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 1] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin] & 0xFFL);
                    nameValue1 = ((long)this.bytes[this.nameBegin + 15] << 56) + (((long)this.bytes[this.nameBegin + 14] & 0xFFL) << 48) + (((long)this.bytes[this.nameBegin + 13] & 0xFFL) << 40) + (((long)this.bytes[this.nameBegin + 12] & 0xFFL) << 32) + (((long)this.bytes[this.nameBegin + 11] & 0xFFL) << 24) + (((long)this.bytes[this.nameBegin + 10] & 0xFFL) << 16) + (((long)this.bytes[this.nameBegin + 9] & 0xFFL) << 8) + ((long)this.bytes[this.nameBegin + 8] & 0xFFL);
                    break;
                }
            }
            if (nameValue0 != -1L) {
                if (nameValue1 != -1L) {
                    long nameValue01 = nameValue0 ^ nameValue1;
                    int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                    JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                    if (entry == null) {
                        char[] chars = new char[length];
                        for (int i2 = 0; i2 < length; ++i2) {
                            chars[i2] = (char)(this.bytes[this.nameBegin + i2] & 0xFF);
                        }
                        String name = new String(chars);
                        JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                        return name;
                    }
                    if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                        return entry.name;
                    }
                } else {
                    int indexMask = (int)(nameValue0 ^ nameValue0 >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                    NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                    if (entry == null) {
                        char[] chars = new char[length];
                        for (int i3 = 0; i3 < length; ++i3) {
                            chars[i3] = (char)(this.bytes[this.nameBegin + i3] & 0xFF);
                        }
                        String name = new String(chars);
                        JSONFactory.NAME_CACHE[indexMask] = new NameCacheEntry(name, nameValue0);
                        return name;
                    }
                    if (entry.value == nameValue0) {
                        return entry.name;
                    }
                }
            }
        }
        return this.getFieldName();
    }

    @Override
    protected final void readString0() {
        String str;
        char quote = this.ch;
        int start = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            byte c;
            if ((c = this.bytes[this.offset]) == 92) {
                this.valueEscape = true;
                c = this.bytes[++this.offset];
                switch (c) {
                    case 117: {
                        this.offset += 4;
                        break;
                    }
                    case 120: {
                        this.offset += 2;
                        break;
                    }
                }
                ++this.offset;
            } else {
                if (c == quote) break;
                ++this.offset;
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            this.offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = (char)(this.bytes[this.offset] & 0xFF)) == '\\') {
                    c = (char)this.bytes[++this.offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++this.offset];
                            byte c2 = this.bytes[++this.offset];
                            byte c3 = this.bytes[++this.offset];
                            byte c4 = this.bytes[++this.offset];
                            c = JSONReaderASCII.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++this.offset];
                            byte c2 = this.bytes[++this.offset];
                            c = JSONReaderASCII.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i2] = c;
                ++this.offset;
                ++i2;
            }
            str = new String(chars);
        } else {
            str = this.getLatin1String(start, this.offset - start);
        }
        byte b = this.bytes[++this.offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.bytes[++this.offset];
        }
        this.comma = b == 44;
        if (this.comma) {
            ++this.offset;
            this.next();
        } else {
            ++this.offset;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int offset;
            block47: {
                byte quote = (byte)this.ch;
                int slash = 92;
                int start = offset = this.offset;
                boolean valueEscape = false;
                int i = 0;
                while (true) {
                    if (offset >= this.end) {
                        throw new JSONException("invalid escape character EOI");
                    }
                    byte c = this.bytes[offset];
                    if (c == 92) {
                        valueEscape = true;
                        c = this.bytes[++offset];
                        switch (c) {
                            case 117: {
                                offset += 4;
                                break;
                            }
                            case 120: {
                                offset += 2;
                                break;
                            }
                        }
                        ++offset;
                    } else {
                        if (c == quote) break;
                        ++offset;
                    }
                    ++i;
                }
                int valueLength = i;
                if (valueEscape) {
                    char[] chars = new char[valueLength];
                    offset = start;
                    int i2 = 0;
                    while (true) {
                        byte by;
                        if ((by = (byte)(this.bytes[offset] & 0xFF)) == 92) {
                            by = (char)this.bytes[++offset];
                            switch (by) {
                                case 117: {
                                    char c1 = (char)this.bytes[++offset];
                                    char c2 = (char)this.bytes[++offset];
                                    char c3 = (char)this.bytes[++offset];
                                    char c4 = (char)this.bytes[++offset];
                                    by = (byte)JSONReaderASCII.char4(c1, c2, c3, c4);
                                    break;
                                }
                                case 120: {
                                    char c1 = (char)this.bytes[++offset];
                                    char c2 = (char)this.bytes[++offset];
                                    by = (byte)JSONReaderASCII.char2(c1, c2);
                                    break;
                                }
                                case 34: 
                                case 92: {
                                    break;
                                }
                                case 98: {
                                    by = 8;
                                    break;
                                }
                                case 116: {
                                    by = 9;
                                    break;
                                }
                                case 110: {
                                    by = 10;
                                    break;
                                }
                                case 102: {
                                    by = 12;
                                    break;
                                }
                                case 114: {
                                    by = 13;
                                    break;
                                }
                                default: {
                                    by = (byte)this.char1(by);
                                    break;
                                }
                            }
                        } else if (by == quote) break;
                        chars[i2] = by;
                        ++offset;
                        ++i2;
                    }
                    str = new String(chars);
                } else if (this.str != null) {
                    str = this.str.substring(this.offset, offset);
                } else {
                    int strOff = this.offset;
                    int strlen = offset - strOff;
                    if (JDKUtils.ANDROID_SDK_INT < 34) {
                        void var10_20;
                        void var10_18;
                        char[] cArray = this.charBuf;
                        if (cArray == null) {
                            char[] cArray2 = JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
                            this.charBuf = cArray2;
                        }
                        if (var10_18 == null || ((void)var10_18).length < strlen) {
                            char[] cArray3 = new char[strlen];
                            this.charBuf = cArray3;
                        }
                        for (int i3 = 0; i3 < strlen; ++i3) {
                            var10_20[i3] = (char)(this.bytes[strOff + i3] & 0xFF);
                        }
                        str = new String((char[])var10_20, 0, strlen);
                    } else {
                        str = new String(this.bytes, strOff, strlen, StandardCharsets.ISO_8859_1);
                    }
                }
                if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                    str = str.trim();
                }
                if (++offset != this.end) {
                    int e = this.bytes[offset++];
                    while (e <= 32 && (1L << e & 0x100003700L) != 0L) {
                        if (offset != this.end) {
                            e = this.bytes[offset++];
                            continue;
                        }
                        break block47;
                    }
                    this.comma = e == 44;
                    if (this.comma) {
                        if (offset == this.end) {
                            e = 26;
                        } else {
                            e = this.bytes[offset++];
                            while (e <= 32 && (1L << e & 0x100003700L) != 0L) {
                                if (offset == this.end) {
                                    e = 26;
                                    break;
                                }
                                e = this.bytes[offset++];
                            }
                        }
                    }
                    this.ch = (char)e;
                    this.offset = offset;
                    return str;
                }
            }
            this.ch = (char)26;
            this.comma = false;
            this.offset = offset;
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException(this.info("illegal input : " + this.ch));
    }
}

