/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.time.Instant;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.lang.reflect.Type;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Locale;

final class ObjectWriterImplCalendar
extends DateTimeCodec
implements ObjectWriter {
    static final ObjectWriterImplCalendar INSTANCE = new ObjectWriterImplCalendar(null, null);

    public ObjectWriterImplCalendar(String format, Locale locale) {
        super(format, locale);
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        long millis = ((Calendar)object).getTimeInMillis();
        jsonWriter.writeMillis(millis);
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        String format;
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        JSONWriter.Context ctx = jsonWriter.context;
        Calendar calendar = (Calendar)object;
        long millis = calendar.getTimeInMillis();
        if (this.formatUnixTime || this.format == null && ctx.isDateFormatUnixTime()) {
            jsonWriter.writeInt64(millis / 1000L);
            return;
        }
        if (this.format == null && ctx.isDateFormatMillis()) {
            jsonWriter.writeInt64(millis);
            return;
        }
        ZoneId zoneId = ctx.getZoneId();
        Instant instant = Instant.ofEpochMilli(millis);
        ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
        int offsetSeconds = zdt.offsetSeconds;
        int year = zdt.dateTime.date.year;
        if (year >= 0 && year <= 9999) {
            String dateFormat;
            if (this.format == null && ctx.isDateFormatISO8601()) {
                short month = zdt.dateTime.date.monthValue;
                short dayOfMonth = zdt.dateTime.date.dayOfMonth;
                byte hour = zdt.dateTime.time.hour;
                byte minute = zdt.dateTime.time.minute;
                byte second = zdt.dateTime.time.second;
                int nano = zdt.dateTime.time.nano / 1000000;
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, nano, offsetSeconds, true);
                return;
            }
            String string = dateFormat = this.format == null ? ctx.getDateFormat() : this.format;
            if (dateFormat == null) {
                short month = zdt.dateTime.date.monthValue;
                short dayOfMonth = zdt.dateTime.date.dayOfMonth;
                byte hour = zdt.dateTime.time.hour;
                byte minute = zdt.dateTime.time.minute;
                byte second = zdt.dateTime.time.second;
                int nano = zdt.dateTime.time.nano;
                if (nano == 0) {
                    jsonWriter.writeDateTime19(year, month, dayOfMonth, hour, minute, second);
                } else {
                    jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, nano / 1000000, offsetSeconds, false);
                }
                return;
            }
        }
        if ((format = this.format) == null) {
            format = jsonWriter.context.getDateFormat();
        }
        SimpleDateFormat fmt = new SimpleDateFormat(format);
        String str = fmt.format(calendar.getTime());
        jsonWriter.writeString(str);
    }
}

