/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.util.function.Supplier;

final class ConstructorSupplier
implements Supplier {
    final Constructor constructor;
    final Class objectClass;
    final boolean useClassNewInstance;
    final int parameterCount;

    public ConstructorSupplier(Constructor constructor) {
        constructor.setAccessible(true);
        this.constructor = constructor;
        this.objectClass = this.constructor.getDeclaringClass();
        this.parameterCount = constructor.getParameterTypes().length;
        this.useClassNewInstance = this.parameterCount == 0 && Modifier.isPublic(constructor.getModifiers()) && Modifier.isPublic(this.objectClass.getModifiers());
    }

    public Object get() {
        try {
            if (this.useClassNewInstance) {
                return this.objectClass.newInstance();
            }
            if (this.parameterCount == 1) {
                return this.constructor.newInstance(new Object[1]);
            }
            return this.constructor.newInstance(new Object[0]);
        }
        catch (Throwable e) {
            throw new JSONException("create instance error", e);
        }
    }
}

