/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.function.Function;

public final class ObjectReaderImplListStr
implements ObjectReader {
    final Class listType;
    final Class instanceType;

    public ObjectReaderImplListStr(Class listType, Class instanceType) {
        this.listType = listType;
        this.instanceType = instanceType;
    }

    public Object createInstance(long features) {
        if (this.instanceType == ArrayList.class) {
            return new ArrayList();
        }
        if (this.instanceType == LinkedList.class) {
            return new LinkedList();
        }
        try {
            return this.instanceType.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new JSONException("create list error, type " + this.instanceType);
        }
    }

    public Object createInstance(Collection collection) {
        if (this.listType.isInstance(collection)) {
            boolean typeMatch = true;
            for (Object item : collection) {
                if (item instanceof String) continue;
                typeMatch = false;
                break;
            }
            if (typeMatch) {
                return collection;
            }
        }
        Collection typedList = (Collection)this.createInstance(0L);
        for (Object item : collection) {
            if (item == null || item instanceof String) {
                typedList.add(item);
                continue;
            }
            typedList.add(JSON.toJSONString(item));
        }
        return typedList;
    }

    public Class getObjectClass() {
        return this.listType;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Collection<Object> list;
        Class instanceType = this.instanceType;
        if (jsonReader.nextIfNull()) {
            return null;
        }
        ObjectReader objectReader = jsonReader.checkAutoType(this.listType, 0L, features);
        if (objectReader != null) {
            instanceType = objectReader.getObjectClass();
        }
        if (instanceType == ObjectReaderImplList.CLASS_ARRAYS_LIST) {
            int entryCnt = jsonReader.startArray();
            String[] array = new String[entryCnt];
            for (int i = 0; i < entryCnt; ++i) {
                array[i] = jsonReader.readString();
            }
            return Arrays.asList(array);
        }
        int entryCnt = jsonReader.startArray();
        Function<Collection, Collection> builder = null;
        if (instanceType == ArrayList.class) {
            list = entryCnt > 0 ? new ArrayList(entryCnt) : new ArrayList();
        } else if (instanceType == JSONArray.class) {
            list = entryCnt > 0 ? new JSONArray(entryCnt) : new JSONArray();
        } else if (instanceType == ObjectReaderImplList.CLASS_UNMODIFIABLE_COLLECTION) {
            list = new ArrayList();
            builder = Collections::unmodifiableCollection;
        } else if (instanceType == ObjectReaderImplList.CLASS_UNMODIFIABLE_LIST) {
            list = new ArrayList();
            builder = Collections::unmodifiableList;
        } else if (instanceType == ObjectReaderImplList.CLASS_UNMODIFIABLE_SET) {
            list = new LinkedHashSet();
            builder = Collections::unmodifiableSet;
        } else if (instanceType == ObjectReaderImplList.CLASS_SINGLETON) {
            list = new ArrayList();
            builder = collection -> Collections.singleton(collection.iterator().next());
        } else if (instanceType == ObjectReaderImplList.CLASS_SINGLETON_LIST) {
            list = new ArrayList();
            builder = collection -> Collections.singletonList(collection.iterator().next());
        } else if (instanceType != null && instanceType != this.listType) {
            try {
                list = (Collection)instanceType.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new JSONException(jsonReader.info("create instance error " + instanceType), e);
            }
        } else {
            list = (Collection)this.createInstance(jsonReader.context.getFeatures() | features);
        }
        for (int i = 0; i < entryCnt; ++i) {
            list.add(jsonReader.readString());
        }
        if (builder != null) {
            list = builder.apply(list);
        }
        return list;
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.jsonb) {
            return this.readJSONBObject(jsonReader, fieldType, fieldName, 0L);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        boolean set = jsonReader.nextIfSet();
        HashSet<String> list = set ? new HashSet<String>() : (Collection)this.createInstance(jsonReader.context.getFeatures() | features);
        char ch = jsonReader.current();
        if (ch == '[') {
            jsonReader.next();
            while (!jsonReader.nextIfArrayEnd()) {
                list.add(jsonReader.readString());
            }
        } else if (ch == '\"' || ch == '\'' || ch == '{') {
            String str = jsonReader.readString();
            if (!str.isEmpty()) {
                list.add(str);
            }
        } else {
            throw new JSONException(jsonReader.info());
        }
        jsonReader.nextIfComma();
        return list;
    }
}

