/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.PropertyNamingStrategy;
import com.alibaba.fastjson2.annotation.JSONCompiled;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.function.impl.StringToAny;
import com.alibaba.fastjson2.function.impl.ToAny;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplOptional;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.reader.ObjectReaderModule;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.sql.DataSource;
import javax.sql.RowSet;

public class ObjectReaderProvider {
    public static final boolean SAFE_MODE;
    static final String[] DENYS;
    static final String[] AUTO_TYPE_ACCEPT_LIST;
    static JSONReader.AutoTypeBeforeHandler DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    static Consumer<Class> DEFAULT_AUTO_TYPE_HANDLER;
    static boolean DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR;
    static ObjectReaderCachePair readerCache;
    final ConcurrentMap<Type, ObjectReader> cache = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Type, ObjectReader> cacheFieldBased = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Long, ObjectReader> hashCache = new ConcurrentHashMap<Long, ObjectReader>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final LRUAutoTypeCache autoTypeList = new LRUAutoTypeCache(1024);
    private ConcurrentMap<Type, Map<Type, Function>> typeConverts;
    public final ObjectReaderCreator creator;
    final ObjectReaderModule module = new ObjectReaderModule(this);
    private long[] denyHashCodes;
    private long[] acceptHashCodes;
    private JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler = DEFAULT_AUTO_TYPE_BEFORE_HANDLER;
    private Consumer<Class> autoTypeHandler = DEFAULT_AUTO_TYPE_HANDLER;

    public void registerIfAbsent(long hashCode, ObjectReader objectReader) {
        this.hashCache.put(hashCode, objectReader);
    }

    public void addAutoTypeAccept(String name) {
        long hash;
        if (name != null && name.length() != 0 && Arrays.binarySearch(this.acceptHashCodes, hash = Fnv.hashCode64(name)) < 0) {
            long[] hashCodes = new long[this.acceptHashCodes.length + 1];
            hashCodes[hashCodes.length - 1] = hash;
            System.arraycopy(this.acceptHashCodes, 0, hashCodes, 0, this.acceptHashCodes.length);
            Arrays.sort(hashCodes);
            this.acceptHashCodes = hashCodes;
        }
    }

    public void addAutoTypeDeny(String name) {
        long hash;
        if (name != null && name.length() != 0 && Arrays.binarySearch(this.denyHashCodes, hash = Fnv.hashCode64(name)) < 0) {
            long[] hashCodes = new long[this.denyHashCodes.length + 1];
            hashCodes[hashCodes.length - 1] = hash;
            System.arraycopy(this.denyHashCodes, 0, hashCodes, 0, this.denyHashCodes.length);
            Arrays.sort(hashCodes);
            this.denyHashCodes = hashCodes;
        }
    }

    public Consumer<Class> getAutoTypeHandler() {
        return this.autoTypeHandler;
    }

    public void setAutoTypeHandler(Consumer<Class> autoTypeHandler) {
        this.autoTypeHandler = autoTypeHandler;
    }

    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void cleanupMixIn() {
        this.mixInCache.clear();
    }

    public void mixIn(Class target, Class mixinSource) {
        if (mixinSource == null) {
            this.mixInCache.remove(target);
        } else {
            this.mixInCache.put(target, mixinSource);
        }
        this.cache.remove(target);
        this.cacheFieldBased.remove(target);
    }

    public void registerSeeAlsoSubType(Class subTypeClass) {
        this.registerSeeAlsoSubType(subTypeClass, null);
    }

    public void registerSeeAlsoSubType(Class subTypeClass, String subTypeClassName) {
        ObjectReaderSeeAlso readerSeeAlso;
        ObjectReaderSeeAlso readerSeeAlsoNew;
        Class superClass = subTypeClass.getSuperclass();
        if (superClass == null) {
            throw new JSONException("superclass is null");
        }
        ObjectReader objectReader = this.getObjectReader(superClass);
        if (objectReader instanceof ObjectReaderSeeAlso && (readerSeeAlsoNew = (readerSeeAlso = (ObjectReaderSeeAlso)objectReader).addSubType(subTypeClass, subTypeClassName)) != readerSeeAlso) {
            if (this.cache.containsKey(superClass)) {
                this.cache.put(superClass, readerSeeAlsoNew);
            } else {
                this.cacheFieldBased.put(subTypeClass, readerSeeAlsoNew);
            }
        }
    }

    public ObjectReader register(Type type, ObjectReader objectReader) {
        if (objectReader == null) {
            return (ObjectReader)this.cache.remove(type);
        }
        return this.cache.put(type, objectReader);
    }

    public ObjectReader registerIfAbsent(Type type, ObjectReader objectReader) {
        if (this.cache.containsKey(type)) {
            return (ObjectReader)this.cache.get(type);
        }
        return this.cache.put(type, objectReader);
    }

    public ObjectReader unregisterObjectReader(Type type) {
        return (ObjectReader)this.cache.remove(type);
    }

    public boolean unregisterObjectReader(Type type, ObjectReader reader) {
        return this.cache.remove(type, reader);
    }

    public void cleanup(Class objectClass) {
        this.mixInCache.remove(objectClass);
        this.cache.remove(objectClass);
        this.cacheFieldBased.remove(objectClass);
        BeanUtils.cleanupCache(objectClass);
    }

    static boolean match(Type objectType, ObjectReader objectReader, ClassLoader classLoader) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        if (objectClass != null && objectClass.getClassLoader() == classLoader) {
            return true;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)objectType;
            Type rawType = paramType.getRawType();
            if (ObjectReaderProvider.match(rawType, objectReader, classLoader)) {
                return true;
            }
            Type[] actualTypeArguments = paramType.getActualTypeArguments();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type argType = actualTypeArguments[i];
                if (!ObjectReaderProvider.match(argType, objectReader, classLoader)) continue;
                return true;
            }
        }
        if (objectReader instanceof ObjectReaderImplMapTyped) {
            ObjectReaderImplMapTyped mapTyped = (ObjectReaderImplMapTyped)objectReader;
            Class valueClass = mapTyped.valueClass;
            if (valueClass != null && valueClass.getClassLoader() == classLoader) {
                return true;
            }
            Class<?> keyClass = TypeUtils.getClass(mapTyped.keyType);
            return keyClass != null && keyClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderImplList) {
            ObjectReaderImplList list = (ObjectReaderImplList)objectReader;
            return list.itemClass != null && list.itemClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderImplOptional) {
            Class itemClass = ((ObjectReaderImplOptional)objectReader).itemClass;
            return itemClass != null && itemClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderAdapter) {
            FieldReader[] fieldReaders;
            for (FieldReader fieldReader : fieldReaders = ((ObjectReaderAdapter)objectReader).fieldReaders) {
                if (fieldReader.fieldClass != null && fieldReader.fieldClass.getClassLoader() == classLoader) {
                    return true;
                }
                Type fieldType = fieldReader.fieldType;
                if (!(fieldType instanceof ParameterizedType) || !ObjectReaderProvider.match(fieldType, null, classLoader)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanup(ClassLoader classLoader) {
        Map.Entry entry;
        Iterator it = this.mixInCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (((Class)entry.getKey()).getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader)) continue;
            it.remove();
        }
        it = this.cacheFieldBased.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader)) continue;
            it.remove();
        }
        BeanUtils.cleanupCache(classLoader);
    }

    public ObjectReaderCreator getCreator() {
        return this.creator;
    }

    public ObjectReaderProvider() {
        long[] hashCodes;
        this.denyHashCodes = new long[]{-9164606388214699518L, -8754006975464705441L, -8720046426850100497L, -8649961213709896794L, -8614556368991373401L, -8382625455832334425L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6088208984980396913L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4733542790109620528L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -803541446955902575L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1268707909007641340L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3058452313624178956L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3740226159580918099L, 3794316665763266033L, 3977090344859527316L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4215053018660518963L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5120543992130540564L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5916409771425455946L, 5944107969236155580L, 6007332606592876737L, 6090377589998869205L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7164889056054194741L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8488266005336625107L, 8537233257283452655L, 8735538376409180149L, 8838294710098435315L, 8861402923078831179L, 9140390920032557669L, 9140416208800006522L, 9144212112462101475L};
        if (AUTO_TYPE_ACCEPT_LIST == null) {
            hashCodes = new long[1];
        } else {
            hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
            for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
                hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
            }
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        this.creator = ObjectReaderCreator.INSTANCE;
        this.init();
    }

    public ObjectReaderProvider(ObjectReaderCreator creator) {
        long[] hashCodes;
        this.denyHashCodes = new long[]{-9164606388214699518L, -8754006975464705441L, -8720046426850100497L, -8649961213709896794L, -8614556368991373401L, -8382625455832334425L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6088208984980396913L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4733542790109620528L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -803541446955902575L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1268707909007641340L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3058452313624178956L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3740226159580918099L, 3794316665763266033L, 3977090344859527316L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4215053018660518963L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5120543992130540564L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5916409771425455946L, 5944107969236155580L, 6007332606592876737L, 6090377589998869205L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7164889056054194741L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8488266005336625107L, 8537233257283452655L, 8735538376409180149L, 8838294710098435315L, 8861402923078831179L, 9140390920032557669L, 9140416208800006522L, 9144212112462101475L};
        if (AUTO_TYPE_ACCEPT_LIST == null) {
            hashCodes = new long[1];
        } else {
            hashCodes = new long[AUTO_TYPE_ACCEPT_LIST.length + 1];
            for (int i = 0; i < AUTO_TYPE_ACCEPT_LIST.length; ++i) {
                hashCodes[i] = Fnv.hashCode64(AUTO_TYPE_ACCEPT_LIST[i]);
            }
        }
        hashCodes[hashCodes.length - 1] = -6293031534589903644L;
        Arrays.sort(hashCodes);
        this.acceptHashCodes = hashCodes;
        this.hashCache.put(ObjectArrayReader.TYPE_HASH_CODE, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        this.hashCache.put(Fnv.hashCode64(TypeUtils.getTypeName(HashMap.class)), ObjectReaderImplMap.INSTANCE);
        this.creator = creator;
        this.init();
    }

    void init() {
    }

    public Function getTypeConvert(Type from, Type to) {
        Map map;
        ConcurrentMap<Type, Map<Type, Function>> typeConverts = this.typeConverts;
        if (typeConverts == null) {
            typeConverts = this.typeConverts = ObjectReaderProvider.buildInitTypeConverts();
        }
        if ((map = (Map)typeConverts.get(from)) == null) {
            return null;
        }
        return (Function)map.get(to);
    }

    protected static ConcurrentMap<Type, Map<Type, Function>> buildInitTypeConverts() {
        ConcurrentHashMap<Type, Map<Type, Function>> typeConverts = new ConcurrentHashMap<Type, Map<Type, Function>>();
        ObjectReaderProvider.registerTypeConvert(typeConverts, Character.class, Character.TYPE, o -> o);
        Class[] numberTypes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Number.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, AtomicInteger.class, AtomicLong.class};
        ToAny TO_BOOLEAN = new ToAny(Boolean.class, null);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Boolean.class, TO_BOOLEAN);
        }
        ToAny TO_BOOLEAN_VALUE = new ToAny(Boolean.class, Boolean.FALSE);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Boolean.TYPE, TO_BOOLEAN_VALUE);
        }
        ToAny TO_STRING = new ToAny(String.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, String.class, TO_STRING);
        }
        ToAny TO_DECIMAL = new ToAny(BigDecimal.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, BigDecimal.class, TO_DECIMAL);
        }
        ToAny TO_BIGINT = new ToAny(BigInteger.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, BigInteger.class, TO_BIGINT);
        }
        ToAny TO_BYTE = new ToAny(Byte.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Byte.class, TO_BYTE);
        }
        ToAny TO_BYTE_VALUE = new ToAny(Byte.class, (byte)0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Byte.TYPE, TO_BYTE_VALUE);
        }
        ToAny TO_SHORT = new ToAny(Short.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Short.class, TO_SHORT);
        }
        ToAny TO_SHORT_VALUE = new ToAny(Short.class, (short)0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Short.TYPE, TO_SHORT_VALUE);
        }
        ToAny TO_INTEGER = new ToAny(Integer.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Integer.class, TO_INTEGER);
        }
        ToAny TO_INT = new ToAny(Integer.class, 0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Integer.TYPE, TO_INT);
        }
        ToAny TO_LONG = new ToAny(Long.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Long.class, TO_LONG);
        }
        ToAny TO_LONG_VALUE = new ToAny(Long.class, 0L);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Long.TYPE, TO_LONG_VALUE);
        }
        ToAny TO_FLOAT = new ToAny(Float.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Float.class, TO_FLOAT);
        }
        ToAny TO_FLOAT_VALUE = new ToAny(Float.class, Float.valueOf(0.0f));
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Float.TYPE, TO_FLOAT_VALUE);
        }
        ToAny TO_DOUBLE = new ToAny(Double.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Double.class, TO_DOUBLE);
        }
        ToAny TO_DOUBLE_VALUE = new ToAny(Double.class, 0.0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Double.TYPE, TO_DOUBLE_VALUE);
        }
        ToAny TO_NUMBER = new ToAny(Number.class, 0.0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Number.class, TO_NUMBER);
        }
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Character.TYPE, new StringToAny(Character.TYPE, Character.valueOf('0')));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Boolean.TYPE, new StringToAny(Boolean.TYPE, false));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Float.TYPE, new StringToAny(Float.TYPE, Float.valueOf(0.0f)));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Double.TYPE, new StringToAny(Double.TYPE, 0.0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Byte.TYPE, new StringToAny(Byte.TYPE, (byte)0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Short.TYPE, new StringToAny(Short.TYPE, (short)0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Integer.TYPE, new StringToAny(Integer.TYPE, 0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Long.TYPE, new StringToAny(Long.TYPE, 0L));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Character.class, new StringToAny(Character.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Boolean.class, new StringToAny(Boolean.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Double.class, new StringToAny(Double.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Float.class, new StringToAny(Float.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Byte.class, new StringToAny(Byte.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Short.class, new StringToAny(Short.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Integer.class, new StringToAny(Integer.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Long.class, new StringToAny(Long.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, BigDecimal.class, new StringToAny(BigDecimal.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, BigInteger.class, new StringToAny(BigInteger.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Number.class, new StringToAny(BigDecimal.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Collection.class, new StringToAny(Collection.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, List.class, new StringToAny(List.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, JSONArray.class, new StringToAny(JSONArray.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, Boolean.class, Boolean.TYPE, o -> o);
        Function<Object, Object> function = o -> o == null || "null".equals(o) || "".equals(o) ? null : UUID.fromString((String)o);
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, UUID.class, function);
        return typeConverts;
    }

    static Function registerTypeConvert(ConcurrentMap<Type, Map<Type, Function>> typeConverts, Type from, Type to, Function typeConvert) {
        Map map = (Map)typeConverts.get(from);
        if (map == null) {
            typeConverts.put(from, new ConcurrentHashMap());
            map = (Map)typeConverts.get(from);
        }
        return map.put(to, typeConvert);
    }

    public ObjectReader getObjectReader(long hashCode) {
        Long hashCodeObj;
        ObjectReader objectReader;
        ObjectReaderCachePair pair = readerCache;
        if (pair != null) {
            if (pair.hashCode == hashCode) {
                return pair.reader;
            }
            if (pair.missCount++ > 16) {
                readerCache = null;
            }
        }
        if ((objectReader = (ObjectReader)this.hashCache.get(hashCodeObj = new Long(hashCode))) != null && readerCache == null) {
            readerCache = new ObjectReaderCachePair(hashCode, objectReader);
        }
        return objectReader;
    }

    public ObjectReader getObjectReader(String typeName, Class<?> expectClass, long features) {
        Class<?> autoTypeClass = this.checkAutoType(typeName, expectClass, features);
        if (autoTypeClass == null) {
            return null;
        }
        boolean fieldBased = (features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.getObjectReader(autoTypeClass, fieldBased);
        if (autoTypeClass != expectClass) {
            this.registerIfAbsent(Fnv.hashCode64(typeName), objectReader);
        }
        return objectReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void afterAutoType(String typeName, Class type) {
        if (this.autoTypeHandler != null) {
            this.autoTypeHandler.accept(type);
        }
        LRUAutoTypeCache lRUAutoTypeCache = this.autoTypeList;
        synchronized (lRUAutoTypeCache) {
            this.autoTypeList.put(typeName, new Date());
        }
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass, long features) {
        Class clazz;
        int ch;
        int i;
        long hash;
        boolean autoTypeSupport;
        Class<?> resolvedClass;
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        if (this.autoTypeBeforeHandler != null && (resolvedClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            this.afterAutoType(typeName, resolvedClass);
            return resolvedClass;
        }
        if (SAFE_MODE) {
            return null;
        }
        int typeNameLength = typeName.length();
        if (typeNameLength >= 192) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (typeName.charAt(0) == '[') {
            String componentTypeName = typeName.substring(1);
            this.checkAutoType(componentTypeName, null, features);
        }
        if (expectClass != null && expectClass.getName().equals(typeName)) {
            this.afterAutoType(typeName, expectClass);
            return expectClass;
        }
        boolean bl = autoTypeSupport = (features & JSONReader.Feature.SupportAutoType.mask) != 0L;
        if (autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) >= 0 && (clazz = TypeUtils.loadClass(typeName)) != null) {
                    if (expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                        throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                    }
                    this.afterAutoType(typeName, clazz);
                    return clazz;
                }
                if (Arrays.binarySearch(this.denyHashCodes, hash) < 0 || TypeUtils.getMapping(typeName) != null) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if (!autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.denyHashCodes, hash *= 1099511628211L) >= 0) {
                    throw new JSONException("autoType is not support. " + typeName);
                }
                if (Arrays.binarySearch(this.acceptHashCodes, hash) < 0) continue;
                clazz = TypeUtils.loadClass(typeName);
                if (clazz != null && expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                this.afterAutoType(typeName, clazz);
                return clazz;
            }
        }
        if (!autoTypeSupport) {
            return null;
        }
        clazz = TypeUtils.getMapping(typeName);
        if (clazz != null) {
            if (expectClass != null && expectClass != Object.class && clazz != HashMap.class && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            this.afterAutoType(typeName, clazz);
            return clazz;
        }
        clazz = TypeUtils.loadClass(typeName);
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || DataSource.class.isAssignableFrom(clazz) || RowSet.class.isAssignableFrom(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    this.afterAutoType(typeName, clazz);
                    return clazz;
                }
                if ((features & JSONReader.Feature.IgnoreAutoTypeNotMatch.mask) != 0L) {
                    return expectClass;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        this.afterAutoType(typeName, clazz);
        return clazz;
    }

    public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
        this.module.getBeanInfo(beanInfo, objectClass);
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
        this.module.getFieldInfo(fieldInfo, objectClass, field);
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Annotation[][] parameterAnnotations) {
        this.module.getFieldInfo(fieldInfo, objectClass, constructor, paramIndex, parameterAnnotations);
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex) {
        this.module.getFieldInfo(fieldInfo, objectClass, method, paramIndex);
    }

    public ObjectReader getObjectReader(Type objectType) {
        return this.getObjectReader(objectType, false);
    }

    public ObjectReader getObjectReader(Type objectType, boolean fieldBased) {
        ObjectReader previous;
        Class<?> objectClass;
        ObjectReader boundObjectReader;
        Type bound;
        Type[] bounds;
        Type[] upperBounds;
        ObjectReader objectReader;
        if (objectType == null) {
            objectType = Object.class;
        }
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectType) : (ObjectReader)this.cache.get(objectType);
        if (objectReader == null && objectType instanceof WildcardType && (upperBounds = ((WildcardType)objectType).getUpperBounds()).length == 1) {
            Type upperBoundType = upperBounds[0];
            ObjectReader objectReader3 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(upperBoundType) : (ObjectReader)this.cache.get(upperBoundType);
        }
        if (objectReader != null) {
            return objectReader;
        }
        objectReader = this.module.getObjectReader(this, (Type)objectType);
        if (objectReader != null) {
            ObjectReader previous2;
            ObjectReader objectReader4 = previous2 = fieldBased ? this.cacheFieldBased.put((Type)objectType, objectReader) : this.cache.put((Type)objectType, objectReader);
            if (previous2 != null) {
                objectReader = previous2;
            }
            return objectReader;
        }
        if (objectType instanceof TypeVariable && (bounds = ((TypeVariable)objectType).getBounds()).length > 0 && (bound = bounds[0]) instanceof Class && (boundObjectReader = this.getObjectReader(bound, fieldBased)) != null) {
            ObjectReader previous3 = this.getPreviousObjectReader(fieldBased, (Type)objectType, boundObjectReader);
            if (previous3 != null) {
                boundObjectReader = previous3;
            }
            return boundObjectReader;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (rawType instanceof Class) {
                ObjectReader rawClassReader;
                Class rawClass = (Class)rawType;
                boolean generic = false;
                for (Class clazz = rawClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    if (clazz.getTypeParameters().length <= 0) continue;
                    generic = true;
                    break;
                }
                if (!(typeArguments.length != 0 && generic || (rawClassReader = this.getObjectReader(rawClass, fieldBased)) == null)) {
                    ObjectReader previous4 = this.getPreviousObjectReader(fieldBased, (Type)objectType, rawClassReader);
                    if (previous4 != null) {
                        rawClassReader = previous4;
                    }
                    return rawClassReader;
                }
            }
        }
        if ((objectClass = TypeUtils.getMapping((Type)objectType)).isAnnotationPresent(JSONCompiled.class)) {
            String codeGenClassName = objectClass.getName() + "_FASTJOSNReader";
            ClassLoader classLoader = objectClass.getClassLoader();
            try {
                Class<?> loadedClass = classLoader.loadClass(codeGenClassName);
                if (ObjectReader.class.isAssignableFrom(loadedClass)) {
                    objectReader = (ObjectReader)loadedClass.newInstance();
                }
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        if (objectReader == null) {
            ObjectReaderCreator creator = this.getCreator();
            objectReader = creator.createObjectReader(objectClass, (Type)objectType, fieldBased, this);
        }
        if ((previous = this.getPreviousObjectReader(fieldBased, (Type)objectType, objectReader)) != null) {
            objectReader = previous;
        }
        return objectReader;
    }

    private ObjectReader getPreviousObjectReader(boolean fieldBased, Type objectType, ObjectReader boundObjectReader) {
        return fieldBased ? this.cacheFieldBased.put(objectType, boundObjectReader) : this.cache.put(objectType, boundObjectReader);
    }

    public JSONReader.AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public Map<String, Date> getAutoTypeList() {
        return this.autoTypeList;
    }

    public void setAutoTypeBeforeHandler(JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }

    public FieldReader createFieldReader(Class objectClass, String fieldName, long readerFeatures) {
        ObjectReader objectReader;
        boolean fieldBased = (readerFeatures & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectClass) : (ObjectReader)this.cache.get(objectClass);
        if (objectReader != null) {
            return objectReader.getFieldReader(fieldName);
        }
        AtomicReference fieldRef = new AtomicReference();
        long nameHashLCase = Fnv.hashCode64LCase(fieldName);
        BeanUtils.fields(objectClass, field -> {
            if (nameHashLCase == Fnv.hashCode64LCase(field.getName())) {
                fieldRef.set(field);
            }
        });
        Field field2 = (Field)fieldRef.get();
        if (field2 != null) {
            return this.creator.createFieldReader(fieldName, null, field2.getType(), field2);
        }
        AtomicReference methodRef = new AtomicReference();
        BeanUtils.setters(objectClass, method -> {
            String setterName = BeanUtils.setterName(method.getName(), PropertyNamingStrategy.CamelCase.name());
            if (nameHashLCase == Fnv.hashCode64LCase(setterName)) {
                methodRef.set(method);
            }
        });
        Method method2 = (Method)methodRef.get();
        if (method2 != null) {
            Class<?>[] params = method2.getParameterTypes();
            Class<?> fieldClass = params[0];
            return this.creator.createFieldReaderMethod(objectClass, fieldName, null, fieldClass, fieldClass, method2);
        }
        return null;
    }

    static {
        Class handlerClass;
        String property = System.getProperty("fastjson2.parser.deny");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.parser.deny");
        }
        DENYS = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeAccept");
        if (property == null) {
            property = JSONFactory.getProperty("fastjson2.autoTypeAccept");
        }
        AUTO_TYPE_ACCEPT_LIST = property != null && property.length() > 0 ? property.split(",") : new String[0];
        property = System.getProperty("fastjson2.autoTypeBeforeHandler");
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeBeforeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_BEFORE_HANDLER = (JSONReader.AutoTypeBeforeHandler)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson2.autoTypeHandler")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.autoTypeHandler");
        }
        if (property != null) {
            property = property.trim();
        }
        if (property != null && !property.isEmpty() && (handlerClass = TypeUtils.loadClass(property)) != null) {
            try {
                DEFAULT_AUTO_TYPE_HANDLER = (Consumer)handlerClass.newInstance();
            }
            catch (Exception ignored) {
                DEFAULT_AUTO_TYPE_HANDLER_INIT_ERROR = true;
            }
        }
        if ((property = System.getProperty("fastjson.parser.safeMode")) == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = System.getProperty("fastjson2.parser.safeMode");
        }
        if (property == null || property.isEmpty()) {
            property = JSONFactory.getProperty("fastjson2.parser.safeMode");
        }
        if (property != null) {
            property = property.trim();
        }
        SAFE_MODE = "true".equals(property);
    }

    static class LRUAutoTypeCache
    extends LinkedHashMap<String, Date> {
        private final int maxSize;

        public LRUAutoTypeCache(int maxSize) {
            super(16, 0.75f, false);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Date> eldest) {
            return this.size() > this.maxSize;
        }
    }

    static class ObjectReaderCachePair {
        final long hashCode;
        final ObjectReader reader;
        volatile int missCount;

        public ObjectReaderCachePair(long hashCode, ObjectReader reader) {
            this.hashCode = hashCode;
            this.reader = reader;
        }
    }
}

