/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.BeforeFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public final class ObjectWriterImplMap
extends ObjectWriterPrimitiveImpl {
    static final byte[] TYPE_NAME_JSONObject1O = JSONB.toBytes("JO10");
    static final long TYPE_HASH_JSONObject1O = Fnv.hashCode64("JO10");
    static final ObjectWriterImplMap INSTANCE = new ObjectWriterImplMap((Type)((Object)String.class), (Type)((Object)Object.class), JSONObject.class, (Type)((Object)JSONObject.class), 0L);
    static final ObjectWriterImplMap INSTANCE_1x = TypeUtils.CLASS_JSON_OBJECT_1x == null ? null : new ObjectWriterImplMap((Type)((Object)String.class), (Type)((Object)Object.class), TypeUtils.CLASS_JSON_OBJECT_1x, TypeUtils.CLASS_JSON_OBJECT_1x, 0L);
    final Type objectType;
    final Class objectClass;
    final Type keyType;
    final Type valueType;
    final boolean valueTypeRefDetect;
    volatile ObjectWriter keyWriter;
    volatile ObjectWriter valueWriter;
    final byte[] jsonbTypeInfo;
    final long typeNameHash;
    final long features;
    final boolean jsonObject1;
    final Field jsonObject1InnerMap;
    long jsonObject1InnerMapOffset = -1L;
    final char[] typeInfoUTF16;
    final byte[] typeInfoUTF8;

    public ObjectWriterImplMap(Class objectClass, long features) {
        this(null, null, objectClass, objectClass, features);
    }

    public ObjectWriterImplMap(Type keyType, Type valueType, Class objectClass, Type objectType, long features) {
        this.keyType = keyType;
        this.valueType = valueType;
        this.objectClass = objectClass;
        this.objectType = objectType;
        this.features = features;
        this.valueTypeRefDetect = valueType == null ? true : !ObjectWriterProvider.isNotReferenceDetect(TypeUtils.getClass(valueType));
        String typeName = TypeUtils.getTypeName(objectClass);
        String typeInfoStr = "\"@type\":\"" + objectClass.getName() + "\"";
        this.typeInfoUTF16 = typeInfoStr.toCharArray();
        this.typeInfoUTF8 = typeInfoStr.getBytes(StandardCharsets.UTF_8);
        this.jsonObject1 = "JO1".equals(typeName);
        this.jsonbTypeInfo = JSONB.toBytes(typeName);
        this.typeNameHash = Fnv.hashCode64(typeName);
        if (this.jsonObject1) {
            this.jsonObject1InnerMap = BeanUtils.getDeclaredField(objectClass, "map");
            if (this.jsonObject1InnerMap != null) {
                this.jsonObject1InnerMap.setAccessible(true);
                this.jsonObject1InnerMapOffset = JDKUtils.UNSAFE.objectFieldOffset(this.jsonObject1InnerMap);
            }
        } else {
            this.jsonObject1InnerMap = null;
        }
    }

    public static ObjectWriterImplMap of(Class objectClass) {
        if (objectClass == JSONObject.class) {
            return INSTANCE;
        }
        if (objectClass == TypeUtils.CLASS_JSON_OBJECT_1x) {
            return INSTANCE_1x;
        }
        return new ObjectWriterImplMap(null, null, objectClass, objectClass, 0L);
    }

    public static ObjectWriterImplMap of(Type type) {
        Class<?> objectClass = TypeUtils.getClass(type);
        return new ObjectWriterImplMap(objectClass, 0L);
    }

    public static ObjectWriterImplMap of(Type type, Class defineClass) {
        Type keyType = null;
        Type valueType = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 2) {
                keyType = actualTypeArguments[0];
                valueType = actualTypeArguments[1];
            }
        }
        return new ObjectWriterImplMap(keyType, valueType, defineClass, type, 0L);
    }

    @Override
    public void writeArrayMappingJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        Map map = (Map)object;
        jsonWriter.startObject();
        boolean writeNulls = jsonWriter.isWriteNulls();
        for (Map.Entry entry : map.entrySet()) {
            String key = (String)entry.getKey();
            Object value = entry.getValue();
            if (value == null) {
                if (!writeNulls) continue;
                jsonWriter.writeString(key);
                jsonWriter.writeNull();
                continue;
            }
            jsonWriter.writeString(key);
            Class<?> valueType = value.getClass();
            if (valueType == String.class) {
                jsonWriter.writeString((String)value);
                continue;
            }
            ObjectWriter valueWriter = jsonWriter.getObjectWriter(valueType);
            valueWriter.writeJSONB(jsonWriter, value, key, this.valueType, this.features);
        }
        jsonWriter.endObject();
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (fieldType == this.objectType && jsonWriter.isWriteMapTypeInfo(object, this.objectClass, features) || jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
            ordered = false;
            if (this.jsonObject1InnerMap != null) {
                if (this.jsonObject1InnerMapOffset != -1L) {
                    innerMap = JDKUtils.UNSAFE.getObject(object, this.jsonObject1InnerMapOffset);
                    ordered = innerMap instanceof LinkedHashMap;
                } else {
                    try {
                        innerMap = this.jsonObject1InnerMap.get(object);
                        ordered = innerMap instanceof LinkedHashMap;
                    }
                    catch (IllegalAccessException innerMap) {
                        // empty catch block
                    }
                }
            }
            if (ordered) {
                jsonWriter.writeTypeName(ObjectWriterImplMap.TYPE_NAME_JSONObject1O, ObjectWriterImplMap.TYPE_HASH_JSONObject1O);
            } else {
                jsonWriter.writeTypeName(this.jsonbTypeInfo, this.typeNameHash);
            }
        }
        map = (Map)object;
        context = jsonWriter.context;
        jsonWriter.startObject();
        fieldValueType = this.valueType;
        if (fieldType == this.objectType) {
            fieldValueType = this.valueType;
        } else if (fieldType instanceof ParameterizedType && (actualTypeArguments = ((ParameterizedType)fieldType).getActualTypeArguments()).length == 2) {
            fieldValueType = actualTypeArguments[1];
        }
        contextFeatures = context.getFeatures();
        writeNulls = (contextFeatures & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L;
        fieldBased = (contextFeatures & JSONWriter.Feature.FieldBased.mask) != 0L;
        provider = context.provider;
        itemClass = null;
        itemWriter = null;
        contextRefDetect = (contextFeatures & JSONWriter.Feature.ReferenceDetection.mask) != 0L;
        i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            block45: {
                block51: {
                    block50: {
                        block49: {
                            block48: {
                                block46: {
                                    block47: {
                                        block44: {
                                            entryKey = entry.getKey();
                                            value = entry.getValue();
                                            if (value != null) break block44;
                                            if (writeNulls) {
                                                if (entryKey instanceof String) {
                                                    jsonWriter.writeString((String)entryKey);
                                                } else {
                                                    entryKeyClass = entryKey.getClass();
                                                    keyRefDetect = contextRefDetect != false && ObjectWriterProvider.isNotReferenceDetect(entryKeyClass) == false;
                                                    refPath = null;
                                                    if (keyRefDetect) {
                                                        jsonWriter.setPath(i, entry);
                                                        refPath = jsonWriter.setPath("key", entryKey);
                                                    }
                                                    if (refPath != null) {
                                                        jsonWriter.writeReference(refPath);
                                                    } else {
                                                        keyWriter = provider.getObjectWriter(entryKeyClass, entryKeyClass, fieldBased);
                                                        keyWriter.writeJSONB(jsonWriter, entryKey, null, null, 0L);
                                                    }
                                                    if (keyRefDetect) {
                                                        jsonWriter.popPath(entry);
                                                        jsonWriter.popPath(entryKey);
                                                    }
                                                }
                                                jsonWriter.writeNull();
                                            }
                                            break block45;
                                        }
                                        if (!(entryKey instanceof String) && (contextFeatures & JSONWriter.Feature.WriteClassName.mask) != 0L) break block46;
                                        key = entryKey instanceof String != false ? (String)entryKey : entryKey.toString();
                                        if (jsonWriter.symbolTable == null) break block47;
                                        jsonWriter.writeSymbol(key);
                                        if (!(value instanceof String)) break block48;
                                        jsonWriter.writeSymbol((String)value);
                                        break block45;
                                    }
                                    jsonWriter.writeString(key);
                                    break block48;
                                }
                                if (entryKey == null) {
                                    jsonWriter.writeNull();
                                } else {
                                    if (contextRefDetect) {
                                        jsonWriter.config(JSONWriter.Feature.ReferenceDetection, false);
                                    }
                                    entryKeyClass = entryKey.getClass();
                                    keyWriter = provider.getObjectWriter(entryKeyClass, entryKeyClass, fieldBased);
                                    keyWriter.writeJSONB(jsonWriter, entryKey, null, null, 0L);
                                    if (contextRefDetect) {
                                        jsonWriter.config(JSONWriter.Feature.ReferenceDetection, true);
                                    }
                                }
                            }
                            valueClass = value.getClass();
                            if (valueClass != String.class) break block49;
                            jsonWriter.writeString((String)value);
                            break block45;
                        }
                        if (valueClass != Integer.class) break block50;
                        jsonWriter.writeInt32((Integer)value);
                        break block45;
                    }
                    if (valueClass != Long.class) break block51;
                    jsonWriter.writeInt64((Long)value);
                    break block45;
                }
                valueRefDetecChanged = false;
                if (valueClass == this.valueType) {
                    valueRefDetect = contextRefDetect != false && this.valueTypeRefDetect != false;
                } else {
                    v0 = valueRefDetect = contextRefDetect != false && ObjectWriterProvider.isNotReferenceDetect(valueClass) == false;
                }
                if (!valueRefDetect) ** GOTO lbl-1000
                if (value == object) {
                    jsonWriter.writeReference("..");
                } else {
                    if (entryKey instanceof String) {
                        refPath = jsonWriter.setPath((String)entryKey, value);
                    } else if (ObjectWriterProvider.isPrimitiveOrEnum(entryKey.getClass())) {
                        refPath = jsonWriter.setPath(entryKey.toString(), value);
                    } else if (map.size() != 1 && !(map instanceof SortedMap) && !(map instanceof LinkedHashMap)) {
                        refPath = null;
                        jsonWriter.config(JSONWriter.Feature.ReferenceDetection, false);
                        valueRefDetecChanged = true;
                        valueRefDetect = false;
                    } else {
                        refPath = jsonWriter.setPath(i, value);
                    }
                    if (refPath != null) {
                        jsonWriter.writeReference(refPath);
                        jsonWriter.popPath(value);
                    } else lbl-1000:
                    // 2 sources

                    {
                        if (valueClass == this.valueType && this.valueWriter != null) {
                            valueWriter = this.valueWriter;
                        } else if (itemClass == valueClass) {
                            valueWriter = itemWriter;
                        } else {
                            valueWriter = valueClass == JSONObject.class ? ObjectWriterImplMap.INSTANCE : (valueClass == TypeUtils.CLASS_JSON_OBJECT_1x ? ObjectWriterImplMap.INSTANCE_1x : (valueClass == JSONArray.class ? ObjectWriterImplList.INSTANCE : (valueClass == TypeUtils.CLASS_JSON_ARRAY_1x ? ObjectWriterImplList.INSTANCE : provider.getObjectWriter(valueClass, valueClass, fieldBased))));
                            if (itemWriter == null) {
                                itemWriter = valueWriter;
                                itemClass = valueClass;
                            }
                            if (valueClass == this.valueType) {
                                this.valueWriter = valueWriter;
                            }
                        }
                        valueWriter.writeJSONB(jsonWriter, value, entryKey, fieldValueType, this.features);
                        if (valueRefDetecChanged) {
                            jsonWriter.config(JSONWriter.Feature.ReferenceDetection, true);
                        } else if (valueRefDetect) {
                            jsonWriter.popPath(value);
                        }
                    }
                }
            }
            ++i;
        }
        jsonWriter.endObject();
    }

    @Override
    public boolean writeTypeInfo(JSONWriter jsonWriter) {
        if (jsonWriter.utf8) {
            jsonWriter.writeNameRaw(this.typeInfoUTF8);
        } else {
            jsonWriter.writeNameRaw(this.typeInfoUTF16);
        }
        return true;
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.jsonb) {
            this.writeJSONB(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        if (this.hasFilter(jsonWriter)) {
            this.writeWithFilter(jsonWriter, object, fieldName, fieldType, features);
            return;
        }
        boolean refDetect = jsonWriter.isRefDetect();
        jsonWriter.startObject();
        if (fieldType == this.objectType && jsonWriter.isWriteMapTypeInfo(object, this.objectClass, features) || jsonWriter.isWriteTypeInfo(object, fieldType, features)) {
            this.writeTypeInfo(jsonWriter);
        }
        TreeMap map = (TreeMap)object;
        if (((features |= jsonWriter.getFeatures()) & JSONWriter.Feature.MapSortField.mask) != 0L && !(map instanceof SortedMap) && map.getClass() != LinkedHashMap.class) {
            map = new TreeMap(map);
        }
        ObjectWriterProvider provider = jsonWriter.context.provider;
        for (Map.Entry entry : map.entrySet()) {
            boolean valueRefDetect;
            boolean isPrimitiveOrEnum;
            ObjectWriter valueWriter;
            Object value = entry.getValue();
            Object key = entry.getKey();
            if (value == null) {
                if ((features & JSONWriter.Feature.WriteNulls.mask) == 0L) continue;
                if (key == null) {
                    jsonWriter.writeName("null");
                } else if (key instanceof String) {
                    jsonWriter.writeName((String)key);
                } else if ((features & (JSONWriter.Feature.WriteNonStringKeyAsString.mask | JSONWriter.Feature.BrowserCompatible.mask)) != 0L) {
                    jsonWriter.writeName(key.toString());
                } else if (key instanceof Integer) {
                    jsonWriter.writeName((Integer)key);
                } else if (key instanceof Long) {
                    jsonWriter.writeName((Long)key);
                } else {
                    jsonWriter.writeNameAny(key);
                }
                jsonWriter.writeColon();
                jsonWriter.writeNull();
                continue;
            }
            if ((features & JSONWriter.Feature.NotWriteEmptyArray.mask) != 0L && (value instanceof Collection && ((Collection)value).isEmpty() || value.getClass().isArray() && Array.getLength(value) == 0)) continue;
            String strKey = null;
            if (this.keyWriter != null) {
                this.keyWriter.write(jsonWriter, key, null, null, 0L);
            } else if (key == null) {
                jsonWriter.writeName("null");
            } else if (key instanceof String) {
                strKey = (String)key;
                jsonWriter.writeName(strKey);
            } else if ((features & (JSONWriter.Feature.WriteNonStringKeyAsString.mask | JSONWriter.Feature.BrowserCompatible.mask)) != 0L) {
                strKey = key.toString();
                jsonWriter.writeName(strKey);
            } else if (key instanceof Integer) {
                jsonWriter.writeName((Integer)key);
            } else if (key instanceof Long) {
                long longKey = (Long)key;
                jsonWriter.writeName(longKey);
            } else {
                jsonWriter.writeNameAny(key);
            }
            jsonWriter.writeColon();
            Class<?> valueClass = value.getClass();
            if (valueClass == String.class) {
                jsonWriter.writeString((String)value);
                continue;
            }
            if (valueClass == Integer.class) {
                jsonWriter.writeInt32((Integer)value);
                continue;
            }
            if (valueClass == Long.class) {
                if ((provider.userDefineMask & 4L) == 0L) {
                    jsonWriter.writeInt64((Long)value);
                    continue;
                }
                ObjectWriter valueWriter2 = jsonWriter.getObjectWriter(valueClass);
                valueWriter2.write(jsonWriter, value, strKey, (Type)((Object)Long.class), features);
                continue;
            }
            if (valueClass == Boolean.class) {
                jsonWriter.writeBool((Boolean)value);
                continue;
            }
            if (valueClass == BigDecimal.class) {
                if ((provider.userDefineMask & 8L) == 0L) {
                    jsonWriter.writeDecimal((BigDecimal)value, features, null);
                    continue;
                }
                ObjectWriter valueWriter3 = jsonWriter.getObjectWriter(valueClass);
                valueWriter3.write(jsonWriter, value, key, this.valueType, this.features);
                continue;
            }
            if (valueClass == this.valueType) {
                if (this.valueWriter != null) {
                    valueWriter = this.valueWriter;
                } else {
                    this.valueWriter = jsonWriter.getObjectWriter(valueClass);
                    valueWriter = this.valueWriter;
                }
                isPrimitiveOrEnum = ObjectWriterProvider.isPrimitiveOrEnum(value.getClass());
            } else if (valueClass == JSONObject.class) {
                valueWriter = INSTANCE;
                isPrimitiveOrEnum = false;
            } else if (valueClass == TypeUtils.CLASS_JSON_OBJECT_1x) {
                valueWriter = INSTANCE_1x;
                isPrimitiveOrEnum = false;
            } else if (valueClass == JSONArray.class) {
                valueWriter = ObjectWriterImplList.INSTANCE;
                isPrimitiveOrEnum = false;
            } else if (valueClass == TypeUtils.CLASS_JSON_ARRAY_1x) {
                valueWriter = ObjectWriterImplList.INSTANCE;
                isPrimitiveOrEnum = false;
            } else {
                valueWriter = jsonWriter.getObjectWriter(valueClass);
                isPrimitiveOrEnum = ObjectWriterProvider.isPrimitiveOrEnum(value.getClass());
            }
            boolean bl = valueRefDetect = refDetect && strKey != null && !isPrimitiveOrEnum;
            if (valueRefDetect) {
                if (value == object) {
                    jsonWriter.writeReference("..");
                    continue;
                }
                String refPath = jsonWriter.setPath(strKey, value);
                if (refPath != null) {
                    jsonWriter.writeReference(refPath);
                    jsonWriter.popPath(value);
                    continue;
                }
            }
            valueWriter.write(jsonWriter, value, key, this.valueType, this.features);
            if (!valueRefDetect) continue;
            jsonWriter.popPath(value);
        }
        jsonWriter.endObject();
    }

    @Override
    public void writeWithFilter(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        JSONWriter.Context context;
        BeforeFilter beforeFilter;
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        jsonWriter.startObject();
        TreeMap map = (TreeMap)object;
        if (((features |= jsonWriter.getFeatures()) & JSONWriter.Feature.MapSortField.mask) != 0L && !(map instanceof SortedMap) && map.getClass() != LinkedHashMap.class) {
            map = new TreeMap(map);
        }
        if ((beforeFilter = (context = jsonWriter.context).getBeforeFilter()) != null) {
            beforeFilter.writeBefore(jsonWriter, object);
        }
        PropertyPreFilter propertyPreFilter = context.getPropertyPreFilter();
        NameFilter nameFilter = context.getNameFilter();
        ValueFilter valueFilter = context.getValueFilter();
        PropertyFilter propertyFilter = context.getPropertyFilter();
        AfterFilter afterFilter = context.getAfterFilter();
        boolean writeNulls = context.isEnabled(JSONWriter.Feature.WriteNulls.mask);
        for (Map.Entry entry : map.entrySet()) {
            Object value = entry.getValue();
            if (value == null && !writeNulls) continue;
            Object enryKey = entry.getKey();
            String key = enryKey == null ? null : enryKey.toString();
            if (propertyPreFilter != null && !propertyPreFilter.process(jsonWriter, object, key)) continue;
            if (nameFilter != null) {
                key = nameFilter.process(object, key, value);
            }
            if (propertyFilter != null && !propertyFilter.apply(object, key, value)) continue;
            if (valueFilter != null) {
                value = valueFilter.apply(object, key, value);
            }
            if (value == null && (jsonWriter.getFeatures(features) & JSONWriter.Feature.WriteNulls.mask) == 0L) continue;
            jsonWriter.writeName(key);
            jsonWriter.writeColon();
            if (value == null) {
                jsonWriter.writeNull();
                continue;
            }
            Class<?> valueType = value.getClass();
            ObjectWriter valueWriter = jsonWriter.getObjectWriter(valueType);
            valueWriter.write(jsonWriter, value, fieldName, fieldType, this.features);
        }
        if (afterFilter != null) {
            afterFilter.writeAfter(jsonWriter, object);
        }
        jsonWriter.endObject();
    }
}

