/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.function.Supplier;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.util.MapMultiValueType;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;

public class ObjectReaderImplMapMultiValueType
implements ObjectReader {
    final Class mapType;
    final Class instanceType;
    final Function builder;
    final MapMultiValueType multiValueType;

    public ObjectReaderImplMapMultiValueType(MapMultiValueType multiValueType) {
        this.multiValueType = multiValueType;
        this.mapType = multiValueType.mapType;
        String mapClassName = this.mapType.getName();
        Class instanceType = this.mapType;
        if (this.mapType == Map.class || this.mapType == AbstractMap.class || mapClassName.equals("java.util.Collections$SingletonMap")) {
            instanceType = HashMap.class;
        } else if (mapClassName.equals("java.util.Collections$UnmodifiableMap")) {
            instanceType = LinkedHashMap.class;
        } else if (this.mapType == SortedMap.class) {
            instanceType = TreeMap.class;
        } else if (this.mapType == ConcurrentMap.class) {
            instanceType = ConcurrentHashMap.class;
        } else if (this.mapType == ConcurrentNavigableMap.class) {
            instanceType = ConcurrentSkipListMap.class;
        }
        this.instanceType = instanceType;
        this.builder = null;
    }

    public Object createInstance(long features) {
        if (this.instanceType != null && !this.instanceType.isInterface()) {
            try {
                return this.instanceType.newInstance();
            }
            catch (Exception e) {
                throw new JSONException("create map error", e);
            }
        }
        return new HashMap();
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        Map<String, Object> object;
        if (!jsonReader.nextIfObjectStart()) {
            if (jsonReader.nextIfNullOrEmptyString()) {
                return null;
            }
            throw new JSONException(jsonReader.info("expect '{', but '" + jsonReader.current() + "'"));
        }
        JSONReader.Context context = jsonReader.getContext();
        long contextFeatures = context.features | features;
        Map innerMap = null;
        if (this.instanceType == HashMap.class) {
            Supplier<Map> objectSupplier = context.getObjectSupplier();
            if (this.mapType == Map.class && objectSupplier != null) {
                object = objectSupplier.get();
                innerMap = TypeUtils.getInnerMap(object);
            } else {
                object = new HashMap();
            }
        } else {
            object = this.instanceType == JSONObject.class ? new JSONObject() : (Map)this.createInstance(contextFeatures);
        }
        Type valueType = null;
        int i = 0;
        while (!jsonReader.nextIfObjectEnd() && !jsonReader.isEnd()) {
            Object origin;
            Object value;
            String name;
            if (jsonReader.nextIfNull()) {
                if (!jsonReader.nextIfMatch(':')) {
                    throw new JSONException(jsonReader.info("illegal json"));
                }
                name = null;
            } else {
                name = jsonReader.readFieldName();
                valueType = this.multiValueType.getType(name);
            }
            if (valueType == null) {
                value = jsonReader.readAny();
            } else {
                ObjectReader valueObjectReader = jsonReader.getObjectReader(valueType);
                value = valueObjectReader.readObject(jsonReader, valueType, fieldName, 0L);
            }
            if ((value != null || (contextFeatures & JSONReader.Feature.IgnoreNullPropertyValue.mask) == 0L) && (origin = innerMap != null ? innerMap.put(name, value) : object.put(name, value)) != null && (contextFeatures & JSONReader.Feature.DuplicateKeyValueAsArray.mask) != 0L) {
                if (origin instanceof Collection) {
                    ((Collection)origin).add(value);
                    object.put(name, origin);
                } else {
                    JSONArray array = JSONArray.of(origin, value);
                    object.put(name, array);
                }
            }
            ++i;
        }
        jsonReader.nextIfComma();
        if (this.builder != null) {
            return this.builder.apply(object);
        }
        return object;
    }
}

