/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.function.Function;

public interface ObjectReader<T> {
    public static final long HASH_TYPE = 435678704704L;

    default public T createInstance() {
        return this.createInstance(0L);
    }

    default public T createInstance(long features) {
        throw new UnsupportedOperationException();
    }

    default public T createInstance(Collection collection) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    default public void acceptExtra(Object object, String fieldName, Object fieldValue, long features) {
    }

    default public T createInstance(Map map, JSONReader.Feature ... features) {
        long featuresValue = 0L;
        for (int i = 0; i < features.length; ++i) {
            featuresValue |= features[i].mask;
        }
        return this.createInstance(map, featuresValue);
    }

    default public T createInstance(Map map, long features) {
        ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
        Object typeKey = map.get(this.getTypeKey());
        if (typeKey instanceof String) {
            String typeName = (String)typeKey;
            long typeHash = Fnv.hashCode64(typeName);
            ObjectReader reader = null;
            if ((features & JSONReader.Feature.SupportAutoType.mask) != 0L || this instanceof ObjectReaderSeeAlso) {
                reader = this.autoType(provider, typeHash);
            }
            if (reader == null) {
                reader = provider.getObjectReader(typeName, this.getObjectClass(), features | this.getFeatures());
            }
            if (reader != this && reader != null) {
                return reader.createInstance(map, features);
            }
        }
        T object = this.createInstance(0L);
        for (Map.Entry entry : map.entrySet()) {
            String entryKey = entry.getKey().toString();
            Object fieldValue = entry.getValue();
            FieldReader fieldReader = this.getFieldReader(entryKey);
            if (fieldReader == null) {
                this.acceptExtra(object, entryKey, entry.getValue(), features);
                continue;
            }
            fieldReader.acceptAny(object, fieldValue, features);
        }
        Function buildFunction = this.getBuildFunction();
        if (buildFunction != null) {
            return (T)buildFunction.apply(object);
        }
        return object;
    }

    default public T createInstanceNoneDefaultConstructor(Map<Long, Object> values) {
        throw new UnsupportedOperationException();
    }

    default public long getFeatures() {
        return 0L;
    }

    default public String getTypeKey() {
        return "@type";
    }

    default public long getTypeKeyHash() {
        return 435678704704L;
    }

    default public Class<T> getObjectClass() {
        return null;
    }

    default public FieldReader getFieldReader(long hashCode) {
        return null;
    }

    default public FieldReader getFieldReaderLCase(long hashCode) {
        return null;
    }

    default public FieldReader getFieldReader(String fieldName) {
        long fieldNameHashLCase;
        long fieldNameHash = Fnv.hashCode64(fieldName);
        FieldReader fieldReader = this.getFieldReader(fieldNameHash);
        if (fieldReader == null && (fieldNameHashLCase = Fnv.hashCode64LCase(fieldName)) != fieldNameHash) {
            fieldReader = this.getFieldReaderLCase(fieldNameHashLCase);
        }
        return fieldReader;
    }

    default public Function getBuildFunction() {
        return null;
    }

    default public ObjectReader autoType(JSONReader.Context context, long typeHash) {
        return context.getObjectReaderAutoType(typeHash);
    }

    default public ObjectReader autoType(ObjectReaderProvider provider, long typeHash) {
        return provider.getObjectReader(typeHash);
    }

    default public T readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isArray() && jsonReader.isSupportBeanArray()) {
            return this.readArrayMappingJSONBObject(jsonReader, fieldType, fieldName, features);
        }
        Object object = null;
        jsonReader.nextIfObjectStart();
        int i = 0;
        while (!jsonReader.nextIfObjectEnd()) {
            long hash = jsonReader.readFieldNameHashCode();
            if (hash == this.getTypeKeyHash() && i == 0) {
                String typeName;
                JSONReader.Context context = jsonReader.context;
                long typeHash = jsonReader.readTypeHashCode();
                ObjectReader reader = this.autoType(context, typeHash);
                if (reader == null && (reader = context.getObjectReaderAutoType(typeName = jsonReader.getString(), null)) == null) {
                    throw new JSONException(jsonReader.info("No suitable ObjectReader found for" + typeName));
                }
                if (reader != this) {
                    return reader.readJSONBObject(jsonReader, fieldType, fieldName, features);
                }
            } else if (hash != 0L) {
                FieldReader fieldReader = this.getFieldReader(hash);
                if (fieldReader == null && jsonReader.isSupportSmartMatch(features | this.getFeatures())) {
                    long nameHashCodeLCase = jsonReader.getNameHashCodeLCase();
                    fieldReader = this.getFieldReaderLCase(nameHashCodeLCase);
                }
                if (fieldReader == null) {
                    jsonReader.skipValue();
                } else {
                    if (object == null) {
                        object = this.createInstance(jsonReader.context.features | features);
                    }
                    fieldReader.readFieldValue(jsonReader, object);
                }
            }
            ++i;
        }
        if (object == null) {
            object = this.createInstance(jsonReader.context.features | features);
        }
        return object;
    }

    default public T readArrayMappingJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        throw new UnsupportedOperationException();
    }

    default public T readArrayMappingObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        throw new UnsupportedOperationException();
    }

    default public T readObject(JSONReader jsonReader) {
        return this.readObject(jsonReader, null, null, this.getFeatures());
    }

    default public T readObject(JSONReader jsonReader, long features) {
        return this.readObject(jsonReader, null, null, features);
    }

    public T readObject(JSONReader var1, Type var2, Object var3, long var4);
}

