/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.util;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.writer.ObjectWriter;
import java.io.Reader;
import java.lang.reflect.Type;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;

public class JdbcSupport {

    public static final class DateReader
    extends ObjectReaderImplDate {
        public DateReader(String format, Locale locale) {
            super(format, locale);
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            return this.readObject(jsonReader, fieldType, fieldName, features);
        }

        @Override
        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            Instant instant;
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                if (this.formatUnixTime) {
                    millis *= 1000L;
                }
                return new Date(millis);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (this.formatUnixTime && jsonReader.isString()) {
                String str = jsonReader.readString();
                long millis = Long.parseLong(str);
                return new Date(millis *= 1000L);
            }
            if (this.format == null || this.formatISO8601 || this.formatMillis) {
                LocalDateTime localDateTime = jsonReader.readLocalDateTime();
                if (localDateTime != null) {
                    return Date.valueOf(localDateTime.toLocalDate());
                }
                if (jsonReader.wasNull()) {
                    return null;
                }
                long millis = jsonReader.readMillisFromString();
                if (millis == 0L && jsonReader.wasNull()) {
                    return null;
                }
                return new Date(millis);
            }
            String str = jsonReader.readString();
            if (str.isEmpty()) {
                return null;
            }
            DateTimeFormatter dateFormatter = this.getDateFormatter();
            if (!this.formatHasHour) {
                LocalDate localDate = LocalDate.parse(str, dateFormatter);
                LocalDateTime ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                instant = ldt.atZone(jsonReader.getContext().getZoneId()).toInstant();
            } else {
                LocalDateTime ldt = LocalDateTime.parse(str, dateFormatter);
                instant = ldt.atZone(jsonReader.getContext().getZoneId()).toInstant();
            }
            return new Date(instant.toEpochMilli());
        }
    }

    public static final class TimestampReader
    extends ObjectReaderImplDate {
        public TimestampReader(String format, Locale locale) {
            super(format, locale);
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                if (this.formatUnixTime) {
                    millis *= 1000L;
                }
                return this.createTimestamp(millis, 0);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            return this.readObject(jsonReader, fieldType, fieldName, features);
        }

        Object createTimestamp(long millis, int nanos) {
            Timestamp ts = new Timestamp(millis);
            if (nanos != 0) {
                ts.setNanos(nanos);
            }
            return ts;
        }

        @Override
        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            Instant instant;
            if (jsonReader.isInt()) {
                long millis = jsonReader.readInt64Value();
                if (this.formatUnixTime) {
                    millis *= 1000L;
                }
                return this.createTimestamp(millis, 0);
            }
            if (jsonReader.nextIfNullOrEmptyString()) {
                return null;
            }
            if (this.format == null || this.formatISO8601 || this.formatMillis) {
                LocalDateTime localDateTime = jsonReader.readLocalDateTime();
                if (localDateTime != null) {
                    return Timestamp.valueOf(localDateTime);
                }
                if (jsonReader.wasNull()) {
                    return null;
                }
                long millis = jsonReader.readMillisFromString();
                if (millis == 0L && jsonReader.wasNull()) {
                    return null;
                }
                return new Timestamp(millis);
            }
            String str = jsonReader.readString();
            if (str.isEmpty()) {
                return null;
            }
            DateTimeFormatter dateFormatter = this.getDateFormatter();
            if (!this.formatHasHour) {
                LocalDate localDate = LocalDate.parse(str, dateFormatter);
                LocalDateTime ldt = LocalDateTime.of(localDate, LocalTime.MIN);
                instant = ldt.atZone(jsonReader.getContext().getZoneId()).toInstant();
            } else {
                LocalDateTime ldt = LocalDateTime.parse(str, dateFormatter);
                instant = ldt.atZone(jsonReader.getContext().getZoneId()).toInstant();
            }
            long millis = instant.toEpochMilli();
            int nanos = instant.getNano();
            return this.createTimestamp(millis, nanos);
        }
    }

    public static final class TimestampWriter
    extends DateTimeCodec
    implements ObjectWriter {
        public TimestampWriter(String format) {
            super(format);
        }

        @Override
        public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            Timestamp ts = (Timestamp)object;
            long millis = ts.getTime();
            int nanos = ts.getNanos();
            if (nanos == 0) {
                jsonWriter.writeMillis(millis);
                return;
            }
            jsonWriter.writeInstant(millis, nanos);
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            JSONWriter.Context ctx = jsonWriter.context;
            Timestamp date = (Timestamp)object;
            if (this.formatUnixTime || ctx.isDateFormatUnixTime()) {
                long millis = date.getTime();
                jsonWriter.writeInt64(millis / 1000L);
                return;
            }
            ZoneId zoneId = ctx.getZoneId();
            Instant instant = date.toInstant();
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
            int offsetSeconds = zdt.getOffset().getTotalSeconds();
            if ((this.formatISO8601 || ctx.isDateFormatISO8601()) && zdt.getNano() % 1000000 == 0) {
                int year = zdt.getYear();
                int month = zdt.getMonthValue();
                int dayOfMonth = zdt.getDayOfMonth();
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                int nano = zdt.getNano();
                int millis = nano / 1000000;
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, millis, offsetSeconds, true);
                return;
            }
            DateTimeFormatter dateFormatter = this.getDateFormatter();
            if (dateFormatter == null) {
                dateFormatter = ctx.getDateFormatter();
            }
            if (dateFormatter == null) {
                if (this.formatMillis || ctx.isDateFormatMillis()) {
                    long millis = date.getTime();
                    jsonWriter.writeInt64(millis);
                    return;
                }
                int nanos = date.getNanos();
                if (nanos == 0) {
                    jsonWriter.writeInt64(date.getTime());
                    return;
                }
                int year = zdt.getYear();
                int month = zdt.getMonthValue();
                int dayOfMonth = zdt.getDayOfMonth();
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                if (nanos % 1000000 == 0) {
                    jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, nanos / 1000000, offsetSeconds, false);
                } else {
                    jsonWriter.writeLocalDateTime(zdt.toLocalDateTime());
                }
            } else {
                String str = dateFormatter.format(zdt);
                jsonWriter.writeString(str);
            }
        }
    }

    public static final class TimeWriter
    extends DateTimeCodec
    implements ObjectWriter {
        public static final TimeWriter INSTANCE = new TimeWriter(null);

        public TimeWriter(String format) {
            super(format);
        }

        public static TimeWriter of(String format) {
            if (format == null) {
                return INSTANCE;
            }
            return new TimeWriter(format);
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            String format;
            if (object == null) {
                jsonWriter.writeNull();
                return;
            }
            JSONWriter.Context context = jsonWriter.context;
            if (this.formatUnixTime || context.isDateFormatUnixTime()) {
                long millis = ((java.util.Date)object).getTime();
                long seconds = millis / 1000L;
                jsonWriter.writeInt64(seconds);
                return;
            }
            if (this.formatMillis || context.isDateFormatMillis()) {
                long millis = ((java.util.Date)object).getTime();
                jsonWriter.writeInt64(millis);
                return;
            }
            if (this.formatISO8601 || context.isDateFormatISO8601()) {
                ZoneId zoneId = context.getZoneId();
                long millis = ((java.util.Date)object).getTime();
                Instant instant = Instant.ofEpochMilli(millis);
                ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
                int offsetSeconds = zdt.getOffset().getTotalSeconds();
                int year = zdt.getYear();
                int month = zdt.getMonthValue();
                int dayOfMonth = zdt.getDayOfMonth();
                int hour = zdt.getHour();
                int minute = zdt.getMinute();
                int second = zdt.getSecond();
                int nano = 0;
                jsonWriter.writeDateTimeISO8601(year, month, dayOfMonth, hour, minute, second, nano, offsetSeconds, true);
                return;
            }
            DateTimeFormatter dateFormatter = null;
            if (this.format != null && !this.format.contains("dd")) {
                dateFormatter = this.getDateFormatter();
            }
            if (dateFormatter == null && (format = context.getDateFormat()) != null && !format.contains("dd")) {
                dateFormatter = context.getDateFormatter();
            }
            if (dateFormatter == null) {
                jsonWriter.writeString(object.toString());
                return;
            }
            java.util.Date time = (java.util.Date)object;
            ZoneId zoneId = context.getZoneId();
            Instant instant = Instant.ofEpochMilli(time.getTime());
            ZonedDateTime zdt = ZonedDateTime.ofInstant(instant, zoneId);
            String str = dateFormatter.format(zdt);
            jsonWriter.writeString(str);
        }
    }

    public static final class TimeReader
    extends ObjectReaderImplDate {
        public TimeReader(String format, Locale locale) {
            super(format, locale);
        }

        @Override
        public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            return this.readObject(jsonReader, fieldType, fieldName, features);
        }

        @Override
        public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
            long millis;
            if (jsonReader.isInt()) {
                long millis2 = jsonReader.readInt64Value();
                if (this.formatUnixTime) {
                    millis2 *= 1000L;
                }
                return new Time(millis2);
            }
            if (jsonReader.readIfNull()) {
                return null;
            }
            if (this.formatISO8601 || this.formatMillis) {
                long millis3 = jsonReader.readMillisFromString();
                return new Time(millis3);
            }
            if (this.formatUnixTime) {
                long seconds = jsonReader.readInt64();
                return new Time(seconds * 1000L);
            }
            if (this.format != null) {
                ZonedDateTime zdt;
                DateTimeFormatter formatter = this.getDateFormatter(jsonReader.getLocale());
                if (formatter != null) {
                    String str = jsonReader.readString();
                    if (str.isEmpty()) {
                        return null;
                    }
                    LocalDateTime ldt = !this.formatHasHour ? LocalDateTime.of(LocalDate.parse(str, formatter), LocalTime.MIN) : (!this.formatHasDay ? LocalDateTime.of(LocalDate.of(1970, 1, 1), LocalTime.parse(str, formatter)) : LocalDateTime.parse(str, formatter));
                    zdt = ldt.atZone(jsonReader.getContext().getZoneId());
                } else {
                    zdt = jsonReader.readZonedDateTime();
                }
                millis = zdt.toInstant().toEpochMilli();
            } else {
                String str = jsonReader.readString();
                if ("0000-00-00".equals(str) || "0000-00-00 00:00:00".equals(str)) {
                    millis = 0L;
                } else if (str.length() == 9 && str.charAt(8) == 'Z') {
                    LocalTime localTime = DateUtils.parseLocalTime(str.charAt(0), str.charAt(1), str.charAt(2), str.charAt(3), str.charAt(4), str.charAt(5), str.charAt(6), str.charAt(7));
                    millis = LocalDateTime.of(DateUtils.LOCAL_DATE_19700101, localTime).atZone(DateUtils.DEFAULT_ZONE_ID).toInstant().toEpochMilli();
                } else {
                    if (str.isEmpty() || "null".equals(str)) {
                        return null;
                    }
                    return Time.valueOf(str);
                }
            }
            return new Time(millis);
        }
    }

    public static final class ClobWriter
    implements ObjectWriter {
        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
            Reader reader;
            Clob clob = (Clob)object;
            try {
                reader = clob.getCharacterStream();
            }
            catch (SQLException e) {
                throw new JSONException("get getCharacterStream error", e);
            }
            jsonWriter.writeString(reader);
        }
    }
}

