/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONPathSegment;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

final class JSONPathSegmentName
extends JSONPathSegment {
    final String name;
    final long nameHashCode;

    public JSONPathSegmentName(String name, long nameHashCode) {
        this.name = name;
        this.nameHashCode = nameHashCode;
    }

    @Override
    public void eval(JSONPath.Context context) {
        Object object;
        Object object2 = object = context.parent == null ? context.root : context.parent.value;
        if (object == null) {
            return;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            Object value = map.get(this.name);
            if (value == null) {
                boolean isNum = IOUtils.isNumber(this.name);
                Long longValue = null;
                for (Map.Entry o : map.entrySet()) {
                    Map.Entry entry = o;
                    Object entryKey = entry.getKey();
                    if (entryKey instanceof Enum && ((Enum)entryKey).name().equals(this.name)) {
                        value = entry.getValue();
                        break;
                    }
                    if (!(entryKey instanceof Long)) continue;
                    if (longValue == null && isNum) {
                        longValue = Long.parseLong(this.name);
                    }
                    if (!entryKey.equals(longValue)) continue;
                    value = entry.getValue();
                    break;
                }
            }
            context.value = value;
            return;
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            int size = collection.size();
            Collection values = null;
            for (Object item : collection) {
                Object val;
                if (!(item instanceof Map) || (val = ((Map)item).get(this.name)) == null) continue;
                if (val instanceof Collection) {
                    if (size == 1) {
                        values = (Collection)val;
                        continue;
                    }
                    if (values == null) {
                        values = new JSONArray(size);
                    }
                    values.addAll((Collection)val);
                    continue;
                }
                if (values == null) {
                    values = new JSONArray(size);
                }
                values.add(val);
            }
            context.value = values;
            return;
        }
        Class<?> objectClass = object.getClass();
        JSONWriter.Context writerContext = context.path.writerContext;
        ObjectWriter objectWriter = writerContext != null ? writerContext.getObjectWriter(objectClass) : JSONFactory.defaultObjectWriterProvider.getObjectWriter(objectClass);
        if (objectWriter instanceof ObjectWriterAdapter) {
            FieldWriter fieldWriter = objectWriter.getFieldWriter(this.nameHashCode);
            if (fieldWriter != null) {
                context.value = fieldWriter.getFieldValue(object);
            }
            return;
        }
        if (object instanceof Number || object instanceof Boolean) {
            context.value = null;
            return;
        }
        throw new JSONException("not support : " + objectClass);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JSONPathSegmentName that = (JSONPathSegmentName)o;
        return this.nameHashCode == that.nameHashCode && this.name == that.name || this.name != null && this.name.equals(that.name);
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.name, this.nameHashCode});
    }

    public String toString() {
        return this.name;
    }
}

