/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.time.DateTimeException;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.NameCacheEntry;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

class JSONReaderUTF8
extends JSONReader {
    protected final byte[] bytes;
    protected final int length;
    protected final int start;
    protected final int end;
    protected int nameBegin;
    protected int nameEnd;
    protected int nameLength;
    protected boolean nameAscii;
    protected int referenceBegin;
    protected final InputStream in;
    protected byte[] byteBuf;
    protected char[] charBuf;
    protected final JSONFactory.CacheItem cacheItem;

    JSONReaderUTF8(JSONReader.Context ctx, InputStream is) {
        super(ctx, false);
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        if (bytes == null) {
            bytes = new byte[ctx.bufferSize];
        }
        int off = 0;
        try {
            int n;
            while ((n = is.read(bytes, off, bytes.length - off)) != -1) {
                if ((off += n) != bytes.length) continue;
                bytes = Arrays.copyOf(bytes, bytes.length + ctx.bufferSize);
            }
        }
        catch (IOException ioe) {
            throw new JSONException("read error", ioe);
        }
        this.byteBuf = bytes;
        this.bytes = bytes;
        this.offset = 0;
        this.length = off;
        this.in = is;
        this.start = 0;
        this.end = this.length;
        this.next();
        if (this.ch == '/') {
            this.skipComment();
        }
    }

    JSONReaderUTF8(JSONReader.Context ctx, ByteBuffer buffer) {
        super(ctx, false);
        int ch;
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        byte[] bytes = JSONFactory.BYTES_UPDATER.getAndSet(this.cacheItem, null);
        int remaining = buffer.remaining();
        if (bytes == null || bytes.length < remaining) {
            bytes = new byte[remaining];
        }
        buffer.get(bytes, 0, remaining);
        this.byteBuf = bytes;
        this.bytes = bytes;
        int offset = 0;
        this.length = remaining;
        this.in = null;
        this.start = 0;
        this.end = this.length;
        int n = ch = offset >= this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.next();
            return;
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
    }

    JSONReaderUTF8(JSONReader.Context ctx, String str, byte[] bytes, int offset, int length) {
        super(ctx, false);
        int ch;
        int cacheIndex = System.identityHashCode(Thread.currentThread()) & JSONFactory.CACHE_ITEMS.length - 1;
        this.cacheItem = JSONFactory.CACHE_ITEMS[cacheIndex];
        this.bytes = bytes;
        this.length = length;
        this.in = null;
        this.start = offset;
        this.end = offset + length;
        int n = ch = offset >= this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.next();
            return;
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
    }

    private void char_utf8(int ch, int offset) {
        byte[] bytes = this.bytes;
        switch ((ch & 0xFF) >> 4) {
            case 12: 
            case 13: {
                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset++], offset);
                break;
            }
            case 14: {
                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset], bytes[offset + 1], offset);
                offset += 2;
                break;
            }
            default: {
                if (ch >> 3 == -2) {
                    byte c2 = bytes[offset];
                    byte c3 = bytes[offset + 1];
                    byte c4 = bytes[offset + 2];
                    ch = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                    offset += 3;
                    break;
                }
                throw new JSONException("malformed input around byte " + offset);
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    static int char2_utf8(int ch, int char2, int offset) {
        if ((char2 & 0xC0) != 128) {
            throw new JSONException("malformed input around byte " + offset);
        }
        return (ch & 0x1F) << 6 | char2 & 0x3F;
    }

    static int char2_utf8(int ch, int char2, int char3, int offset) {
        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
            throw new JSONException("malformed input around byte " + offset);
        }
        return (ch & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
    }

    static void char2_utf8(byte[] bytes, int offset, int c, char[] chars, int charPos) {
        if (c >> 3 == -2) {
            byte c2 = bytes[offset + 1];
            byte c3 = bytes[offset + 2];
            byte c4 = bytes[offset + 3];
            int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                throw new JSONException("malformed input around byte " + offset);
            }
            chars[charPos] = (char)((uc >>> 10) + 55232);
            chars[charPos + 1] = (char)((uc & 0x3FF) + 56320);
            return;
        }
        throw new JSONException("malformed input around byte " + offset);
    }

    @Override
    public final boolean nextIfMatch(char m) {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        char ch = this.ch;
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        }
        if (ch != m) {
            return false;
        }
        char c = ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        while (ch == '\u0000' || ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        }
        if (ch < '\u0000') {
            this.char_utf8(ch, offset);
            return true;
        }
        this.offset = offset;
        this.ch = ch;
        if (ch == '/') {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfComma() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch != 44) {
            return false;
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfArrayStart() {
        int ch = this.ch;
        if (ch != 91) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfArrayEnd() {
        int ch = this.ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (ch != 93) {
            return false;
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n2 = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public final boolean nextIfSet() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 83 && offset + 1 < this.end && bytes[offset] == 101 && bytes[offset + 1] == 116) {
            int n = ch = (offset += 2) == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public final boolean nextIfInfinity() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 73 && offset + 6 < this.end && bytes[offset] == 110 && bytes[offset + 1] == 102 && bytes[offset + 2] == 105 && bytes[offset + 3] == 110 && bytes[offset + 4] == 105 && bytes[offset + 5] == 116 && bytes[offset + 6] == 121) {
            int n = ch = (offset += 7) == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            this.offset = offset;
            this.ch = (char)ch;
            return true;
        }
        return false;
    }

    @Override
    public boolean nextIfObjectStart() {
        int ch = this.ch;
        if (ch != 123) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public boolean nextIfObjectEnd() {
        int ch = this.ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (ch != 125) {
            return false;
        }
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n2 = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
        return true;
    }

    @Override
    public void next() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int n = ch = offset >= this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return;
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (ch == 47) {
            this.skipComment();
        }
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        long hashCode;
        this.nameEscape = false;
        int offset = this.offset;
        int end = this.end;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        this.nameBegin = offset - 1;
        int first = ch;
        long nameValue = 0L;
        int i = 0;
        block34: while (offset <= end) {
            switch (ch) {
                case 8: 
                case 9: 
                case 10: 
                case 12: 
                case 13: 
                case 26: 
                case 32: 
                case 33: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 58: 
                case 60: 
                case 61: 
                case 62: 
                case 91: 
                case 93: 
                case 123: 
                case 125: {
                    this.nameLength = i;
                    int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                    if (ch > 32 || (1L << ch & 0x100003700L) == 0L) break block34;
                    ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
                    break block34;
                }
                default: {
                    if (ch == 92) {
                        this.nameEscape = true;
                        ch = (char)bytes[offset++];
                        switch (ch) {
                            case 117: {
                                ch = JSONReaderUTF8.char4(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
                                offset += 4;
                                break;
                            }
                            case 120: {
                                ch = JSONReaderUTF8.char2(bytes[offset], bytes[offset + 1]);
                                offset += 2;
                                break;
                            }
                            case 34: 
                            case 42: 
                            case 43: 
                            case 45: 
                            case 46: 
                            case 47: 
                            case 58: 
                            case 60: 
                            case 61: 
                            case 62: 
                            case 64: 
                            case 92: {
                                break;
                            }
                            default: {
                                ch = this.char1(ch);
                            }
                        }
                    }
                    if (ch < 0) {
                        switch ((ch & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset++], offset);
                                break;
                            }
                            case 14: {
                                ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset], bytes[offset + 1], offset);
                                offset += 2;
                                break;
                            }
                            default: {
                                if (ch >> 3 == -2) {
                                    byte c2 = bytes[offset];
                                    byte c3 = bytes[offset + 1];
                                    byte c4 = bytes[offset + 2];
                                    ch = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                    break;
                                }
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                    if (ch > 255 || i >= 8 || i == 0 && ch == 0) {
                        nameValue = 0L;
                        ch = first;
                        offset = this.nameBegin + 1;
                        break block34;
                    }
                    byte c = (byte)ch;
                    switch (i) {
                        case 0: {
                            nameValue = c;
                            break;
                        }
                        case 1: {
                            nameValue = (long)(c << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)(c << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)(c << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)c << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)c << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)c << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)c << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ch = offset == end ? 26 : bytes[offset++];
                    ++i;
                    continue block34;
                }
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i2 = 0;
            block35: while (true) {
                if (ch == 92) {
                    this.nameEscape = true;
                    ch = bytes[offset++];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderUTF8.char4(bytes[offset], bytes[offset + 1], bytes[offset + 2], bytes[offset + 3]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF8.char2(bytes[offset], bytes[offset + 1]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                    ch = offset == end ? 26 : bytes[offset++];
                } else {
                    switch (ch) {
                        case 8: 
                        case 9: 
                        case 10: 
                        case 12: 
                        case 13: 
                        case 26: 
                        case 32: 
                        case 33: 
                        case 40: 
                        case 41: 
                        case 42: 
                        case 43: 
                        case 44: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 91: 
                        case 93: 
                        case 123: 
                        case 125: {
                            this.nameLength = i2;
                            int n = this.nameEnd = ch == 26 ? offset : offset - 1;
                            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                                ch = offset == end ? 26 : bytes[offset++];
                            }
                            break block35;
                        }
                        default: {
                            if (ch < 0) {
                                switch ((ch & 0xFF) >> 4) {
                                    case 12: 
                                    case 13: {
                                        ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset++], offset);
                                        this.nameAscii = false;
                                        break;
                                    }
                                    case 14: {
                                        ch = JSONReaderUTF8.char2_utf8(ch & 0xFF, bytes[offset], bytes[offset + 1], offset);
                                        offset += 2;
                                        this.nameAscii = false;
                                        break;
                                    }
                                    default: {
                                        if (ch >> 3 == -2) {
                                            byte c2 = bytes[offset];
                                            byte c3 = bytes[offset + 1];
                                            byte c4 = bytes[offset + 2];
                                            ch = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                            offset += 3;
                                            this.nameAscii = false;
                                            break;
                                        }
                                        throw new JSONException("malformed input around byte " + offset);
                                    }
                                }
                            }
                            if (ch > 65535) {
                                int c0 = (ch >>> 10) + 55232;
                                hashCode ^= (long)c0;
                                hashCode *= 1099511628211L;
                                int c1 = (ch & 0x3FF) + 56320;
                                hashCode ^= (long)c1;
                                hashCode *= 1099511628211L;
                            } else {
                                hashCode ^= (long)ch;
                                hashCode *= 1099511628211L;
                            }
                            ch = offset == end ? 26 : bytes[offset++];
                        }
                    }
                }
                ++i2;
            }
        }
        if (ch == 58) {
            ch = (char)(offset == end ? 26 : (char)bytes[offset++]);
            char c = (char)ch;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    @Override
    public long readFieldNameHashCode() {
        long hashCode;
        byte c1;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        if (ch != 34 && ch != 39) {
            String preFieldName;
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF8.isFirstIdentifier(ch)) {
                return this.readFieldNameHashCodeUnquote();
            }
            if (ch == 125 || this.isNull()) {
                return -1L;
            }
            String errorMsg = ch == 91 && this.nameBegin > 0 && (preFieldName = this.getFieldName()) != null ? "illegal fieldName input " + ch + ", previous fieldName " + preFieldName : "illegal fieldName input" + ch;
            throw new JSONException(this.info(errorMsg));
        }
        int quote = ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int end = this.end;
        long nameValue = 0L;
        if (offset + 9 < end) {
            byte c0 = bytes[offset];
            if (c0 == quote) {
                nameValue = 0L;
            } else {
                c1 = bytes[offset + 1];
                if (c1 == quote && c0 != 92 && c0 > 0) {
                    nameValue = c0;
                    this.nameLength = 1;
                    this.nameEnd = offset + 1;
                    offset += 2;
                } else {
                    int c2 = bytes[offset + 2];
                    if (c2 == quote && c0 != 92 && c1 != 92 && c0 >= 0 && c1 > 0) {
                        nameValue = (c1 << 8) + c0;
                        this.nameLength = 2;
                        this.nameEnd = offset + 2;
                        offset += 3;
                    } else {
                        byte c3 = bytes[offset + 3];
                        if (c3 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c0 >= 0 && c1 >= 0 && c2 > 0) {
                            nameValue = (c2 << 16) + (c1 << 8) + c0;
                            this.nameLength = 3;
                            this.nameEnd = offset + 3;
                            offset += 4;
                        } else {
                            byte c4 = bytes[offset + 4];
                            if (c4 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 > 0) {
                                nameValue = (c3 << 24) + (c2 << 16) + (c1 << 8) + c0;
                                this.nameLength = 4;
                                this.nameEnd = offset + 4;
                                offset += 5;
                            } else {
                                byte c5 = bytes[offset + 5];
                                if (c5 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 > 0) {
                                    nameValue = ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                    this.nameLength = 5;
                                    this.nameEnd = offset + 5;
                                    offset += 6;
                                } else {
                                    byte c6 = bytes[offset + 6];
                                    if (c6 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 > 0) {
                                        nameValue = ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                        this.nameLength = 6;
                                        this.nameEnd = offset + 6;
                                        offset += 7;
                                    } else {
                                        byte c7 = bytes[offset + 7];
                                        if (c7 == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 > 0) {
                                            nameValue = ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 7;
                                            this.nameEnd = offset + 7;
                                            offset += 8;
                                        } else if (bytes[offset + 8] == quote && c0 != 92 && c1 != 92 && c2 != 92 && c3 != 92 && c4 != 92 && c5 != 92 && c6 != 92 && c7 != 92 && c0 >= 0 && c1 >= 0 && c2 >= 0 && c3 >= 0 && c4 >= 0 && c5 >= 0 && c6 >= 0 && c7 > 0) {
                                            nameValue = ((long)c7 << 56) + ((long)c6 << 48) + ((long)c5 << 40) + ((long)c4 << 32) + (long)(c3 << 24) + (long)(c2 << 16) + (long)(c1 << 8) + (long)c0;
                                            this.nameLength = 8;
                                            this.nameEnd = offset + 8;
                                            offset += 9;
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        if (nameValue == 0L) {
            int i = 0;
            while (offset < end) {
                ch = bytes[offset];
                if (ch == quote) {
                    if (i == 0) {
                        offset = this.nameBegin;
                        break;
                    }
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    break;
                }
                if (ch == 92) {
                    this.nameEscape = true;
                    ch = bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    if (ch > 255) {
                        this.nameAscii = false;
                    }
                } else if (ch == -61 || ch == -62) {
                    c1 = bytes[++offset];
                    ch = (char)((ch & 0x1F) << 6 | c1 & 0x3F);
                    this.nameAscii = false;
                }
                if (ch > 255 || ch < 0 || i >= 8 || i == 0 && ch == 0) {
                    nameValue = 0L;
                    offset = this.nameBegin;
                    break;
                }
                switch (i) {
                    case 0: {
                        nameValue = (byte)ch;
                        break;
                    }
                    case 1: {
                        nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                        break;
                    }
                    case 2: {
                        nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                        break;
                    }
                    case 3: {
                        nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                        break;
                    }
                    case 4: {
                        nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                        break;
                    }
                    case 5: {
                        nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                        break;
                    }
                    case 6: {
                        nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                        break;
                    }
                    case 7: {
                        nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                        break;
                    }
                }
                ++offset;
                ++i;
            }
        }
        if (nameValue != 0L) {
            hashCode = nameValue;
        } else {
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                if ((ch = bytes[offset]) == 92) {
                    this.nameEscape = true;
                    ch = bytes[++offset];
                    switch (ch) {
                        case 117: {
                            ch = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        default: {
                            ch = this.char1(ch);
                        }
                    }
                    ++offset;
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                } else {
                    if (ch == quote) {
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    if (ch >= 0) {
                        ++offset;
                    } else {
                        switch ((ch &= 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], offset);
                                offset += 2;
                                this.nameAscii = false;
                                break;
                            }
                            case 14: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], bytes[offset + 2], offset);
                                offset += 3;
                                this.nameAscii = false;
                                break;
                            }
                            default: {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch != 58) {
            throw new JSONException(this.info("expect ':', but " + ch));
        }
        int n2 = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long readValueHashCode() {
        long hashCode;
        int end;
        int offset;
        byte[] bytes;
        int ch;
        block37: {
            block36: {
                ch = this.ch;
                if (ch != 34 && ch != 39) {
                    return -1L;
                }
                bytes = this.bytes;
                int quote = ch;
                this.nameAscii = true;
                this.nameEscape = false;
                offset = this.nameBegin = this.offset;
                end = this.end;
                long nameValue = 0L;
                int i = 0;
                while (offset < end) {
                    ch = bytes[offset];
                    if (ch == quote) {
                        if (i == 0) {
                            nameValue = 0L;
                            offset = this.nameBegin;
                            break;
                        }
                        this.nameLength = i;
                        this.nameEnd = offset++;
                        break;
                    }
                    if (ch == 92) {
                        this.nameEscape = true;
                        ch = bytes[++offset];
                        switch (ch) {
                            case 117: {
                                ch = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                                offset += 4;
                                break;
                            }
                            case 120: {
                                ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                                offset += 2;
                                break;
                            }
                            default: {
                                ch = this.char1(ch);
                                break;
                            }
                        }
                    } else if (ch == -61 || ch == -62) {
                        ch = (char)((ch & 0x1F) << 6 | bytes[++offset] & 0x3F);
                    }
                    if (ch > 255 || ch < 0 || i >= 8 || i == 0 && ch == 0) {
                        nameValue = 0L;
                        offset = this.nameBegin;
                        break;
                    }
                    switch (i) {
                        case 0: {
                            nameValue = (byte)ch;
                            break;
                        }
                        case 1: {
                            nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                            break;
                        }
                        case 2: {
                            nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                            break;
                        }
                        case 3: {
                            nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                            break;
                        }
                        case 4: {
                            nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                            break;
                        }
                        case 5: {
                            nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                            break;
                        }
                        case 6: {
                            nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                            break;
                        }
                        case 7: {
                            nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                            break;
                        }
                    }
                    ++offset;
                    ++i;
                }
                if (nameValue == 0L) break block36;
                hashCode = nameValue;
                break block37;
            }
            hashCode = -3750763034362895579L;
            int i = 0;
            while (true) {
                block39: {
                    block41: {
                        block40: {
                            block38: {
                                if ((ch = bytes[offset]) != 92) break block38;
                                this.nameEscape = true;
                                ch = bytes[++offset];
                                switch (ch) {
                                    case 117: {
                                        ch = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                                        offset += 4;
                                        break;
                                    }
                                    case 120: {
                                        ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                                        offset += 2;
                                        break;
                                    }
                                    default: {
                                        ch = this.char1(ch);
                                    }
                                }
                                ++offset;
                                hashCode ^= (long)ch;
                                hashCode *= 1099511628211L;
                                break block39;
                            }
                            if (ch == 34) {
                                this.nameLength = i;
                                this.nameEnd = offset++;
                                break;
                            }
                            if (ch < 0) break block40;
                            ++offset;
                            break block41;
                        }
                        switch ((ch & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], offset);
                                offset += 2;
                                this.nameAscii = false;
                                break;
                            }
                            case 14: {
                                ch = JSONReaderUTF8.char2_utf8(ch, bytes[offset + 1], bytes[offset + 2], offset);
                                offset += 3;
                                this.nameAscii = false;
                                break;
                            }
                            default: {
                                if (ch >> 3 != -2) throw new JSONException("malformed input around byte " + offset);
                                int n = ++offset;
                                byte c2 = bytes[n];
                                int n2 = ++offset;
                                byte c3 = bytes[n2];
                                int n3 = ++offset;
                                ++offset;
                                byte c4 = bytes[n3];
                                int uc = ch << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                char x1 = (char)((uc >>> 10) + 55232);
                                char x2 = (char)((uc & 0x3FF) + 56320);
                                hashCode ^= (long)x1;
                                hashCode *= 1099511628211L;
                                hashCode ^= (long)x2;
                                hashCode *= 1099511628211L;
                                ++i;
                                break block39;
                            }
                        }
                    }
                    hashCode ^= (long)ch;
                    hashCode *= 1099511628211L;
                }
                ++i;
            }
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n4 = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        byte c1;
        int ch;
        int offset;
        long hashCode = -3750763034362895579L;
        byte[] bytes = this.bytes;
        long nameValue = 0L;
        int i = 0;
        for (offset = this.nameBegin; offset < this.end; ++offset) {
            ch = bytes[offset];
            if (ch == 92) {
                ch = bytes[++offset];
                switch (ch) {
                    case 117: {
                        ch = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 120: {
                        ch = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        ch = this.char1(ch);
                        break;
                    }
                }
            } else if (ch == -61 || ch == -62) {
                ch = (ch & 0x1F) << 6 | bytes[++offset] & 0x3F;
            } else if (ch == 34) break;
            if (i >= 8 || ch > 255 || ch < 0 || i == 0 && ch == 0) {
                nameValue = 0L;
                offset = this.nameBegin;
                break;
            }
            if ((ch == 95 || ch == 45 || ch == 32) && (c1 = bytes[offset + 1]) != 34 && c1 != 39 && c1 != ch) continue;
            if (ch >= 65 && ch <= 90) {
                ch = (char)(ch + 32);
            }
            switch (i) {
                case 0: {
                    nameValue = (byte)ch;
                    break;
                }
                case 1: {
                    nameValue = (long)((byte)ch << 8) + (nameValue & 0xFFL);
                    break;
                }
                case 2: {
                    nameValue = (long)((byte)ch << 16) + (nameValue & 0xFFFFL);
                    break;
                }
                case 3: {
                    nameValue = (long)((byte)ch << 24) + (nameValue & 0xFFFFFFL);
                    break;
                }
                case 4: {
                    nameValue = ((long)((byte)ch) << 32) + (nameValue & 0xFFFFFFFFL);
                    break;
                }
                case 5: {
                    nameValue = ((long)((byte)ch) << 40) + (nameValue & 0xFFFFFFFFFFL);
                    break;
                }
                case 6: {
                    nameValue = ((long)((byte)ch) << 48) + (nameValue & 0xFFFFFFFFFFFFL);
                    break;
                }
                case 7: {
                    nameValue = ((long)((byte)ch) << 56) + (nameValue & 0xFFFFFFFFFFFFFFL);
                    break;
                }
            }
            ++i;
        }
        if (nameValue != 0L) {
            return nameValue;
        }
        if (this.nameAscii && !this.nameEscape) {
            for (i = this.nameBegin; i < this.nameEnd; ++i) {
                ch = bytes[i];
                if (ch >= 65 && ch <= 90) {
                    ch += 32;
                }
                if ((ch == 95 || ch == 45 || ch == 32) && (c1 = bytes[i + 1]) != 34 && c1 != 39 && c1 != ch) continue;
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
            return hashCode;
        }
        while (true) {
            int ch2;
            if ((ch2 = bytes[offset]) == 92) {
                ch2 = bytes[++offset];
                switch (ch2) {
                    case 117: {
                        ch2 = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                        offset += 4;
                        break;
                    }
                    case 120: {
                        ch2 = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                        offset += 2;
                        break;
                    }
                    default: {
                        ch2 = this.char1(ch2);
                    }
                }
                ++offset;
            } else {
                if (ch2 == 34) break;
                if (ch2 >= 0) {
                    if (ch2 >= 65 && ch2 <= 90) {
                        ch2 += 32;
                    }
                    ++offset;
                } else {
                    switch ((ch2 &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = bytes[offset + 1];
                            ch2 = (ch2 & 0x1F) << 6 | c2 & 0x3F;
                            offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = bytes[offset + 1];
                            byte c3 = bytes[offset + 2];
                            ch2 = (ch2 & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F;
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
            }
            if (ch2 == 95 || ch2 == 45 || ch2 == 32) continue;
            hashCode ^= (long)ch2;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    final String getLatin1String(int offset, int length) {
        if (JDKUtils.ANDROID_SDK_INT >= 34) {
            return new String(this.bytes, offset, length, StandardCharsets.ISO_8859_1);
        }
        char[] chars = this.charBuf;
        if (chars == null) {
            this.charBuf = chars = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
        }
        if (chars == null || chars.length < length) {
            this.charBuf = chars = new char[length];
        }
        for (int i = 0; i < length; ++i) {
            chars[i] = (char)(this.bytes[offset + i] & 0xFF);
        }
        return new String(chars, 0, length);
    }

    @Override
    public String getFieldName() {
        byte[] bytes = this.bytes;
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return this.nameAscii ? this.getLatin1String(this.nameBegin, length) : new String(bytes, this.nameBegin, length, StandardCharsets.UTF_8);
        }
        char[] chars = this.charBuf;
        if (chars == null) {
            this.charBuf = chars = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
        }
        if (chars == null || chars.length < length) {
            this.charBuf = chars = new char[this.nameLength];
        }
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            int c = bytes[offset];
            if (c < 0) {
                switch ((c &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        byte char2 = bytes[offset + 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                        c = (c & 0x1F) << 6 | char2 & 0x3F;
                        offset += 2;
                        break;
                    }
                    case 14: {
                        byte char2 = bytes[offset + 1];
                        byte char3 = bytes[offset + 2];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new JSONException("malformed input around byte " + (offset + 2));
                        }
                        c = (c & 0xF) << 12 | (char2 & 0x3F) << 6 | char3 & 0x3F;
                        offset += 3;
                        break;
                    }
                    default: {
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
                chars[i] = (char)c;
            } else {
                if (c == 92) {
                    c = (char)bytes[++offset];
                    switch (c) {
                        case 117: {
                            c = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 120: {
                            c = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == 34) break;
                chars[i] = (char)c;
                ++offset;
            }
            ++i;
        }
        return new String(chars, 0, this.nameLength);
    }

    @Override
    public String readFieldName() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L && JSONReaderUTF8.isFirstIdentifier(quote)) {
                return this.readFieldNameUnquote();
            }
            return null;
        }
        byte[] bytes = this.bytes;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int end = this.end;
        int nameBegin = this.nameBegin;
        int i = 0;
        while (offset < end) {
            int ch = bytes[offset];
            if (ch == 92) {
                this.nameEscape = true;
                offset += (ch = bytes[offset + 1]) == 117 ? 6 : (ch == 120 ? 4 : 2);
            } else {
                if (ch == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    ch = bytes[offset] & 0xFF;
                    while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                        ch = bytes[++offset] & 0xFF;
                    }
                    if (ch != 58) {
                        throw JSONReaderUTF8.syntaxError(offset, ch);
                    }
                    int n = ch = ++offset == end ? 26 : bytes[offset++];
                    while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                        ch = offset == end ? 26 : bytes[offset++];
                    }
                    this.offset = offset;
                    this.ch = (char)ch;
                    break;
                }
                if (ch >= 0) {
                    ++offset;
                } else {
                    if (this.nameAscii) {
                        this.nameAscii = false;
                    }
                    switch ((ch & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            offset += 2;
                            break;
                        }
                        case 14: {
                            offset += 3;
                            break;
                        }
                        default: {
                            if (ch >> 3 == -2) {
                                offset += 4;
                                break;
                            }
                            throw JSONReaderUTF8.syntaxError(offset, ch);
                        }
                    }
                }
            }
            ++i;
        }
        if (this.nameEnd < nameBegin) {
            throw JSONReaderUTF8.syntaxError(offset, this.ch);
        }
        int length = this.nameEnd - nameBegin;
        if (!this.nameEscape) {
            if (this.nameAscii) {
                long nameValue0 = -1L;
                long nameValue1 = -1L;
                switch (length) {
                    case 1: {
                        nameValue0 = bytes[nameBegin];
                        break;
                    }
                    case 2: {
                        nameValue0 = (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        break;
                    }
                    case 3: {
                        nameValue0 = (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        break;
                    }
                    case 4: {
                        nameValue0 = (bytes[nameBegin + 3] << 24) + (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        break;
                    }
                    case 5: {
                        nameValue0 = ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 6: {
                        nameValue0 = ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 7: {
                        nameValue0 = ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 8: {
                        nameValue0 = ((long)bytes[nameBegin + 7] << 56) + ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        break;
                    }
                    case 9: {
                        nameValue0 = bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 8] << 56) + ((long)bytes[nameBegin + 7] << 48) + ((long)bytes[nameBegin + 6] << 40) + ((long)bytes[nameBegin + 5] << 32) + ((long)bytes[nameBegin + 4] << 24) + ((long)bytes[nameBegin + 3] << 16) + ((long)bytes[nameBegin + 2] << 8) + (long)bytes[nameBegin + 1];
                        break;
                    }
                    case 10: {
                        nameValue0 = (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 9] << 56) + ((long)bytes[nameBegin + 8] << 48) + ((long)bytes[nameBegin + 7] << 40) + ((long)bytes[nameBegin + 6] << 32) + ((long)bytes[nameBegin + 5] << 24) + ((long)bytes[nameBegin + 4] << 16) + ((long)bytes[nameBegin + 3] << 8) + (long)bytes[nameBegin + 2];
                        break;
                    }
                    case 11: {
                        nameValue0 = (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 10] << 56) + ((long)bytes[nameBegin + 9] << 48) + ((long)bytes[nameBegin + 8] << 40) + ((long)bytes[nameBegin + 7] << 32) + ((long)bytes[nameBegin + 6] << 24) + ((long)bytes[nameBegin + 5] << 16) + ((long)bytes[nameBegin + 4] << 8) + (long)bytes[nameBegin + 3];
                        break;
                    }
                    case 12: {
                        nameValue0 = (bytes[nameBegin + 3] << 24) + (bytes[nameBegin + 2] << 16) + (bytes[nameBegin + 1] << 8) + bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 11] << 56) + ((long)bytes[nameBegin + 10] << 48) + ((long)bytes[nameBegin + 9] << 40) + ((long)bytes[nameBegin + 8] << 32) + ((long)bytes[nameBegin + 7] << 24) + ((long)bytes[nameBegin + 6] << 16) + ((long)bytes[nameBegin + 5] << 8) + (long)bytes[nameBegin + 4];
                        break;
                    }
                    case 13: {
                        nameValue0 = ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 12] << 56) + ((long)bytes[nameBegin + 11] << 48) + ((long)bytes[nameBegin + 10] << 40) + ((long)bytes[nameBegin + 9] << 32) + ((long)bytes[nameBegin + 8] << 24) + ((long)bytes[nameBegin + 7] << 16) + ((long)bytes[nameBegin + 6] << 8) + (long)bytes[nameBegin + 5];
                        break;
                    }
                    case 14: {
                        nameValue0 = ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 13] << 56) + ((long)bytes[nameBegin + 12] << 48) + ((long)bytes[nameBegin + 11] << 40) + ((long)bytes[nameBegin + 10] << 32) + ((long)bytes[nameBegin + 9] << 24) + ((long)bytes[nameBegin + 8] << 16) + ((long)bytes[nameBegin + 8] << 8) + (long)bytes[nameBegin + 6];
                        break;
                    }
                    case 15: {
                        nameValue0 = ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 14] << 56) + ((long)bytes[nameBegin + 13] << 48) + ((long)bytes[nameBegin + 12] << 40) + ((long)bytes[nameBegin + 11] << 32) + ((long)bytes[nameBegin + 10] << 24) + ((long)bytes[nameBegin + 9] << 16) + ((long)bytes[nameBegin + 8] << 8) + (long)bytes[nameBegin + 7];
                        break;
                    }
                    case 16: {
                        nameValue0 = ((long)bytes[nameBegin + 7] << 56) + ((long)bytes[nameBegin + 6] << 48) + ((long)bytes[nameBegin + 5] << 40) + ((long)bytes[nameBegin + 4] << 32) + ((long)bytes[nameBegin + 3] << 24) + ((long)bytes[nameBegin + 2] << 16) + ((long)bytes[nameBegin + 1] << 8) + (long)bytes[nameBegin];
                        nameValue1 = ((long)bytes[nameBegin + 15] << 56) + ((long)bytes[nameBegin + 14] << 48) + ((long)bytes[nameBegin + 13] << 40) + ((long)bytes[nameBegin + 12] << 32) + ((long)bytes[nameBegin + 11] << 24) + ((long)bytes[nameBegin + 10] << 16) + ((long)bytes[nameBegin + 9] << 8) + (long)bytes[nameBegin + 8];
                        break;
                    }
                }
                if (nameValue0 != -1L) {
                    if (nameValue1 != -1L) {
                        long nameValue01 = nameValue0 ^ nameValue1;
                        int indexMask = (int)(nameValue01 ^ nameValue01 >>> 32) & JSONFactory.NAME_CACHE2.length - 1;
                        JSONFactory.NameCacheEntry2 entry = JSONFactory.NAME_CACHE2[indexMask];
                        if (entry == null) {
                            String name = this.getLatin1String(nameBegin, length);
                            JSONFactory.NAME_CACHE2[indexMask] = new JSONFactory.NameCacheEntry2(name, nameValue0, nameValue1);
                            return name;
                        }
                        if (entry.value0 == nameValue0 && entry.value1 == nameValue1) {
                            return entry.name;
                        }
                    } else {
                        int indexMask = (int)(nameValue0 ^ nameValue0 >>> 32) & JSONFactory.NAME_CACHE.length - 1;
                        NameCacheEntry entry = JSONFactory.NAME_CACHE[indexMask];
                        if (entry == null) {
                            String name = this.getLatin1String(nameBegin, length);
                            JSONFactory.NAME_CACHE[indexMask] = new NameCacheEntry(name, nameValue0);
                            return name;
                        }
                        if (entry.value == nameValue0) {
                            return entry.name;
                        }
                    }
                }
            }
            if (this.nameAscii) {
                if (JDKUtils.ANDROID_SDK_INT < 34) {
                    char[] chars = this.charBuf;
                    if (chars == null) {
                        this.charBuf = chars = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
                    }
                    if (chars == null || chars.length < length) {
                        this.charBuf = chars = new char[length];
                    }
                    for (int i2 = 0; i2 < length; ++i2) {
                        chars[i2] = (char)bytes[nameBegin + i2];
                    }
                    return new String(chars, 0, length);
                }
                return new String(bytes, nameBegin, length, StandardCharsets.ISO_8859_1);
            }
            return new String(bytes, nameBegin, length, StandardCharsets.UTF_8);
        }
        return this.getFieldName();
    }

    @Override
    public final int readInt32Value() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        byte[] bytes = this.bytes;
        int intValue = 0;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = bytes[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = bytes[offset++];
        } else if (ch == 43) {
            ch = bytes[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            int intValue10 = intValue * 10 + (ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            return this.getInt32Value();
        }
        if (quote != 0) {
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -intValue : intValue;
    }

    @Override
    public final Integer readInt32() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        int intValue = 0;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = bytes[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = bytes[offset++];
        } else if (ch == 43) {
            ch = bytes[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            int intValue10 = intValue * 10 + (ch - 48);
            if (intValue10 < intValue) {
                overflow = true;
                break;
            }
            intValue = intValue10;
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != 0) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -intValue : intValue;
    }

    @Override
    public final long readInt64Value() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        long longValue = 0L;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = bytes[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = bytes[offset++];
        } else if (ch == 43) {
            ch = bytes[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            long intValue10 = longValue * 10L + (long)(ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            return this.getInt64Value();
        }
        if (quote != 0) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]);
            char c = (char)ch;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -longValue : longValue;
    }

    @Override
    public final Long readInt64() {
        boolean overflow;
        boolean negative = false;
        int ch = this.ch;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        long longValue = 0L;
        int quote = 0;
        if (ch == 34 || ch == 39) {
            quote = ch;
            ch = bytes[offset++];
        }
        if (ch == 45) {
            negative = true;
            ch = bytes[offset++];
        } else if (ch == 43) {
            ch = bytes[offset++];
        } else if (ch == 44) {
            throw this.numberError();
        }
        boolean bl = overflow = ch < 48 || ch > 57;
        while (ch >= 48 && ch <= 57) {
            long intValue10 = longValue * 10L + (long)(ch - 48);
            if (intValue10 < longValue) {
                overflow = true;
                break;
            }
            longValue = intValue10;
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 46 || ch == 101 || ch == 69 || ch == 116 || ch == 102 || ch == 110 || ch == 123 || ch == 91 || quote != 0 && ch != quote) {
            overflow = true;
        }
        if (overflow) {
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt64Value();
        }
        this.wasNull = false;
        if (quote != 0) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]);
            char c = (char)ch;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return negative ? -longValue : longValue;
    }

    @Override
    public final double readDoubleValue() {
        long intValue10;
        boolean valid = false;
        this.wasNull = false;
        boolean value = false;
        double doubleValue = 0.0;
        byte[] bytes = this.bytes;
        int quote = 0;
        int ch = this.ch;
        int offset = this.offset;
        if ((ch == 34 || ch == 39) && (ch = bytes[offset++]) == (quote = ch)) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            this.nextIfComma();
            this.wasNull = true;
            return 0.0;
        }
        int start = offset;
        if (ch == 45) {
            this.negative = true;
            ch = bytes[offset++];
        } else {
            this.negative = false;
            if (ch == 43) {
                ch = bytes[offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (offset == this.end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = bytes[offset++];
        }
        this.scale = 0;
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = bytes[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                this.scale = (short)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
        }
        int expValue = 0;
        if (ch == 101 || ch == 69) {
            boolean negativeExp = false;
            if ((ch = bytes[offset++]) == 45) {
                negativeExp = true;
                ch = bytes[offset++];
            } else if (ch == 43) {
                ch = bytes[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110 && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
                offset += 3;
                valid = true;
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                value = true;
                ch = offset == this.end ? 26 : bytes[offset++];
            } else if (ch == 116 && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
                valid = true;
                value = true;
                doubleValue = 1.0;
                ch = (offset += 3) == this.end ? 26 : bytes[offset++];
            } else if (ch == 102 && bytes[offset] == 97 && bytes[offset + 1] == 108 && bytes[offset + 2] == 115 && bytes[offset + 3] == 101) {
                valid = true;
                doubleValue = 0.0;
                value = true;
                ch = (offset += 4) == this.end ? 26 : bytes[offset++];
            } else if (ch == 78 && bytes[offset] == 97 && bytes[offset + 1] == 78) {
                valid = true;
                doubleValue = Double.NaN;
                value = true;
                ch = (offset += 2) == this.end ? 26 : bytes[offset++];
            } else if (ch == 123 && quote == 0) {
                valid = true;
                this.ch = (char)ch;
                this.offset = offset;
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                offset = this.offset;
                ch = this.ch;
                value = true;
                this.wasNull = true;
            } else if (ch == 91 && quote == 0) {
                valid = true;
                this.ch = (char)ch;
                this.offset = offset;
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                offset = this.offset;
                ch = this.ch;
                value = true;
                this.wasNull = true;
            }
        }
        int len = offset - start;
        String str = null;
        if (quote != 0) {
            if (ch != quote) {
                this.offset = offset - 1;
                this.ch = (char)quote;
                str = this.readString();
                offset = this.offset;
            }
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (!value) {
            if (!overflow) {
                if (longValue == 0L) {
                    if (this.scale == 1) {
                        doubleValue = 0.0;
                        value = true;
                    }
                } else {
                    int scale = this.scale - expValue;
                    if (scale == 0) {
                        doubleValue = longValue;
                        if (this.negative) {
                            doubleValue = -doubleValue;
                        }
                        value = true;
                    } else if ((long)((double)longValue) == longValue) {
                        if (0 < scale && scale < JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = (double)longValue / JSONFactory.DOUBLE_10_POW[scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        } else if (0 > scale && scale > -JSONFactory.DOUBLE_10_POW.length) {
                            doubleValue = (double)longValue * JSONFactory.DOUBLE_10_POW[-scale];
                            if (this.negative) {
                                doubleValue = -doubleValue;
                            }
                            value = true;
                        }
                    }
                    if (!value && scale > -128 && scale < 128) {
                        doubleValue = TypeUtils.doubleValue(this.negative ? -1 : 1, longValue, scale);
                        value = true;
                    }
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        doubleValue = Double.parseDouble(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    doubleValue = TypeUtils.parseDouble(bytes, start - 1, len);
                }
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n = ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.ch = (char)ch;
        this.offset = offset;
        return doubleValue;
    }

    @Override
    public final float readFloatValue() {
        long intValue10;
        boolean valid = false;
        this.wasNull = false;
        boolean value = false;
        float floatValue = 0.0f;
        byte[] chars = this.bytes;
        int quote = 0;
        int ch = this.ch;
        int offset = this.offset;
        if ((ch == 34 || ch == 39) && (ch = chars[offset++]) == (quote = ch)) {
            int n = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            this.nextIfComma();
            this.wasNull = true;
            return 0.0f;
        }
        int start = offset;
        if (ch == 45) {
            this.negative = true;
            ch = chars[offset++];
        } else {
            this.negative = false;
            if (ch == 43) {
                ch = chars[offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!overflow) {
                intValue10 = longValue * 10L + (long)(ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                } else {
                    longValue = intValue10;
                }
            }
            if (offset == this.end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = chars[offset++];
        }
        this.scale = 0;
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = chars[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                this.scale = (short)(this.scale + 1);
                if (!overflow) {
                    intValue10 = longValue * 10L + (long)(ch - 48);
                    if (intValue10 < longValue) {
                        overflow = true;
                    } else {
                        longValue = intValue10;
                    }
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
        }
        int expValue = 0;
        if (ch == 101 || ch == 69) {
            boolean negativeExp = false;
            if ((ch = chars[offset++]) == 45) {
                negativeExp = true;
                ch = chars[offset++];
            } else if (ch == 43) {
                ch = chars[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = chars[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110 && chars[offset] == 117 && chars[offset + 1] == 108 && chars[offset + 2] == 108) {
                offset += 3;
                valid = true;
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                value = true;
                ch = offset == this.end ? 26 : chars[offset++];
            } else if (ch == 116 && chars[offset] == 114 && chars[offset + 1] == 117 && chars[offset + 2] == 101) {
                valid = true;
                value = true;
                floatValue = 1.0f;
                ch = (offset += 3) == this.end ? 26 : chars[offset++];
            } else if (ch == 102 && chars[offset] == 97 && chars[offset + 1] == 108 && chars[offset + 2] == 115 && chars[offset + 3] == 101) {
                valid = true;
                floatValue = 0.0f;
                value = true;
                ch = (offset += 4) == this.end ? 26 : chars[offset++];
            } else if (ch == 78 && this.bytes[offset] == 97 && this.bytes[offset + 1] == 78) {
                valid = true;
                floatValue = Float.NaN;
                value = true;
                ch = (offset += 2) == this.end ? 26 : this.bytes[offset++];
            } else if (ch == 123 && quote == 0) {
                valid = true;
                this.ch = (char)ch;
                this.offset = offset;
                Map<String, Object> obj = this.readObject();
                if (!obj.isEmpty()) {
                    throw new JSONException(this.info());
                }
                ch = this.ch;
                offset = this.offset;
                value = true;
                this.wasNull = true;
            } else if (ch == 91 && quote == 0) {
                this.ch = (char)ch;
                this.offset = offset;
                valid = true;
                List array = this.readArray();
                if (!array.isEmpty()) {
                    throw new JSONException(this.info());
                }
                ch = this.ch;
                offset = this.offset;
                value = true;
                this.wasNull = true;
            }
        }
        int len = offset - start;
        String str = null;
        if (quote != 0) {
            if (ch != quote) {
                overflow = true;
                this.offset = offset - 1;
                this.ch = (char)quote;
                str = this.readString();
                offset = this.offset;
            }
            int n = ch = offset >= this.end ? 26 : chars[offset++];
        }
        if (!value) {
            if (!overflow) {
                int scale = this.scale - expValue;
                if (scale == 0) {
                    floatValue = longValue;
                    if (this.negative) {
                        floatValue = -floatValue;
                    }
                    value = true;
                } else if ((long)((float)longValue) == longValue) {
                    if (0 < scale && scale < JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)longValue / JSONFactory.FLOAT_10_POW[scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    } else if (0 > scale && scale > -JSONFactory.FLOAT_10_POW.length) {
                        floatValue = (float)longValue * JSONFactory.FLOAT_10_POW[-scale];
                        if (this.negative) {
                            floatValue = -floatValue;
                        }
                    }
                }
                if (!value && scale > -128 && scale < 128) {
                    floatValue = TypeUtils.floatValue(this.negative ? -1 : 1, longValue, scale);
                    value = true;
                }
            }
            if (!value) {
                if (str != null) {
                    try {
                        floatValue = Float.parseFloat(str);
                    }
                    catch (NumberFormatException ex) {
                        throw new JSONException(this.info(), ex);
                    }
                } else {
                    floatValue = TypeUtils.parseFloat(chars, start - 1, len);
                }
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n = ch = offset >= this.end ? 26 : chars[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= this.end ? 26 : chars[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.ch = (char)ch;
        this.offset = offset;
        return floatValue;
    }

    protected void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        boolean ascii = true;
        this.valueEscape = false;
        byte[] bytes = this.bytes;
        int i = 0;
        while (true) {
            byte c;
            if ((c = bytes[offset]) == 92) {
                this.valueEscape = true;
                offset += (c = bytes[offset + 1]) == 117 ? 6 : (c == 120 ? 4 : 2);
            } else if (c >= 0) {
                if (c == quote) break;
                ++offset;
            } else {
                switch ((c & 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        offset += 2;
                        ascii = false;
                        break;
                    }
                    case 14: {
                        offset += 3;
                        ascii = false;
                        break;
                    }
                    default: {
                        if (c >> 3 == -2) {
                            offset += 4;
                            ++i;
                            ascii = false;
                            break;
                        }
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = bytes[offset]) == '\\') {
                    c = bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                            offset += 2;
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                        }
                    }
                    chars[i2] = c;
                    ++offset;
                } else {
                    if (c == '\"') break;
                    if (c >= '\u0000') {
                        chars[i2] = c;
                        ++offset;
                    } else {
                        switch ((c & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                int n = ++offset;
                                ++offset;
                                byte c2 = bytes[n];
                                chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                int n = ++offset;
                                byte c2 = bytes[n];
                                int n2 = ++offset;
                                ++offset;
                                byte c3 = bytes[n2];
                                chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | c3 & 0x3F);
                                break;
                            }
                            default: {
                                byte c3;
                                byte c2;
                                if (c >> 3 == -2) {
                                    int n = ++offset;
                                    c2 = bytes[n];
                                    int n3 = ++offset;
                                    c3 = bytes[n3];
                                    int n4 = ++offset;
                                    ++offset;
                                    byte c4 = bytes[n4];
                                    int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                        throw new JSONException("malformed input around byte " + offset);
                                    }
                                    chars[i2++] = (char)((uc >>> 10) + 55232);
                                    chars[i2] = (char)((uc & 0x3FF) + 56320);
                                    break;
                                }
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                }
                ++i2;
            }
            str = new String(chars);
        } else {
            str = ascii ? this.getLatin1String(this.offset, offset - this.offset) : new String(bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
        }
        byte ch = bytes[++offset];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = bytes[++offset];
        }
        this.comma = ch == 44;
        this.offset = offset + 1;
        if (ch == 44) {
            this.next();
        } else {
            this.ch = (char)ch;
        }
        this.stringValue = str;
    }

    @Override
    public final boolean skipName() {
        char ch;
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            if ((this.context.features & JSONReader.Feature.AllowUnQuotedFieldNames.mask) != 0L) {
                this.readFieldNameHashCodeUnquote();
                return true;
            }
            throw this.notSupportName();
        }
        int offset = this.offset;
        byte[] bytes = this.bytes;
        while (true) {
            if ((ch = bytes[offset++]) == '\\') {
                offset += (ch = bytes[offset]) == 'u' ? 5 : (ch == 'x' ? 3 : 1);
                continue;
            }
            if (ch == quote) break;
        }
        char c = ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        }
        if (ch != ':') {
            throw JSONReaderUTF8.syntaxError(ch);
        }
        char c2 = ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (char)'\u001a' : bytes[offset++];
        }
        this.offset = offset;
        this.ch = ch;
        return true;
    }

    @Override
    public final void skipValue() {
        byte[] bytes = this.bytes;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        this.comma = false;
        block0 : switch (ch) {
            case 43: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                boolean sign;
                boolean bl = sign = ch == 45 || ch == 43;
                if (sign) {
                    if (offset < end) {
                        ch = bytes[offset++];
                    } else {
                        throw JSONReaderUTF8.numberError(offset, ch);
                    }
                }
                boolean dot = ch == 46;
                boolean num = false;
                if (!dot && ch >= 48 && ch <= 57) {
                    num = true;
                    do {
                        int n = ch = offset == end ? 26 : bytes[offset++];
                    } while (ch >= 48 && ch <= 57);
                }
                if (num && (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83)) {
                    ch = bytes[offset++];
                }
                boolean small = false;
                if (ch == 46) {
                    small = true;
                    int n = ch = offset == end ? 26 : bytes[offset++];
                    if (ch >= 48 && ch <= 57) {
                        do {
                            int n2 = ch = offset == end ? 26 : bytes[offset++];
                        } while (ch >= 48 && ch <= 57);
                    }
                }
                if (!num && !small) {
                    throw JSONReaderUTF8.numberError(offset, ch);
                }
                if (ch == 101 || ch == 69) {
                    ch = bytes[offset++];
                    boolean eSign = false;
                    if (ch == 43 || ch == 45) {
                        eSign = true;
                        if (offset < end) {
                            ch = bytes[offset++];
                        } else {
                            throw JSONReaderUTF8.numberError(offset, ch);
                        }
                    }
                    if (ch >= 48 && ch <= 57) {
                        do {
                            int n = ch = offset == end ? 26 : bytes[offset++];
                        } while (ch >= 48 && ch <= 57);
                    } else if (eSign) {
                        throw JSONReaderUTF8.numberError(offset, ch);
                    }
                }
                if (ch != 76 && ch != 70 && ch != 68 && ch != 66 && ch != 83) break;
                ch = offset == end ? 26 : bytes[offset++];
                break;
            }
            case 116: {
                if (offset + 3 > end) {
                    throw this.error(offset, ch);
                }
                if (bytes[offset] != 114 || bytes[offset + 1] != 117 || bytes[offset + 2] != 101) {
                    throw this.error(offset, ch);
                }
                ch = (offset += 3) == end ? 26 : bytes[offset++];
                break;
            }
            case 102: {
                if (offset + 4 > end) {
                    throw this.error(offset, ch);
                }
                if (bytes[offset] != 97 || bytes[offset + 1] != 108 || bytes[offset + 2] != 115 || bytes[offset + 3] != 101) {
                    throw this.error(offset, ch);
                }
                ch = (offset += 4) == end ? 26 : bytes[offset++];
                break;
            }
            case 110: {
                if (offset + 3 > end) {
                    throw this.error(offset, ch);
                }
                if (bytes[offset] != 117 || bytes[offset + 1] != 108 || bytes[offset + 2] != 108) {
                    throw this.error(offset, ch);
                }
                ch = (offset += 3) == end ? 26 : bytes[offset++];
                break;
            }
            case 34: 
            case 39: {
                int quote = ch;
                ch = bytes[offset++];
                while (true) {
                    if (ch == 92) {
                        if ((ch = bytes[offset++]) == 117) {
                            offset += 4;
                        } else if (ch == 120) {
                            offset += 2;
                        } else if (ch != 92 && ch != 34) {
                            this.char1(ch);
                        }
                        ch = bytes[offset++];
                        continue;
                    }
                    if (ch == quote) {
                        ch = offset == end ? 26 : bytes[offset++];
                        break block0;
                    }
                    ch = bytes[offset++];
                }
            }
            default: {
                if (ch == 91) {
                    this.next();
                    int i = 0;
                    while (true) {
                        if (this.ch == ']') {
                            this.comma = false;
                            offset = this.offset;
                            ch = offset == end ? 26 : bytes[offset++];
                            break block0;
                        }
                        if (i != 0 && !this.comma) {
                            throw this.valueError();
                        }
                        this.comma = false;
                        this.skipValue();
                        ++i;
                    }
                }
                if (ch == 123) {
                    this.next();
                    while (true) {
                        if (this.ch == '}') {
                            this.comma = false;
                            offset = this.offset;
                            ch = offset == end ? 26 : bytes[offset++];
                            break block0;
                        }
                        this.skipName();
                        this.skipValue();
                    }
                }
                if (ch != 83 || !this.nextIfSet()) {
                    throw this.error(offset, ch);
                }
                this.skipValue();
                ch = this.ch;
                offset = this.offset;
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch == 44) {
            this.comma = true;
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        if (!this.comma && ch != 26 && ch != 125 && ch != 93 && ch != 26) {
            throw this.error(offset, ch);
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public final String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        bytes = this.bytes;
        offset = this.nameBegin;
        length = this.nameEnd - offset;
        if (!this.nameEscape) {
            return this.nameAscii != false ? this.getLatin1String(this.nameBegin, length) : new String(bytes, this.nameBegin, length, StandardCharsets.UTF_8);
        }
        chars = new char[this.nameLength];
        i = 0;
        while (true) {
            block18: {
                block17: {
                    if ((c = bytes[offset]) >= '\u0000') break block17;
                    switch ((c & 255) >> 4) {
                        case 12: 
                        case 13: {
                            char2 = bytes[offset + 1];
                            if ((char2 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 31) << 6 | char2 & 63);
                            offset += 2;
                            break;
                        }
                        case 14: {
                            char2 = bytes[offset + 1];
                            char3 = bytes[offset + 2];
                            if ((char2 & 192) != 128 || (char3 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + (offset + 2));
                            }
                            c = (char)((c & 15) << 12 | (char2 & 63) << 6 | char3 & 63);
                            offset += 3;
                            break;
                        }
                        default: {
                            if (c >> 3 != -2) ** GOTO lbl40
                            c2 = bytes[offset + 1];
                            c3 = bytes[offset + 2];
                            c4 = bytes[offset + 3];
                            offset += 4;
                            uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 3678080);
                            if ((c2 & 192) != 128 || (c3 & 192) != 128 || (c4 & 192) != 128 || uc < 65536 || uc >= 0x110000) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            chars[i++] = (char)((uc >>> 10) + 55232);
                            chars[i] = (char)((uc & 1023) + 56320);
                            break block18;
lbl40:
                            // 1 sources

                            c = (char)(c & 255);
                            ++offset;
                        }
                    }
                    chars[i] = c;
                    break block18;
                }
                if (c == '\\') {
                    c = (char)bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c1 = bytes[offset + 1];
                            c2 = bytes[offset + 2];
                            c3 = bytes[offset + 3];
                            c4 = bytes[offset + 4];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            offset += 4;
                            break;
                        }
                        case 'x': {
                            c1 = bytes[offset + 1];
                            c2 = bytes[offset + 2];
                            c = JSONReaderUTF8.char2(c1, c2);
                            offset += 2;
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = this.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i] = c;
                ++offset;
            }
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    @Override
    public final void skipComment() {
        boolean multi;
        int ch;
        int offset = this.offset;
        if (offset + 1 >= this.end) {
            throw new JSONException(this.info());
        }
        byte[] bytes = this.bytes;
        if ((ch = bytes[offset++]) == 42) {
            multi = true;
        } else if (ch == 47) {
            multi = false;
        } else {
            return;
        }
        ch = bytes[offset++];
        while (true) {
            boolean endOfComment = false;
            if (multi) {
                if (ch == 42 && offset <= this.end && bytes[offset] == 47) {
                    ++offset;
                    endOfComment = true;
                }
            } else {
                boolean bl = endOfComment = ch == 10;
            }
            if (endOfComment) {
                if (offset >= this.end) {
                    ch = 26;
                    break;
                }
                ch = bytes[offset];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    if (++offset >= this.end) {
                        ch = 26;
                        break;
                    }
                    ch = bytes[offset];
                }
                ++offset;
                break;
            }
            if (offset >= this.end) {
                ch = 26;
                break;
            }
            ch = bytes[offset++];
        }
        this.ch = (char)ch;
        this.offset = offset;
        if (ch == 47) {
            this.skipComment();
        }
    }

    @Override
    public String readString() {
        byte[] bytes = this.bytes;
        if (this.ch == '\"' || this.ch == '\'') {
            int ch;
            String str;
            int offset;
            char quote = this.ch;
            int start = offset = this.offset;
            int end = this.end;
            boolean ascii = true;
            this.valueEscape = false;
            int i = 0;
            while (true) {
                if (offset >= end) {
                    throw new JSONException("invalid escape character EOI");
                }
                byte ch2 = bytes[offset];
                if (ch2 == 92) {
                    this.valueEscape = true;
                    offset += (ch2 = bytes[offset + 1]) == 117 ? 6 : (ch2 == 120 ? 4 : 2);
                } else if (ch2 >= 0) {
                    if (ch2 == quote) break;
                    ++offset;
                } else {
                    ascii = false;
                    switch ((ch2 & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            offset += 2;
                            break;
                        }
                        case 14: {
                            offset += 3;
                            break;
                        }
                        default: {
                            offset += 4;
                            ++i;
                        }
                    }
                }
                ++i;
            }
            int valueLength = i;
            if (this.valueEscape) {
                char[] chars = this.charBuf;
                if (chars == null) {
                    this.charBuf = chars = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
                }
                if (chars == null || chars.length < valueLength) {
                    this.charBuf = chars = new char[valueLength];
                }
                offset = start;
                int i2 = 0;
                while (true) {
                    char ch3;
                    if ((ch3 = bytes[offset]) == '\\') {
                        ch3 = bytes[++offset];
                        switch (ch3) {
                            case 'u': {
                                ch3 = JSONReaderUTF8.char4(bytes[offset + 1], bytes[offset + 2], bytes[offset + 3], bytes[offset + 4]);
                                offset += 4;
                                break;
                            }
                            case 'x': {
                                ch3 = JSONReaderUTF8.char2(bytes[offset + 1], bytes[offset + 2]);
                                offset += 2;
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            case 'b': {
                                ch3 = '\b';
                                break;
                            }
                            case 't': {
                                ch3 = '\t';
                                break;
                            }
                            case 'n': {
                                ch3 = '\n';
                                break;
                            }
                            case 'f': {
                                ch3 = '\f';
                                break;
                            }
                            case 'r': {
                                ch3 = '\r';
                                break;
                            }
                            default: {
                                ch3 = this.char1(ch3);
                            }
                        }
                        chars[i2] = ch3;
                        ++offset;
                    } else {
                        if (ch3 == quote) break;
                        if (ch3 >= '\u0000') {
                            chars[i2] = ch3;
                            ++offset;
                        } else {
                            switch ((ch3 & 0xFF) >> 4) {
                                case 12: 
                                case 13: {
                                    byte c2 = bytes[offset + 1];
                                    chars[i2] = (char)((ch3 & 0x1F) << 6 | c2 & 0x3F);
                                    offset += 2;
                                    break;
                                }
                                case 14: {
                                    chars[i2] = (char)((ch3 & 0xF) << 12 | (bytes[offset + 1] & 0x3F) << 6 | bytes[offset + 2] & 0x3F);
                                    offset += 3;
                                    break;
                                }
                                default: {
                                    JSONReaderUTF8.char2_utf8(bytes, offset, ch3, chars, i2);
                                    offset += 4;
                                    ++i2;
                                }
                            }
                        }
                    }
                    ++i2;
                }
                str = new String(chars, 0, valueLength);
            } else if (ascii) {
                int len = offset - start;
                if (JDKUtils.ANDROID_SDK_INT < 34) {
                    char[] chars = this.charBuf;
                    if (chars == null) {
                        this.charBuf = chars = (char[])JSONFactory.CHARS_UPDATER.getAndSet(this.cacheItem, null);
                    }
                    if (chars == null || chars.length < len) {
                        this.charBuf = chars = new char[len];
                    }
                    for (int i3 = 0; i3 < len; ++i3) {
                        chars[i3] = (char)bytes[start + i3];
                    }
                    str = new String(chars, 0, len);
                } else {
                    str = new String(bytes, start, len, StandardCharsets.ISO_8859_1);
                }
            } else {
                str = new String(bytes, start, offset - start, StandardCharsets.UTF_8);
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (str.isEmpty() && (this.context.features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L) {
                str = null;
            }
            int n = ch = ++offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            this.comma = ch == 44;
            if (this.comma) {
                int n2 = ch = offset == end ? 26 : bytes[offset++];
                while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                    ch = offset == end ? 26 : bytes[offset++];
                }
            }
            this.ch = (char)ch;
            this.offset = offset;
            return str;
        }
        return this.readStringNotMatch();
    }

    @Override
    public final void readNumber0() {
        int digit;
        int multmin;
        boolean valid = false;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        int firstOffset = this.offset;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        int offset = this.offset;
        int end = this.end;
        int quote = 0;
        if ((ch == 34 || ch == 39) && (ch = (char)bytes[offset++]) == (quote = ch)) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            this.comma = this.nextIfComma();
            this.wasNull = true;
            this.valueType = (byte)5;
            return;
        }
        int start = offset;
        if (ch == 45) {
            if (offset == end) {
                throw new JSONException(this.info("illegal input"));
            }
            multmin = -214748364;
            this.negative = true;
            ch = bytes[offset++];
        } else {
            if (ch == 43) {
                if (offset == end) {
                    throw new JSONException(this.info("illegal input"));
                }
                ch = bytes[offset++];
            }
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!intOverflow) {
                digit = ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (offset == end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = bytes[offset++];
        }
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = bytes[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                if (!intOverflow) {
                    digit = ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (short)(this.scale + 1);
                if (offset == end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? offset - 2 - numStart : offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                if (this.negative) {
                    --numStart;
                }
                this.stringValue = new String(bytes, numStart, offset - 1 - numStart);
            } else {
                this.bigInt(bytes, numStart, offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (ch == 101 || ch == 69) {
            boolean negativeExp = false;
            int expValue = 0;
            if ((ch = bytes[offset++]) == 45) {
                negativeExp = true;
                ch = bytes[offset++];
            } else if (ch == 43) {
                ch = (char)bytes[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == end) {
                    ch = 26;
                    break;
                }
                ch = bytes[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110) {
                if (bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
                    valid = true;
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    ch = (offset += 3) == end ? 26 : bytes[offset++];
                }
            } else if (ch == 116 && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
                valid = true;
                this.boolValue = true;
                this.valueType = (byte)4;
                ch = (offset += 3) == end ? 26 : bytes[offset++];
            } else if (ch == 102 && bytes[offset] == 97 && bytes[offset + 1] == 108 && bytes[offset + 2] == 115 && bytes[offset + 3] == 101) {
                valid = true;
                this.boolValue = false;
                this.valueType = (byte)4;
                ch = (offset += 4) == end ? 26 : bytes[offset++];
            } else {
                if (ch == 123 && quote == 0) {
                    this.offset = offset;
                    this.ch = (char)ch;
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (ch == 91 && quote == 0) {
                    this.offset = offset;
                    this.ch = (char)ch;
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != 0) {
            if (ch != quote) {
                this.offset = firstOffset;
                this.ch = (char)quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
            if (!intOverflow) {
                switch (ch) {
                    case 66: {
                        this.valueType = (byte)9;
                        break;
                    }
                    case 83: {
                        this.valueType = (byte)10;
                        break;
                    }
                    case 76: {
                        this.valueType = (byte)11;
                        break;
                    }
                    case 70: {
                        this.valueType = (byte)12;
                        break;
                    }
                    case 68: {
                        this.valueType = (byte)13;
                        break;
                    }
                }
            }
            int n = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == end ? 26 : bytes[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.offset = offset;
        this.ch = (char)ch;
    }

    @Override
    public final boolean readIfNull() {
        byte[] bytes = this.bytes;
        int ch = this.ch;
        int offset = this.offset;
        if (ch == 110 && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            ch = offset + 3 == this.end ? 26 : (int)((char)bytes[offset + 3]);
            offset += 4;
        } else {
            return false;
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]);
            char c = (char)ch;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean isArray() {
        return this.ch == '[';
    }

    @Override
    public final boolean isNull() {
        return this.ch == 'n' && this.offset < this.end && this.bytes[this.offset] == 117;
    }

    @Override
    public final Date readNullOrNewDate() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        Date date = null;
        if (offset + 2 < this.end && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            ch = offset + 3 == this.end ? 26 : bytes[offset + 3];
            offset += 4;
        } else if (offset + 1 < this.end && bytes[offset] == 101 && bytes[offset + 1] == 119) {
            ch = offset + 3 == this.end ? 26 : bytes[offset + 2];
            offset += 3;
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            if (offset + 4 < this.end && ch == 68 && bytes[offset] == 97 && bytes[offset + 1] == 116 && bytes[offset + 2] == 101) {
                ch = offset + 3 == this.end ? 26 : bytes[offset + 3];
                offset += 4;
            } else {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            if (ch != 40 || offset >= this.end) {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            ch = bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
            this.ch = (char)ch;
            this.offset = offset;
            long millis = this.readInt64Value();
            ch = this.ch;
            offset = this.offset;
            if (ch != 41) {
                throw new JSONException("json syntax error, not match new Date" + offset);
            }
            ch = offset >= this.end ? 26 : bytes[offset++];
            date = new Date(millis);
        } else {
            throw new JSONException("json syntax error, not match null or new Date" + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return date;
    }

    @Override
    public final boolean nextIfNull() {
        if (this.ch == 'n' && this.offset + 2 < this.end && this.bytes[this.offset] == 117) {
            this.readNull();
            return true;
        }
        return false;
    }

    @Override
    public final void readNull() {
        int ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            ch = (offset += 3) == this.end ? 26 : bytes[offset++];
        } else {
            throw new JSONException("json syntax error, not match null" + offset);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= this.end ? 26 : bytes[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
    }

    @Override
    public final int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        byte[] bytes = this.bytes;
        int i8 = i + 8;
        if (i8 < this.end && i8 < bytes.length && bytes[i] != quote && bytes[i + 1] != quote && bytes[i + 2] != quote && bytes[i + 3] != quote && bytes[i + 4] != quote && bytes[i + 5] != quote && bytes[i + 6] != quote && bytes[i + 7] != quote) {
            i += 8;
            len += 8;
        }
        while (i < this.end && bytes[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    public final LocalDate readLocalDate() {
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (this.ch == '\"' || this.ch == '\'') {
            JSONReader.Context context = this.context;
            if (context.dateFormat == null || context.formatyyyyMMddhhmmss19 || context.formatyyyyMMddhhmmssT19 || context.formatyyyyMMdd8 || context.formatISO8601) {
                char quote = this.ch;
                int c10 = offset + 10;
                if (c10 < bytes.length && c10 < this.end && bytes[offset + 4] == 45 && bytes[offset + 7] == 45 && bytes[offset + 10] == quote) {
                    byte y0 = bytes[offset];
                    byte y1 = bytes[offset + 1];
                    byte y2 = bytes[offset + 2];
                    byte y3 = bytes[offset + 3];
                    byte m0 = bytes[offset + 5];
                    byte m1 = bytes[offset + 6];
                    byte d0 = bytes[offset + 8];
                    byte d1 = bytes[offset + 9];
                    if (y0 >= 48 && y0 <= 57 && y1 >= 48 && y1 <= 57 && y2 >= 48 && y2 <= 57 && y3 >= 48 && y3 <= 57) {
                        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
                        if (m0 >= 48 && m0 <= 57 && m1 >= 48 && m1 <= 57) {
                            int month = (m0 - 48) * 10 + (m1 - 48);
                            if (d0 >= 48 && d0 <= 57 && d1 >= 48 && d1 <= 57) {
                                LocalDate ldt;
                                int dom = (d0 - 48) * 10 + (d1 - 48);
                                try {
                                    ldt = year == 0 && month == 0 && dom == 0 ? null : LocalDate.of(year, month, dom);
                                }
                                catch (DateTimeException ex) {
                                    throw new JSONException(this.info("read date error"), ex);
                                }
                                this.offset = offset + 11;
                                this.next();
                                this.comma = this.ch == ',';
                                if (this.comma) {
                                    this.next();
                                }
                                return ldt;
                            }
                        }
                    }
                }
            }
        }
        return super.readLocalDate();
    }

    @Override
    protected final ZonedDateTime readZonedDateTimeX(int len) {
        ZonedDateTime zdt;
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        if (len < 19) {
            return null;
        }
        if (len == 30 && this.bytes[this.offset + 29] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime29(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else if (len == 29 && this.bytes[this.offset + 28] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime28(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else if (len == 28 && this.bytes[this.offset + 27] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime27(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else if (len == 27 && this.bytes[this.offset + 26] == 90) {
            LocalDateTime ldt = DateUtils.parseLocalDateTime26(this.bytes, this.offset);
            zdt = ZonedDateTime.of(ldt, ZoneId.UTC);
        } else {
            zdt = DateUtils.parseZonedDateTime(this.bytes, this.offset, len, this.context.zoneId);
        }
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return zdt;
    }

    @Override
    public final LocalDate readLocalDate8() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate8(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate9() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate9(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        this.offset += 10;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final LocalDate readLocalDate10() {
        LocalDate ldt;
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        try {
            ldt = DateUtils.parseLocalDate10(this.bytes, this.offset);
        }
        catch (DateTimeException ex) {
            throw new JSONException(this.info("read date error"), ex);
        }
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDate readLocalDate11() {
        if (!this.isString()) {
            throw new JSONException("localDate only support string input");
        }
        LocalDate ldt = DateUtils.parseLocalDate11(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime17() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime17(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 18;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalTime readLocalTime5() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime5(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 6;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime8() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime8(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 9;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime10() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime10(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 11;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime11() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime11(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 12;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime12() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime12(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalTime readLocalTime18() {
        if (!this.isString()) {
            throw new JSONException("localTime only support string input");
        }
        LocalTime time = DateUtils.parseLocalTime18(this.bytes, this.offset);
        if (time == null) {
            return null;
        }
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return time;
    }

    @Override
    protected final LocalDateTime readLocalDateTime12() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime12(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 13;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime14() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime14(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 15;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime16() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime16(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 17;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime18() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime18(this.bytes, this.offset);
        this.offset += 19;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime19() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime19(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    protected final LocalDateTime readLocalDateTime20() {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTime20(this.bytes, this.offset);
        if (ldt == null) {
            return null;
        }
        this.offset += 21;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final long readMillis19() {
        char quote = this.ch;
        if (quote != '\"' && quote != '\'') {
            throw new JSONException("date only support string input");
        }
        if (this.offset + 18 >= this.end) {
            this.wasNull = true;
            return 0L;
        }
        long millis = DateUtils.parseMillis19(this.bytes, this.offset, this.context.zoneId);
        if (this.bytes[this.offset + 19] != quote) {
            throw new JSONException(this.info("illegal date input"));
        }
        this.offset += 20;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return millis;
    }

    @Override
    protected final LocalDateTime readLocalDateTimeX(int len) {
        if (!this.isString()) {
            throw new JSONException("date only support string input");
        }
        LocalDateTime ldt = DateUtils.parseLocalDateTimeX(this.bytes, this.offset, len);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        this.comma = this.ch == ',';
        if (this.comma) {
            this.next();
        }
        return ldt;
    }

    @Override
    public final BigDecimal readBigDecimal() {
        long r;
        boolean valid = false;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        int offset = this.offset;
        boolean value = false;
        BigDecimal decimal = null;
        int quote = 0;
        if ((ch == 34 || ch == 39) && (ch = bytes[offset++]) == (quote = ch)) {
            this.ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]);
            this.offset = offset;
            this.nextIfComma();
            return null;
        }
        int start = offset;
        if (ch == 45) {
            this.negative = true;
            ch = bytes[offset++];
        } else {
            this.negative = false;
            if (ch == 43) {
                ch = bytes[offset++];
            }
        }
        this.valueType = 1;
        boolean overflow = false;
        long longValue = 0L;
        while (ch >= 48 && ch <= 57) {
            valid = true;
            if (!overflow) {
                r = longValue * 10L;
                if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                    longValue = r + (long)(ch - 48);
                } else {
                    overflow = true;
                }
            }
            if (offset == this.end) {
                ch = 26;
                ++offset;
                break;
            }
            ch = bytes[offset++];
        }
        this.scale = 0;
        if (ch == 46) {
            this.valueType = (byte)2;
            ch = bytes[offset++];
            while (ch >= 48 && ch <= 57) {
                valid = true;
                this.scale = (short)(this.scale + 1);
                if (!overflow) {
                    r = longValue * 10L;
                    if ((longValue | 0xAL) >>> 31 == 0L || r / 10L == longValue) {
                        longValue = r + (long)(ch - 48);
                    } else {
                        overflow = true;
                    }
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
        }
        int expValue = 0;
        if (ch == 101 || ch == 69) {
            boolean negativeExp;
            if ((negativeExp = (ch = bytes[offset++]) == 45) || ch == 43) {
                ch = bytes[offset++];
            }
            while (ch >= 48 && ch <= 57) {
                valid = true;
                int byteVal = ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 1023) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (offset == this.end) {
                    ch = 26;
                    ++offset;
                    break;
                }
                ch = bytes[offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (short)expValue;
            this.valueType = (byte)2;
        }
        if (offset == start) {
            if (ch == 110 && bytes[offset++] == 117 && bytes[offset++] == 108 && bytes[offset++] == 108) {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("long value not support input null"));
                }
                this.wasNull = true;
                value = true;
                ch = offset == this.end ? 26 : bytes[offset];
                ++offset;
                valid = true;
            } else if (ch == 116 && offset + 3 <= this.end && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
                valid = true;
                value = true;
                decimal = BigDecimal.ONE;
                ch = (offset += 3) == this.end ? 26 : bytes[offset];
                ++offset;
            } else if (ch == 102 && offset + 4 <= this.end && bytes[offset] == 97 && bytes[offset + 1] == 108 && bytes[offset + 2] == 115 && bytes[offset + 3] == 101) {
                valid = true;
                decimal = BigDecimal.ZERO;
                value = true;
                ch = (offset += 4) == this.end ? 26 : bytes[offset];
                ++offset;
            } else {
                if (ch == 123 && quote == 0) {
                    JSONObject jsonObject = new JSONObject();
                    this.readObject((Object)jsonObject, 0L);
                    this.wasNull = false;
                    return this.decimal(jsonObject);
                }
                if (ch == 91 && quote == 0) {
                    List array = this.readArray();
                    if (!array.isEmpty()) {
                        throw new JSONException(this.info());
                    }
                    this.wasNull = true;
                    return null;
                }
            }
        }
        int len = offset - start;
        if (quote != 0) {
            if (ch != quote) {
                String str = this.readString();
                try {
                    return TypeUtils.toBigDecimal(str);
                }
                catch (NumberFormatException e) {
                    throw new JSONException(this.info(e.getMessage()), e);
                }
            }
            int n = ch = offset >= this.end ? 26 : bytes[offset++];
        }
        if (!value) {
            if (expValue == 0 && !overflow && longValue != 0L) {
                decimal = BigDecimal.valueOf(this.negative ? -longValue : longValue, this.scale);
                value = true;
            }
            if (!value) {
                decimal = TypeUtils.parseBigDecimal(bytes, start - 1, len);
            }
            if (ch == 76 || ch == 70 || ch == 68 || ch == 66 || ch == 83) {
                int n = ch = offset >= this.end ? 26 : bytes[offset++];
            }
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        if (!valid) {
            throw new JSONException(this.info("illegal input error"));
        }
        this.ch = (char)ch;
        this.offset = offset;
        return decimal;
    }

    @Override
    public final UUID readUUID() {
        int i;
        byte ch = this.ch;
        if (ch == 110) {
            this.readNull();
            return null;
        }
        if (ch != 34 && ch != 39) {
            throw new JSONException(this.info("syntax error, can not read uuid"));
        }
        byte quote = ch;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        long hi = 0L;
        long lo = 0L;
        if (offset + 36 < bytes.length && bytes[offset + 36] == quote && bytes[offset + 8] == 45 && bytes[offset + 13] == 45 && bytes[offset + 18] == 45 && bytes[offset + 23] == 45) {
            for (i = 0; i < 8; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            for (i = 9; i < 13; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            for (i = 14; i < 18; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            for (i = 19; i < 23; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            for (i = 24; i < 36; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            offset += 37;
        } else if (offset + 32 < bytes.length && bytes[offset + 32] == quote) {
            for (i = 0; i < 16; ++i) {
                hi = (hi << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            for (i = 16; i < 32; ++i) {
                lo = (lo << 4) + (long)JSONFactory.UUID_VALUES[bytes[offset + i] - 48];
            }
            offset += 33;
        } else {
            String str = this.readString();
            if (str.isEmpty()) {
                return null;
            }
            return UUID.fromString(str);
        }
        byte by = ch = offset == this.end ? (byte)26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? (byte)26 : bytes[offset++];
        }
        this.offset = offset;
        this.comma = ch == 44;
        if (this.comma) {
            this.next();
        } else {
            this.ch = (char)ch;
        }
        return new UUID(hi, lo);
    }

    @Override
    public final String readPattern() {
        int ch;
        int offset;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        byte[] bytes = this.bytes;
        int start = offset = this.offset;
        while (offset < this.end && bytes[offset] != 47) {
            ++offset;
        }
        String str = new String(bytes, start, offset - start, StandardCharsets.UTF_8);
        int n = ch = ++offset == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return str;
    }

    @Override
    public boolean nextIfNullOrEmptyString() {
        int ch;
        char first = this.ch;
        int end = this.end;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        if (first == 'n' && offset + 2 < end && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
            offset += 3;
        } else if ((first == '\"' || first == '\'') && offset < end && bytes[offset] == first) {
            ++offset;
        } else {
            return false;
        }
        int n = ch = offset == end ? 26 : bytes[offset++];
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == end ? 26 : bytes[offset++];
        }
        while (ch >= 0 && ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == end ? 26 : bytes[offset++];
        }
        if (ch < 0) {
            this.char_utf8(ch, offset);
            return true;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 2 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2) {
            return false;
        }
        int n = ch = (offset += 2) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 3 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 3 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2 || bytes[offset + 2] != c3) {
            return false;
        }
        int n = ch = (offset += 3) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 4 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 4 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2 || bytes[offset + 2] != c3 || bytes[offset + 3] != c4) {
            return false;
        }
        int n = ch = (offset += 4) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 5 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final boolean nextIfMatchIdent(char c0, char c1, char c2, char c3, char c4, char c5) {
        int ch;
        if (this.ch != c0) {
            return false;
        }
        byte[] bytes = this.bytes;
        int offset = this.offset;
        if (offset + 5 > this.end || bytes[offset] != c1 || bytes[offset + 1] != c2 || bytes[offset + 2] != c3 || bytes[offset + 3] != c4 || bytes[offset + 4] != c5) {
            return false;
        }
        int n = ch = (offset += 5) == this.end ? 26 : bytes[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (offset == this.offset + 6 && ch != 26 && ch != 40 && ch != 91 && ch != 93 && ch != 41 && ch != 58 && ch != 44) {
            return false;
        }
        this.offset = offset;
        this.ch = (char)ch;
        return true;
    }

    @Override
    public final byte[] readHex() {
        int quote;
        int offset = this.offset;
        byte[] bytes = this.bytes;
        int ch = this.ch;
        if (ch == 120) {
            int n = ch = offset == this.end ? 26 : bytes[offset++];
        }
        if ((quote = ch) != 39 && quote != 34) {
            throw new JSONException("illegal state. " + ch);
        }
        int start = offset;
        int n = ch = offset == this.end ? 26 : bytes[offset++];
        while (true) {
            if (!(ch >= 48 && ch <= 57 || ch >= 65 && ch <= 70)) {
                if (ch == quote) break;
                throw new JSONException("illegal state. " + ch);
            }
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        ch = offset == this.end ? 26 : bytes[offset++];
        int len = offset - start - 2;
        if (ch == 26) {
            ++len;
        }
        if (len % 2 != 0) {
            throw new JSONException("illegal state. " + len);
        }
        byte[] hex = new byte[len / 2];
        for (int i = 0; i < hex.length; ++i) {
            byte c0 = bytes[start + i * 2];
            byte c1 = bytes[start + i * 2 + 1];
            int b0 = c0 - (c0 <= 57 ? 48 : 55);
            int b1 = c1 - (c1 <= 57 ? 48 : 55);
            hex[i] = (byte)(b0 << 4 | b1);
        }
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        if (ch != 44 || offset >= this.end) {
            this.offset = offset;
            this.ch = (char)ch;
            return hex;
        }
        this.comma = true;
        int n2 = ch = offset == this.end ? 26 : bytes[offset++];
        while (ch == 0 || ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : bytes[offset++];
        }
        this.offset = offset;
        this.ch = (char)ch;
        if (this.ch == '/') {
            this.skipComment();
        }
        return hex;
    }

    @Override
    public boolean isReference() {
        byte[] bytes = this.bytes;
        char ch = this.ch;
        if (ch != '{') {
            return false;
        }
        int offset = this.offset;
        int end = this.end;
        if (offset == end) {
            return false;
        }
        ch = bytes[offset];
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = bytes[offset];
        }
        char quote = ch;
        if (offset + 6 >= end || bytes[offset + 1] != 36 || bytes[offset + 2] != 114 || bytes[offset + 3] != 101 || bytes[offset + 4] != 102 || bytes[offset + 5] != quote) {
            return false;
        }
        ch = bytes[offset += 6];
        while (ch >= '\u0000' && ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = bytes[offset];
        }
        if (ch != ':' || offset + 1 >= end) {
            return false;
        }
        ch = bytes[++offset];
        while (ch >= '\u0000' && ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            if (++offset >= end) {
                return false;
            }
            ch = bytes[offset];
        }
        if (ch != quote || offset + 1 < end && bytes[offset + 1] == 35) {
            return false;
        }
        this.referenceBegin = offset;
        return true;
    }

    @Override
    public final String readReference() {
        if (this.referenceBegin == this.end) {
            return null;
        }
        byte[] chars = this.bytes;
        this.offset = this.referenceBegin;
        this.ch = (char)chars[this.offset++];
        String reference = this.readString();
        int ch = this.ch;
        int offset = this.offset;
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        if (ch != 125) {
            throw new JSONException("illegal reference : " + reference);
        }
        int n = ch = offset == this.end ? 26 : chars[offset++];
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset == this.end ? 26 : chars[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n2 = ch = offset == this.end ? 26 : chars[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset == this.end ? 26 : chars[offset++];
            }
        }
        this.ch = (char)ch;
        this.offset = offset;
        return reference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final boolean readBoolValue() {
        boolean val;
        this.wasNull = false;
        byte[] bytes = this.bytes;
        int offset = this.offset;
        int ch = this.ch;
        if (ch == 116 && offset + 2 < bytes.length && bytes[offset] == 114 && bytes[offset + 1] == 117 && bytes[offset + 2] == 101) {
            offset += 3;
            val = true;
        } else if (ch == 102 && offset + 3 < bytes.length && bytes[offset] == 97 && bytes[offset + 1] == 108 && bytes[offset + 2] == 115 && bytes[offset + 3] == 101) {
            offset += 4;
            val = false;
        } else {
            if (ch == 45 || ch >= 48 && ch <= 57) {
                this.readNumber();
                if (this.valueType != 1) return false;
                if ((this.context.features & JSONReader.Feature.NonZeroNumberCastToBooleanAsTrue.mask) != 0L) {
                    if (this.mag0 != 0) return true;
                    if (this.mag1 != 0) return true;
                    if (this.mag2 != 0) return true;
                    if (this.mag3 == 0) return false;
                    return true;
                }
                if (this.mag0 != 0) return false;
                if (this.mag1 != 0) return false;
                if (this.mag2 != 0) return false;
                if (this.mag3 != 1) return false;
                return true;
            }
            if (ch == 110 && offset + 2 < bytes.length && bytes[offset] == 117 && bytes[offset + 1] == 108 && bytes[offset + 2] == 108) {
                if ((this.context.features & JSONReader.Feature.ErrorOnNullForPrimitives.mask) != 0L) {
                    throw new JSONException(this.info("boolean value not support input null"));
                }
                this.wasNull = true;
                offset += 3;
                val = false;
            } else {
                if (ch != 34) throw new JSONException("syntax error : " + ch);
                if (offset + 1 < bytes.length && bytes[offset + 1] == 34) {
                    byte c0 = bytes[offset];
                    offset += 2;
                    if (c0 == 48 || c0 == 78) {
                        val = false;
                    } else {
                        if (c0 != 49) {
                            if (c0 != 89) throw new JSONException("can not convert to boolean : " + c0);
                        }
                        val = true;
                    }
                } else {
                    String str = this.readString();
                    if ("true".equalsIgnoreCase(str)) {
                        return true;
                    }
                    if ("false".equalsIgnoreCase(str)) {
                        return false;
                    }
                    if (!str.isEmpty()) {
                        if (!"null".equalsIgnoreCase(str)) throw new JSONException("can not convert to boolean : " + str);
                    }
                    this.wasNull = true;
                    return false;
                }
            }
        }
        char c = (char)(ch = (char)(offset == this.end ? 26 : (char)bytes[offset++]));
        while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
            ch = offset >= this.end ? 26 : bytes[offset++];
        }
        this.comma = ch == 44;
        if (this.comma) {
            int n = ch = offset >= this.end ? 26 : bytes[offset++];
            while (ch <= 32 && (1L << ch & 0x100003700L) != 0L) {
                ch = offset >= this.end ? 26 : bytes[offset++];
            }
        }
        this.offset = offset;
        this.ch = (char)ch;
        return val;
    }

    @Override
    public final String info(String message) {
        int line = 1;
        int column = 0;
        int i = 0;
        while (i < this.offset && i < this.end) {
            if (this.bytes[i] == 10) {
                column = 1;
                ++line;
            }
            ++i;
            ++column;
        }
        StringBuilder buf = new StringBuilder();
        if (message != null && !message.isEmpty()) {
            buf.append(message).append(", ");
        }
        buf.append("offset ").append(this.offset).append(", character ").append(this.ch).append(", line ").append(line).append(", column ").append(column).append(", fastjson-version ").append("2.0.48").append(line > 1 ? (char)'\n' : ' ');
        String str = new String(this.bytes, this.start, this.length < 65535 ? this.length : 65535);
        buf.append(str);
        return buf.toString();
    }

    @Override
    public final void close() {
        char[] charBuf;
        JSONFactory.CacheItem cacheItem = this.cacheItem;
        byte[] byteBuf = this.byteBuf;
        if (byteBuf != null && byteBuf.length < 0x100000) {
            JSONFactory.BYTES_UPDATER.lazySet(cacheItem, byteBuf);
        }
        if ((charBuf = this.charBuf) != null && charBuf.length < 0x100000) {
            JSONFactory.CHARS_UPDATER.lazySet(cacheItem, charBuf);
        }
        if (this.in != null) {
            try {
                this.in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

