/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONWriterJSONB;
import com.alibaba.fastjson2.JSONWriterUTF16;
import com.alibaba.fastjson2.JSONWriterUTF8;
import com.alibaba.fastjson2.SymbolTable;
import com.alibaba.fastjson2.filter.AfterFilter;
import com.alibaba.fastjson2.filter.BeforeFilter;
import com.alibaba.fastjson2.filter.ContextNameFilter;
import com.alibaba.fastjson2.filter.ContextValueFilter;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.filter.LabelFilter;
import com.alibaba.fastjson2.filter.NameFilter;
import com.alibaba.fastjson2.filter.PropertyFilter;
import com.alibaba.fastjson2.filter.PropertyPreFilter;
import com.alibaba.fastjson2.filter.ValueFilter;
import com.alibaba.fastjson2.time.DateTimeFormatter;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.io.Closeable;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;

public abstract class JSONWriter
implements Closeable {
    static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    public final Context context;
    public final boolean utf8;
    public final boolean utf16;
    public final boolean jsonb;
    public final boolean useSingleQuote;
    public final SymbolTable symbolTable;
    protected final Charset charset;
    protected final char quote;
    protected final int maxArraySize;
    protected boolean startObject;
    protected int level;
    protected int off;
    protected Object rootObject;
    protected IdentityHashMap<Object, Path> refs;
    protected Path path;
    protected String lastReference;
    protected boolean pretty;
    protected int indent;

    protected JSONWriter(Context context, SymbolTable symbolTable, boolean jsonb, Charset charset) {
        this.context = context;
        this.symbolTable = symbolTable;
        this.charset = charset;
        this.jsonb = jsonb;
        this.utf8 = !jsonb && charset == StandardCharsets.UTF_8;
        this.utf16 = !jsonb && charset == StandardCharsets.UTF_16;
        this.useSingleQuote = !jsonb && (context.features & Feature.UseSingleQuotes.mask) != 0L;
        this.quote = (char)(this.useSingleQuote ? 39 : 34);
        this.maxArraySize = (context.features & Feature.LargeObject.mask) != 0L ? 0x40000000 : 0x4000000;
        this.pretty = (context.features & Feature.PrettyFormat.mask) != 0L;
    }

    public final Charset getCharset() {
        return this.charset;
    }

    public final boolean isUTF8() {
        return this.utf8;
    }

    public final boolean isUTF16() {
        return this.utf16;
    }

    public final boolean isIgnoreNoneSerializable() {
        return (this.context.features & Feature.IgnoreNoneSerializable.mask) != 0L;
    }

    public final boolean isIgnoreNoneSerializable(Object object) {
        return (this.context.features & Feature.IgnoreNoneSerializable.mask) != 0L && object != null && !Serializable.class.isAssignableFrom(object.getClass());
    }

    public final SymbolTable getSymbolTable() {
        return this.symbolTable;
    }

    public final void config(Feature ... features) {
        this.context.config(features);
    }

    public final void config(Feature feature, boolean state) {
        this.context.config(feature, state);
    }

    public final Context getContext() {
        return this.context;
    }

    public final int level() {
        return this.level;
    }

    public final void setRootObject(Object rootObject) {
        this.rootObject = rootObject;
        this.path = Path.ROOT;
    }

    public final String setPath(String name, Object object) {
        Path previous;
        if (!this.isRefDetect(object)) {
            return null;
        }
        this.path = new Path(this.path, name);
        if (object == this.rootObject) {
            previous = Path.ROOT;
        } else if (this.refs == null || (previous = this.refs.get(object)) == null) {
            if (this.refs == null) {
                this.refs = new IdentityHashMap(8);
            }
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public final String setPath(FieldWriter fieldWriter, Object object) {
        Path previous;
        if (!this.isRefDetect(object)) {
            return null;
        }
        Path path = this.path = this.path == Path.ROOT ? fieldWriter.getRootParentPath() : fieldWriter.getPath(this.path);
        if (object == this.rootObject) {
            previous = Path.ROOT;
        } else if (this.refs == null || (previous = this.refs.get(object)) == null) {
            if (this.refs == null) {
                this.refs = new IdentityHashMap(8);
            }
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public final String setPath(int index, Object object) {
        Path previous;
        if (!this.isRefDetect(object)) {
            return null;
        }
        Path path = index == 0 ? (this.path.child0 != null ? this.path.child0 : (this.path.child0 = new Path(this.path, index))) : (index == 1 ? (this.path.child1 != null ? this.path.child1 : (this.path.child1 = new Path(this.path, index))) : (this.path = new Path(this.path, index)));
        if (object == this.rootObject) {
            previous = Path.ROOT;
        } else if (this.refs == null || (previous = this.refs.get(object)) == null) {
            if (this.refs == null) {
                this.refs = new IdentityHashMap(8);
            }
            this.refs.put(object, this.path);
            return null;
        }
        return previous.toString();
    }

    public final void popPath(Object object) {
        if (this.path == null || (this.context.features & Feature.ReferenceDetection.mask) == 0L || object == Collections.EMPTY_LIST || object == Collections.EMPTY_SET) {
            return;
        }
        this.path = this.path.parent;
    }

    public final boolean hasFilter() {
        return this.context.hasFilter;
    }

    public final boolean hasFilter(long feature) {
        return this.context.hasFilter || (this.context.features & feature) != 0L;
    }

    public final boolean hasFilter(boolean containsNoneFieldGetter) {
        return this.context.hasFilter || containsNoneFieldGetter && (this.context.features & Feature.IgnoreNonFieldGetter.mask) != 0L;
    }

    public final boolean isWriteNulls() {
        return (this.context.features & Feature.WriteNulls.mask) != 0L;
    }

    public final boolean isRefDetect() {
        return (this.context.features & Feature.ReferenceDetection.mask) != 0L;
    }

    public final boolean isUseSingleQuotes() {
        return this.useSingleQuote;
    }

    public final boolean isRefDetect(Object object) {
        return (this.context.features & Feature.ReferenceDetection.mask) != 0L && object != null && !ObjectWriterProvider.isNotReferenceDetect(object.getClass());
    }

    public final boolean containsReference(Object value) {
        return this.refs != null && this.refs.containsKey(value);
    }

    public final boolean removeReference(Object value) {
        return this.refs != null && this.refs.remove(value) != null;
    }

    public final boolean isBeanToArray() {
        return (this.context.features & Feature.BeanToArray.mask) != 0L;
    }

    public final boolean isEnabled(Feature feature) {
        return (this.context.features & feature.mask) != 0L;
    }

    public final boolean isEnabled(long feature) {
        return (this.context.features & feature) != 0L;
    }

    public final long getFeatures() {
        return this.context.features;
    }

    public final long getFeatures(long features) {
        return this.context.features | features;
    }

    public final boolean isIgnoreErrorGetter() {
        return (this.context.features & Feature.IgnoreErrorGetter.mask) != 0L;
    }

    public final boolean isWriteTypeInfo(Object object, Class fieldClass) {
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public final boolean isWriteTypeInfo(Object object, Type fieldType) {
        Type rawType;
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L || object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType instanceof GenericArrayType) {
            if (JSONWriter.isWriteTypeInfoGenericArray((GenericArrayType)fieldType, objectClass)) {
                return false;
            }
        } else if (fieldType instanceof ParameterizedType && (rawType = ((ParameterizedType)fieldType).getRawType()) instanceof Class) {
            fieldClass = (Class)rawType;
        }
        if (objectClass == fieldClass) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    private static boolean isWriteTypeInfoGenericArray(GenericArrayType fieldType, Class objectClass) {
        Type componentType = fieldType.getGenericComponentType();
        if (componentType instanceof ParameterizedType) {
            componentType = ((ParameterizedType)componentType).getRawType();
        }
        if (objectClass.isArray()) {
            return objectClass.getComponentType().equals(componentType);
        }
        return false;
    }

    public final boolean isWriteTypeInfo(Object object) {
        Class<?> objectClass;
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && object != null && ((objectClass = object.getClass()) == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public final boolean isWriteTypeInfo(Object object, Type fieldType, long features) {
        Type rawType;
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        Class fieldClass = null;
        if (fieldType instanceof Class) {
            fieldClass = (Class)fieldType;
        } else if (fieldType instanceof ParameterizedType && (rawType = ((ParameterizedType)fieldType).getRawType()) instanceof Class) {
            fieldClass = (Class)rawType;
        }
        if (objectClass == fieldClass) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class ? fieldClass == null || fieldClass == Object.class || fieldClass == Map.class || fieldClass == AbstractMap.class : objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public final boolean isWriteTypeInfo(Object object, Class fieldClass, long features) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return false;
        }
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class ? fieldClass == null || fieldClass == Object.class || fieldClass == Map.class || fieldClass == AbstractMap.class : objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public final boolean isWriteMapTypeInfo(Object object, Class fieldClass, long features) {
        if (object == null) {
            return false;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return false;
        }
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && objectClass == HashMap.class) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public final boolean isWriteTypeInfo(Object object, long features) {
        Class<?> objectClass;
        if (((features |= this.context.features) & Feature.WriteClassName.mask) == 0L) {
            return false;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && object != null && ((objectClass = object.getClass()) == HashMap.class || objectClass == ArrayList.class)) {
            return false;
        }
        return (features & Feature.NotWriteRootClassName.mask) == 0L || object != this.rootObject;
    }

    public final ObjectWriter getObjectWriter(Class objectClass) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectWriter(objectClass, objectClass, fieldBased);
    }

    public final ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        boolean fieldBased = (this.context.features & Feature.FieldBased.mask) != 0L;
        return this.context.provider.getObjectWriter(objectType, objectClass, fieldBased);
    }

    public static JSONWriter of() {
        Context writeContext = new Context(JSONFactory.defaultObjectWriterProvider);
        JSONWriter jsonWriter = (JSONFactory.defaultWriterFeatures & Feature.OptimizedForAscii.mask) != 0L ? new JSONWriterUTF8(writeContext) : new JSONWriterUTF16(writeContext);
        return jsonWriter;
    }

    public static JSONWriter of(ObjectWriterProvider provider, Feature ... features) {
        Context context = new Context(provider);
        context.config(features);
        return JSONWriter.of(context);
    }

    public static JSONWriter of(Context writeContext) {
        if (writeContext == null) {
            writeContext = JSONFactory.createWriteContext();
        }
        JSONWriter jsonWriter = (writeContext.features & Feature.OptimizedForAscii.mask) != 0L ? new JSONWriterUTF8(writeContext) : new JSONWriterUTF16(writeContext);
        return jsonWriter;
    }

    public static JSONWriter of(Feature ... features) {
        Context context = JSONFactory.createWriteContext(features);
        JSONWriter jsonWriter = (context.features & Feature.OptimizedForAscii.mask) != 0L ? new JSONWriterUTF8(context) : new JSONWriterUTF16(context);
        return jsonWriter;
    }

    public static JSONWriter ofUTF16(Feature ... features) {
        Context writeContext = JSONFactory.createWriteContext(features);
        return new JSONWriterUTF16(writeContext);
    }

    public static JSONWriter ofJSONB() {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider), null);
    }

    public static JSONWriter ofJSONB(Context context) {
        return new JSONWriterJSONB(context, null);
    }

    public static JSONWriter ofJSONB(Context context, SymbolTable symbolTable) {
        return new JSONWriterJSONB(context, symbolTable);
    }

    public static JSONWriter ofJSONB(Feature ... features) {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider, features), null);
    }

    public static JSONWriter ofJSONB(SymbolTable symbolTable) {
        return new JSONWriterJSONB(new Context(JSONFactory.defaultObjectWriterProvider), symbolTable);
    }

    public static JSONWriter ofPretty() {
        return JSONWriter.of(Feature.PrettyFormat);
    }

    public static JSONWriter ofPretty(JSONWriter writer) {
        if (!writer.pretty) {
            writer.pretty = true;
            writer.context.features |= Feature.PrettyFormat.mask;
        }
        return writer;
    }

    public static JSONWriter ofUTF8() {
        Context context = JSONFactory.createWriteContext();
        return new JSONWriterUTF8(context);
    }

    public static JSONWriter ofUTF8(Context context) {
        return new JSONWriterUTF8(context);
    }

    public static JSONWriter ofUTF8(Feature ... features) {
        Context context = JSONFactory.createWriteContext(features);
        return new JSONWriterUTF8(context);
    }

    public void writeBinary(byte[] bytes) {
        if (bytes == null) {
            this.writeArrayNull();
            return;
        }
        if ((this.context.features & Feature.WriteByteArrayAsBase64.mask) != 0L) {
            this.writeBase64(bytes);
            return;
        }
        this.startArray();
        for (int i = 0; i < bytes.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt32(bytes[i]);
        }
        this.endArray();
    }

    public abstract void writeBase64(byte[] var1);

    public abstract void writeHex(byte[] var1);

    protected abstract void write0(char var1);

    public abstract void writeRaw(String var1);

    public abstract void writeRaw(byte[] var1);

    public void writeRaw(byte b) {
        throw new JSONException("UnsupportedOperation");
    }

    public void writeNameRaw(byte[] bytes, int offset, int len) {
        throw new JSONException("UnsupportedOperation");
    }

    public final void writeRaw(char[] chars) {
        this.writeRaw(chars, 0, chars.length);
    }

    public void writeRaw(char[] chars, int off, int charslen) {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract void writeChar(char var1);

    public abstract void writeRaw(char var1);

    public void writeRaw(char c0, char c1) {
        this.writeRaw(c0);
        this.writeRaw(c1);
    }

    public abstract void writeNameRaw(byte[] var1);

    public void writeSymbol(int symbol) {
        throw new JSONException("UnsupportedOperation");
    }

    public void writeNameRaw(byte[] name, long nameHash) {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract void writeNameRaw(char[] var1);

    public abstract void writeNameRaw(char[] var1, int var2, int var3);

    public void writeName(String name) {
        boolean unquote;
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        boolean bl = unquote = (this.context.features & Feature.UnquoteFieldName.mask) != 0L;
        if (unquote && (name.indexOf(this.quote) >= 0 || name.indexOf(92) >= 0)) {
            unquote = false;
        }
        if (unquote) {
            this.writeRaw(name);
            return;
        }
        this.writeString(name);
    }

    public final void writeNameValue(String name, Object value) {
        this.writeName(name);
        this.writeAny(value);
    }

    public final void writeName(long name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeInt64(name);
    }

    public final void writeName(int name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeInt32(name);
    }

    public void writeNameAny(Object name) {
        if (this.startObject) {
            this.startObject = false;
        } else {
            this.writeComma();
        }
        this.writeAny(name);
    }

    public abstract void startObject();

    public abstract void endObject();

    public abstract void startArray();

    public void startArray(int size) {
        throw new JSONException("UnsupportedOperation");
    }

    public void startArray(Object array, int size) {
        throw new JSONException("UnsupportedOperation");
    }

    public abstract void endArray();

    public abstract void writeComma();

    public abstract void writeColon();

    public void writeInt16(short[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeInt16(value[i]);
        }
        this.endArray();
    }

    public abstract void writeInt8(byte var1);

    public abstract void writeInt16(short var1);

    public abstract void writeInt32(int[] var1);

    public abstract void writeInt32(int var1);

    public abstract void writeInt64(long var1);

    public final void writeInt32(int value, String format) {
        if (format == null || this.jsonb) {
            this.writeInt32(value);
            return;
        }
        this.writeString(String.format(format, value));
    }

    public void writeMillis(long i) {
        this.writeInt64(i);
    }

    public abstract void writeInt64(long[] var1);

    public abstract void writeFloat(float var1);

    public final void writeFloat(float value, DecimalFormat format) {
        if (format == null || this.jsonb) {
            this.writeFloat(value);
            return;
        }
        if (Float.isNaN(value) || Float.isInfinite(value)) {
            this.writeNull();
            return;
        }
        String str = format.format(value);
        this.writeRaw(str);
    }

    public void writeFloat(float[] value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeFloat(value[i]);
        }
        this.endArray();
    }

    public final void writeFloat(float[] value, DecimalFormat format) {
        if (format == null || this.jsonb) {
            this.writeFloat(value);
            return;
        }
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            String str = format.format(value[i]);
            this.writeRaw(str);
        }
        this.endArray();
    }

    public final void writeFloat(Float value) {
        if (value == null) {
            this.writeNumberNull();
        } else {
            this.writeDouble(value.floatValue());
        }
    }

    public abstract void writeDouble(double var1);

    public final void writeDouble(double value, DecimalFormat format) {
        if (format == null || this.jsonb) {
            this.writeDouble(value);
            return;
        }
        if (Double.isNaN(value) || Double.isInfinite(value)) {
            this.writeNull();
            return;
        }
        String str = format.format(value);
        this.writeRaw(str);
    }

    public void writeDoubleArray(double value0, double value1) {
        this.startArray();
        this.writeDouble(value0);
        this.writeComma();
        this.writeDouble(value1);
        this.endArray();
    }

    public final void writeDouble(double[] value, DecimalFormat format) {
        if (format == null || this.jsonb) {
            this.writeDouble(value);
            return;
        }
        if (value == null) {
            this.writeNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            String str = format.format(value[i]);
            this.writeRaw(str);
        }
        this.endArray();
    }

    public abstract void writeDouble(double[] var1);

    public void writeBool(boolean value) {
        if ((this.context.features & Feature.WriteBooleanAsNumber.mask) != 0L) {
            this.write0(value ? (char)'1' : '0');
        } else {
            this.writeRaw(value ? "true" : "false");
        }
    }

    public void writeBool(boolean[] value) {
        if (value == null) {
            this.writeArrayNull();
            return;
        }
        this.startArray();
        for (int i = 0; i < value.length; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            this.writeBool(value[i]);
        }
        this.endArray();
    }

    public void writeNull() {
        this.writeRaw("null");
    }

    public void writeStringNull() {
        String raw = (this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullStringAsEmpty.mask)) != 0L ? ((this.context.features & Feature.UseSingleQuotes.mask) != 0L ? "''" : "\"\"") : "null";
        this.writeRaw(raw);
    }

    public void writeArrayNull() {
        String raw = (this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullListAsEmpty.mask)) != 0L ? "[]" : "null";
        this.writeRaw(raw);
    }

    public final void writeNumberNull() {
        if ((this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullNumberAsZero.mask)) != 0L) {
            this.writeInt32(0);
        } else {
            this.writeNull();
        }
    }

    public final void writeInt64Null() {
        if ((this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullNumberAsZero.mask)) != 0L) {
            this.writeInt64(0L);
        } else {
            this.writeNull();
        }
    }

    public final void writeBooleanNull() {
        if ((this.context.features & (Feature.NullAsDefaultValue.mask | Feature.WriteNullBooleanAsFalse.mask)) != 0L) {
            this.writeBool(false);
        } else {
            this.writeNull();
        }
    }

    public final void writeDecimal(BigDecimal value) {
        this.writeDecimal(value, 0L, null);
    }

    public final void writeDecimal(BigDecimal value, long features) {
        this.writeDecimal(value, features, null);
    }

    public abstract void writeDecimal(BigDecimal var1, long var2, DecimalFormat var4);

    public void writeEnum(Enum e) {
        if (e == null) {
            this.writeNull();
            return;
        }
        if ((this.context.features & Feature.WriteEnumUsingToString.mask) != 0L) {
            this.writeString(e.toString());
        } else if ((this.context.features & Feature.WriteEnumsUsingName.mask) != 0L) {
            this.writeString(e.name());
        } else {
            this.writeInt32(e.ordinal());
        }
    }

    public final void writeBigInt(BigInteger value) {
        this.writeBigInt(value, 0L);
    }

    public abstract void writeBigInt(BigInteger var1, long var2);

    public abstract void writeUUID(UUID var1);

    public final void checkAndWriteTypeName(Object object, Class fieldClass) {
        long features = this.context.features;
        if ((features & Feature.WriteClassName.mask) == 0L) {
            return;
        }
        if (object == null) {
            return;
        }
        Class<?> objectClass = object.getClass();
        if (objectClass == fieldClass) {
            return;
        }
        if ((features & Feature.NotWriteHashMapArrayListClassName.mask) != 0L && (objectClass == HashMap.class || objectClass == ArrayList.class)) {
            return;
        }
        if ((features & Feature.NotWriteRootClassName.mask) != 0L && object == this.rootObject) {
            return;
        }
        this.writeTypeName(TypeUtils.getTypeName(objectClass));
    }

    public void writeTypeName(String typeName) {
        throw new JSONException("UnsupportedOperation");
    }

    public boolean writeTypeName(byte[] typeName, long typeNameHash) {
        throw new JSONException("UnsupportedOperation");
    }

    public final void writeString(Reader reader) {
        this.writeRaw(this.quote);
        try {
            int len;
            char[] chars = new char[2048];
            while ((len = reader.read(chars, 0, chars.length)) >= 0) {
                if (len <= 0) continue;
                this.writeString(chars, 0, len, false);
            }
        }
        catch (Exception ex) {
            throw new JSONException("read string from reader error", ex);
        }
        this.writeRaw(this.quote);
    }

    public abstract void writeString(String var1);

    public abstract void writeStringLatin1(byte[] var1);

    public abstract void writeStringUTF16(byte[] var1);

    public void writeString(List<String> list) {
        this.startArray();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            if (i != 0) {
                this.writeComma();
            }
            String str = list.get(i);
            this.writeString(str);
        }
        this.endArray();
    }

    public abstract void writeString(String[] var1);

    public void writeSymbol(String string) {
        this.writeString(string);
    }

    public abstract void writeString(char[] var1);

    public abstract void writeString(char[] var1, int var2, int var3);

    public abstract void writeString(char[] var1, int var2, int var3, boolean var4);

    public abstract void writeLocalDateTime(LocalDateTime var1);

    public void writeInstant(long seconds, int nano) {
        throw new JSONException("TODO");
    }

    public abstract void writeDateTime14(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void writeDateTime19(int var1, int var2, int var3, int var4, int var5, int var6);

    public abstract void writeDateTimeISO8601(int var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    public abstract void writeDateYYYMMDD8(int var1, int var2, int var3);

    public abstract void writeDateYYYMMDD10(int var1, int var2, int var3);

    public abstract void writeTimeHHMMSS8(int var1, int var2, int var3);

    public void write(List array) {
        if (array == null) {
            this.writeArrayNull();
            return;
        }
        long NONE_DIRECT_FEATURES = Feature.ReferenceDetection.mask | Feature.PrettyFormat.mask | Feature.NotWriteEmptyArray.mask | Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(array.getClass());
            objectWriter.write(this, array, null, null, 0L);
            return;
        }
        this.write0('[');
        for (int i = 0; i < array.size(); ++i) {
            Object item = array.get(i);
            if (i != 0) {
                this.write0(',');
            }
            this.writeAny(item);
        }
        this.write0(']');
    }

    public void write(Map map) {
        if (map == null) {
            this.writeNull();
            return;
        }
        long NONE_DIRECT_FEATURES = Feature.ReferenceDetection.mask | Feature.PrettyFormat.mask | Feature.NotWriteEmptyArray.mask | Feature.NotWriteDefaultValue.mask;
        if ((this.context.features & NONE_DIRECT_FEATURES) != 0L) {
            ObjectWriter<?> objectWriter = this.context.getObjectWriter(map.getClass());
            objectWriter.write(this, map, null, null, 0L);
            return;
        }
        this.write0('{');
        boolean first = true;
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            if (!first) {
                this.write0(',');
            }
            Map.Entry next = it.next();
            this.writeAny(next.getKey());
            this.write0(':');
            this.writeAny(next.getValue());
            first = false;
        }
        this.write0('}');
    }

    public void write(JSONObject map) {
        this.write((Map)map);
    }

    public void writeAny(Object value) {
        if (value == null) {
            this.writeNull();
            return;
        }
        Class<?> valueClass = value.getClass();
        ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
        objectWriter.write(this, value, null, null, 0L);
    }

    public abstract void writeReference(String var1);

    public final void writeAs(Object value, Class type) {
        if (value == null) {
            this.writeNull();
            return;
        }
        ObjectWriter objectWriter = this.context.getObjectWriter(type);
        objectWriter.write(this, value, null, null, 0L);
    }

    @Override
    public abstract void close();

    public abstract int size();

    public abstract byte[] getBytes();

    public abstract byte[] getBytes(Charset var1);

    public void flushTo(Writer to) {
        try {
            String json = this.toString();
            to.write(json);
            this.off = 0;
        }
        catch (IOException e) {
            throw new JSONException("flushTo error", e);
        }
    }

    public abstract int flushTo(OutputStream var1) throws IOException;

    public abstract int flushTo(OutputStream var1, Charset var2) throws IOException;

    public static final class Context {
        public final ObjectWriterProvider provider;
        DateTimeFormatter dateFormatter;
        String dateFormat;
        Locale locale;
        TimeZone timeZone;
        boolean dateFormatMillis;
        boolean dateFormatISO8601;
        boolean dateFormatUnixTime;
        boolean formatyyyyMMddhhmmss19;
        boolean formatHasDay;
        boolean formatHasHour;
        long features;
        ZoneId zoneId;
        boolean hasFilter;
        PropertyPreFilter propertyPreFilter;
        PropertyFilter propertyFilter;
        NameFilter nameFilter;
        ValueFilter valueFilter;
        BeforeFilter beforeFilter;
        AfterFilter afterFilter;
        LabelFilter labelFilter;
        ContextValueFilter contextValueFilter;
        ContextNameFilter contextNameFilter;

        public Context(ObjectWriterProvider provider) {
            if (provider == null) {
                throw new IllegalArgumentException("objectWriterProvider must not null");
            }
            this.features = JSONFactory.defaultWriterFeatures;
            this.provider = provider;
            this.zoneId = JSONFactory.defaultWriterZoneId;
            String format = JSONFactory.defaultWriterFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(Feature ... features) {
            this.features = JSONFactory.defaultWriterFeatures;
            this.provider = JSONFactory.defaultObjectWriterProvider;
            this.zoneId = JSONFactory.defaultWriterZoneId;
            String format = JSONFactory.defaultWriterFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public Context(String format, Feature ... features) {
            this.features = JSONFactory.defaultWriterFeatures;
            this.provider = JSONFactory.defaultObjectWriterProvider;
            this.zoneId = JSONFactory.defaultWriterZoneId;
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
            if (format == null) {
                format = JSONFactory.defaultWriterFormat;
            }
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(ObjectWriterProvider provider, String format, Filter filter, Feature ... features) {
            this.features = JSONFactory.defaultWriterFeatures;
            this.provider = provider;
            this.zoneId = JSONFactory.defaultWriterZoneId;
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
            this.configFilter(filter);
            if (format == null) {
                format = JSONFactory.defaultWriterFormat;
            }
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public Context(ObjectWriterProvider provider, Feature ... features) {
            if (provider == null) {
                throw new IllegalArgumentException("objectWriterProvider must not null");
            }
            this.features = JSONFactory.defaultWriterFeatures;
            this.provider = provider;
            this.zoneId = JSONFactory.defaultWriterZoneId;
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
            String format = JSONFactory.defaultWriterFormat;
            if (format != null) {
                this.setDateFormat(format);
            }
        }

        public TimeZone getTimeZone() {
            if (this.timeZone == null) {
                this.timeZone = ZoneId.DEFAULT_TIME_ZONE;
            }
            return this.timeZone;
        }

        public void setTimeZone(TimeZone timeZone) {
            this.timeZone = timeZone;
        }

        public long getFeatures() {
            return this.features;
        }

        public boolean isEnabled(Feature feature) {
            return (this.features & feature.mask) != 0L;
        }

        public boolean isEnabled(long feature) {
            return (this.features & feature) != 0L;
        }

        public void config(Feature ... features) {
            for (int i = 0; i < features.length; ++i) {
                this.features |= features[i].mask;
            }
        }

        public void config(Feature feature, boolean state) {
            this.features = state ? (this.features |= feature.mask) : (this.features &= feature.mask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        public void configFilter(Filter ... filters) {
            if (filters == null) {
                return;
            }
            for (int i = 0; i < filters.length; ++i) {
                Filter filter = filters[i];
                if (filter instanceof NameFilter) {
                    this.nameFilter = this.nameFilter == null ? (NameFilter)filter : NameFilter.compose(this.nameFilter, (NameFilter)filter);
                }
                if (filter instanceof ValueFilter) {
                    this.valueFilter = this.valueFilter == null ? (ValueFilter)filter : ValueFilter.compose(this.valueFilter, (ValueFilter)filter);
                }
                if (filter instanceof PropertyFilter) {
                    this.propertyFilter = (PropertyFilter)filter;
                }
                if (filter instanceof PropertyPreFilter) {
                    this.propertyPreFilter = (PropertyPreFilter)filter;
                }
                if (filter instanceof BeforeFilter) {
                    this.beforeFilter = (BeforeFilter)filter;
                }
                if (filter instanceof AfterFilter) {
                    this.afterFilter = (AfterFilter)filter;
                }
                if (filter instanceof LabelFilter) {
                    this.labelFilter = (LabelFilter)filter;
                }
                if (filter instanceof ContextValueFilter) {
                    this.contextValueFilter = (ContextValueFilter)filter;
                }
                if (!(filter instanceof ContextNameFilter)) continue;
                this.contextNameFilter = (ContextNameFilter)filter;
            }
            this.hasFilter = this.propertyPreFilter != null || this.propertyFilter != null || this.nameFilter != null || this.valueFilter != null || this.beforeFilter != null || this.afterFilter != null || this.labelFilter != null || this.contextValueFilter != null || this.contextNameFilter != null;
        }

        public <T> ObjectWriter<T> getObjectWriter(Class<T> objectType) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectWriter(objectType, objectType, fieldBased);
        }

        public <T> ObjectWriter<T> getObjectWriter(Type objectType, Class<T> objectClass) {
            boolean fieldBased = (this.features & Feature.FieldBased.mask) != 0L;
            return this.provider.getObjectWriter(objectType, objectClass, fieldBased);
        }

        public ObjectWriterProvider getProvider() {
            return this.provider;
        }

        public ZoneId getZoneId() {
            if (this.zoneId == null) {
                this.zoneId = ZoneId.DEFAULT_ZONE_ID;
            }
            return this.zoneId;
        }

        public void setZoneId(ZoneId zoneId) {
            this.zoneId = zoneId;
        }

        public String getDateFormat() {
            return this.dateFormat;
        }

        public boolean isDateFormatMillis() {
            return this.dateFormatMillis;
        }

        public boolean isDateFormatUnixTime() {
            return this.dateFormatUnixTime;
        }

        public boolean isDateFormatISO8601() {
            return this.dateFormatISO8601;
        }

        public boolean isDateFormatHasDay() {
            return this.formatHasDay;
        }

        public boolean isDateFormatHasHour() {
            return this.formatHasHour;
        }

        public boolean isFormatyyyyMMddhhmmss19() {
            return this.formatyyyyMMddhhmmss19;
        }

        public DateTimeFormatter getDateFormatter() {
            if (!(this.dateFormatter != null || this.dateFormat == null || this.dateFormatMillis || this.dateFormatISO8601 || this.dateFormatUnixTime)) {
                this.dateFormatter = this.locale == null ? DateTimeFormatter.ofPattern(this.dateFormat) : DateTimeFormatter.ofPattern(this.dateFormat, this.locale);
            }
            return this.dateFormatter;
        }

        public void setDateFormat(String dateFormat) {
            if (dateFormat == null || !dateFormat.equals(this.dateFormat)) {
                this.dateFormatter = null;
            }
            if (dateFormat != null && !dateFormat.isEmpty()) {
                boolean dateFormatMillis = false;
                boolean dateFormatISO8601 = false;
                boolean dateFormatUnixTime = false;
                boolean formatHasDay = false;
                boolean formatHasHour = false;
                boolean formatyyyyMMddhhmmss19 = false;
                switch (dateFormat) {
                    case "millis": {
                        dateFormatMillis = true;
                        break;
                    }
                    case "iso8601": {
                        dateFormatISO8601 = true;
                        break;
                    }
                    case "unixtime": {
                        dateFormatUnixTime = true;
                        break;
                    }
                    case "yyyy-MM-ddTHH:mm:ss": {
                        dateFormat = "yyyy-MM-dd'T'HH:mm:ss";
                        formatHasDay = true;
                        formatHasHour = true;
                        break;
                    }
                    case "yyyy-MM-dd HH:mm:ss": {
                        formatyyyyMMddhhmmss19 = true;
                        formatHasDay = true;
                        formatHasHour = true;
                        break;
                    }
                    default: {
                        formatHasDay = dateFormat.contains("d");
                        formatHasHour = dateFormat.contains("H");
                    }
                }
                this.dateFormatMillis = dateFormatMillis;
                this.dateFormatISO8601 = dateFormatISO8601;
                this.dateFormatUnixTime = dateFormatUnixTime;
                this.formatHasDay = formatHasDay;
                this.formatHasHour = formatHasHour;
                this.formatyyyyMMddhhmmss19 = formatyyyyMMddhhmmss19;
            }
            this.dateFormat = dateFormat;
        }

        public PropertyPreFilter getPropertyPreFilter() {
            return this.propertyPreFilter;
        }

        public void setPropertyPreFilter(PropertyPreFilter propertyPreFilter) {
            this.propertyPreFilter = propertyPreFilter;
            if (propertyPreFilter != null) {
                this.hasFilter = true;
            }
        }

        public NameFilter getNameFilter() {
            return this.nameFilter;
        }

        public void setNameFilter(NameFilter nameFilter) {
            this.nameFilter = nameFilter;
            if (nameFilter != null) {
                this.hasFilter = true;
            }
        }

        public ValueFilter getValueFilter() {
            return this.valueFilter;
        }

        public void setValueFilter(ValueFilter valueFilter) {
            this.valueFilter = valueFilter;
            if (valueFilter != null) {
                this.hasFilter = true;
            }
        }

        public ContextValueFilter getContextValueFilter() {
            return this.contextValueFilter;
        }

        public void setContextValueFilter(ContextValueFilter contextValueFilter) {
            this.contextValueFilter = contextValueFilter;
            if (contextValueFilter != null) {
                this.hasFilter = true;
            }
        }

        public ContextNameFilter getContextNameFilter() {
            return this.contextNameFilter;
        }

        public void setContextNameFilter(ContextNameFilter contextNameFilter) {
            this.contextNameFilter = contextNameFilter;
            if (contextNameFilter != null) {
                this.hasFilter = true;
            }
        }

        public PropertyFilter getPropertyFilter() {
            return this.propertyFilter;
        }

        public void setPropertyFilter(PropertyFilter propertyFilter) {
            this.propertyFilter = propertyFilter;
            if (propertyFilter != null) {
                this.hasFilter = true;
            }
        }

        public AfterFilter getAfterFilter() {
            return this.afterFilter;
        }

        public void setAfterFilter(AfterFilter afterFilter) {
            this.afterFilter = afterFilter;
            if (afterFilter != null) {
                this.hasFilter = true;
            }
        }

        public BeforeFilter getBeforeFilter() {
            return this.beforeFilter;
        }

        public void setBeforeFilter(BeforeFilter beforeFilter) {
            this.beforeFilter = beforeFilter;
            if (beforeFilter != null) {
                this.hasFilter = true;
            }
        }

        public LabelFilter getLabelFilter() {
            return this.labelFilter;
        }

        public void setLabelFilter(LabelFilter labelFilter) {
            this.labelFilter = labelFilter;
            if (labelFilter != null) {
                this.hasFilter = true;
            }
        }
    }

    public static enum Feature {
        FieldBased(1L),
        IgnoreNoneSerializable(2L),
        ErrorOnNoneSerializable(4L),
        BeanToArray(8L),
        WriteNulls(16L),
        WriteMapNullValue(16L),
        BrowserCompatible(32L),
        NullAsDefaultValue(64L),
        WriteBooleanAsNumber(128L),
        WriteNonStringValueAsString(256L),
        WriteClassName(512L),
        NotWriteRootClassName(1024L),
        NotWriteHashMapArrayListClassName(2048L),
        NotWriteDefaultValue(4096L),
        WriteEnumsUsingName(8192L),
        WriteEnumUsingToString(16384L),
        IgnoreErrorGetter(32768L),
        PrettyFormat(65536L),
        ReferenceDetection(131072L),
        WriteNameAsSymbol(262144L),
        WriteBigDecimalAsPlain(524288L),
        UseSingleQuotes(0x100000L),
        MapSortField(0x200000L),
        WriteNullListAsEmpty(0x400000L),
        WriteNullStringAsEmpty(0x800000L),
        WriteNullNumberAsZero(0x1000000L),
        WriteNullBooleanAsFalse(0x2000000L),
        NotWriteEmptyArray(0x4000000L),
        WriteNonStringKeyAsString(0x8000000L),
        WritePairAsJavaBean(0x10000000L),
        OptimizedForAscii(0x20000000L),
        EscapeNoneAscii(0x40000000L),
        WriteByteArrayAsBase64(0x80000000L),
        IgnoreNonFieldGetter(0x100000000L),
        LargeObject(0x200000000L),
        WriteLongAsString(0x400000000L),
        BrowserSecure(0x800000000L),
        WriteEnumUsingOrdinal(0x1000000000L),
        WriteThrowableClassName(0x2000000000L),
        UnquoteFieldName(0x4000000000L),
        NotWriteSetClassName(0x8000000000L),
        NotWriteNumberClassName(0x10000000000L),
        SortMapEntriesByKeys(0x20000000000L);

        public final long mask;

        private Feature(long mask) {
            this.mask = mask;
        }
    }

    public static final class Path {
        public static final Path ROOT = new Path(null, "$");
        public final Path parent;
        final String name;
        final int index;
        String fullPath;
        Path child0;
        Path child1;

        public Path(Path parent, String name) {
            this.parent = parent;
            this.name = name;
            this.index = -1;
        }

        public Path(Path parent, int index) {
            this.parent = parent;
            this.name = null;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Path path = (Path)o;
            return this.index == path.index && this.parent == path.parent || this.parent != null && this.parent.equals(path.parent) && this.name == path.name || this.name != null && this.name.equals(path.name);
        }

        public int hashCode() {
            return Arrays.hashCode(new Object[]{this.parent, this.name, this.index});
        }

        /*
         * Unable to fully structure code
         */
        public String toString() {
            if (this.fullPath != null) {
                return this.fullPath;
            }
            buf = new byte[16];
            off = 0;
            level = 0;
            items = new Path[4];
            p = this;
            while (p != null) {
                if (items.length == level) {
                    items = Arrays.copyOf(items, items.length + 4);
                }
                items[level] = p;
                ++level;
                p = p.parent;
            }
            ascii = true;
            for (i = level - 1; i >= 0; --i) {
                item = items[i];
                name = item.name;
                if (name == null) {
                    intValue = item.index;
                    intValueSize = IOUtils.stringSize(intValue);
                    while (off + intValueSize + 2 >= buf.length) {
                        newCapacity = buf.length + (buf.length >> 1);
                        buf = Arrays.copyOf(buf, newCapacity);
                    }
                    buf[off++] = 91;
                    off = IOUtils.writeInt32(buf, off, intValue);
                    buf[off++] = 93;
                    continue;
                }
                if (off + 1 >= buf.length) {
                    newCapacity = buf.length + (buf.length >> 1);
                    buf = Arrays.copyOf(buf, newCapacity);
                }
                if (i != level - 1) {
                    buf[off++] = 46;
                }
                block6: for (j = 0; j < name.length(); ++j) {
                    ch = name.charAt(j);
                    switch (ch) {
                        case '!': 
                        case '\"': 
                        case '#': 
                        case '%': 
                        case '&': 
                        case '\'': 
                        case '(': 
                        case ')': 
                        case '*': 
                        case '+': 
                        case '-': 
                        case '.': 
                        case '/': 
                        case ':': 
                        case ';': 
                        case '<': 
                        case '=': 
                        case '>': 
                        case '?': 
                        case '@': 
                        case '[': 
                        case '\\': 
                        case ']': 
                        case '^': 
                        case '`': 
                        case '~': {
                            if (off + 1 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            buf[off++] = 92;
                            buf[off++] = (byte)ch;
                            continue block6;
                        }
                        default: {
                            if (ch >= '\u0001' && ch <= '\u007f') {
                                if (off == buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = (byte)ch;
                                continue block6;
                            }
                            if (ch < '\ud800' || ch >= '\ue000') ** GOTO lbl81
                            ascii = false;
                            if (ch >= '\udc00') ** GOTO lbl64
                            if (name.length() - i < 2) {
                                uc = -1;
                            } else {
                                d = name.charAt(i + 1);
                                if (d >= '\udc00' && d < '\ue000') {
                                    uc = (ch << 10) + d + -56613888;
                                } else {
                                    buf[off++] = 63;
                                    continue block6;
lbl64:
                                    // 1 sources

                                    buf[off++] = 63;
                                    continue block6;
                                }
                            }
                            if (uc < 0) {
                                if (off == buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                buf[off++] = 63;
                                continue block6;
                            }
                            if (off + 3 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            buf[off++] = (byte)(240 | uc >> 18);
                            buf[off++] = (byte)(128 | uc >> 12 & 63);
                            buf[off++] = (byte)(128 | uc >> 6 & 63);
                            buf[off++] = (byte)(128 | uc & 63);
                            ++j;
                            continue block6;
lbl81:
                            // 1 sources

                            if (ch > '\u07ff') {
                                if (off + 2 >= buf.length) {
                                    newCapacity = buf.length + (buf.length >> 1);
                                    buf = Arrays.copyOf(buf, newCapacity);
                                }
                                ascii = false;
                                buf[off++] = (byte)(224 | ch >> 12 & 15);
                                buf[off++] = (byte)(128 | ch >> 6 & 63);
                                buf[off++] = (byte)(128 | ch & 63);
                                continue block6;
                            }
                            if (off + 1 >= buf.length) {
                                newCapacity = buf.length + (buf.length >> 1);
                                buf = Arrays.copyOf(buf, newCapacity);
                            }
                            ascii = false;
                            buf[off++] = (byte)(192 | ch >> 6 & 31);
                            buf[off++] = (byte)(128 | ch & 63);
                        }
                    }
                }
            }
            this.fullPath = new String(buf, 0, off, ascii != false ? StandardCharsets.ISO_8859_1 : StandardCharsets.UTF_8);
            return this.fullPath;
        }
    }
}

