/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.function.ToDoubleFunction;
import com.alibaba.fastjson2.writer.FieldWriter;
import java.lang.reflect.Method;

final class FieldWriterDoubleValueFunc
extends FieldWriter {
    final ToDoubleFunction function;

    protected FieldWriterDoubleValueFunc(String fieldName, int ordinal, long features, String format, String label, Method method, ToDoubleFunction function) {
        super(fieldName, ordinal, features, format, label, Double.TYPE, Double.TYPE, null, method);
        this.function = function;
    }

    public Object getFieldValue(Object object) {
        return this.function.applyAsDouble(object);
    }

    public void writeValue(JSONWriter jsonWriter, Object object) {
        double value = this.function.applyAsDouble(object);
        if (this.decimalFormat != null) {
            jsonWriter.writeDouble(value, this.decimalFormat);
        } else {
            jsonWriter.writeDouble(value);
        }
    }

    public boolean write(JSONWriter jsonWriter, Object object) {
        double value;
        try {
            value = this.function.applyAsDouble(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        this.writeFieldName(jsonWriter);
        if (this.decimalFormat != null) {
            jsonWriter.writeDouble(value, this.decimalFormat);
        } else {
            jsonWriter.writeDouble(value);
        }
        return true;
    }
}

