/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.PropertyNamingStrategy;
import com.alibaba.fastjson2.TypeReference;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.reader.ConstructorFunction;
import com.alibaba.fastjson2.reader.ConstructorSupplier;
import com.alibaba.fastjson2.reader.FactoryFunction;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.FieldReaderAnySetter;
import com.alibaba.fastjson2.reader.FieldReaderAtomicBooleanFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicBooleanMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicIntegerArrayReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicIntegerMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicLongArrayReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicLongReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderAtomicReferenceField;
import com.alibaba.fastjson2.reader.FieldReaderAtomicReferenceMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalField;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalFunc;
import com.alibaba.fastjson2.reader.FieldReaderBigDecimalMethod;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerField;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerFunc;
import com.alibaba.fastjson2.reader.FieldReaderBigIntegerMethod;
import com.alibaba.fastjson2.reader.FieldReaderBoolField;
import com.alibaba.fastjson2.reader.FieldReaderBoolFunc;
import com.alibaba.fastjson2.reader.FieldReaderBoolMethod;
import com.alibaba.fastjson2.reader.FieldReaderBoolValueField;
import com.alibaba.fastjson2.reader.FieldReaderBoolValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderCharValueField;
import com.alibaba.fastjson2.reader.FieldReaderCollectionFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderCollectionMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderDate;
import com.alibaba.fastjson2.reader.FieldReaderDoubleField;
import com.alibaba.fastjson2.reader.FieldReaderDoubleFunc;
import com.alibaba.fastjson2.reader.FieldReaderDoubleMethod;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueField;
import com.alibaba.fastjson2.reader.FieldReaderDoubleValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderFloatField;
import com.alibaba.fastjson2.reader.FieldReaderFloatFunc;
import com.alibaba.fastjson2.reader.FieldReaderFloatMethod;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueField;
import com.alibaba.fastjson2.reader.FieldReaderFloatValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt16Field;
import com.alibaba.fastjson2.reader.FieldReaderInt16Func;
import com.alibaba.fastjson2.reader.FieldReaderInt16Method;
import com.alibaba.fastjson2.reader.FieldReaderInt16Param;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt16ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt32Field;
import com.alibaba.fastjson2.reader.FieldReaderInt32Func;
import com.alibaba.fastjson2.reader.FieldReaderInt32Method;
import com.alibaba.fastjson2.reader.FieldReaderInt32Param;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueArrayFinalField;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt32ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt64Field;
import com.alibaba.fastjson2.reader.FieldReaderInt64Func;
import com.alibaba.fastjson2.reader.FieldReaderInt64Method;
import com.alibaba.fastjson2.reader.FieldReaderInt64Param;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueArrayFinalField;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt64ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderInt8Field;
import com.alibaba.fastjson2.reader.FieldReaderInt8Func;
import com.alibaba.fastjson2.reader.FieldReaderInt8Method;
import com.alibaba.fastjson2.reader.FieldReaderInt8Param;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueField;
import com.alibaba.fastjson2.reader.FieldReaderInt8ValueMethod;
import com.alibaba.fastjson2.reader.FieldReaderList;
import com.alibaba.fastjson2.reader.FieldReaderListFieldUF;
import com.alibaba.fastjson2.reader.FieldReaderMapFieldReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderMapMethodReadOnly;
import com.alibaba.fastjson2.reader.FieldReaderNumberFunc;
import com.alibaba.fastjson2.reader.FieldReaderObject;
import com.alibaba.fastjson2.reader.FieldReaderObjectField;
import com.alibaba.fastjson2.reader.FieldReaderObjectFunc;
import com.alibaba.fastjson2.reader.FieldReaderObjectParam;
import com.alibaba.fastjson2.reader.FieldReaderStackTrace;
import com.alibaba.fastjson2.reader.FieldReaderStringArray;
import com.alibaba.fastjson2.reader.FieldReaderStringField;
import com.alibaba.fastjson2.reader.FieldReaderStringFunc;
import com.alibaba.fastjson2.reader.FieldReaderStringMethod;
import com.alibaba.fastjson2.reader.FieldReaderUUID;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReader1;
import com.alibaba.fastjson2.reader.ObjectReader2;
import com.alibaba.fastjson2.reader.ObjectReader3;
import com.alibaba.fastjson2.reader.ObjectReader4;
import com.alibaba.fastjson2.reader.ObjectReader5;
import com.alibaba.fastjson2.reader.ObjectReader6;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderBean;
import com.alibaba.fastjson2.reader.ObjectReaderException;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigDecimal;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplClass;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum;
import com.alibaba.fastjson2.reader.ObjectReaderImplEnum2X4;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplValue;
import com.alibaba.fastjson2.reader.ObjectReaderInterface;
import com.alibaba.fastjson2.reader.ObjectReaderNoneDefaultConstructor;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class ObjectReaderCreator {
    public static final ObjectReaderCreator INSTANCE = new ObjectReaderCreator();

    public <T> ObjectReader<T> createObjectReaderNoneDefaultConstructor(Constructor constructor, String ... paramNames) {
        Function<Map<Long, Object>, T> function = this.createFunction(constructor, paramNames);
        Class declaringClass = constructor.getDeclaringClass();
        FieldReader[] fieldReaders = this.createFieldReaders(JSONFactory.defaultObjectReaderProvider, declaringClass, declaringClass, constructor, constructor.getParameterTypes(), paramNames);
        return this.createObjectReaderNoneDefaultConstructor(declaringClass, function, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderNoneDefaultConstructor(Class objectClass, Function<Map<Long, Object>, T> creator, FieldReader ... fieldReaders) {
        return new ObjectReaderNoneDefaultConstructor<T>(objectClass, null, null, 0L, creator, null, fieldReaders, null, null, null);
    }

    public <T> ObjectReader<T> createObjectReaderFactoryMethod(Method factoryMethod, String ... paramNames) {
        Function<Map<Long, Object>, T> factoryFunction = this.createFactoryFunction(factoryMethod, paramNames);
        FieldReader[] fieldReaders = this.createFieldReaders(JSONFactory.defaultObjectReaderProvider, null, null, factoryMethod, factoryMethod.getParameterTypes(), paramNames);
        return new ObjectReaderNoneDefaultConstructor<T>(null, null, null, 0L, factoryFunction, paramNames, fieldReaders, null, null, null);
    }

    public FieldReader[] createFieldReaders(ObjectReaderProvider provider, Class objectClass, Type objectType, AccessibleObject owner, Class[] parameters, String ... paramNames) {
        Class<Object> declaringClass = null;
        Type[] paramTypes = null;
        Annotation[][] parameterAnnotations = null;
        if (owner instanceof Constructor) {
            declaringClass = ((Constructor)owner).getDeclaringClass();
            paramTypes = ((Constructor)owner).getGenericParameterTypes();
            parameterAnnotations = ((Constructor)owner).getParameterAnnotations();
        } else if (owner instanceof Method) {
            declaringClass = ((Method)owner).getDeclaringClass();
            paramTypes = ((Method)owner).getGenericParameterTypes();
            parameterAnnotations = ((Method)owner).getParameterAnnotations();
        }
        FieldReader[] fieldReaders = new FieldReader[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String fieldName;
            Field field;
            FieldInfo fieldInfo = new FieldInfo();
            String paramName = i < paramNames.length ? paramNames[i] : "arg" + i;
            if (owner instanceof Constructor) {
                provider.getFieldInfo(fieldInfo, declaringClass, (Constructor)owner, i, parameterAnnotations);
            }
            if (owner instanceof Constructor && (field = BeanUtils.getDeclaredField(declaringClass, paramName)) != null) {
                provider.getFieldInfo(fieldInfo, declaringClass, field);
            }
            if ((fieldName = fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty() ? paramName : fieldInfo.fieldName) == null) {
                fieldName = "arg" + i;
            }
            if (paramName == null) {
                paramName = "arg" + i;
            }
            Type paramType = paramTypes[i];
            ObjectReader initReader = ObjectReaderCreator.getInitReader(provider, paramType, parameters[i], fieldInfo);
            fieldReaders[i] = this.createFieldReaderParam(null, null, fieldName, i, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, paramType, parameters[i], paramName, declaringClass, initReader);
        }
        return fieldReaders;
    }

    public <T> Function<Map<Long, Object>, T> createFactoryFunction(Method factoryMethod, String ... paramNames) {
        factoryMethod.setAccessible(true);
        return new FactoryFunction(factoryMethod, paramNames);
    }

    public <T> Function<Map<Long, Object>, T> createFunction(Constructor constructor, String ... paramNames) {
        constructor.setAccessible(true);
        return new ConstructorFunction(null, constructor, null, null, null, paramNames);
    }

    public <T> Function<Map<Long, Object>, T> createFunction(Constructor constructor, Constructor markerConstructor, String ... paramNames) {
        if (markerConstructor == null) {
            constructor.setAccessible(true);
        } else {
            markerConstructor.setAccessible(true);
        }
        return new ConstructorFunction(null, constructor, null, null, markerConstructor, paramNames);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectClass, null, 0L, this.createSupplier(objectClass), null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, Supplier<T> defaultCreator, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectClass, null, 0L, defaultCreator, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectType, Class[] seeAlso, FieldReader ... fieldReaders) {
        Supplier<T> instanceSupplier = this.createSupplier(objectType);
        return new ObjectReaderSeeAlso<T>(objectType, instanceSupplier, "@type", seeAlso, null, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectClass, String typeKey, Class[] seeAlso, String[] seeAlsoNames, FieldReader ... fieldReaders) {
        Supplier<T> creator = this.createSupplier(objectClass);
        return new ObjectReaderSeeAlso<T>(objectClass, creator, typeKey, seeAlso, seeAlsoNames, null, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectClass, String typeKey, Class[] seeAlso, String[] seeAlsoNames, Class seeAlsoDefault, FieldReader ... fieldReaders) {
        Supplier<T> creator = this.createSupplier(objectClass);
        return new ObjectReaderSeeAlso<T>(objectClass, creator, typeKey, seeAlso, seeAlsoNames, seeAlsoDefault, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReaderSeeAlso(Class<T> objectType, Supplier<T> defaultCreator, String typeKey, Class[] seeAlso, String[] seeAlsoNames, FieldReader ... fieldReaders) {
        return new ObjectReaderSeeAlso<T>(objectType, defaultCreator, typeKey, seeAlso, seeAlsoNames, null, fieldReaders);
    }

    protected <T> ObjectReader<T> createObjectReaderWithBuilder(Class<T> objectClass, Type objectType, ObjectReaderProvider provider, BeanInfo beanInfo) {
        Function builderFunction = null;
        if (beanInfo.buildMethod != null) {
            builderFunction = this.createBuildFunction(beanInfo.buildMethod);
        }
        Class builderClass = beanInfo.builder;
        String builderWithPrefix = beanInfo.builderWithPrefix;
        if (builderWithPrefix == null || builderWithPrefix.isEmpty()) {
            builderWithPrefix = "with";
        }
        int builderWithPrefixLength = builderWithPrefix.length();
        LinkedHashMap fieldReaders = new LinkedHashMap();
        String prefix = builderWithPrefix;
        FieldInfo fieldInfo = new FieldInfo();
        BeanUtils.setters(builderClass, false, method -> {
            String fieldName;
            fieldInfo.init();
            provider.getFieldInfo(fieldInfo, objectClass, (Method)method);
            if (fieldInfo.ignore) {
                return;
            }
            String methodName = method.getName();
            if (fieldInfo.fieldName == null || fieldInfo.fieldName.isEmpty()) {
                boolean prefixNotMach;
                int methodNameLength = methodName.length();
                boolean bl = prefixNotMach = methodNameLength <= prefix.length() || !methodName.startsWith(prefix, 0);
                if (prefixNotMach) {
                    if (method.getDeclaringClass() == Object.class || method.getReturnType() != builderClass || method.getAnnotation(JSONField.class) == null && (beanInfo.readerFeatures & JSONReader.Feature.SupportSmartMatch.mask) == 0L) return;
                    fieldName = methodName;
                } else {
                    fieldName = BeanUtils.setterName(methodName, builderWithPrefixLength);
                }
            } else {
                fieldName = fieldInfo.fieldName;
            }
            if (method.getParameterCount() == 0) {
                FieldReader fieldReader = this.createFieldReaderMethod(builderClass, builderClass, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, method.getGenericReturnType(), method.getReturnType(), (Method)method, null);
                FieldReader origin = (FieldReader)fieldReaders.get(fieldName);
                if (origin == null) {
                    fieldReaders.put(fieldName, fieldReader);
                    return;
                } else {
                    if (origin.compareTo(fieldReader) <= 0) return;
                    fieldReaders.put(fieldName, fieldReader);
                }
                return;
            }
            Type fieldType = method.getGenericParameterTypes()[0];
            Class<?> fieldClass = method.getParameterTypes()[0];
            method.setAccessible(true);
            FieldReader fieldReader = this.createFieldReaderMethod(builderClass, objectType, fieldName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldType, fieldClass, (Method)method, null);
            FieldReader origin = (FieldReader)fieldReaders.get(fieldName);
            if (origin == null) {
                fieldReaders.put(fieldName, fieldReader);
            } else if (origin.compareTo(fieldReader) > 0) {
                fieldReaders.put(fieldName, fieldReader);
            }
            String[] alternateNames = fieldInfo.alternateNames;
            if (alternateNames == null) return;
            for (int i = 0; i < alternateNames.length; ++i) {
                FieldReader alterOrigin;
                String alternateName = alternateNames[i];
                if (fieldName.equals(alternateName) || (alterOrigin = (FieldReader)fieldReaders.get(alternateName)) != null) continue;
                fieldReaders.put(alternateName, this.createFieldReaderMethod(builderClass, objectType, alternateName, fieldInfo.ordinal, fieldInfo.features, fieldInfo.format, fieldInfo.locale, fieldInfo.defaultValue, fieldType, fieldClass, (Method)method, null));
            }
        });
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        Supplier<T> instanceSupplier = this.createSupplier(builderClass);
        return this.createObjectReader(builderClass, 0L, instanceSupplier, builderFunction, (FieldReader[])fieldReaderArray);
    }

    protected <T> ObjectReader<T> createObjectReaderWithCreator(Class<T> objectClass, Type objectType, ObjectReaderProvider provider, BeanInfo beanInfo) {
        Annotation[][] parameterAnnotations;
        Type[] genericParameterTypes;
        String[] paramNames;
        Class<Object> declaringClass;
        Class<?>[] parameters;
        FieldInfo fieldInfo = new FieldInfo();
        LinkedHashMap<String, FieldReader> fieldReaders = new LinkedHashMap<String, FieldReader>();
        if (beanInfo.creatorConstructor != null) {
            parameters = beanInfo.creatorConstructor.getParameterTypes();
            declaringClass = beanInfo.creatorConstructor.getDeclaringClass();
            paramNames = BeanUtils.lookupParameterNames(beanInfo.creatorConstructor);
            genericParameterTypes = beanInfo.creatorConstructor.getGenericParameterTypes();
            parameterAnnotations = beanInfo.creatorConstructor.getParameterAnnotations();
        } else {
            parameters = beanInfo.createMethod.getParameterTypes();
            declaringClass = beanInfo.createMethod.getDeclaringClass();
            paramNames = new String[parameters.length];
            genericParameterTypes = beanInfo.createMethod.getGenericParameterTypes();
            parameterAnnotations = beanInfo.createMethod.getParameterAnnotations();
        }
        for (int i = 0; i < parameters.length; ++i) {
            fieldInfo.init();
            if (beanInfo.creatorConstructor != null) {
                provider.getFieldInfo(fieldInfo, objectClass, beanInfo.creatorConstructor, i, parameterAnnotations);
            } else {
                provider.getFieldInfo(fieldInfo, objectClass, beanInfo.createMethod, i);
            }
            if (parameters.length == 1 && (fieldInfo.features & 0x1000000000000L) != 0L) break;
            String fieldName = fieldInfo.fieldName;
            if (fieldName == null || fieldName.isEmpty()) {
                if (beanInfo.createParameterNames != null && i < beanInfo.createParameterNames.length) {
                    fieldName = beanInfo.createParameterNames[i];
                }
                if (fieldName == null || fieldName.isEmpty()) {
                    fieldName = "arg" + i;
                }
            }
            if (fieldName.startsWith("arg", 0)) {
                if (paramNames.length > i) {
                    fieldName = paramNames[i];
                }
            } else {
                paramNames[i] = fieldName;
            }
            String finalFieldName = fieldName;
            Class<?> paramClass = parameters[i];
            BeanUtils.getters(objectClass, method -> {
                if (method.getReturnType() != paramClass) {
                    return;
                }
                FieldInfo methodFieldInfo = new FieldInfo();
                provider.getFieldInfo(methodFieldInfo, objectClass, (Method)method);
                String methodFieldName = methodFieldInfo.fieldName;
                if (methodFieldName == null) {
                    methodFieldName = BeanUtils.getterName(method, beanInfo.kotlin, PropertyNamingStrategy.CamelCase.name());
                }
                if (methodFieldInfo.readUsing != null && finalFieldName.equals(methodFieldName)) {
                    fieldInfo.readUsing = methodFieldInfo.readUsing;
                }
            });
            if (fieldName == null || fieldName.isEmpty()) {
                fieldName = "arg" + i;
            }
            Type paramType = genericParameterTypes[i];
            ObjectReader initReader = ObjectReaderCreator.getInitReader(provider, paramType, paramClass, fieldInfo);
            FieldReader fieldReaderParam = this.createFieldReaderParam(objectClass, objectType, fieldName, i, fieldInfo.features, fieldInfo.format, paramType, paramClass, fieldName, declaringClass, initReader);
            fieldReaders.put(fieldName, fieldReaderParam);
            String[] alternateNames = fieldInfo.alternateNames;
            if (alternateNames == null) continue;
            for (int j = 0; j < alternateNames.length; ++j) {
                FieldReader alterOrigin;
                String alternateName = alternateNames[j];
                if (fieldName.equals(alternateName) || (alterOrigin = (FieldReader)fieldReaders.get(alternateName)) != null) continue;
                fieldReaders.put(alternateName, this.createFieldReaderParam(objectClass, objectType, alternateName, i, fieldInfo.features, fieldInfo.format, paramType, paramClass, fieldName, declaringClass, null));
            }
        }
        if (parameters.length == 1 && (fieldInfo.features & 0x1000000000000L) != 0L) {
            Type valueType = beanInfo.creatorConstructor == null ? beanInfo.createMethod.getGenericParameterTypes()[0] : genericParameterTypes[0];
            Class<?> valueClass = beanInfo.creatorConstructor == null ? beanInfo.createMethod.getParameterTypes()[0] : beanInfo.creatorConstructor.getParameterTypes()[0];
            String defaultValue = fieldInfo.defaultValue;
            if (defaultValue != null && defaultValue.getClass() != valueClass) {
                Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), valueType);
                if (typeConvert != null) {
                    defaultValue = typeConvert.apply(defaultValue);
                } else {
                    throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + valueClass.getName());
                }
            }
            return new ObjectReaderImplValue(objectClass, valueType, valueClass, fieldInfo.features, fieldInfo.format, defaultValue, beanInfo.creatorConstructor, beanInfo.createMethod, null);
        }
        Function<Map<Long, Object>, Object> function = beanInfo.creatorConstructor != null ? this.createFunction(beanInfo.creatorConstructor, beanInfo.markerConstructor, paramNames) : this.createFactoryFunction(beanInfo.createMethod, paramNames);
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        Object[] setterFieldReaders = this.createFieldReaders(objectClass, objectType, null, false, provider);
        Arrays.sort(setterFieldReaders);
        boolean[] flags = null;
        int maskCount = 0;
        for (int i = 0; i < setterFieldReaders.length; ++i) {
            Object setterFieldReader = setterFieldReaders[i];
            if (!fieldReaders.containsKey(((FieldReader)setterFieldReader).fieldName)) continue;
            if (flags == null) {
                flags = new boolean[setterFieldReaders.length];
            }
            flags[i] = true;
            ++maskCount;
        }
        if (maskCount > 0) {
            FieldReader[] array = new FieldReader[setterFieldReaders.length - maskCount];
            int index = 0;
            for (int i = 0; i < setterFieldReaders.length; ++i) {
                if (flags[i]) continue;
                array[index++] = setterFieldReaders[i];
            }
            setterFieldReaders = array;
        }
        return new ObjectReaderNoneDefaultConstructor<T>(objectClass, beanInfo.typeKey, beanInfo.typeName, beanInfo.readerFeatures, function, paramNames, (FieldReader[])fieldReaderArray, (FieldReader[])setterFieldReaders, beanInfo.seeAlso, beanInfo.seeAlsoNames);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, long features, Supplier<T> defaultCreator, Function buildFunction, FieldReader ... fieldReaders) {
        return this.createObjectReader(objectClass, null, features, defaultCreator, buildFunction, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, String typeKey, long features, Supplier<T> defaultCreator, Function buildFunction, FieldReader ... fieldReaders) {
        int modifiers;
        if (objectClass != null && (Modifier.isAbstract(modifiers = objectClass.getModifiers()) || Modifier.isInterface(modifiers))) {
            return new ObjectReaderAdapter<T>(objectClass, typeKey, null, features, defaultCreator, buildFunction, fieldReaders);
        }
        switch (fieldReaders.length) {
            case 1: {
                return new ObjectReader1<T>(objectClass, null, null, features, defaultCreator, buildFunction, fieldReaders);
            }
            case 2: {
                return new ObjectReader2<T>(objectClass, null, null, features, defaultCreator, buildFunction, fieldReaders);
            }
            case 3: {
                return new ObjectReader3<T>(objectClass, null, null, features, defaultCreator, buildFunction, fieldReaders);
            }
            case 4: {
                return new ObjectReader4<T>(objectClass, null, null, features, defaultCreator, buildFunction, fieldReaders);
            }
            case 5: {
                return new ObjectReader5<T>(objectClass, null, null, features, defaultCreator, buildFunction, fieldReaders);
            }
            case 6: {
                return new ObjectReader6<T>(objectClass, null, null, features, defaultCreator, buildFunction, fieldReaders);
            }
        }
        return new ObjectReaderAdapter<T>(objectClass, typeKey, null, features, defaultCreator, buildFunction, fieldReaders);
    }

    public <T> ObjectReader<T> createObjectReader(Type objectType) {
        if (objectType instanceof Class) {
            return this.createObjectReader((Class)objectType);
        }
        Class<?> objectClass = TypeUtils.getMapping(objectType);
        FieldReader[] fieldReaderArray = this.createFieldReaders(objectClass, objectType);
        return this.createObjectReader(objectClass, this.createSupplier(objectClass), fieldReaderArray);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType) {
        return this.createObjectReader(objectType, objectType, false, JSONFactory.defaultObjectReaderProvider);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectType, boolean fieldBased) {
        return this.createObjectReader(objectType, objectType, fieldBased, JSONFactory.defaultObjectReaderProvider);
    }

    public <T> ObjectReader<T> createObjectReader(Class<T> objectClass, Type objectType, boolean fieldBased, ObjectReaderProvider provider) {
        BeanInfo beanInfo = new BeanInfo();
        if (fieldBased) {
            beanInfo.readerFeatures |= JSONReader.Feature.FieldBased.mask;
        }
        provider.getBeanInfo(beanInfo, objectClass);
        if (beanInfo.deserializer != null && ObjectReader.class.isAssignableFrom(beanInfo.deserializer)) {
            try {
                Constructor constructor2 = beanInfo.deserializer.getDeclaredConstructor(new Class[0]);
                constructor2.setAccessible(true);
                return (ObjectReader)constructor2.newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new JSONException("create deserializer error", e);
            }
        }
        if (fieldBased) {
            beanInfo.readerFeatures |= JSONReader.Feature.FieldBased.mask;
        }
        if (Enum.class.isAssignableFrom(objectClass) && (beanInfo.createMethod == null || beanInfo.createMethod.getParameterCount() == 1)) {
            return this.createEnumReader(objectClass, beanInfo.createMethod, provider);
        }
        if (Throwable.class.isAssignableFrom(objectClass)) {
            fieldBased = false;
            beanInfo.readerFeatures |= JSONReader.Feature.IgnoreSetNullValue.mask;
        }
        if (objectClass == Class.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        if (fieldBased && objectClass.isInterface()) {
            fieldBased = false;
        }
        FieldReader[] fieldReaderArray = this.createFieldReaders(objectClass, objectType, beanInfo, fieldBased, provider);
        boolean allReadOnlyOrZero = true;
        for (int i = 0; i < fieldReaderArray.length; ++i) {
            if (fieldReaderArray[i].isReadOnly()) continue;
            allReadOnlyOrZero = false;
            break;
        }
        if (beanInfo.creatorConstructor != null || beanInfo.createMethod != null) {
            return this.createObjectReaderWithCreator(objectClass, objectType, provider, beanInfo);
        }
        if (beanInfo.builder != null) {
            return this.createObjectReaderWithBuilder(objectClass, objectType, provider, beanInfo);
        }
        Constructor creatorConstructor = null;
        ArrayList<Constructor> alternateConstructors = new ArrayList<Constructor>();
        BeanUtils.constructor(objectClass, constructor -> alternateConstructors.add((Constructor)constructor));
        if (Throwable.class.isAssignableFrom(objectClass)) {
            return new ObjectReaderException<T>(objectClass, alternateConstructors, fieldReaderArray);
        }
        Constructor defaultConstructor = null;
        Class<?> declaringClass = objectClass.getDeclaringClass();
        int index = -1;
        for (int i = 0; i < alternateConstructors.size(); ++i) {
            Constructor constructor3 = (Constructor)alternateConstructors.get(i);
            int parameterCount = constructor3.getParameterCount();
            if (parameterCount == 0) {
                defaultConstructor = constructor3;
            }
            if (declaringClass != null && parameterCount == 1 && declaringClass.equals(constructor3.getParameterTypes()[0])) {
                creatorConstructor = constructor3;
                index = i;
                break;
            }
            if (creatorConstructor == null) {
                creatorConstructor = constructor3;
                index = i;
                continue;
            }
            if (parameterCount == 0) {
                creatorConstructor = constructor3;
                index = i;
                continue;
            }
            if (creatorConstructor.getParameterCount() >= parameterCount) continue;
            creatorConstructor = constructor3;
            index = i;
        }
        int creatorConstructorParameterCount = creatorConstructor != null ? creatorConstructor.getParameterCount() : -1;
        if (index != -1) {
            alternateConstructors.remove(index);
        }
        if (creatorConstructor != null && creatorConstructorParameterCount != 0 && beanInfo.seeAlso == null) {
            creatorConstructor.setAccessible(true);
            String[] parameterNames = beanInfo.createParameterNames;
            if (parameterNames == null || parameterNames.length == 0) {
                parameterNames = BeanUtils.lookupParameterNames(creatorConstructor);
                Class<?>[] parameters = creatorConstructor.getParameterTypes();
                Annotation[][] parameterAnnotations = creatorConstructor.getParameterAnnotations();
                FieldInfo fieldInfo = new FieldInfo();
                for (int i = 0; i < parameters.length && i < parameterNames.length; ++i) {
                    fieldInfo.init();
                    provider.getFieldInfo(fieldInfo, objectClass, creatorConstructor, i, parameterAnnotations);
                    if (fieldInfo.fieldName == null) continue;
                    parameterNames[i] = fieldInfo.fieldName;
                }
            }
            int matchCount = 0;
            if (defaultConstructor != null) {
                block7: for (int i = 0; i < parameterNames.length; ++i) {
                    String parameterName = parameterNames[i];
                    if (parameterName == null) continue;
                    for (int j = 0; j < fieldReaderArray.length; ++j) {
                        FieldReader fieldReader = fieldReaderArray[j];
                        if (fieldReader == null || !parameterName.equals(fieldReader.fieldName)) continue;
                        ++matchCount;
                        continue block7;
                    }
                }
            }
            if (!fieldBased && !Throwable.class.isAssignableFrom(objectClass) && defaultConstructor == null && matchCount != parameterNames.length) {
                if (creatorConstructorParameterCount == 1) {
                    FieldInfo fieldInfo = new FieldInfo();
                    provider.getFieldInfo(fieldInfo, objectClass, creatorConstructor, 0, null);
                    if ((fieldInfo.features & 0x1000000000000L) != 0L) {
                        Type valueType = creatorConstructor.getGenericParameterTypes()[0];
                        Class<?> valueClass = creatorConstructor.getParameterTypes()[0];
                        String defaultValue = fieldInfo.defaultValue;
                        if (defaultValue != null && defaultValue.getClass() != valueClass) {
                            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), valueType);
                            if (typeConvert != null) {
                                defaultValue = typeConvert.apply(defaultValue);
                            } else {
                                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + valueClass.getName());
                            }
                        }
                        return new ObjectReaderImplValue(objectClass, valueType, valueClass, fieldInfo.features, fieldInfo.format, defaultValue, creatorConstructor, null, null);
                    }
                }
                if (allReadOnlyOrZero && fieldReaderArray.length != 0 && alternateConstructors.isEmpty()) {
                    block9: for (int i = 0; i < parameterNames.length; ++i) {
                        String paramName = parameterNames[i];
                        for (FieldReader fieldReader : fieldReaderArray) {
                            if (fieldReader.field == null || !fieldReader.field.getName().equals(paramName) || fieldReader.fieldName.equals(paramName)) continue;
                            parameterNames[i] = fieldReader.fieldName;
                            continue block9;
                        }
                    }
                }
                ConstructorFunction constructorFunction = new ConstructorFunction(alternateConstructors, creatorConstructor, null, null, null, parameterNames);
                FieldReader[] paramFieldReaders = this.createFieldReaders(provider, objectClass, objectType, creatorConstructor, creatorConstructor.getParameterTypes(), parameterNames);
                return new ObjectReaderNoneDefaultConstructor(objectClass, beanInfo.typeKey, beanInfo.typeName, beanInfo.readerFeatures, constructorFunction, parameterNames, paramFieldReaders, fieldReaderArray, null, null);
            }
        }
        if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0) {
            return this.createObjectReaderSeeAlso(objectClass, beanInfo.typeKey, beanInfo.seeAlso, beanInfo.seeAlsoNames, beanInfo.seeAlsoDefault, fieldReaderArray);
        }
        if (objectClass.isInterface()) {
            return new ObjectReaderInterface((Class)objectClass, null, null, 0L, null, null, fieldReaderArray);
        }
        Supplier<T> creator = this.createSupplier(objectClass);
        ObjectReader<T> objectReader = this.createObjectReader(objectClass, beanInfo.typeKey, beanInfo.readerFeatures, creator, null, fieldReaderArray);
        if (objectReader instanceof ObjectReaderBean) {
            JSONReader.AutoTypeBeforeHandler beforeHandler = null;
            if (beanInfo.autoTypeBeforeHandler != null) {
                try {
                    Constructor<? extends JSONReader.AutoTypeBeforeHandler> constructor4 = beanInfo.autoTypeBeforeHandler.getDeclaredConstructor(new Class[0]);
                    constructor4.setAccessible(true);
                    beforeHandler = constructor4.newInstance(new Object[0]);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (beforeHandler != null) {
                ((ObjectReaderBean)objectReader).setAutoTypeBeforeHandler(beforeHandler);
            }
        }
        return objectReader;
    }

    public <T> FieldReader[] createFieldReaders(Class<T> objectClass) {
        return this.createFieldReaders(objectClass, objectClass, null, false, JSONFactory.defaultObjectReaderProvider);
    }

    public <T> FieldReader[] createFieldReaders(Class<T> objectClass, Type objectType) {
        return this.createFieldReaders(objectClass, objectType, null, false, JSONFactory.defaultObjectReaderProvider);
    }

    protected <T> FieldReader[] createFieldReaders(Class<T> objectClass, Type objectType, BeanInfo beanInfo, boolean fieldBased, ObjectReaderProvider provider) {
        if (beanInfo == null) {
            beanInfo = new BeanInfo();
            provider.getBeanInfo(beanInfo, objectClass);
        }
        String namingStrategy = beanInfo.namingStrategy;
        LinkedHashMap<String, FieldReader> fieldReaders = new LinkedHashMap<String, FieldReader>();
        FieldInfo fieldInfo = new FieldInfo();
        String[] orders = beanInfo.orders;
        FieldConsumer fieldConsumer = new FieldConsumer(objectClass, objectType, namingStrategy, fieldInfo, fieldReaders, provider, beanInfo, fieldBased);
        if (fieldBased) {
            BeanUtils.declaredFields(objectClass, fieldConsumer);
        } else {
            BeanUtils.declaredFields(objectClass, fieldConsumer);
            Class mixIn = (Class)provider.mixInCache.get(objectClass);
            CreateFieldReaderConsumer consumer = new CreateFieldReaderConsumer(objectClass, objectType, namingStrategy, orders, beanInfo, fieldInfo, fieldReaders, provider);
            BeanUtils.setters(objectClass, beanInfo, mixIn, consumer);
            if (objectClass.isInterface()) {
                BeanUtils.getters(objectClass, consumer);
            }
        }
        Object[] fieldReaderArray = new FieldReader[fieldReaders.size()];
        fieldReaders.values().toArray(fieldReaderArray);
        Arrays.sort(fieldReaderArray);
        return fieldReaderArray;
    }

    public <T> Supplier<T> createSupplier(Class<T> objectClass) {
        Constructor<T> constructor;
        if (objectClass.isInterface() || Modifier.isAbstract(objectClass.getModifiers())) {
            return null;
        }
        try {
            constructor = objectClass.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
        catch (Throwable e) {
            throw new JSONException("get constructor error, class " + objectClass.getName(), e);
        }
        return new ConstructorSupplier(constructor);
    }

    public <T, R> Function<T, R> createBuildFunction(Method builderMethod) {
        builderMethod.setAccessible(true);
        return o -> {
            try {
                return builderMethod.invoke(o, new Object[0]);
            }
            catch (Throwable e) {
                throw new JSONException("create instance error", e);
            }
        };
    }

    public <T> FieldReader createFieldReader(Class<T> objectType, String fieldName, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectType, objectType, fieldName, 0, 0L, null, null, null, fieldType, fieldClass, method, null);
    }

    public <T> FieldReader createFieldReader(Class<T> objectType, String fieldName, String format, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectType, fieldName, format, fieldType, fieldClass, method);
    }

    public <T> FieldReader createFieldReaderMethod(Class<T> objectClass, String fieldName, String format, Type fieldType, Class fieldClass, Method method) {
        return this.createFieldReaderMethod(objectClass, objectClass, fieldName, 0, 0L, format, null, null, fieldType, fieldClass, method, null);
    }

    public <T> FieldReader createFieldReaderParam(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Type fieldType, Class fieldClass, String paramName, Class declaringClass) {
        return this.createFieldReaderParam(objectClass, objectType, fieldName, ordinal, features, format, null, null, fieldType, fieldClass, paramName, declaringClass, null);
    }

    public <T> FieldReader createFieldReaderParam(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Type fieldType, Class fieldClass, String paramName, Class declaringClass, ObjectReader initReader) {
        return this.createFieldReaderParam(objectClass, objectType, fieldName, ordinal, features, format, null, null, fieldType, fieldClass, paramName, declaringClass, initReader);
    }

    public <T> FieldReader createFieldReaderParam(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, Type fieldType, Class fieldClass, String paramName, Class declaringClass, ObjectReader initReader) {
        if (initReader != null) {
            FieldReaderObjectParam paramReader = new FieldReaderObjectParam(fieldName, fieldType, fieldClass, paramName, ordinal, features, format, locale, defaultValue);
            paramReader.initReader = initReader;
            return paramReader;
        }
        if (fieldType == Byte.TYPE || fieldType == Byte.class) {
            return new FieldReaderInt8Param(fieldName, fieldClass, paramName, ordinal, features, format, locale, defaultValue);
        }
        if (fieldType == Short.TYPE || fieldType == Short.class) {
            return new FieldReaderInt16Param(fieldName, fieldClass, paramName, ordinal, features, format, locale, defaultValue);
        }
        if (fieldType == Integer.TYPE || fieldType == Integer.class) {
            return new FieldReaderInt32Param(fieldName, fieldClass, paramName, ordinal, features, format, locale, defaultValue);
        }
        if (fieldType == Long.TYPE || fieldType == Long.class) {
            return new FieldReaderInt64Param(fieldName, fieldClass, paramName, ordinal, features, format, locale, defaultValue);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class) && objectType != null && (fieldTypeResolved = BeanUtils.getParamType(TypeReference.get(objectType), objectClass, declaringClass, fieldType)) != null) {
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (fieldTypeResolved == null) {
            fieldTypeResolved = fieldType;
        }
        if (fieldClassResolved == null) {
            fieldClassResolved = fieldClass;
        }
        return new FieldReaderObjectParam(fieldName, fieldTypeResolved, fieldClassResolved, paramName, ordinal, features, format, locale, defaultValue);
    }

    public <T> FieldReader createFieldReaderMethod(Class<T> objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, Type fieldType, Class fieldClass, Method method, ObjectReader initReader) {
        String methodName;
        if (method != null) {
            method.setAccessible(true);
        }
        if (defaultValue instanceof String && fieldClass.isEnum()) {
            defaultValue = Enum.valueOf(fieldClass, (String)defaultValue);
        }
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            Function typeConvert = JSONFactory.getDefaultObjectReaderProvider().getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        if (initReader != null) {
            FieldReaderObject fieldReaderObjectMethod = new FieldReaderObject(fieldName, fieldType, fieldClass, ordinal, features | 0x8000000000000L, format, locale, defaultValue, method, null, null);
            fieldReaderObjectMethod.initReader = initReader;
            return fieldReaderObjectMethod;
        }
        if (fieldType == Boolean.TYPE) {
            return new FieldReaderBoolValueMethod(fieldName, ordinal, features, format, (Boolean)defaultValue, method);
        }
        if (fieldType == Boolean.class) {
            return new FieldReaderBoolMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Boolean)defaultValue, method);
        }
        if (fieldType == Byte.TYPE) {
            return new FieldReaderInt8ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Byte)defaultValue, method);
        }
        if (fieldType == Short.TYPE) {
            return new FieldReaderInt16ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Short)defaultValue, method);
        }
        if (fieldType == Integer.TYPE) {
            return new FieldReaderInt32ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, (Integer)defaultValue, method);
        }
        if (fieldType == Long.TYPE) {
            return new FieldReaderInt64ValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Long)defaultValue, method);
        }
        if (fieldType == Float.TYPE) {
            return new FieldReaderFloatValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Float)defaultValue, method);
        }
        if (fieldType == Double.TYPE) {
            return new FieldReaderDoubleValueMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Double)defaultValue, method);
        }
        if (fieldType == Byte.class) {
            return new FieldReaderInt8Method(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Byte)defaultValue, method);
        }
        if (fieldType == Short.class) {
            return new FieldReaderInt16Method(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (Short)defaultValue, method);
        }
        if (fieldType == Integer.class) {
            return new FieldReaderInt32Method(fieldName, ordinal, features, format, locale, (Integer)defaultValue, method);
        }
        if (fieldType == Long.class) {
            return new FieldReaderInt64Method(fieldName, ordinal, features, format, locale, (Long)defaultValue, method);
        }
        if (fieldType == Float.class) {
            return new FieldReaderFloatMethod(fieldName, ordinal, features, format, locale, (Float)defaultValue, method);
        }
        if (fieldType == Double.class) {
            return new FieldReaderDoubleMethod(fieldName, ordinal, features, format, (Double)defaultValue, method);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (BigDecimal)defaultValue, method);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (BigInteger)defaultValue, method);
        }
        if (fieldType == String.class) {
            return new FieldReaderStringMethod(fieldName, fieldType, fieldClass, ordinal, features, format, locale, (String)defaultValue, method);
        }
        if (fieldType == UUID.class) {
            return new FieldReaderUUID(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, method, null, null);
        }
        if (fieldType == String[].class) {
            return new FieldReaderStringArray(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, method, null, null);
        }
        if (method.getParameterCount() == 0) {
            Field field;
            if (fieldClass == AtomicInteger.class) {
                return new FieldReaderAtomicIntegerMethodReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicLong.class) {
                return new FieldReaderAtomicLongReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicIntegerArray.class) {
                return new FieldReaderAtomicIntegerArrayReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicLongArray.class) {
                return new FieldReaderAtomicLongArrayReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicBoolean.class) {
                return new FieldReaderAtomicBooleanMethodReadOnly(fieldName, fieldClass, ordinal, method);
            }
            if (fieldClass == AtomicReference.class) {
                return new FieldReaderAtomicReferenceMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, method);
            }
            if (Collection.class.isAssignableFrom(fieldClass)) {
                field = null;
                String methodName2 = method.getName();
                if (methodName2.startsWith("get", 0)) {
                    String getterName = BeanUtils.getterName(methodName2, PropertyNamingStrategy.CamelCase.name());
                    field = BeanUtils.getDeclaredField(method.getDeclaringClass(), getterName);
                }
                return new FieldReaderCollectionMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, features, format, method, field);
            }
            if (Map.class.isAssignableFrom(fieldClass)) {
                field = null;
                String methodName3 = method.getName();
                if (methodName3.startsWith("get", 0)) {
                    String getterName = BeanUtils.getterName(methodName3, PropertyNamingStrategy.CamelCase.name());
                    field = BeanUtils.getDeclaredField(method.getDeclaringClass(), getterName);
                }
                return new FieldReaderMapMethodReadOnly(fieldName, fieldType, fieldClass, ordinal, features, format, method, field);
            }
            if (!objectClass.isInterface()) {
                return null;
            }
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            fieldTypeResolved = BeanUtils.getFieldType(TypeReference.get(objectType), objectClass, method, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1) {
                Type itemType = actualTypeArguments[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (itemClass == String.class) {
                    return new FieldReaderList(fieldName, fieldTypeResolved, fieldClass, (Type)((Object)String.class), String.class, ordinal, features, format, locale, null, method, null, null);
                }
                return new FieldReaderList(fieldName, fieldTypeResolved, fieldClassResolved, itemType, itemClass, ordinal, features, format, locale, null, method, null, null);
            }
            return new FieldReaderList(fieldName, fieldType, fieldClass, (Type)((Object)Object.class), Object.class, ordinal, features, format, locale, null, method, null, null);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDate(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, null, method, null);
        }
        if (fieldClass == StackTraceElement[].class && method.getDeclaringClass() == Throwable.class) {
            return new FieldReaderStackTrace(fieldName, fieldTypeResolved != null ? fieldTypeResolved : fieldType, fieldClass, ordinal, features, format, locale, defaultValue, method, null, Throwable::setStackTrace);
        }
        Field field = null;
        if ((features & 0x2000000000000L) != 0L && (methodName = method.getName()).startsWith("set", 0)) {
            String setterName = BeanUtils.setterName(methodName, PropertyNamingStrategy.CamelCase.name());
            field = BeanUtils.getDeclaredField(method.getDeclaringClass(), setterName);
            try {
                field.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return new FieldReaderObject(fieldName, fieldTypeResolved != null ? fieldTypeResolved : fieldType, fieldClass, ordinal, features, format, locale, defaultValue, method, field, null);
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, Type fieldType, Field field) {
        return this.createFieldReader(fieldName, null, fieldType, field);
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, String format, Type fieldType, Field field) {
        Class<?> objectClass = field.getDeclaringClass();
        return this.createFieldReader(objectClass, objectClass, fieldName, 0L, format, fieldType, field.getType(), field);
    }

    public <T> FieldReader<T> createFieldReader(Class objectClass, Type objectType, String fieldName, long features, String format, Type fieldType, Class fieldClass, Field field) {
        return this.createFieldReader(objectClass, objectType, fieldName, 0, features, format, null, null, fieldType, field.getType(), field, null);
    }

    public <T> FieldReader<T> createFieldReader(Class objectClass, Type objectType, String fieldName, int ordinal, long features, String format, Locale locale, Object defaultValue, Type fieldType, Class fieldClass, Field field, ObjectReader initReader) {
        ParameterizedType parameterizedType;
        Type[] actualTypeArguments;
        String objectClassName;
        if (defaultValue instanceof String && fieldClass.isEnum()) {
            defaultValue = Enum.valueOf(fieldClass, (String)defaultValue);
        }
        if (defaultValue != null && defaultValue.getClass() != fieldClass) {
            ObjectReaderProvider provider = JSONFactory.getDefaultObjectReaderProvider();
            Function typeConvert = provider.getTypeConvert(defaultValue.getClass(), fieldType);
            if (typeConvert != null) {
                defaultValue = typeConvert.apply(defaultValue);
            } else {
                throw new JSONException("illegal defaultValue : " + defaultValue + ", class " + fieldClass.getName());
            }
        }
        if (field != null && !(objectClassName = objectClass.getName()).startsWith("java.lang", 0)) {
            field.setAccessible(true);
        }
        if (initReader != null) {
            FieldReaderObjectField fieldReader = new FieldReaderObjectField(fieldName, fieldType, fieldClass, ordinal, features | 0x8000000000000L, format, defaultValue, field);
            fieldReader.initReader = initReader;
            return fieldReader;
        }
        if (fieldClass == Integer.TYPE) {
            return new FieldReaderInt32ValueField(fieldName, fieldClass, ordinal, format, (Integer)defaultValue, field);
        }
        if (fieldClass == Integer.class) {
            return new FieldReaderInt32Field(fieldName, fieldClass, ordinal, features, format, (Integer)defaultValue, field);
        }
        if (fieldClass == Long.TYPE) {
            return new FieldReaderInt64ValueField(fieldName, fieldClass, ordinal, features, format, (Long)defaultValue, field);
        }
        if (fieldClass == Long.class) {
            return new FieldReaderInt64Field(fieldName, fieldClass, ordinal, features, format, (Long)defaultValue, field);
        }
        if (fieldClass == Short.TYPE) {
            return new FieldReaderInt16ValueField(fieldName, fieldClass, ordinal, features, format, (Short)defaultValue, field);
        }
        if (fieldClass == Short.class) {
            return new FieldReaderInt16Field(fieldName, fieldClass, ordinal, features, format, (Short)defaultValue, field);
        }
        if (fieldClass == Boolean.TYPE) {
            return new FieldReaderBoolValueField(fieldName, ordinal, features, format, (Boolean)defaultValue, field);
        }
        if (fieldClass == Boolean.class) {
            return new FieldReaderBoolField(fieldName, fieldClass, ordinal, features, format, (Boolean)defaultValue, field);
        }
        if (fieldClass == Byte.TYPE) {
            return new FieldReaderInt8ValueField(fieldName, fieldClass, ordinal, features, format, (Byte)defaultValue, field);
        }
        if (fieldClass == Byte.class) {
            return new FieldReaderInt8Field(fieldName, fieldClass, ordinal, features, format, (Byte)defaultValue, field);
        }
        if (fieldClass == Float.TYPE) {
            return new FieldReaderFloatValueField(fieldName, fieldClass, ordinal, features, format, (Float)defaultValue, field);
        }
        if (fieldClass == Float.class) {
            return new FieldReaderFloatField(fieldName, fieldClass, ordinal, features, format, (Float)defaultValue, field);
        }
        if (fieldClass == Double.TYPE) {
            return new FieldReaderDoubleValueField(fieldName, fieldClass, ordinal, features, format, (Double)defaultValue, field);
        }
        if (fieldClass == Double.class) {
            return new FieldReaderDoubleField(fieldName, fieldClass, ordinal, features, format, (Double)defaultValue, field);
        }
        if (fieldClass == Character.TYPE) {
            return new FieldReaderCharValueField(fieldName, ordinal, features, format, (Character)defaultValue, field);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalField(fieldName, fieldClass, ordinal, features, format, (BigDecimal)defaultValue, field);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerField(fieldName, fieldClass, ordinal, features, format, (BigInteger)defaultValue, field);
        }
        if (fieldClass == String.class) {
            return new FieldReaderStringField(fieldName, fieldClass, ordinal, features, format, (String)defaultValue, field);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDate(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, field, null, null);
        }
        if (fieldClass == AtomicBoolean.class) {
            return new FieldReaderAtomicBooleanFieldReadOnly(fieldName, fieldClass, ordinal, format, (AtomicBoolean)defaultValue, field);
        }
        if (fieldClass == AtomicReference.class) {
            return new FieldReaderAtomicReferenceField(fieldName, fieldType, fieldClass, ordinal, format, field);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            fieldTypeResolved = BeanUtils.getFieldType(TypeReference.get(objectType), objectClass, field, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        boolean finalField = Modifier.isFinal(field.getModifiers());
        if (Collection.class.isAssignableFrom(fieldClass)) {
            ParameterizedType parameterizedType2;
            Type[] actualTypeArguments2;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments2 = (parameterizedType2 = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1) {
                Type itemType = actualTypeArguments2[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (itemClass == String.class) {
                    if (finalField) {
                        if ((features & JSONReader.Feature.FieldBased.mask) != 0L) {
                            return new FieldReaderListFieldUF(fieldName, fieldTypeResolved, (Class)fieldClassResolved, (Type)((Object)String.class), String.class, ordinal, features, format, locale, null, field);
                        }
                        return new FieldReaderCollectionFieldReadOnly(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, field);
                    }
                    return new FieldReaderListFieldUF(fieldName, fieldTypeResolved, (Class)fieldClassResolved, (Type)((Object)String.class), String.class, ordinal, features, format, locale, null, field);
                }
                return new FieldReaderListFieldUF(fieldName, fieldTypeResolved, fieldClassResolved, itemType, itemClass, ordinal, features, format, locale, (Collection)defaultValue, field);
            }
            Object itemType = null;
            if (fieldType instanceof ParameterizedType && (actualTypeArguments2 = ((ParameterizedType)fieldType).getActualTypeArguments()).length > 0) {
                itemType = actualTypeArguments2[0];
            }
            if (itemType == null) {
                itemType = Object.class;
            }
            Class<?> itemClass = TypeUtils.getClass(itemType);
            return new FieldReaderListFieldUF(fieldName, fieldType, fieldClass, (Type)itemType, itemClass, ordinal, features, format, locale, (Collection)defaultValue, field);
        }
        if (Map.class.isAssignableFrom(fieldClass) && fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 2 && finalField && (features & JSONReader.Feature.FieldBased.mask) == 0L) {
            return new FieldReaderMapFieldReadOnly(fieldName, fieldTypeResolved, fieldClassResolved, ordinal, features, format, field);
        }
        if (finalField) {
            if (fieldClass == int[].class) {
                return new FieldReaderInt32ValueArrayFinalField(fieldName, fieldClass, ordinal, features, format, (int[])defaultValue, field);
            }
            if (fieldClass == long[].class) {
                return new FieldReaderInt64ValueArrayFinalField(fieldName, fieldClass, ordinal, features, format, (long[])defaultValue, field);
            }
        }
        if (fieldClassResolved != null) {
            if ((features & 0x2000000000000L) != 0L && Map.class.isAssignableFrom(fieldClassResolved)) {
                return new FieldReaderMapFieldReadOnly(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, field);
            }
            return new FieldReaderObjectField(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, defaultValue, field);
        }
        return new FieldReaderObjectField(fieldName, fieldType, fieldClass, ordinal, features, format, defaultValue, field);
    }

    public <T, V> FieldReader createFieldReader(String fieldName, Type fieldType, Class<V> fieldClass, Method method, BiConsumer<T, V> function) {
        return this.createFieldReader(null, null, fieldName, fieldType, fieldClass, 0, 0L, null, null, null, method, function, null);
    }

    public <T, V> FieldReader createFieldReader(Class objectClass, Type objectType, String fieldName, Type fieldType, Class<V> fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, Method method, BiConsumer<T, V> function, ObjectReader initReader) {
        if (initReader != null) {
            FieldReaderObject fieldReaderObjectMethod = new FieldReaderObject(fieldName, fieldType, fieldClass, ordinal, features | 0x8000000000000L, format, locale, defaultValue, method, null, function);
            fieldReaderObjectMethod.initReader = initReader;
            return fieldReaderObjectMethod;
        }
        if (fieldClass == Integer.class) {
            return new FieldReaderInt32Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == Long.class) {
            return new FieldReaderInt64Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == String.class) {
            return new FieldReaderStringFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == Boolean.class) {
            return new FieldReaderBoolFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == Short.class) {
            return new FieldReaderInt16Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == Byte.class) {
            return new FieldReaderInt8Func<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == BigDecimal.class) {
            return new FieldReaderBigDecimalFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == BigInteger.class) {
            return new FieldReaderBigIntegerFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, defaultValue, method, function);
        }
        if (fieldClass == Float.class) {
            return new FieldReaderFloatFunc<T>(fieldName, fieldClass, ordinal, features, format, locale, (Float)defaultValue, method, function);
        }
        if (fieldClass == Double.class) {
            return new FieldReaderDoubleFunc<T>(fieldName, fieldClass, ordinal, features, format, locale, (Double)defaultValue, method, function);
        }
        if (fieldClass == Number.class) {
            return new FieldReaderNumberFunc<T, V>(fieldName, fieldClass, ordinal, features, format, locale, (Number)defaultValue, method, function);
        }
        if (fieldClass == Date.class) {
            return new FieldReaderDate<T>(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, null, method, function);
        }
        Type fieldTypeResolved = null;
        Class<?> fieldClassResolved = null;
        if (!(fieldType instanceof Class)) {
            TypeReference<?> objectTypeReference = objectType == null ? null : TypeReference.get(objectType);
            fieldTypeResolved = BeanUtils.getFieldType(objectTypeReference, objectClass, method, fieldType);
            fieldClassResolved = TypeUtils.getMapping(fieldTypeResolved);
        }
        if (fieldClass == List.class || fieldClass == ArrayList.class) {
            ParameterizedType parameterizedType;
            Type[] actualTypeArguments;
            Object itemType = Object.class;
            Class itemClass = Object.class;
            if (fieldTypeResolved instanceof ParameterizedType && (actualTypeArguments = (parameterizedType = (ParameterizedType)fieldTypeResolved).getActualTypeArguments()).length == 1 && (itemClass = TypeUtils.getMapping((Type)(itemType = actualTypeArguments[0]))) == String.class) {
                return new FieldReaderList(fieldName, fieldTypeResolved, fieldClassResolved, (Type)((Object)String.class), String.class, ordinal, features, format, locale, defaultValue, method, null, function);
            }
            return new FieldReaderList(fieldName, fieldTypeResolved, fieldClassResolved, (Type)itemType, itemClass, ordinal, features, format, locale, defaultValue, method, null, function);
        }
        if (fieldTypeResolved != null) {
            return new FieldReaderObjectFunc<T, V>(fieldName, fieldTypeResolved, fieldClass, ordinal, features, format, locale, defaultValue, method, function, null);
        }
        return new FieldReaderObjectFunc<T, V>(fieldName, fieldType, fieldClass, ordinal, features, format, locale, defaultValue, method, function, null);
    }

    protected ObjectReader createEnumReader(Class objectClass, Method createMethod, ObjectReaderProvider provider) {
        Class fieldClassMixInSource;
        Object name;
        Enum e;
        int i;
        FieldInfo fieldInfo = new FieldInfo();
        Enum[] ordinalEnums = (Enum[])objectClass.getEnumConstants();
        LinkedHashMap<Long, Enum> enumMap = new LinkedHashMap<Long, Enum>();
        for (i = 0; ordinalEnums != null && i < ordinalEnums.length; ++i) {
            e = ordinalEnums[i];
            name = e.name();
            long hash = Fnv.hashCode64((String)name);
            enumMap.put(hash, e);
            try {
                fieldInfo.init();
                Field field = BeanUtils.getField(objectClass, (String)name);
                provider.getFieldInfo(fieldInfo, objectClass, field);
                String jsonFieldName = fieldInfo.fieldName;
                if (jsonFieldName != null && !jsonFieldName.isEmpty() && !jsonFieldName.equals(name)) {
                    long jsonFieldNameHash = Fnv.hashCode64(jsonFieldName);
                    enumMap.put(jsonFieldNameHash, e);
                }
                if (fieldInfo.alternateNames == null) continue;
                for (String alternateName : fieldInfo.alternateNames) {
                    if (alternateName == null || alternateName.isEmpty()) continue;
                    long alternateNameHash = Fnv.hashCode64(alternateName);
                    enumMap.put(alternateNameHash, e);
                }
                continue;
            }
            catch (Exception field) {
                // empty catch block
            }
        }
        for (i = 0; ordinalEnums != null && i < ordinalEnums.length; ++i) {
            e = ordinalEnums[i];
            name = e.name();
            long hashLCase = Fnv.hashCode64LCase((String)name);
            enumMap.put(hashLCase, e);
        }
        long[] enumNameHashCodes = new long[enumMap.size()];
        int i2 = 0;
        for (Long h : enumMap.keySet()) {
            enumNameHashCodes[i2++] = h;
        }
        Arrays.sort(enumNameHashCodes);
        Member enumValueField = BeanUtils.getEnumValueField(objectClass, provider);
        if (enumValueField == null && provider != null && (fieldClassMixInSource = (Class)provider.mixInCache.get(objectClass)) != null) {
            Member mixedValueField = BeanUtils.getEnumValueField(fieldClassMixInSource, provider);
            if (mixedValueField instanceof Field) {
                try {
                    enumValueField = objectClass.getField(mixedValueField.getName());
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else if (mixedValueField instanceof Method) {
                try {
                    enumValueField = objectClass.getMethod(mixedValueField.getName(), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        Enum[] enums = new Enum[enumNameHashCodes.length];
        for (int i3 = 0; i3 < enumNameHashCodes.length; ++i3) {
            Enum e2;
            long hash = enumNameHashCodes[i3];
            enums[i3] = e2 = (Enum)enumMap.get(hash);
        }
        if (createMethod == null && enumValueField == null && ordinalEnums != null && ordinalEnums.length == 2) {
            Enum first = ordinalEnums[0];
            int matchCount = 0;
            for (int i4 = 0; i4 < enums.length; ++i4) {
                if (enums[i4] != first) continue;
                ++matchCount;
            }
            if (matchCount == 2) {
                return new ObjectReaderImplEnum2X4(objectClass, enums, ordinalEnums, enumNameHashCodes);
            }
        }
        return new ObjectReaderImplEnum(objectClass, createMethod, enumValueField, enums, ordinalEnums, enumNameHashCodes);
    }

    static ObjectReader getInitReader(ObjectReaderProvider provider, Type fieldType, Class fieldClass, FieldInfo fieldInfo) {
        ObjectReader initReader = fieldInfo.getInitReader();
        if (initReader == null && (fieldInfo.keyUsing != null || fieldInfo.valueUsing != null) && Map.class.isAssignableFrom(fieldClass)) {
            ObjectReader reader;
            ObjectReader keyReader = null;
            if (fieldInfo.keyUsing != null) {
                try {
                    Constructor<?> constructor = fieldInfo.keyUsing.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    keyReader = (ObjectReader)constructor.newInstance(new Object[0]);
                }
                catch (Exception constructor) {
                    // empty catch block
                }
            }
            ObjectReader valueReader = null;
            if (fieldInfo.valueUsing != null) {
                try {
                    Constructor<?> constructor = fieldInfo.valueUsing.getDeclaredConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    valueReader = (ObjectReader)constructor.newInstance(new Object[0]);
                }
                catch (Exception constructor) {
                    // empty catch block
                }
            }
            if ((keyReader != null || valueReader != null) && (reader = ObjectReaderImplMap.of(fieldType, fieldClass, fieldInfo.features)) instanceof ObjectReaderImplMapTyped) {
                ObjectReaderImplMapTyped mapReader = (ObjectReaderImplMapTyped)reader;
                if (keyReader != null) {
                    mapReader.keyObjectReader = keyReader;
                }
                if (valueReader != null) {
                    mapReader.valueObjectReader = valueReader;
                }
                return mapReader;
            }
        }
        if (initReader == null) {
            ObjectReader objectReader;
            if (fieldClass == BigDecimal.class) {
                objectReader = provider.getObjectReader((Type)((Object)BigDecimal.class), false);
                if (objectReader != ObjectReaderImplBigDecimal.INSTANCE) {
                    initReader = objectReader;
                }
            } else if (fieldClass == BigInteger.class) {
                objectReader = provider.getObjectReader((Type)((Object)BigInteger.class), false);
                if (objectReader != ObjectReaderImplBigInteger.INSTANCE) {
                    initReader = objectReader;
                }
            } else if (fieldClass == Date.class && (objectReader = provider.getObjectReader((Type)((Object)Date.class), false)) != ObjectReaderImplDate.INSTANCE) {
                initReader = objectReader;
            }
        }
        return initReader;
    }

    public <T> FieldReader<T> createFieldReader(String fieldName, Field field) {
        return this.createFieldReader(fieldName, null, field.getGenericType(), field);
    }

    public <T> FieldReader createFieldReader(String fieldName, Method method) {
        Type fieldType;
        Class<?> fieldClass;
        Class<?> declaringClass = method.getDeclaringClass();
        Class<?>[] parameterTypes = method.getParameterTypes();
        if (parameterTypes.length == 0) {
            fieldClass = method.getReturnType();
            fieldType = method.getGenericReturnType();
        } else if (parameterTypes.length == 1) {
            fieldClass = parameterTypes[0];
            fieldType = method.getGenericParameterTypes()[0];
        } else {
            throw new JSONException("illegal setter method " + method);
        }
        return this.createFieldReaderMethod(declaringClass, declaringClass, fieldName, 0, 0L, null, null, null, fieldType, fieldClass, method, null);
    }

    final class FieldConsumer
    implements Consumer {
        final Class objectClass;
        final Type objectType;
        final String namingStrategy;
        final FieldInfo fieldInfo;
        final Map<String, FieldReader> fieldReaders;
        final ObjectReaderProvider provider;
        final BeanInfo beanInfo;
        final boolean fieldBased;

        public FieldConsumer(Class objectClass, Type objectType, String namingStrategy, FieldInfo fieldInfo, Map<String, FieldReader> fieldReaders, ObjectReaderProvider provider, BeanInfo beanInfo, boolean fieldBased) {
            this.objectClass = objectClass;
            this.objectType = objectType;
            this.namingStrategy = namingStrategy;
            this.fieldInfo = fieldInfo;
            this.fieldReaders = fieldReaders;
            this.provider = provider;
            this.beanInfo = beanInfo;
            this.fieldBased = fieldBased;
        }

        public void accept(Object o) {
            String[] orders;
            String fieldName;
            Field field = (Field)o;
            this.fieldInfo.init();
            if (this.fieldBased) {
                this.fieldInfo.features |= JSONReader.Feature.FieldBased.mask;
            } else {
                this.fieldInfo.ignore = (field.getModifiers() & 1) == 0;
            }
            this.fieldInfo.features |= this.beanInfo.readerFeatures;
            this.fieldInfo.format = this.beanInfo.format;
            this.provider.getFieldInfo(this.fieldInfo, this.objectClass, field);
            if (this.fieldInfo.ignore) {
                boolean unwrap;
                boolean bl = unwrap = (this.fieldInfo.features & 0x2000000000000L) != 0L && Map.class.isAssignableFrom(field.getType());
                if (!unwrap) {
                    return;
                }
            }
            if (this.fieldInfo.fieldName == null || this.fieldInfo.fieldName.isEmpty()) {
                fieldName = field.getName();
                if (this.namingStrategy != null) {
                    fieldName = BeanUtils.fieldName(fieldName, this.namingStrategy);
                }
            } else {
                fieldName = this.fieldInfo.fieldName;
            }
            if ((orders = this.beanInfo.orders) != null && orders.length > 0) {
                boolean match = false;
                for (int i = 0; i < orders.length; ++i) {
                    if (!fieldName.equals(orders[i])) continue;
                    this.fieldInfo.ordinal = i;
                    match = true;
                    break;
                }
                if (!match && this.fieldInfo.ordinal == 0) {
                    this.fieldInfo.ordinal = orders.length;
                }
            }
            Type fieldType = field.getGenericType();
            Class<?> fieldClass = field.getType();
            ObjectReader initReader = ObjectReaderCreator.getInitReader(this.provider, fieldType, fieldClass, this.fieldInfo);
            FieldReader fieldReader = ObjectReaderCreator.this.createFieldReader(this.objectClass, this.objectType, fieldName, this.fieldInfo.ordinal, this.fieldInfo.features, this.fieldInfo.format, this.fieldInfo.locale, this.fieldInfo.defaultValue, fieldType, fieldClass, field, initReader);
            FieldReader previous = this.fieldReaders.get(fieldName);
            if (previous == null) {
                this.fieldReaders.put(fieldName, fieldReader);
            } else {
                int cmp = fieldReader.compareTo(previous);
                if (cmp > 0) {
                    this.fieldReaders.put(fieldName, fieldReader);
                }
            }
            if (this.fieldInfo.alternateNames != null) {
                for (String alternateName : this.fieldInfo.alternateNames) {
                    if (fieldName.equals(alternateName)) continue;
                    FieldReader fieldReader1 = ObjectReaderCreator.this.createFieldReader(this.objectClass, this.objectType, alternateName, this.fieldInfo.ordinal, this.fieldInfo.features, null, this.fieldInfo.locale, this.fieldInfo.defaultValue, fieldType, fieldClass, field, null);
                    FieldReader alterOrigin = this.fieldReaders.get(alternateName);
                    if (alterOrigin != null) continue;
                    this.fieldReaders.put(alternateName, fieldReader1);
                }
            }
        }
    }

    final class CreateFieldReaderConsumer
    implements Consumer {
        final Class objectClass;
        final Type objectType;
        final String namingStrategy;
        final String[] orders;
        final BeanInfo beanInfo;
        final FieldInfo fieldInfo;
        final Map<String, FieldReader> fieldReaders;
        final ObjectReaderProvider provider;

        CreateFieldReaderConsumer(Class objectClass, Type objectType, String namingStrategy, String[] orders, BeanInfo beanInfo, FieldInfo fieldInfo, Map<String, FieldReader> fieldReaders, ObjectReaderProvider provider) {
            this.objectClass = objectClass;
            this.objectType = objectType;
            this.namingStrategy = namingStrategy;
            this.orders = orders;
            this.beanInfo = beanInfo;
            this.fieldInfo = fieldInfo;
            this.fieldReaders = fieldReaders;
            this.provider = provider;
        }

        public void accept(Object o) {
            Class<?> fieldClass;
            Class<?>[] parameterTypes;
            int parameterCount;
            String fieldName;
            Method method = (Method)o;
            this.fieldInfo.init();
            this.fieldInfo.features |= this.beanInfo.readerFeatures;
            this.fieldInfo.format = this.beanInfo.format;
            this.provider.getFieldInfo(this.fieldInfo, this.objectClass, method);
            if (this.fieldInfo.ignore) {
                return;
            }
            if (this.fieldInfo.fieldName == null) {
                char c1;
                String methodName = method.getName();
                if (methodName.startsWith("set", 0)) {
                    String findName;
                    Field field;
                    fieldName = BeanUtils.setterName(methodName, this.namingStrategy);
                    if (this.fieldInfo.alternateNames == null && (field = BeanUtils.getDeclaredField(this.objectClass, findName = methodName.substring(3))) != null) {
                        this.fieldInfo.alternateNames = new String[]{findName};
                    }
                } else {
                    fieldName = BeanUtils.getterName(method, false, this.namingStrategy);
                }
                char c0 = '\u0000';
                int len = fieldName.length();
                if (len > 0) {
                    c0 = fieldName.charAt(0);
                }
                if (len == 1 && c0 >= 'a' && c0 <= 'z' || len > 2 && c0 >= 'A' && c0 <= 'Z' && (c1 = fieldName.charAt(1)) >= 'A' && c1 <= 'Z') {
                    char[] chars = fieldName.toCharArray();
                    chars[0] = len == 1 ? (char)(chars[0] - 32) : (char)(chars[0] + 32);
                    String fieldName1 = new String(chars);
                    Field field = BeanUtils.getDeclaredField(this.objectClass, fieldName1);
                    if (field != null) {
                        if (Modifier.isPublic(field.getModifiers())) {
                            fieldName = field.getName();
                        } else if (len == 1) {
                            this.fieldInfo.alternateNames = new String[]{fieldName};
                            fieldName = field.getName();
                        }
                    }
                }
            } else {
                fieldName = this.fieldInfo.fieldName;
            }
            if (this.orders != null && this.orders.length > 0) {
                boolean match = false;
                for (int i = 0; i < this.orders.length; ++i) {
                    if (!fieldName.equals(this.orders[i])) continue;
                    this.fieldInfo.ordinal = i;
                    match = true;
                    break;
                }
                if (!match && this.fieldInfo.ordinal == 0) {
                    this.fieldInfo.ordinal = this.orders.length;
                }
            }
            if ((parameterCount = (parameterTypes = method.getParameterTypes()).length) == 0) {
                FieldReader fieldReader = ObjectReaderCreator.this.createFieldReaderMethod(this.objectClass, this.objectType, fieldName, this.fieldInfo.ordinal, this.fieldInfo.features | 0x100000000000000L, this.fieldInfo.format, this.fieldInfo.locale, this.fieldInfo.defaultValue, method.getGenericReturnType(), method.getReturnType(), method, this.fieldInfo.getInitReader());
                FieldReader origin = this.fieldReaders.get(fieldName);
                if (origin == null) {
                    this.fieldReaders.put(fieldName, fieldReader);
                } else if (origin.compareTo(fieldReader) > 0) {
                    this.fieldReaders.put(fieldName, fieldReader);
                }
                return;
            }
            if (parameterCount == 2) {
                fieldClass = parameterTypes[1];
                Type fieldType = method.getGenericParameterTypes()[1];
                method.setAccessible(true);
                FieldReaderAnySetter anySetter = new FieldReaderAnySetter(fieldType, fieldClass, this.fieldInfo.ordinal, this.fieldInfo.features, this.fieldInfo.format, method);
                this.fieldReaders.put(anySetter.fieldName, anySetter);
                return;
            }
            fieldClass = parameterTypes[0];
            Type fieldType = fieldClass.isPrimitive() || fieldClass == String.class || fieldClass.isEnum() ? fieldClass : method.getGenericParameterTypes()[0];
            if (fieldType instanceof Class && Collection.class.isAssignableFrom((Class<?>)fieldType)) {
                Class<?>[] interfaces = this.objectClass.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Type[] genericParameterTypes;
                    Method interfaceMethod = BeanUtils.getMethod(interfaces[i], method);
                    if (interfaceMethod == null || (genericParameterTypes = interfaceMethod.getGenericParameterTypes()).length != 1 || !(genericParameterTypes[0] instanceof ParameterizedType)) continue;
                    fieldType = genericParameterTypes[0];
                }
            }
            ObjectReader initReader = ObjectReaderCreator.getInitReader(this.provider, fieldType, fieldClass, this.fieldInfo);
            FieldReader fieldReader = null;
            fieldReader = ObjectReaderCreator.this.createFieldReaderMethod(this.objectClass, this.objectType, fieldName, this.fieldInfo.ordinal, this.fieldInfo.features, this.fieldInfo.format, this.fieldInfo.locale, this.fieldInfo.defaultValue, fieldType, fieldClass, method, initReader);
            FieldReader origin = this.fieldReaders.get(fieldName);
            if (origin == null) {
                this.fieldReaders.put(fieldName, fieldReader);
            } else if (origin.compareTo(fieldReader) > 0) {
                this.fieldReaders.put(fieldName, fieldReader);
            }
            if (this.fieldInfo.alternateNames != null) {
                for (String alternateName : this.fieldInfo.alternateNames) {
                    FieldReader alterOrigin;
                    if (fieldName.equals(alternateName) || (alterOrigin = this.fieldReaders.get(alternateName)) != null) continue;
                    this.fieldReaders.put(alternateName, ObjectReaderCreator.this.createFieldReaderMethod(this.objectClass, this.objectType, alternateName, this.fieldInfo.ordinal, this.fieldInfo.features, this.fieldInfo.format, this.fieldInfo.locale, this.fieldInfo.defaultValue, fieldType, fieldClass, method, initReader));
                }
            }
        }
    }
}

