/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.PropertyNamingStrategy;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.filter.Filter;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.FieldWriterObject;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterArray;
import com.alibaba.fastjson2.writer.ObjectWriterArrayFinal;
import com.alibaba.fastjson2.writer.ObjectWriterBigInteger;
import com.alibaba.fastjson2.writer.ObjectWriterCreator;
import com.alibaba.fastjson2.writer.ObjectWriterImpDecimalArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicBoolean;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicInteger;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicIntegerArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicLong;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicLongArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplAtomicReference;
import com.alibaba.fastjson2.writer.ObjectWriterImplBigDecimal;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplBoolean;
import com.alibaba.fastjson2.writer.ObjectWriterImplCalendar;
import com.alibaba.fastjson2.writer.ObjectWriterImplCharValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplCharacter;
import com.alibaba.fastjson2.writer.ObjectWriterImplClass;
import com.alibaba.fastjson2.writer.ObjectWriterImplCollection;
import com.alibaba.fastjson2.writer.ObjectWriterImplCurrency;
import com.alibaba.fastjson2.writer.ObjectWriterImplDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplDouble;
import com.alibaba.fastjson2.writer.ObjectWriterImplDoubleValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplEnum;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloat;
import com.alibaba.fastjson2.writer.ObjectWriterImplFloatValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInstant;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt16;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt16ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt32ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt64ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8Array;
import com.alibaba.fastjson2.writer.ObjectWriterImplInt8ValueArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplList;
import com.alibaba.fastjson2.writer.ObjectWriterImplListStr;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDate;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocalTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplLocale;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterImplOffsetDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplOffsetTime;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptional;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalDouble;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalInt;
import com.alibaba.fastjson2.writer.ObjectWriterImplOptionalLong;
import com.alibaba.fastjson2.writer.ObjectWriterImplString;
import com.alibaba.fastjson2.writer.ObjectWriterImplStringArray;
import com.alibaba.fastjson2.writer.ObjectWriterImplTimeZone;
import com.alibaba.fastjson2.writer.ObjectWriterImplToString;
import com.alibaba.fastjson2.writer.ObjectWriterImplUUID;
import com.alibaba.fastjson2.writer.ObjectWriterImplZonedDateTime;
import com.alibaba.fastjson2.writer.ObjectWriterMisc;
import com.alibaba.fastjson2.writer.ObjectWriters;
import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.sql.Clob;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.TimeZone;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

public class ObjectWriterProvider {
    static final int TYPE_INT32_MASK = 2;
    static final int TYPE_INT64_MASK = 4;
    static final int TYPE_DECIMAL_MASK = 8;
    static final int TYPE_DATE_MASK = 16;
    static final int TYPE_ENUM_MASK = 32;
    static ObjectWriterAdapter STACK_TRACE_ELEMENT_WRITER;
    final ConcurrentMap<Type, ObjectWriter> cache = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Type, ObjectWriter> cacheFieldBased = new ConcurrentHashMap<Type, ObjectWriter>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final ObjectWriterCreator creator;
    final PropertyNamingStrategy namingStrategy;
    volatile long userDefineMask;
    static final int ENUM = 16384;
    static final int[] PRIMITIVE_HASH_CODES;
    static final int[] NOT_REFERENCES_TYPE_HASH_CODES;

    public ObjectWriterProvider() {
        this((PropertyNamingStrategy)null);
    }

    public ObjectWriterProvider(PropertyNamingStrategy namingStrategy) {
        this.namingStrategy = namingStrategy;
        this.creator = ObjectWriterCreator.INSTANCE;
    }

    public ObjectWriterProvider(ObjectWriterCreator creator) {
        this.creator = creator;
        this.namingStrategy = null;
    }

    public void mixIn(Class target, Class mixinSource) {
        if (mixinSource == null) {
            this.mixInCache.remove(target);
        } else {
            this.mixInCache.put(target, mixinSource);
        }
        this.cache.remove(target);
    }

    public void cleanupMixIn() {
        this.mixInCache.clear();
    }

    public ObjectWriter register(Type type, ObjectWriter objectWriter) {
        return this.register(type, objectWriter, false);
    }

    public ObjectWriter register(Type type, ObjectWriter objectWriter, boolean fieldBased) {
        if (type == Integer.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplInt32.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFFDL) : (this.userDefineMask |= 2L);
        } else if (type == Long.class || type == Long.TYPE) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplInt64.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFFBL) : (this.userDefineMask |= 4L);
        } else if (type == BigDecimal.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplBigDecimal.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFF7L) : (this.userDefineMask |= 8L);
        } else if (type == Date.class) {
            this.userDefineMask = objectWriter == null || objectWriter == ObjectWriterImplDate.INSTANCE ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFEFL) : (this.userDefineMask |= 0x10L);
        } else if (type == Enum.class) {
            this.userDefineMask = objectWriter == null ? (this.userDefineMask &= 0xFFFFFFFFFFFFFFDFL) : (this.userDefineMask |= 0x20L);
        }
        if (objectWriter == null) {
            if (fieldBased) {
                return (ObjectWriter)this.cacheFieldBased.remove(type);
            }
            return (ObjectWriter)this.cache.remove(type);
        }
        if (fieldBased) {
            return this.cacheFieldBased.put(type, objectWriter);
        }
        return this.cache.put(type, objectWriter);
    }

    public ObjectWriter registerIfAbsent(Type type, ObjectWriter objectWriter) {
        ObjectWriter origin = (ObjectWriter)this.cache.get(type);
        if (origin == null) {
            this.cache.put(type, objectWriter);
        }
        return origin;
    }

    public ObjectWriter unregister(Type type) {
        return (ObjectWriter)this.cache.remove(type);
    }

    public boolean unregister(Type type, ObjectWriter objectWriter) {
        return this.cache.remove(type, objectWriter);
    }

    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public ObjectWriter getObjectWriter(Class objectClass) {
        return this.getObjectWriter(objectClass, objectClass, false);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass) {
        return this.getObjectWriter(objectType, objectClass, false);
    }

    public ObjectWriter getObjectWriter(Type objectType) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        return this.getObjectWriter(objectType, objectClass, false);
    }

    public ObjectWriter getObjectWriterFromCache(Type objectType, Class objectClass, boolean fieldBased) {
        return fieldBased ? (ObjectWriter)this.cacheFieldBased.get(objectType) : (ObjectWriter)this.cache.get(objectType);
    }

    public ObjectWriter getObjectWriter(Type objectType, Class objectClass, boolean fieldBased) {
        String className;
        ObjectWriter objectWriter;
        Class superclass = objectClass.getSuperclass();
        if (!objectClass.isEnum() && superclass != null && superclass.isEnum()) {
            return this.getObjectWriter(superclass, superclass, fieldBased);
        }
        if (fieldBased && superclass != null && superclass != Object.class && superclass.getName().equals("com.google.protobuf.GeneratedMessageV3")) {
            fieldBased = false;
        }
        ObjectWriter objectWriter2 = objectWriter = fieldBased ? (ObjectWriter)this.cacheFieldBased.get(objectType) : (ObjectWriter)this.cache.get(objectType);
        if (objectWriter != null) {
            return objectWriter;
        }
        boolean useModules = true;
        if (fieldBased && Iterable.class.isAssignableFrom(objectClass) && !Collection.class.isAssignableFrom(objectClass)) {
            useModules = false;
        }
        if (useModules && (objectWriter = this.getObjectWriterModule(objectType, objectClass)) != null) {
            ObjectWriter previous;
            ObjectWriter objectWriter3 = previous = fieldBased ? this.cacheFieldBased.put(objectType, objectWriter) : this.cache.put(objectType, objectWriter);
            if (previous != null) {
                objectWriter = previous;
            }
            return objectWriter;
        }
        switch (className = objectClass.getName()) {
            case "com.alibaba.fastjson.JSONObject": {
                objectWriter = ObjectWriterImplMap.of(objectClass);
                break;
            }
            case "android.net.Uri$OpaqueUri": 
            case "android.net.Uri$HierarchicalUri": 
            case "android.net.Uri$StringUri": {
                objectWriter = ObjectWriterImplToString.INSTANCE;
                break;
            }
        }
        if (objectWriter == null) {
            ObjectWriter previous;
            objectWriter = this.creator.createObjectWriter(objectClass, fieldBased ? JSONWriter.Feature.FieldBased.mask : 0L, this);
            ObjectWriter objectWriter4 = previous = fieldBased ? this.cacheFieldBased.put(objectType, objectWriter) : this.cache.put(objectType, objectWriter);
            if (previous != null) {
                objectWriter = previous;
            }
        }
        return objectWriter;
    }

    public static boolean isPrimitiveOrEnum(Class<?> clazz) {
        return Arrays.binarySearch(PRIMITIVE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    public static boolean isNotReferenceDetect(Class<?> clazz) {
        return Arrays.binarySearch(NOT_REFERENCES_TYPE_HASH_CODES, System.identityHashCode(clazz)) >= 0 || (clazz.getModifiers() & 0x4000) != 0 && clazz.getSuperclass() == Enum.class;
    }

    public void cleanup(Class objectClass) {
        this.mixInCache.remove(objectClass);
        this.cache.remove(objectClass);
        this.cacheFieldBased.remove(objectClass);
        BeanUtils.cleanupCache(objectClass);
    }

    static boolean match(Type objectType, ObjectWriter objectWriter, ClassLoader classLoader, IdentityHashMap<ObjectWriter, Object> checkedMap) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        if (objectClass != null && objectClass.getClassLoader() == classLoader) {
            return true;
        }
        if (checkedMap.containsKey(objectWriter)) {
            return false;
        }
        if (objectWriter instanceof ObjectWriterImplMap) {
            ObjectWriterImplMap mapTyped = (ObjectWriterImplMap)objectWriter;
            Class<?> valueClass = TypeUtils.getClass(mapTyped.valueType);
            if (valueClass != null && valueClass.getClassLoader() == classLoader) {
                return true;
            }
            Class<?> keyClass = TypeUtils.getClass(mapTyped.keyType);
            return keyClass != null && keyClass.getClassLoader() == classLoader;
        }
        if (objectWriter instanceof ObjectWriterImplCollection) {
            Class<?> itemClass = TypeUtils.getClass(((ObjectWriterImplCollection)objectWriter).itemType);
            return itemClass != null && itemClass.getClassLoader() == classLoader;
        }
        if (objectWriter instanceof ObjectWriterAdapter) {
            checkedMap.put(objectWriter, null);
            List<FieldWriter> fieldWriters = ((ObjectWriterAdapter)objectWriter).fieldWriters;
            for (int i = 0; i < fieldWriters.size(); ++i) {
                ObjectWriter initObjectWriter;
                FieldWriter fieldWriter = fieldWriters.get(i);
                if (!(fieldWriter instanceof FieldWriterObject) || !ObjectWriterProvider.match(null, initObjectWriter = ((FieldWriterObject)fieldWriter).initObjectWriter, classLoader, checkedMap)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanup(ClassLoader classLoader) {
        Map.Entry entry;
        Iterator it = this.mixInCache.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry2 = it.next();
            if (((Class)entry2.getKey()).getClassLoader() != classLoader) continue;
            it.remove();
        }
        IdentityHashMap<ObjectWriter, Object> checkedMap = new IdentityHashMap<ObjectWriter, Object>();
        Iterator it2 = this.cache.entrySet().iterator();
        while (it2.hasNext()) {
            entry = it2.next();
            if (!ObjectWriterProvider.match((Type)entry.getKey(), (ObjectWriter)entry.getValue(), classLoader, checkedMap)) continue;
            it2.remove();
        }
        it2 = this.cacheFieldBased.entrySet().iterator();
        while (it2.hasNext()) {
            entry = it2.next();
            if (!ObjectWriterProvider.match((Type)entry.getKey(), (ObjectWriter)entry.getValue(), classLoader, checkedMap)) continue;
            it2.remove();
        }
        BeanUtils.cleanupCache(classLoader);
    }

    public void getBeanInfo(BeanInfo beanInfo, Class objectClass) {
        Class mixInSource;
        Class superclass;
        if (this.namingStrategy != null && this.namingStrategy != PropertyNamingStrategy.NeverUseThisValueExceptDefaultValue) {
            beanInfo.namingStrategy = this.namingStrategy.name();
        }
        if (objectClass != null && (superclass = objectClass.getSuperclass()) != Object.class && superclass != null && superclass != Enum.class) {
            this.getBeanInfo(beanInfo, superclass);
            if (beanInfo.seeAlso != null && beanInfo.seeAlsoNames != null) {
                for (int i = 0; i < beanInfo.seeAlso.length; ++i) {
                    String seeAlsoName;
                    Class seeAlso = beanInfo.seeAlso[i];
                    if (seeAlso != objectClass || i >= beanInfo.seeAlsoNames.length || (seeAlsoName = beanInfo.seeAlsoNames[i]) == null || seeAlsoName.length() == 0) continue;
                    beanInfo.typeName = seeAlsoName;
                    break;
                }
            }
        }
        Annotation jsonType1x = null;
        JSONType jsonType = null;
        Annotation[] annotations = objectClass.getDeclaredAnnotations();
        block9: for (int i = 0; i < annotations.length; ++i) {
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            jsonType = BeanUtils.findAnnotation(annotation, JSONType.class);
            if (jsonType == annotation) continue;
            switch (annotationType.getName()) {
                case "com.alibaba.fastjson.annotation.JSONType": {
                    jsonType1x = annotation;
                    continue block9;
                }
                case "kotlin.Metadata": {
                    beanInfo.kotlin = true;
                    BeanUtils.getKotlinConstructor(objectClass, beanInfo);
                    beanInfo.createParameterNames = BeanUtils.getKotlinConstructorParameters(objectClass);
                    continue block9;
                }
            }
        }
        if (jsonType == null && (mixInSource = (Class)this.mixInCache.get(objectClass)) != null) {
            beanInfo.mixIn = true;
            Annotation[] mixInAnnotations = mixInSource.getDeclaredAnnotations();
            for (int i = 0; i < mixInAnnotations.length; ++i) {
                String annotationTypeName;
                Annotation annotation = mixInAnnotations[i];
                Class<? extends Annotation> annotationType = annotation.annotationType();
                jsonType = BeanUtils.findAnnotation(annotation, JSONType.class);
                if (jsonType == annotation || !(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONType")) continue;
                jsonType1x = annotation;
            }
        }
        if (jsonType != null) {
            String[] parts;
            String locale;
            String format;
            Class<? extends Filter>[] serializeFilters;
            Class<?> serializer;
            String[] orders;
            String[] includes;
            String typeName;
            String typeKey;
            Class<?>[] classes = jsonType.seeAlso();
            if (classes.length != 0) {
                beanInfo.seeAlso = classes;
            }
            if (!(typeKey = jsonType.typeKey()).isEmpty()) {
                beanInfo.typeKey = typeKey;
            }
            if (!(typeName = jsonType.typeName()).isEmpty()) {
                beanInfo.typeName = typeName;
            }
            JSONWriter.Feature[] serializeFeatures = jsonType.serializeFeatures();
            for (int i = 0; i < serializeFeatures.length; ++i) {
                JSONWriter.Feature feature = serializeFeatures[i];
                beanInfo.writerFeatures |= feature.mask;
            }
            beanInfo.namingStrategy = jsonType.naming().name();
            String[] ignores = jsonType.ignores();
            if (ignores.length > 0) {
                beanInfo.ignores = ignores;
            }
            if ((includes = jsonType.includes()).length > 0) {
                beanInfo.includes = includes;
            }
            if ((orders = jsonType.orders()).length > 0) {
                beanInfo.orders = orders;
            }
            if (ObjectWriter.class.isAssignableFrom(serializer = jsonType.serializer())) {
                beanInfo.serializer = serializer;
                beanInfo.writeEnumAsJavaBean = true;
            }
            if ((serializeFilters = jsonType.serializeFilters()).length != 0) {
                beanInfo.serializeFilters = serializeFilters;
            }
            if (!(format = jsonType.format()).isEmpty()) {
                beanInfo.format = format;
            }
            if (!(locale = jsonType.locale()).isEmpty() && (parts = locale.split("_")).length == 2) {
                beanInfo.locale = new Locale(parts[0], parts[1]);
            }
            if (!jsonType.alphabetic()) {
                beanInfo.alphabetic = false;
            }
            if (jsonType.writeEnumAsJavaBean()) {
                beanInfo.writeEnumAsJavaBean = true;
            }
        } else if (jsonType1x != null) {
            Annotation annotation = jsonType1x;
            BeanUtils.annotationMethods(jsonType1x.annotationType(), method -> BeanUtils.processJSONType1x(beanInfo, annotation, method));
        }
        if (beanInfo.seeAlso != null && beanInfo.seeAlso.length != 0 && (beanInfo.typeName == null || beanInfo.typeName.length() == 0)) {
            for (Class seeAlsoClass : beanInfo.seeAlso) {
                if (seeAlsoClass != objectClass) continue;
                beanInfo.typeName = objectClass.getSimpleName();
                break;
            }
        }
    }

    public void getFieldInfo(BeanInfo beanInfo, FieldInfo fieldInfo, Class objectClass, Field field) {
        Class serializeUsing;
        int modifiers;
        boolean isTransient;
        Class fieldClassMixInSource;
        Class mixInSource;
        if (objectClass != null && (mixInSource = (Class)this.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
            Field mixInField = null;
            try {
                mixInField = mixInSource.getDeclaredField(field.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mixInField != null) {
                this.getFieldInfo(beanInfo, fieldInfo, mixInSource, mixInField);
            }
        }
        if ((fieldClassMixInSource = (Class)this.mixInCache.get(field.getType())) != null) {
            fieldInfo.fieldClassMixIn = true;
        }
        if (isTransient = Modifier.isTransient(modifiers = field.getModifiers())) {
            fieldInfo.ignore = true;
        }
        JSONField jsonField = null;
        Annotation[] annotations = field.getDeclaredAnnotations();
        for (int i = 0; i < annotations.length; ++i) {
            String annotationTypeName;
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            if (jsonField == null && (jsonField = BeanUtils.findAnnotation(annotation, JSONField.class)) == annotation || !(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONField")) continue;
            this.processJSONField1x(fieldInfo, annotation);
        }
        if (jsonField == null) {
            return;
        }
        this.loadFieldInfo(fieldInfo, jsonField);
        Class writeUsing = jsonField.writeUsing();
        if (ObjectWriter.class.isAssignableFrom(writeUsing)) {
            fieldInfo.writeUsing = writeUsing;
        }
        if (ObjectWriter.class.isAssignableFrom(serializeUsing = jsonField.serializeUsing())) {
            fieldInfo.writeUsing = serializeUsing;
        }
        if (jsonField.jsonDirect()) {
            fieldInfo.features |= 0x4000000000000L;
        }
        if ((fieldInfo.features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L && !String.class.equals(field.getType()) && fieldInfo.writeUsing == null) {
            fieldInfo.writeUsing = ObjectWriterImplToString.class;
        }
    }

    private void processJSONField1x(FieldInfo fieldInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "name": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        fieldInfo.fieldName = value;
                        break;
                    }
                    case "format": {
                        this.loadJsonFieldFormat(fieldInfo, (String)result);
                        break;
                    }
                    case "label": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        fieldInfo.label = value;
                        break;
                    }
                    case "defaultValue": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        fieldInfo.defaultValue = value;
                        break;
                    }
                    case "ordinal": {
                        Integer ordinal = (Integer)result;
                        if (ordinal == 0) break;
                        fieldInfo.ordinal = ordinal;
                        break;
                    }
                    case "serialize": {
                        Boolean serialize = (Boolean)result;
                        if (serialize.booleanValue()) break;
                        fieldInfo.ignore = true;
                        break;
                    }
                    case "unwrapped": {
                        Boolean unwrapped = (Boolean)result;
                        if (!unwrapped.booleanValue()) break;
                        fieldInfo.features |= 0x2000000000000L;
                        break;
                    }
                    case "serialzeFeatures": {
                        Enum[] features = (Enum[])result;
                        this.applyFeatures(fieldInfo, features);
                        break;
                    }
                    case "serializeUsing": {
                        Class writeUsing = (Class)result;
                        if (!ObjectWriter.class.isAssignableFrom(writeUsing)) break;
                        fieldInfo.writeUsing = writeUsing;
                        break;
                    }
                    case "jsonDirect": {
                        Boolean jsonDirect = (Boolean)result;
                        if (!jsonDirect.booleanValue()) break;
                        fieldInfo.features |= 0x4000000000000L;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void applyFeatures(FieldInfo fieldInfo, Enum[] features) {
        block30: for (int i = 0; i < features.length; ++i) {
            Enum feature = features[i];
            switch (feature.name()) {
                case "UseISO8601DateFormat": {
                    fieldInfo.format = "iso8601";
                    continue block30;
                }
                case "WriteMapNullValue": {
                    fieldInfo.features |= JSONWriter.Feature.WriteNulls.mask;
                    continue block30;
                }
                case "WriteNullListAsEmpty": {
                    fieldInfo.features |= JSONWriter.Feature.WriteNullListAsEmpty.mask;
                    continue block30;
                }
                case "WriteNullStringAsEmpty": {
                    fieldInfo.features |= JSONWriter.Feature.WriteNullStringAsEmpty.mask;
                    continue block30;
                }
                case "WriteNullNumberAsZero": {
                    fieldInfo.features |= JSONWriter.Feature.WriteNullNumberAsZero.mask;
                    continue block30;
                }
                case "WriteNullBooleanAsFalse": {
                    fieldInfo.features |= JSONWriter.Feature.WriteNullBooleanAsFalse.mask;
                    continue block30;
                }
                case "BrowserCompatible": {
                    fieldInfo.features |= JSONWriter.Feature.BrowserCompatible.mask;
                    continue block30;
                }
                case "WriteClassName": {
                    fieldInfo.features |= JSONWriter.Feature.WriteClassName.mask;
                    continue block30;
                }
                case "WriteNonStringValueAsString": {
                    fieldInfo.features |= JSONWriter.Feature.WriteNonStringValueAsString.mask;
                    continue block30;
                }
                case "WriteEnumUsingToString": {
                    fieldInfo.features |= JSONWriter.Feature.WriteEnumUsingToString.mask;
                    continue block30;
                }
                case "NotWriteRootClassName": {
                    fieldInfo.features |= JSONWriter.Feature.NotWriteRootClassName.mask;
                    continue block30;
                }
                case "IgnoreErrorGetter": {
                    fieldInfo.features |= JSONWriter.Feature.IgnoreErrorGetter.mask;
                    continue block30;
                }
                case "WriteBigDecimalAsPlain": {
                    fieldInfo.features |= JSONWriter.Feature.WriteBigDecimalAsPlain.mask;
                    continue block30;
                }
            }
        }
    }

    public void getFieldInfo(BeanInfo beanInfo, FieldInfo fieldInfo, Class objectClass, Method method) {
        Field methodField;
        Class fieldClassMixInSource;
        Class mixInSource = (Class)this.mixInCache.get(objectClass);
        String methodName = method.getName();
        if (mixInSource != null && mixInSource != objectClass) {
            Method mixInMethod = null;
            try {
                mixInMethod = mixInSource.getDeclaredMethod(methodName, method.getParameterTypes());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mixInMethod != null) {
                this.getFieldInfo(beanInfo, fieldInfo, mixInSource, mixInMethod);
            }
        }
        if ((fieldClassMixInSource = (Class)this.mixInCache.get(method.getReturnType())) != null) {
            fieldInfo.fieldClassMixIn = true;
        }
        if (objectClass != null) {
            Class superclass = objectClass.getSuperclass();
            Method supperMethod = BeanUtils.getMethod(superclass, method);
            if (supperMethod != null) {
                this.getFieldInfo(beanInfo, fieldInfo, superclass, supperMethod);
            }
            Class<?>[] interfaces = objectClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method interfaceMethod = BeanUtils.getMethod(interfaces[i], method);
                if (interfaceMethod == null) continue;
                this.getFieldInfo(beanInfo, fieldInfo, superclass, interfaceMethod);
            }
        }
        Annotation[] annotations = method.getDeclaredAnnotations();
        this.processAnnotations(fieldInfo, annotations);
        if (!objectClass.getName().startsWith("java.lang", 0) && (methodField = BeanUtils.getField(objectClass, method)) != null) {
            fieldInfo.features |= 0x10000000000000L;
            this.getFieldInfo(beanInfo, fieldInfo, objectClass, methodField);
        }
        if (beanInfo.kotlin && beanInfo.creatorConstructor != null && beanInfo.createParameterNames != null) {
            String fieldName = BeanUtils.getterName(method, beanInfo.kotlin, null);
            for (int i = 0; i < beanInfo.createParameterNames.length; ++i) {
                Annotation[][] creatorConsParamAnnotations;
                if (!fieldName.equals(beanInfo.createParameterNames[i]) || i >= (creatorConsParamAnnotations = beanInfo.creatorConstructor.getParameterAnnotations()).length) continue;
                Annotation[] parameterAnnotations = creatorConsParamAnnotations[i];
                this.processAnnotations(fieldInfo, parameterAnnotations);
                break;
            }
        }
    }

    private void processAnnotations(FieldInfo fieldInfo, Annotation[] annotations) {
        block8: for (int i = 0; i < annotations.length; ++i) {
            String annotationTypeName;
            Annotation annotation = annotations[i];
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONField jsonField = BeanUtils.findAnnotation(annotation, JSONField.class);
            if (jsonField != null) {
                this.loadFieldInfo(fieldInfo, jsonField);
                continue;
            }
            switch (annotationTypeName = annotationType.getName()) {
                case "com.alibaba.fastjson.annotation.JSONField": {
                    this.processJSONField1x(fieldInfo, annotation);
                    continue block8;
                }
                case "java.beans.Transient": {
                    fieldInfo.ignore = true;
                    fieldInfo.isTransient = true;
                    continue block8;
                }
            }
        }
    }

    private void loadFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
        Class serializeUsing;
        String defaultValue;
        String jsonFieldName = jsonField.name();
        if (!jsonFieldName.isEmpty()) {
            fieldInfo.fieldName = jsonFieldName;
        }
        if (!(defaultValue = jsonField.defaultValue()).isEmpty()) {
            fieldInfo.defaultValue = defaultValue;
        }
        this.loadJsonFieldFormat(fieldInfo, jsonField.format());
        String label = jsonField.label();
        if (!label.isEmpty()) {
            fieldInfo.label = label;
        }
        if (!fieldInfo.ignore) {
            boolean bl = fieldInfo.ignore = !jsonField.serialize();
        }
        if (jsonField.unwrapped()) {
            fieldInfo.features |= 0x2000000000000L;
        }
        JSONWriter.Feature[] serializeFeatures = jsonField.serializeFeatures();
        for (int i = 0; i < serializeFeatures.length; ++i) {
            JSONWriter.Feature feature = serializeFeatures[i];
            fieldInfo.features |= feature.mask;
        }
        int ordinal = jsonField.ordinal();
        if (ordinal != 0) {
            fieldInfo.ordinal = ordinal;
        }
        if (jsonField.value()) {
            fieldInfo.features |= 0x1000000000000L;
        }
        if (jsonField.jsonDirect()) {
            fieldInfo.features |= 0x4000000000000L;
        }
        if (ObjectWriter.class.isAssignableFrom(serializeUsing = jsonField.serializeUsing())) {
            fieldInfo.writeUsing = serializeUsing;
        }
    }

    private void loadJsonFieldFormat(FieldInfo fieldInfo, String jsonFieldFormat) {
        if (!jsonFieldFormat.isEmpty()) {
            if ((jsonFieldFormat = jsonFieldFormat.trim()).indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
            }
            if (!jsonFieldFormat.isEmpty()) {
                fieldInfo.format = jsonFieldFormat;
            }
        }
    }

    ObjectWriter getExternalObjectWriter(String className, Class objectClass) {
        switch (className) {
            case "java.sql.Time": {
                return JdbcSupport.TimeWriter.of(null);
            }
            case "java.sql.Timestamp": {
                return new JdbcSupport.TimestampWriter(null);
            }
        }
        if (Clob.class.isAssignableFrom(objectClass)) {
            return new JdbcSupport.ClobWriter();
        }
        return null;
    }

    public ObjectWriter getObjectWriterModule(Type objectType, Class objectClass) {
        String className;
        ObjectWriter externalObjectWriter;
        if (objectType == String.class) {
            return ObjectWriterImplString.INSTANCE;
        }
        if (objectClass == null) {
            objectClass = objectType instanceof Class ? (Class)objectType : TypeUtils.getMapping(objectType);
        }
        if ((externalObjectWriter = this.getExternalObjectWriter(className = objectClass.getName(), objectClass)) != null) {
            return externalObjectWriter;
        }
        switch (className) {
            case "net.sf.json.JSONNull": 
            case "java.net.Inet4Address": 
            case "java.net.Inet6Address": 
            case "java.net.InetSocketAddress": 
            case "java.text.SimpleDateFormat": 
            case "java.util.regex.Pattern": {
                return ObjectWriterMisc.INSTANCE;
            }
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (rawType == List.class || rawType == ArrayList.class) {
                if (actualTypeArguments.length == 1 && actualTypeArguments[0] == String.class) {
                    return ObjectWriterImplListStr.INSTANCE;
                }
                objectType = rawType;
            }
            if (Map.class.isAssignableFrom(objectClass)) {
                return ObjectWriterImplMap.of(objectType, objectClass);
            }
        }
        if (objectType == LinkedList.class) {
            return ObjectWriterImplList.INSTANCE;
        }
        if (objectType == ArrayList.class || objectType == List.class || List.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplList.INSTANCE;
        }
        if (Collection.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplCollection.INSTANCE;
        }
        if (Map.class.isAssignableFrom(objectClass)) {
            return ObjectWriterImplMap.of(objectClass);
        }
        if (objectType == Integer.class) {
            return ObjectWriterImplInt32.INSTANCE;
        }
        if (objectType == AtomicInteger.class) {
            return ObjectWriterImplAtomicInteger.INSTANCE;
        }
        if (objectType == Byte.class) {
            return ObjectWriterImplInt8.INSTANCE;
        }
        if (objectType == Short.class) {
            return ObjectWriterImplInt16.INSTANCE;
        }
        if (objectType == Long.class) {
            return ObjectWriterImplInt64.INSTANCE;
        }
        if (objectType == AtomicLong.class) {
            return ObjectWriterImplAtomicLong.INSTANCE;
        }
        if (objectType == AtomicReference.class) {
            return ObjectWriterImplAtomicReference.INSTANCE;
        }
        if (objectType == Float.class) {
            return ObjectWriterImplFloat.INSTANCE;
        }
        if (objectType == Double.class) {
            return ObjectWriterImplDouble.INSTANCE;
        }
        if (objectType == BigInteger.class) {
            return ObjectWriterBigInteger.INSTANCE;
        }
        if (objectType == BigDecimal.class) {
            return ObjectWriterImplBigDecimal.INSTANCE;
        }
        if (objectType == OptionalInt.class) {
            return ObjectWriterImplOptionalInt.INSTANCE;
        }
        if (objectType == OptionalLong.class) {
            return ObjectWriterImplOptionalLong.INSTANCE;
        }
        if (objectType == OptionalDouble.class) {
            return ObjectWriterImplOptionalDouble.INSTANCE;
        }
        if (objectType == Optional.class) {
            return ObjectWriterImplOptional.INSTANCE;
        }
        if (objectType == Boolean.class) {
            return ObjectWriterImplBoolean.INSTANCE;
        }
        if (objectType == AtomicBoolean.class) {
            return ObjectWriterImplAtomicBoolean.INSTANCE;
        }
        if (objectType == AtomicIntegerArray.class) {
            return ObjectWriterImplAtomicIntegerArray.INSTANCE;
        }
        if (objectType == AtomicLongArray.class) {
            return ObjectWriterImplAtomicLongArray.INSTANCE;
        }
        if (objectType == Character.class) {
            return ObjectWriterImplCharacter.INSTANCE;
        }
        if (objectType instanceof Class) {
            ObjectWriter enumWriter;
            Class clazz = (Class)objectType;
            if (TimeUnit.class.isAssignableFrom(clazz)) {
                return new ObjectWriterImplEnum(null, TimeUnit.class, null, null, 0L);
            }
            if (Enum.class.isAssignableFrom(clazz) && (enumWriter = this.createEnumWriter(clazz)) != null) {
                return enumWriter;
            }
            if (JSONPath.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplToString.INSTANCE;
            }
            if (clazz == boolean[].class) {
                return ObjectWriterImplBoolValueArray.INSTANCE;
            }
            if (clazz == char[].class) {
                return ObjectWriterImplCharValueArray.INSTANCE;
            }
            if (clazz == StringBuffer.class || clazz == StringBuilder.class) {
                return ObjectWriterImplToString.INSTANCE;
            }
            if (clazz == byte[].class) {
                return ObjectWriterImplInt8ValueArray.INSTANCE;
            }
            if (clazz == short[].class) {
                return ObjectWriterImplInt16ValueArray.INSTANCE;
            }
            if (clazz == int[].class) {
                return ObjectWriterImplInt32ValueArray.INSTANCE;
            }
            if (clazz == long[].class) {
                return ObjectWriterImplInt64ValueArray.INSTANCE;
            }
            if (clazz == float[].class) {
                return ObjectWriterImplFloatValueArray.INSTANCE;
            }
            if (clazz == double[].class) {
                return ObjectWriterImplDoubleValueArray.INSTANCE;
            }
            if (clazz == Byte[].class) {
                return ObjectWriterImplInt8Array.INSTANCE;
            }
            if (clazz == Integer[].class) {
                return ObjectWriterImplInt32Array.INSTANCE;
            }
            if (clazz == Long[].class) {
                return ObjectWriterImplInt64Array.INSTANCE;
            }
            if (String[].class == clazz) {
                return ObjectWriterImplStringArray.INSTANCE;
            }
            if (BigDecimal[].class == clazz) {
                return ObjectWriterImpDecimalArray.INSTANCE;
            }
            if (Object[].class.isAssignableFrom(clazz)) {
                if (clazz == Object[].class) {
                    return ObjectWriterArray.INSTANCE;
                }
                Class<?> componentType = clazz.getComponentType();
                if (Modifier.isFinal(componentType.getModifiers())) {
                    return new ObjectWriterArrayFinal(componentType, null);
                }
                return new ObjectWriterArray(componentType);
            }
            if (clazz == UUID.class) {
                return ObjectWriterImplUUID.INSTANCE;
            }
            if (clazz == Locale.class) {
                return ObjectWriterImplLocale.INSTANCE;
            }
            if (clazz == Currency.class) {
                return ObjectWriterImplCurrency.INSTANCE;
            }
            if (TimeZone.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplTimeZone.INSTANCE;
            }
            if (clazz == URI.class || clazz == URL.class || clazz == File.class || ZoneId.class.isAssignableFrom(clazz) || Charset.class.isAssignableFrom(clazz)) {
                return ObjectWriterImplToString.INSTANCE;
            }
            externalObjectWriter = this.getExternalObjectWriter(clazz.getName(), clazz);
            if (externalObjectWriter != null) {
                return externalObjectWriter;
            }
            BeanInfo beanInfo = new BeanInfo();
            Class mixIn = this.getMixIn(clazz);
            if (mixIn != null) {
                this.getBeanInfo(beanInfo, mixIn);
            }
            if (Date.class.isAssignableFrom(clazz)) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplDate(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplDate.INSTANCE;
            }
            if (Calendar.class.isAssignableFrom(clazz)) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplCalendar(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplCalendar.INSTANCE;
            }
            if (ZonedDateTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplZonedDateTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplZonedDateTime.INSTANCE;
            }
            if (OffsetDateTime.class == clazz) {
                return ObjectWriterImplOffsetDateTime.of(beanInfo.format, beanInfo.locale);
            }
            if (LocalDateTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplLocalDateTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplLocalDateTime.INSTANCE;
            }
            if (LocalDate.class == clazz) {
                return ObjectWriterImplLocalDate.of(beanInfo.format, beanInfo.locale);
            }
            if (LocalTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplLocalTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplLocalTime.INSTANCE;
            }
            if (OffsetTime.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplOffsetTime(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplOffsetTime.INSTANCE;
            }
            if (Instant.class == clazz) {
                if (beanInfo.format != null || beanInfo.locale != null) {
                    return new ObjectWriterImplInstant(beanInfo.format, beanInfo.locale);
                }
                return ObjectWriterImplInstant.INSTANCE;
            }
            if (Duration.class == clazz) {
                return ObjectWriterImplToString.INSTANCE;
            }
            if (StackTraceElement.class == clazz) {
                if (STACK_TRACE_ELEMENT_WRITER == null) {
                    STACK_TRACE_ELEMENT_WRITER = new ObjectWriterAdapter<StackTraceElement>(StackTraceElement.class, null, null, 0L, Arrays.asList(ObjectWriters.fieldWriter("fileName", String.class, StackTraceElement::getFileName), ObjectWriters.fieldWriter("lineNumber", StackTraceElement::getLineNumber), ObjectWriters.fieldWriter("className", String.class, StackTraceElement::getClassName), ObjectWriters.fieldWriter("methodName", String.class, StackTraceElement::getMethodName)));
                }
                return STACK_TRACE_ELEMENT_WRITER;
            }
            if (Class.class == clazz) {
                return ObjectWriterImplClass.INSTANCE;
            }
            if (Method.class == clazz) {
                return new ObjectWriterAdapter<Method>(Method.class, null, null, 0L, Arrays.asList(ObjectWriters.fieldWriter("declaringClass", Class.class, Method::getDeclaringClass), ObjectWriters.fieldWriter("name", String.class, Method::getName), ObjectWriters.fieldWriter("parameterTypes", Class[].class, Method::getParameterTypes)));
            }
            if (Field.class == clazz) {
                return new ObjectWriterAdapter<Method>(Method.class, null, null, 0L, Arrays.asList(ObjectWriters.fieldWriter("declaringClass", Class.class, Field::getDeclaringClass), ObjectWriters.fieldWriter("name", String.class, Field::getName)));
            }
            if (ParameterizedType.class.isAssignableFrom(clazz)) {
                return ObjectWriters.objectWriter(ParameterizedType.class, ObjectWriters.fieldWriter("actualTypeArguments", Type[].class, ParameterizedType::getActualTypeArguments), ObjectWriters.fieldWriter("ownerType", Type.class, ParameterizedType::getOwnerType), ObjectWriters.fieldWriter("rawType", Type.class, ParameterizedType::getRawType));
            }
        }
        return null;
    }

    private ObjectWriter createEnumWriter(Class enumClass) {
        Member valueField;
        Class superclass;
        if (!enumClass.isEnum() && (superclass = enumClass.getSuperclass()).isEnum()) {
            enumClass = superclass;
        }
        if ((valueField = BeanUtils.getEnumValueField(enumClass, this)) == null) {
            Class mixInSource = (Class)this.mixInCache.get(enumClass);
            Member mixedValueField = BeanUtils.getEnumValueField(mixInSource, this);
            if (mixedValueField instanceof Field) {
                try {
                    valueField = enumClass.getField(mixedValueField.getName());
                }
                catch (NoSuchFieldException noSuchFieldException) {}
            } else if (mixedValueField instanceof Method) {
                try {
                    valueField = enumClass.getMethod(mixedValueField.getName(), new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
        }
        BeanInfo beanInfo = new BeanInfo();
        this.getBeanInfo(beanInfo, enumClass);
        if (beanInfo.writeEnumAsJavaBean) {
            return null;
        }
        String[] annotationNames = BeanUtils.getEnumAnnotationNames(enumClass);
        return new ObjectWriterImplEnum(null, enumClass, valueField, annotationNames, 0L);
    }

    static {
        Class[] classes = new Class[]{Boolean.TYPE, Boolean.class, Character.class, Character.TYPE, Byte.class, Byte.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE, BigInteger.class, BigDecimal.class, String.class, Currency.class, Date.class, UUID.class, Locale.class, String.class, StackTraceElement.class, Collections.emptyList().getClass(), Collections.emptyMap().getClass(), Collections.emptySet().getClass()};
        int[] codes = new int[classes.length];
        for (int i = 0; i < classes.length; ++i) {
            codes[i] = System.identityHashCode(classes[i]);
        }
        Arrays.sort(codes);
        PRIMITIVE_HASH_CODES = codes;
        int[] codes2 = Arrays.copyOf(codes, codes.length + 3);
        codes2[codes2.length - 1] = System.identityHashCode(Class.class);
        codes2[codes2.length - 2] = System.identityHashCode(int[].class);
        codes2[codes2.length - 3] = System.identityHashCode(long[].class);
        Arrays.sort(codes2);
        NOT_REFERENCES_TYPE_HASH_CODES = codes2;
    }

    static class VoidObjectWriter
    implements ObjectWriter {
        public static final VoidObjectWriter INSTANCE = new VoidObjectWriter();

        VoidObjectWriter() {
        }

        @Override
        public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        }
    }
}

