/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.filter;

import com.alibaba.fastjson2.JSON;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.time.DateTimeFormatter;
import com.alibaba.fastjson2.time.Instant;
import com.alibaba.fastjson2.time.LocalDate;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;

public class ContextAutoTypeBeforeHandler
implements JSONReader.AutoTypeBeforeHandler {
    static final Class CLASS_UNMODIFIABLE_SORTED_SET = Collections.unmodifiableSortedSet(new TreeSet()).getClass();
    static final Class CLASS_UNMODIFIABLE_SET = Collections.unmodifiableSet(Collections.emptySet()).getClass();
    static final Class CLASS_UNMODIFIABLE_COLLECTION = Collections.unmodifiableCollection(Collections.emptyList()).getClass();
    final long[] acceptHashCodes;
    final ConcurrentMap<Integer, ConcurrentHashMap<Long, Class>> tclHashCaches = new ConcurrentHashMap<Integer, ConcurrentHashMap<Long, Class>>();
    final Map<Long, Class> classCache = new ConcurrentHashMap<Long, Class>(16, 0.75f, 1);

    public ContextAutoTypeBeforeHandler(Class ... types) {
        this(false, types);
    }

    public ContextAutoTypeBeforeHandler(boolean includeBasic, Class ... types) {
        this(includeBasic, ContextAutoTypeBeforeHandler.names(Arrays.asList(types)));
    }

    public ContextAutoTypeBeforeHandler(String ... acceptNames) {
        this(false, acceptNames);
    }

    public ContextAutoTypeBeforeHandler(boolean includeBasic) {
        this(includeBasic, new String[0]);
    }

    static String[] names(Collection<Class> types) {
        HashSet<String> nameSet = new HashSet<String>();
        for (Class type : types) {
            if (type == null) continue;
            String name = TypeUtils.getTypeName(type);
            nameSet.add(name);
        }
        return nameSet.toArray(new String[nameSet.size()]);
    }

    public ContextAutoTypeBeforeHandler(boolean includeBasic, String ... acceptNames) {
        HashSet<String> nameSet = new HashSet<String>();
        if (includeBasic) {
            Class[] basicTypes = new Class[]{Object.class, Byte.TYPE, Byte.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class, Number.class, BigInteger.class, BigDecimal.class, AtomicInteger.class, AtomicLong.class, AtomicBoolean.class, AtomicIntegerArray.class, AtomicLongArray.class, AtomicReference.class, Boolean.TYPE, Boolean.class, Character.TYPE, Character.class, String.class, UUID.class, Currency.class, BitSet.class, EnumSet.class, EnumSet.noneOf(TimeUnit.class).getClass(), Date.class, Calendar.class, LocalDate.class, LocalDateTime.class, Instant.class, SimpleDateFormat.class, DateTimeFormatter.class, TimeUnit.class, Set.class, HashSet.class, LinkedHashSet.class, TreeSet.class, List.class, ArrayList.class, LinkedList.class, ConcurrentLinkedQueue.class, ConcurrentSkipListSet.class, CopyOnWriteArrayList.class, Collections.emptyList().getClass(), Collections.emptyMap().getClass(), TypeUtils.CLASS_SINGLE_SET, TypeUtils.CLASS_SINGLE_LIST, CLASS_UNMODIFIABLE_COLLECTION, TypeUtils.CLASS_UNMODIFIABLE_LIST, CLASS_UNMODIFIABLE_SET, CLASS_UNMODIFIABLE_SORTED_SET, Collections.unmodifiableMap(new HashMap()).getClass(), Collections.unmodifiableSortedMap(new TreeMap()).getClass(), Arrays.asList(new Object[0]).getClass(), Map.class, HashMap.class, Hashtable.class, TreeMap.class, LinkedHashMap.class, WeakHashMap.class, IdentityHashMap.class, ConcurrentMap.class, ConcurrentHashMap.class, ConcurrentSkipListMap.class, Exception.class, IllegalAccessError.class, IllegalAccessException.class, IllegalArgumentException.class, IllegalMonitorStateException.class, IllegalStateException.class, IllegalThreadStateException.class, IndexOutOfBoundsException.class, InstantiationError.class, InstantiationException.class, InternalError.class, InterruptedException.class, LinkageError.class, NegativeArraySizeException.class, NoClassDefFoundError.class, NoSuchFieldError.class, NoSuchFieldException.class, NoSuchMethodError.class, NoSuchMethodException.class, NullPointerException.class, NumberFormatException.class, OutOfMemoryError.class, RuntimeException.class, SecurityException.class, StackOverflowError.class, StringIndexOutOfBoundsException.class, TypeNotPresentException.class, VerifyError.class, StackTraceElement.class};
            for (int i = 0; i < basicTypes.length; ++i) {
                Class basicType = basicTypes[i];
                String name = TypeUtils.getTypeName(basicType);
                nameSet.add(name);
            }
            nameSet.add("javax.validation.ValidationException");
            nameSet.add("javax.validation.NoProviderFoundException");
        }
        for (int i = 0; i < acceptNames.length; ++i) {
            String name = acceptNames[i];
            if (name == null || name.isEmpty()) continue;
            Class mapping = TypeUtils.getMapping(name);
            if (mapping != null) {
                name = TypeUtils.getTypeName(mapping);
            }
            nameSet.add(name);
        }
        long[] array = new long[nameSet.size()];
        int index = 0;
        for (String name : nameSet) {
            long hashCode = -3750763034362895579L;
            for (int j = 0; j < name.length(); ++j) {
                int ch = name.charAt(j);
                if (ch == 36) {
                    ch = 46;
                }
                hashCode ^= (long)ch;
                hashCode *= 1099511628211L;
            }
            array[index++] = hashCode;
        }
        if (index != array.length) {
            array = Arrays.copyOf(array, index);
        }
        Arrays.sort(array);
        this.acceptHashCodes = array;
    }

    @Override
    public Class<?> apply(long typeNameHash, Class<?> expectClass, long features) {
        int tclHash;
        ConcurrentHashMap tclHashCache;
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader() && (tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash = System.identityHashCode(tcl))) != null) {
            return (Class)tclHashCache.get(typeNameHash);
        }
        return this.classCache.get(typeNameHash);
    }

    @Override
    public Class<?> apply(String typeName, Class<?> expectClass, long features) {
        String mappingTypeName;
        Class mapping;
        if ("O".equals(typeName)) {
            typeName = "Object";
        }
        long hash = -3750763034362895579L;
        int typeNameLength = typeName.length();
        for (int i = 0; i < typeNameLength; ++i) {
            Class origin;
            int ch = typeName.charAt(i);
            if (ch == 36) {
                ch = 46;
            }
            hash ^= (long)ch;
            if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) < 0) continue;
            long typeNameHash = Fnv.hashCode64(typeName);
            Class clazz = this.apply(typeNameHash, expectClass, features);
            if (clazz == null && (clazz = TypeUtils.loadClass(typeName)) != null && (origin = this.putCacheIfAbsent(typeNameHash, clazz)) != null) {
                clazz = origin;
            }
            if (clazz == null) continue;
            return clazz;
        }
        long typeNameHash = Fnv.hashCode64(typeName);
        if (typeName.length() > 0 && typeName.charAt(0) == '[') {
            Class<?> itemType;
            Class<?> clazz = this.apply(typeNameHash, expectClass, features);
            if (clazz != null) {
                return clazz;
            }
            String itemTypeName = typeName.substring(1);
            Class<?> itemExpectClass = null;
            if (expectClass != null) {
                itemExpectClass = expectClass.getComponentType();
            }
            if ((itemType = this.apply(itemTypeName, itemExpectClass, features)) != null) {
                Class<Object> arrayType = itemType == itemExpectClass ? expectClass : TypeUtils.getArrayClass(itemType);
                Class<Object> origin = this.putCacheIfAbsent(typeNameHash, arrayType);
                if (origin != null) {
                    arrayType = origin;
                }
                return arrayType;
            }
        }
        if ((mapping = TypeUtils.getMapping(typeName)) != null && !typeName.equals(mappingTypeName = TypeUtils.getTypeName(mapping))) {
            Class<?> mappingClass = this.apply(mappingTypeName, expectClass, features);
            if (mappingClass != null) {
                this.putCacheIfAbsent(typeNameHash, mappingClass);
            }
            return mappingClass;
        }
        return null;
    }

    private Class putCacheIfAbsent(long typeNameHash, Class type) {
        ClassLoader tcl = Thread.currentThread().getContextClassLoader();
        if (tcl != null && tcl != JSON.class.getClassLoader()) {
            int tclHash = System.identityHashCode(tcl);
            ConcurrentHashMap tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            if (tclHashCache == null) {
                this.tclHashCaches.put(tclHash, new ConcurrentHashMap());
                tclHashCache = (ConcurrentHashMap)this.tclHashCaches.get(tclHash);
            }
            return tclHashCache.put(typeNameHash, type);
        }
        return this.classCache.put(typeNameHash, type);
    }
}

