/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.time.DateTimeFormatter;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;

final class ObjectReaderImplCalendar
extends DateTimeCodec
implements ObjectReader {
    static final ObjectReaderImplCalendar INSTANCE = new ObjectReaderImplCalendar(null, null);

    public static ObjectReaderImplCalendar of(String format, Locale locale) {
        if (format == null) {
            return INSTANCE;
        }
        return new ObjectReaderImplCalendar(format, locale);
    }

    public ObjectReaderImplCalendar(String format, Locale locale) {
        super(format, locale);
    }

    public Class getObjectClass() {
        return Calendar.class;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        if (jsonReader.isInt()) {
            long millis = jsonReader.readInt64Value();
            if (this.formatUnixTime) {
                millis *= 1000L;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(millis);
            return calendar;
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        long millis = jsonReader.readMillisFromString();
        if (this.formatUnixTime) {
            millis *= 1000L;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        long millis;
        block26: {
            block30: {
                block29: {
                    block28: {
                        ZonedDateTime zdt;
                        block27: {
                            if (this.useSimpleFormatter) {
                                String str = jsonReader.readString();
                                try {
                                    return new SimpleDateFormat(this.format).parse(str);
                                }
                                catch (ParseException e) {
                                    throw new JSONException(jsonReader.info("parse error : " + str), e);
                                }
                            }
                            if (jsonReader.nextIfNullOrEmptyString()) {
                                return null;
                            }
                            if (!this.formatUnixTime && !this.formatMillis) break block27;
                            millis = jsonReader.readInt64Value();
                            if (this.formatUnixTime) {
                                millis *= 1000L;
                            }
                            break block26;
                        }
                        if (this.format == null) break block28;
                        if (this.yyyyMMddhhmmss19) {
                            millis = jsonReader.isSupportSmartMatch() ? jsonReader.readMillisFromString() : jsonReader.readMillis19();
                            if (millis != 0L || !jsonReader.wasNull()) {
                                Calendar calendar = Calendar.getInstance(jsonReader.context.getTimeZone());
                                calendar.setTimeInMillis(millis);
                                return calendar;
                            }
                            zdt = jsonReader.readZonedDateTime();
                        } else {
                            DateTimeFormatter formatter = this.getDateFormatter(jsonReader.getLocale());
                            if (formatter != null) {
                                LocalDateTime ldt;
                                block25: {
                                    if (jsonReader.jsonb && !jsonReader.isString()) {
                                        return jsonReader.readCalendar();
                                    }
                                    String str = jsonReader.readString();
                                    if (str.isEmpty() || "null".equals(str)) {
                                        return null;
                                    }
                                    if (!this.formatHasHour) {
                                        if (!this.formatHasDay) {
                                            return formatter.parseDate(str, jsonReader.getZoneId());
                                        }
                                        if (str.length() == 19 && jsonReader.isEnabled(JSONReader.Feature.SupportSmartMatch)) {
                                            ldt = DateUtils.parseLocalDateTime(str, 0, str.length());
                                            break block25;
                                        } else {
                                            if (this.format.indexOf(45) != -1 && str.indexOf(45) == -1 && TypeUtils.isInteger(str)) {
                                                long millis2 = Long.parseLong(str);
                                                Calendar calendar = Calendar.getInstance(jsonReader.context.getTimeZone());
                                                calendar.setTimeInMillis(millis2);
                                                return calendar;
                                            }
                                            Date date = formatter.parseDate(str, jsonReader.getZoneId());
                                            Calendar calendar = Calendar.getInstance(jsonReader.context.getTimeZone());
                                            calendar.setTime(date);
                                            return calendar;
                                        }
                                    }
                                    if (str.length() == 19 && (this.yyyyMMddhhmm16 || jsonReader.isEnabled(JSONReader.Feature.SupportSmartMatch))) {
                                        int length = this.yyyyMMddhhmm16 ? 16 : 19;
                                        ldt = DateUtils.parseLocalDateTime(str, 0, length);
                                    } else {
                                        try {
                                            Date date = new SimpleDateFormat(this.format).parse(str);
                                            Calendar calendar = Calendar.getInstance(jsonReader.context.getTimeZone());
                                            calendar.setTime(date);
                                            return calendar;
                                        }
                                        catch (ParseException e) {
                                            throw new JSONException("parse format '" + this.format + "'", e);
                                        }
                                    }
                                }
                                zdt = ZonedDateTime.of(ldt, jsonReader.context.getZoneId());
                            } else {
                                zdt = jsonReader.readZonedDateTime();
                            }
                        }
                        if (zdt == null) {
                            return null;
                        }
                        long seconds = zdt.toEpochSecond();
                        int nanos = zdt.dateTime.time.nano;
                        if (seconds < 0L && nanos > 0) {
                            millis = (seconds + 1L) * 1000L;
                            long adjustment = nanos / 1000000 - 1000;
                            millis += adjustment;
                            break block26;
                        } else {
                            millis = seconds * 1000L;
                            millis += (long)(nanos / 1000000);
                        }
                        break block26;
                    }
                    if (!jsonReader.isTypeRedirect() || !jsonReader.nextIfMatchIdent('\"', 'v', 'a', 'l', '\"')) break block29;
                    jsonReader.nextIfMatch(':');
                    millis = jsonReader.readInt64Value();
                    jsonReader.nextIfObjectEnd();
                    jsonReader.setTypeRedirect(false);
                    if (millis != 0L) break block26;
                    break block30;
                }
                return jsonReader.readCalendar();
            }
            if (jsonReader.wasNull()) {
                return null;
            }
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millis);
        return calendar;
    }
}

