/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.time;

import com.alibaba.fastjson2.time.DateTimeException;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.LocalTime;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.time.ZonedDateTime;
import java.util.Arrays;
import java.util.Date;

public final class LocalDate {
    public final int year;
    public final short monthValue;
    public final short dayOfMonth;

    private LocalDate(int year, int month, int dayOfMonth) {
        this.year = year;
        this.monthValue = (short)month;
        this.dayOfMonth = (short)dayOfMonth;
    }

    public static LocalDate of(int year, int month, int dayOfMonth) {
        if (month <= 0 || month > 12) {
            throw new DateTimeException("Invalid value for month (valid values [1,12]): " + month);
        }
        if (dayOfMonth <= 0 || dayOfMonth > 31) {
            throw new DateTimeException("Invalid value for month (valid values [1,31]): " + dayOfMonth);
        }
        return LocalDate.create(year, month, dayOfMonth);
    }

    private static LocalDate create(int year, int month, int dayOfMonth) {
        if (dayOfMonth > 28) {
            int dom = 31;
            switch (month) {
                case 2: {
                    dom = LocalDate.isLeapYear(year) ? 29 : 28;
                    break;
                }
                case 4: 
                case 6: 
                case 9: 
                case 11: {
                    dom = 30;
                }
            }
            if (dayOfMonth > dom) {
                if (dayOfMonth == 29) {
                    throw new DateTimeException("Invalid date 'February 29' as '" + year + "' is not a leap year");
                }
                throw new DateTimeException("Invalid date month-" + dayOfMonth + "'");
            }
        }
        return new LocalDate(year, month, dayOfMonth);
    }

    public static LocalDate ofEpochDay(long epochDay) {
        long yearEst;
        long doyEst;
        int DAYS_PER_CYCLE = 146097;
        long zeroDay = epochDay + 719528L;
        long adjust = 0L;
        if ((zeroDay -= 60L) < 0L) {
            long adjustCycles = (zeroDay + 1L) / 146097L - 1L;
            adjust = adjustCycles * 400L;
            zeroDay += -adjustCycles * 146097L;
        }
        if ((doyEst = zeroDay - (365L * (yearEst = (400L * zeroDay + 591L) / 146097L) + yearEst / 4L - yearEst / 100L + yearEst / 400L)) < 0L) {
            doyEst = zeroDay - (365L * --yearEst + yearEst / 4L - yearEst / 100L + yearEst / 400L);
        }
        yearEst += adjust;
        int marchDoy0 = (int)doyEst;
        int marchMonth0 = (marchDoy0 * 5 + 2) / 153;
        int month = (marchMonth0 + 2) % 12 + 1;
        int dom = marchDoy0 - (marchMonth0 * 306 + 5) / 10 + 1;
        int year = LocalDateTime.checkYear(yearEst += (long)(marchMonth0 / 10));
        return new LocalDate(year, month, dom);
    }

    public long toEpochDay() {
        long y = this.year;
        long m = this.monthValue;
        long total = 0L;
        total += 365L * y;
        total = y >= 0L ? (total += (y + 3L) / 4L - (y + 99L) / 100L + (y + 399L) / 400L) : (total -= y / -4L - y / -100L + y / -400L);
        total += (367L * m - 362L) / 12L;
        total += (long)(this.dayOfMonth - 1);
        if (m > 2L) {
            --total;
            if (!LocalDate.isLeapYear(this.year)) {
                --total;
            }
        }
        return total - 719528L;
    }

    public static boolean isLeapYear(int year) {
        return (year & 3) == 0 && (year % 100 != 0 || year % 400 == 0);
    }

    public LocalDateTime atStartOfDay() {
        return LocalDateTime.of(this, LocalTime.MIN);
    }

    public Date toDate() {
        return this.atStartOfDay().toInstant(ZoneId.DEFAULT_ZONE_ID).toDate();
    }

    public ZonedDateTime atStartOfDay(ZoneId zone) {
        return ZonedDateTime.of(LocalDateTime.of(this, LocalTime.MIN), zone);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LocalDate localDate = (LocalDate)o;
        return this.year == localDate.year && this.monthValue == localDate.monthValue && this.dayOfMonth == localDate.dayOfMonth;
    }

    public int hashCode() {
        return Arrays.hashCode(new Object[]{this.year, this.monthValue, this.dayOfMonth});
    }
}

