/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.lang.reflect.Type;

final class ObjectWriterImplInt64
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplInt64 INSTANCE = new ObjectWriterImplInt64(null);
    final Class defineClass;

    public ObjectWriterImplInt64(Class defineClass) {
        this.defineClass = defineClass;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNumberNull();
            return;
        }
        long longValue = (Long)object;
        if ((features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            jsonWriter.writeString(longValue);
        } else {
            jsonWriter.writeInt64(longValue);
        }
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        long contextFeatures;
        if (object == null) {
            jsonWriter.writeNumberNull();
            return;
        }
        long longValue = ((Number)object).longValue();
        if ((features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            jsonWriter.writeString(longValue);
            return;
        }
        jsonWriter.writeInt64(longValue);
        if (longValue >= Integer.MIN_VALUE && longValue <= Integer.MAX_VALUE && (features & JSONWriter.Feature.WriteClassName.mask) != 0L && ((contextFeatures = jsonWriter.getFeatures()) & JSONWriter.Feature.WriteClassName.mask) == 0L) {
            boolean writeAsString;
            boolean bl = writeAsString = (contextFeatures & (JSONWriter.Feature.WriteNonStringValueAsString.mask | JSONWriter.Feature.WriteLongAsString.mask)) != 0L;
            if (!writeAsString) {
                jsonWriter.writeRaw('L');
            }
        }
    }
}

