/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.reader.ObjectReaderProvider;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;

final class ConstructorFunction<T>
implements Function<Map<Long, Object>, T> {
    final Constructor constructor;
    final int parameterCount;
    final Function function;
    final BiFunction biFunction;
    final Class[] parameterTypes;
    final boolean kotlinMaker;
    final long[] hashCodes;
    Map<Set<Long>, Constructor> alternateConstructorMap;
    Map<Set<Long>, String[]> alternateConstructorNames;
    Map<Set<Long>, long[]> alternateConstructorNameHashCodes;
    Map<Set<Long>, Type[]> alternateConstructorArgTypes;

    ConstructorFunction(List<Constructor> alternateConstructors, Constructor constructor, Function function, BiFunction biFunction, Constructor markerConstructor, String ... paramNames) {
        int i;
        this.kotlinMaker = markerConstructor != null;
        this.function = function;
        this.biFunction = biFunction;
        this.constructor = this.kotlinMaker ? markerConstructor : constructor;
        this.parameterCount = this.constructor.getParameterCount();
        this.parameterTypes = constructor.getParameterTypes();
        this.hashCodes = new long[this.parameterTypes.length];
        for (i = 0; i < this.parameterTypes.length; ++i) {
            String name = null;
            if (i < paramNames.length) {
                name = paramNames[i];
            }
            if (name == null) {
                name = "arg" + i;
            }
            this.hashCodes[i] = Fnv.hashCode64(name);
        }
        if (alternateConstructors != null) {
            this.alternateConstructorMap = new HashMap<Set<Long>, Constructor>(alternateConstructors.size());
            this.alternateConstructorNames = new HashMap<Set<Long>, String[]>(alternateConstructors.size());
            this.alternateConstructorArgTypes = new HashMap<Set<Long>, Type[]>(alternateConstructors.size());
            this.alternateConstructorNameHashCodes = new HashMap<Set<Long>, long[]>(alternateConstructors.size());
            for (i = 0; i < alternateConstructors.size(); ++i) {
                Constructor alternateConstructor = alternateConstructors.get(i);
                alternateConstructor.setAccessible(true);
                String[] parameterNames = BeanUtils.lookupParameterNames(alternateConstructor);
                Class<?>[] parameters = alternateConstructor.getParameterTypes();
                FieldInfo fieldInfo = new FieldInfo();
                ObjectReaderProvider provider = JSONFactory.defaultObjectReaderProvider;
                Annotation[][] parameterAnnotations = alternateConstructor.getParameterAnnotations();
                for (int j = 0; i < parameters.length && j < parameterNames.length; ++j) {
                    fieldInfo.init();
                    provider.getFieldInfo(fieldInfo, alternateConstructor.getDeclaringClass(), alternateConstructor, j, parameterAnnotations);
                    if (fieldInfo.fieldName == null) continue;
                    parameterNames[j] = fieldInfo.fieldName;
                }
                long[] parameterNameHashCodes = new long[parameterNames.length];
                Type[] parameterTypes = alternateConstructor.getGenericParameterTypes();
                HashSet<Long> paramHashCodes = new HashSet<Long>(parameterNames.length);
                for (int j = 0; j < parameterNames.length; ++j) {
                    long hashCode64;
                    String paramName = parameterNames[j];
                    parameterNameHashCodes[j] = hashCode64 = paramName == null ? 0L : Fnv.hashCode64(paramName);
                    paramHashCodes.add(hashCode64);
                }
                this.alternateConstructorMap.put(paramHashCodes, alternateConstructor);
                this.alternateConstructorNames.put(paramHashCodes, parameterNames);
                this.alternateConstructorNameHashCodes.put(paramHashCodes, parameterNameHashCodes);
                this.alternateConstructorArgTypes.put(paramHashCodes, parameterTypes);
            }
        }
    }

    @Override
    public T apply(Map<Long, Object> values) {
        int i;
        Set<Long> key;
        Constructor constructor;
        boolean containsAll = true;
        for (int i2 = 0; i2 < this.hashCodes.length; ++i2) {
            if (values.containsKey(this.hashCodes[i2])) continue;
            containsAll = false;
            break;
        }
        if (!containsAll && this.alternateConstructorMap != null && (constructor = this.alternateConstructorMap.get(key = values.keySet())) != null) {
            long[] hashCodes = this.alternateConstructorNameHashCodes.get(key);
            Type[] paramTypes = this.alternateConstructorArgTypes.get(key);
            Object[] args = new Object[hashCodes.length];
            for (int i3 = 0; i3 < hashCodes.length; ++i3) {
                Object arg = values.get(hashCodes[i3]);
                Type paramType = paramTypes[i3];
                if (arg == null) {
                    arg = TypeUtils.getDefaultValue(paramType);
                }
                args[i3] = arg;
            }
            try {
                return constructor.newInstance(args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
                throw new JSONException("invoke constructor error, " + constructor, e);
            }
        }
        if (this.function != null && this.parameterTypes.length == 1) {
            Object arg = values.get(this.hashCodes[0]);
            Class paramType = this.parameterTypes[0];
            if (arg == null) {
                arg = TypeUtils.getDefaultValue(paramType);
            } else if (!paramType.isInstance(arg)) {
                arg = TypeUtils.cast(arg, paramType, JSONFactory.defaultObjectReaderProvider);
            }
            return (T)this.function.apply(arg);
        }
        if (this.biFunction != null && this.parameterTypes.length == 2) {
            Object arg0 = values.get(this.hashCodes[0]);
            Class param0Type = this.parameterTypes[0];
            if (arg0 == null) {
                arg0 = TypeUtils.getDefaultValue(param0Type);
            } else if (!param0Type.isInstance(arg0)) {
                arg0 = TypeUtils.cast(arg0, param0Type, JSONFactory.defaultObjectReaderProvider);
            }
            Object arg1 = values.get(this.hashCodes[1]);
            Class param1Type = this.parameterTypes[1];
            if (arg1 == null) {
                arg1 = TypeUtils.getDefaultValue(param1Type);
            } else if (!param1Type.isInstance(arg1)) {
                arg1 = TypeUtils.cast(arg1, param1Type, JSONFactory.defaultObjectReaderProvider);
            }
            return (T)this.biFunction.apply(arg0, arg1);
        }
        int size = this.parameterTypes.length;
        Object[] args = new Object[this.parameterCount];
        if (this.kotlinMaker) {
            i = 0;
            int flag = 0;
            while (i < size) {
                Object arg = values.get(this.hashCodes[i]);
                if (arg != null) {
                    args[i] = arg;
                } else {
                    flag |= 1 << i;
                    Class paramType = this.parameterTypes[i];
                    if (paramType.isPrimitive()) {
                        args[i] = TypeUtils.getDefaultValue(paramType);
                    }
                }
                int n = i + 1;
                if (n % 32 == 0 || n == size) {
                    args[size + i / 32] = flag;
                    flag = 0;
                }
                i = n;
            }
        } else {
            for (i = 0; i < size; ++i) {
                Type[] genericParameterTypes;
                Class paramClass = this.parameterTypes[i];
                Object arg = values.get(this.hashCodes[i]);
                if (arg == null) {
                    arg = TypeUtils.getDefaultValue(paramClass);
                } else if (!paramClass.isInstance(arg)) {
                    arg = TypeUtils.cast(arg, paramClass, JSONFactory.defaultObjectReaderProvider);
                } else if ((Collection.class.isAssignableFrom(paramClass) || Map.class.isAssignableFrom(paramClass)) && (genericParameterTypes = this.constructor.getGenericParameterTypes()).length == this.parameterTypes.length) {
                    Type paramType = genericParameterTypes[i];
                    arg = TypeUtils.cast(arg, paramType);
                }
                args[i] = arg;
            }
        }
        try {
            return this.constructor.newInstance(args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException e) {
            throw new JSONException("invoke constructor error, " + this.constructor, e);
        }
    }
}

