/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.lang.reflect.Type;
import java.text.DecimalFormat;

final class ObjectWriterImplFloat
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplFloat INSTANCE = new ObjectWriterImplFloat(null);
    private final DecimalFormat format;

    public ObjectWriterImplFloat(DecimalFormat format) {
        this.format = format;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        float value = ((Float)object).floatValue();
        if ((features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            jsonWriter.writeString(value);
        } else {
            jsonWriter.writeFloat(value);
        }
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (object == null) {
            jsonWriter.writeNull();
            return;
        }
        if (this.format != null) {
            String str = this.format.format(object);
            jsonWriter.writeRaw(str);
            return;
        }
        float floatValue = ((Float)object).floatValue();
        if ((features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            jsonWriter.writeString(floatValue);
            return;
        }
        jsonWriter.writeFloat(floatValue);
        if (((jsonWriter.getFeatures() | features) & JSONWriter.Feature.WriteClassName.mask) != 0L && fieldType != Float.class && fieldType != Float.TYPE) {
            jsonWriter.writeRaw('F');
        }
    }
}

