/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONReaderUTF16;
import com.alibaba.fastjson2.JSONValidException;
import com.alibaba.fastjson2.reader.ValueConsumer;
import com.alibaba.fastjson2.util.IOUtils;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.UUIDUtils;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.TimeZone;
import java.util.UUID;

class JSONReaderUTF8
extends JSONReader {
    protected final byte[] bytes;
    protected final int length;
    protected final int end;
    protected int nameBegin;
    protected int nameEnd;
    protected int nameLength;
    protected boolean nameAscii;
    protected int referenceBegin;

    JSONReaderUTF8(JSONReader.Context ctx, byte[] bytes, int offset, int length) {
        super(ctx);
        this.bytes = bytes;
        this.offset = offset;
        this.length = length;
        this.end = offset + length;
        this.next();
        while (this.ch == '/') {
            this.next();
            if (this.ch == '/') {
                this.skipLineComment();
                continue;
            }
            throw new JSONException("input not support " + this.ch + ", offset " + offset);
        }
    }

    @Override
    public boolean nextIfMatch(char e) {
        if (this.ch != e) {
            return false;
        }
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return true;
        }
        int c = this.bytes[this.offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return true;
            }
            c = this.bytes[this.offset];
        }
        if (c >= 0) {
            ++this.offset;
            this.ch = (char)c;
            return true;
        }
        switch ((c &= 0xFF) >> 4) {
            case 12: 
            case 13: {
                this.offset += 2;
                byte char2 = this.bytes[this.offset - 1];
                if ((char2 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + this.offset);
                }
                this.ch = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                break;
            }
            case 14: {
                this.offset += 3;
                byte char2 = this.bytes[this.offset - 2];
                byte char3 = this.bytes[this.offset - 1];
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + (this.offset - 1));
                }
                this.ch = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                break;
            }
            default: {
                throw new JSONException("malformed input around byte " + this.offset);
            }
        }
        return true;
    }

    @Override
    public void next() {
        if (this.offset >= this.end) {
            this.ch = (char)26;
            return;
        }
        int c = this.bytes[this.offset];
        while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            c = this.bytes[this.offset];
        }
        if (c >= 0) {
            ++this.offset;
            this.ch = (char)c;
            return;
        }
        switch ((c &= 0xFF) >> 4) {
            case 12: 
            case 13: {
                this.offset += 2;
                byte char2 = this.bytes[this.offset - 1];
                if ((char2 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + this.offset);
                }
                this.ch = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                break;
            }
            case 14: {
                this.offset += 3;
                byte char2 = this.bytes[this.offset - 2];
                byte char3 = this.bytes[this.offset - 1];
                if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                    throw new JSONException("malformed input around byte " + (this.offset - 1));
                }
                this.ch = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                break;
            }
            default: {
                throw new JSONException("malformed input around byte " + this.offset);
            }
        }
    }

    @Override
    public long readFieldNameHashCodeUnquote() {
        this.nameEscape = false;
        this.nameBegin = this.offset - 1;
        long hashCode = -3750763034362895579L;
        int i = 0;
        block8: while (true) {
            if (this.ch == '\\') {
                this.nameEscape = true;
                this.ch = (char)this.bytes[this.offset++];
                switch (this.ch) {
                    case 'u': {
                        char c1 = (char)this.bytes[this.offset++];
                        char c2 = (char)this.bytes[this.offset++];
                        char c3 = (char)this.bytes[this.offset++];
                        char c4 = (char)this.bytes[this.offset++];
                        this.ch = JSONReaderUTF8.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = (char)this.bytes[this.offset++];
                        char c2 = (char)this.bytes[this.offset++];
                        this.ch = JSONReaderUTF8.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '*': 
                    case '+': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '@': 
                    case '\\': {
                        break;
                    }
                    default: {
                        this.ch = JSONReaderUTF8.char1(this.ch);
                    }
                }
                hashCode ^= (long)this.ch;
                hashCode *= 1099511628211L;
                this.next();
            } else {
                switch (this.ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case '\u001a': 
                    case ' ': 
                    case '!': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.nameLength = i;
                        this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                            this.next();
                        }
                        break block8;
                    }
                    default: {
                        hashCode ^= (long)this.ch;
                        hashCode *= 1099511628211L;
                        this.ch = (char)(this.offset >= this.end ? 26 : (char)this.bytes[this.offset++]);
                    }
                }
            }
            ++i;
        }
        return hashCode;
    }

    public long readFieldNameHashCodeUnquote1() {
        this.nameEscape = false;
        this.nameBegin = this.offset - 1;
        long hashCode = -3750763034362895579L;
        int i = 0;
        block8: while (true) {
            if (this.ch == '\\') {
                this.nameEscape = true;
                this.ch = (char)this.bytes[this.offset++];
                switch (this.ch) {
                    case 'u': {
                        char c1 = (char)this.bytes[this.offset++];
                        char c2 = (char)this.bytes[this.offset++];
                        char c3 = (char)this.bytes[this.offset++];
                        char c4 = (char)this.bytes[this.offset++];
                        this.ch = JSONReaderUTF8.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        char c1 = (char)this.bytes[this.offset++];
                        char c2 = (char)this.bytes[this.offset++];
                        this.ch = JSONReaderUTF8.char2(c1, c2);
                        break;
                    }
                    case '\"': 
                    case '.': 
                    case '\\': {
                        break;
                    }
                    default: {
                        this.ch = JSONReaderUTF8.char1(this.ch);
                    }
                }
                hashCode ^= (long)this.ch;
                hashCode *= 1099511628211L;
                this.next();
            } else {
                switch (this.ch) {
                    case '\b': 
                    case '\t': 
                    case '\n': 
                    case '\f': 
                    case '\r': 
                    case '\u001a': 
                    case ' ': 
                    case '!': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '+': 
                    case ',': 
                    case '-': 
                    case '.': 
                    case '/': 
                    case ':': 
                    case '<': 
                    case '=': 
                    case '>': 
                    case '[': 
                    case ']': 
                    case '{': 
                    case '}': {
                        this.nameLength = i;
                        this.nameEnd = this.ch == '\u001a' ? this.offset : this.offset - 1;
                        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                            this.next();
                        }
                        break block8;
                    }
                    default: {
                        hashCode ^= (long)this.ch;
                        hashCode *= 1099511628211L;
                        this.next();
                    }
                }
            }
            ++i;
        }
        return hashCode;
    }

    @Override
    public long readFieldNameHashCode() {
        int c;
        if (this.ch != '\"' && this.ch != '\'') {
            return -1L;
        }
        char quote = this.ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i = 0;
        while (true) {
            if ((c = this.bytes[offset]) == 92) {
                this.nameEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 120: {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderUTF8.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderUTF8.char1(c);
                    }
                }
                ++offset;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = this.bytes[offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    if (c != 58) {
                        return -1L;
                    }
                    c = this.bytes[++offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    break;
                }
                if (c >= 0) {
                    ++offset;
                } else {
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            offset += 2;
                            this.nameAscii = false;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[offset + 1];
                            byte c3 = this.bytes[offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            offset += 3;
                            this.nameAscii = false;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public long readValueHashCode() {
        int c;
        if (this.ch != '\"') {
            return -1L;
        }
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        long hashCode = -3750763034362895579L;
        int i = 0;
        while (true) {
            block18: {
                block20: {
                    block19: {
                        block17: {
                            if ((c = this.bytes[offset]) != 92) break block17;
                            this.nameEscape = true;
                            c = this.bytes[++offset];
                            switch (c) {
                                case 117: {
                                    byte c1 = this.bytes[++offset];
                                    byte c2 = this.bytes[++offset];
                                    byte c3 = this.bytes[++offset];
                                    byte c4 = this.bytes[++offset];
                                    c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                                    break;
                                }
                                case 120: {
                                    byte c1 = this.bytes[++offset];
                                    byte c2 = this.bytes[++offset];
                                    c = JSONReaderUTF8.char2(c1, c2);
                                    break;
                                }
                                default: {
                                    c = JSONReaderUTF8.char1(c);
                                }
                            }
                            ++offset;
                            hashCode ^= (long)c;
                            hashCode *= 1099511628211L;
                            break block18;
                        }
                        if (c == 34) {
                            this.nameLength = i;
                            this.nameEnd = offset++;
                            c = offset == this.end ? 26 : this.bytes[offset];
                            while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                                c = this.bytes[++offset];
                            }
                            if (c == 44) {
                                c = this.bytes[++offset];
                                while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                                    c = this.bytes[++offset];
                                }
                            }
                            break;
                        }
                        if (c < 0) break block19;
                        ++offset;
                        break block20;
                    }
                    switch ((c & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[offset + 1];
                            if ((c2 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            offset += 2;
                            this.nameAscii = false;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[offset + 1];
                            byte c3 = this.bytes[offset + 2];
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            offset += 3;
                            this.nameAscii = false;
                            break;
                        }
                        default: {
                            if (c >> 3 != -2) throw new JSONException("malformed input around byte " + offset);
                            int n = ++offset;
                            byte c2 = this.bytes[n];
                            int n2 = ++offset;
                            byte c3 = this.bytes[n2];
                            int n3 = ++offset;
                            ++offset;
                            byte c4 = this.bytes[n3];
                            int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                            if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            char x1 = (char)((uc >>> 10) + 55232);
                            char x2 = (char)((uc & 0x3FF) + 56320);
                            hashCode ^= (long)x1;
                            hashCode *= 1099511628211L;
                            hashCode ^= (long)x2;
                            hashCode *= 1099511628211L;
                            ++i;
                            break block18;
                        }
                    }
                }
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return hashCode;
    }

    @Override
    public long getNameHashCodeLCase() {
        long hashCode = -3750763034362895579L;
        int offset = this.nameBegin;
        if (this.nameAscii && !this.nameEscape) {
            for (int i = 0; i < this.nameLength; ++i) {
                char c = (char)this.bytes[offset + i];
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c + 32);
                }
                if (c == '_') continue;
                hashCode ^= (long)c;
                hashCode *= 1099511628211L;
            }
            return hashCode;
        }
        while (true) {
            char c;
            if ((c = this.bytes[offset]) == '\\') {
                c = (char)this.bytes[++offset];
                switch (c) {
                    case 'u': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        byte c3 = this.bytes[++offset];
                        byte c4 = this.bytes[++offset];
                        c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                        break;
                    }
                    case 'x': {
                        byte c1 = this.bytes[++offset];
                        byte c2 = this.bytes[++offset];
                        c = JSONReaderUTF8.char2(c1, c2);
                        break;
                    }
                    default: {
                        c = JSONReaderUTF8.char1(c);
                    }
                }
                ++offset;
            } else {
                if (c == '\"') break;
                if (c >= '\u0000') {
                    if (c >= 'A' && c <= 'Z') {
                        c = (char)(c + 32);
                    }
                    ++offset;
                } else {
                    c = (char)(c & 0xFF);
                    switch (c >> 4) {
                        case 12: 
                        case 13: {
                            byte c2 = this.bytes[offset + 1];
                            c = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            offset += 2;
                            break;
                        }
                        case 14: {
                            byte c2 = this.bytes[offset + 1];
                            byte c3 = this.bytes[offset + 2];
                            c = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
            }
            if (c == '_') continue;
            hashCode ^= (long)c;
            hashCode *= 1099511628211L;
        }
        return hashCode;
    }

    @Override
    public String getFieldName() {
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.bytes, this.nameBegin, length, this.nameAscii ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8);
        }
        char[] chars = new char[this.nameLength];
        int offset = this.nameBegin;
        int i = 0;
        while (offset < this.nameEnd) {
            int c = this.bytes[offset];
            if (c < 0) {
                switch ((c &= 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        byte char2 = this.bytes[offset + 1];
                        if ((char2 & 0xC0) != 128) {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                        c = (c & 0x1F) << 6 | char2 & 0x3F;
                        offset += 2;
                        break;
                    }
                    case 14: {
                        byte char2 = this.bytes[offset + 1];
                        byte char3 = this.bytes[offset + 2];
                        if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                            throw new JSONException("malformed input around byte " + (offset + 2));
                        }
                        c = (c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0;
                        offset += 3;
                        break;
                    }
                    default: {
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
                chars[i] = (char)c;
            } else {
                if (c == 92) {
                    c = (char)this.bytes[++offset];
                    switch (c) {
                        case 117: {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 120: {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case 34: 
                        case 42: 
                        case 43: 
                        case 45: 
                        case 46: 
                        case 47: 
                        case 58: 
                        case 60: 
                        case 61: 
                        case 62: 
                        case 64: 
                        case 92: {
                            break;
                        }
                        default: {
                            c = JSONReaderUTF8.char1(c);
                            break;
                        }
                    }
                } else if (c == 34) break;
                chars[i] = (char)c;
                ++offset;
            }
            ++i;
        }
        return new String(chars);
    }

    @Override
    public String readFieldName() {
        int c;
        if (this.ch != '\"' && this.ch != '\'') {
            return null;
        }
        char quote = this.ch;
        this.nameAscii = true;
        this.nameEscape = false;
        int offset = this.nameBegin = this.offset;
        int i = 0;
        while (true) {
            if ((c = this.bytes[offset]) == 92) {
                this.nameEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else {
                if (c == quote) {
                    this.nameLength = i;
                    this.nameEnd = offset++;
                    c = this.bytes[offset] & 0xFF;
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset] & 0xFF;
                    }
                    if (c != 58) {
                        throw new JSONException("syntax error : " + offset);
                    }
                    c = this.bytes[++offset];
                    while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                        c = this.bytes[++offset];
                    }
                    break;
                }
                if (c >= 0) {
                    ++offset;
                } else {
                    if (this.nameAscii) {
                        this.nameAscii = false;
                    }
                    switch ((c &= 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            offset += 2;
                            break;
                        }
                        case 14: {
                            offset += 3;
                            break;
                        }
                        default: {
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
            }
            ++i;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        int length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.bytes, this.nameBegin, length, this.nameAscii ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8);
        }
        return this.getFieldName();
    }

    @Override
    public final int readInt32Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                int intValue10 = intValue * 10 + (this.ch - 48);
                if (intValue10 < intValue) {
                    overflow = true;
                    break;
                }
                intValue = intValue10;
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.intValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("int overflow, value " + bigInteger.toString());
                }
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public Integer readInt32() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        int intValue = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
                this.nextIfMatch(',');
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                int intValue10 = intValue * 10 + (this.ch - 48);
                if (intValue10 < intValue) {
                    overflow = true;
                    break;
                }
                intValue = intValue10;
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.wasNull) {
                return null;
            }
            return this.getInt32Value();
        }
        if (quote != '\u0000') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        return negative ? -intValue : intValue;
    }

    @Override
    public final long readInt64Value() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                long intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                    break;
                }
                longValue = intValue10;
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            if (this.valueType == 1) {
                BigInteger bigInteger = this.getBigInteger();
                try {
                    return bigInteger.longValueExact();
                }
                catch (ArithmeticException ex) {
                    throw new JSONException("long overflow, value " + bigInteger);
                }
            }
            return this.getInt64Value();
        }
        if (quote != '\u0000') {
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public Long readInt64() {
        boolean negative = false;
        int firstOffset = this.offset;
        char firstChar = this.ch;
        long longValue = 0L;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
                this.nextIfMatch(',');
                return null;
            }
        }
        if (this.ch == '-') {
            negative = true;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
                this.nextIfMatch(',');
                return null;
            }
        }
        boolean overflow = false;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!overflow) {
                long intValue10 = longValue * 10L + (long)(this.ch - 48);
                if (intValue10 < longValue) {
                    overflow = true;
                    break;
                }
                longValue = intValue10;
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean notMatch = false;
        if (this.ch == '.' || this.ch == 'e' || this.ch == 'E' || this.ch == 't' || this.ch == 'f' || this.ch == 'n' || this.ch == '{' || this.ch == '[' || overflow) {
            notMatch = true;
        } else if (quote != '\u0000' && this.ch != quote) {
            notMatch = true;
        }
        if (notMatch) {
            this.offset = firstOffset;
            this.ch = firstChar;
            this.readNumber0();
            return this.getInt64();
        }
        if (quote != '\u0000') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        return negative ? -longValue : longValue;
    }

    @Override
    public void readString(ValueConsumer consumer, boolean quoted) {
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            byte c;
            if ((c = this.bytes[offset]) == 92) {
                this.valueEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else if (c >= 0) {
                if (c == quote) break;
                ++offset;
            } else {
                switch ((c & 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        offset += 2;
                        break;
                    }
                    case 14: {
                        offset += 3;
                        break;
                    }
                    default: {
                        if (c >> 3 == -2) {
                            offset += 4;
                            ++i;
                            break;
                        }
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            int bytesMaxiumLength = offset - this.offset;
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.bytes[offset]) == '\\') {
                    c = this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderUTF8.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                if (c >= '\u0000') {
                    chars[i2] = c;
                    ++offset;
                } else {
                    switch ((c & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            int n = ++offset;
                            ++offset;
                            byte c2 = this.bytes[n];
                            chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                            break;
                        }
                        case 14: {
                            int n = ++offset;
                            byte c2 = this.bytes[n];
                            int n2 = ++offset;
                            ++offset;
                            byte c3 = this.bytes[n2];
                            chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                            break;
                        }
                        default: {
                            byte c3;
                            byte c2;
                            if (c >> 3 == -2) {
                                int n = ++offset;
                                c2 = this.bytes[n];
                                int n3 = ++offset;
                                c3 = this.bytes[n3];
                                int n4 = ++offset;
                                ++offset;
                                byte c4 = this.bytes[n4];
                                int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                                chars[i2++] = (char)((uc >>> 10) + 55232);
                                chars[i2] = (char)((uc & 0x3FF) + 56320);
                                break;
                            }
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
                ++i2;
            }
            byte[] bytes = new byte[bytesMaxiumLength];
            int bytesLength = IOUtils.encodeUTF8(chars, 0, chars.length, bytes, 0);
            consumer.accept(bytes, 0, bytesLength);
        } else {
            int consumLen;
            int consumStart = quoted ? this.offset - 1 : this.offset;
            int n = consumLen = quoted ? offset - this.offset + 2 : offset - this.offset;
            if (quoted && quote == '\'') {
                byte[] quotedBytes = new byte[consumLen];
                System.arraycopy(this.bytes, this.offset - 1, quotedBytes, 0, consumLen);
                quotedBytes[0] = 34;
                quotedBytes[quotedBytes.length - 1] = 34;
                consumer.accept(quotedBytes, 0, quotedBytes.length);
            } else {
                consumer.accept(this.bytes, consumStart, consumLen);
            }
        }
        byte b = this.bytes[++offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.bytes[++offset];
        }
        if (b == 44) {
            this.offset = offset + 1;
            this.next();
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
    }

    protected void readString0() {
        String str;
        int offset;
        char quote = this.ch;
        int start = offset = this.offset;
        boolean ascii = true;
        this.valueEscape = false;
        int i = 0;
        while (true) {
            byte c;
            if ((c = this.bytes[offset]) == 92) {
                this.valueEscape = true;
                c = this.bytes[++offset];
                switch (c) {
                    case 117: {
                        offset += 4;
                        break;
                    }
                    case 120: {
                        offset += 2;
                        break;
                    }
                }
                ++offset;
            } else if (c >= 0) {
                if (c == quote) break;
                ++offset;
            } else {
                switch ((c & 0xFF) >> 4) {
                    case 12: 
                    case 13: {
                        offset += 2;
                        ascii = false;
                        break;
                    }
                    case 14: {
                        offset += 3;
                        ascii = false;
                        break;
                    }
                    default: {
                        if (c >> 3 == -2) {
                            offset += 4;
                            ++i;
                            ascii = false;
                            break;
                        }
                        throw new JSONException("malformed input around byte " + offset);
                    }
                }
            }
            ++i;
        }
        int valueLength = i;
        if (this.valueEscape) {
            char[] chars = new char[valueLength];
            offset = start;
            int i2 = 0;
            while (true) {
                char c;
                if ((c = this.bytes[offset]) == '\\') {
                    c = this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            byte c3 = this.bytes[++offset];
                            byte c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            byte c1 = this.bytes[++offset];
                            byte c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderUTF8.char1(c);
                        }
                    }
                    chars[i2] = c;
                    ++offset;
                } else {
                    if (c == '\"') break;
                    if (c >= '\u0000') {
                        chars[i2] = c;
                        ++offset;
                    } else {
                        switch ((c & 0xFF) >> 4) {
                            case 12: 
                            case 13: {
                                int n = ++offset;
                                ++offset;
                                byte c2 = this.bytes[n];
                                chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                break;
                            }
                            case 14: {
                                int n = ++offset;
                                byte c2 = this.bytes[n];
                                int n2 = ++offset;
                                ++offset;
                                byte c3 = this.bytes[n2];
                                chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                                break;
                            }
                            default: {
                                byte c3;
                                byte c2;
                                if (c >> 3 == -2) {
                                    int n = ++offset;
                                    c2 = this.bytes[n];
                                    int n3 = ++offset;
                                    c3 = this.bytes[n3];
                                    int n4 = ++offset;
                                    ++offset;
                                    byte c4 = this.bytes[n4];
                                    int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                    if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                        throw new JSONException("malformed input around byte " + offset);
                                    }
                                    chars[i2++] = (char)((uc >>> 10) + 55232);
                                    chars[i2] = (char)((uc & 0x3FF) + 56320);
                                    break;
                                }
                                throw new JSONException("malformed input around byte " + offset);
                            }
                        }
                    }
                }
                ++i2;
            }
            str = new String(chars);
        } else {
            str = ascii ? new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.US_ASCII) : new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
        }
        byte b = this.bytes[++offset];
        while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
            b = this.bytes[++offset];
        }
        if (b == 44) {
            this.offset = offset + 1;
            this.next();
        } else {
            this.offset = offset + 1;
            this.ch = (char)b;
        }
        this.stringValue = str;
    }

    @Override
    public boolean skipName() {
        byte c;
        if (this.ch != '\"') {
            throw new JSONException("not support unquoted name");
        }
        int offset = this.offset;
        while (true) {
            if ((c = this.bytes[offset]) == 92) {
                offset += 2;
                continue;
            }
            if (c == 34) {
                c = this.bytes[++offset];
                while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                    c = this.bytes[++offset];
                }
                if (c != 58) {
                    throw new JSONException("syntax error, expect ',', but '" + c + "'");
                }
                c = this.bytes[++offset];
                while (c <= 32 && (1L << c & 0x100003700L) != 0L) {
                    c = this.bytes[++offset];
                }
                break;
            }
            ++offset;
        }
        this.offset = offset + 1;
        this.ch = (char)c;
        return true;
    }

    @Override
    public void skipValue() {
        block0 : switch (this.ch) {
            case '[': {
                this.next();
                int i = 0;
                while (true) {
                    if (this.ch == ']') {
                        this.next();
                        break block0;
                    }
                    if (i != 0 && !this.comma) {
                        throw new JSONValidException("offset " + this.offset);
                    }
                    this.comma = false;
                    this.skipValue();
                    ++i;
                }
            }
            case '{': {
                this.next();
                while (true) {
                    if (this.ch == '}') {
                        this.next();
                        break block0;
                    }
                    this.skipName();
                    this.skipValue();
                }
            }
            case '\"': {
                this.skipString();
                break;
            }
            case '+': 
            case '-': 
            case '.': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': 
            case 'f': 
            case 'n': 
            case 't': {
                do {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        break block0;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                    if (this.ch == '}' || this.ch == ']' || this.ch == '{' || this.ch == '[') break block0;
                } while (this.ch != ',');
                this.comma = true;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = (char)this.bytes[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = (char)this.bytes[this.offset];
                }
                ++this.offset;
                break;
            }
            default: {
                throw new JSONException("TODO : " + this.ch);
            }
        }
        if (this.ch == ',') {
            this.comma = true;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            this.ch = (char)this.bytes[this.offset];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = (char)this.bytes[this.offset];
            }
            ++this.offset;
        } else if (!this.comma && this.ch != '}' && this.ch != ']' && this.ch != '\u001a') {
            throw new JSONValidException("offset " + this.offset);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public String getString() {
        if (this.stringValue != null) {
            return this.stringValue;
        }
        length = this.nameEnd - this.nameBegin;
        if (!this.nameEscape) {
            return new String(this.bytes, this.nameBegin, length, this.nameAscii != false ? StandardCharsets.US_ASCII : StandardCharsets.UTF_8);
        }
        chars = new char[this.nameLength];
        offset = this.nameBegin;
        i = 0;
        while (true) {
            block18: {
                block17: {
                    if ((c = this.bytes[offset]) >= '\u0000') break block17;
                    switch ((c & 255) >> 4) {
                        case 12: 
                        case 13: {
                            char2 = this.bytes[offset + 1];
                            if ((char2 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            c = (char)((c & 31) << 6 | char2 & 63);
                            offset += 2;
                            break;
                        }
                        case 14: {
                            char2 = this.bytes[offset + 1];
                            char3 = this.bytes[offset + 2];
                            if ((char2 & 192) != 128 || (char3 & 192) != 128) {
                                throw new JSONException("malformed input around byte " + (offset + 2));
                            }
                            c = (char)((c & 15) << 12 | (char2 & 63) << 6 | (char3 & 63) << 0);
                            offset += 3;
                            break;
                        }
                        default: {
                            if (c >> 3 != -2) ** GOTO lbl42
                            v0 = ++offset;
                            c2 = this.bytes[v0];
                            v1 = ++offset;
                            c3 = this.bytes[v1];
                            v2 = ++offset;
                            ++offset;
                            c4 = this.bytes[v2];
                            uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 3678080);
                            if ((c2 & 192) != 128 || (c3 & 192) != 128 || (c4 & 192) != 128 || uc < 65536 || uc >= 0x110000) {
                                throw new JSONException("malformed input around byte " + offset);
                            }
                            chars[i++] = (char)((uc >>> 10) + 55232);
                            chars[i] = (char)((uc & 1023) + 56320);
                            break block18;
lbl42:
                            // 1 sources

                            c = (char)(c & 255);
                            ++offset;
                        }
                    }
                    chars[i] = c;
                    break block18;
                }
                if (c == '\\') {
                    c = (char)this.bytes[++offset];
                    switch (c) {
                        case 'u': {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            c3 = this.bytes[++offset];
                            c4 = this.bytes[++offset];
                            c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                            break;
                        }
                        case 'x': {
                            c1 = this.bytes[++offset];
                            c2 = this.bytes[++offset];
                            c = JSONReaderUTF8.char2(c1, c2);
                            break;
                        }
                        case '\"': 
                        case '\\': {
                            break;
                        }
                        default: {
                            c = JSONReaderUTF8.char1(c);
                            break;
                        }
                    }
                } else if (c == '\"') break;
                chars[i] = c;
                ++offset;
            }
            ++i;
        }
        this.stringValue = new String(chars);
        return this.stringValue;
    }

    protected void skipString() {
        char ch;
        block11: {
            char quote = this.ch;
            while (this.offset + 4 < this.end && this.offset + 4 < this.bytes.length) {
                byte b0 = this.bytes[this.offset];
                byte b1 = this.bytes[this.offset + 1];
                byte b2 = this.bytes[this.offset + 2];
                byte b3 = this.bytes[this.offset + 3];
                if (b0 == 92 || b1 == 92 || b2 == 92 || b3 == 92 || b0 == 34 || b1 == 34 || b2 == 34 || b3 == 34) break;
                this.offset += 4;
            }
            ch = this.bytes[this.offset++];
            while (true) {
                if (ch == '\\') {
                    if ((ch = this.bytes[this.offset++]) == '\\' || ch == '\"') {
                        ch = this.bytes[this.offset++];
                        continue;
                    }
                    if (ch == 'u') {
                        this.offset += 4;
                        ch = this.bytes[this.offset++];
                        continue;
                    }
                    JSONReaderUTF8.char1(ch);
                    continue;
                }
                if (ch == quote) {
                    ch = this.offset < this.end ? this.bytes[this.offset++] : (char)'\u001a';
                    break block11;
                }
                if (this.offset >= this.end) break;
                ch = this.bytes[this.offset++];
            }
            ch = '\u001a';
        }
        while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
            ch = this.bytes[this.offset++];
        }
        if (ch == ',') {
            this.comma = true;
            if (this.offset >= this.end) {
                this.ch = (char)26;
                return;
            }
            ch = this.bytes[this.offset];
            while (ch <= ' ' && (1L << ch & 0x100003700L) != 0L) {
                ++this.offset;
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    return;
                }
                ch = this.bytes[this.offset];
            }
            ++this.offset;
        }
        this.ch = ch;
    }

    @Override
    public void skipLineComment() {
        while (true) {
            if (this.ch == '\n') {
                ++this.offset;
                if (this.offset >= this.length) {
                    this.ch = (char)26;
                    return;
                }
                this.ch = (char)this.bytes[this.offset];
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    ++this.offset;
                    if (this.offset >= this.length) {
                        this.ch = (char)26;
                        return;
                    }
                    this.ch = (char)this.bytes[this.offset];
                }
                ++this.offset;
                break;
            }
            ++this.offset;
            if (this.offset >= this.length) {
                this.ch = (char)26;
                return;
            }
            this.ch = (char)this.bytes[this.offset];
        }
    }

    @Override
    public String readString() {
        if (this.ch == '\"' || this.ch == '\'') {
            String str;
            int offset;
            char quote = this.ch;
            int start = offset = this.offset;
            boolean ascii = true;
            this.valueEscape = false;
            int i = 0;
            while (true) {
                byte c;
                if ((c = this.bytes[offset]) == 92) {
                    this.valueEscape = true;
                    c = this.bytes[++offset];
                    switch (c) {
                        case 117: {
                            offset += 4;
                            break;
                        }
                        case 120: {
                            offset += 2;
                            break;
                        }
                    }
                    ++offset;
                } else if (c >= 0) {
                    if (c == quote) break;
                    ++offset;
                } else {
                    switch ((c & 0xFF) >> 4) {
                        case 12: 
                        case 13: {
                            offset += 2;
                            ascii = false;
                            break;
                        }
                        case 14: {
                            offset += 3;
                            ascii = false;
                            break;
                        }
                        default: {
                            if (c >> 3 == -2) {
                                offset += 4;
                                ++i;
                                ascii = false;
                                break;
                            }
                            throw new JSONException("malformed input around byte " + offset);
                        }
                    }
                }
                ++i;
            }
            int valueLength = i;
            if (this.valueEscape) {
                char[] chars = new char[valueLength];
                offset = start;
                int i2 = 0;
                while (true) {
                    char c;
                    if ((c = this.bytes[offset]) == '\\') {
                        c = this.bytes[++offset];
                        switch (c) {
                            case 'u': {
                                byte c1 = this.bytes[++offset];
                                byte c2 = this.bytes[++offset];
                                byte c3 = this.bytes[++offset];
                                byte c4 = this.bytes[++offset];
                                c = JSONReaderUTF8.char4(c1, c2, c3, c4);
                                break;
                            }
                            case 'x': {
                                byte c1 = this.bytes[++offset];
                                byte c2 = this.bytes[++offset];
                                c = JSONReaderUTF8.char2(c1, c2);
                                break;
                            }
                            case '\"': 
                            case '\\': {
                                break;
                            }
                            default: {
                                c = JSONReaderUTF8.char1(c);
                            }
                        }
                        chars[i2] = c;
                        ++offset;
                    } else {
                        if (c == '\"') break;
                        if (c >= '\u0000') {
                            chars[i2] = c;
                            ++offset;
                        } else {
                            switch ((c & 0xFF) >> 4) {
                                case 12: 
                                case 13: {
                                    int n = ++offset;
                                    ++offset;
                                    byte c2 = this.bytes[n];
                                    chars[i2] = (char)((c & 0x1F) << 6 | c2 & 0x3F);
                                    break;
                                }
                                case 14: {
                                    int n = ++offset;
                                    byte c2 = this.bytes[n];
                                    int n2 = ++offset;
                                    ++offset;
                                    byte c3 = this.bytes[n2];
                                    chars[i2] = (char)((c & 0xF) << 12 | (c2 & 0x3F) << 6 | (c3 & 0x3F) << 0);
                                    break;
                                }
                                default: {
                                    byte c3;
                                    byte c2;
                                    if (c >> 3 == -2) {
                                        int n = ++offset;
                                        c2 = this.bytes[n];
                                        int n3 = ++offset;
                                        c3 = this.bytes[n3];
                                        int n4 = ++offset;
                                        ++offset;
                                        byte c4 = this.bytes[n4];
                                        int uc = c << 18 ^ c2 << 12 ^ c3 << 6 ^ (c4 ^ 0x381F80);
                                        if ((c2 & 0xC0) != 128 || (c3 & 0xC0) != 128 || (c4 & 0xC0) != 128 || uc < 65536 || uc >= 0x110000) {
                                            throw new JSONException("malformed input around byte " + offset);
                                        }
                                        chars[i2++] = (char)((uc >>> 10) + 55232);
                                        chars[i2] = (char)((uc & 0x3FF) + 56320);
                                        break;
                                    }
                                    throw new JSONException("malformed input around byte " + offset);
                                }
                            }
                        }
                    }
                    ++i2;
                }
                str = new String(chars);
            } else if (ascii) {
                if (JDKUtils.JVM_VERSION == 8) {
                    int strlen = offset - this.offset;
                    char[] chars = new char[strlen];
                    for (int i3 = 0; i3 < strlen; ++i3) {
                        chars[i3] = (char)this.bytes[this.offset + i3];
                    }
                    str = new String(chars);
                } else {
                    str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.US_ASCII);
                }
            } else {
                str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
            }
            if ((this.context.features & JSONReader.Feature.TrimString.mask) != 0L) {
                str = str.trim();
            }
            if (offset + 1 == this.end) {
                this.offset = this.end;
                this.ch = (char)26;
                return str;
            }
            byte b = this.bytes[++offset];
            while (b <= 32 && (1L << b & 0x100003700L) != 0L) {
                b = this.bytes[++offset];
            }
            if (b == 44) {
                this.offset = offset + 1;
                this.next();
            } else {
                this.offset = offset + 1;
                this.ch = (char)b;
            }
            return str;
        }
        switch (this.ch) {
            case '[': {
                return this.toString(this.readArray());
            }
            case '{': {
                return this.toString(this.readObject());
            }
            case '+': 
            case '-': 
            case '0': 
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '5': 
            case '6': 
            case '7': 
            case '8': 
            case '9': {
                this.readNumber0();
                Number number = this.getNumber();
                return number.toString();
            }
            case 'f': 
            case 't': {
                this.boolValue = this.readBoolValue();
                return this.boolValue ? "true" : "false";
            }
            case 'n': {
                this.readNull();
                return null;
            }
        }
        throw new JSONException("TODO : " + this.ch);
    }

    @Override
    public void readNumber0() {
        int digit;
        int multmin;
        int limit;
        this.wasNull = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == quote) {
                this.ch = this.offset == this.end ? (char)26 : (char)this.bytes[this.offset++];
                this.nextIfMatch(',');
                this.wasNull = true;
                return;
            }
        }
        int start = this.offset;
        if (this.ch == '-') {
            limit = Integer.MIN_VALUE;
            multmin = -214748364;
            this.negative = true;
            this.ch = (char)this.bytes[this.offset++];
        } else {
            limit = -2147483647;
            multmin = -214748364;
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                digit = this.ch - 48;
                this.mag3 *= 10;
                if (this.mag3 < multmin || this.mag3 < limit + digit) {
                    intOverflow = true;
                } else {
                    this.mag3 -= digit;
                    if (this.mag3 < multmin) {
                        intOverflow = true;
                    }
                }
            }
            if (this.offset == this.end) {
                this.ch = (char)26;
                ++this.offset;
                break;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    digit = this.ch - 48;
                    this.mag3 *= 10;
                    if (this.mag3 < multmin || this.mag3 < limit + digit) {
                        intOverflow = true;
                    } else {
                        this.mag3 -= digit;
                        if (this.mag3 < multmin) {
                            intOverflow = true;
                        }
                    }
                }
                this.scale = (byte)(this.scale + 1);
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    ++this.offset;
                    break;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        if (intOverflow) {
            int numDigits;
            int numStart = this.negative ? start : start - 1;
            int n = numDigits = this.scale > 0 ? this.offset - 2 - numStart : this.offset - 1 - numStart;
            if (numDigits > 38) {
                this.valueType = (byte)8;
                this.stringValue = new String(this.bytes, numStart, this.offset - 1 - numStart);
            } else {
                this.bigInt(this.bytes, numStart, this.offset - 1);
            }
        } else {
            this.mag3 = -this.mag3;
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)this.bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)this.bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 512) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                if (this.offset == this.end) {
                    this.ch = (char)26;
                    break;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (byte)expValue;
            this.valueType = (byte)2;
        }
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 108 && this.bytes[this.offset++] == 108) {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)this.bytes[this.offset++];
                    }
                }
            } else if (this.ch == 't') {
                if (this.bytes[this.offset++] == 114 && this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 101) {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)this.bytes[this.offset++];
                    }
                }
            } else if (this.ch == 'f') {
                if (this.bytes[this.offset++] == 97 && this.bytes[this.offset++] == 108 && this.bytes[this.offset++] == 115 && this.bytes[this.offset++] == 101) {
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    if (this.offset == this.end) {
                        this.ch = (char)26;
                        ++this.offset;
                    } else {
                        this.ch = (char)this.bytes[this.offset++];
                    }
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        if (this.ch == 'L' || this.ch == 'F' || this.ch == 'D') {
            this.ch = this.offset >= this.end ? (char)26 : (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
    }

    @Override
    public void readNumber(ValueConsumer consumer, boolean quoted) {
        int mag3_10;
        this.wasNull = false;
        this.boolValue = false;
        this.mag0 = 0;
        this.mag1 = 0;
        this.mag2 = 0;
        this.mag3 = 0;
        this.negative = false;
        this.exponent = 0;
        this.scale = 0;
        char quote = '\u0000';
        if (this.ch == '\"' || this.ch == '\'') {
            quote = this.ch;
            this.ch = (char)this.bytes[this.offset++];
        }
        int start = this.offset;
        if (this.ch == '-') {
            this.negative = true;
            this.ch = (char)this.bytes[this.offset++];
        }
        boolean intOverflow = false;
        this.valueType = 1;
        while (this.ch >= '0' && this.ch <= '9') {
            if (!intOverflow) {
                mag3_10 = this.mag3 * 10 + (this.ch - 48);
                if (mag3_10 < this.mag3) {
                    intOverflow = true;
                } else {
                    this.mag3 = mag3_10;
                }
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == '.') {
            this.valueType = (byte)2;
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch >= '0' && this.ch <= '9') {
                if (!intOverflow) {
                    mag3_10 = this.mag3 * 10 + (this.ch - 48);
                    if (mag3_10 < this.mag3) {
                        intOverflow = true;
                    } else {
                        this.mag3 = mag3_10;
                    }
                }
                this.scale = (byte)(this.scale + 1);
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        if (intOverflow) {
            int numStart = this.negative ? start : start - 1;
            this.bigInt(this.bytes, numStart, this.offset - 1);
        }
        if (this.ch == 'e' || this.ch == 'E') {
            boolean negativeExp = false;
            int expValue = 0;
            this.ch = (char)this.bytes[this.offset++];
            if (this.ch == '-') {
                negativeExp = true;
                this.ch = (char)this.bytes[this.offset++];
            } else if (this.ch == '+') {
                this.ch = (char)this.bytes[this.offset++];
            }
            while (this.ch >= '0' && this.ch <= '9') {
                int byteVal = this.ch - 48;
                if ((expValue = expValue * 10 + byteVal) > 512) {
                    throw new JSONException("too large exp value : " + expValue);
                }
                this.ch = (char)this.bytes[this.offset++];
            }
            if (negativeExp) {
                expValue = -expValue;
            }
            this.exponent = (byte)expValue;
            this.valueType = (byte)2;
        }
        int len = this.offset - start;
        if (this.offset == start) {
            if (this.ch == 'n') {
                if (this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 108 && this.bytes[this.offset++] == 108) {
                    this.wasNull = true;
                    this.valueType = (byte)5;
                    this.ch = (char)this.bytes[this.offset++];
                }
            } else if (this.ch == 't') {
                if (this.bytes[this.offset++] == 114 && this.bytes[this.offset++] == 117 && this.bytes[this.offset++] == 101) {
                    this.boolValue = true;
                    this.valueType = (byte)4;
                    this.ch = (char)this.bytes[this.offset++];
                }
            } else if (this.ch == 'f') {
                if (this.bytes[this.offset++] == 97 && this.bytes[this.offset++] == 108 && this.bytes[this.offset++] == 115 && this.bytes[this.offset++] == 101) {
                    this.boolValue = false;
                    this.valueType = (byte)4;
                    this.ch = (char)this.bytes[this.offset++];
                }
            } else {
                if (this.ch == '{' && quote == '\u0000') {
                    this.complex = this.readObject();
                    this.valueType = (byte)6;
                    return;
                }
                if (this.ch == '[' && quote == '\u0000') {
                    this.complex = this.readArray();
                    this.valueType = (byte)7;
                    return;
                }
            }
        }
        if (quote != '\u0000') {
            if (this.ch != quote) {
                --this.offset;
                this.ch = quote;
                this.readString0();
                this.valueType = (byte)3;
                return;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            if (this.offset >= this.end) {
                this.ch = (char)26;
            } else {
                while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                    if (this.offset >= this.end) {
                        this.ch = (char)26;
                        continue;
                    }
                    this.ch = (char)this.bytes[this.offset++];
                }
            }
        }
        if (!(quoted || this.valueType != 1 && this.valueType != 2)) {
            consumer.accept(this.bytes, start - 1, len);
            return;
        }
        if (this.valueType == 1) {
            if (this.mag1 == 0 && this.mag1 == 0 && this.mag2 == 0 && this.mag3 != Integer.MIN_VALUE) {
                int intValue = this.negative ? -this.mag3 : this.mag3;
                consumer.accept(intValue);
                return;
            }
            if (this.mag1 == 0 && this.mag1 == 0) {
                long v3 = (long)this.mag3 & 0xFFFFFFFFL;
                long v2 = (long)this.mag2 & 0xFFFFFFFFL;
                if (v2 >= Integer.MIN_VALUE && v2 <= Integer.MAX_VALUE) {
                    long v23 = (v2 << 32) + v3;
                    long longValue = this.negative ? -v23 : v23;
                    consumer.accept(longValue);
                    return;
                }
            }
        }
        Number number = this.getNumber();
        consumer.accept(number);
    }

    @Override
    public boolean readIfNull() {
        if (this.ch == 'n' && this.bytes[this.offset] == 117 && this.bytes[this.offset + 1] == 108 && this.bytes[this.offset + 2] == 108) {
            this.ch = this.offset + 3 == this.end ? (char)26 : (char)this.bytes[this.offset + 3];
            this.offset += 4;
        } else {
            return false;
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
        return true;
    }

    @Override
    public void readNull() {
        if (this.bytes[this.offset] == 117 && this.bytes[this.offset + 1] == 108 && this.bytes[this.offset + 2] == 108) {
            this.ch = this.offset + 3 == this.end ? (char)26 : (char)this.bytes[this.offset + 3];
            this.offset += 4;
        } else {
            throw new JSONException("json syntax error, not match null" + this.offset);
        }
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            if (this.offset >= this.end) {
                this.ch = (char)26;
                continue;
            }
            this.ch = (char)this.bytes[this.offset++];
        }
        if (this.ch == ',') {
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        }
    }

    @Override
    public int getStringLength() {
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char quote = this.ch;
        int len = 0;
        int i = this.offset;
        while (i < this.end && this.bytes[i] != quote) {
            ++i;
            ++len;
        }
        return len;
    }

    @Override
    protected ZonedDateTime readZonedDateTimeX(int len) {
        ZoneId zoneId;
        int zoneIdBegin;
        int S8;
        char S7;
        char S6;
        char S5;
        char S4;
        char S3;
        char S2;
        char S1;
        char S0;
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        char d0;
        char m1;
        char m0;
        char y3;
        char y2;
        char y1;
        char y0;
        char c20;
        if (this.ch != '\"' && this.ch != '\'') {
            throw new JSONException("date only support string input");
        }
        char quote = this.ch;
        if (len < 19) {
            return null;
        }
        char c0 = (char)this.bytes[this.offset + 0];
        char c1 = (char)this.bytes[this.offset + 1];
        char c2 = (char)this.bytes[this.offset + 2];
        char c3 = (char)this.bytes[this.offset + 3];
        char c4 = (char)this.bytes[this.offset + 4];
        char c5 = (char)this.bytes[this.offset + 5];
        char c6 = (char)this.bytes[this.offset + 6];
        char c7 = (char)this.bytes[this.offset + 7];
        char c8 = (char)this.bytes[this.offset + 8];
        char c9 = (char)this.bytes[this.offset + 9];
        char c10 = (char)this.bytes[this.offset + 10];
        char c11 = (char)this.bytes[this.offset + 11];
        char c12 = (char)this.bytes[this.offset + 12];
        char c13 = (char)this.bytes[this.offset + 13];
        char c14 = (char)this.bytes[this.offset + 14];
        char c15 = (char)this.bytes[this.offset + 15];
        char c16 = (char)this.bytes[this.offset + 16];
        char c17 = (char)this.bytes[this.offset + 17];
        char c18 = (char)this.bytes[this.offset + 18];
        int c19 = (char)(len == 19 ? 32 : (char)this.bytes[this.offset + 19]);
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        int c28 = 48;
        int c29 = 0;
        switch (len) {
            case 19: 
            case 20: {
                c20 = '\u0000';
                break;
            }
            case 21: {
                c20 = (char)this.bytes[this.offset + 20];
                break;
            }
            case 22: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                break;
            }
            case 23: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                break;
            }
            case 24: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                break;
            }
            case 25: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                break;
            }
            case 26: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                break;
            }
            case 27: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                c26 = (char)this.bytes[this.offset + 26];
                break;
            }
            case 28: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                c26 = (char)this.bytes[this.offset + 26];
                c27 = (char)this.bytes[this.offset + 27];
                break;
            }
            case 29: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                c26 = (char)this.bytes[this.offset + 26];
                c27 = (char)this.bytes[this.offset + 27];
                c28 = (char)this.bytes[this.offset + 28];
                break;
            }
            default: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                c26 = (char)this.bytes[this.offset + 26];
                c27 = (char)this.bytes[this.offset + 27];
                c28 = (char)this.bytes[this.offset + 28];
                c29 = (char)this.bytes[this.offset + 29];
            }
        }
        boolean isTimeZone = false;
        if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 91 && c19 != 90 && c19 != 43 && c19 != 45 && c19 != 32)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 19;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 21 && c21 != '[' && c21 != '+' && c21 != '-' && c21 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 21;
            isTimeZone = c21 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 22 && c22 != '[' && c22 != '+' && c22 != '-' && c22 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 22;
            isTimeZone = c22 == '|';
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == 'Z' && c17 == '[' && len == 22 && c21 == ']') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = '0';
            s1 = '0';
            S0 = '0';
            S1 = '0';
            S2 = '0';
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            isTimeZone = true;
            zoneIdBegin = 17;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 23 && c23 != '[' && c23 != '|' && c23 != '+' && c23 != '-' && c23 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = c23 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 24 && c24 != '[' && c24 != '|' && c24 != '+' && c24 != '-' && c24 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 24;
            isTimeZone = c24 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 25 && c25 != '[' && c25 != '|' && c25 != '+' && c25 != '-' && c25 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 25;
            isTimeZone = c25 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 26 && c26 != '[' && c26 != '|' && c26 != '+' && c26 != '-' && c26 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 26;
            isTimeZone = c26 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 27 && c27 != '[' && c27 != '|' && c27 != '+' && c27 != '-' && c27 != 'Z')) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 27;
            isTimeZone = c27 == '|';
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 28 && c28 != 91 && c28 != 124 && c28 != 43 && c28 != 45 && c28 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = 48;
            zoneIdBegin = 28;
            isTimeZone = c28 == 124;
        } else if (!(c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != 46 || len != 29 && c29 != 91 && c29 != 124 && c29 != 43 && c29 != 45 && c29 != 90)) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = c23;
            S4 = c24;
            S5 = c25;
            S6 = c26;
            S7 = c27;
            S8 = c28;
            zoneIdBegin = 29;
            isTimeZone = c29 == 124;
        } else if (c4 == '-' && c7 == '-' && (c10 == ' ' || c10 == 'T') && c13 == ':' && c16 == ':' && c19 == 46 && len == 23) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = c20;
            S1 = c21;
            S2 = c22;
            S3 = '0';
            S4 = '0';
            S5 = '0';
            S6 = '0';
            S7 = '0';
            S8 = 48;
            zoneIdBegin = 23;
            isTimeZone = false;
        } else {
            return null;
        }
        char first = (char)this.bytes[this.offset + zoneIdBegin];
        LocalDateTime ldt = JSONReaderUTF8.getLocalDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, (char)S8);
        if (isTimeZone) {
            String tzStr = new String(this.bytes, this.offset + zoneIdBegin, len - zoneIdBegin);
            TimeZone timeZone = TimeZone.getTimeZone(tzStr);
            zoneId = timeZone.toZoneId();
        } else if (first == 'Z') {
            zoneId = UTC;
        } else {
            String zoneIdStr = first == '+' || first == '-' ? new String(this.bytes, this.offset + zoneIdBegin, len - zoneIdBegin, StandardCharsets.US_ASCII) : (first == ' ' ? new String(this.bytes, this.offset + zoneIdBegin + 1, len - zoneIdBegin - 1, StandardCharsets.US_ASCII) : (zoneIdBegin < len ? new String(this.bytes, this.offset + zoneIdBegin + 1, len - zoneIdBegin - 2, StandardCharsets.US_ASCII) : null));
            zoneId = this.getZoneId(ldt, zoneIdStr);
        }
        ZonedDateTime zdt = ldt.atZone(zoneId);
        if (zdt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return zdt;
    }

    @Override
    public LocalDateTime readLocalDate8() {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("localDate only support string input");
        }
        char c0 = (char)this.bytes[this.offset + 0];
        char c1 = (char)this.bytes[this.offset + 1];
        char c2 = (char)this.bytes[this.offset + 2];
        char c3 = (char)this.bytes[this.offset + 3];
        int c4 = this.bytes[this.offset + 4];
        char c5 = (char)this.bytes[this.offset + 5];
        int c6 = this.bytes[this.offset + 6];
        char c7 = (char)this.bytes[this.offset + 7];
        if (c4 == 45 && c6 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = 48;
            d1 = c7;
        } else {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c4;
            m1 = c5;
            d0 = c6;
            d1 = c7;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 9;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate9() {
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("localDate only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        if (c4 == 45 && c6 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c5;
            d0 = c7;
            d1 = (char)c8;
        } else if (c4 == 45 && c7 == 45) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c5;
            m1 = (char)c6;
            d0 = 48;
            d1 = (char)c8;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 10;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    public LocalDateTime readLocalDate10() {
        byte d1;
        byte d0;
        byte m1;
        byte m0;
        byte y3;
        byte y2;
        byte y1;
        byte y0;
        if (this.ch != '\"') {
            throw new JSONException("localDate only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        if (c4 == 45 && c7 == 45) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c4 == 47 && c7 == 47) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
        } else if (c2 == 46 && c5 == 46) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else if (c2 == 45 && c5 == 45) {
            d0 = c0;
            d1 = c1;
            m0 = c3;
            m1 = c4;
            y0 = c6;
            y1 = c7;
            y2 = c8;
            y3 = c9;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (year == 0 && month == 0 && dom == 0) {
            return null;
        }
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, 0, 0, 0);
        this.offset += 11;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime17() {
        int s1;
        int s0;
        int i1;
        int i0;
        int h1;
        int h0;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        byte c10 = this.bytes[this.offset + 10];
        byte c11 = this.bytes[this.offset + 11];
        byte c12 = this.bytes[this.offset + 12];
        byte c13 = this.bytes[this.offset + 13];
        byte c14 = this.bytes[this.offset + 14];
        byte c15 = this.bytes[this.offset + 15];
        byte c16 = this.bytes[this.offset + 16];
        if (c4 == 45 && c7 == 45 && c10 == 84 && c13 == 58 && c16 == 90) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = c5;
            m1 = (char)c6;
            d0 = c8;
            d1 = (char)c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = 48;
            s1 = 48;
        } else if (c4 == 45 && c6 == 45 && c8 == 32 && c11 == 58 && c14 == 58) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c5;
            d0 = 48;
            d1 = (char)c7;
            h0 = (char)c9;
            h1 = (char)c10;
            i0 = (char)c12;
            i1 = (char)c13;
            s0 = (char)c15;
            s1 = (char)c16;
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c9 == -26 && c10 == -100 && c11 == -120 && c14 == -26 && c15 == -105 && c16 == -91) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c7;
            m1 = (char)c8;
            d0 = (char)c12;
            d1 = (char)c13;
            h0 = 48;
            h1 = 48;
            i0 = 48;
            i1 = 48;
            s0 = 48;
            s1 = 48;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 18;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalTime readLocalTime8() {
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        if (c2 != 58 || c5 != 58) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        this.offset += 9;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, seccond);
    }

    @Override
    protected LocalTime readLocalTime11() {
        int millis;
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        byte c10 = this.bytes[this.offset + 10];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        int m2 = 48;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= 48 && m0 <= 57 && m1 >= 48 && m1 <= 57 && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 12;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalTime readLocalTime10() {
        int millis;
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        int m1 = 48;
        int m2 = 48;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= 48 && m0 <= 57 && m1 >= 48 && m1 <= 57 && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 11;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalTime readLocalTime12() {
        int millis;
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        byte c10 = this.bytes[this.offset + 10];
        byte c11 = this.bytes[this.offset + 11];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 >= 48 && m0 <= 57 && m1 >= 48 && m1 <= 57 && m2 >= 48 && m2 <= 57) {
            millis = (m0 - 48) * 100 + (m1 - 48) * 10 + (m2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        this.offset += 13;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalTime readLocalTime18() {
        if (this.ch != '\"') {
            throw new JSONException("localTime only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        byte c10 = this.bytes[this.offset + 10];
        byte c11 = this.bytes[this.offset + 11];
        byte c12 = this.bytes[this.offset + 12];
        byte c13 = this.bytes[this.offset + 13];
        byte c14 = this.bytes[this.offset + 14];
        byte c15 = this.bytes[this.offset + 15];
        byte c16 = this.bytes[this.offset + 16];
        byte c17 = this.bytes[this.offset + 17];
        if (c2 != 58 || c5 != 58 || c8 != 46) {
            return null;
        }
        byte h0 = c0;
        byte h1 = c1;
        byte i0 = c3;
        byte i1 = c4;
        byte s0 = c6;
        byte s1 = c7;
        byte m0 = c9;
        byte m1 = c10;
        byte m2 = c11;
        byte m3 = c12;
        byte m4 = c13;
        byte m5 = c14;
        byte m6 = c15;
        byte m7 = c16;
        byte m8 = c17;
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int seccond = (s0 - 48) * 10 + (s1 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57 || m2 < 48 || m2 > 57 || m3 < 48 || m3 > 57 || m4 < 48 || m4 > 57 || m5 < 48 || m5 > 57 || m6 < 48 || m6 > 57 || m7 < 48 || m7 > 57 || m8 < 48 || m8 > 57) {
            return null;
        }
        int millis = (m0 - 48) * 100000000 + (m1 - 48) * 10000000 + (m2 - 48) * 1000000 + (m3 - 48) * 100000 + (m4 - 48) * 10000 + (m5 - 48) * 1000 + (m6 - 48) * 100 + (m7 - 48) * 10 + (m8 - 48);
        this.offset += 19;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return LocalTime.of(hour, minute, seccond, millis);
    }

    @Override
    protected LocalDateTime readLocalDateTime16() {
        int i1;
        int i0;
        int h1;
        int h0;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        byte c10 = this.bytes[this.offset + 10];
        byte c11 = this.bytes[this.offset + 11];
        byte c12 = this.bytes[this.offset + 12];
        byte c13 = this.bytes[this.offset + 13];
        byte c14 = this.bytes[this.offset + 14];
        byte c15 = this.bytes[this.offset + 15];
        if (c4 == 45 && c7 == 45 && (c10 == 84 || c10 == 32) && c13 == 58) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = c5;
            m1 = (char)c6;
            d0 = c8;
            d1 = (char)c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c8 == -26 && c9 == -100 && c10 == -120 && c13 == -26 && c14 == -105 && c15 == -91) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = 48;
            m1 = (char)c7;
            d0 = (char)c11;
            d1 = (char)c12;
            h0 = 48;
            h1 = 48;
            i0 = 48;
            i1 = 48;
        } else if (c4 == -27 && c5 == -71 && c6 == -76 && c9 == -26 && c10 == -100 && c11 == -120 && c13 == -26 && c14 == -105 && c15 == -91) {
            y0 = (char)c0;
            y1 = (char)c1;
            y2 = (char)c2;
            y3 = (char)c3;
            m0 = (char)c7;
            m1 = (char)c8;
            d0 = 48;
            d1 = (char)c12;
            h0 = 48;
            h1 = 48;
            i0 = 48;
            i1 = 48;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        int second = 0;
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 17;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime18() {
        char s1;
        char s0;
        char i1;
        char i0;
        char h1;
        char h0;
        char d1;
        int d0;
        char m1;
        int m0;
        char y3;
        char y2;
        char y1;
        char y0;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        char c0 = (char)this.bytes[this.offset + 0];
        char c1 = (char)this.bytes[this.offset + 1];
        char c2 = (char)this.bytes[this.offset + 2];
        char c3 = (char)this.bytes[this.offset + 3];
        char c4 = (char)this.bytes[this.offset + 4];
        char c5 = (char)this.bytes[this.offset + 5];
        char c6 = (char)this.bytes[this.offset + 6];
        int c7 = this.bytes[this.offset + 7];
        char c8 = (char)this.bytes[this.offset + 8];
        char c9 = (char)this.bytes[this.offset + 9];
        char c10 = (char)this.bytes[this.offset + 10];
        char c11 = (char)this.bytes[this.offset + 11];
        char c12 = (char)this.bytes[this.offset + 12];
        char c13 = (char)this.bytes[this.offset + 13];
        char c14 = (char)this.bytes[this.offset + 14];
        char c15 = (char)this.bytes[this.offset + 15];
        char c16 = (char)this.bytes[this.offset + 16];
        char c17 = (char)this.bytes[this.offset + 17];
        if (c4 == '-' && c6 == '-' && c9 == ' ' && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = 48;
            m1 = c5;
            d0 = c7;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else if (c4 == '-' && c7 == 45 && c9 == ' ' && c12 == ':' && c15 == ':') {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = 48;
            d1 = c8;
            h0 = c10;
            h1 = c11;
            i0 = c13;
            i1 = c14;
            s0 = c16;
            s1 = c17;
        } else {
            return null;
        }
        if (y0 < '0' || y0 > '9' || y1 < '0' || y1 > '9' || y2 < '0' || y2 > '9' || y3 < '0' || y3 > '9') {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < '0' || m1 > '9') {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < '0' || d1 > '9') {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < '0' || h0 > '9' || h1 < '0' || h1 > '9') {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < '0' || i0 > '9' || i1 < '0' || i1 > '9') {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < '0' || s0 > '9' || s1 < '0' || s1 > '9') {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second);
        this.offset += 19;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTime19() {
        int millis;
        int S2;
        int S1;
        int S0;
        byte s1;
        byte s0;
        byte i1;
        byte i0;
        byte h1;
        byte h0;
        byte d1;
        byte d0;
        byte m1;
        byte m0;
        byte y3;
        byte y2;
        byte y1;
        byte y0;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        byte c0 = this.bytes[this.offset + 0];
        byte c1 = this.bytes[this.offset + 1];
        byte c2 = this.bytes[this.offset + 2];
        byte c3 = this.bytes[this.offset + 3];
        byte c4 = this.bytes[this.offset + 4];
        byte c5 = this.bytes[this.offset + 5];
        byte c6 = this.bytes[this.offset + 6];
        byte c7 = this.bytes[this.offset + 7];
        byte c8 = this.bytes[this.offset + 8];
        byte c9 = this.bytes[this.offset + 9];
        byte c10 = this.bytes[this.offset + 10];
        byte c11 = this.bytes[this.offset + 11];
        byte c12 = this.bytes[this.offset + 12];
        byte c13 = this.bytes[this.offset + 13];
        byte c14 = this.bytes[this.offset + 14];
        byte c15 = this.bytes[this.offset + 15];
        byte c16 = this.bytes[this.offset + 16];
        byte c17 = this.bytes[this.offset + 17];
        byte c18 = this.bytes[this.offset + 18];
        if (c4 == 45 && c7 == 45 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else if (c4 == 47 && c7 == 47 && (c10 == 32 || c10 == 84) && c13 == 58 && c16 == 58) {
            y0 = c0;
            y1 = c1;
            y2 = c2;
            y3 = c3;
            m0 = c5;
            m1 = c6;
            d0 = c8;
            d1 = c9;
            h0 = c11;
            h1 = c12;
            i0 = c14;
            i1 = c15;
            s0 = c17;
            s1 = c18;
            S0 = 48;
            S1 = 48;
            S2 = 48;
        } else {
            return null;
        }
        if (y0 < 48 || y0 > 57 || y1 < 48 || y1 > 57 || y2 < 48 || y2 > 57 || y3 < 48 || y3 > 57) {
            return null;
        }
        int year = (y0 - 48) * 1000 + (y1 - 48) * 100 + (y2 - 48) * 10 + (y3 - 48);
        if (m0 < 48 || m0 > 57 || m1 < 48 || m1 > 57) {
            return null;
        }
        int month = (m0 - 48) * 10 + (m1 - 48);
        if (d0 < 48 || d0 > 57 || d1 < 48 || d1 > 57) {
            return null;
        }
        int dom = (d0 - 48) * 10 + (d1 - 48);
        if (h0 < 48 || h0 > 57 || h1 < 48 || h1 > 57) {
            return null;
        }
        int hour = (h0 - 48) * 10 + (h1 - 48);
        if (i0 < 48 || i0 > 57 || i1 < 48 || i1 > 57) {
            return null;
        }
        int minute = (i0 - 48) * 10 + (i1 - 48);
        if (s0 < 48 || s0 > 57 || s1 < 48 || s1 > 57) {
            return null;
        }
        int second = (s0 - 48) * 10 + (s1 - 48);
        if (S0 >= 48 && S0 <= 57 && S1 >= 48 && S1 <= 57 && S2 >= 48 && S2 <= 57) {
            millis = (S0 - 48) * 100 + (S1 - 48) * 10 + (S2 - 48);
            millis *= 1000000;
        } else {
            return null;
        }
        if (year == 0 && month == 0 && dom == 0) {
            year = 1970;
            month = 1;
            dom = 1;
        }
        LocalDateTime ldt = LocalDateTime.of(year, month, dom, hour, minute, second, millis);
        this.offset += 20;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    protected LocalDateTime readLocalDateTimeX(int len) {
        char c20;
        if (this.ch != '\"') {
            throw new JSONException("date only support string input");
        }
        if (len < 21 || len > 29) {
            throw new JSONException("illeal localdatetime string : " + this.readString());
        }
        char c0 = (char)this.bytes[this.offset + 0];
        char c1 = (char)this.bytes[this.offset + 1];
        char c2 = (char)this.bytes[this.offset + 2];
        char c3 = (char)this.bytes[this.offset + 3];
        char c4 = (char)this.bytes[this.offset + 4];
        char c5 = (char)this.bytes[this.offset + 5];
        char c6 = (char)this.bytes[this.offset + 6];
        char c7 = (char)this.bytes[this.offset + 7];
        char c8 = (char)this.bytes[this.offset + 8];
        char c9 = (char)this.bytes[this.offset + 9];
        char c10 = (char)this.bytes[this.offset + 10];
        char c11 = (char)this.bytes[this.offset + 11];
        char c12 = (char)this.bytes[this.offset + 12];
        char c13 = (char)this.bytes[this.offset + 13];
        char c14 = (char)this.bytes[this.offset + 14];
        char c15 = (char)this.bytes[this.offset + 15];
        char c16 = (char)this.bytes[this.offset + 16];
        char c17 = (char)this.bytes[this.offset + 17];
        char c18 = (char)this.bytes[this.offset + 18];
        char c19 = (char)this.bytes[this.offset + 19];
        char c21 = '0';
        char c22 = '0';
        char c23 = '0';
        char c24 = '0';
        char c25 = '0';
        char c26 = '0';
        char c27 = '0';
        char c28 = '0';
        switch (len) {
            case 21: {
                c20 = (char)this.bytes[this.offset + 20];
                break;
            }
            case 22: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                break;
            }
            case 23: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                break;
            }
            case 24: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                break;
            }
            case 25: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                break;
            }
            case 26: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                break;
            }
            case 27: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                c26 = (char)this.bytes[this.offset + 26];
                break;
            }
            case 28: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                c26 = (char)this.bytes[this.offset + 26];
                c27 = (char)this.bytes[this.offset + 27];
                break;
            }
            default: {
                c20 = (char)this.bytes[this.offset + 20];
                c21 = (char)this.bytes[this.offset + 21];
                c22 = (char)this.bytes[this.offset + 22];
                c23 = (char)this.bytes[this.offset + 23];
                c24 = (char)this.bytes[this.offset + 24];
                c25 = (char)this.bytes[this.offset + 25];
                c26 = (char)this.bytes[this.offset + 26];
                c27 = (char)this.bytes[this.offset + 27];
                c28 = (char)this.bytes[this.offset + 28];
            }
        }
        if (c4 != '-' || c7 != '-' || c10 != ' ' && c10 != 'T' || c13 != ':' || c16 != ':' || c19 != '.') {
            return null;
        }
        char y0 = c0;
        char y1 = c1;
        char y2 = c2;
        char y3 = c3;
        char m0 = c5;
        char m1 = c6;
        char d0 = c8;
        char d1 = c9;
        char h0 = c11;
        char h1 = c12;
        char i0 = c14;
        char i1 = c15;
        char s0 = c17;
        char s1 = c18;
        char S0 = c20;
        char S1 = c21;
        char S2 = c22;
        char S3 = c23;
        char S4 = c24;
        char S5 = c25;
        char S6 = c26;
        char S7 = c27;
        char S8 = c28;
        LocalDateTime ldt = JSONReaderUTF16.getLocalDateTime(y0, y1, y2, y3, m0, m1, d0, d1, h0, h1, i0, i1, s0, s1, S0, S1, S2, S3, S4, S5, S6, S7, S8);
        if (ldt == null) {
            return null;
        }
        this.offset += len + 1;
        this.next();
        if (this.ch == ',') {
            this.next();
        }
        return ldt;
    }

    @Override
    public UUID readUUID() {
        if (this.ch == 'n') {
            this.readNull();
            return null;
        }
        if (this.ch != '\"') {
            throw new JSONException("syntax error, can not read uuid, position " + this.offset);
        }
        if (this.offset + 32 < this.bytes.length && this.bytes[this.offset + 32] == 34) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0);
            if ((msb1 | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 8)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 12)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 16)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 20)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28))) >= 0L) {
                this.offset += 33;
                this.ch = (char)this.bytes[this.offset++];
                if (this.ch == ',') {
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        } else if (this.offset + 36 < this.bytes.length && this.bytes[this.offset + 36] == 34) {
            long lsb4;
            long lsb3;
            long lsb2;
            long lsb1;
            long msb4;
            long msb3;
            long msb2;
            long msb1;
            char ch1 = (char)this.bytes[this.offset + 8];
            char ch2 = (char)this.bytes[this.offset + 13];
            char ch3 = (char)this.bytes[this.offset + 18];
            char ch4 = (char)this.bytes[this.offset + 23];
            if (ch1 == '-' && ch2 == '-' && ch3 == '-' && ch4 == '-' && ((msb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 0)) | (msb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 4)) | (msb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 9)) | (msb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 14)) | (lsb1 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 19)) | (lsb2 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 24)) | (lsb3 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 28)) | (lsb4 = UUIDUtils.parse4Nibbles(this.bytes, this.offset + 32))) >= 0L) {
                this.offset += 37;
                this.ch = (char)this.bytes[this.offset++];
                if (this.ch == ',') {
                    this.next();
                }
                return new UUID(msb1 << 48 | msb2 << 32 | msb3 << 16 | msb4, lsb1 << 48 | lsb2 << 32 | lsb3 << 16 | lsb4);
            }
        }
        String str = this.readString();
        return UUID.fromString(str);
    }

    @Override
    public String readPattern() {
        char c;
        if (this.ch != '/') {
            throw new JSONException("illegal pattern");
        }
        int offset = this.offset;
        int i = 0;
        while ((c = (char)this.bytes[offset]) != '/' && ++offset < this.end) {
            ++i;
        }
        String str = new String(this.bytes, this.offset, offset - this.offset, StandardCharsets.UTF_8);
        if (offset + 1 == this.end) {
            this.offset = this.end;
            this.ch = (char)26;
            return str;
        }
        char b = (char)this.bytes[++offset];
        while (b <= ' ' && (1L << b & 0x100003700L) != 0L) {
            b = (char)this.bytes[++offset];
        }
        if (b == ',') {
            this.offset = offset + 1;
            this.ch = (char)this.bytes[this.offset++];
            while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
                if (this.offset >= this.end) {
                    this.ch = (char)26;
                    continue;
                }
                this.ch = (char)this.bytes[this.offset++];
            }
        } else {
            this.offset = offset + 1;
            this.ch = b;
        }
        return str;
    }

    @Override
    public boolean isReference() {
        if (this.ch != '{') {
            return false;
        }
        int start = this.offset;
        this.ch = (char)this.bytes[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        char quote = this.ch;
        if (quote != '\"' && quote != '\'' || this.offset + 5 >= this.end) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        if (this.bytes[this.offset + 1] != 36 || this.bytes[this.offset + 2] != 114 || this.bytes[this.offset + 3] != 101 || this.bytes[this.offset + 4] != 102 || this.bytes[this.offset + 5] != quote) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.offset += 6;
        this.ch = (char)this.bytes[this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        if (this.ch != ':') {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.ch = (char)this.bytes[++this.offset];
        while (this.ch <= ' ' && (1L << this.ch & 0x100003700L) != 0L) {
            ++this.offset;
            if (this.offset >= this.length) {
                this.offset = start;
                this.ch = (char)123;
                return false;
            }
            this.ch = (char)this.bytes[this.offset];
        }
        if (this.ch != quote) {
            this.offset = start;
            this.ch = (char)123;
            return false;
        }
        this.referenceBegin = this.offset;
        this.offset = start;
        this.ch = (char)123;
        return true;
    }

    @Override
    public String readReference() {
        this.offset = this.referenceBegin;
        this.ch = (char)this.bytes[this.offset++];
        String reference = this.readString();
        return reference;
    }
}

