/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONPath;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.schema.JSONSchema;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Locale;

abstract class FieldReaderImpl<T>
implements FieldReader<T> {
    final int ordinal;
    final String fieldName;
    final Class fieldClass;
    final boolean fieldClassSerializable;
    final Type fieldType;
    final long fieldNameHash;
    final long features;
    final String format;
    final Locale locale;
    final JSONSchema schema;
    volatile ObjectReader reader;
    volatile JSONPath referenceCache;
    final Object defaultValue;

    public FieldReaderImpl(String fieldName, Type fieldType) {
        this(fieldName, fieldType, TypeUtils.getClass(fieldType), 0, 0L, null, null, null, null);
    }

    public FieldReaderImpl(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Object defaultValue) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldClass = fieldClass;
        this.fieldClassSerializable = fieldClass != null && Serializable.class.isAssignableFrom(fieldClass);
        this.features = features;
        this.fieldNameHash = Fnv.hashCode64(fieldName);
        this.ordinal = ordinal;
        this.format = format;
        this.locale = null;
        this.defaultValue = defaultValue;
        this.schema = null;
    }

    public FieldReaderImpl(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Locale locale, Object defaultValue, JSONSchema schema) {
        this.fieldName = fieldName;
        this.fieldType = fieldType;
        this.fieldClass = fieldClass;
        this.fieldClassSerializable = fieldClass != null && Serializable.class.isAssignableFrom(fieldClass);
        this.features = features;
        this.fieldNameHash = Fnv.hashCode64(fieldName);
        this.ordinal = ordinal;
        this.format = format;
        this.locale = locale;
        this.defaultValue = defaultValue;
        this.schema = schema;
    }

    @Override
    public boolean isFieldClassSerializable() {
        return this.fieldClassSerializable;
    }

    @Override
    public Object getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public ObjectReader getObjectReader(JSONReader jsonReader) {
        if (this.reader != null) {
            return this.reader;
        }
        if (this.format != null && !this.format.isEmpty()) {
            String typeName;
            switch (typeName = this.fieldType.getTypeName()) {
                case "java.sql.Time": {
                    this.reader = JdbcSupport.createTimeReader(this.format, this.locale);
                    return this.reader;
                }
                case "java.sql.Timestamp": {
                    this.reader = JdbcSupport.createTimestampReader(this.format, this.locale);
                    return this.reader;
                }
                case "java.sql.Date": {
                    return JdbcSupport.createDateReader(this.format, this.locale);
                }
            }
        }
        this.reader = jsonReader.getObjectReader(this.fieldType);
        return this.reader;
    }

    @Override
    public JSONSchema getSchema() {
        return this.schema;
    }

    @Override
    public int ordinal() {
        return this.ordinal;
    }

    @Override
    public long getFeatures() {
        return this.features;
    }

    @Override
    public long getFieldNameHash() {
        return this.fieldNameHash;
    }

    @Override
    public String getFormat() {
        return this.format;
    }

    @Override
    public Type getFieldType() {
        return this.fieldType;
    }

    @Override
    public Class getFieldClass() {
        return this.fieldClass;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    public String toString() {
        return this.fieldName;
    }

    @Override
    public void addResolveTask(JSONReader jsonReader, Object object, String reference) {
        JSONPath path = this.referenceCache != null && this.referenceCache.toString().equals(reference) ? this.referenceCache : (this.referenceCache = JSONPath.of(reference));
        jsonReader.addResolveTask(this, object, path);
    }

    public void addResolveTask(JSONReader jsonReader, Collection object, int i, String reference) {
        JSONPath path = this.referenceCache != null && this.referenceCache.toString().equals(reference) ? this.referenceCache : (this.referenceCache = JSONPath.of(reference));
        jsonReader.addResolveTask(object, i, path);
    }
}

