/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.FieldWriter;
import com.alibaba.fastjson2.writer.FieldWriterImpl;
import com.alibaba.fastjson2.writer.ObjectWriter;
import com.alibaba.fastjson2.writer.ObjectWriterAdapter;
import com.alibaba.fastjson2.writer.ObjectWriterBaseModule;
import com.alibaba.fastjson2.writer.ObjectWriterImplCurrency;
import com.alibaba.fastjson2.writer.ObjectWriterImplMap;
import com.alibaba.fastjson2.writer.ObjectWriterProvider;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Currency;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLongArray;

abstract class FieldWriterObject<T>
extends FieldWriterImpl<T> {
    volatile Class initValueClass;
    volatile ObjectWriter initObjectWriter;
    final boolean unwrapped;
    final boolean array;
    final boolean number;

    protected FieldWriterObject(String name, int ordinal, long features, String format, String label, Type fieldType, Class fieldClass) {
        super(name, ordinal, features, format, label, fieldType, fieldClass);
        boolean bl = this.unwrapped = (features & 0x2000000000000L) != 0L;
        if (fieldClass == Currency.class) {
            this.initValueClass = fieldClass;
            this.initObjectWriter = ObjectWriterImplCurrency.INSTANCE_FOR_FIELD;
        }
        this.array = fieldClass.isArray() || Collection.class.isAssignableFrom(fieldClass) || fieldClass == AtomicLongArray.class || fieldClass == AtomicIntegerArray.class;
        this.number = Number.class.isAssignableFrom(fieldClass);
    }

    @Override
    public ObjectWriter getInitWriter() {
        return this.initObjectWriter;
    }

    @Override
    public boolean unwrapped() {
        return this.unwrapped;
    }

    @Override
    public ObjectWriter getObjectWriter(JSONWriter jsonWriter, Class valueClass) {
        if (this.initValueClass == null || this.initObjectWriter == ObjectWriterBaseModule.VoidObjectWriter.INSTANCE) {
            ObjectWriter formattedWriter = FieldWriter.getObjectWriter(this.fieldType, this.fieldClass, this.format, null, valueClass);
            if (formattedWriter == null) {
                this.initObjectWriter = jsonWriter.getObjectWriter(valueClass);
                return this.initObjectWriter;
            }
            this.initObjectWriter = formattedWriter;
            return this.initObjectWriter;
        }
        if (this.initValueClass == valueClass) {
            if (this.initObjectWriter == null) {
                this.initObjectWriter = Map.class.isAssignableFrom(valueClass) ? (this.fieldClass.isAssignableFrom(valueClass) ? ObjectWriterImplMap.of(this.fieldType, valueClass) : ObjectWriterImplMap.of(valueClass)) : jsonWriter.getObjectWriter(valueClass);
            }
            return this.initObjectWriter;
        }
        if (Map.class.isAssignableFrom(valueClass)) {
            if (this.fieldClass.isAssignableFrom(valueClass)) {
                return ObjectWriterImplMap.of(this.fieldType, valueClass);
            }
            return ObjectWriterImplMap.of(valueClass);
        }
        return jsonWriter.getObjectWriter(valueClass);
    }

    @Override
    public boolean write(JSONWriter jsonWriter, T object) {
        Class<?> valueClass;
        Object value;
        if (!this.fieldClassSerializable && (jsonWriter.getFeatures(this.features) & JSONWriter.Feature.IgnoreNoneSerializable.mask) != 0L) {
            return false;
        }
        try {
            value = this.getFieldValue(object);
        }
        catch (RuntimeException error) {
            if (jsonWriter.isIgnoreErrorGetter()) {
                return false;
            }
            throw error;
        }
        if (value == null) {
            long features = this.features | jsonWriter.getFeatures();
            if ((features & (JSONWriter.Feature.WriteNulls.mask | JSONWriter.Feature.NullAsDefaultValue.mask)) != 0L && (features & JSONWriter.Feature.NotWriteDefaultValue.mask) == 0L) {
                this.writeFieldName(jsonWriter);
                if (this.array) {
                    jsonWriter.writeArrayNull();
                } else if (this.number) {
                    jsonWriter.writeNumberNull();
                } else {
                    jsonWriter.writeNull();
                }
                return true;
            }
            return false;
        }
        boolean refDetect = jsonWriter.isRefDetect(value);
        if (refDetect) {
            if (value == object) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeReference("..");
                return true;
            }
            String refPath = jsonWriter.setPath(this.name, value);
            if (refPath != null) {
                this.writeFieldName(jsonWriter);
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(value);
                return true;
            }
        }
        if ((valueClass = value.getClass()) == byte[].class) {
            this.writeBinary(jsonWriter, (byte[])value);
            return true;
        }
        ObjectWriter valueWriter = this.getObjectWriter(jsonWriter, valueClass);
        if (valueWriter == null) {
            throw new JSONException("get objectWriter error : " + valueClass);
        }
        if (this.unwrapped) {
            if (value instanceof Map) {
                for (Map.Entry entry : ((Map)value).entrySet()) {
                    long features;
                    String entryKey = entry.getKey().toString();
                    Object entryValue = entry.getValue();
                    if (entryValue == null && ((features = this.features | jsonWriter.getFeatures()) & JSONWriter.Feature.WriteNulls.mask) == 0L) continue;
                    jsonWriter.writeName(entryKey);
                    jsonWriter.writeColon();
                    if (entryValue == null) {
                        jsonWriter.writeNull();
                        continue;
                    }
                    Class<?> entryValueClass = entryValue.getClass();
                    ObjectWriter entryValueWriter = jsonWriter.getObjectWriter(entryValueClass);
                    entryValueWriter.write(jsonWriter, entryValue);
                }
                if (refDetect) {
                    jsonWriter.popPath(value);
                }
                return true;
            }
            if (valueWriter instanceof ObjectWriterAdapter) {
                ObjectWriterAdapter writerAdapter = (ObjectWriterAdapter)valueWriter;
                List<FieldWriter> fieldWriters = writerAdapter.getFieldWriters();
                for (FieldWriter fieldWriter : fieldWriters) {
                    fieldWriter.write(jsonWriter, value);
                }
                return true;
            }
        }
        this.writeFieldName(jsonWriter);
        boolean jsonb = jsonWriter.isJSONB();
        if ((this.features & JSONWriter.Feature.BeanToArray.mask) != 0L) {
            if (jsonb) {
                valueWriter.writeArrayMappingJSONB(jsonWriter, value, this.name, this.fieldType, this.features);
            } else {
                valueWriter.writeArrayMapping(jsonWriter, value, this.name, this.fieldType, this.features);
            }
        } else if (jsonb) {
            valueWriter.writeJSONB(jsonWriter, value, this.name, this.fieldType, this.features);
        } else {
            valueWriter.write(jsonWriter, value, this.name, this.fieldType, this.features);
        }
        if (refDetect) {
            jsonWriter.popPath(value);
        }
        return true;
    }

    @Override
    public void writeValue(JSONWriter jsonWriter, T object) {
        boolean refDetect;
        ObjectWriter valueWriter;
        Object value = this.getFieldValue(object);
        if (value == null) {
            jsonWriter.writeNull();
            return;
        }
        Class<?> valueClass = value.getClass();
        if (this.initValueClass == null) {
            this.initValueClass = valueClass;
            this.initObjectWriter = valueWriter = jsonWriter.getObjectWriter(valueClass);
        } else {
            valueWriter = this.initValueClass == valueClass ? this.initObjectWriter : jsonWriter.getObjectWriter(valueClass);
        }
        if (valueWriter == null) {
            throw new JSONException("get value writer error, valueType : " + valueClass);
        }
        boolean bl = refDetect = jsonWriter.isRefDetect() && !ObjectWriterProvider.isNotReferenceDetect(valueClass);
        if (refDetect) {
            if (value == object) {
                jsonWriter.writeReference("..");
                return;
            }
            String refPath = jsonWriter.setPath(this.name, value);
            if (refPath != null) {
                jsonWriter.writeReference(refPath);
                jsonWriter.popPath(value);
                return;
            }
        }
        if (jsonWriter.isJSONB()) {
            if (jsonWriter.isBeanToArray()) {
                valueWriter.writeArrayMappingJSONB(jsonWriter, value, this.name, this.fieldClass, this.features);
            } else {
                valueWriter.writeJSONB(jsonWriter, value, this.name, this.fieldClass, this.features);
            }
        } else {
            valueWriter.write(jsonWriter, value, this.name, this.fieldClass, this.features);
        }
        if (refDetect) {
            jsonWriter.popPath(value);
        }
    }
}

