/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.codec.DateTimeCodec;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.time.DateTimeFormatter;
import com.alibaba.fastjson2.time.LocalDateTime;
import com.alibaba.fastjson2.time.ZonedDateTime;
import com.alibaba.fastjson2.util.DateUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class ObjectReaderImplDate
extends DateTimeCodec
implements ObjectReader {
    public static final ObjectReaderImplDate INSTANCE = new ObjectReaderImplDate(null, null);

    public static ObjectReaderImplDate of(String format, Locale locale) {
        if (format == null) {
            return INSTANCE;
        }
        return new ObjectReaderImplDate(format, locale);
    }

    public ObjectReaderImplDate(String format, Locale locale) {
        super(format, locale);
    }

    public Class getObjectClass() {
        return Date.class;
    }

    public Object readJSONBObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return this.readDate(jsonReader);
    }

    public Object readObject(JSONReader jsonReader, Type fieldType, Object fieldName, long features) {
        return this.readDate(jsonReader);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readDate(JSONReader jsonReader) {
        ZonedDateTime zdt;
        long millis;
        if (jsonReader.isInt() && (this.format == null || this.formatMillis)) {
            long millis2 = jsonReader.readInt64Value();
            if (!this.formatUnixTime) return new Date(millis2);
            millis2 *= 1000L;
            return new Date(millis2);
        }
        if (jsonReader.readIfNull()) {
            return null;
        }
        if (jsonReader.nextIfNullOrEmptyString()) {
            return null;
        }
        if (jsonReader.current() == 'n') {
            return jsonReader.readNullOrNewDate();
        }
        if (this.useSimpleFormatter) {
            String str = jsonReader.readString();
            try {
                return new SimpleDateFormat(this.format).parse(str);
            }
            catch (ParseException e) {
                throw new JSONException(jsonReader.info("parse error : " + str), e);
            }
        }
        if (jsonReader.nextIfNullOrEmptyString()) {
            return null;
        }
        if (this.formatUnixTime || this.formatMillis) {
            millis = jsonReader.readInt64Value();
            if (!this.formatUnixTime) return new Date(millis);
            return new Date(millis *= 1000L);
        }
        if (this.format == null) {
            if (!jsonReader.isTypeRedirect()) return jsonReader.readDate();
            if (!jsonReader.nextIfMatchIdent('\"', 'v', 'a', 'l', '\"')) return jsonReader.readDate();
            jsonReader.nextIfMatch(':');
            millis = jsonReader.readInt64Value();
            jsonReader.nextIfObjectEnd();
            jsonReader.setTypeRedirect(false);
            if (millis != 0L) return new Date(millis);
            if (!jsonReader.wasNull()) return new Date(millis);
            return null;
        }
        if (this.yyyyMMddhhmmss19) {
            millis = jsonReader.isSupportSmartMatch() ? jsonReader.readMillisFromString() : jsonReader.readMillis19();
            if (millis != 0L) return new Date(millis);
            if (!jsonReader.wasNull()) {
                return new Date(millis);
            }
            zdt = jsonReader.readZonedDateTime();
        } else {
            DateTimeFormatter formatter = this.getDateFormatter(jsonReader.getLocale());
            if (formatter != null) {
                LocalDateTime ldt;
                block27: {
                    if (jsonReader.jsonb && !jsonReader.isString()) {
                        return jsonReader.readDate();
                    }
                    String str = jsonReader.readString();
                    if (str.isEmpty()) return null;
                    if ("null".equals(str)) {
                        return null;
                    }
                    if (!this.formatHasHour) {
                        if (!this.formatHasDay) {
                            return formatter.parseDate(str, jsonReader.getZoneId());
                        }
                        if (str.length() == 19 && jsonReader.isEnabled(JSONReader.Feature.SupportSmartMatch)) {
                            ldt = DateUtils.parseLocalDateTime(str, 0, str.length());
                            break block27;
                        } else {
                            if (this.format.indexOf(45) == -1) return formatter.parseDate(str, jsonReader.getZoneId());
                            if (str.indexOf(45) != -1) return formatter.parseDate(str, jsonReader.getZoneId());
                            if (!TypeUtils.isInteger(str)) return formatter.parseDate(str, jsonReader.getZoneId());
                            long millis3 = Long.parseLong(str);
                            return new Date(millis3);
                        }
                    }
                    if (str.length() == 19 && (this.yyyyMMddhhmm16 || jsonReader.isEnabled(JSONReader.Feature.SupportSmartMatch))) {
                        int length = this.yyyyMMddhhmm16 ? 16 : 19;
                        ldt = DateUtils.parseLocalDateTime(str, 0, length);
                    } else {
                        try {
                            return new SimpleDateFormat(this.format).parse(str);
                        }
                        catch (ParseException e) {
                            throw new JSONException("parse format '" + this.format + "'", e);
                        }
                    }
                }
                zdt = ZonedDateTime.of(ldt, jsonReader.context.getZoneId());
            } else {
                zdt = jsonReader.readZonedDateTime();
            }
        }
        if (zdt == null) {
            return null;
        }
        long seconds = zdt.toEpochSecond();
        int nanos = zdt.dateTime.time.nano;
        if (seconds < 0L && nanos > 0) {
            millis = (seconds + 1L) * 1000L;
            long adjustment = nanos / 1000000 - 1000;
            return new Date(millis += adjustment);
        }
        millis = seconds * 1000L;
        millis += (long)(nanos / 1000000);
        return new Date(millis);
    }
}

