/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONArray;
import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.PropertyNamingStrategy;
import com.alibaba.fastjson2.annotation.JSONBuilder;
import com.alibaba.fastjson2.annotation.JSONCreator;
import com.alibaba.fastjson2.annotation.JSONField;
import com.alibaba.fastjson2.annotation.JSONType;
import com.alibaba.fastjson2.codec.BeanInfo;
import com.alibaba.fastjson2.codec.FieldInfo;
import com.alibaba.fastjson2.function.Consumer;
import com.alibaba.fastjson2.function.Function;
import com.alibaba.fastjson2.function.impl.StringToAny;
import com.alibaba.fastjson2.function.impl.ToAny;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.reader.ObjectArrayReader;
import com.alibaba.fastjson2.reader.ObjectArrayReaderMultiType;
import com.alibaba.fastjson2.reader.ObjectArrayTypedReader;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderAdapter;
import com.alibaba.fastjson2.reader.ObjectReaderCreator;
import com.alibaba.fastjson2.reader.ObjectReaderImplAtomicReference;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigDecimal;
import com.alibaba.fastjson2.reader.ObjectReaderImplBigInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplBoolValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplBoolean;
import com.alibaba.fastjson2.reader.ObjectReaderImplByte;
import com.alibaba.fastjson2.reader.ObjectReaderImplCalendar;
import com.alibaba.fastjson2.reader.ObjectReaderImplCharValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplCharacter;
import com.alibaba.fastjson2.reader.ObjectReaderImplClass;
import com.alibaba.fastjson2.reader.ObjectReaderImplCurrency;
import com.alibaba.fastjson2.reader.ObjectReaderImplDate;
import com.alibaba.fastjson2.reader.ObjectReaderImplDouble;
import com.alibaba.fastjson2.reader.ObjectReaderImplDoubleArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplDoubleValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplField;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloat;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloatArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplFloatValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromBoolean;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromInt;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromLong;
import com.alibaba.fastjson2.reader.ObjectReaderImplFromString;
import com.alibaba.fastjson2.reader.ObjectReaderImplGenericArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt16Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt16ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt32ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt64ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8Array;
import com.alibaba.fastjson2.reader.ObjectReaderImplInt8ValueArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplInteger;
import com.alibaba.fastjson2.reader.ObjectReaderImplList;
import com.alibaba.fastjson2.reader.ObjectReaderImplListInt64;
import com.alibaba.fastjson2.reader.ObjectReaderImplListStr;
import com.alibaba.fastjson2.reader.ObjectReaderImplLocale;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapEntry;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapMultiValueType;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapString;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplMethod;
import com.alibaba.fastjson2.reader.ObjectReaderImplNumber;
import com.alibaba.fastjson2.reader.ObjectReaderImplNumberArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderImplShort;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import com.alibaba.fastjson2.reader.ObjectReaderImplStringArray;
import com.alibaba.fastjson2.reader.ObjectReaderImplUUID;
import com.alibaba.fastjson2.reader.ObjectReaderImplValue;
import com.alibaba.fastjson2.reader.ObjectReaderMisc;
import com.alibaba.fastjson2.reader.ObjectReaderSeeAlso;
import com.alibaba.fastjson2.reader.ObjectReaders;
import com.alibaba.fastjson2.time.ZoneId;
import com.alibaba.fastjson2.util.BeanUtils;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.util.JdbcSupport;
import com.alibaba.fastjson2.util.MapMultiValueType;
import com.alibaba.fastjson2.util.MultiType;
import com.alibaba.fastjson2.util.ParameterizedTypeImpl;
import com.alibaba.fastjson2.util.TypeUtils;
import java.io.Closeable;
import java.io.File;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSequentialList;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Currency;
import java.util.Date;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicLongArray;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import javax.sql.RowSet;

public class ObjectReaderProvider {
    static ObjectReaderCachePair readerCache;
    final ConcurrentMap<Type, ObjectReader> cache = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Type, ObjectReader> cacheFieldBased = new ConcurrentHashMap<Type, ObjectReader>();
    final ConcurrentMap<Long, ObjectReader> hashCache = new ConcurrentHashMap<Long, ObjectReader>();
    final ConcurrentMap<Class, Class> mixInCache = new ConcurrentHashMap<Class, Class>();
    final LRUAutoTypeCache autoTypeList = new LRUAutoTypeCache(1024);
    private ConcurrentMap<Type, Map<Type, Function>> typeConverts;
    public final ObjectReaderCreator creator;
    private long[] denyHashCodes = new long[]{-9164606388214699518L, -8754006975464705441L, -8720046426850100497L, -8649961213709896794L, -8614556368991373401L, -8382625455832334425L, -8165637398350707645L, -8109300701639721088L, -7966123100503199569L, -7921218830998286408L, -7775351613326101303L, -7768608037458185275L, -7766605818834748097L, -6835437086156813536L, -6316154655839304624L, -6179589609550493385L, -6149130139291498841L, -6149093380703242441L, -6088208984980396913L, -6025144546313590215L, -5939269048541779808L, -5885964883385605994L, -5767141746063564198L, -5764804792063216819L, -5472097725414717105L, -5194641081268104286L, -5076846148177416215L, -4837536971810737970L, -4836620931940850535L, -4733542790109620528L, -4703320437989596122L, -4608341446948126581L, -4537258998789938600L, -4438775680185074100L, -4314457471973557243L, -4150995715611818742L, -4082057040235125754L, -3975378478825053783L, -3967588558552655563L, -3935185854875733362L, -3319207949486691020L, -3077205613010077203L, -3053747177772160511L, -2995060141064716555L, -2825378362173150292L, -2533039401923731906L, -2439930098895578154L, -2378990704010641148L, -2364987994247679115L, -2262244760619952081L, -2192804397019347313L, -2095516571388852610L, -1872417015366588117L, -1650485814983027158L, -1589194880214235129L, -965955008570215305L, -905177026366752536L, -831789045734283466L, -803541446955902575L, -731978084025273882L, -666475508176557463L, -582813228520337988L, -254670111376247151L, -219577392946377768L, -190281065685395680L, -26639035867733124L, -9822483067882491L, 4750336058574309L, 33238344207745342L, 156405680656087946L, 218512992947536312L, 313864100207897507L, 386461436234701831L, 744602970950881621L, 823641066473609950L, 1073634739308289776L, 1153291637701043748L, 1203232727967308606L, 1214780596910349029L, 1268707909007641340L, 1459860845934817624L, 1502845958873959152L, 1534439610567445754L, 1698504441317515818L, 1818089308493370394L, 2078113382421334967L, 2164696723069287854L, 2622551729063269307L, 2653453629929770569L, 2660670623866180977L, 2731823439467737506L, 2836431254737891113L, 2930861374593775110L, 3058452313624178956L, 3085473968517218653L, 3089451460101527857L, 3114862868117605599L, 3129395579983849527L, 3256258368248066264L, 3452379460455804429L, 3547627781654598988L, 3637939656440441093L, 3688179072722109200L, 3718352661124136681L, 3730752432285826863L, 3740226159580918099L, 3794316665763266033L, 3977090344859527316L, 4000049462512838776L, 4046190361520671643L, 4147696707147271408L, 4193204392725694463L, 4215053018660518963L, 4241163808635564644L, 4254584350247334433L, 4814658433570175913L, 4841947709850912914L, 4904007817188630457L, 5100336081510080343L, 5120543992130540564L, 5274044858141538265L, 5347909877633654828L, 5450448828334921485L, 5474268165959054640L, 5545425291794704408L, 5596129856135573697L, 5688200883751798389L, 5751393439502795295L, 5916409771425455946L, 5944107969236155580L, 6007332606592876737L, 6090377589998869205L, 6280357960959217660L, 6456855723474196908L, 6511035576063254270L, 6534946468240507089L, 6584624952928234050L, 6734240326434096246L, 6742705432718011780L, 6800727078373023163L, 6854854816081053523L, 7045245923763966215L, 7123326897294507060L, 7164889056054194741L, 7179336928365889465L, 7240293012336844478L, 7347653049056829645L, 7375862386996623731L, 7442624256860549330L, 7617522210483516279L, 7658177784286215602L, 8055461369741094911L, 8064026652676081192L, 8389032537095247355L, 8488266005336625107L, 8537233257283452655L, 8735538376409180149L, 8838294710098435315L, 8861402923078831179L, 9140390920032557669L, 9140416208800006522L, 9144212112462101475L};
    private long[] acceptHashCodes = new long[]{-6293031534589903644L};
    private JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler;
    private Consumer<Class> autoTypeHandler;

    public void registerIfAbsent(long hashCode, ObjectReader objectReader) {
        this.hashCache.put(hashCode, objectReader);
    }

    public void addAutoTypeAccept(String name) {
        long hash;
        if (name != null && name.length() != 0 && Arrays.binarySearch(this.acceptHashCodes, hash = Fnv.hashCode64(name)) < 0) {
            long[] hashCodes = new long[this.acceptHashCodes.length + 1];
            hashCodes[hashCodes.length - 1] = hash;
            System.arraycopy(this.acceptHashCodes, 0, hashCodes, 0, this.acceptHashCodes.length);
            Arrays.sort(hashCodes);
            this.acceptHashCodes = hashCodes;
        }
    }

    public Consumer<Class> getAutoTypeHandler() {
        return this.autoTypeHandler;
    }

    public void setAutoTypeHandler(Consumer<Class> autoTypeHandler) {
        this.autoTypeHandler = autoTypeHandler;
    }

    public Class getMixIn(Class target) {
        return (Class)this.mixInCache.get(target);
    }

    public void cleanupMixIn() {
        this.mixInCache.clear();
    }

    public void mixIn(Class target, Class mixinSource) {
        if (mixinSource == null) {
            this.mixInCache.remove(target);
        } else {
            this.mixInCache.put(target, mixinSource);
        }
        this.cache.remove(target);
        this.cacheFieldBased.remove(target);
    }

    public void registerSeeAlsoSubType(Class subTypeClass) {
        this.registerSeeAlsoSubType(subTypeClass, null);
    }

    public void registerSeeAlsoSubType(Class subTypeClass, String subTypeClassName) {
        ObjectReaderSeeAlso readerSeeAlso;
        ObjectReaderSeeAlso readerSeeAlsoNew;
        Class superClass = subTypeClass.getSuperclass();
        if (superClass == null) {
            throw new JSONException("superclass is null");
        }
        ObjectReader objectReader = this.getObjectReader(superClass);
        if (objectReader instanceof ObjectReaderSeeAlso && (readerSeeAlsoNew = (readerSeeAlso = (ObjectReaderSeeAlso)objectReader).addSubType(subTypeClass, subTypeClassName)) != readerSeeAlso) {
            if (this.cache.containsKey(superClass)) {
                this.cache.put(superClass, readerSeeAlsoNew);
            } else {
                this.cacheFieldBased.put(subTypeClass, readerSeeAlsoNew);
            }
        }
    }

    public ObjectReader register(Type type, ObjectReader objectReader) {
        if (objectReader == null) {
            return (ObjectReader)this.cache.remove(type);
        }
        return this.cache.put(type, objectReader);
    }

    public ObjectReader registerIfAbsent(Type type, ObjectReader objectReader) {
        if (this.cache.containsKey(type)) {
            return (ObjectReader)this.cache.get(type);
        }
        return this.cache.put(type, objectReader);
    }

    public ObjectReader unregisterObjectReader(Type type) {
        return (ObjectReader)this.cache.remove(type);
    }

    public boolean unregisterObjectReader(Type type, ObjectReader reader) {
        return this.cache.remove(type, reader);
    }

    public void cleanup(Class objectClass) {
        this.mixInCache.remove(objectClass);
        this.cache.remove(objectClass);
        this.cacheFieldBased.remove(objectClass);
        BeanUtils.cleanupCache(objectClass);
    }

    static boolean match(Type objectType, ObjectReader objectReader, ClassLoader classLoader) {
        Class<?> objectClass = TypeUtils.getClass(objectType);
        if (objectClass != null && objectClass.getClassLoader() == classLoader) {
            return true;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType paramType = (ParameterizedType)objectType;
            Type rawType = paramType.getRawType();
            if (ObjectReaderProvider.match(rawType, objectReader, classLoader)) {
                return true;
            }
            Type[] actualTypeArguments = paramType.getActualTypeArguments();
            for (int i = 0; i < actualTypeArguments.length; ++i) {
                Type argType = actualTypeArguments[i];
                if (!ObjectReaderProvider.match(argType, objectReader, classLoader)) continue;
                return true;
            }
        }
        if (objectReader instanceof ObjectReaderImplMapTyped) {
            ObjectReaderImplMapTyped mapTyped = (ObjectReaderImplMapTyped)objectReader;
            Class valueClass = mapTyped.valueClass;
            if (valueClass != null && valueClass.getClassLoader() == classLoader) {
                return true;
            }
            Class<?> keyClass = TypeUtils.getClass(mapTyped.keyType);
            return keyClass != null && keyClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderImplList) {
            ObjectReaderImplList list = (ObjectReaderImplList)objectReader;
            return list.itemClass != null && list.itemClass.getClassLoader() == classLoader;
        }
        if (objectReader instanceof ObjectReaderAdapter) {
            FieldReader[] fieldReaders;
            for (FieldReader fieldReader : fieldReaders = ((ObjectReaderAdapter)objectReader).fieldReaders) {
                if (fieldReader.fieldClass != null && fieldReader.fieldClass.getClassLoader() == classLoader) {
                    return true;
                }
                Type fieldType = fieldReader.fieldType;
                if (!(fieldType instanceof ParameterizedType) || !ObjectReaderProvider.match(fieldType, null, classLoader)) continue;
                return true;
            }
        }
        return false;
    }

    public void cleanup(ClassLoader classLoader) {
        Map.Entry entry;
        Iterator it = this.mixInCache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (((Class)entry.getKey()).getClassLoader() != classLoader) continue;
            it.remove();
        }
        it = this.cache.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader)) continue;
            it.remove();
        }
        it = this.cacheFieldBased.entrySet().iterator();
        while (it.hasNext()) {
            entry = it.next();
            if (!ObjectReaderProvider.match((Type)entry.getKey(), (ObjectReader)entry.getValue(), classLoader)) continue;
            it.remove();
        }
        BeanUtils.cleanupCache(classLoader);
    }

    public ObjectReaderCreator getCreator() {
        return this.creator;
    }

    public ObjectReaderProvider() {
        this.hashCache.put(20315L, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        long HASH_MAP_CLASS_NAME_HASH = 77L;
        this.hashCache.put(77L, ObjectReaderImplMap.INSTANCE);
        this.creator = ObjectReaderCreator.INSTANCE;
    }

    public ObjectReaderProvider(ObjectReaderCreator creator) {
        this.hashCache.put(20315L, ObjectArrayReader.INSTANCE);
        long STRING_CLASS_NAME_HASH = -4834614249632438472L;
        this.hashCache.put(-4834614249632438472L, ObjectReaderImplString.INSTANCE);
        long HASH_MAP_CLASS_NAME_HASH = 77L;
        this.hashCache.put(77L, ObjectReaderImplMap.INSTANCE);
        this.creator = creator;
    }

    public Function getTypeConvert(Type from, Type to) {
        Map map;
        ConcurrentMap<Type, Map<Type, Function>> typeConverts = this.typeConverts;
        if (typeConverts == null) {
            typeConverts = this.typeConverts = ObjectReaderProvider.buildInitTypeConverts();
        }
        if ((map = (Map)typeConverts.get(from)) == null) {
            return null;
        }
        return (Function)map.get(to);
    }

    protected static ConcurrentMap<Type, Map<Type, Function>> buildInitTypeConverts() {
        ConcurrentHashMap<Type, Map<Type, Function>> typeConverts = new ConcurrentHashMap<Type, Map<Type, Function>>();
        ObjectReaderProvider.registerTypeConvert(typeConverts, Character.class, Character.TYPE, o -> o);
        Class[] numberTypes = new Class[]{Boolean.class, Byte.class, Short.class, Integer.class, Long.class, Number.class, Float.class, Double.class, BigInteger.class, BigDecimal.class, AtomicInteger.class, AtomicLong.class};
        ToAny TO_BOOLEAN = new ToAny(Boolean.class, null);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Boolean.class, TO_BOOLEAN);
        }
        ToAny TO_BOOLEAN_VALUE = new ToAny(Boolean.class, Boolean.FALSE);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Boolean.TYPE, TO_BOOLEAN_VALUE);
        }
        ToAny TO_STRING = new ToAny(String.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, String.class, TO_STRING);
        }
        ToAny TO_DECIMAL = new ToAny(BigDecimal.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, BigDecimal.class, TO_DECIMAL);
        }
        ToAny TO_BIGINT = new ToAny(BigInteger.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, BigInteger.class, TO_BIGINT);
        }
        ToAny TO_BYTE = new ToAny(Byte.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Byte.class, TO_BYTE);
        }
        ToAny TO_BYTE_VALUE = new ToAny(Byte.class, (byte)0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Byte.TYPE, TO_BYTE_VALUE);
        }
        ToAny TO_SHORT = new ToAny(Short.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Short.class, TO_SHORT);
        }
        ToAny TO_SHORT_VALUE = new ToAny(Short.class, (short)0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Short.TYPE, TO_SHORT_VALUE);
        }
        ToAny TO_INTEGER = new ToAny(Integer.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Integer.class, TO_INTEGER);
        }
        ToAny TO_INT = new ToAny(Integer.class, 0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Integer.TYPE, TO_INT);
        }
        ToAny TO_LONG = new ToAny(Long.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Long.class, TO_LONG);
        }
        ToAny TO_LONG_VALUE = new ToAny(Long.class, 0L);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Long.TYPE, TO_LONG_VALUE);
        }
        ToAny TO_FLOAT = new ToAny(Float.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Float.class, TO_FLOAT);
        }
        ToAny TO_FLOAT_VALUE = new ToAny(Float.class, Float.valueOf(0.0f));
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Float.TYPE, TO_FLOAT_VALUE);
        }
        ToAny TO_DOUBLE = new ToAny(Double.class);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Double.class, TO_DOUBLE);
        }
        ToAny TO_DOUBLE_VALUE = new ToAny(Double.class, 0.0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Double.TYPE, TO_DOUBLE_VALUE);
        }
        ToAny TO_NUMBER = new ToAny(Number.class, 0.0);
        for (Class type : numberTypes) {
            ObjectReaderProvider.registerTypeConvert(typeConverts, type, Number.class, TO_NUMBER);
        }
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Character.TYPE, new StringToAny(Character.TYPE, Character.valueOf('0')));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Boolean.TYPE, new StringToAny(Boolean.TYPE, false));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Float.TYPE, new StringToAny(Float.TYPE, Float.valueOf(0.0f)));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Double.TYPE, new StringToAny(Double.TYPE, 0.0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Byte.TYPE, new StringToAny(Byte.TYPE, (byte)0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Short.TYPE, new StringToAny(Short.TYPE, (short)0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Integer.TYPE, new StringToAny(Integer.TYPE, 0));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Long.TYPE, new StringToAny(Long.TYPE, 0L));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Character.class, new StringToAny(Character.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Boolean.class, new StringToAny(Boolean.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Double.class, new StringToAny(Double.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Float.class, new StringToAny(Float.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Byte.class, new StringToAny(Byte.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Short.class, new StringToAny(Short.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Integer.class, new StringToAny(Integer.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Long.class, new StringToAny(Long.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, BigDecimal.class, new StringToAny(BigDecimal.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, BigInteger.class, new StringToAny(BigInteger.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Number.class, new StringToAny(BigDecimal.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, Collection.class, new StringToAny(Collection.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, List.class, new StringToAny(List.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, JSONArray.class, new StringToAny(JSONArray.class, null));
        ObjectReaderProvider.registerTypeConvert(typeConverts, Boolean.class, Boolean.TYPE, o -> o);
        Function<Object, Object> function = o -> o == null || "null".equals(o) || "".equals(o) ? null : UUID.fromString((String)o);
        ObjectReaderProvider.registerTypeConvert(typeConverts, String.class, UUID.class, function);
        return typeConverts;
    }

    static Function registerTypeConvert(ConcurrentMap<Type, Map<Type, Function>> typeConverts, Type from, Type to, Function typeConvert) {
        Map map = (Map)typeConverts.get(from);
        if (map == null) {
            typeConverts.put(from, new ConcurrentHashMap());
            map = (Map)typeConverts.get(from);
        }
        return map.put(to, typeConvert);
    }

    public ObjectReader getObjectReader(long hashCode) {
        Long hashCodeObj;
        ObjectReader objectReader;
        ObjectReaderCachePair pair = readerCache;
        if (pair != null) {
            if (pair.hashCode == hashCode) {
                return pair.reader;
            }
            if (pair.missCount++ > 16) {
                readerCache = null;
            }
        }
        if ((objectReader = (ObjectReader)this.hashCache.get(hashCodeObj = new Long(hashCode))) != null && readerCache == null) {
            readerCache = new ObjectReaderCachePair(hashCode, objectReader);
        }
        return objectReader;
    }

    public ObjectReader getObjectReader(String typeName, Class<?> expectClass, long features) {
        Class<?> autoTypeClass = this.checkAutoType(typeName, expectClass, features);
        if (autoTypeClass == null) {
            return null;
        }
        boolean fieldBased = (features & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader = this.getObjectReader(autoTypeClass, fieldBased);
        if (autoTypeClass != expectClass) {
            this.registerIfAbsent(Fnv.hashCode64(typeName), objectReader);
        }
        return objectReader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void afterAutoType(String typeName, Class type) {
        if (this.autoTypeHandler != null) {
            this.autoTypeHandler.accept(type);
        }
        LRUAutoTypeCache lRUAutoTypeCache = this.autoTypeList;
        synchronized (lRUAutoTypeCache) {
            this.autoTypeList.put(typeName, new Date());
        }
    }

    public Class<?> checkAutoType(String typeName, Class<?> expectClass, long features) {
        Class clazz;
        int ch;
        int i;
        long hash;
        boolean autoTypeSupport;
        Class<?> resolvedClass;
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        if (this.autoTypeBeforeHandler != null && (resolvedClass = this.autoTypeBeforeHandler.apply(typeName, expectClass, features)) != null) {
            this.afterAutoType(typeName, resolvedClass);
            return resolvedClass;
        }
        int typeNameLength = typeName.length();
        if (typeNameLength >= 192) {
            throw new JSONException("autoType is not support. " + typeName);
        }
        if (typeName.charAt(0) == '[') {
            String componentTypeName = typeName.substring(1);
            this.checkAutoType(componentTypeName, null, features);
        }
        if (expectClass != null && expectClass.getName().equals(typeName)) {
            this.afterAutoType(typeName, expectClass);
            return expectClass;
        }
        boolean bl = autoTypeSupport = (features & JSONReader.Feature.SupportAutoType.mask) != 0L;
        if (autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.acceptHashCodes, hash *= 1099511628211L) >= 0 && (clazz = TypeUtils.loadClass(typeName)) != null) {
                    if (expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                        throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                    }
                    this.afterAutoType(typeName, clazz);
                    return clazz;
                }
                if (Arrays.binarySearch(this.denyHashCodes, hash) < 0 || TypeUtils.getMapping(typeName) != null) continue;
                throw new JSONException("autoType is not support. " + typeName);
            }
        }
        if (!autoTypeSupport) {
            hash = -3750763034362895579L;
            for (i = 0; i < typeNameLength; ++i) {
                ch = typeName.charAt(i);
                if (ch == 36) {
                    ch = 46;
                }
                hash ^= (long)ch;
                if (Arrays.binarySearch(this.denyHashCodes, hash *= 1099511628211L) >= 0) {
                    throw new JSONException("autoType is not support. " + typeName);
                }
                if (Arrays.binarySearch(this.acceptHashCodes, hash) < 0) continue;
                clazz = TypeUtils.loadClass(typeName);
                if (clazz != null && expectClass != null && !expectClass.isAssignableFrom(clazz)) {
                    throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
                }
                this.afterAutoType(typeName, clazz);
                return clazz;
            }
        }
        if (!autoTypeSupport) {
            return null;
        }
        clazz = TypeUtils.getMapping(typeName);
        if (clazz != null) {
            if (expectClass != null && expectClass != Object.class && clazz != HashMap.class && !expectClass.isAssignableFrom(clazz)) {
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
            this.afterAutoType(typeName, clazz);
            return clazz;
        }
        clazz = TypeUtils.loadClass(typeName);
        if (clazz != null) {
            if (ClassLoader.class.isAssignableFrom(clazz) || DataSource.class.isAssignableFrom(clazz) || RowSet.class.isAssignableFrom(clazz)) {
                throw new JSONException("autoType is not support. " + typeName);
            }
            if (expectClass != null) {
                if (expectClass.isAssignableFrom(clazz)) {
                    this.afterAutoType(typeName, clazz);
                    return clazz;
                }
                if ((features & JSONReader.Feature.IgnoreAutoTypeNotMatch.mask) != 0L) {
                    return expectClass;
                }
                throw new JSONException("type not match. " + typeName + " -> " + expectClass.getName());
            }
        }
        this.afterAutoType(typeName, clazz);
        return clazz;
    }

    public ObjectReader getObjectReader(Type objectType) {
        return this.getObjectReader(objectType, false);
    }

    public ObjectReader getObjectReader(Type objectType, boolean fieldBased) {
        ObjectReaderCreator creator;
        ObjectReader previous;
        ObjectReader boundObjectReader;
        Type bound;
        Type[] bounds;
        Type[] upperBounds;
        ObjectReader objectReader;
        if (objectType == null) {
            objectType = Object.class;
        }
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectType) : (ObjectReader)this.cache.get(objectType);
        if (objectReader == null && objectType instanceof WildcardType && (upperBounds = ((WildcardType)objectType).getUpperBounds()).length == 1) {
            Type upperBoundType = upperBounds[0];
            ObjectReader objectReader3 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(upperBoundType) : (ObjectReader)this.cache.get(upperBoundType);
        }
        if (objectReader != null) {
            return objectReader;
        }
        objectReader = this.getObjectReaderModule((Type)objectType);
        if (objectReader != null) {
            ObjectReader previous2;
            ObjectReader objectReader4 = previous2 = fieldBased ? this.cacheFieldBased.put((Type)objectType, objectReader) : this.cache.put((Type)objectType, objectReader);
            if (previous2 != null) {
                objectReader = previous2;
            }
            return objectReader;
        }
        if (objectType instanceof TypeVariable && (bounds = ((TypeVariable)objectType).getBounds()).length > 0 && (bound = bounds[0]) instanceof Class && (boundObjectReader = this.getObjectReader(bound, fieldBased)) != null) {
            ObjectReader previous3 = this.getPreviousObjectReader(fieldBased, (Type)objectType, boundObjectReader);
            if (previous3 != null) {
                boundObjectReader = previous3;
            }
            return boundObjectReader;
        }
        if (objectType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)objectType;
            Type rawType = parameterizedType.getRawType();
            Type[] typeArguments = parameterizedType.getActualTypeArguments();
            if (rawType instanceof Class) {
                ObjectReader rawClassReader;
                Class rawClass = (Class)rawType;
                boolean generic = false;
                for (Class clazz = rawClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
                    if (clazz.getTypeParameters().length <= 0) continue;
                    generic = true;
                    break;
                }
                if (!(typeArguments.length != 0 && generic || (rawClassReader = this.getObjectReader(rawClass, fieldBased)) == null)) {
                    ObjectReader previous4 = this.getPreviousObjectReader(fieldBased, (Type)objectType, rawClassReader);
                    if (previous4 != null) {
                        rawClassReader = previous4;
                    }
                    return rawClassReader;
                }
            }
        }
        if ((previous = this.getPreviousObjectReader(fieldBased, (Type)objectType, objectReader = (creator = this.getCreator()).createObjectReader(TypeUtils.getMapping((Type)objectType), (Type)objectType, fieldBased, this))) != null) {
            objectReader = previous;
        }
        return objectReader;
    }

    private ObjectReader getPreviousObjectReader(boolean fieldBased, Type objectType, ObjectReader boundObjectReader) {
        return fieldBased ? this.cacheFieldBased.put(objectType, boundObjectReader) : this.cache.put(objectType, boundObjectReader);
    }

    public JSONReader.AutoTypeBeforeHandler getAutoTypeBeforeHandler() {
        return this.autoTypeBeforeHandler;
    }

    public Map<String, Date> getAutoTypeList() {
        return this.autoTypeList;
    }

    public void setAutoTypeBeforeHandler(JSONReader.AutoTypeBeforeHandler autoTypeBeforeHandler) {
        this.autoTypeBeforeHandler = autoTypeBeforeHandler;
    }

    public FieldReader createFieldReader(Class objectClass, String fieldName, long readerFeatures) {
        ObjectReader objectReader;
        boolean fieldBased = (readerFeatures & JSONReader.Feature.FieldBased.mask) != 0L;
        ObjectReader objectReader2 = objectReader = fieldBased ? (ObjectReader)this.cacheFieldBased.get(objectClass) : (ObjectReader)this.cache.get(objectClass);
        if (objectReader != null) {
            return objectReader.getFieldReader(fieldName);
        }
        AtomicReference fieldRef = new AtomicReference();
        long nameHashLCase = Fnv.hashCode64LCase(fieldName);
        BeanUtils.fields(objectClass, field -> {
            if (nameHashLCase == Fnv.hashCode64LCase(field.getName())) {
                fieldRef.set(field);
            }
        });
        Field field2 = (Field)fieldRef.get();
        if (field2 != null) {
            return this.creator.createFieldReader(fieldName, null, field2.getType(), field2);
        }
        AtomicReference methodRef = new AtomicReference();
        BeanUtils.setters(objectClass, method -> {
            String setterName = BeanUtils.setterName(method.getName(), PropertyNamingStrategy.CamelCase.name());
            if (nameHashLCase == Fnv.hashCode64LCase(setterName)) {
                methodRef.set(method);
            }
        });
        Method method2 = (Method)methodRef.get();
        if (method2 != null) {
            Class<?>[] params = method2.getParameterTypes();
            Class<?> fieldClass = params[0];
            return this.creator.createFieldReaderMethod(objectClass, fieldName, null, fieldClass, fieldClass, method2);
        }
        return null;
    }

    public void getBeanInfo(BeanInfo beanInfo, Class<?> objectClass) {
        Annotation[] annotations;
        Class mixInSource = (Class)this.mixInCache.get(objectClass);
        if (mixInSource != null && mixInSource != objectClass) {
            beanInfo.mixIn = true;
            for (Annotation annotation : mixInSource.getDeclaredAnnotations()) {
                if (annotation.annotationType() != JSONType.class) continue;
                this.getBeanInfo1x(beanInfo, annotation);
            }
            BeanUtils.staticMethod(mixInSource, method -> this.getCreator(beanInfo, objectClass, (Method)method));
            BeanUtils.constructor(mixInSource, constructor -> this.getCreator(beanInfo, objectClass, (Constructor)constructor));
        }
        Class<?> seeAlsoClass = null;
        for (Class<?> superClass = objectClass.getSuperclass(); superClass != null && superClass != Object.class && superClass != Enum.class; superClass = superClass.getSuperclass()) {
            BeanInfo superBeanInfo = new BeanInfo();
            this.getBeanInfo(superBeanInfo, superClass);
            if (superBeanInfo.seeAlso == null) continue;
            boolean inSeeAlso = false;
            for (Class seeAlsoItem : superBeanInfo.seeAlso) {
                if (seeAlsoItem != objectClass) continue;
                inSeeAlso = true;
                break;
            }
            if (inSeeAlso) continue;
            seeAlsoClass = superClass;
        }
        if (seeAlsoClass != null) {
            this.getBeanInfo(beanInfo, seeAlsoClass);
        }
        for (Annotation annotation : annotations = objectClass.getDeclaredAnnotations()) {
            if (annotation.annotationType() != JSONType.class) continue;
            this.getBeanInfo1x(beanInfo, annotation);
        }
        block12: for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            switch (annotationTypeName = annotationType.getName()) {
                case "com.alibaba.fastjson.annotation.JSONType": {
                    this.getBeanInfo1x(beanInfo, annotation);
                    continue block12;
                }
                case "kotlin.Metadata": {
                    beanInfo.kotlin = true;
                    continue block12;
                }
            }
        }
        BeanUtils.staticMethod(objectClass, method -> this.getCreator(beanInfo, objectClass, (Method)method));
        BeanUtils.constructor(objectClass, constructor -> this.getCreator(beanInfo, objectClass, (Constructor)constructor));
        if (beanInfo.creatorConstructor == null && (beanInfo.readerFeatures & JSONReader.Feature.FieldBased.mask) == 0L && beanInfo.kotlin) {
            BeanUtils.getKotlinConstructor(objectClass, beanInfo);
            beanInfo.createParameterNames = BeanUtils.getKotlinConstructorParameters(objectClass);
        }
    }

    void getBeanInfo1x(BeanInfo beanInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "seeAlso": {
                        Class[] classes = (Class[])result;
                        if (classes.length == 0) break;
                        beanInfo.seeAlso = classes;
                        beanInfo.seeAlsoNames = new String[classes.length];
                        for (int i = 0; i < classes.length; ++i) {
                            Class item = classes[i];
                            BeanInfo itemBeanInfo = new BeanInfo();
                            this.processSeeAlsoAnnotation(itemBeanInfo, item);
                            String typeName = itemBeanInfo.typeName;
                            if (typeName == null || typeName.isEmpty()) {
                                typeName = item.getSimpleName();
                            }
                            beanInfo.seeAlsoNames[i] = typeName;
                        }
                        beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                        break;
                    }
                    case "seeAlsoDefault": {
                        Class seeAlsoDefault = (Class)result;
                        if (seeAlsoDefault != Void.class) {
                            beanInfo.seeAlsoDefault = seeAlsoDefault;
                        }
                    }
                    case "typeKey": {
                        String jsonTypeKey = (String)result;
                        if (jsonTypeKey.isEmpty()) break;
                        beanInfo.typeKey = jsonTypeKey;
                        break;
                    }
                    case "typeName": {
                        String typeName = (String)result;
                        if (typeName.isEmpty()) break;
                        beanInfo.typeName = typeName;
                        break;
                    }
                    case "naming": {
                        Enum naming = (Enum)result;
                        beanInfo.namingStrategy = naming.name();
                        break;
                    }
                    case "ignores": {
                        String[] ignores = (String[])result;
                        if (ignores.length <= 0) break;
                        beanInfo.ignores = ignores;
                        break;
                    }
                    case "orders": {
                        String[] fields = (String[])result;
                        if (fields.length == 0) break;
                        beanInfo.orders = fields;
                        break;
                    }
                    case "deserializer": {
                        Class deserializer = (Class)result;
                        if (!ObjectReader.class.isAssignableFrom(deserializer)) break;
                        beanInfo.deserializer = deserializer;
                        break;
                    }
                    case "parseFeatures": {
                        Enum[] features = (Enum[])result;
                        block46: for (int i = 0; i < features.length; ++i) {
                            Enum feature = features[i];
                            switch (feature.name()) {
                                case "SupportAutoType": {
                                    beanInfo.readerFeatures |= JSONReader.Feature.SupportAutoType.mask;
                                    continue block46;
                                }
                                case "SupportArrayToBean": {
                                    beanInfo.readerFeatures |= JSONReader.Feature.SupportArrayToBean.mask;
                                    continue block46;
                                }
                                case "InitStringFieldAsEmpty": {
                                    beanInfo.readerFeatures |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                                    continue block46;
                                }
                                case "TrimStringFieldValue": {
                                    continue block46;
                                }
                            }
                        }
                        break;
                    }
                    case "deserializeFeatures": {
                        JSONReader.Feature[] features = (JSONReader.Feature[])result;
                        for (int i = 0; i < features.length; ++i) {
                            beanInfo.readerFeatures |= features[i].mask;
                        }
                        break;
                    }
                    case "builder": {
                        Class builderClass = (Class)result;
                        if (builderClass == Void.TYPE || builderClass == Void.class) break;
                        beanInfo.builder = builderClass;
                        for (Annotation builderAnnotation : builderClass.getDeclaredAnnotations()) {
                            Class<? extends Annotation> builderAnnotationClass = builderAnnotation.annotationType();
                            String builderAnnotationName = builderAnnotationClass.getName();
                            if (builderAnnotationName.equals("com.alibaba.fastjson.annotation.JSONPOJOBuilder")) {
                                this.getBeanInfo1xJSONPOJOBuilder(beanInfo, builderClass, builderAnnotation, builderAnnotationClass);
                                continue;
                            }
                            JSONBuilder jsonBuilder = BeanUtils.findAnnotation(builderClass, JSONBuilder.class);
                            if (jsonBuilder == null) continue;
                            String buildMethodName = jsonBuilder.buildMethod();
                            beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, buildMethodName);
                            String withPrefix = jsonBuilder.withPrefix();
                            if (withPrefix.isEmpty()) continue;
                            beanInfo.builderWithPrefix = withPrefix;
                        }
                        if (beanInfo.buildMethod == null) {
                            beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, "build");
                        }
                        if (beanInfo.buildMethod != null) break;
                        beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, "create");
                        break;
                    }
                    case "deserializeUsing": {
                        Class deserializeUsing = (Class)result;
                        if (!ObjectReader.class.isAssignableFrom(deserializeUsing)) break;
                        beanInfo.deserializer = deserializeUsing;
                        break;
                    }
                    case "autoTypeBeforeHandler": 
                    case "autoTypeCheckHandler": {
                        Class autoTypeCheckHandler = (Class)result;
                        if (autoTypeCheckHandler == JSONReader.AutoTypeBeforeHandler.class || !JSONReader.AutoTypeBeforeHandler.class.isAssignableFrom(autoTypeCheckHandler)) break;
                        beanInfo.autoTypeBeforeHandler = autoTypeCheckHandler;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void processSeeAlsoAnnotation(BeanInfo beanInfo, Class<?> objectClass) {
        Class mixInSource = (Class)this.mixInCache.get(objectClass);
        if (mixInSource != null && mixInSource != objectClass) {
            beanInfo.mixIn = true;
            this.processSeeAlsoAnnotation(beanInfo, mixInSource.getDeclaredAnnotations());
        }
        this.processSeeAlsoAnnotation(beanInfo, objectClass.getDeclaredAnnotations());
    }

    private void processSeeAlsoAnnotation(BeanInfo beanInfo, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> itemAnnotationType = annotation.annotationType();
            BeanUtils.annotationMethods(itemAnnotationType, m -> {
                String name = m.getName();
                try {
                    String typeName;
                    Object result = m.invoke((Object)annotation, new Object[0]);
                    if (name.equals("typeName") && !(typeName = (String)result).isEmpty()) {
                        beanInfo.typeName = typeName;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Constructor constructor, int paramIndex, Annotation[][] parameterAnnotations) {
        int paIndex;
        Class mixInSource;
        if (objectClass != null && (mixInSource = (Class)this.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
            Constructor mixInConstructor = null;
            try {
                mixInConstructor = mixInSource.getDeclaredConstructor(constructor.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (mixInConstructor != null) {
                Annotation[] mixInParamAnnotations = mixInConstructor.getParameterAnnotations()[paramIndex];
                this.processAnnotation(fieldInfo, mixInParamAnnotations);
            }
        }
        Annotation[] annotations = null;
        if (parameterAnnotations == null) {
            parameterAnnotations = constructor.getParameterAnnotations();
        }
        if ((paIndex = parameterAnnotations.length == constructor.getParameterTypes().length ? paramIndex : paramIndex - 1) >= 0 && paIndex < parameterAnnotations.length) {
            annotations = parameterAnnotations[paIndex];
        }
        if (annotations != null && annotations.length > 0) {
            this.processAnnotation(fieldInfo, annotations);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method, int paramIndex) {
        Class mixInSource;
        if (objectClass != null && (mixInSource = (Class)this.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
            Method mixInMethod = null;
            try {
                mixInMethod = mixInSource.getMethod(method.getName(), method.getParameterTypes());
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (mixInMethod != null) {
                Annotation[] mixInParamAnnotations = mixInMethod.getParameterAnnotations()[paramIndex];
                this.processAnnotation(fieldInfo, mixInParamAnnotations);
            }
        }
        Annotation[] parameterAnnotations = method.getParameterAnnotations()[paramIndex];
        this.processAnnotation(fieldInfo, parameterAnnotations);
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Field field) {
        Annotation[] annotations;
        Class mixInSource;
        if (objectClass != null && (mixInSource = (Class)this.mixInCache.get(objectClass)) != null && mixInSource != objectClass) {
            Field mixInField = null;
            try {
                mixInField = mixInSource.getDeclaredField(field.getName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (mixInField != null) {
                this.getFieldInfo(fieldInfo, mixInSource, mixInField);
            }
        }
        if ((annotations = field.getDeclaredAnnotations()).length > 0) {
            this.processAnnotation(fieldInfo, annotations);
        }
    }

    public void getFieldInfo(FieldInfo fieldInfo, Class objectClass, Method method) {
        String fieldName2;
        String fieldName1;
        char c1;
        char c0;
        String methodName = method.getName();
        if (objectClass != null) {
            Method supperMethod;
            Class superclass = objectClass.getSuperclass();
            if (superclass != Object.class && superclass != null && (supperMethod = BeanUtils.getMethod(superclass, method)) != null) {
                this.getFieldInfo(fieldInfo, superclass, supperMethod);
            }
            Class<?>[] interfaces = objectClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                Method interfaceMethod;
                Class<?> item = interfaces[i];
                if (item == Serializable.class || (interfaceMethod = BeanUtils.getMethod(item, method)) == null || superclass == null) continue;
                this.getFieldInfo(fieldInfo, superclass, interfaceMethod);
            }
            Class mixInSource = (Class)this.mixInCache.get(objectClass);
            if (mixInSource != null && mixInSource != objectClass) {
                Method mixInMethod = null;
                try {
                    mixInMethod = mixInSource.getDeclaredMethod(methodName, method.getParameterTypes());
                }
                catch (Exception interfaceMethod) {
                    // empty catch block
                }
                if (mixInMethod != null) {
                    this.getFieldInfo(fieldInfo, mixInSource, mixInMethod);
                }
            }
        }
        String jsonFieldName = null;
        Annotation[] annotations = method.getDeclaredAnnotations();
        for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONField jsonField = BeanUtils.findAnnotation(annotation, JSONField.class);
            if (jsonField != null) {
                this.getFieldInfo(fieldInfo, jsonField);
                jsonFieldName = jsonField.name();
                if (jsonField == annotation) continue;
            }
            if (!(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONField")) continue;
            this.processJSONField1x(fieldInfo, annotation);
        }
        String fieldName = methodName.startsWith("set", 0) ? BeanUtils.setterName(methodName, null) : BeanUtils.getterName(methodName, null);
        if (fieldName.length() > 1 && (c0 = fieldName.charAt(0)) >= 'A' && c0 <= 'Z' && (c1 = fieldName.charAt(1)) >= 'A' && c1 <= 'Z' && (jsonFieldName == null || jsonFieldName.isEmpty())) {
            char[] chars = fieldName.toCharArray();
            chars[0] = (char)(chars[0] + 32);
            fieldName1 = new String(chars);
            chars[1] = (char)(chars[1] + 32);
            fieldName2 = new String(chars);
        } else {
            fieldName1 = null;
            fieldName2 = null;
        }
        BeanUtils.getFieldInfo(objectClass, fieldInfo, this, fieldName, fieldName1, fieldName2);
        if (fieldName1 != null && fieldInfo.fieldName == null && fieldInfo.alternateNames == null) {
            fieldInfo.alternateNames = new String[]{fieldName1, fieldName2};
        }
    }

    private void processAnnotation(FieldInfo fieldInfo, Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONField jsonField = BeanUtils.findAnnotation(annotation, JSONField.class);
            if (jsonField != null) {
                this.getFieldInfo(fieldInfo, jsonField);
                if (jsonField == annotation) continue;
            }
            if (!(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONField")) continue;
            this.processJSONField1x(fieldInfo, annotation);
        }
    }

    private void processJSONField1x(FieldInfo fieldInfo, Annotation annotation) {
        Class<?> annotationClass = annotation.getClass();
        BeanUtils.annotationMethods(annotationClass, m -> {
            String name = m.getName();
            try {
                Object result = m.invoke((Object)annotation, new Object[0]);
                switch (name) {
                    case "name": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        fieldInfo.fieldName = value;
                        break;
                    }
                    case "format": {
                        String format = (String)result;
                        if (format.isEmpty()) break;
                        if ((format = format.trim()).indexOf(84) != -1 && !format.contains("'T'")) {
                            format = format.replaceAll("T", "'T'");
                        }
                        fieldInfo.format = format;
                        break;
                    }
                    case "label": {
                        String label = (String)result;
                        if (label.isEmpty()) break;
                        fieldInfo.label = label;
                        break;
                    }
                    case "defaultValue": {
                        String value = (String)result;
                        if (value.isEmpty()) break;
                        fieldInfo.defaultValue = value;
                        break;
                    }
                    case "alternateNames": {
                        String[] alternateNames = (String[])result;
                        if (alternateNames.length == 0) break;
                        if (fieldInfo.alternateNames == null) {
                            fieldInfo.alternateNames = alternateNames;
                            break;
                        }
                        LinkedHashSet<String> nameSet = new LinkedHashSet<String>();
                        nameSet.addAll(Arrays.asList(alternateNames));
                        nameSet.addAll(Arrays.asList(fieldInfo.alternateNames));
                        fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
                        break;
                    }
                    case "ordinal": {
                        Integer ordinal = (Integer)result;
                        if (ordinal == 0) break;
                        fieldInfo.ordinal = ordinal;
                        break;
                    }
                    case "deserialize": {
                        Boolean serialize = (Boolean)result;
                        if (serialize.booleanValue()) break;
                        fieldInfo.ignore = true;
                        break;
                    }
                    case "parseFeatures": {
                        Enum[] features;
                        block34: for (Enum feature : features = (Enum[])result) {
                            switch (feature.name()) {
                                case "SupportAutoType": {
                                    fieldInfo.features |= JSONReader.Feature.SupportAutoType.mask;
                                    continue block34;
                                }
                                case "SupportArrayToBean": {
                                    fieldInfo.features |= JSONReader.Feature.SupportArrayToBean.mask;
                                    continue block34;
                                }
                                case "InitStringFieldAsEmpty": {
                                    fieldInfo.features |= JSONReader.Feature.InitStringFieldAsEmpty.mask;
                                    continue block34;
                                }
                            }
                        }
                        break;
                    }
                    case "deserializeUsing": {
                        Class deserializeUsing = (Class)result;
                        if (!ObjectReader.class.isAssignableFrom(deserializeUsing)) break;
                        fieldInfo.readUsing = deserializeUsing;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void getFieldInfo(FieldInfo fieldInfo, JSONField jsonField) {
        Class deserializeUsing;
        boolean value;
        String[] alternateNames;
        String[] parts;
        String locale;
        String defaultValue;
        String label;
        String jsonFieldFormat;
        if (jsonField == null) {
            return;
        }
        String jsonFieldName = jsonField.name();
        if (!jsonFieldName.isEmpty()) {
            fieldInfo.fieldName = jsonFieldName;
        }
        if (!(jsonFieldFormat = jsonField.format()).isEmpty()) {
            if ((jsonFieldFormat = jsonFieldFormat.trim()).indexOf(84) != -1 && !jsonFieldFormat.contains("'T'")) {
                jsonFieldFormat = jsonFieldFormat.replaceAll("T", "'T'");
            }
            fieldInfo.format = jsonFieldFormat;
        }
        if (!(label = jsonField.label()).isEmpty()) {
            fieldInfo.label = label = label.trim();
        }
        if (!(defaultValue = jsonField.defaultValue()).isEmpty()) {
            fieldInfo.defaultValue = defaultValue;
        }
        if (!(locale = jsonField.locale()).isEmpty() && (parts = locale.split("_")).length == 2) {
            fieldInfo.locale = new Locale(parts[0], parts[1]);
        }
        if ((alternateNames = jsonField.alternateNames()).length != 0) {
            if (fieldInfo.alternateNames == null) {
                fieldInfo.alternateNames = alternateNames;
            } else {
                LinkedHashSet nameSet = new LinkedHashSet();
                Collections.addAll(nameSet, alternateNames);
                nameSet.addAll(Arrays.asList(fieldInfo.alternateNames));
                fieldInfo.alternateNames = nameSet.toArray(new String[nameSet.size()]);
            }
        }
        if (!fieldInfo.ignore) {
            fieldInfo.ignore = !jsonField.deserialize();
        }
        for (JSONReader.Feature feature : jsonField.deserializeFeatures()) {
            fieldInfo.features |= feature.mask;
            if (!fieldInfo.ignore || feature != JSONReader.Feature.FieldBased) continue;
            fieldInfo.ignore = false;
        }
        int ordinal = jsonField.ordinal();
        if (ordinal != 0) {
            fieldInfo.ordinal = ordinal;
        }
        if (value = jsonField.value()) {
            fieldInfo.features |= 0x1000000000000L;
        }
        if (jsonField.unwrapped()) {
            fieldInfo.features |= 0x2000000000000L;
        }
        if (jsonField.required()) {
            fieldInfo.required = true;
        }
        if (ObjectReader.class.isAssignableFrom(deserializeUsing = jsonField.deserializeUsing())) {
            fieldInfo.readUsing = deserializeUsing;
        }
    }

    private void getBeanInfo1xJSONPOJOBuilder(BeanInfo beanInfo, Class<?> builderClass, Annotation builderAnnatation, Class<? extends Annotation> builderAnnatationClass) {
        BeanUtils.annotationMethods(builderAnnatationClass, method -> {
            try {
                String methodName;
                switch (methodName = method.getName()) {
                    case "buildMethod": {
                        String buildMethodName = (String)method.invoke((Object)builderAnnatation, new Object[0]);
                        beanInfo.buildMethod = BeanUtils.buildMethod(builderClass, buildMethodName);
                        break;
                    }
                    case "withPrefix": {
                        String withPrefix = (String)method.invoke((Object)builderAnnatation, new Object[0]);
                        if (withPrefix.isEmpty()) break;
                        beanInfo.builderWithPrefix = withPrefix;
                        break;
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        });
    }

    private void getCreator(BeanInfo beanInfo, Class<?> objectClass, Constructor constructor) {
        if (objectClass.isEnum()) {
            return;
        }
        Annotation[] annotations = constructor.getDeclaredAnnotations();
        boolean creatorMethod = false;
        for (Annotation annotation : annotations) {
            String annotationTypeName;
            Class<? extends Annotation> annotationType = annotation.annotationType();
            JSONCreator jsonCreator = BeanUtils.findAnnotation(annotation, JSONCreator.class);
            if (jsonCreator != null) {
                String[] createParameterNames = jsonCreator.parameterNames();
                if (createParameterNames.length != 0) {
                    beanInfo.createParameterNames = createParameterNames;
                }
                creatorMethod = true;
                if (jsonCreator == annotation) continue;
            }
            if (!(annotationTypeName = annotationType.getName()).equals("com.alibaba.fastjson.annotation.JSONCreator") && !annotationTypeName.equals("com.alibaba.fastjson2.annotation.JSONCreator")) continue;
            creatorMethod = true;
            BeanUtils.annotationMethods(annotationType, m1 -> {
                try {
                    switch (m1.getName()) {
                        case "parameterNames": {
                            String[] createParameterNames = (String[])m1.invoke((Object)annotation, new Object[0]);
                            if (createParameterNames.length == 0) break;
                            beanInfo.createParameterNames = createParameterNames;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        if (!creatorMethod) {
            return;
        }
        Constructor<?> targetConstructor = null;
        try {
            targetConstructor = objectClass.getDeclaredConstructor(constructor.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (targetConstructor != null) {
            beanInfo.creatorConstructor = targetConstructor;
        }
    }

    private void getCreator(BeanInfo beanInfo, Class<?> objectClass, Method method) {
        if (method.getDeclaringClass() == Enum.class) {
            return;
        }
        String methodName = method.getName();
        if (objectClass.isEnum() && methodName.equals("values")) {
            return;
        }
        Annotation[] annotations = method.getDeclaredAnnotations();
        boolean creatorMethod = false;
        JSONCreator jsonCreator = null;
        for (Annotation annotation : annotations) {
            Class<? extends Annotation> annotationType = annotation.annotationType();
            jsonCreator = BeanUtils.findAnnotation(annotation, JSONCreator.class);
            if (jsonCreator == annotation || !annotationType.getName().equals("com.alibaba.fastjson.annotation.JSONCreator")) continue;
            creatorMethod = true;
            BeanUtils.annotationMethods(annotationType, m1 -> {
                try {
                    switch (m1.getName()) {
                        case "parameterNames": {
                            String[] createParameterNames = (String[])m1.invoke((Object)annotation, new Object[0]);
                            if (createParameterNames.length == 0) break;
                            beanInfo.createParameterNames = createParameterNames;
                            break;
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            });
        }
        if (jsonCreator != null) {
            String[] createParameterNames = jsonCreator.parameterNames();
            if (createParameterNames.length != 0) {
                beanInfo.createParameterNames = createParameterNames;
            }
            creatorMethod = true;
        }
        if (!creatorMethod) {
            return;
        }
        Method targetMethod = null;
        try {
            targetMethod = objectClass.getDeclaredMethod(methodName, method.getParameterTypes());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (targetMethod != null) {
            beanInfo.createMethod = targetMethod;
        }
    }

    private ObjectReader getObjectReaderModule(Type type) {
        Type[] upperBounds;
        if (type == String.class || type == CharSequence.class) {
            return ObjectReaderImplString.INSTANCE;
        }
        if (type == Character.TYPE || type == Character.class) {
            return ObjectReaderImplCharacter.INSTANCE;
        }
        if (type == Boolean.TYPE || type == Boolean.class) {
            return ObjectReaderImplBoolean.INSTANCE;
        }
        if (type == Byte.TYPE || type == Byte.class) {
            return ObjectReaderImplByte.INSTANCE;
        }
        if (type == Short.TYPE || type == Short.class) {
            return ObjectReaderImplShort.INSTANCE;
        }
        if (type == Integer.TYPE || type == Integer.class) {
            return ObjectReaderImplInteger.INSTANCE;
        }
        if (type == Long.TYPE || type == Long.class) {
            return ObjectReaderImplInt64.INSTANCE;
        }
        if (type == Float.TYPE || type == Float.class) {
            return ObjectReaderImplFloat.INSTANCE;
        }
        if (type == Double.TYPE || type == Double.class) {
            return ObjectReaderImplDouble.INSTANCE;
        }
        if (type == BigInteger.class) {
            return ObjectReaderImplBigInteger.INSTANCE;
        }
        if (type == BigDecimal.class) {
            return ObjectReaderImplBigDecimal.INSTANCE;
        }
        if (type == Number.class) {
            return ObjectReaderImplNumber.INSTANCE;
        }
        if (type == UUID.class) {
            return ObjectReaderImplUUID.INSTANCE;
        }
        if (type == AtomicBoolean.class) {
            return new ObjectReaderImplFromBoolean<AtomicBoolean>(AtomicBoolean.class, AtomicBoolean::new);
        }
        if (type == URI.class) {
            return new ObjectReaderImplFromString<URI>(URI.class, URI::create);
        }
        if (type == Charset.class) {
            return new ObjectReaderImplFromString<Charset>(Charset.class, e -> Charset.forName(e));
        }
        if (type == File.class) {
            return new ObjectReaderImplFromString<File>(File.class, e -> new File((String)e));
        }
        if (type == URL.class) {
            return new ObjectReaderImplFromString<URL>(URL.class, e -> {
                try {
                    return new URL((String)e);
                }
                catch (MalformedURLException ex) {
                    throw new JSONException("read URL error", ex);
                }
            });
        }
        if (type == Pattern.class) {
            return new ObjectReaderImplFromString<Pattern>(Pattern.class, Pattern::compile);
        }
        if (type == SimpleDateFormat.class) {
            return new ObjectReaderImplFromString<SimpleDateFormat>(SimpleDateFormat.class, SimpleDateFormat::new);
        }
        if (type == Class.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        if (type == Method.class) {
            return new ObjectReaderImplMethod();
        }
        if (type == Field.class) {
            return new ObjectReaderImplField();
        }
        if (type == Type.class) {
            return ObjectReaderImplClass.INSTANCE;
        }
        String typeName = type instanceof Class ? ((Class)type).getName() : "";
        if (type == Map.class || type == AbstractMap.class) {
            return ObjectReaderImplMap.of(null, (Class)type, 0L);
        }
        if (type == ConcurrentMap.class || type == ConcurrentHashMap.class) {
            return ObjectReaderProvider.typedMap((Class)type, ConcurrentHashMap.class, null, Object.class);
        }
        if (type == ConcurrentNavigableMap.class || type == ConcurrentSkipListMap.class) {
            return ObjectReaderProvider.typedMap((Class)type, ConcurrentSkipListMap.class, null, Object.class);
        }
        if (type == SortedMap.class || type == NavigableMap.class || type == TreeMap.class) {
            return ObjectReaderProvider.typedMap((Class)type, TreeMap.class, null, Object.class);
        }
        if (type == Calendar.class) {
            return ObjectReaderImplCalendar.INSTANCE;
        }
        if (type == Date.class) {
            return ObjectReaderImplDate.INSTANCE;
        }
        if (type == Locale.class) {
            return ObjectReaderImplLocale.INSTANCE;
        }
        if (type == Currency.class) {
            return ObjectReaderImplCurrency.INSTANCE;
        }
        if (type == ZoneId.class) {
            return new ObjectReaderImplFromString<ZoneId>(ZoneId.class, e -> ZoneId.of(e));
        }
        if (type == TimeZone.class) {
            return new ObjectReaderImplFromString<TimeZone>(TimeZone.class, e -> TimeZone.getTimeZone(e));
        }
        if (type == char[].class) {
            return ObjectReaderImplCharValueArray.INSTANCE;
        }
        if (type == float[].class) {
            return ObjectReaderImplFloatValueArray.INSTANCE;
        }
        if (type == double[].class) {
            return ObjectReaderImplDoubleValueArray.INSTANCE;
        }
        if (type == boolean[].class) {
            return ObjectReaderImplBoolValueArray.INSTANCE;
        }
        if (type == byte[].class) {
            return ObjectReaderImplInt8ValueArray.INSTANCE;
        }
        if (type == short[].class) {
            return ObjectReaderImplInt16ValueArray.INSTANCE;
        }
        if (type == int[].class) {
            return ObjectReaderImplInt32ValueArray.INSTANCE;
        }
        if (type == long[].class) {
            return ObjectReaderImplInt64ValueArray.INSTANCE;
        }
        if (type == Byte[].class) {
            return ObjectReaderImplInt8Array.INSTANCE;
        }
        if (type == Short[].class) {
            return ObjectReaderImplInt16Array.INSTANCE;
        }
        if (type == Integer[].class) {
            return ObjectReaderImplInt32Array.INSTANCE;
        }
        if (type == Long[].class) {
            return ObjectReaderImplInt64Array.INSTANCE;
        }
        if (type == Float[].class) {
            return ObjectReaderImplFloatArray.INSTANCE;
        }
        if (type == Double[].class) {
            return ObjectReaderImplDoubleArray.INSTANCE;
        }
        if (type == Number[].class) {
            return ObjectReaderImplNumberArray.INSTANCE;
        }
        if (type == String[].class) {
            return ObjectReaderImplStringArray.INSTANCE;
        }
        if (type == AtomicInteger.class) {
            return new ObjectReaderImplFromInt<AtomicInteger>(AtomicInteger.class, AtomicInteger::new);
        }
        if (type == AtomicLong.class) {
            return new ObjectReaderImplFromLong<AtomicLong>(AtomicLong.class, AtomicLong::new);
        }
        if (type == AtomicIntegerArray.class) {
            return new ObjectReaderImplInt32ValueArray(AtomicIntegerArray.class, AtomicIntegerArray::new);
        }
        if (type == AtomicLongArray.class) {
            return new ObjectReaderImplInt64ValueArray(AtomicLongArray.class, AtomicLongArray::new);
        }
        if (type == AtomicReference.class) {
            return ObjectReaderImplAtomicReference.INSTANCE;
        }
        if (type instanceof MultiType) {
            return new ObjectArrayReaderMultiType((MultiType)type);
        }
        if (type instanceof MapMultiValueType) {
            return new ObjectReaderImplMapMultiValueType((MapMultiValueType)type);
        }
        if (type == StringBuffer.class || type == StringBuilder.class) {
            try {
                Class objectClass = (Class)type;
                return new ObjectReaderImplValue(objectClass, (Type)((Object)String.class), String.class, 0L, null, null, objectClass.getConstructor(String.class), null, null);
            }
            catch (NoSuchMethodException e2) {
                throw new RuntimeException(e2);
            }
        }
        if (type == Iterable.class || type == Collection.class || type == List.class || type == AbstractCollection.class || type == AbstractList.class || type == ArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Queue.class || type == Deque.class || type == AbstractSequentialList.class || type == LinkedList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Set.class || type == AbstractSet.class || type == EnumSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == NavigableSet.class || type == SortedSet.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ConcurrentLinkedQueue.class || type == ConcurrentSkipListSet.class || type == LinkedHashSet.class || type == HashSet.class || type == TreeSet.class || type == CopyOnWriteArrayList.class) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == ObjectReaderImplList.CLASS_EMPTY_SET || type == ObjectReaderImplList.CLASS_EMPTY_LIST || type == ObjectReaderImplList.CLASS_SINGLETON || type == ObjectReaderImplList.CLASS_SINGLETON_LIST || type == ObjectReaderImplList.CLASS_ARRAYS_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_COLLECTION || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_LIST || type == ObjectReaderImplList.CLASS_UNMODIFIABLE_SET) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == TypeUtils.CLASS_SINGLE_SET) {
            return ObjectReaderImplList.of(type, null, 0L);
        }
        if (type == Object.class || type == Cloneable.class || type == Closeable.class || type == Serializable.class || type == Comparable.class) {
            return ObjectReaderImplObject.INSTANCE;
        }
        if (type == Map.Entry.class) {
            return new ObjectReaderImplMapEntry(null, null);
        }
        if (type instanceof Class) {
            Class objectClass = (Class)type;
            if (Map.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplMap.of(null, objectClass, 0L);
            }
            if (Collection.class.isAssignableFrom(objectClass)) {
                return ObjectReaderImplList.of(objectClass, objectClass, 0L);
            }
            if (objectClass.isArray()) {
                Class<?> componentType = objectClass.getComponentType();
                if (componentType == Object.class) {
                    return ObjectArrayReader.INSTANCE;
                }
                return new ObjectArrayTypedReader(objectClass);
            }
            ObjectReaderCreator creator = JSONFactory.defaultObjectReaderProvider.creator;
            if (objectClass == StackTraceElement.class) {
                try {
                    Constructor constructor = objectClass.getConstructor(String.class, String.class, String.class, Integer.TYPE);
                    return creator.createObjectReaderNoneDefaultConstructor(constructor, "className", "methodName", "fileName", "lineNumber");
                }
                catch (Throwable constructor) {
                    // empty catch block
                }
            }
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type rawType = parameterizedType.getRawType();
            Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
            if (actualTypeArguments.length == 2) {
                Type actualTypeParam0 = actualTypeArguments[0];
                Type actualTypeParam1 = actualTypeArguments[1];
                if (rawType == Map.class || rawType == AbstractMap.class || rawType == HashMap.class) {
                    return ObjectReaderProvider.typedMap((Class)rawType, HashMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == ConcurrentMap.class || rawType == ConcurrentHashMap.class) {
                    return ObjectReaderProvider.typedMap((Class)rawType, ConcurrentHashMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == ConcurrentNavigableMap.class || rawType == ConcurrentSkipListMap.class) {
                    return ObjectReaderProvider.typedMap((Class)rawType, ConcurrentSkipListMap.class, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == LinkedHashMap.class || rawType == TreeMap.class || rawType == EnumMap.class) {
                    return ObjectReaderProvider.typedMap((Class)rawType, (Class)rawType, actualTypeParam0, actualTypeParam1);
                }
                if (rawType == Map.Entry.class) {
                    return new ObjectReaderImplMapEntry(actualTypeArguments[0], actualTypeArguments[1]);
                }
            }
            if (actualTypeArguments.length == 1) {
                Type itemType = actualTypeArguments[0];
                Class<?> itemClass = TypeUtils.getMapping(itemType);
                if (rawType == Iterable.class || rawType == Collection.class || rawType == List.class || rawType == AbstractCollection.class || rawType == AbstractList.class || rawType == ArrayList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, ArrayList.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, ArrayList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Queue.class || rawType == Deque.class || rawType == AbstractSequentialList.class || rawType == LinkedList.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, LinkedList.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, LinkedList.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == Set.class || rawType == AbstractSet.class || rawType == EnumSet.class) {
                    if (itemClass == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, HashSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, HashSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == NavigableSet.class || rawType == SortedSet.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, TreeSet.class);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, TreeSet.class);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == ConcurrentLinkedQueue.class || rawType == ConcurrentSkipListSet.class || rawType == LinkedHashSet.class || rawType == HashSet.class || rawType == TreeSet.class || rawType == CopyOnWriteArrayList.class) {
                    if (itemType == String.class) {
                        return new ObjectReaderImplListStr((Class)rawType, (Class)rawType);
                    }
                    if (itemClass == Long.class) {
                        return new ObjectReaderImplListInt64((Class)rawType, (Class)rawType);
                    }
                    return ObjectReaderImplList.of(type, null, 0L);
                }
                if (rawType == AtomicReference.class) {
                    return new ObjectReaderImplAtomicReference(itemType);
                }
                if (itemType instanceof WildcardType) {
                    return this.getObjectReaderModule(rawType);
                }
            }
            return null;
        }
        if (type instanceof GenericArrayType) {
            return new ObjectReaderImplGenericArray((GenericArrayType)type);
        }
        if (type instanceof WildcardType && (upperBounds = ((WildcardType)type).getUpperBounds()).length == 1) {
            return this.getObjectReaderModule(upperBounds[0]);
        }
        if (type == ParameterizedType.class) {
            return ObjectReaders.ofReflect(ParameterizedTypeImpl.class);
        }
        switch (typeName) {
            case "java.sql.Time": {
                return new JdbcSupport.TimeReader(null, null);
            }
            case "java.sql.Timestamp": {
                return new JdbcSupport.TimestampReader(null, null);
            }
            case "java.sql.Date": {
                return new JdbcSupport.DateReader(null, null);
            }
            case "java.util.RegularEnumSet": 
            case "java.util.JumboEnumSet": {
                return ObjectReaderImplList.of(type, TypeUtils.getClass(type), 0L);
            }
            case "java.net.InetSocketAddress": {
                return new ObjectReaderMisc((Class)type);
            }
            case "java.net.InetAddress": {
                return ObjectReaderImplValue.of((Class)type, String.class, address -> {
                    try {
                        return InetAddress.getByName(address);
                    }
                    catch (UnknownHostException e) {
                        throw new JSONException("create address error", e);
                    }
                });
            }
            case "java.text.SimpleDateFormat": {
                return ObjectReaderImplValue.of((Class)type, String.class, SimpleDateFormat::new);
            }
        }
        return null;
    }

    public static ObjectReader typedMap(Class mapType, Class instanceType, Type keyType, Type valueType) {
        if ((keyType == null || keyType == String.class) && valueType == String.class) {
            return new ObjectReaderImplMapString(mapType, instanceType, 0L);
        }
        return new ObjectReaderImplMapTyped(mapType, instanceType, keyType, valueType, 0L, null);
    }

    static final class LRUAutoTypeCache
    extends LinkedHashMap<String, Date> {
        private final int maxSize;

        public LRUAutoTypeCache(int maxSize) {
            super(16, 0.75f, false);
            this.maxSize = maxSize;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Date> eldest) {
            return this.size() > this.maxSize;
        }
    }

    static class ObjectReaderCachePair {
        final long hashCode;
        final ObjectReader reader;
        volatile int missCount;

        public ObjectReaderCachePair(long hashCode, ObjectReader reader) {
            this.hashCode = hashCode;
            this.reader = reader;
        }
    }
}

