/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.util.Fnv;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;

final class FactoryFunction<T>
implements Function<Map<Long, Object>, T> {
    final Method factoryMethod;
    final Function function;
    final BiFunction biFunction;
    final String[] paramNames;
    final long[] hashCodes;

    FactoryFunction(Method factoryMethod, String ... paramNames) {
        this.factoryMethod = factoryMethod;
        Class<?>[] parameters = factoryMethod.getParameterTypes();
        this.paramNames = new String[parameters.length];
        this.hashCodes = new long[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            String name = null;
            if (i < paramNames.length) {
                name = paramNames[i];
            }
            if (name == null) {
                name = "arg" + i;
            }
            paramNames[i] = name;
            this.hashCodes[i] = Fnv.hashCode64(name);
        }
        this.function = null;
        this.biFunction = null;
    }

    @Override
    public T apply(Map<Long, Object> values) {
        if (this.function != null) {
            Object arg = values.get(this.hashCodes[0]);
            return (T)this.function.apply(arg);
        }
        if (this.biFunction != null) {
            Object arg0 = values.get(this.hashCodes[0]);
            Object arg1 = values.get(this.hashCodes[1]);
            return (T)this.biFunction.apply(arg0, arg1);
        }
        Object[] args = new Object[this.hashCodes.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = values.get(this.hashCodes[i]);
        }
        try {
            return (T)this.factoryMethod.invoke(null, args);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            throw new JSONException("invoke factoryMethod error", e);
        }
    }
}

