/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.util.JDKUtils;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;

final class FieldReaderBoolValueField<T>
extends FieldReader<T> {
    FieldReaderBoolValueField(String fieldName, int ordinal, long features, String format, Boolean defaultValue, Field field) {
        super(fieldName, Boolean.TYPE, Boolean.TYPE, ordinal, features, format, null, defaultValue, null, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        boolean fieldValue = jsonReader.readBoolValue();
        try {
            this.field.setBoolean(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public void accept(T object, int value) {
        this.accept(object, TypeUtils.toBooleanValue(value));
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            if ((this.features & JSONReader.Feature.IgnoreSetNullValue.mask) != 0L) {
                return;
            }
            this.accept(object, false);
            return;
        }
        if (value instanceof Boolean) {
            this.accept(object, (Boolean)value);
            return;
        }
        throw new JSONException("set " + this.fieldName + " error, type not support " + value.getClass());
    }

    @Override
    public void accept(T object, boolean value) {
        if (this.fieldOffset != -1L) {
            JDKUtils.UNSAFE.putBoolean(object, this.fieldOffset, value);
            return;
        }
        try {
            this.field.setBoolean(object, value);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readBoolValue();
    }
}

