/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import java.lang.reflect.Field;

final class FieldReaderCharValueField<T>
extends FieldReader<T> {
    FieldReaderCharValueField(String fieldName, int ordinal, long features, String format, Character defaultValue, Field field) {
        super(fieldName, Character.TYPE, Character.TYPE, ordinal, features, format, null, defaultValue, null, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        char ch = jsonReader.readCharValue();
        if (ch == '\u0000' && jsonReader.wasNull()) {
            return;
        }
        this.accept(object, ch);
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return Character.valueOf(jsonReader.readCharValue());
    }

    @Override
    public void accept(T object, Object value) {
        char charValue;
        if (value instanceof String) {
            charValue = ((String)value).charAt(0);
        } else if (value instanceof Character) {
            charValue = ((Character)value).charValue();
        } else {
            throw new JSONException("cast to char error");
        }
        try {
            this.field.set(object, Character.valueOf(charValue));
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

