/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.util.TypeUtils;
import java.lang.reflect.Field;

final class FieldReaderInt64Field<T>
extends FieldReader<T> {
    FieldReaderInt64Field(String fieldName, Class fieldType, int ordinal, long features, String format, Long defaultValue, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, null, defaultValue, null, field);
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        Long fieldValue = jsonReader.readInt64();
        try {
            this.field.set(object, fieldValue);
        }
        catch (Exception e) {
            throw new JSONException(jsonReader.info("set " + this.fieldName + " error"), e);
        }
    }

    @Override
    public Object readFieldValue(JSONReader jsonReader) {
        return jsonReader.readInt64();
    }

    @Override
    public void accept(T object, float value) {
        this.accept(object, (Object)((long)value));
    }

    @Override
    public void accept(T object, double value) {
        this.accept(object, (Object)((long)value));
    }

    @Override
    public void accept(T object, Object value) {
        Long longValue = TypeUtils.toLong(value);
        try {
            this.field.set(object, longValue);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error", e);
        }
    }
}

