/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.reader.FieldReader;
import com.alibaba.fastjson2.util.JDKUtils;
import java.lang.reflect.Field;

final class FieldReaderStringField<T>
extends FieldReader<T> {
    final boolean trim;
    final boolean emptyToNull;
    final long fieldOffset;

    FieldReaderStringField(String fieldName, Class fieldType, int ordinal, long features, String format, String defaultValue, Field field) {
        super(fieldName, fieldType, fieldType, ordinal, features, format, null, defaultValue, null, field);
        this.trim = "trim".equals(format) || (features & JSONReader.Feature.TrimString.mask) != 0L;
        this.fieldOffset = JDKUtils.UNSAFE.objectFieldOffset(field);
        this.emptyToNull = (features & JSONReader.Feature.EmptyStringAsNull.mask) != 0L;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        String fieldValue = jsonReader.readString();
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        JDKUtils.UNSAFE.putObject(object, this.fieldOffset, fieldValue);
    }

    @Override
    public void readFieldValueJSONB(JSONReader jsonReader, T object) {
        String fieldValue = jsonReader.readString();
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        if (this.emptyToNull && fieldValue != null && fieldValue.isEmpty()) {
            fieldValue = null;
        }
        this.accept(object, fieldValue);
    }

    @Override
    public String readFieldValue(JSONReader jsonReader) {
        String fieldValue = jsonReader.readString();
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        if (this.emptyToNull && fieldValue != null && fieldValue.isEmpty()) {
            fieldValue = null;
        }
        return fieldValue;
    }

    @Override
    public boolean supportAcceptType(Class valueClass) {
        return true;
    }

    @Override
    public void accept(T object, Object value) {
        String fieldValue = value != null && !(value instanceof String) ? value.toString() : (String)value;
        if (this.trim && fieldValue != null) {
            fieldValue = fieldValue.trim();
        }
        JDKUtils.UNSAFE.putObject(object, this.fieldOffset, fieldValue);
    }
}

