/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.time;

import com.alibaba.fastjson2.time.DateTimeException;
import com.alibaba.fastjson2.util.IOUtils;
import java.sql.Timestamp;
import java.util.Date;

public final class Instant {
    static final Instant EPOCH = new Instant(0L, 0);
    public final long epochSecond;
    public final int nanos;

    public static Instant ofEpochMilli(long epochMilli) {
        long secs = IOUtils.floorDiv(epochMilli, 1000L);
        int mos = (int)IOUtils.floorMod(epochMilli, 1000L);
        return Instant.create(secs, mos * 1000000);
    }

    public static Instant of(Date date) {
        return Instant.ofEpochMilli(date.getTime());
    }

    public static Instant of(Timestamp date) {
        long millis = date.getTime();
        long second = millis / 1000L;
        return Instant.ofEpochSecond(second, date.getNanos());
    }

    public static Instant ofEpochSecond(long epochSecond, long nanoAdjustment) {
        long secs = IOUtils.addExact(epochSecond, IOUtils.floorDiv(nanoAdjustment, 1000000000L));
        int nos = (int)IOUtils.floorMod(nanoAdjustment, 1000000000L);
        return Instant.create(secs, nos);
    }

    private Instant(long epochSecond, int nanos) {
        this.epochSecond = epochSecond;
        this.nanos = nanos;
    }

    private static Instant create(long seconds, int nanoOfSecond) {
        if ((seconds | (long)nanoOfSecond) == 0L) {
            return EPOCH;
        }
        long MIN_SECOND = -31557014167219200L;
        long MAX_SECOND = 31556889864403199L;
        if (seconds < -31557014167219200L || seconds > 31556889864403199L) {
            throw new DateTimeException("Instant exceeds minimum or maximum instant");
        }
        return new Instant(seconds, nanoOfSecond);
    }

    public long toEpochMilli() {
        if (this.epochSecond < 0L && this.nanos > 0) {
            long millis = IOUtils.multiplyExact(this.epochSecond + 1L, 1000L);
            long adjustment = this.nanos / 1000000 - 1000;
            return IOUtils.addExact(millis, adjustment);
        }
        long millis = IOUtils.multiplyExact(this.epochSecond, 1000L);
        return IOUtils.addExact(millis, this.nanos / 1000000);
    }

    public Timestamp toTimestamp() {
        Timestamp ts = new Timestamp(this.toEpochMilli());
        ts.setNanos(this.nanos);
        return ts;
    }

    public Date toDate() {
        return new Date(this.toEpochMilli());
    }

    public String toString() {
        return "Instant(" + this.epochSecond + ", " + this.nanos + ")";
    }
}

