/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.reader;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.function.BiConsumer;
import com.alibaba.fastjson2.reader.FieldReaderMapMethod;
import com.alibaba.fastjson2.reader.ObjectReader;
import com.alibaba.fastjson2.reader.ObjectReaderImplMap;
import com.alibaba.fastjson2.reader.ObjectReaderImplMapTyped;
import com.alibaba.fastjson2.reader.ObjectReaderImplObject;
import com.alibaba.fastjson2.reader.ObjectReaderImplString;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

class FieldReaderMapMethodReadOnly<T>
extends FieldReaderMapMethod<T> {
    FieldReaderMapMethodReadOnly(String fieldName, Type fieldType, Class fieldClass, int ordinal, long features, String format, Method method, Field field, String arrayToMapKey, BiConsumer arrayToMapDuplicateHandler) {
        super(fieldName, fieldType, fieldClass, ordinal, features, format, null, null, method, field, null, arrayToMapKey, arrayToMapDuplicateHandler);
    }

    @Override
    public ObjectReader getItemObjectReader(JSONReader jsonReader) {
        if (this.itemReader != null) {
            return this.itemReader;
        }
        ObjectReader objectReader = this.getObjectReader(jsonReader);
        if (objectReader instanceof ObjectReaderImplMap) {
            this.itemReader = ObjectReaderImplString.INSTANCE;
            return this.itemReader;
        }
        if (objectReader instanceof ObjectReaderImplMapTyped) {
            Type valueType = ((ObjectReaderImplMapTyped)objectReader).valueType;
            this.itemReader = jsonReader.getObjectReader(valueType);
            return this.itemReader;
        }
        return ObjectReaderImplObject.INSTANCE;
    }

    @Override
    public void accept(T object, Object value) {
        if (value == null) {
            return;
        }
        Map map = this.getReadOnlyMap(object);
        if (map == Collections.EMPTY_MAP || map == null) {
            return;
        }
        String name = map.getClass().getName();
        if ("java.util.Collections$UnmodifiableMap".equals(name)) {
            return;
        }
        map.putAll((Map)value);
    }

    @Override
    public void processExtra(JSONReader jsonReader, Object object) {
        String name = jsonReader.getFieldName();
        ObjectReader itemObjectReader = this.getItemObjectReader(jsonReader);
        Object value = itemObjectReader.readObject(jsonReader, this.getItemType(), this.fieldName, 0L);
        this.getReadOnlyMap(object).put(name, value);
    }

    @Override
    public void acceptExtra(Object object, String name, Object value) {
        this.getReadOnlyMap(object).put(name, value);
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public void readFieldValue(JSONReader jsonReader, T object) {
        if (this.arrayToMapKey != null && jsonReader.isArray()) {
            Map map = this.getReadOnlyMap(object);
            List array = jsonReader.readArray(this.valueType);
            FieldReaderMapMethodReadOnly.arrayToMap(map, array, this.arrayToMapKey, JSONFactory.getObjectReader(this.valueType, this.features | this.features), this.arrayToMapDuplicateHandler);
            return;
        }
        if (this.initReader == null) {
            this.initReader = jsonReader.getContext().getObjectReader(this.fieldType);
        }
        Object value = jsonReader.jsonb ? this.initReader.readJSONBObject(jsonReader, this.getItemType(), this.fieldName, this.features) : this.initReader.readObject(jsonReader, this.getItemType(), this.fieldName, this.features);
        this.accept(object, value);
    }

    @Override
    protected void acceptAny(T object, Object fieldValue, long features) {
        if (this.arrayToMapKey != null && fieldValue instanceof Collection) {
            Map map = this.getReadOnlyMap(object);
            FieldReaderMapMethodReadOnly.arrayToMap(map, (Collection)fieldValue, this.arrayToMapKey, JSONFactory.getObjectReader(this.valueType, this.features | features), this.arrayToMapDuplicateHandler);
            return;
        }
        super.acceptAny(object, fieldValue, features);
    }

    private Map getReadOnlyMap(Object object) {
        Map map;
        try {
            map = (Map)this.method.invoke(object, new Object[0]);
        }
        catch (Exception e) {
            throw new JSONException("set " + this.fieldName + " error");
        }
        return map;
    }
}

