/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.writer;

import com.alibaba.fastjson2.JSONB;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.util.Fnv;
import com.alibaba.fastjson2.writer.ObjectWriterPrimitiveImpl;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.util.function.Function;

final class ObjectWriterImplFloatValueArray
extends ObjectWriterPrimitiveImpl {
    static final ObjectWriterImplFloatValueArray INSTANCE = new ObjectWriterImplFloatValueArray(null, null);
    static final byte[] JSONB_TYPE_NAME_BYTES = JSONB.toBytes("[F");
    static final long JSONB_TYPE_HASH = Fnv.hashCode64("[F");
    private final DecimalFormat format;
    private final Function<Object, float[]> function;

    public ObjectWriterImplFloatValueArray(DecimalFormat format) {
        this.format = format;
        this.function = null;
    }

    public ObjectWriterImplFloatValueArray(Function<Object, float[]> function, DecimalFormat format) {
        this.function = function;
        this.format = format;
    }

    @Override
    public void writeJSONB(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        if (jsonWriter.isWriteTypeInfo(object, fieldType)) {
            jsonWriter.writeTypeName(JSONB_TYPE_NAME_BYTES, JSONB_TYPE_HASH);
        }
        float[] array = this.function != null && object != null ? this.function.apply(object) : (float[])object;
        if ((features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
            jsonWriter.writeString(array);
        } else {
            jsonWriter.writeFloat(array);
        }
    }

    @Override
    public void write(JSONWriter jsonWriter, Object object, Object fieldName, Type fieldType, long features) {
        float[] array = this.function != null && object != null ? this.function.apply(object) : (float[])object;
        if (this.format == null) {
            if ((features & JSONWriter.Feature.WriteNonStringValueAsString.mask) != 0L) {
                jsonWriter.writeString(array);
            } else {
                jsonWriter.writeFloat(array);
            }
        } else {
            jsonWriter.writeFloat(array, this.format);
        }
    }
}

